/**
 * 侧边工具栏模块
 * User: yuwang@iflytek.com
 * Date: 13-7-10 上午9:43
 * Version: 1.0
 */

define(function (require, exports) {

    require('jquery');
    var _define = require('../../define');
    var ebookContext = require('../../ebookcontext').Instance;
    var _pageNavigatorHelper = require('../../../common/pagenavigatorhelper');
    var navigatorMenu = require('../navigator');
    var _model = require('../../model');
    var _shellcmd = require('../../../common/shellcmd');
    var monitorInfo = require('../../../common/MonitorInfo').Instance;

    var ibWSLogic = require('../../../ibWSLogic');

    var localres = require('./localres').Instance;
    // var mainToolbar=require('./maintoolbar');
    var pluginsMgr=require('../../plugins/pluginsmgr').Instance;
    var _ktsl = require('./ktsl');

    /** @type {number} 页面单次放大比例 */
    var ZOOM_IN_RATE = 1.2;

    /** @type {number} 页面单词缩小比例 */
    var ZOOM_OUT_RATE = 1 / ZOOM_IN_RATE;

    var _bookContainer;
    var _canvasManager;
    var _confirmExit;
    var _switchPageViewImgs;
    var _switchPageViewAs;
    var _btns;
    var isEditing = false;
    var sideBarisWB;
    var _curBookViewType = null;
    var _switchDevicePenFunction = 0; //用于电子教鞭的上下翻动和左右翻页切换标识-JJ

    /**
     *
     * @param {{
     *    btnLeftSwitchPageView:jQuery,
     *    btnRightSwitchPageView:jQuery,
     *
     *    btnLeftPrePage: jQuery,
     *    btnLeftNextPage: jQuery,
     *    btnRightPrePage: jQuery,
     *    btnRightNextPage: jQuery,
     *
     *    btnZoomIn: jQuery,
     *    btnZoomOut: jQuery
     * }} btns 工具栏按钮集合
     * @param {BookContainer} bookContainer
     * @param {PaintCanvas}  canvasMgr
     */
    function init(btns, bookContainer, canvasMgr, confirmExit, blackBoard) {
        _bookContainer = bookContainer;
        _canvasManager = canvasMgr;
        _btns = btns;
        _confirmExit = confirmExit;
        var leftToolBar = $("#leftToolbar"), rightToolBar = $("#rightToolbar"), systemBar = $(".btn_system");
        var btnMoveMenu = $("#btnMoveMenuBar");

        //如果是800*600分辨率，直接隐藏文字
        if( Config.Height < 670 ){
            // rightToolBar.find("a").hide(),leftToolBar.find("a").hide();
            // rightToolBar.find("dd").css("height","35px"),leftToolBar.find("dd").css("height","35px");
            // leftToolBar.css("marginTop","-100px"),rightToolBar.css("marginTop","-100px");
            // systemBar.css("bottom",0).css("top","420px");
            // btnMoveMenu.css("bottom",0);
        }
        else if( 670 < Config.Height && Config.Height < 800 ){
            // btnMoveMenu.css("bottom",0);
            // systemBar.css("bottom","20px");
            // leftToolBar.css("marginTop","-60px"),rightToolBar.css("marginTop","-60px");
        }


        setIsWhiteBoard(false);

        _switchPageViewImgs = btns.btnLeftSwitchPageView.find('img');
        $.merge(_switchPageViewImgs, btns.btnRightSwitchPageView.find('img'));
        btns.btnLeftSwitchPageView.click(switchPageView);
        btns.btnRightSwitchPageView.click(switchPageView);

        //给本地资源管理按钮绑定事件
//        btns.btnLocalResMgr.click(showLocalRes);
//        localres.init(btns.btnLocalResMgr,bookContainer);


        _switchPageViewAs = btns.btnLeftSwitchPageView.find("p[name=pageview_text]");
        $.merge(_switchPageViewAs, btns.btnRightSwitchPageView.find('p[name=pageview_text]'));

            // 初始化翻页按钮
        initChangePageButtons(btns.btnLeftPrePage, btns.btnLeftNextPage, btns.btnRightPrePage, btns.btnRightNextPage);

        // 初始化页面缩放按钮
        initZoomPageButtons(btns.btnZoomIn, btns.btnZoomOut);

        //初始化书架按钮
        initBookShelfButton(btns.btnBookShelf);

        // 左侧工具栏已经脱离到课本外，这里缩放和样式禁用 --by xinfang3
        // var matrixTransform = correctToBaseResolution(leftToolBar, {scaleFromCenter: false});
        // matrixTransform[5] = 0;
        // leftToolBar.css({'width': leftToolBar.outerWidth() * matrixTransform[0], '-webkit-transform': 'matrix(' + matrixTransform.join(',') + ')'});
        //
        // matrixTransform = correctToBaseResolution(rightToolBar, {scaleFromCenter: false});
        // matrixTransform[5] = 0;
        // rightToolBar.css({'width': rightToolBar.outerWidth() * matrixTransform[0], '-webkit-transform': 'matrix(' + matrixTransform.join(',') + ')'});
        //
        // matrixTransform = correctToBaseResolution(systemBar, {scaleFromCenter: false});
        // matrixTransform[4] = -matrixTransform[4];
        // matrixTransform[5] = -matrixTransform[5];
        // systemBar.css('-webkit-transform', 'matrix(' + matrixTransform.join(',') + ')');

        ebookContext.getUser().checkSingleLogin(_pageNavigatorHelper);
    }

    /**
     * 切换书本视图
     */
    function switchPageView() {
        var pageViewType = _bookContainer.getPageViewType();
        // 根据当前视图类别决定如何切换
        if (pageViewType === _define.PageViewType.TurnJsDoublePage) {
            _bookContainer.switchPageView(_define.PageViewType.SimpleSinglePage);
        } else if (pageViewType === _define.PageViewType.SimpleDoublePage) {
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:ebookContext._curUser._uid,
                module:'03007',
                type:'trigger',
                havingClass:_isHavingClass?1:0
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            _bookContainer.switchPageView(_define.PageViewType.SimpleSinglePage);
        } else if (pageViewType === _define.PageViewType.SimpleSinglePage) {
            if (AppCfg.useTurnJSDoublePage) {
                _bookContainer.switchPageView(_define.PageViewType.TurnJsDoublePage);
            } else {
                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:ebookContext._curUser._uid,
                    module:'03008',
                    type:'trigger',
                    havingClass:_isHavingClass?1:0
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
                _bookContainer.switchPageView(_define.PageViewType.SimpleDoublePage);
            }
        } else {
            console.error('sidetoolbar::switchPageView, unknown pageViewType:%s', pageViewType);
        }

        var isSinglePageView = pageViewType == _define.PageViewType.SimpleSinglePage;
        _switchPageViewImgs.attr('src', isSinglePageView ? 'assert/images/tool_single.png' : 'assert/images/tool_split-screen.png');
        _switchPageViewAs.text( isSinglePageView ? '单页' :'双页');
        $(_bookContainer).bind('bookViewChanged', IsDisabledNextPrePage);
        setTimeout(" $('#btnMouse').click()",100);
        //监管
        var action = LogManager.action.trigger;
        var params = {};
        params.module = '1130202';
        var user_id = ebookContext.getUser().getUid();
        if(user_id != '0' && user_id){
            params.user_id =user_id;
        }
        LogManager.statistics(action,params);
    }



    /**
     * 初始化翻页按钮
     */
    function initChangePageButtons(btnLeftPrePage, btnLeftNextPage, btnRightPrePage, btnRightNextPage) {
        // 给页面上的上一页、下一页按钮绑定点击事件
        $(".user-popover").hide();
        $("#smartbar_pop").remove();
        var previousPageImgs = $.merge(btnLeftPrePage, btnRightPrePage);

        previousPageImgs.click(function (event) {
            var isPenUse=ebookContext.getIsPenUse();
            if(isPenUse) {
               //如果使用了画笔，则后台调用快照截屏
               //  pluginsMgr.openSnapshot(true);

            }

            _bookContainer.previousPage();
            ebookContext.setIsPenUse(false);//翻页后设置画笔状态为未使用
            event.stopPropagation();

            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130204';
            var user_id = ebookContext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);
        });

        var nextPageImgs = $.merge(btnLeftNextPage, btnRightNextPage);
        nextPageImgs.click(function (event) {
            var isPenUse=ebookContext.getIsPenUse();
            if(isPenUse) {
               //如果使用了画笔则截屏
               //  pluginsMgr.openSnapshot(true);
            }

            _bookContainer.nextPage();
            ebookContext.setIsPenUse(false);//翻页后设置画笔状态为未使用
            event.stopPropagation();

            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130205';
            var user_id = ebookContext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);
        });

        // 左右箭头翻页
        $(window).bind('keydown', function (e) {
            //global_flag 设置为true，表示预览页面是打开的
            if(global_flag == true){
                return;
            }
            console.log(e.keyCode);
            if (e.target && e.target.tagName.toLowerCase() != 'input' && e.target.tagName.toLowerCase() != 'textarea') {
                if (e.keyCode == 37) {//键盘左键
                    _bookContainer.previousPage();
                }
                else if (e.keyCode == 39) {//键盘右键
                    _bookContainer.nextPage();
                }else if (e.keyCode == 33) {//键盘PageUp
                    if (_bookContainer.getPageViewType() ==_define.PageViewType.SimpleSinglePage && _switchDevicePenFunction == 0){
                        var offset = new _model.Offset(50, 50);
                        _bookContainer.moveView(offset);
                    }else{
                        _bookContainer.previousPage();
                    }

                }
                else if (e.keyCode == 34) {//键盘PageDown
                    if (_bookContainer.getPageViewType() ==_define.PageViewType.SimpleSinglePage && _switchDevicePenFunction == 0){
                        var offset = new _model.Offset(-50, -50);
                        _bookContainer.moveView(offset);
                    }else{
                        _bookContainer.nextPage();
                    }
                } else if(e.keyCode == 27 || e.keyCode == 116 ){//键盘F5和ESC
                    switchPageView();
                } else if (e.keyCode == 190 && _bookContainer.getPageViewType() == _define.PageViewType.SimpleSinglePage){//切换按键功能
                    _switchDevicePenFunction = 1-_switchDevicePenFunction;
                }
            }
        });
        $(_bookContainer).bind('pageChanged', IsDisabledNextPrePage);
        $(_bookContainer).bind('bookViewChanged', IsDisabledNextPrePage);
    }

    var IsDisabledNextPrePage = function () {
        var btnLeftPrePage = $("#btnLeftPrePage");               // 左侧上一页按钮
        var btnLeftNextPage = $("#btnLeftNextPage");             // 左侧下一页按钮
        var btnRightPrePage = $("#btnRightPrePage");             // 右侧上一页按钮
        var btnRightNextPage = $("#btnRightNextPage");           // 右侧下一页按钮
        var pageIndex = _bookContainer.getPageIndex();
        //设定上下翻页按钮是否灰显
        // var nextPageBtns = $.merge(btnLeftNextPage, btnRightNextPage);
        // var previousPageBtns = $.merge(btnLeftPrePage, btnRightPrePage);
        // var nextPageImgs = $.merge(btnLeftNextPage.find('img'), btnRightNextPage.find('img'));
        // var previousPageImgs = $.merge(btnLeftPrePage.find('img'), btnRightPrePage.find('img'));
        //
        // var isPreviousPageEnable = this.isPreviousPageEnable();
        // var isNextPageEnable = this.isNextPageEnable();
        //
        // previousPageBtns.attr('disable', isPreviousPageEnable ? '' : 'disabled');
        // previousPageImgs.attr('src', 'assert/images/tool_prepage' + (isPreviousPageEnable ? '' : '_disabled') + '.png');
        // nextPageBtns.attr('disable', isNextPageEnable ? '' : 'disabled');
        // nextPageImgs.attr('src', 'assert/images/tool_nextpage' + (isNextPageEnable ? '' : '_disabled') + '.png');

        //上下翻页（单个）
        var isPreviousPageEnable = this.isPreviousPageEnable();
        var isNextPageEnable = this.isNextPageEnable();
        isPreviousPageEnable ? btnLeftPrePage.removeClass("disabled"): btnLeftPrePage.addClass("disabled");
        isPreviousPageEnable ? btnRightPrePage.removeClass("disabled") : btnRightPrePage.addClass("disabled");
        isNextPageEnable ? btnLeftNextPage.removeClass("disabled") : btnLeftNextPage.addClass("disabled");
        isNextPageEnable ? btnRightNextPage.removeClass("disabled") : btnRightNextPage.addClass("disabled");
        btnLeftPrePage.find(".turnpage-text").text(pageIndex);
        btnRightNextPage.find(".turnpage-text").text(pageIndex + 1);
    }

    /**
     * 初始化书架按钮
     * @param btnBookShelf
     */
    function initBookShelfButton(btnBookShelf) {
        btnBookShelf.click(function () {
                console.log("goback->click");
                //$(this).addClass('sidertool2_current')
           /*
           课堂实录相关，暂时回滚，以后还会用到
           var isHavingClass=app_global_MainToolbar.getIsHavingClass();
            if(isHavingClass){
                $("#J_after_class").trigger("click");
                ebookContext.EndClassStyle=1;
            }else{*/

            $('#lessonRecord').attr('endStyle',1);
            //保存资源排序文件
            $(document).trigger('pageItemUnload');

            _ktsl.afterOrLeave(function () {

                _confirmExit.saveBookData().done(function () {
                    var isPenUse=ebookContext.getIsPenUse();
                    if(isPenUse) {
                        //如果使用了画笔，则后台调用快照截屏
                        // pluginsMgr.openSnapshot(true);
                    }
                    //给TA发送消息，刷新书本
                    var json = {
                        type   : "logic",
                        action : "refreash_ta_book",
                        from   : "ib",
                        to : "main"
                    };
                    socket.send(json);

                    //监管平台
                    var monitorMessage;
                    var session_id;
                    var monitorInfoData = monitorInfo.getInfoData();
                    var uid = ebookContext.getUser().getUid();
                    uid = uid == "0"? "" : uid;
                    for (var key in monitorInfoData){
                        session_id = monitorInfo.getSession_id(key);
                        monitorMessage ='quit|||' + session_id + '|{"module":' + key + ', "user_id":'+uid+'}';
                        monitorInfo.deleteMonitorInfo(key);
                        if(key == '02'){
                            console.log('quit电子书:' + session_id);
                        }
                        else if(key == '03'){
                            console.log('quit黑板:' + session_id);
                        }
                        _shellcmd.MonitorSend(monitorMessage);
                    }

                    //监管
                    var action = LogManager.action.trigger;
                    var params = {};
                    params.module = '1130203';
                    var user_id = ebookContext.getUser().getUid();
                    if(user_id != '0' && user_id){
                        params.user_id =user_id;
                    }
                    LogManager.statistics(action,params);

                    _pageNavigatorHelper.goToBookShelf(ebookContext.getUser());
                });
            });
            // }
            
            
        });
    }

    $(document).on("gotoBookshelf",function () {
        _confirmExit.saveBookData().done(function () {
            //给TA发送消息，刷新书本
            var json = {
                type   : "logic",
                action : "refreash_ta_book",
                from   : "ib",
                to : "main"
            };
            socket.send(json);

            //监管平台
            var monitorMessage;
            var session_id;
            var monitorInfoData = monitorInfo.getInfoData();
            var uid = ebookContext.getUser().getUid();
            uid = uid == "0"? "" : uid;
            for (var key in monitorInfoData){
                session_id = monitorInfo.getSession_id(key);
                monitorMessage ='quit|||' + session_id + '|{"module":' + key + ', "user_id":'+uid+'}';
                monitorInfo.deleteMonitorInfo(key);
                if(key == '02'){
                    console.log('quit电子书:' + session_id);
                }
                else if(key == '03'){
                    console.log('quit黑板:' + session_id);
                }
                _shellcmd.MonitorSend(monitorMessage);
            }

            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130203';
            var user_id = ebookContext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);

            _pageNavigatorHelper.goToBookShelf(ebookContext.getUser());
        });
    });


    /**
     * 初始化页面缩放按钮
     * @param btnZoomIn
     * @param btnZoomOut
     */
    function initZoomPageButtons(btnZoomIn, btnZoomOut) {

        btnZoomIn.click(function () {
            $(".user-popover").hide();

            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:ebookContext._curUser._uid,
                module:'03005',
                type:'trigger',
                havingClass:_isHavingClass?1:0
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);

            _bookContainer.zoom(ZOOM_IN_RATE);
            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130206';
            var user_id = ebookContext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);
        });

        btnZoomOut.click(function () {
            $(".user-popover").hide();
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:ebookContext._curUser._uid,
                module:'03006',
                type:'trigger',
                havingClass:_isHavingClass?1:0
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            _bookContainer.zoom(ZOOM_OUT_RATE);
            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130207';
            var user_id = ebookContext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);

        });

        var zoomInImg = btnZoomIn.find('img');
        var zoomOutImg = btnZoomOut.find('img');
        btnZoomOut.attr('disable', 'disabled');

        function setBtnZoomImgs() {
            var zoomInEnable = this.isZoomInEnable();
            var zoomOutEnable = this.isZoomOutEnable();

            zoomInImg.attr('src', 'assert/images/tool_zoomin' + (zoomInEnable ? '' : '_disabled') + '.png');
            zoomOutImg.attr('src', 'assert/images/tool_zoomout' + (zoomOutEnable ? '' : '_disabled') + '.png');
            btnZoomIn.attr('disable', zoomInEnable ? '' : 'disabled');
            btnZoomOut.attr('disable', zoomOutEnable ? '' : 'disabled');
        }

        $(_bookContainer).bind('zoomRateChanged', setBtnZoomImgs);
        $(_bookContainer).bind('bookViewChanged', setBtnZoomImgs);
    }

    function setIsEditing(value) {
        if (value == undefined) return;
        isEditing = value;
    //    _btns.btnBookShelf.find('img').attr('src', 'assert/images/tool_bookshelf' + (isEditing ? '_disabled' : '') + '.png');
    //    _btns.btnBookShelf.attr('disable', isEditing ? 'disabled' : '');
     //   _btns.btnRBlackBoard.find('img').attr('src', 'assert/images/tool_sxb' + (isEditing ? '_disable' : '') + '.png');
    //    _btns.btnLBlackBoard.find('img').attr('src', 'assert/images/tool_sxb' + (isEditing ? '_disable' : '') + '.png');

//        _btns.WBL.find('img').attr('src', 'assert/images/tool_sxb' + (isEditing ? '_disable' : '') + '.png');
//        _btns.WBR.find('img').attr('src', 'assert/images/tool_sxb' + (isEditing ? '_disable' : '') + '.png');
//        _btns.EBL.find('img').attr('src', 'assert/images/tool_kb' + (isEditing ? '_disable' : '') + '.png');
//        _btns.EBR.find('img').attr('src', 'assert/images/tool_kb' + (isEditing ? '_disable' : '') + '.png');
    }

    function setIsWhiteBoard(isWB) {
        if (isWB != undefined) {
            if (isWB == sideBarisWB) return;
            else sideBarisWB = isWB;
        }
        else sideBarisWB = !sideBarisWB;
        //白板按钮与电子书按钮切换
        sideBarisWB ? (_btns.WBL.hide(),_btns.WBR.hide()) : (_btns.WBL.show(),_btns.WBR.show());
        sideBarisWB ? (_btns.EBL.show(),_btns.EBR.show()) : (_btns.EBL.hide(),_btns.EBR.hide());
        //目录显示or隐藏
        //sideBarisWB ? (_btns.btnMuluL.css("visibility","hidden"), _btns.btnMuluR.css("visibility","hidden"),
        //    _btns.btnLeftSwitchPageView.hide(), _btns.btnRightSwitchPageView.hide(),_btns.btnResShow.hide()) :
        //    (_btns.btnMuluR.css("visibility","visible"), _btns.btnMuluL.css("visibility","visible"),
        //        _btns.btnLeftSwitchPageView.show(), _btns.btnRightSwitchPageView.show(),_btns.btnResShow.show());
        if(sideBarisWB){
            _btns.btnMuluL.hide();
            _btns.btnMuluR.hide();
            _btns.btnLeftSwitchPageView.hide();
            _btns.btnRightSwitchPageView.hide();
            _btns.btnResShow.hide();
            _btns.contentDrawerL.hide();
            _btns.contentDrawerR.hide();
        }else{
            _btns.btnMuluR.show();
            _btns.btnMuluL.show();
            _btns.btnLeftSwitchPageView.show();
            _btns.btnRightSwitchPageView.show();
            _btns.btnResShow.show();
            //上课模式显示 授课包缩略图
            if($(document).data("isHavingClass")){
                _btns.contentDrawerL.show();
                _btns.contentDrawerR.show();
            }
        }
        ibWSLogic.setCurrentState(isWB);
    }

    function initnavigator (bookContainer){
        navigatorMenu.init (bookContainer);
    }

    function changeWBEB(){
            sideBarisWB ? (_bookContainer.switchPageView(_curBookViewType)) :
                ( _curBookViewType = _bookContainer.getPageViewType(),
                    _bookContainer.switchPageView(_define.PageViewType.WhiteBoardView));
            setIsWhiteBoard(!sideBarisWB);
    }

    exports.init = init;
    exports.setIsEditing = setIsEditing;
    exports.changeWBEB = changeWBEB;
    exports.initnavigator = initnavigator;
})

