/**
 * Created by pengfu on 14-12-23.
 */
;
define(function (require, exports) {

    function LocalRes() {

        var _self = this;

        var ebookContext = require('../../ebookcontext').Instance;
        _self.bookContainer = null;

        _self.smartbar = null;

        _self.widgetArr = [];

        _self.isShow = false;

        //选中标红的模板
        // _self.domTpl =
        //     '<li><a class="clearfix" style="cursor:pointer;">' +
        //         '<span class="res_neme fl" cata="namespan">{resourcename}</span>' +
        //         ' <span class="fr ic_radio ic_radio_on" cata="titspan"></span>' +
        //         '</a></li>';
        _self.domTpl = '<li><div class="drawer-info active">' +
            '<div class="format-number">{index}</div>' +
            '<div class="format-img"><img src="{resTypePicture}"></div></div>' +
            '<div class="format-tit"><p>{resourcename}</p></div>' +
            '</li>';
        //没有选中没有红色高亮的模板
        // _self.domTplNoSel =
        //     '<li><a class="clearfix" style="cursor:pointer;">' +
        //         '<span class="res_neme fl" cata="namespan">{resourcename}</span>' +
        //         ' <span class="fr ic_radio" cata="titspan"></span>' +
        //         '</a></li>';
        _self.domTplNoSel = '<li><div class="drawer-info">' +
            '<div class="format-number">{index}</div>' +
            '<div class="format-img"><img src="{resTypePicture}"></div></div>' +
            '<div class="format-tit"><p>{resourcename}</p></div>' +
            '</li>';

        _self.controls = {
            localResId: $("#localResId"),
            localResUl: $("#localResUl"),
            showAllResId: $("#showAllResId"),

            localResNoneId: $("#localResNoneId"),
            clickAddRes: $("#clickAddRes")
        }

        _self.init = function (that) {
            _self.smartbar = that;
            _self.bookContainer = that.bookContainer;
            _self.smartbarTitle = that.smartbarTitle;

            that.controls.btnLocalResMgr.click(function () {
                if ( ! _self.controls.localResId.is(":visible") && !_self.controls.localResNoneId.is(":visible")) {
                    _self.controls.showAllResId.unbind('click');
                    _self.showLocalResPanel();

                    //监管
                    var action = LogManager.action.trigger;
                    var params = {};
                    params.module = '1130217';
                    var user_id = ebookContext.getUser().getUid();
                    if(user_id != '0' && user_id){
                        params.user_id =user_id;
                    }
                    LogManager.statistics(action,params);

                } else {
                    _self.hideLocalResPanel();
                }
            });

            _self.controls.clickAddRes.click(function (e) {
                _self.hideLocalResPanel();
                if (!_self.smartbar.editStatus) {
                    _self.smartbar.openSmartBar();
                }
            });
        }

        _self.showLocalResPanel = function () {
            var widowWidth = $(window).width();
            var windowHeight = $(window).height();
            if(windowHeight >= 950){
                _self.controls.localResId.css('top','195px');
                _self.controls.localResNoneId.css('top','195px');
            }
            if(windowHeight <=600){
                _self.controls.localResId.css('top','93px');
                _self.controls.localResNoneId.css('top','93px');
            }
            //TODO：不同分辨率进行缩放
            correctToBaseResolution(_self.controls.localResId, {scaleFromCenter: false});
            correctToBaseResolution(_self.controls.localResNoneId, {scaleFromCenter: false});

            //获取资源widgets数组，
            var widgets = _self.bookContainer.getCurrentPageRes();
            _self.widgetArr = widgets;

            //显示所有勾选框的初始化状态
            var showAll = true;

            if (widgets.length > 0) {
                //TODO:将数组中资源类型append到页面上
                _self.controls.localResUl.empty();
                for (var i = 0, len = widgets.length; i < len; i++) {
                    var resTpl;
                    if (!widgets[i].showIconFlag) {
                        resTpl = _self.domTpl;
                    } else {
                        resTpl = _self.domTplNoSel;
                        showAll = false;
                    }
                    resTpl = resTpl.replace("{resourcename}", widgets[i].Title);
                    _self.controls.localResUl.append(resTpl);

                    if(showAll){
                        _self.controls.showAllResId.removeClass().addClass('ic_radio radio-t ic_radio_on');
                    }else{
                        _self.controls.showAllResId.removeClass().addClass('ic_radio radio-t');
                    }
                }
                _self.bindEvents();
                _self.controls.localResId.show();
                _self.controls.localResNoneId.hide();
            } else {
                //页面没有资源时显示没有资源的页面
                _self.controls.localResNoneId.show();
                _self.controls.localResId.hide();
            }

        }

        //为有资源页面里的相关控件绑定事件
        _self.bindEvents = function () {

            //为“显示所有”绑定事件
            _self.controls.showAllResId.click(function () {
                if ($(this).hasClass('ic_radio radio-t ic_radio_on')) {
                    //隐藏全部
                    $(this).removeClass().addClass('ic_radio radio-t');
                    //TODO:全部隐藏，UI上取消下面分项的全部勾选，变为正常色，业务逻辑上全部icon隐藏
                    _self._changeCheckBoxesUI(false);
                    _self._DisplayOrHideIcon(false);
                } else {
                    //显示全部
                    $(this).removeClass().addClass('ic_radio radio-t ic_radio_on');
                    //TODO:全部显示，显示下面分项的全部勾选
                    _self._changeCheckBoxesUI(true);
                    _self._DisplayOrHideIcon(true);
                }
            })

            _self.controls.localResUl.find('span[cata=titspan]').
                on('click', function () {
                    var i = $(this).parent().parent().index();
                    if ($(this).hasClass('fr ic_radio ic_radio_on')) {
                        //隐藏
                        $(this).removeClass().addClass('fr ic_radio');
//                        $(this).prev().removeClass().addClass('res_neme fl');
                        //有一个checkbox没有选中，全局的checkbox就不应该选中了
                        _self.controls.showAllResId.removeClass().addClass('ic_radio radio-t');

                        _self.widgetArr[i].showIconFlag = true;//true表示隐藏
                        _self.widgetArr[i].resourceIconHide();
                    } else {
                        //显示
                        $(this).removeClass().addClass('fr ic_radio ic_radio_on');
//                        $(this).prev().removeClass().addClass('res_neme red fl');

                        //选中了checkbox要判断所有的checkbox是否都选中，全部选中，则应该把全局checkbox设置为选中
                        var titDomList = _self.controls.localResUl.find('span[cata=titspan]');
                        var flag = false;
                        $.each(titDomList, function () {
                            if (!($(this).hasClass('fr ic_radio ic_radio_on'))) {
                                flag = true;
                            }
                        })
                        if (!flag) {
                            _self.controls.showAllResId.removeClass().addClass('ic_radio radio-t ic_radio_on');
                        }

                        _self.widgetArr[i].showIconFlag = false;
                        _self.widgetArr[i].resourceIconHide();
                    }
                })

            _self.controls.localResUl.find('span[cata=namespan]').
                on('click', function () {
                    $(this).removeClass().addClass('res_neme red fl');
                    _self.hideLocalResPanel();
                    var i = $(this).parent().parent().index();
                    _self.widgetArr[i].resourcePreview();

                })

        }

        _self.hideLocalResPanel = function () {
            _self.controls.localResId.hide();
            _self.controls.localResNoneId.hide();
        }

        _self._changeCheckBoxesUI = function (isDisplay) {
            var nameDomList = _self.controls.localResUl.find('span[cata=namespan]');
            var titDomList = _self.controls.localResUl.find('span[cata=titspan]');
            if (!isDisplay) {
//                $.each(nameDomList,function(){
//                    $(this).removeClass().addClass('res_neme fl');
//                })
                $.each(titDomList, function () {
                    $(this).removeClass().addClass('fr ic_radio');
                })
            } else {
//                $.each(nameDomList,function(){
//                    $(this).removeClass().addClass('res_neme red fl');
//                })
                $.each(titDomList, function () {
                    $(this).removeClass().addClass('fr ic_radio ic_radio_on');
                })
            }

        }

        _self._DisplayOrHideIcon = function (isDisplay) {
            var len = _self.widgetArr.length;
            if (isDisplay) {
                //显示
                for (var i = 0; i < len; i++) {
                    _self.widgetArr[i].showIconFlag = false;//false 表示显示
                    _self.widgetArr[i].resourceIconHide();
                }
            } else {
                //隐藏
                for (var j = 0; j < len; j++) {
                    _self.widgetArr[j].showIconFlag = true;
                    _self.widgetArr[j].resourceIconHide();
                }
            }
        }
    }

    exports.Instance = new LocalRes();
})
