/**
 * Created by zzsun on 14-9-1.
 */
define(function (require, exports) {
    var _cloudresourceBase = require('./cloudresourcebase');
    var _recommendResUrl = AppRemoteSvcCfg.ResBatch;
    var _ebookContext = require('../../ebookcontext').Instance;
    var path = require('../../../common/path');
    var _resourceContentPage = require('./resourcecontent').Instance;
    var shellcmd = require('../../../common/shellcmd');

    //资源分类名称
    var _resType={
        "0100": "教案",
        "0300": "素材",
        "0400": "习题",
        "0600": "课件"
    }
    //按照此序列进行排序
    var _resTypeArr=[
        "0600",
        "0100",
        "0400",
        "0300"
    ];
    function recommendresource(){
        this.bookContainer = "";
        this.smartBarContent="";
        this.recommendList = {
            data: [],
            total: 0
        };
        this.showStatus = {
            resource: [
            ]
        };

    }
    recommendresource.prototype = new _cloudresourceBase();
    /**
     * 初始化
     * @param bookContainer
     */
    recommendresource.prototype.init = function(bookContainer,smartBarEle){
        var _this = this;
        _this.bookContainer = bookContainer;
        _this.smartBarEle = smartBarEle;
        _this.smartBarPop = $('#smartbar_pop');
        _this.smartBarTool = $('#smartbar_tool');
        _this.smartBarTitle = this.smartBarEle.find('.new_pop_tit2');
        _this.smartBarContent = this.smartBarEle.find('.resource_tool_cont2');
        _this.registerEvent();
        //资源详情页初始化
           _resourceContentPage.init(bookContainer,smartBarEle);    };
    /**
     * 设置推荐资源Item
     * @param result
     */
    recommendresource.prototype.setRecommendResItem = function(result,status){
        var _this = this;
          _this.recommendList = result;
        _this.showStatus.resource=status;
        console.log(result)
        var _containerWidth = parseInt($("#bookContainer").css("width"));
        var $recommendList = $("#recommendList");
        var _conWidth = 215;//这个变量是临时增加用于调整推荐资源宽度的
        //$recommendList.css("width",(_containerWidth-266-16*2-10)*0.99+"px");
        $recommendList.css("width",_conWidth+"px");
        //根据不同分辨率来计算显示的数目
        var resTotal = parseInt((_containerWidth-266-16*2-10)*0.99/67);

        for(var i=0;i<5;i++){
            $($("ul[name='recommendItem']")[i]).html("");
        }

        if (!getBlackboardFlag()){
            _this.recommendList = result;
            _this.showStatus.resource=status;
            //清空列表
            result = result.data;
            //A代表课件
            //B代表教案
            //C代表习题
            //D代表素材
            var A= 0, B= 0, C= 0, D=0;
            //Now标识当前应该塞到那个分类里
            var Now= 0;
            for(var i=0; i<resTotal; i++){
                Now = Now%4;
                if(Now==0){
                    if(A<2){
                        var data =  result[Now].data,
                            total = result[Now].total,
                            resType= result[Now].type,
                            recommendItem = $("ul[name='recommendItem']");
                        $(recommendItem[Now]).attr("resType",resType);
                        $(recommendItem[Now]).attr("title",_resType[resType]);
                        if(data[A])
                        {
                            _this.render(A,resType,data,$(recommendItem[Now]));
                            A++;
                            Now++;
                            continue;
                        }else{
                            Now=Now+1
                        }
                    }else{
                        Now++;
                    }
                }
                if(Now==1){
                    if(B<2){
                        var data =  result[Now].data,
                            total = result[Now].total,
                            resType= result[Now].type,
                            recommendItem = $("ul[name='recommendItem']");
                        $(recommendItem[Now]).attr("resType",resType);
                        $(recommendItem[Now]).attr("title",_resType[resType]);
                        if(data[B])
                        {
                            _this.render(B,resType,data,$(recommendItem[Now]));
                            B++;
                            Now++;
                            continue;
                        }else{
                            Now++;
                        }
                    }else{
                        Now++;
                    }
                }
                if(Now==2){
                    var data =  result[Now].data,
                        total = result[Now].total,
                        resType= result[Now].type,
                        recommendItem = $("ul[name='recommendItem']");
                    $(recommendItem[Now]).attr("resType",resType);
                    $(recommendItem[Now]).attr("title",_resType[resType]);
                    if(data[C])
                    {
                        _this.render(C,resType,data,$(recommendItem[Now]));
                        C++;
                        Now++;
                        continue;
                    }else{
                        Now++;
                    }
                }
                if(Now==3){
                    var data =  result[Now].data,
                        total = result[Now].total,
                        resType= result[Now].type,
                        recommendItem = $("ul[name='recommendItem']");
                    $(recommendItem[Now]).attr("resType",resType);
                    $(recommendItem[Now]).attr("title",_resType[resType]);
                    if(data[D])
                    {
                        _this.render(D,resType,data,$(recommendItem[Now]));
                        D++;
                        Now++;
                        continue;
                    }else{
                        Now++;
                    }
                }
            }

            var $recommendList_re_group = $recommendList.find(".re_group");
         //   $($('.re_group').find('span')[0]).html('');
           $($recommendList_re_group[4]).hide();
            //A代表课件,若A=0表示无该分类资源，隐藏该分类
            (A==0) && $($recommendList_re_group[0]).hide();
            //B代表教案,若B=0表示无该分类资源，隐藏该分类
            (B==0) && $($recommendList_re_group[1]).hide();
            //C代表习题,若C=0表示无该分类资源，隐藏该分类
            (C==0) && $($recommendList_re_group[2]).hide();
            //D代表素材,若D=0表示无该分类资源，隐藏该分类
            (D==0) && $($recommendList_re_group[3]).hide();
        }
        else {
             //   $recommendList_re_group = $recommendList.find(".re_group");
             //   $($recommendList_re_group[0]).show();
                var recommendItem = $("ul[name='recommendItem']");
                $($('.re_group').find('span')[4]).html('模板');
                var resNum = resTotal > result.length ? result.length : resTotal;
                for( i = 0 ;i < resNum; i++){
                    _this.renderSubjectTemplate(result[i],i,$(recommendItem[4]));
                }
        }
    };

    recommendresource.prototype.renderSubjectTemplate = function(data, index, container){
        var _this = this;
        var li = $(' <li name="subjectTemplate" class="itemli">'+
            '<a class="current" title="资源1" href="javascript:;" style="text-decoration: none;">'+
            '<img alt="" style="width: 36px;height: 36px;" src="assert/images/resource_tool_img2.png" />'+
            '<p name="title" style="font-size: 11px;height: 16px;overflow-y:hidden">{title}</p>'+
            '</a>' +
            '</li>');
        var realName = data.title;
        var url = _this.setDefaultPic('jpg');
        li.find('img').attr("src", url);
        li.find('a').attr("title", realName);
        li.find('p').text(realName);
        li.attr("srcPath",data.srcPath);
        li.attr("index" ,index);
        var _containerWidth = parseInt($("#bookContainer").css("width"));
        if(_containerWidth<1000){
            li.css("width","54px");
        }
        container.append(li);
        $("li[name=subjectTemplate]").hover(function(){
            $(this).find('a').css("color","red");
        },function(){
            $(this).find('a').css("color","black");
        });
    }
    /**
     * 插入到页面
     * @param index 下标
     * @param resType 分类
     * @param data  数据
     * @param container 容器
     */
    recommendresource.prototype.render = function(index, resType,data,container){
        var _this = this;
        var li = $(' <li name="recommendItemLi" class="itemli">'+
        '<a class="record_link current" title="资源1"  style="text-decoration: none;cursor: pointer">'+
            '<img alt="" style="width: 36px;height: 36px;" src="assert/images/resource_tool_img2.png" />'+
            '<p name="title" style="font-size: 11px;">{title}</p>'+
            '</a>' +
            '</li>');
        var type = data[index].extension,
            url = _this.setDefaultPic(type);
        (data[index].thumburl.length == 0) && (data[index].thumburl = "assert/images/default_01.jpg");
        li.attr("id", data[index].id);
        var _containerWidth = parseInt($("#bookContainer").css("width"));
        if(_containerWidth<1000){
            li.css("width","54px");
        }
        li.attr("contend", index);
        li.attr("resType", resType);
        li.find('img').attr("src", url);
        li.find('a').attr("title", data[index].title);
        //去除《》中的内容
        var _title = data[index].title.replace(/^[《].*[》]/i,"");
        if(_title)
            _title = _title.length >5 ? _title.substr(0, 5) + "···" : _title;
        else{
            _title = data[index].title;
        }
        li.find('p').text(_title);
        container.append(li);
       /* $("li[name=recommendItemLi]").hover(function(){
            $(this).find('a').css("color","red");
        },function(){
            $(this).find('a').css("color","black");
        });*/
    };
    /**
     * 事件绑定
     */
    recommendresource.prototype.registerEvent=function(){
        var _this = this,
            resourceList = this.smartBarContent.find('.resource_tool_cont_box'),
            left = parseInt(_this.smartBarEle.css("left").replace(/px/gi, "")),
            bottom, width;

        var PopFrame = function(curEle){
            if (!getBlackboardFlag()){
                var smartbar_pop = $('<div class="re_group_block_warp" id="smartbar_pop" style="margin-left: -60px;">'+
                    '<div class="re_group_block_con re_group_block_con_bar">'+
                    '<dl>'+
                    '<dd class="re_gr_img"><img id="viewImg" src="assert/images/re_gr_img01.png" alt=""></dd>'+
                    '<dd class="re_gr_btn clearfix">'+
                    '<span id="viewRes">预览</span>'+
                    '<span id="addToBook">加入课本</span>'+
                    '</dd>'+
                    '<dd class="re_gr_text">可直接拖动加入课本</dd>'+
                    '</dl>'+
                    '</div>'+
                    '</div>');

                var containerWidth = parseInt($("#bookContainer").css("width"))
                if (containerWidth < 800&&(i==0&&index==0)) {
                    if($("#smartbar").attr("flag")=="top")
                        smartbar_pop.css("marginLeft","-30px").addClass("re_group_block_warp2");
                    else
                        smartbar_pop.css("marginLeft","-30px")
                            .removeClass("re_group_block_warp").addClass("re_group_block_warp_top_yf").addClass("re_group_block_warp2");
                }else{
                    if($("#smartbar").attr("flag")=="top"){
                        smartbar_pop.removeClass("re_group_block_warp_top01").addClass("re_group_block_warp");
                        smartbar_pop.find(".re_group_block_con_top01").removeClass("re_group_block_con_top01").addClass("re_group_block_con");

                    }else{
                        smartbar_pop.removeClass("re_group_block_warp").addClass("re_group_block_warp_top01");
                        smartbar_pop.find(".re_group_block_con").removeClass("re_group_block_con").addClass("re_group_block_con_top01");

                    }
                }
                curEle.append(smartbar_pop);
            } else {
                smartbar_pop =
                    $('<div class="wrap" id="smartbar_pop" style="z-index :1 ;position: absolute;bottom: 81px;left:-113px"><div class="re_group2 relative">'+
                    '<div class="editor_tit_smartBar clearfix">'+
                        '<p style="float: left">田字格</p>'+
                    '</div>'+
                        '<div class="editor_con">' +
                            '<div class="editor_photo_smartBar"><img id = "viewImg"src="images/default_01.jpg" alt=""></div>' +
                                '<div class="editor_btnbar_smartBar">'+
                                    '<div class="line"></div>' +
                                    '<div class="btn_smartBar">' +
                                        '<div id = "addToBook" class="smartbar_btn_smartBar">加入黑板</div>'+
                                        '<div id = "viewRes" class="smartbar_btn_smartBar">预览</div>'+
                                    '</div>'+
                                '</div>'+
                        '</div>' +
                     '</div>' +
                    '<i class="ic_arrowbot absolute" style="margin-left: -9px"></i>'+
                '</div>');
                if ($("#smartbar").attr("flag")=="top"){
                    if (curEle.attr("index") == 0){
                        smartbar_pop.css('left','-34px');
                        smartbar_pop.find('i').css('margin-left','-86px');
                    } else if(curEle.attr("index") == 1){
                        smartbar_pop.css('left','-94px');
                        smartbar_pop.find('i').css('margin-left','-28px');
                    }
                } else {
                    smartbar_pop.find('i').removeClass('ic_arrowbot').addClass('ic_arrowtop');
                    smartbar_pop.find('i').css('margin-top','1px');
                    if (curEle.attr("index") == 0){
                        smartbar_pop.css('left','-34px');
                        smartbar_pop.find('i').css('margin-left','-88px');
                    } else if(curEle.attr("index") == 1){
                        smartbar_pop.css('left','-95px');
                        smartbar_pop.find('i').css('margin-left','-27px');
                    }
                }
                //var realName = path.basename(curEle.attr('srcPath'),'.jpg');
                smartbar_pop.find('p').text(curEle.find('p').text());
                curEle.append(smartbar_pop);

            }

            if($("#smartbar").attr("flag")=="top"){
                $("#smartbar_pop").css({
                    bottom:"81px",
                    top:""
                })
            }else{
                $("#smartbar_pop").css({
                    bottom:"",
                    top:"81px"
                })
            }
        }
        //推荐资源列表点击单个资源弹出气泡
        $(document).on("click","li[name='recommendItemLi'] , li[name=subjectTemplate]", function (e) {
            var _that = this;
            var isSelf = false;
            if (typeof bottom == 'undefined') {
                bottom = $("#smartbar").height();
                width = $(this).width();
                left = left - width;
            }
            var currentIndex = $("li[name='recommendItemLi']").index($(this));
            console.log(currentIndex)

            //关闭已经存在的气泡
            if ($("li[name=subjectTemplate]").find("#smartbar_pop").length!=0&&$($("li[name=subjectTemplate]").find("#smartbar_pop").find('#viewImg')).attr("src") == $(this).attr("srcPath") ){
                isSelf = true;
            }
            $("li[name='recommendItemLi'] , li[name=subjectTemplate]").find("#smartbar_pop").remove();
            //若本地资源信息框是显示状态、则关闭本地资源信息框
            $("div[name='infoWideget_pop']").length!=0 && $("div[name='infoWideget_pop']").parent().hide();

            if (!getBlackboardFlag()){
                var index = $(this).attr("contend"),
                    resType = $(this).attr("resType");
                for(var i in _resTypeArr){
                    if(_resTypeArr[i]==resType) break;
                }
                //i为资源分类下标 index为该分类下的下标
                _this.resetSmartBarEle('resource', i , index);
                var _recommendItem = _this.recommendList.data[i].data[index];
                //   console.log(_recommendItem)
			  if (_this.showStatus.resource[i][index]) {
                var url = AppRemoteSvcCfg.rescomment +_recommendItem.id;
                _ebookContext.getUser().getDataByUserToken(url).done(function (result) {
                    console.log(result);


                    var smartbar_pop = $(' <div class="res_editor_box2 relative" id="smartbar_pop"  style="margin-left: -120px;">'+
                                                '<div class="editor_tit clearfix">'+
                                                    '<span class="editor_top fl" name="res_title">与西湖相关的古诗</span>'+
                                                    '<span class="editor_btn fr"><a id="reviewResContent" style="cursor: pointer" class="blue_btn" title="查看详情">查看详情</a></span>'+
                                                '</div>'+
                                                '<div class="editor_con">'+
                                                    '<div class="editor_img" style="width: 260px;height: 173px;">'+
                                                        '<div class="smart_img_contend" style="cursor: pointer;">'+
                                                        '<img name="res_image" class="img_show" style="width: 260px;height: 173px;" id="viewImg" src="assert/images/default_01.jpg" >'+
                                                        '</div>'+
                                                        '<a style="cursor: pointer" id="smart_img_pre" class="editor_pre" title="上一页"><img src="assert/images/pre_arrow.png"></a>'+
                                                        '<a style="cursor: pointer" id="smart_img_next" class="editor_next" title="下一页"><img src="assert/images/next_arrow.png"></a>'+
                                                    '</div>'+
                                                    '<div class="editor_text text_ellipsis" name="description">' +
                                                            '雪孩子变成了白云，雪孩子变成了白云。雪孩子变成了白云。' +
                                                    '</div>'+
                                                    '<div class="editor_info">资源作者：<a  name="auth_name" class="blue_text">李老师</a></div>'+
                                                    '<div class="editor_pj clearfix">'+
                                                        '<p class="fl"><span class="star">' +
                                                            '<em name="resStar" style="width:80%;"></em>' +
//                                                            '</span><a style="cursor: pointer" name="commendNum" class="blue_text">102</a>条评论' +
                                                        '</p>'+
//                                                        '<p class="fr"><a id="reviewComments" style="cursor: pointer" class="blue_text">查看评论/我要评论</a></p>'+
                                                    '</div>'+
                                                    '<div class="editor_btnbar">'+
                                                        '<div class="line"></div>'+
                                                        '<div class="btn">'+
                                                            '<a style="cursor: pointer" id="addToBook" class="smartbar_btn" title="加入课本">加入课本</a>'+
//                                                            '<a style="cursor: pointer" id="shareToWeb" class="smartbar_btn" title="分享">分享</a>'+
                                                        '</div>'+
                                                    '</div>'+
                                                '</div>'+
                                                '<i name="arrow" class="ic_arrowbot absolute"></i>'+
                                        '</div>');



                        var containerWidth = parseInt($("#bookContainer").css("width"));
                        if (containerWidth < 800&&(i==0&&index==0)) {
                            if($("#smartbar").attr("flag")=="top")
                                smartbar_pop.css("marginLeft","-30px").addClass("re_group_block_warp2");
                            else{
                                smartbar_pop.css("marginLeft","-30px")
                                    .removeClass("re_group_block_warp").addClass("re_group_block_warp_top_yf").addClass("re_group_block_warp2");
                            }

                        }else if(containerWidth>800&&((i==0&&index==0) || currentIndex==0)){
                            if($("#smartbar").attr("flag")=="top"){
                                smartbar_pop.css("marginLeft","-48px");
                                smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowtop").addClass("ic_arrowbot").css("marginLeft","-72px");
                            }else{
                                smartbar_pop.css("marginLeft","-48px");
                                smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowbot").addClass("ic_arrowtop").css("marginLeft","-72px");

                            }
                        }else if(containerWidth>800&&((i==0&&index==1) || currentIndex==1)){
                            if($("#smartbar").attr("flag")=="top"){
                                smartbar_pop.css("marginLeft","-95px");
                                smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowtop").addClass("ic_arrowbot").css("marginLeft","-30px");
                            }else{
                                smartbar_pop.css("marginLeft","-95px");
                                smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowbot").addClass("ic_arrowtop").css("marginLeft","-30px");

                            }
                        }
                        else{
                            if($("#smartbar").attr("flag")=="top"){
                                smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowtop").addClass("ic_arrowbot");
                            }else{
                                smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowbot").addClass("ic_arrowtop");

                            }
                        }
                        $(_that).append(smartbar_pop);
                        $("#addToBook").attr("content_li", i).attr("content_li_a", index);
                        var user = _ebookContext.getUser();
                        if(user._name === 'defaultuser' || user._userName === 'defaultuser'){
                            $("#shareToWeb").hide();
                        }else{
                            $("#shareToWeb").attr("content_li", i).attr("content_li_a", index);
                        }
                        $("#reviewResContent").attr("content_li", i).attr("content_li_a", index);
                        $("#reviewComments").attr("content_li", i).attr("content_li_a", index);
                        $(".smart_img_contend").attr("content_li", i).attr("content_li_a", index);
                        smartbar_pop.find("a[name='auth_name']").html(_recommendItem.creator);
                        smartbar_pop.find("a[name='auth_name']").attr('contend-name',_recommendItem.uploader);
                        smartbar_pop.find("div[name='description']").html(_recommendItem.description);
                        smartbar_pop.find("div[name='description']").attr("title",_recommendItem.description);
                        smartbar_pop.find("a[name='commendNum']").html(result.total);
                        var _title ="";
                        if(_recommendItem.title&& _recommendItem.title.length>10)
                            _title = _recommendItem.title.substr(0,10)+"···";
                        else
                            _title = _recommendItem.title;

                        smartbar_pop.find("span[name='res_title']").attr("title",_recommendItem.title).html(_title);
                        smartbar_pop.find("em[name='resStar']").css("width",_recommendItem.statistics.score + "%");

                        //多张缩略图
                        //_recommendItem.screenshots[1] 是为了防止服务端返回空对象
                        if(_recommendItem.screenshots && _recommendItem.screenshots[1]) {
                            //screenshots 有，不用单缩略图
                            $("#viewImg").remove();
                            $("#smart_img_pre").show();
                            $("#smart_img_next").show();
                            var _imgTemp = null;
                            for(var temp in _recommendItem.screenshots){
                                if(temp == 1){
                                    _imgTemp = $('<img name="res_image" style="width: 260px;height: 173px;" class="img_show" src="assert/images/default_01.jpg" >');

                                }else{
                                    _imgTemp = $('<img name="res_image" style="width: 260px;height: 173px;" class="img_hide" src="assert/images/default_01.jpg" >');

                                }
                                _imgTemp.attr("src", _recommendItem.screenshots[temp]);
                                smartbar_pop.find(".smart_img_contend").append(_imgTemp);
                            }
                        }else{
                            $("#smart_img_pre").hide();
                            $("#smart_img_next").hide();
                            if (_recommendItem.thumburl) $("#viewImg").attr("src", _recommendItem.thumburl);
                        }

                        if($("#smartbar").attr("flag")=="top"){
                            $("#smartbar_pop").css({
                                bottom:"60px",
                                top:"",
                                position: "absolute",
                                "z-index":10
                            })
                        }else{
                            $("#smartbar_pop").css({
                                bottom:"",
                                top:"60px",
                                position: "absolute",
                                "z-index":10
                            })
                        }
					});
				}
            } else {
                    if (isSelf == false){
                        PopFrame($(this));
                        $("#viewRes").attr("srcPath", $(this).attr("srcPath"));
                        $("#viewRes").attr("srcName", $(this).find('a').attr('title'));
                        $("#addToBook").attr("srcPath", $(this).attr("srcPath"));
                        $("#viewImg").attr("src", $(this).attr("srcPath"));
                    }


            }
        });

        $(document).on('click',"a[name='auth_name']", function(e){
            /**
             * 以下代码注释时间：2015.4.18
             * 原因：区域平台展会屏蔽
             */
//            var upLoadName = $(this).text();
//            var url = AppRemoteSvcCfg.GeRenZhongXin + upLoadName;
//            _ebookContext.getUser().getDataByUserToken(url).done(function(userInfo){
//                if(userInfo)
//                {
//                    var userServiceUrl = AppRemoteSvcCfg.SNSID +userInfo.id;
//                    shellcmd.getHttpRequest(userServiceUrl).done(function(res){
//                        if(res)
//                        {
//                            var res = JSON.parse(res);
//                            var indexUrl = ''
//                            console.log(res);
//                            if(AppVersionCfg.AppVersion == "YueJiaoYun"){
//                                indexUrl= AppRemoteSvcCfg.YJYSNSMainPage + res.uid;
//                            }else{
//                                indexUrl= AppRemoteSvcCfg.SNSMainPage + res.uid;
//                            }
//                            res.uid && shellcmd.openPageOutside(indexUrl);
//                        }
//                    });
//                }
//            });
//            $("li[name='recommendItemLi'] , li[name=subjectTemplate]").find("#smartbar_pop").remove();
//            e.stopPropagation();
        });

        //通过缩略图点击进入详情页
        $(document).on("click", ".smart_img_contend", function(){
            var resType_index = $(this).attr("content_li"),
                index = $(this).attr("content_li_a"),
                resultData =_this.recommendList.data[resType_index].data[index];
            resultData.resFrom = "recommend";

//            var url = AppRemoteSvcCfg.resDetail +  resultData.id;
            var url = getPlatFormCfg(resultData.platForm) + "&method=res.resource.get&resourceid=" + resultData.id;
            _ebookContext.getUser().getDataByUserToken(url).done(function(result){
                if(!resultData.thumburl){
                    resultData.thumburl = result.thumburl;
                }
                resultData.statistics = result.statistics;
                _resourceContentPage.showResContentPanel(resultData);
            });
        });

		//资源弹出框图片翻页----前一张
        $(document).on("click","#smart_img_pre",function(e){
            $("#smart_img_pre").show();
            $("#smart_img_next").show();
            var prev =$(".img_show").prev("img[name=res_image]");
            var length = $("img[name=res_image]").length;
            if(prev.length>0){
                $(".img_show").removeClass("img_show").addClass("img_hide");
                prev.removeClass("img_hide").addClass("img_show");
            }else{
                $(".img_show").removeClass("img_show").addClass("img_hide");
                $($("img[name=res_image]")[length-1]).removeClass("img_hide").addClass("img_show");
              //  $("#smart_img_pre").hide();
            }
            e.stopPropagation();
        });
		
        //资源弹出框图片翻页----后一张
        $(document).on("click","#smart_img_next",function(e){
            $("#smart_img_pre").show();
            $("#smart_img_next").show();
            var next = $(".img_show").next("img[name=res_image]");
            var length = $("img[name=res_image]").length;
            if(next.length>0){
                $(".img_show").removeClass("img_show").addClass("img_hide");
                next.removeClass("img_hide").addClass("img_show");
            }else if(length>0){
                $(".img_show").removeClass("img_show").addClass("img_hide");
                $($("img[name=res_image]")[0]).removeClass("img_hide").addClass("img_show");
               // $("#smart_img_next").hide();
            }
            e.stopPropagation();
        });
        //推荐资源---查看资源
        $(document).on("click","#viewRes",function(event){
            if(!getBlackboardFlag()){
                var resType_index = $(this).attr("content_li");
                var index = $(this).attr("content_li_a");
                var resultData = _this.recommendList.data[resType_index].data[index];
                var type = resultData.extension;
                var url = resultData.previewurl;
                $("#smartbar_pop").remove();
                resultData.resFrom = "recommend";
                _this.resetSmartBarEle('resource', resType_index , index);
                _this.previewRes(type, url,resultData);
                event.stopPropagation();
                return false;
            } else{
                $("#smartbar_pop").remove();
                 url = $(this).attr('srcPath');
                 type = path.extname(url);
                 type = type.replace('.','');
                 resultData = {"title" : $(this).attr('srcName') , "url" : url};
                _this.previewRes(type, url, resultData);
                event.stopPropagation();
                return false;
            }

        });
        //推荐资源---加入到书本
        $(document).on("click","#addToBook",function(event){
            if (!getBlackboardFlag()){
                var resType_index = $(this).attr("content_li"),
                    index = $(this).attr("content_li_a"),
                    resultData =_this.recommendList.data[resType_index].data[index];
                resultData.resFrom = "recommend";
                $("#smartbar_pop").remove();
                newWidgetPos = null;
                _this.resetSmartBarEle('resource', resType_index , index);
                _this.downLoadFile(resultData);
                event.stopPropagation();
                return false;
            } else {
                var array = [];
                array[0] = $(this).attr('srcPath');
                _this.bookContainer.insertWidget(array,'');

                //监管
                var action = LogManager.action.trigger;
                var params = {};
                params.module = '1130624';
                var user_id = _ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                LogManager.statistics(action,params);

            }

        });

//        //查看详情reviewResContent
//        $(document).on("click","#reviewResContent",function(event){
//            var resType_index = $(this).attr("content_li"),
//                index = $(this).attr("content_li_a"),
//                resultData =_this.recommendList.data[resType_index].data[index];
//            resultData.resFrom = "recommend";
//
////            var url = AppRemoteSvcCfg.resDetail +  resultData.id;
//            var url = getPlatFormCfg(resultData.platForm) + "&method=res.resource.get&resourceid=" + resultData.id;
//            _ebookContext.getUser().getDataByUserToken(url).done(function(result){
//                if(!resultData.thumburl){
//                    resultData.thumburl = result.thumburl;
//                }
//                resultData.statistics = result.statistics;
//                _resourceContentPage.showResContentPanel(resultData);
//            });
//        })

        //查看评论reviewComments
        $(document).on("click","#reviewComments",function(event){
            var resType_index = $(this).attr("content_li"),
                index = $(this).attr("content_li_a"),
                resultData =_this.recommendList.data[resType_index].data[index];
            resultData.resFrom = "recommend";
            _resourceContentPage.showResContentPanel(resultData);

        })        //推荐资源----拖拽下载
        $(document).on("dragend","li[name='recommendItemLi'] ,li[name='subjectTemplate'] ",function(e){
            newWidgetPos = {
                left : e.originalEvent.clientX,
                top : e.originalEvent.clientY
            }
            if (!getBlackboardFlag()){
                var _that = this;
                var index = $(_that).attr("contend"),
                    resType = $(_that).attr("resType");
                for(var i in _resTypeArr){
                    if(_resTypeArr[i]==resType) break;
                }
                $("li[name='recommendItemLi'] , li[name=subjectTemplate]").find("#smartbar_pop").remove();
                _this.resetSmartBarEle('resource', i , index);
                var resultData = _this.recommendList.data[i].data[index];
                resultData.resFrom = "recommend";
                console.log(resultData);
                resultData && _this.downLoadFile(resultData);
            } else {
                var array = [];
                array[0] = $(this).attr("srcPath");
                var $pageItem = $('.pageItem');
                var isDoublePage = $pageItem.length === 2;
                var pageindex = 1;
                var pageScale = _ebookContext.getTransformMatrix($pageItem);
                var viewWidth =  $("#bookContainer").width();
                var x, y;
                if (isDoublePage) {
                    x = (newWidgetPos.left - 70 - viewWidth/2 );
                    //判断是否是第二页
                    if(x>0){
                        x = x / pageScale[0];
                        pageindex = 2;
                    }
                    else{
                        x = (newWidgetPos.left - 70) / pageScale[0];
                    }
                }
                else {
                    x = (newWidgetPos.left - 70) / pageScale[0];
                }
                y = (newWidgetPos.top - 90) / pageScale[3];
                console.log(x, y);
                console.log(newWidgetPos.left, newWidgetPos.top);
                _this.bookContainer.insertWidgetWithPos(array[0], [x, y],pageindex, '');
            }});

       //分享至畅言云
        $(document).on("click", "#shareToWeb", function(evt){
            var _that = this;
            shellcmd.checkOnline().done(function(ret){
                if(!ret){
                    $.Zebra_Dialog("请先连接网络！", {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [ AppTips.OkTips],
                        'zIndex': 1000
                    });
                    return;
                }
                else{
                    var resType_index = $(_that).attr("content_li"),
                        index = $(_that).attr("content_li_a"),
                        resultData = _this.recommendList.data[resType_index].data[index],
                        type = resultData.extension,
                        previewurl = resultData.previewurl;
                    resultData.resFrom = "recommend";
                    resultData.type='4';
                    _this.shareResToCloud(resultData);
                }
            });
        });
    };
    /**
     * smartBar 重置显示或隐藏状态
     * @param ele
     */
    recommendresource.prototype.resetSmartBarEle = function (ele) {
        for (var i in this.showStatus) {
            if (i == ele) {
                if (typeof this.showStatus[i] == 'object') {
                    for (var j = 0, length = this.showStatus[i].length; j < length; j++) {
                        if (arguments[1] == j) {
                            this.showStatus[i][j][arguments[2]] = !this.showStatus[i][j][arguments[2]];
                        } else {
                            this.showStatus[i][j][arguments[2]] = false;
                        }
                    }
                } else {
                    this.showStatus[i] = !this.showStatus[i];
                }
            } else {
                if (typeof this.showStatus[i] == 'object') {
                    for (j = 0, length = this.showStatus[i].length; j < length; j++) {
                        this.showStatus[i][j][arguments[2]] = false;
                    }
                } else {
                    this.showStatus[i] = false;
                }
            }
        }
    };

    exports.Instance = new recommendresource();
})
