/**
 * Created by pengfu on 14-7-18.
 */
;
define(function (require, exports) {


    var netdiskLesson = require('./netdisklesson').Instance;

    var ebookContext = require('../../../../app/ebookcontext').Instance;


    function MyNetDiskTpl() {

        var _self = this;
        this.isShow = false;
        this.bookContainer = null;
        this.smartBarEle = null;

        /**
         * @网盘类别
         *
         */
        var _NetDiskType = {
            /**
             * 备课本
             */
            PrepareLessonTxt: 1,
            /**
             * 授课记录
             */
            TeachingRecords: 2,
            /**
             * 我的文档
             */
            MyDocument: 3
        }

        _self.buttons = {
            myNetDiskCloseBtn: $("#myNetDiskCloseBtn")

        };

        _self.controls = {
            myNetworkDiskTplPanel: $("#myNetworkDiskTplPanel"),
            prepareLessonTxt: $("#prepareLessonTxt"),
            teachingRecord: $("#teachingRecord"),
            myDocument: $("#myDocument"),
            prepareLessonTxtPanel: $("#prepareLessonTxtPanel"),
            netdiskrecordPanel: $("#netdiskrecordPanel"),
            netdiskdocumentPanel: $("#netdiskdocumentPanel")

        };

        _self.init = function (bookContainer, smartBarEle) {
            _self.bookContainer = bookContainer;
            _self.smartBarEle = smartBarEle;
            //初始化备课本、授课记录、我的素材
            netdiskLesson.init(bookContainer);
//            netdiskRecord.init(bookContainer);
//            netdiskDocument.init(bookContainer);

            _self.controls.myNetworkDiskTplPanel.draggable({
//                handle: _self.controls.myNetworkDiskTplPanel.find('.smartbar_tit.clearfix'),
//                containment: 'parent'
                handle: _self.controls.myNetworkDiskTplPanel.find('.smartbar_tit.clearfix'),
                containment: "window"
            });

            _self.controls.prepareLessonTxt.click(function () {
                _self.controls.prepareLessonTxt.removeClass().addClass("smartbar_tab current");
                _self.controls.teachingRecord.removeClass().addClass("smartbar_tab");
                _self.controls.myDocument.removeClass().addClass("smartbar_tab");

                _self.controls.netdiskrecordPanel.hide();
                _self.controls.netdiskdocumentPanel.hide();
                netdiskLesson._reset();
                //备课本展示
                netdiskLesson.show();

                //监管
                var action = LogManager.action.trigger;
                var params = {};
                params.module = '1130607';
                var user_id = ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                LogManager.statistics(action,params);

            });

            _self.controls.teachingRecord.click(function () {
                var netdiskRecord = require('./netdiskrecord').Instance;
                _self.controls.prepareLessonTxt.removeClass().addClass("smartbar_tab");
                _self.controls.teachingRecord.removeClass().addClass("smartbar_tab current");
                _self.controls.myDocument.removeClass().addClass("smartbar_tab");

                _self.controls.netdiskdocumentPanel.hide();
                _self.controls.prepareLessonTxtPanel.hide();
                _self.controls.netdiskrecordPanel.show();
                netdiskRecord.reset();

                //监管
                var action = LogManager.action.trigger;
                var params = {};
                params.module = '1130608';
                var user_id = ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                LogManager.statistics(action,params);
                //TODO:获取json，根据json在页面上展示出结果
//                _self.displayNetDiskResource(_NetDiskType.TeachingRecords);
            });

            _self.controls.myDocument.click(function () {
                var netdiskDocument = require('./netdiskdocument').Instance;
                _self.controls.prepareLessonTxt.removeClass().addClass("smartbar_tab");
                _self.controls.teachingRecord.removeClass().addClass("smartbar_tab");
                _self.controls.myDocument.removeClass().addClass("smartbar_tab current");

                _self.controls.netdiskrecordPanel.hide();
                _self.controls.prepareLessonTxtPanel.hide();
                _self.controls.netdiskdocumentPanel.show();
                netdiskDocument.reset();

                //监管
                var action = LogManager.action.trigger;
                var params = {};
                params.module = '1130609';
                var user_id = ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                LogManager.statistics(action,params);
                //TODO:获取json，根据json在页面上展示出结果
//                _self.displayNetDiskResource(_NetDiskType.MyDocument);
            });

        };

//        this.displayNetDiskResource = function(netdisktype){
//
//            if(!netdisktype){
//                netdisktype = _NetDiskType.PrepareLessonTxt;
//            }
//            if(netdisktype == _NetDiskType.PrepareLessonTxt){
//                netdiskLesson.bookContainer = _self.bookContainer;
//                netdiskLesson.reset();
//                netdiskLesson.clearDom();
//                netdiskLesson.buildDom(true);
//            }else if(netdisktype == _NetDiskType.TeachingRecords){
//                netdiskRecord.bookContainer = _self.bookContainer;
//                netdiskRecord.reset();
//                netdiskRecord.clearDom();
//                netdiskRecord.buildDom(true);
//
//            }else{
//                netdiskDocument.bookContainer = _self.bookContainer;
//                netdiskDocument.reset();
//                netdiskDocument.clearDom();
//                netdiskDocument.buildDom(true);
//            }
//        };

        this.show = function () {
            if (!this.isShow) {
                //TODO:改变弹出框css
//                correctToBaseResolution(_self.controls.myNetworkDiskTplPanel, {keepScale: true});
                _self.controls.myNetworkDiskTplPanel.show();
                var bookContainerWidth = this.bookContainer.getContent().width(),
                    smartBarWidth = _self.controls.myNetworkDiskTplPanel.width(),
                    left = ((bookContainerWidth - smartBarWidth) / 2).toFixed(2),
                    bookContainerHeight = this.bookContainer.getContent().height(),
                    top = (bookContainerHeight -
                        this.smartBarEle.data("realHeight") -
                        _self.controls.myNetworkDiskTplPanel.height()) / 2;

                _self.controls.myNetworkDiskTplPanel.css({
                    position: "absolute",
                    left: left + "px",
                    top: "80px"
//                    margin:"10% auto"
                });
                var containerWidth = parseInt($("#bookContainer").css("width"))
                if (containerWidth < 800) {
                    correctToBaseResolution(_self.controls.myNetworkDiskTplPanel, {keepScale: true});
                    _self.controls.myNetworkDiskTplPanel.css("top", "-60px");
                    _self.controls.myNetworkDiskTplPanel.draggable({disabled:true});
                }

                _self.controls.prepareLessonTxt.removeClass().addClass("smartbar_tab current");
                _self.controls.teachingRecord.removeClass().addClass("smartbar_tab");
                _self.controls.myDocument.removeClass().addClass("smartbar_tab ");
                netdiskLesson.show();
                _self.controls.netdiskrecordPanel.hide();
                _self.controls.netdiskdocumentPanel.hide()
            }
            this.isShow = true;
        };

        this.close = function () {
            if (this.isShow) {
                _self.controls.myNetworkDiskTplPanel.hide();
            }
            this.isShow = false;
        }

    }

    exports.Instance = new MyNetDiskTpl();
});