/**
 * Created by pengfu on 14-7-23.
 */

;
define(function(require,exports){

    var NetDiskResBase = require('./netdiskbase').NetDiskResBase;
    var shellcmd = require('../../../../common/shellcmd');
    var netDiskURL = AppSvcHelper.CYSVC+'&';
    var _ebookContext = require('../../../ebookcontext').Instance;
    require('jquery');

    function NetDiskDocument(){
        var _this = this;

        this.requestDirId = {
            method      :   'pan.dirid.get',
            uid         :    _this.uId,
            folderType  :  'yun_wendang'
        };

        /**
         * 资源查看请求参数
         */
        this.requestDocumentAll = {
            method      :   'pan.dirsandfiles.list',
            uid         :    _this.uId,
            folderType  :  'yun_wendang',
            page        :   1,
            limit       :   20,
            brief       :   true
        };
        this.requestDocument = {
            method      :   'pan.file.list',
            uid         :    _this.uId,
            folderType  :  'yun_wendang',
            page        :   1 ,
            limit       :   10 ,
            thumbwidth  :  '202',
            thumbHeight :  '152',
            brief       :   true
        };
        this.requestDocumentInformation = {
            method      :   'pan.file.get',
            uid         :    _this.uId,
            folderType  :  'yun_wendang',
            brief       :   true
        };
        this.ToggleStatus=[];
        this.documentList = "";
        this.netDiskDom = $("#netdiskdocumentPanel");
        this.seekMore =  this.netDiskDom.find('.smartbar_netdisk_more');
        this.notFound =  this.netDiskDom.find('.smartbar_netdisk_not_found');
//        this.getDirId({
//            success:function(dirId){
//                _this.buildDom(true);
//            }
//        });
        this.seekMore.click(function(){
            _this.previewRequest.page++;
            _this.buildDom(false);
        });
        //事件绑定
        _this.documentEventBind();
    }
    NetDiskDocument.prototype = new NetDiskResBase();
    NetDiskDocument.prototype.constructor = NetDiskDocument;
    NetDiskDocument.prototype.reset = function(){
        var _this = this;
        this.ToggleStatus=[];
        this.documentList = "";
        _this.requestDocumentAll.extension = '';
        $(".document_typeLi").find('>a').removeClass("document_active");
        $($(".document_typeLi").find('>a')[0]).addClass("document_active");
        $("#DocumentContainer").find(">p").find("span:first").nextAll().remove();
        var _span = '<span name="documentIndex">{type}</span>';
        _span = _span.replace("{type}","全部文件");
        _this.getDirId({
            success:function(dirId){
                _this.buildDom(true);
            }
        });
        $("#DocumentContainer").find(">p").append(_span);
    };
    /**
     * 获取dirId
     * @param callback
     */
    NetDiskDocument.prototype.getDirId = function(callback){
        var _this = this;
//        var _request={};
//        $.extend(_request,_this.requestDocument);
//        _request.method = "pan.dirid.get";
        var url = netDiskURL+ $.param(_this.requestDirId);
        _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
            //网络失去连接
            if(ret == ""){
                _this.seekMore.hide();
                $.Zebra_Dialog("请先检查网络是否连接！", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [ AppTips.OkTips],
                    'zIndex': 1000
                });
                return;
            }
            console.log(ret);
            _this.requestDocument.dirId=ret;
            _this.requestDocumentAll.dirId=ret;
            $("#DocumentContainer").find("a[name='documentIndex']").attr("contend",ret);
            callback.success && callback.success();
        });
    };
    /**
     * 获取全部文件
     * @param isreload
     */
    NetDiskDocument.prototype.buildDom = function(isreload){
        var _this = this;
//        var _request={};
//        $.extend(_request,_this.requestDocumentAll);
       if( isreload ){
           _this.requestDocumentAll.page = 1;
       }else{
           _this.requestDocumentAll.page ++;
       }
//        _this.requestDocumentAll
//        _this.requestDocumentAll.brief = true;
        var url = netDiskURL+ $.param(_this.requestDocumentAll);
        _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
            //网络失去连接
            if(ret == ""){
                _this.seekMore.hide();
                $.Zebra_Dialog("请先检查网络是否连接！", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [ AppTips.OkTips],
                    'zIndex': 1000
                });
                return;
            }


            if(isreload){
                _this.documentList = ret;
            }else{
                $.merge( _this.documentList.data, ret.data);
            }

            console.log(ret)
            //把json结果render到界面上
            _this.setDocumentList(ret,isreload);
            //_this._renderRlt(ret,isreload);
            //绑定事件
          //  _this._registerEvent();
        });
    }
    /**
     * 获取分类资源列表
     * @param isreload
     */
    NetDiskDocument.prototype.getlassifyRes = function(isreload){
        var _this = this;
//        var _request={};
//         $.extend(_request,_this.requestDocument);
//        _request.method = "pan.file.list";
        if(isreload){
            _this.requestDocument.page=1;
        }else{
            _this.requestDocument.page++;
        }
        var url = netDiskURL+ $.param(_this.requestDocument);
        console.log("url:" + url );
        _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
            //网络失去连接
            if(ret == ""){
                $("#documentList").html("");
                $("#documentList").find("p[name='document_nores']").remove();
                var no_res = $('<p class="no_res01" name="document_nores">' +
                    '<img src="assert/images/no_res01.png"><br>' +
                    '<span>您的素材暂无资源</span></p>');
                $("#documentList").append(no_res);
                return;
            }
            console.log(ret);
            if(isreload){
                _this.documentList = ret;
            }else{
                $.merge( _this.documentList.data, ret.data);
            }
            //把json结果render到界面上
            _this.setDocumentList(ret,isreload);
        });
    };
    /**
     * 获取单个文件详细信息
     * @param callback
     */
    NetDiskDocument.prototype.getDocument = function(callback){
        var _this = this;
        var documentItem = callback.data;
        var index = callback.index;
        var success = callback.success;
//        var _request={};
//        $.extend(_request,_this.requestDocument);
        _this.requestDocumentInformation.fileId = documentItem.fid;
        var url = netDiskURL+ $.param(_this.requestDocumentInformation);
        console.log("url:" + url );
        _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
            console.log(ret)
            //网络失去连接
            if(ret == ""){
                $("#documentList").html("");
                $("#loadmore").hide();
                $("#documentList").find("p[name='document_nores']").remove();
                var no_res = $('<p class="no_res01" name="document_nores">' +
                    '<img src="assert/images/no_res01.png"><br>' +
                    '<span>您的素材暂无资源</span></p>');
                $("#documentList").append(no_res);
                return;
            }
           _this.documentList.data[index] = ret;
            success && success(ret);
        });
    };

    /**
     * 设置我的素材列表
     */
    NetDiskDocument.prototype.setDocumentList =function(result,isreload){
        var _this = this;
       if(isreload){
           $("#documentList").html("");
       }
        $("#loadmore").show();
        $("#documentList").find("p[name='document_nores']").remove();
        if (result.total==0) {
            var no_res = $('<p class="no_res01" name="document_nores">' +
                '<img src="assert/images/no_res01.png"><br>' +
                '<span>您的素材暂无资源</span></p>');
            $("#documentList").append(no_res);
            $("#loadmore").hide();
            return;
        }
        var data = result.data||[];
        _this.ToggleStatus=[];
        for(var j=0; j<data.length; j++){
            _this.ToggleStatus.push(false);
            var _li = $('<li name="documentItem">'+
                            '<a style="cursor:pointer;" >'+
                                '<span class="sm_gs_img"><img src="assert/images/icons/word.png" alt=""></span>'+
                                '<span class="sm_gs_text text_size_overfollow" id="title" style="height: 35px;">{title}</span>'+
                            '</a>'+
                      '</li>');
            var type = data[j].extension,
                url = _this.setDefaultPic(type);
            (!data[j].thumbpath||data[j].thumbpath.length==0) && (data[j].thumbpath = url);
            _li.attr("id", data[j].fid);
            _li.attr("contend", _this.documentList.data.length-data.length +j);
            _li.find('img').attr("src", url);
            _li.find('a').attr("title", data[j].aliasname||data[j].name);
      //      var _title = data[j].name.length >20 ? data[j].name.substr(0, 20) + "···" : data[j].name;
            _li.find(".sm_gs_text").text( data[j].aliasname||data[j].name);
            $("#documentList").append(_li);
        }
        if(_this.documentList.data.length>=_this.documentList.total) $("#loadmore").hide();
    };
    /**
     * 弹出气泡
     * @param that
     */
    NetDiskDocument.prototype.setPop = function(that){
        var _this = this;
        $("#document_pop").hide();
        var res_pop= $('<div class="re_group_block_warp re_group_block_warp_top" id="document_pop" style="z-index: 1003;">'+
            '<div class="re_group_block_con re_group_block_warp_top_con">'+
            '<dl>'+
            '<dd class="re_gr_img"><img id="document_viewImg" style="width: 132px;height: 132px;" src="assert/images/re_gr_img01.png" alt=""></dd>'+
            '<dd class="re_gr_btn clearfix">'+
            '<span id="document_viewRes">预览</span>'+
            '<span id="document_addResToBook">加入课本</span>'+
            '</dd>'+
            '</dl>'+
            '</div>'+
            '</div>');
        //    smartbar_pop.removeClass ("re_group_block_warp_top").addClass("re_group_block_warp_bot");
        //  smartbar_pop.find(">div").removeClass ("re_group_block_warp_top_con");
        $("#documentList").find("#document_pop").remove();
        var index = $(that).attr("contend");
        if(parseInt(index)%6==0) res_pop.addClass("re_g_b_w_t_left");
        if(parseInt(index)%6==5) res_pop.addClass("re_g_b_w_t_right");
        _this.ToggleStatus[index] = !_this.ToggleStatus[index];
        var documentItem = _this.documentList.data[index];
        for(var i=0;i<_this.ToggleStatus.length;i++){
            if(i==index) _this.ToggleStatus[i]=_this.ToggleStatus[index];
            else
                _this.ToggleStatus[i]=false;
        }
        if(_this.ToggleStatus[index]){
            $(that).append(res_pop);
            _this.getDocument({data:documentItem,
                           index:index,
                           success:function(documentItem){

                                $("#document_viewRes").attr("contend", index);
                                $("#document_addResToBook").attr("contend", index);
                                if (documentItem.thumbpath) $("#document_viewImg").attr("src", documentItem.thumbpath);
                                that.scrollIntoView();
                                $("#smartbar")[0].scrollIntoView(false);
                           }
            });
        }
    };
    /**
     * 素材列表事件绑定
     */
    NetDiskDocument.prototype.documentEventBind = function(){
        var _this = this;
         // ItemClick
        $(document).on("click","li[name=documentItem]",function(){
            var index = $(this).attr("contend");
            var resultData = _this.documentList.data[index];
            if(resultData.isdir)
            {
//                var _text = $("DocumentContainer").find(">p").html();
                var _a = $('<span name="documentIndex"></span>');
                _a.html(resultData.name);
                _a.attr("contend",resultData.parentfolder)
                $("#comebackToLast").attr("contend",resultData.parentfolder);
                $("#DocumentContainer").find(">p").find("span:last").append("<em></em>").append(_a);
                _this.requestDocumentAll.dirId = resultData.fid;
                _this.buildDom(true);
            }else{
                _this.setPop(this);
            }
        });
        //返回标签
        $(document).on("click","#comebackToLast",function(){
            $(this).attr("contend",$("#DocumentContainer").find(">p").find("span:last").attr("contend"));
            _this.requestDocumentAll.dirId =$(this).attr("contend");
            if($(this).attr("contend")!=""&&$(this).attr("contend")){
                $("#DocumentContainer").find(">p").find("span:last").remove();
                $("#DocumentContainer").find(">p").find("span:last").find("em").remove();
                _this.buildDom(true);
                $(this).attr("contend","");
            }
        });

        //加载更多资源按钮
        $(document).on("click","#loadmore",function(){
            var content_type = $(".document_active").parent().attr("content_type");
            switch (content_type) {
                case 'audio':
                    _this.requestDocument.extension = 'mp3,wma,wav,ogg,ape,mid,midi';
                    break;
                case 'video':
                    _this.requestDocument.extension= 'mp4,3gp,asf,avi,rmvb,mpeg,wmv,rm,mpeg4,mov,flv,vob,mkv';
                    break;
                case 'image':
                    _this.requestDocument.extension= 'jpg,jpeg,bmp,png,gif';
                    break;
                case 'document':
                    _this.requestDocument.extension = 'doc,docx,xls,xlsx,ppt,pptx,pps,ppsx,txt,rtf';
                    break;
                case 'mutual':
                    _this.requestDocument.extension = 'icw';
                    break;
                case 'other':
                    _this.requestDocument.extension = 'other';
                    break;
                case 'all':
                {
                    _this.requestDocument.extension = '';
                    _this.buildDom(false);
//                    _this.getDirId({
//                        success:function(dirId){
//                            _this.buildDom(false);
//                        }
//                    });
                    return;
                }
            }
            _this.getlassifyRes(false);
        });

        //资源分类标签事件绑定
        $(document).on("click",".document_typeLi",function(){
            $("#comebackToLast").attr("contend","");
            $(".document_typeLi").find('>a').removeClass("document_active");
            $(this).find(">a").addClass("document_active");
            var content_type = $(this).attr("content_type");
            $("#DocumentContainer").find(">p").find("span:first").nextAll().remove();
            var _span = '<span name="documentIndex">{type}</span>';
            switch (content_type) {
                case 'audio':
                    _this.requestDocument.extension = 'mp3,wma,wav,ogg,ape,mid,midi';
                    _span = _span.replace("{type}","音频");
                    break;
                case 'video':
                    _this.requestDocument.extension= 'mp4,3gp,asf,avi,rmvb,mpeg,wmv,rm,mpeg4,mov,flv,vob,mkv';
                    _span = _span.replace("{type}","视频");
                    break;
                case 'image':
                    _this.requestDocument.extension= 'jpg,jpeg,bmp,png,gif';
                    _span = _span.replace("{type}","图片");
                    break;
                case 'document':
                    _this.requestDocument.extension = 'doc,docx,xls,xlsx,ppt,pptx,pps,ppsx,txt,rtf';
                    _span = _span.replace("{type}","文档");
                    break;
                case 'mutual':
                    _this.requestDocument.extension = 'icw';
                    _span = _span.replace("{type}","畅言课件");
                    break;
                case 'other':
                    _this.requestDocument.extension = 'other';
                    _span = _span.replace("{type}","其它");
                    break;
                case 'all':
                {
                    _this.requestDocument.extension = '';
                    console.log( _this.requestDocument);
                    _span = _span.replace("{type}","全部文件");
                    $("#DocumentContainer").find(">p").append(_span);
                    _this.getDirId({
                        success:function(dirId){
                            _this.buildDom(true);
                        }
                    });
                    return;
                }
            }
            $("#DocumentContainer").find(">p").append(_span);
            _this.getlassifyRes(true);
        });
        //资源预览
        $(document).on("click","#document_viewRes",function(){
              var   index = $(this).attr("contend"),
                resultData = _this.documentList.data[index],
                type = resultData.extension,
                url = resultData.previewpath;
            $("#document_pop").remove();
            resultData.resFrom = "myDocument";
            resultData.id = resultData.fid;
            resultData.fileurl = resultData.downloadpath;
            resultData.title = resultData.aliasname;
            resultData.thumbpath?(resultData.thumburl = resultData.thumbpath):(resultData.thumburl ="");
            resultData.creator = decodeURI(_ebookContext.getUser()._userName)||_ebookContext.getUser()._name||"";
            _this.ToggleStatus[index] = ! _this.ToggleStatus[index];
            _this.previewRes(type, url,resultData);
            event.stopPropagation();
            return false;
        });
        //加入课本
        $(document).on("click","#document_addResToBook",function(){
            var index = $(this).attr("contend"),
                resultData =_this.documentList.data[index];
            resultData.resFrom = "myDocument";
            resultData.id = resultData.fid;
            resultData.fileurl = resultData.downloadpath;
            resultData.title = resultData.aliasname;
            resultData.thumbpath?(resultData.thumburl = resultData.thumbpath):(resultData.thumburl ="");
           console.log(_ebookContext.getUser())
            resultData.creator = decodeURI(_ebookContext.getUser()._userName)||_ebookContext.getUser()._name||"";
            newWidgetPos = null;
            $("#document_pop").remove();
            _this.ToggleStatus[index] = ! _this.ToggleStatus[index];

            _this.downLoadFile(resultData);
            event.stopPropagation();
            return false;
        });
        //推荐资源拖拽下载
        $(document).on("dragend","#documentList li",function(e){
            var index = $(this).attr("contend"),
                resultData =_this.documentList.data[index];
            _this.getDocument({data:resultData,
                index:index,
                success:function(documentItem){
                    resultData = documentItem;
                    resultData.resFrom = "myDocument";
                    console.log(resultData);
                    resultData.id = resultData.fid;
                    resultData.fileurl = resultData.downloadpath;
                    resultData.title = resultData.aliasname;
                    resultData.creator = decodeURI(_ebookContext.getUser()._userName)||_ebookContext.getUser()._name||"";
                    resultData.thumbpath?(resultData.thumburl = resultData.thumbpath):(resultData.thumburl="");
                    newWidgetPos = {
                        left : e.originalEvent.clientX,
                        top : e.originalEvent.clientY
                    }
                    resultData && _this.downLoadFile(resultData);
                    event.stopPropagation();
                    return false;
                }
            });
            event.stopPropagation();
            return false;
        });
    };
    exports.Instance = new NetDiskDocument();

});