/**
 * Created by linwang5@iflytek.com on 2016/9/26.
 * 同步精选资源上次到资源网关
 */

;
define(function (require, exports, module) {
    require('jquery');
    var ebookContext = require('../../../app/ebookcontext').Instance;
    var shellcmd = require('../../../common/shellcmd');
    var crypto = nodereq('crypto');
    var fs = nodereq('fs');
    var uploadTag = 'syncRecommend_upload';
    var listInfo = {};
    var userInfo = null;
    var uliDat = process.execPath.replace('nw.exe', 'uli.dat');
    var _creator = "畅言教育";

    /**
     * 获取文件的MD5
     * @param filepath
     * @returns {*}
     * @private
     */
    function _getFileMd5(filepath) {
        //读取一个Buffer
        var buffer = fs.readFileSync(filepath);
        var fsHash = crypto.createHash('md5');

        fsHash.update(buffer);
        var md5 = fsHash.digest('hex');
        return md5;
    }

    /**
     * 查重资源网关
     */
     function _check_ersp(res){
        var def = jQuery.Deferred();
        if(res.md5){
            var p= {
                book:res.SYNC_bookMetaInfo.bookCode,
                md5:res.md5,
                unit1:res.SYNC_unitInfo.unit1 || "",
                unit2:res.SYNC_unitInfo.unit2 || "",
                unit3:res.SYNC_unitInfo.unit3 || "",
                unit4:res.SYNC_unitInfo.unit4 || "",
                topic:"08",
                type:"", //素材0300
                source:"IFLYTEK,UGC,MAISUI,RENJIAOJIAOFU,KXX,GUOJIA,CHANGYAN",
                auditstatus:"1"
                //tag:"" TODO::同步精选资源字段名称待确认
            }
            edcService.Instance().ersp_resource_list(p).done(function(ret){
                def.resolve(ret);
            }).fail(function(e){
                console.log(e);
            });
        }
        return def.promise();
     }
     /**
     * 查重同步精选
     */
     function _check_eshop(res){
        var def = jQuery.Deferred();
        if(res.md5){
            var p= {
                book:res.SYNC_bookMetaInfo.bookCode,
                md5:res.md5,
                bookPage:res.curPage,
                positionX:res.Left,
                positionY:res.Top,
            }
            edcService.Instance().ersp_resource_perfect_list(p).done(function(ret){
                def.resolve(ret);
            }).fail(function(e){
                console.log(e);
            });
        }
        return def.promise();
     }
     /**
     * 查重所有
     */
     function _check_all(res){
        var _this = this;
        _check_eshop(res).done(function(ret){
            if(ret && ret.code==0){
                if(ret.data.data.length>0){
                    _checkUploadCount(true);
                }else{
                    _check_ersp(res).done(function(ret1){
                        if(ret1 && ret1.code==0){
                            console.log(ret1);
                            if (ret1.data.data.length>0) {
                                _saveToEshop(res,ret1.data.data[0].id);
                            }else{
                               //_this.pre_upload(res);
                               _prepareUpload(res);
                               //console.log(res);
                            }
                        }else{
                            console.log("请求失败！");
                        }
                    }).fail(function(e){
                        console.log(e);
                    });
                }
            }else{
                console.log("请求失败！");
            }
        }).fail(function(e){
            console.log(e);
        });
     }

    /**
     * 保存到资源网关
     * @param _data
     * @private
     */
    function _saveToErsp(_data) {
        var single = listInfo.list[_data.id];
        edcService.Instance().ersp_resource_metadata_book_get({bookCode:single.SYNC_bookMetaInfo.bookCode}).done(function (result) {
            if(!result||result.code !=0 ) {
                _checkUploadCount(false);
                return;
            }

           var bookInfo = result.data.data;
            var fileInfo = {
                creator:_creator,
                extension:single.extension,
                uploader:_data.loginName,
                properties:{
                    rrtlevel1:['08'],
                    phase:bookInfo.properties.phase,
                    book:bookInfo.properties.book,
                    edition:bookInfo.properties.edition,
                    grade:bookInfo.properties.grade,
                    stage:bookInfo.properties.stage,
                    subject:bookInfo.properties.subject,
                    type:[],
                    unit1:[single.SYNC_unitInfo.unit1],
                    unit2:[single.SYNC_unitInfo.unit2],
                    unit3:[single.SYNC_unitInfo.unit3],
                    unit4:[single.SYNC_unitInfo.unit4],
                    volumn:bookInfo.properties.volume,
                    tag:["11"] //"11":同步精选
                },
                title:single.Title,
                source:'iflytek',
                description:single.description,
                quality:'20',
                language:'zh-CN',
                action:'',
                module:'',
                lifecycle:{
                    securitystatus:1,
                    auditstatus:1,
                    dependencystatus:1
                }
            }
            var fileIndex = {
                md5:single.md5,
                filePath:_data.realUrl,
                length:single.size,
                filename:single.Title
            }

            var p = {
                fileInfo:JSON.stringify(fileInfo),
                fileIndex:JSON.stringify(fileIndex),
                auditStatus:1
            }

            edcService.Instance().ersp_resource_importResourceInfo(p).done(function (ret) {
                if(ret&&ret.code==0){
                    _saveToEshop(_data,ret.data.data);
                }else {
                    _checkUploadCount(false);
                }
            }).fail(function () {
                _checkUploadCount(false);
            });



        }).fail(function (e) {
            _checkUploadCount(false);
        });


    }

    /**
     * 保存到eshop
     * @param data
     * @private
     */
    function _saveToEshop(single,resIdFromErsp) {
        var p =[];
        var date = new Date()
        //var updatetime = date.Format('yyyy-MM-dd hh:mm:ss');
        if(single.act == "update"){
            var u = {
                rid:single.rid,
                book:ebookContext.curBookCode,
                bookPage:single.curPage,
                resourceId:resIdFromErsp,
                resourceName:single.File,
                positionX:single.Left,
                positionY:single.Top,
                md5:single.md5,
                reserve1:0,
                updateTime:date || ""
             };
             edcService.Instance().ersp_resource_perfect_update(u).done(function (ret) {
                if(ret&&ret.code==0&&(ret.data.data==true||ret.data.data=='true')){
                    hideLoading();
                    tipsDialog({id:_getRandomString(),content:'更新完成'});
                    $(document).trigger("update_toSelected");
                } else{
                    hideLoading();
                   tipsDialog({id:_getRandomString(),content:'更新失败'});
                } 
            }).fail(function () {
                hideLoading();
                tipsDialog({id:_getRandomString(),content:'更新失败'});
            });
        }else{
            p[0] ={
                book:ebookContext.curBookCode,
                bookPage:single.curPage,
                resourceId:resIdFromErsp,
                resourceName:single.File,
                positionX:single.Left,
                positionY:single.Top,
                createId:userInfo.id,
                md5:single.md5,
                updateTime:date || ""
            };
            var s = {
                bookResourceJson:JSON.stringify(p),
            };
            edcService.Instance().ersp_resource_perfect_add(s,{type:'POST'}).done(function (ret) {
                if(ret&&ret.code==0&&(ret.data.data==true||ret.data.data=='true')){
                    _checkUploadCount(true);
                    $(document).trigger("upload_toSelected");
                } else{
                   _checkUploadCount(false); 
                } 
            }).fail(function () {
                _checkUploadCount(false);
            });
        }        

    }
    /**
     * 接收真实上传的回调信息,完成 后进行相应的处理
     * @param _data
     */
    function onReceiveMessage(_data) {
        if (_data.source == uploadTag && _data.process == 100) {
            var s = {
                platForm: _data.appKey,
                contextId: _data.contextId
            };
            edcService.Instance().pan_file_upload_complete(s).done(function (ret) {
                if (ret && ret.code == 0) {
                    _saveToErsp(_data);
                }else {
                    _checkUploadCount(false);
                }
            }).fail(function (e) {
                _checkUploadCount(false);
            });
        } else if (_data.source == uploadTag && _data.process == -1) {
            _checkUploadCount(false);
        } else {
            //process
        }
    }

    /**
     * 生成随机长度的字符串
     * @param len 生成的长度 可选 未传则生成32的
     * @private
     */
    function _getRandomString(len) {
        var len = len || 32;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
        var maxPos = $chars.length;
        var pwd = '';
        for (var i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd.toLowerCase();
    }

    function _checkUploadCount(one) {
        if(one) listInfo.success++;
        else listInfo.fail++;
        if(listInfo.success+listInfo.fail){
            hideLoading();
            tipsDialog({id:_getRandomString(),content:'上传完成，成功'+listInfo.success+'个，失败'+listInfo.fail+'个'});
        }
    }


    /**
     * 获取用户信息
     * @param callback 回调
     */
    function getUserInfo(callback) {
        if (userInfo) callback(userInfo);
        else {
            shellcmd.readFileAsync(uliDat).done(function (ret) {
                userInfo = JSON.parse(ret);
                callback(userInfo);
            })
        }
    }

    /**
     * 调用预上传接口
     * @param params
     * @private
     */
    function _prepareUpload(params) {
        console.log("%c开始预上传", 'color:blue');
        getUserInfo(function (userInfo) {
            var p = {
                openId: userInfo._sso_openId,
                extension: params.extension,
                chunks: 1,
                platForm: window.Base_Cfg.Platform,
                callbackParams:_getRandomString(16)
            };
            edcService.Instance().pan_file_resource_prepare(p).done(function (ret) {
                if (ret && ret.code == 0) {
                    _uploadActSend(params, ret.data.prepareInfo,userInfo.loginName);
                } else {
                    _checkUploadCount(false);
                }
            }).fail(function (e) {
                _checkUploadCount(false);
            });
        });

    }

    /**
     * 根据预上传返回的host和其他参数开始正式上传,此时为发送socket消息
     * @param params
     * @param prepareInfo
     * @param loginName
     * @private
     */
    function _uploadActSend(params, prepareInfo,loginName) {
        var uploadChunck = prepareInfo.uploads[0];
        var data = {
            id: params.wbId,
            curPage:params.curPage,
            File:params.File,
            Left:params.Left,
            Top:params.Top,
            act:params.act || "",
            rid:params.rid || "",
            md5:params.md5,
            multi: 1,
            url: uploadChunck.host,
            realUrl:prepareInfo.url,
            appKey: uploadChunck.params.appKey,
            contextId: uploadChunck.params.contextId,
            expires: uploadChunck.params.expires,
            token: uploadChunck.params.token,
            file: params.src,
            key: 'file',
            source: uploadTag,
            loginName:loginName,
            extra: {
                appKey: uploadChunck.params.appKey,
                contextId: uploadChunck.params.contextId,
                expires: uploadChunck.params.expires,
                token: uploadChunck.params.token
            }

        };
        var obj = {
            "type": 'logic',
            "action": 'ta_upload',
            "from": 'ib',
            "to": 'ta_dum',
            "id": params.wbId,
            "data": data
        };
        socket.send(obj);
    }



    function init(curpageRes,curPage,bookMetaInfo,unitInfo,act) {
        var list = [];
        var length=0;
        for(var i=0,l=curpageRes.length;i<l;i++){
            var path = curpageRes[i].src;
            var id = _getRandomString();
            curpageRes[i].md5 = _getFileMd5(path);
            curpageRes[i].size = fs.statSync(path).size;
            curpageRes[i].extension = path.substr(path.lastIndexOf('.')+1);
            curpageRes[i].wbId = id;
            curpageRes[i].curPage = curPage;
            curpageRes[i].act = act || "";
            curpageRes[i].SYNC_bookMetaInfo = bookMetaInfo,
            curpageRes[i].SYNC_unitInfo = unitInfo,
            list[id] = curpageRes[i];
            length++;
        }
        listInfo = {
            list:list,
            length:length,
            success:0,
            fail:0
        };
        if(listInfo.length==0){
            tipsDialog({id:_getRandomString(),content:'无上传的资源'});
            return;
        }
        if(act == "update"){
            showLoading({tips:'正在更新资源,请稍候……'}); 
        }else{
            showLoading({tips:'正在上传'+listInfo.length+'个资源,请稍候……'});
        }
        getUserInfo(function(userInfo){
            userInfo =userInfo;
        });
        for(var key in listInfo.list){
            //console.log(listInfo.list[key]);
            _check_all(listInfo.list[key])
            //_prepareUpload(listInfo.list[key]);
        }
    }

    exports.init = init;
    exports.onReceiveMessage = onReceiveMessage;
});

