define(function(require, exports, module){
    require('jquery');
    require('browserContext');
    var _define = require('../../define'),
        _cloudresourceBase = require('./cloudresourcebase'),
        // _dragsort = require('./jquery.dragsort-0.5.1.min'),
        _ebookContext = require('../../ebookcontext').Instance,
        _mainToolbar = require('../toolbar/maintoolbar'),
        _shellcmd = require('../../../common/shellcmd'),
        path = require('../../../common/path'),
        _resTool = require('./restool'),
        fs =  nodereq("fs");

    function TeachingPackage() {
        var _this = this;
        _this.buttons = {};
        _this.controls = {};
        _this.bookContainer = "";
        _this.widgetArr = [];
        //授课包列表数据
        _this.teachingPackageList = {
            "current" :{
                origin: [],
                data: [],
                total: 0
            },
            "downloading":{
                origin: [],
                data: [],
                total: 0
            }
        };
        //授课包排序数据
        // [{"page":"1","widgets":[{"index":"1","fileId":""}]},{"page":"2","widgets":[]}]
        _this.widgetSortList = [];

        /**
         * 授课包排序数据（按单元组织数据）
         * isSync:是否已同步
         * [{"unit1":"1","unit2":"2","unit3":"3","unit4":"4",isSync:false,"widgets":[{"index":"1","fileId":""}]},{"unit1":"5","unit2":"6","unit3":"7","unit4":"8",isSync:false,"widgets":[]}]
         */
        _this.widgetSortListByUnit = [];
        /**
         * 显示下载中数据的模式 enume('default','single')
         * single:下载中资源按页显示在授课包列表中
         * default:下载中资源一直显示在授课包列表中)
         */
        _this.showDownloadingMode = 'single';
    }

    TeachingPackage.prototype = new _cloudresourceBase();

    TeachingPackage.prototype.init = function(bookContainer,buttons,controls){
        var _this = this;
        _this.bookContainer = bookContainer;
        _this.buttons = {
            selectedBtn: $("#J_selected"),
            recommmendBtn: $("#J_recommend"),
            lessonPrepareBtn: $("#J_lessonprepare"),
            localPrepareBtn: $("#J_localprepare"),
            cloudPrepareBtn: $("#J_cloudprepare"),
            leftWidgetsBtn: $("#J_teaching_package_lbtn"),
            rightWidgetsBtn: $("#J_teaching_package_rbtn"),
            btnResCenter: $("#J_res_center")
        };
        _this.controls = {
            tabBar: $(".J_resource_center_bar .tabbar"),
            selectedContainer: $(".J_selected_content"),
            recommmendContainer: $(".J_recommend_content"),
            lessonPrepareContainer: $(".J_lesssonprepare_content"),
            localPrepareContainer: $(".J_localprepare_content"),
            cloudPrepareContainer: $(".J_cloudprepare_content"),
            teachingPackageContainer: $(".J_teaching_package_content"),
            widgetsContent: $(".J_teaching_package_content"),
            leftWidgetsContent: $(".J_teacking_package_left_content"),
            rightWidgetsContent: $(".J_teacking_package_right_content")
        };
        _this.registerEvent();
        _this.getWidgets();
    };

    TeachingPackage.prototype.registerEvent = function() {
        var _this = this;
        var observer = new MutationObserver(function(mutations){
            if(typeof $("[name=sort_content] ul").data("listidx") == "undefined"){
                // $("#sortUl ul").dragsort({
                //     dragSelector: 'li',
                //     dragSelectorExclude: "a",
                //     scrollSpeed: 0,
                //     placeHolderTemplate: "",
                //     //placeHolderTemplate: '<li class="draging-place">&nbsp;</li>',
                //     dragEnd: function (e) {
                //         //temp eshop监管 linwang5@iflytek.com
                //         var staticParams = {
                //             uid:_ebookContext._curUser._uid,
                //             module:'02004',
                //             type:'trigger'
                //         };
                //         edcService.Instance().api_eshop_baseStatics(staticParams);
                //         $(this).removeAttr('draged');
                //         $(this).trigger("uidragend");
                //         event.stopPropagation();
                //         event.preventDefault();
                //     }
                // });
                // $('#sortUl li b').click(function () {
                //     $(this).parent().remove();
                // });
                //这部分使用jqueryUI的 sortable组件，废弃使用dragsort组件
                $("#sortUl").sortable({
                    axis : 'y',
                    items: "li",
                    containment : "#sortUl",
                    distance : 5,
                    cancel : "a,input,textarea,button,select,option",
                    connectWith : false,
                    dropOnEmpty : false,
                    cursor : "move",
                    cursorAt : {top:26,left:102},
                    revert : true,
                    start : function(event, ui){
                        if(ui && ui.item) {
                            $(ui.item).attr('draged', 'true');
                        }
                    },
                    stop : function(event, ui){
                        //temp eshop监管 linwang5@iflytek.com
                        var staticParams = {
                            uid:_ebookContext._curUser._uid,
                            module:'02004',
                            type:'trigger'
                        };
                        edcService.Instance().api_eshop_baseStatics(staticParams);
                        if(ui && ui.item) {
                            $(ui.item).removeAttr('draged');
                        }
                        if(json.TP.useDb){
                            $(document).trigger("uiDragendByUnit");
                        }else{
                            $(document).trigger("uidragend");
                        }
                    }
                });
                $( "#sortUl" ).disableSelection();
            }
        });
        observer.observe($("[name=sort_content]")[0], {
            childList: true
        });
        //拖动后资源更新列表资源序号
        $(document).on("uidragend",function (e) {
            var sourceArr = $("#sortUl").find("li");
            for (var idx = 0; idx < sourceArr.length; idx++) {
                $(sourceArr[idx]).find(".format-number").text(idx + 1);
            }
            var currPageSortedWidgets = [];
            var sourceArr = $("#sortUl").find("li");
            var sourceIdxArr = [];
            for (var i = 0; i < sourceArr.length; i++) {
                var item = {
                    "index": i + 1,
                    "fileId":$(sourceArr[i]).data("file")
                }
                sourceIdxArr.push(item);
            }
            var currPage = _this.bookContainer.getPageIndex();
            var pages = [currPage,currPage+1];
            for(var i = 0,pageCount = pages.length; i < pageCount; i++) {
                var page = pages[i];
                _this.setSortedData(page,sourceIdxArr);
            }
            //保存到文件
            // _this.saveWidgetSortData(_this.widgetSortList);
            _this.getWidgets();
        });

        $(document).on("uiDragendByUnit",function (e) {
            var sourceArr = $("#sortUl").find("li");
            // for (var idx = 0; idx < sourceArr.length; idx++) {
            //     $(sourceArr[idx]).find(".format-number").text(idx + 1);
            // }
            var currUnitSortedWidgets = [];
            var unitWidgetSort = [];
            for (var i = 0; i < sourceArr.length; i++) {
                var item = {
                    "index":  i + 1,
                    "fileId": $(sourceArr[i]).data("fileid"),
                    "id": $(sourceArr[i]).data("uuid")
                }
                unitWidgetSort.push(item);
            }

            var currPage = _this.bookContainer.getPageIndex();
            var currUnit = _this.bookContainer.getPageMetadata(currPage);
            _this.setSortedDataByUnit(currUnit,unitWidgetSort);
            _this.getWidgets();


            // var currPageSortedWidgets = [];
            // var sourceArr = $("#sortUl").find("li");
            // var sourceIdxArr = [];
            // for (var i = 0; i < sourceArr.length; i++) {
            //     var item = {
            //         "index": i + 1,
            //         "fileId":$(sourceArr[i]).data("file")
            //     }
            //     sourceIdxArr.push(item);
            // }
            // var currPage = _this.bookContainer.getPageIndex();
            // var pages = [currPage,currPage+1];
            // for(var i = 0,pageCount = pages.length; i < pageCount; i++) {
            //     var page = pages[i];
            //     _this.setSortedData(page,sourceIdxArr);
            // }
            // //保存到文件
            // // _this.saveWidgetSortData(_this.widgetSortList);
            // _this.getWidgets();
        });

        $(document).on("click","#J_teaching_package_lbtn",function(e){
            _this.getWidgets();
            //右侧授课包状态
            $(".drawer-right").find(".J_drawer_content").hide();
            $("#J_teaching_package_rbtn").find(".J_hidden").hide();
            $("#J_teaching_package_rbtn").find(".J_show").show();

            $(".drawer-left").find(".J_drawer_content").toggle();
            if($("#J_teaching_package_lbtn").find(".J_show").is(":hidden")){
                $("#J_teaching_package_lbtn").find(".J_hidden").hide();
                $("#J_teaching_package_lbtn").find(".J_show").show();
            }else{
                var staticParams = {
                    uid:_ebookContext._curUser._uid,
                    module:'01013',
                    type:'trigger'
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
                $("#J_teaching_package_lbtn").find(".J_show").hide();
                $("#J_teaching_package_lbtn").find(".J_hidden").show();
            }
        });

        $(document).on("click","#J_teaching_package_rbtn",function(e){
            _this.getWidgets();
            //左侧授课包状态
            $(".drawer-left").find(".J_drawer_content").hide();
            $("#J_teaching_package_lbtn").find(".J_hidden").hide();
            $("#J_teaching_package_lbtn").find(".J_show").show();

            $(".drawer-right").find(".J_drawer_content").toggle();
            if($("#J_teaching_package_rbtn").find(".J_show").is(":hidden")){
                $("#J_teaching_package_rbtn").find(".J_hidden").hide();
                $("#J_teaching_package_rbtn").find(".J_show").show();
            }else{
                var staticParams = {
                    uid:_ebookContext._curUser._uid,
                    module:'01013',
                    type:'trigger'
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
                $("#J_teaching_package_rbtn").find(".J_show").hide();
                $("#J_teaching_package_rbtn").find(".J_hidden").show();
            }
        });

        //收到下载成功通知
        $(document).on("downloadSign",function(){
            _this.getWidgets();
        });

        //课堂模式切换监听-上课/下课
        $(document).on("classMode",function(e,param){
            //上课和下课模式切换刷新上课授课包
            _this.getWidgets();
        });
        $(_this.bookContainer).bind('bookViewChanged',function(){
            //单双页切换
            _this.getWidgets();
        });
        //某一个widget被加载到页面
        $(document).on("widgetLoaded",function (e,param) {
            //重置页面widget数据
            if(param && param.action == "reset") {
                if(json.TP.useDb){
                    _this.widgetSortListByUnit = [];
                    _this.saveWidgetSortDataByUnit(_this.widgetSortListByUnit);
                }else{
                    _this.widgetSortList = [];
                    _this.saveWidgetSortData(_this.widgetSortList);
                }
            }
            _this.getWidgets();
        });
        //页面卸载时保存文件
        $(document).on("pageItemUnload",function () {
            //排序文件保存到文件
            if(json.TP.useDb){
                _this.saveWidgetSortDataByUnit(_this.widgetSortListByUnit);
            }else{
                _this.saveWidgetSortData(_this.widgetSortList);
            }
        });
        //课本资源移动后重写排序文件（该事件废弃）
        // $(document).on("writeSortFile",function () {
        //    // _this.writeSortFile();
        // });
        $(document).on("insertWidgetSuccess",function(e,param){
            //添加文件到授课包刷新页面
            _this.getWidgets();
            var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
            _mainToolbar.setIsTeachingPackage(isTeachingPackage);
            //渲染已下载文件样式
            if(param && param.id) {
                _this.renderDownloadedStyle(param.id);
            }
        });
        $(document).on("importDeleteWidget",function(e,param){
            if(json.TP.useDb){
                var widget_id = param.id;
                var widget_file = param.file;
                var pageIndex = param.pageIndex;
                //删除授课包文件
                var units = _this.bookContainer.getPageMetadata(pageIndex);
                _this.deleteSortDataByUnit(units,widget_id);
            }
        });
        $(document).on("importGetWidget",function(e){
            _this.getWidgets();
        });
        $(document).on("deleteWidgetSuccess",function(e,param){
            if(json.TP.useDb){
                var widget_id = param.id;
                var widget_file = param.file;
                var pageIndex = param.pageIndex;
                //删除授课包文件
                var units = _this.bookContainer.getPageMetadata(pageIndex);
                _this.deleteSortDataByUnit(units,widget_id);
                _this.getWidgets();
            }else{
                var widget_id = param.id;
                var widget_file = param.file;
                //删除授课包文件
                _this.deleteSortData(_this.bookContainer.getPageIndex(),widget_id);
                _this.getWidgets();
            }
        });
        //根据当前授课包状态设置删除按钮状态
        $(document).on("setTeachingPacakge",function(){
            var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
            _mainToolbar.setIsTeachingPackage(isTeachingPackage);
        })

        $(document).on("refreshTeachingPackageNum",function(e,param){
            _this.getWidgetsTotal().done(function(num){
                _this.renderTeachingPackageNum(num);
            });
        });
        /**
         * 这部分因为实现了了jquery sortable组件，以下方法可以不用了
         * mousemove 和 mousedown;这里通过给dom增加属性，判断区分li mouseup时，是否点击操作mouseup或者拖动组件dragEnd前触发的mouseup
         */
        // $(document).on("mousemove",'#sortUl li',function(){
        //     $(this).attr('draged','true');
        // });
        // $(document).on("mousedown",'#sortUl li',function(){
        //     $(this).removeAttr('draged');
        // });
        //点击文件列表，出现预览框
        /**
         * 在这里用mouseup事件是 原因
         * 1.在canvasmgr.js(75行注册的GlobalListen函数)
         * 中有个全局坚挺的mousedown事件的监听，阻止了click时间的发生，
         * 2.click 包含了 mousedown mouseup todo:这块代码还有些问题，请自查一下 @王瑞
         * created by linwang5@iflytek.com 2016-09-27 21:09
         */
        $(document).on("click","#sortUl li",function () {
            var dom = $(this);
            if($(this).attr("draged") == "true"){
                return false;
            }
            if(json.TP.useDb){
                var uuid = $(this).attr("data-uuid");
                _this.bookContainer.getCurrentLessonRes().done(function(currLessonRes){
                    //用户选择的授课包数据
                    var selected = {};
                    var findWidget = currLessonRes.filter(function (el) {
                        return el.uuid == uuid;
                    });
                    if(findWidget.length == 1){
                        selected =  findWidget[0] || {};
                        var needJump = false;
                        var currPage = parseInt(_this.bookContainer.getPageIndex());
                        var pageIndex = parseInt(selected.pageIndex);
                        if(pageIndex){
                            if(_this.bookContainer.getPageViewType() == _define.PageViewType.SimpleDoublePage){
                                if(-1 == $.inArray(pageIndex,[currPage,currPage + 1])){
                                    needJump = true;
                                }
                            }else{
                                if(pageIndex != currPage){
                                    needJump = true;
                                }
                            }
                        }

                        if(!needJump && 1 == selected._packedFlag){
                            console.warn('openPreviewFrame success');
                            console.warn(selected);
                            // 便签单独处理 -by xinfang3
                            if(selected.WidgetType == "note"){
                                selected.resourcePreview();
                            }else {
                                selected.showEdit(dom, selected);
                            }
                        }else{
                            if(needJump){
                                _this.bookContainer.setPageIndex(parseInt(pageIndex));
                                $(document).data('openPreviewFrame',{uuid:uuid});
                                $(document).one('openPreviewFrame',{uuid:uuid},function(event){
                                    var uuid = event.data && event.data.uuid || '';
                                    if(uuid){
                                        var dom = $('#sortUl').find("li[data-uuid = " + uuid + "]");
                                        if(dom.length > 0){
                                            var s = dom.find(".format-number").text();
                                            console.log('handle openPreviewFrame,序号' + s);
                                            $(dom).trigger('click');
                                        }else{
                                            console.warn('跳转后在授课包列表里未找到指定序号的DOM');
                                        }
                                        $(document).removeData('openPreviewFrame');
                                        $(document).off('openPreviewFrame');
                                    }
                                });
                                console.log('资源不在当前视图，需要转页');
                            }else{
                                // 流程不会被执行到这里，视图上的widget全部都会被实例化
                                console.log('资源在当前视图，但该资源没有被实例化');
                            }
                        }
                    }else{
                        console.log('widget不属于该课，暂不作处理');
                    }
                }).fail(function(e){
                    console.log(e);
                });
            }else{
                //widgetArr 由widget 工厂方法产生，带了各种对widget的操作方法
                var fileId = $(this).attr("data-fileid");
                var file = $(this).attr("data-file");
                //用户选择的授课包数据
                var selected = {};
                var findWidget = _this.widgetArr.filter(function (el) {
                    return el.Id == fileId;
                });
                //id能匹配
                if(findWidget.length == 1){
                    selected = findWidget[0];
                }
                //id重复，再次筛选
                if(findWidget.length == 2){
                    var findWidget_file = _this.widgetArr.filter(function (el) {
                        //解析文件 默认后缀名取 data.File
                        var fileNameParse = _resTool.parseFileName(el.File);
                        //兼容某些File数据不带文件后缀名 解析 data.Title
                        if(fileNameParse.fileExt == ""){
                            var fileNameParse = _resTool.parseFileName(el.Title);
                        }
                        var file_title = fileNameParse.file;
                        return el.Id == fileId && file_title == file;
                    });

                    if(findWidget_file.length == 1){
                        selected = findWidget_file[0];
                    }else{
                        //再次筛选时不能匹配数据,取默认（id匹配）第一个
                        selected = findWidget[0];
                    }
                }

                if(!$.isEmptyObject(selected)){
                    // 便签单独处理 -by xinfang3
                    if(selected.WidgetType == "note"){
                        selected.resourcePreview();
                    }else {
                        selected.showEdit($("#" + fileId), selected);
                    }
                }
            }
            return false;
        });

        $(document).on('mouseover',".format-bignumber", function(event){
            var isHavingClass = _mainToolbar.getIsHavingClass();
            var isTeachingPackage=_mainToolbar.getIsTeachingPackage();

            if(!isHavingClass && isTeachingPackage) {
                var _dom = $(this).parent();
                var uuid = _dom.data("uuid");
                if(uuid){
                    var findWidget = _this.widgetArr.filter(function (el) {
                        if (1 == el._packedFlag) {
                            return el.uuid == uuid;
                        } else {
                            return false;
                        }
                    });
                    if (findWidget.length > 0) {
                        var Obj = _ebookContext.getUnTransForm();
                        var findLi = _this.controls.teachingPackageContainer.find("[data-uuid='" + uuid + "']");
                        // 简单判断课本资源是否在授课包列表里
                        if(findLi.length > 0){
                            _dom.find(".format-bignumber").css("-webkit-transform", "matrix(" + (1 * Obj.wZoom) / (Obj.wZoom * 0.7) + ", 0, 0, " + (1 * Obj.hZoom) / (Obj.hZoom * 0.7) + ", 0, 0)");
                            $(findLi).css({
                                'color': '#4b99f0',
                                'background': '#e9eff2'
                            });
                            return false;
                        }
                    }
                }
            }
        }).on('mouseout',".format-bignumber", function(event){
            var isHavingClass = _mainToolbar.getIsHavingClass();
            var isTeachingPackage=_mainToolbar.getIsTeachingPackage();

            if(!isHavingClass && isTeachingPackage) {
                var _dom = $(this).parent();
                var uuid = _dom.data("uuid");

                if(uuid){
                    var findWidget = _this.widgetArr.filter(function (el) {
                        if (1 == el._packedFlag) {
                            return el.uuid == uuid;
                        } else {
                            return false;
                        }
                    });
                    if (findWidget.length > 0) {
                        var Obj = _ebookContext.getUnTransForm();
                        // 简单判断课本资源是否在授课包列表里
                        var findLi = _this.controls.teachingPackageContainer.find("[data-uuid='" + uuid + "']");
                        if(findLi.length > 0) {
                            _dom.find(".format-bignumber").css("-webkit-transform", "matrix(1, 0, 0, 1, 0, 0)");
                            $(findLi).removeAttr("style");
                        }
                        return false;
                    }
                }
            }
        });

        _this.controls.teachingPackageContainer.delegate(".J_to_rescenter","click",function(){
            _this.buttons.btnResCenter.trigger("click");
        });
}

//删除文件
    TeachingPackage.prototype.deleteFile=function(filePath) {
        var _path = filePath.replace(/\bfile:(\/+)/g, "");
        if(fs.existsSync(_path))
            fs.unlinkSync(_path);
    }

//写排序文件
    TeachingPackage.prototype.writeSortFile=function (e) {
        var _this=this;
        var leftwidgetNum = $(".leftPageWrapper").find(".widgeticon");//左页widgets
        var rightwidgetNum = $(".rightPageWrapper").find(".widgeticon");//右页widgets
        var resourcePath = _ebookContext.getUser().getUserResourceBasePath();
        var leftSortFilePath = resourcePath + '/' + _this.bookContainer.getPageIndex() + '/resourceSort.json';//左侧widgets数据保存json地址
        var nextPageIndex=_this.bookContainer.getPageIndex()+1;
        var rightSortFilePath = resourcePath + '/' +nextPageIndex + '/resourceSort.json';//排序数据保存地址
        _this.deleteFile(leftSortFilePath);
        _this.deleteFile(rightSortFilePath);
        var leftresult = [];
        var rightresult = [];
        var sourceArr = $("#sortUl").find("li");
        var sourceIdxArr = [];
        for (var i = 0; i < sourceArr.length; i++) {
            sourceIdxArr[i] = $(sourceArr[i]).data("fileid");
        }
        for (i = 0; i < sourceIdxArr.length; i++) {//左侧列表中数据
            for (j = 0; j < leftwidgetNum.length; j++) {//widget数据
                if (sourceIdxArr[i] == leftwidgetNum[j].id) {
                    var thisSourceIdx = $(sourceArr[i]).find(".format-number").text();
                    $(leftwidgetNum[j]).find(".format-number").text(thisSourceIdx);
                    break;
                }
            }
        }

        for (var i = 0; i < leftwidgetNum.length; i++) {
            var leftsourceIndex= $(leftwidgetNum[i]).find(".format-number").text();
            if(typeof leftsourceIndex == "undefined"){
                leftsourceIndex = leftresult.length + 1;
            }
            leftresult.push({"index": leftsourceIndex, "fileId": leftwidgetNum[i].id});
        }
        _this.saveSortFile(leftresult,leftSortFilePath);//保存左侧资源到json文件

        for (i = 0; i < sourceIdxArr.length; i++) {//右侧列表中数据
            for (j = 0; j < rightwidgetNum.length; j++) {//widget数据
                if (sourceIdxArr[i] == rightwidgetNum[j].id) {
                    var thisSourceIdx = $(sourceArr[i]).find(".format-number").text();
                    $(rightwidgetNum[j]).find(".format-number").text(thisSourceIdx);
                    break;
                }
            }
        }
        for (var i = 0; i < rightwidgetNum.length; i++) {
            var rightSourceIndex= $(rightwidgetNum[i]).find(".format-number").text();
            if(typeof rightSourceIndex == "undefined"){
                rightSourceIndex = leftresult.length + 1;
            }
            rightresult.push({"index": rightSourceIndex, "fileId": rightwidgetNum[i].id});
        }
        _this.saveSortFile(rightresult,rightSortFilePath);//保存右侧资源到json文件
        // _this.getWidgets();
    };


    //解析排序文件json数据
    TeachingPackage.prototype.readSortFile=function(fileFullPath){
        var _this = this;
        var def = $.Deferred();
        var result = [];
        //判断文件是否存在
        var exist = false;
        _shellcmd.isFileExist(fileFullPath).done(function(ret){
            exist = ret;
            if(exist) {
                try {
                    result = _shellcmd.readFile(fileFullPath);
                    if("" == result) {
                        result = [];
                    }
                    def.resolve(result);
                }catch (e){
                    def.resolve(result);
                }
            } else {
                def.resolve(result);
            }
        }).fail(function(){
            def.reject(result);
        });
        return def.promise();
    };

    //保存排序文件json数据
    TeachingPackage.prototype.saveSortFile=function(data,fileFullPath){
        var _this = this;
        _shellcmd.isFileExist(fileFullPath).done(function(ret){
            if(ret) {
                _shellcmd.deleteFile(fileFullPath).done(function(){
                    _shellcmd.saveFile(JSON.stringify(data), fileFullPath);
                });
            } else {
                _shellcmd.saveFile(JSON.stringify(data), fileFullPath);
            }
        });
    };

    /**
     * 该解析排序文件方法废弃
     */
    TeachingPackage.prototype.parseWidgetFile = function (widgetsdata) {
        var def = $.Deferred();
        var _this = this;
        var leftResult = [];
        var rightResult = [];
        var unsortedResult = [];
        var resourcePath = _ebookContext.getUser().getUserResourceBasePath();
        var leftSortFilePath = resourcePath + '/' + _this.bookContainer.getPageIndex() + '/resourceSort.json';//排序数据保存地址
       var nextPageIndex=_this.bookContainer.getPageIndex()+1;
        var rightSortFilePath = resourcePath + '/' +nextPageIndex + '/resourceSort.json';//排序数据保存地址

        var allWidgetsIcon=$(".widgeticon");
        var result=[];
        $.when(_this.readSortFile(leftSortFilePath),_this.readSortFile(rightSortFilePath)).then(function(ret1,ret2){
            var leftSortData = JSON.parse(ret1);
            var rightSortData = JSON.parse(ret2);

            //左边数据不为空时处理
            if(leftSortData.length>0) {
                var leftSorted = leftSortData.sort(function(a,b){return (a.index - b.index)});
                for(var i = 0,count = leftSorted.length;i < count; i++ ){
                    var item = widgetsdata.filter(function(el){
                        return el.Id == leftSorted[i]["fileId"];
                    });
                    if(item.length > 0) {
                        leftResult.push(item[0]);
                    }
                }
            }


            //右边数据不为空时处理
            if(rightSortData.length>0){
                var rightSorted = rightSortData.sort(function(a,b){return (a.index - b.index)});
                for(var i = 0,count = rightSorted.length;i < count; i++ ){
                    var item = widgetsdata.filter(function(el){
                        return el.Id == rightSorted[i]["fileId"];
                    });
                    if(item.length > 0) {
                        rightResult.push(item[0]);
                    }
                }
            }

            var dataInSortFile = $.merge(leftResult,rightResult);//所有已排序资源
            // _this .deleteWidgetSort(widgetsdata,dataInSortFile);

            //考虑不存在排序文件中的数据处理
            if(dataInSortFile.length>0){
                for(var i=0;i<widgetsdata.length;i++){
                    for(var j=0;j<dataInSortFile.length;j++){
                        if(dataInSortFile[j].Id==widgetsdata[i].Id){
                            //如果排序文件中已经有该元素，则跳出循环，查看下一元素
                            break;
                        }
                        else if(j==dataInSortFile.length-1){//表示排序文件中没有该元素，则将其加入未排序数组中
                            var item=widgetsdata[i];
                            unsortedResult.push(item);
                            //break;
                        }
                    }

                }
            }else{
                for(var i=0;i<widgetsdata.length;i++){
                    var item=widgetsdata[i];
                    unsortedResult.push(item);
                }
            }

            var dataNotInSortFile = unsortedResult;
            def.resolve($.merge(dataInSortFile,dataNotInSortFile));
        });
        return def.promise();
    };

    TeachingPackage.prototype.parseWidgetFile1 = function (widgetsData) {
        var _this = this;
        var def = $.Deferred();
        var widgetsData = widgetsData;
        var pageWidgets = [];
        var sortedWidgets = [];
        if(_this.widgetSortList.length == 0){
            _this.readWidgetSortData().done(function(ret){
                //ret （true/false） - 表示排序信息是否存在
                pageWidgets = _this.analyseSortData(widgetsData);
                sortedWidgets = _this.sortListToWidgets(pageWidgets,widgetsData);
                def.resolve(sortedWidgets);
            }).fail(function(e){
                pageWidgets = _this.analyseSortData(widgetsData);
                sortedWidgets = _this.sortListToWidgets(pageWidgets,widgetsData);
                def.resolve(sortedWidgets);
            });
        }else{
            pageWidgets = _this.analyseSortData(widgetsData);
            sortedWidgets = _this.sortListToWidgets(pageWidgets,widgetsData);
            def.resolve(sortedWidgets);
        }
        return def.promise();
    };

    /**
     * 授课包展示课本所在单元信息
     * @param widgetsData
     */
    TeachingPackage.prototype.parseWidgetFileByUnit = function(page,widgetsData){
        var _this = this;
        var def = $.Deferred();
        // 待排序的数据
        widgetsData = widgetsData || [];
        //排序文件里（已排序）的信息
        var unitSortedWidgets = [];
        //排序后的数据
        var sortedWidgets = [];

        //对数据进行排序
        widgetsData = _this.orderArrData(widgetsData,'sort','DESC');

        unitSortedWidgets = _this.analyseSortDataByUnit(page,widgetsData);
        sortedWidgets = _this.sortListToWidgetsByUnit(unitSortedWidgets,widgetsData);

        def.resolve(sortedWidgets);
        return def.promise();
    };

    TeachingPackage.prototype.analyseSortData = function(widgetsData){
        var _this = this;
        var widgetIdsWithInfos = {};
        //取得widgets的id列表
        widgetIdsWithInfos = _this.getWidgetIds(widgetsData);
        var currPage = _this.bookContainer.getPageIndex();
        var pages = [currPage,currPage+1];
        var currPageSortedWidgets = _this.getSortedData(currPage);
        // if(currPageSortedWidgets.length != widgetsData.length){
        //每次都进行刷新，本来是想判断缓存 （页面数据 和 新加入之后的数据）的，但暂时无解
            _this.generateSortData(pages,widgetIdsWithInfos);
            var currPageSortedWidgets = _this.getSortedData(currPage);
        // }
        return currPageSortedWidgets;
    }

    TeachingPackage.prototype.analyseSortDataByUnit = function(page,widgetsData){
        var _this = this;
        var widgetIdsWithInfos = {};
        //取得widgets的id列表
        widgetIdsWithInfos = _this.getWidgetIdsByUnit(widgetsData);
        if(!page){
            page = _this.bookContainer.getPageIndex();
        }
        var units = _this.bookContainer.getPageMetadata(page) || {};

        _this.generateSortDataByUnit(units,widgetIdsWithInfos);
        var currUnitSortedWidgets = _this.getSortedDataByUnit(units);

        return currUnitSortedWidgets;
    }

    //取得课本页面widgets数据
    TeachingPackage.prototype.getWidgets = function(){
        var _this = this;
        // $(".widgeticon").hide();
        if(json.TP.useDb){
            // 下一页是否是下一单元（仅考虑双页模式）
            var showNextUnit = false;
            _this.widgetArr = _this.bookContainer.getCurrentPageRes();
            var currPage = _this.bookContainer.getPageIndex();
            var currUnit = _this.bookContainer.getPageMetadata(currPage);

            var nextPage = parseInt(currPage) + 1;
            var nextUnit = _this.bookContainer.getPageMetadata(nextPage);

            if(_this.bookContainer.getPageViewType() == _define.PageViewType.SimpleDoublePage){
                if(!(currUnit.unit1 == nextUnit.unit1 && currUnit.unit2 == nextUnit.unit2 && currUnit.unit3 == nextUnit.unit3 && currUnit.unit4 == nextUnit.unit4)){
                    showNextUnit = true;
                }
            }
            _this.bookContainer.getLessonRes(currUnit).done(function(widgets){
                var origin_widgets = widgets;
                showLoading({tips: AppTips.OpenResLoadingTips});
                _this.parseWidgetFileByUnit(currPage,origin_widgets).done(function (ret) {
                    hideLoading();
                    var ret_widgets = ret.filter(function(el){
                        return el.widgetType != "fadeCurtain";
                    });
                    // var ret_widgets = ret || [];//设置页面中的widget序号
                    //保存到文件(变更为页面卸载时保存到文件)
                    // _this.saveWidgetSortData(_this.widgetSortList);
                    //渲染图标
                    _this.renderWidgetsIconByUnit(ret_widgets);

                    //判断下一页是否属于同一单元,如果不是，则渲染下一页图标
                    if(showNextUnit){
                        _this.bookContainer.getLessonRes(nextUnit).done(function(widgets){
                            var nextUnit_origin_widgets = widgets;
                            _this.parseWidgetFileByUnit(nextPage,nextUnit_origin_widgets).done(function (nextUnitWidgets) {
                                //渲染图标
                                _this.renderWidgetsIconByUnit(nextUnitWidgets);
                            });
                        });
                    }

                    //渲染数目
                    _this.renderTeachingPackageNum(ret_widgets.length);

                    var isHavingClass = _mainToolbar.getIsHavingClass();
                    if (isHavingClass) {
                        //上课状态下授课包
                        var i = 0,
                            length = ret_widgets.length,
                            recommend_length = 0,
                            recommend_download = JSON.parse(localStorage.getItem("recommend_download"));
                        if (recommend_download && recommend_download.downloading) {
                            switch (_this.showDownloadingMode) {
                                case 'single':
                                    var currPageDownloadingFiles = _this.getCurrPageDownloadingFiles(recommend_download.downloading);
                                    break;
                                case 'default':
                                default:
                                    var currPageDownloadingFiles = recommend_download.downloading;
                                    break;
                            }
                            recommend_length = currPageDownloadingFiles.length;
                        }
                        if (length > 0 || recommend_length > 0) {
                            $(_this.controls.leftWidgetsContent).html("").append("<ul></ul>").addClass("drawer-list");
                            $(_this.controls.rightWidgetsContent).html("").append("<ul></ul>").addClass("drawer-list");
                            for (; i < length; i++) {
                                _this.renderTemplateByUnit(ret_widgets[i], i, _this.controls.leftWidgetsContent.find("ul"));
                                _this.renderTemplateByUnit(ret_widgets[i], i, _this.controls.rightWidgetsContent.find("ul"));
                            }
                            if (recommend_length > 0) {
                                //渲染下载中数据
                                if ($(_this.controls.leftWidgetsContent).find("li").length <= 0 || $(_this.controls.rightWidgetsContent).find("li").length <= 0) {
                                    //为空时创建元素
                                    $(_this.controls.leftWidgetsContent).html("").append("<ul></ul>").addClass("resource-list");
                                    $(_this.controls.rightWidgetsContent).html("").append("<ul></ul>").addClass("resource-list");
                                }
                                _this.renderDownloadingFiles(currPageDownloadingFiles, $(_this.controls.leftWidgetsContent).find("ul"), "havingClass");
                            }
                        } else {
                            //授课包没有数据，展示空白
                            _this.controls.leftWidgetsContent.html("");
                            _this.controls.rightWidgetsContent.html("");
                        }
                    } else {
                        //下课状态下授课包
                        var i = 0,
                            length = ret_widgets.length,
                            recommend_length = 0,
                            recommend_download = JSON.parse(localStorage.getItem("recommend_download"));
                        if (recommend_download && recommend_download.downloading) {
                            switch (_this.showDownloadingMode) {
                                case 'single':
                                    var currPageDownloadingFiles = _this.getCurrPageDownloadingFiles(recommend_download.downloading);
                                    break;
                                case 'default':
                                default:
                                    var currPageDownloadingFiles = recommend_download.downloading;
                                    break;
                            }
                            var recommend_length = currPageDownloadingFiles.length;
                        }
                        if (length > 0 || recommend_length > 0) {
                            $(_this.controls.widgetsContent).html("").append("<ul></ul>").addClass("resources-list").attr("id", "sortUl").attr("data-listidx", "0");
                            for (; i < length; i++) {
                                _this.renderTemplateByUnit(ret_widgets[i], i, _this.controls.widgetsContent.find("ul"));
                            }
                            //渲染下载中数据
                            if (recommend_length > 0) {
                                if ($(_this.controls.widgetsContent).find("ul").length <= 0) {
                                    //为空时创建元素
                                    $(_this.controls.widgetsContent).html("").append("<ul></ul>").addClass("resource-list");
                                }
                                _this.renderDownloadingFiles(currPageDownloadingFiles, $(_this.controls.widgetsContent).find("ul"), "afterClass");
                            }
                        } else {
                            //授课包没有数据
                            // $(_this.controls.widgetsContent).html("授课包没有数据");
                            var info = {
                                "status": "empty-skb",
                                "tips": '授课包空空的，<br/>去<a class="blue J_to_rescenter" style="cursor: pointer;">资源中心</a>挑选吧！'
                            };
                            _this.renderResStatus(_this.controls.widgetsContent, info);
                        }
                    }

                    //渲染页面最小序号定位
                    if(json.TP.useDb) {
                        _this.scrollToMinPosition();
                    }

                });
            });
        }else {
            var origin_widgets = _this.bookContainer.getCurrentPageRes();
            var renameWidgets = _this.renameWidgetsName(origin_widgets);

            var page = _this.bookContainer.getPageIndex();
            showLoading({tips: AppTips.OpenResLoadingTips});
            _this.parseWidgetFile1(renameWidgets).done(function (ret) {
                hideLoading();
                var ret_widgets = ret || [];//设置页面中的widget序号
                //保存到文件(变更为页面卸载时保存到文件)
                // _this.saveWidgetSortData(_this.widgetSortList);
                //渲染图标
                _this.renderWidgetsIcon(ret_widgets);
                //渲染数目
                _this.renderTeachingPackageNum(ret_widgets.length);

                _this.widgetArr = ret_widgets;
                var isHavingClass = _mainToolbar.getIsHavingClass();
                if (isHavingClass) {
                    //上课状态下授课包
                    var i = 0,
                        length = ret_widgets.length,
                        recommend_length = 0,
                        recommend_download = JSON.parse(localStorage.getItem("recommend_download"));
                    if (recommend_download && recommend_download.downloading) {
                        switch (_this.showDownloadingMode) {
                            case 'single':
                                var currPageDownloadingFiles = _this.getCurrPageDownloadingFiles(recommend_download.downloading);
                                break;
                            case 'default':
                            default:
                                var currPageDownloadingFiles = recommend_download.downloading;
                                break;
                        }
                        recommend_length = currPageDownloadingFiles.length;
                    }
                    if (length > 0 || recommend_length > 0) {
                        $(_this.controls.leftWidgetsContent).html("").append("<ul></ul>").addClass("drawer-list");
                        $(_this.controls.rightWidgetsContent).html("").append("<ul></ul>").addClass("drawer-list");
                        for (; i < length; i++) {
                            _this.renderTemplate(ret_widgets[i], i, _this.controls.leftWidgetsContent.find("ul"));
                            _this.renderTemplate(ret_widgets[i], i, _this.controls.rightWidgetsContent.find("ul"));
                        }
                        if (recommend_length > 0) {
                            //渲染下载中数据
                            if ($(_this.controls.leftWidgetsContent).find("li").length <= 0 || $(_this.controls.rightWidgetsContent).find("li").length <= 0) {
                                //为空时创建元素
                                $(_this.controls.leftWidgetsContent).html("").append("<ul></ul>").addClass("resource-list");
                                $(_this.controls.rightWidgetsContent).html("").append("<ul></ul>").addClass("resource-list");
                            }
                            _this.renderDownloadingFiles(currPageDownloadingFiles, $(_this.controls.leftWidgetsContent).find("ul"), "havingClass");
                        }
                    } else {
                        //授课包没有数据，展示空白
                        _this.controls.leftWidgetsContent.html("");
                        _this.controls.rightWidgetsContent.html("");
                    }
                } else {
                    //下课状态下授课包
                    var i = 0,
                        length = ret_widgets.length,
                        recommend_length = 0,
                        recommend_download = JSON.parse(localStorage.getItem("recommend_download"));
                    if (recommend_download && recommend_download.downloading) {
                        switch (_this.showDownloadingMode) {
                            case 'single':
                                var currPageDownloadingFiles = _this.getCurrPageDownloadingFiles(recommend_download.downloading);
                                break;
                            case 'default':
                            default:
                                var currPageDownloadingFiles = recommend_download.downloading;
                                break;
                        }
                        var recommend_length = currPageDownloadingFiles.length;
                    }
                    if (length > 0 || recommend_length > 0) {
                        $(_this.controls.widgetsContent).html("").append("<ul></ul>").addClass("resources-list").attr("id", "sortUl").attr("data-listidx", "0");
                        for (; i < length; i++) {
                            _this.renderTemplate(ret_widgets[i], i, _this.controls.widgetsContent.find("ul"));
                        }
                        //渲染下载中数据
                        if (recommend_length > 0) {
                            if ($(_this.controls.widgetsContent).find("ul").length <= 0) {
                                //为空时创建元素
                                $(_this.controls.widgetsContent).html("").append("<ul></ul>").addClass("resource-list");
                            }
                            _this.renderDownloadingFiles(currPageDownloadingFiles, $(_this.controls.widgetsContent).find("ul"), "afterClass");
                        }
                    } else {
                        //授课包没有数据
                        // $(_this.controls.widgetsContent).html("授课包没有数据");
                        var info = {
                            "status": "empty-skb",
                            "tips": '授课包空空的，<br/>去<a class="blue J_to_rescenter" style="cursor: pointer;">资源中心</a>挑选吧！'
                        };
                        _this.renderResStatus(_this.controls.widgetsContent, info);
                    }
                }
            });
        }
    };

    //取得本页面widgets数据数目
    TeachingPackage.prototype.getWidgetsTotal = function(){
        var _this = this;
        var def = $.Deferred();
        if(json.TP.useDb){
            var currPage = _this.bookContainer.getPageIndex();
            var currUnit = _this.bookContainer.getPageMetadata(currPage);
            _this.bookContainer.getLessonRes(currUnit).done(function(widgets){
                def.resolve(widgets.length);
            });
        }else{
            var widgets = _this.bookContainer.getCurrentPageRes();
            def.resolve(widgets.length);
        }
        return def.promise();
    };

    /**
     * 生成视图widgets数据
     * @param pages
     * @param widgetIds 本视图所有数据
     * @returns {}
     */
    TeachingPackage.prototype.generateSortData = function(pages,widgetIdsWithInfos){
        var _this = this;
        if(!pages) return 0;
        for(var i = 0,pageCount = pages.length; i < pageCount; i++){
            var page = pages[i];
            //sortlist里记录的变量
            var sortedData = _this.getSortedData(page);
            var mergedPageSortedData = _this.mergeWidgetDataUnique(sortedData,widgetIdsWithInfos);
            if(mergedPageSortedData){
                _this.setSortedData(page,mergedPageSortedData);
            }
        }
    };

    TeachingPackage.prototype.generateSortDataByUnit = function(units,widgetIdsWithInfos){
        var _this = this;
        units = units || {};
        var unit1 = units.unit1 || '',
            unit2 = units.unit2 || '',
            unit3 = units.unit3 || '',
            unit4 = units.unit4 || '';
        var currUnitSortedWidgets = _this.getSortedDataByUnit(units);
        var mergedUnitSortedData = _this.mergeWidgetDataUniqueByUnit(currUnitSortedWidgets,widgetIdsWithInfos);
        if(mergedUnitSortedData){
            _this.setSortedDataByUnit(units,mergedUnitSortedData);
        }
    };

    /**
     * 删除视图中widgets数据
     * @param pages
     * @param ids array
     * @returns {}
     */
    TeachingPackage.prototype.deleteSortData = function(currPage,ids){
        var _this = this;
        //要删除的页数集合  [当前页-1，当前页，当前页+1，当前页+1+1]
        //为什么不是3页，因为视图可能包括 当前页 和 当前页+1 两页
        var pages = [];
        var widgets = [];
        if(!currPage){
            return 0;
        }
        if(!ids){
            return 0;
        }

        if($.isArray(ids)){
            widgets = ids;
        }else{
            widgets = ids.split(",");
        }

        if(currPage - 1 > 0){
            pages.push(currPage - 1);
        }
        pages.push(currPage);
        pages.push(currPage+1);
        pages.push(currPage+1+1);

        for(var i = 0,count = pages.length;i < count;i++){
            var page = pages[i];
            _this.deleteSortPageWidgets(page,widgets);
        }
    };

    TeachingPackage.prototype.deleteSortDataByUnit = function(units,ids){
        var _this = this;
        units = units || {};
        var unit1 = units.unit1 || '',
            unit2 = units.unit2 || '',
            unit3 = units.unit3 || '',
            unit4 = units.unit4 || '';
        var pages = [];
        var widgets = [];
        if(!ids){
            return 0;
        }
        if($.isArray(ids)){
            widgets = ids;
        }else{
            widgets = ids.split(",");
        }
        _this.deleteSortPageWidgetsByUnit(units,widgets);
    };

    TeachingPackage.prototype.mergeWidgetDataUnique = function(sortedData,widgetIdsWithInfos){
        var _this = this;
        var sortedData = sortedData;
        var widgetIds = widgetIdsWithInfos.ids;
        var widgetInfos = widgetIdsWithInfos.infos;
        var result = [];
        var unsortArr = [];
        var unsortIds = [];
        var sortIds = [];
        var sortedDataIds = _this.getSortWidgetIds(sortedData);
        for(var i = 0, count = widgetIds.length;i < count; i++){
            var id = widgetIds[i];
            if(-1 == $.inArray(id,sortedDataIds)){
                //不在列表中的数据
                unsortIds.push(id);
            }else{
                //在列表中的数据,更新数据
                for(var x=0,x_count= sortedDataIds.length;x < x_count;x++){
                    var x_item = sortedDataIds[x];
                    if(id == x_item){
                        sortedData[x]["id"] = widgetIdsWithInfos.infos[id];
                    }
                }
            }
        }
        //取得已排序的最大index值
        var maxValue = _this.getMaxIndex(sortedData);
        if(maxValue == "-Infinity"){
            maxValue = 0;
        }
        //合并
        for(var j = 0, count = unsortIds.length; j < count; j++) {
            if (widgetInfos[unsortIds[j]]) {
                var obj = {
                    "index": maxValue + j + 1,
                    "fileId": unsortIds[j],
                    "id": widgetInfos[unsortIds[j]]
                };
                unsortArr.push(obj);
            }
        }
        result = $.merge(sortedData,unsortArr);
        //顺序排序
        result = _this.orderSortedData(result);
        return result;
    };

    TeachingPackage.prototype.mergeWidgetDataUniqueByUnit = function(sortedData,widgetIdsWithInfos){
        var _this = this;
        sortedData = sortedData || [];
        var widgetIds = widgetIdsWithInfos.ids;
        var widgetInfos = widgetIdsWithInfos.infos;
        var result = [];
        //未排序的数据
        var unsortArr = [];
        //未排序数据ids
        var unsortIds = [];
        var sortIds = [];
        var sortedDataIds = _this.getSortWidgetIdsByUnit(sortedData);
        for(var i = 0, count = widgetIds.length;i < count; i++){
            var id = widgetIds[i];
            if(-1 == $.inArray(id,sortedDataIds)){
                //不在列表中的数据
                unsortIds.push(id);
            }
        }
        //取得已排序的最大index值
        var maxValue = _this.getMaxIndex(sortedData);
        if(maxValue == "-Infinity"){
            maxValue = 0;
        }
        //合并不在排序列表里的数据
        for(var j = 0, count = unsortIds.length; j < count; j++) {
            if (widgetInfos[unsortIds[j]]) {
                var obj = {
                    "index": maxValue + j + 1,
                    "fileId": widgetInfos[unsortIds[j]],
                    "id": unsortIds[j]
                };
                unsortArr.push(obj);
            }
        }
        result = $.merge(sortedData,unsortArr);
        //顺序排序
        result = _this.orderArrData(result,'index','DESC');
        return result;
    };

    //取得widgets Id数组
    TeachingPackage.prototype.getWidgetIds = function(widgetsData){
        var _this = this;
        var result = {
            "ids":[],
            "infos":{}
        };
        var ids = [];
        var infos = {};
        for(var i = 0, count = widgetsData.length;i < count; i++){
            var item = widgetsData[i];
            //重要，取得当前页面数据中的唯一id,用于和排序文件对应id进行比较
            //File 保持一致
            // if(item.File){
            //     ids.push(item.File);
            //     infos[item.File] = item.Id;
            // }
            if (item.uniqueFileName) {
                ids.push(item.uniqueFileName);
                infos[item.uniqueFileName] = item.Id;
            }
        }
        result.ids = ids;
        result.infos = infos;
        return result;
    }

    TeachingPackage.prototype.getWidgetIdsByUnit = function(widgetsData){
        var _this = this;
        var result = {
            "ids":[],
            "infos":{}
        };
        var ids = [];
        var infos = {};
        for(var i = 0, count = widgetsData.length;i < count; i++){
            var item = widgetsData[i];
            //重要，取得当前页面数据中的唯一id,用于和排序文件对应id进行比较
            //File 保持一致
            // if(item.File){
            //     ids.push(item.File);
            //     infos[item.File] = item.Id;
            // }
            if (item.uuid) {
                ids.push(item.uuid);
                if(1 == item._packedFlag){
                    infos[item.uuid] = item.Id;
                }else{
                    infos[item.uuid] = item.widgetType;
                }
            }
        }
        result.ids = ids;
        result.infos = infos;
        return result;
    }

    //取得sortListwidgets Id数组
    TeachingPackage.prototype.getSortWidgetIds = function(sortedData){
        var _this = this;
        var result = [];
        for(var i = 0, count = sortedData.length;i < count; i++){
            var item = sortedData[i];
            if(item.fileId){
                result.push(item.fileId);
            }
        }
        return result;
    }

    TeachingPackage.prototype.getSortWidgetIdsByUnit = function(sortedData){
        var _this = this;
        var result = [];
        for(var i = 0, count = sortedData.length;i < count; i++){
            var item = sortedData[i];
            if(item.id){
                result.push(item.id);
            }
        }
        return result;
    }

    //取得对象数组的某属性最大值
    TeachingPackage.prototype.getMaxIndex = function(obj){
        var _this = this;
        var result = -Infinity,
            lastComputed = -Infinity,
            computed;
        for(var i = 0,count = obj.length;i<count;i++){
            var item = obj[i];
            computed = item.index;
            if (computed > lastComputed || computed === -Infinity && result === -Infinity){
                result = computed;
                lastComputed = computed;
            }
        }
        return result;
    };

    //取得指定页面的widgets
    TeachingPackage.prototype.getSortedData = function(page){
        var _this = this;
        var result = [];
        if(!page) return [];
        for(var i = 0,count = _this.widgetSortList.length;i < count;i++){
            var item = _this.widgetSortList[i];
            if(item.page == page){
                result = item.widgets;
                break;
            }
        }
        return result;
    };

    TeachingPackage.prototype.getSortedDataByUnit = function(units){
        var _this = this;
        var result = [];
        units = units || {};
        var unit1 = units.unit1 || '',
            unit2 = units.unit2 || '',
            unit3 = units.unit3 || '',
            unit4 = units.unit4 || '';
        for(var i = 0,count = _this.widgetSortListByUnit.length;i < count;i++){
            var item = _this.widgetSortListByUnit[i] || {};
            if(item.unit1 == unit1 && item.unit2 == unit2 && item.unit3 == unit3 && item.unit4 == unit4){
                result = item.widgets;
                break;
            }
        }
        return result;
    };

    //设置指定页面widgets
    TeachingPackage.prototype.setSortedData = function(page,sortedData){
        var _this = this;
        var sortedData = sortedData;
        var pageWidgets = [];
        if(!page) return 0;
        // pageWidgets = _this.getSortedData(page);
        // if(pageWidgets.length == 0) {
        //     _this.widgetSortList.push({"page":page,"widgets":[]});
        // }

        //判断页码是否存在
        var isPageExist = false;
        for(var j = 0,count = _this.widgetSortList.length; j < count; j++){
            var item = _this.widgetSortList[j];
            if(item && item.page == page){
                isPageExist = true;
                break;
            }
        }
        if(!isPageExist){
            _this.widgetSortList.push({"page":page,"widgets":[]});
        }
        for(var i=0,count = _this.widgetSortList.length; i < count; i++){
            var item = _this.widgetSortList[i];
            if(item && item.page == page){
                _this.widgetSortList[i]["widgets"] = [];
                // var _tmp = _this.widgetSortList[i]["widgets"].concate(widgets);
                _this.widgetSortList[i]["widgets"] = sortedData;
                return _this.widgetSortList[i]["widgets"];
            }
        }
        return false;
    };

    TeachingPackage.prototype.setSortedDataByUnit = function(units,sortedData){
        var _this = this;
        units = units || {};
        var unit1 = units.unit1 || '',
            unit2 = units.unit2 || '',
            unit3 = units.unit3 || '',
            unit4 = units.unit4 || '';
        sortedData = sortedData || [];
        var unitWidgets = [];

        // 判断单元是否存在
        var isUnitExist = false;
        for(var j = 0,count = _this.widgetSortListByUnit.length; j < count; j++){
            var item = _this.widgetSortListByUnit[j] || {};
            if(item && item.unit1 == unit1 && item.unit2 == unit2 && item.unit3 == unit3 && item.unit4 == unit4){
                isUnitExist = true;
                break;
            }
        }
        if(!isUnitExist){
            _this.widgetSortListByUnit.push({"unit1":unit1,"unit2":unit2,"unit3":unit3,"unit4":unit4,"isSync":false,"widgets":[]});
        }
        for(var i=0,count = _this.widgetSortListByUnit.length; i < count; i++){
            var item = _this.widgetSortListByUnit[i];
            if(item && item.unit1 == unit1 && item.unit2 == unit2 && item.unit3 == unit3 && item.unit4 == unit4){
                _this.widgetSortListByUnit[i]["isSync"] = false;
                _this.widgetSortListByUnit[i]["widgets"] = [];
                _this.widgetSortListByUnit[i]["widgets"] = sortedData;
                return _this.widgetSortListByUnit[i]["widgets"];
            }
        }
        return false;
    };

    /**
     * 删除指定页面widget
     * @param page
     * @param widgetIds arrays
     * @returns {*}
     */
    TeachingPackage.prototype.deleteSortPageWidgets = function(page,widgetIds){
        var _this = this;
        var ids = widgetIds || [];
        var result = [];
        if(!page) return 0;
        //重置要删除页面的widget数据
        for(var i=0,count = _this.widgetSortList.length;i<count;i++){
            var item = _this.widgetSortList[i];
            if(item.page == page){
                var pageWidgets = _this.widgetSortList[i]["widgets"] || [];
                for(var j=0,p_count = pageWidgets.length;j < p_count;j++){
                    var pageWidgetItem = pageWidgets[j];
                    if(-1 == $.inArray(pageWidgetItem.id,widgetIds)){
                        result.push(pageWidgetItem);
                    }
                }
                _this.widgetSortList[i]["widgets"] = [];
                _this.widgetSortList[i]["widgets"] = result;
                //这里需要保证每个sort文件page没有重复。page生成时已经做了唯一性验证，这里直接break
                break;
            }
        }
        return _this.widgetSortList;
    };

    TeachingPackage.prototype.deleteSortPageWidgetsByUnit = function(units,widgetIds){
        var _this = this;
        units = units || {};
        var unit1 = units.unit1 || '',
            unit2 = units.unit2 || '',
            unit3 = units.unit3 || '',
            unit4 = units.unit4 || '';
        var ids = widgetIds || [];
        var result = [];
        //重置要删除页面的widget数据
        for(var i=0,count = _this.widgetSortListByUnit.length;i<count;i++) {
            var item = _this.widgetSortListByUnit[i] || {};
            if (item && item.unit1 == unit1 && item.unit2 == unit2 && item.unit3 == unit3 && item.unit4 == unit4) {
                var unitWidgets = item["widgets"] || [];
                for(var j=0,j_count = unitWidgets.length;j < j_count;j++){
                    if (-1 == $.inArray(unitWidgets[j]['id'], ids)) {
                        result.push(unitWidgets[j]);
                    }
                }
                _this.widgetSortListByUnit[i]["widgets"] = [];
                _this.widgetSortListByUnit[i]["widgets"] = result;
                _this.widgetSortListByUnit[i]["isSync"] = false;
                break;
            }
        }
        return _this.widgetSortListByUnit;
    };

    //对排序列表index进行重新排序（只改变index值，不影响排序结果）
    TeachingPackage.prototype.orderSortedData = function(sortedData,sortType){
        var _this = this;
        var sortedData = sortedData;
        var result = [];
        if(typeof (sortType) === "undefined"){
            sortType = "DESC";
        }
        switch(sortType.toUpperCase()){
            case "DESC":
                result = sortedData.sort(function(a,b){return (a.index - b.index)});
                break;
            case "ASC":
                result = sortedData.sort(function(a,b){return (b.index - a.index)});
                break;
            default:
                result = sortedData.sort(function(a,b){return (a.index - b.index)});
                break;
        }
        return result;
    };

    /**
     * 排序方法
     */
    TeachingPackage.prototype.orderArrData = function(arrData,tag,sortType){
        var _this = this;
        arrData = arrData || [];
        var result = [];
        if(typeof (sortType) === "undefined"){
            sortType = "DESC";
        }
        switch(sortType.toUpperCase()){
            case "DESC":
                if(tag){
                    result = arrData.sort(function(a,b){return (parseInt(a[tag]) - parseInt(b[tag]))});
                }else{
                    result = arrData.sort(function(a,b){return (parseInt(a['index']) - parseInt(b['index']))});
                }
                break;
            case "ASC":
                if(tag){
                    result = arrData.sort(function(a,b){return (parseInt(b[tag]) - parseInt(a[tag]))});
                }else{
                    result = arrData.sort(function(a,b){return (parseInt(b['index']) - parseInt(a['index']))});
                }
                break;
            default:
                if(tag){
                    result = arrData.sort(function(a,b){return (parseInt(a[tag]) - parseInt(b[tag]))});
                }else{
                    result = arrData.sort(function(a,b){return (parseInt(a['index']) - parseInt(b['index']))});
                }
                break;
        }
        return result;
    };

    //排序文件转换为 顺序widgets
    TeachingPackage.prototype.sortListToWidgets = function(sortWidgetIds,widgetsData){
        var _this = this;
        var widgetsData = widgetsData;
        var sortWidgetIds = sortWidgetIds;
        var sortedPageWidgets = [];
        //排序
        var sortWidgetIds = _this.orderSortedData(sortWidgetIds);
        for(var i = 0,count = sortWidgetIds.length;i < count; i++ ){
            var item = widgetsData.filter(function(el){
                //重要，排序字段 File - 页面widgets数据
                // return el.Id == sortWidgetIds[i]["fileId"];
                // return el.File == sortWidgetIds[i]["fileId"];
                return el.uniqueFileName == sortWidgetIds[i]["fileId"];
            });
            if(item.length > 0) {
                sortedPageWidgets.push(item[0]);
            }
        }
        return sortedPageWidgets;
    };

    TeachingPackage.prototype.sortListToWidgetsByUnit = function(sortWidgetIds,widgetsData){
        var _this = this;
        widgetsData = widgetsData || [];
        sortWidgetIds = sortWidgetIds;
        var sortedUnitWidgets = [];
        //排序
        var sortWidgetIds = _this.orderSortedData(sortWidgetIds,'index','DESC');
        for(var i = 0,count = sortWidgetIds.length;i < count; i++ ){
            var item = widgetsData.filter(function(el){
                //重要，排序字段 File - 页面widgets数据
                // return el.Id == sortWidgetIds[i]["fileId"];
                // return el.File == sortWidgetIds[i]["fileId"];
                // return el.uniqueFileName == sortWidgetIds[i]["fileId"];
                return el.uuid == sortWidgetIds[i]["id"];
            });
            if(item.length > 0) {
                sortedUnitWidgets.push(item[0]);
            }
        }
        return sortedUnitWidgets;
    };

    //读取sortFile widgets数据
    TeachingPackage.prototype.readWidgetSortData = function(){
        var _this = this;
        var def = $.Deferred();
        var userBookBasePath = _ebookContext.getUser().getUserBookBasePath();
        var sortFilePath = userBookBasePath + '/' + _this.bookContainer.bookMetaInfo.bookCode + '-sort' + '.json';
        _shellcmd.isFileExist(sortFilePath).done(function(exist){
            if(exist){
                _this.readSortFile(sortFilePath).done(function(ret){
                    try{
                        _this.widgetSortList = JSON.parse(ret);
                        def.resolve(true);
                    }catch (e){
                        def.resolve(false);
                    }
                });
            } else {
                //文件不存在
                _this.widgetSortList = [];
                def.resolve(false);
            }
        });
        return def.promise();
    };

    //写入sortFile widgets数据
    TeachingPackage.prototype.saveWidgetSortData = function(data){
        var _this = this;
        var def = $.Deferred();
        var userBookBasePath = _ebookContext.getUser().getUserBookBasePath();
        var sortFilePath = userBookBasePath + '/' + _this.bookContainer.bookMetaInfo.bookCode + '-sort' + '.json';
        _shellcmd.isFileExist(sortFilePath).done(function(exist){
            if(exist){
                _shellcmd.deleteFile(sortFilePath).done(function(){
                    _this.saveSortFile(data,sortFilePath).done(function(ret){
                        def.resolve(true);
                    }).fail(function(){
                        def.reject(false);
                    })
                });
            }else{
                var defaultSortData = [];
                _this.saveSortFile(defaultSortData,sortFilePath);
            }
        });
        return def.promise();
    };

    TeachingPackage.prototype.saveWidgetSortDataByUnit = function(data){
        var _this = this;
        var def = $.Deferred();

        var getUnitSorted = function(units){
            var result = [];
            units = units || {};
            var unit1 = units.unit1 || '',
                unit2 = units.unit2 || '',
                unit3 = units.unit3 || '',
                unit4 = units.unit4 || '';
            var unitSortedData = _this.widgetSortListByUnit.filter(function(el){
                if(el.unit1 == unit1 && el.unit2 == unit2 && el.unit3 == unit3 && el.unit4 == unit4){
                    return true;
                }else{
                    return false;
                }
            });
            // 取拿到的第一组数据
            if(unitSortedData && unitSortedData[0] && unitSortedData[0]['widgets']){
                result = _this.orderArrData(unitSortedData[0]['widgets'],'index','DESC');
            }
            return result;
        };

        var getUnitDb = function(units){
            var def = $.Deferred();
            var result = [];
            _this.bookContainer.getResFromDb(units).done(function(ret){
                result = ret || [];
                def.resolve(result);
            }).fail(function(e){
                def.resolve(result);
            });
            return def.promise();
        }

        // 生成列表
        var generateList = function(units){
            var def = $.Deferred();
            var flag = 0;
            $.when(getUnitDb(units),getUnitSorted(units)).done(function(dbData,sortData){
                var orderDbData = _this.orderArrData(dbData,'sort','DESC');
                var orderSortData = _this.orderArrData(sortData,'index','DESC');
                var orderSortObj = {};
                var orderDbObj = {};
                var listObj = {};
                var lists = [];
                orderSortData.forEach(function(val,index,arr){
                    var key = arr[index]['id'];
                    var sort = arr[index]['index'];
                    orderSortObj[key] = sort;
                });

                orderDbData.forEach(function(val,index,arr){
                    var key = arr[index]['uuid'];
                    var sort = arr[index]['sort'];
                    orderDbObj[key] = sort;
                });

                var flag = 0;
                var currSortValue = 0;
                var sortLength = orderSortData.length;

                for(var s = 0,s_count = orderSortData.length;s < s_count;s++){
                    var key = orderSortData[s]['id'];
                    if(flag == 0){
                        if(orderSortObj[key] && orderDbObj[key] != 1){
                            listObj[key] = 1;
                            currSortValue = 1;
                        }
                    }else{
                        if(orderDbObj[key] <= currSortValue){
                            currSortValue = currSortValue + 1;
                            listObj[key] = currSortValue;
                        }else{
                            currSortValue = orderDbObj[key];
                            // 不做处理
                        }
                    }
                    flag++;
                }
                // 待更新的数据
                console.log(listObj);
                var uuidArr = [];
                for(var key in listObj){
                    uuidArr.push(key)
                };
                //补全数据
                for(var i = 0, count = orderDbData.length; i < count; i++){
                    var item = orderDbData[i];
                    if(-1 != $.inArray(item.uuid,uuidArr)){
                        //针对互动卡片特殊处理widgetType
                        var _widgetType = item.widgetType;
                        if(_define.WidgetType.InteractiveCard == item.widgetType){
                            if(item.secondWidgetType){
                                _widgetType = JSON.stringify({
                                    widgetType: item.widgetType,
                                    secondWidgetType: item.secondWidgetType
                                });
                            }
                        }
                        lists.push(
                            {    //JSON数组
                                unit1: item.unit1, //新的目录
                                unit2: item.unit2,
                                unit3: item.unit3,
                                unit4: item.unit4,
                                uuid: item.uuid,
                                sort: listObj[item.uuid],  //排序字段
                                pageCode: item.pageCode,
                                pageIndex: item.pageIndex,
                                position: item.position,
                                widgetId: item.widgetId,
                                widgetType: _widgetType,
                                resId: item.resId || ''
                            }
                        );
                    }
                };
                console.log(lists);
                def.resolve(lists);
            });
            return def.promise();
        }

       /*
            list:[{    //JSON数组
                unit1:'', //新的目录
                unit2:'',
                unit3:'',
                unit4:'',
                uuid:'',
                sort:1,  //排序字段
                pageCode:'',
                pageIndex:'',
                position:'',JSON字符串

            }]
        */
        var updateTPP = function(list){
            var def = $.Deferred();
            list = list || [];
            var condition = {
                method:'updateTPP',
                data: {
                    userName: _ebookContext.getUser().getName(),
                    list: list
                }
            };
            console.log(condition);
            hproseClient.hproseCall(condition,function(ret){
                if(ret && ret.code == 1){
                    def.resolve(ret);
                }else{
                    def.reject(ret);
                }
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        }

        for(var i = 0,count = _this.widgetSortListByUnit.length;i < count; i++){
            (function(i){
                setTimeout(function(){
                    var item = _this.widgetSortListByUnit[i];
                    if(item && !item.isSync){
                        var units = {
                            unit1: item.unit1 || '',
                            unit2: item.unit2 || '',
                            unit3: item.unit3 || '',
                            unit4: item.unit4 || ''
                        };
                        generateList(units).done(function(lists){
                            if(lists.length > 0){
                                updateTPP(lists).done(function(ret){
                                    item.isSync = true;
                                    console.log('排序完成');
                                    console.log(ret);
                                });
                                console.log(lists);
                            }else{
                                item.isSync = true;
                                console.log('排序不变，不需要进行排序入库');
                            }
                        });
                    }
                });
            })(i);
        }
        return def.promise();
    };

    //渲染组件编码
    TeachingPackage.prototype.renderWidgetsIcon = function(data){
        var allWidgetsIcon=$(".widgeticon");
        var num = "";
        for(var i = 0,count = allWidgetsIcon.length;i < count;i++){
            //计算序号
            for(var j=0,count = data.length;j < count;j++){
                var fileId = $(allWidgetsIcon[i]).attr("id");
                if(data[j].Id == fileId) {
                    num = j;
                    break;
                }
            }
            $(allWidgetsIcon[i]).find(".format-number").text(num+1);
        }
        allWidgetsIcon.show();
    };

    TeachingPackage.prototype.renderWidgetsIconByUnit = function(data){
        var allWidgetsIcon=$(".widgeticon");
        var iconLength  = allWidgetsIcon.length;
        //收集页面上存在的数据id
        var idsInPage = [];
        //记录页面数据
        var sortCollect = {};
        for(var w = 0; w < iconLength; w++){
            var item = allWidgetsIcon[w];
            var uuid = $(allWidgetsIcon[w]).data("uuid");
            idsInPage.push(uuid);
        }
        // 计算序号
        for(var i = 0,count = data.length; i < count; i++){
            var item = data[i];
            if(-1 != $.inArray(item.uuid,idsInPage)){
                sortCollect[item.uuid] = i;
            }
        }
        //渲染序号
        for(var j = 0; j < iconLength; j++){
            var uuid = $(allWidgetsIcon[j]).data("uuid");
            if(typeof sortCollect[uuid] != 'undefined'){
                $(allWidgetsIcon[j]).find(".format-number").text(parseInt(sortCollect[uuid]) + 1);
            }
        }
        allWidgetsIcon.show();
    };

    //将重名widgets重新编号(保证唯一性)
    TeachingPackage.prototype.renameWidgetsName = function(widgets) {
        var _this = this;
        var result = [];
        var name = [];
        var _widgets = widgets.concat([]);
        for(var i=0,count=_widgets.length;i<count;i++){
            var item = {};
            item = _widgets[i];
            //解析文件 默认后缀名取 item.File
            var fileNameParse = _resTool.parseFileName(item.File);
            var item_name = fileNameParse.file;

            //兼容某些File数据不带文件后缀名 解析 item.Title
            if(fileNameParse.fileExt == ""){
                var fileNameParse_title = _resTool.parseFileName(item.Title);
                var item_name = fileNameParse_title.file;
            }
            if(-1 != jQuery.inArray(item_name,name)){
                item.uniqueFileName = "2-" + item_name;
                name.push(item_name);
            }else{
                item.uniqueFileName = item_name;
                name.push(item_name);
            }
            result.push(item);
        }
        return result;
    }

    //渲染上课/下课状态下授课包数据
    TeachingPackage.prototype.renderTemplate = function(data,index,dom) {
        var _this = this;
        if(!dom){
            dom = _this.controls.widgetsContent;
        }
        var index = index;
        var secondWidgetType = "";
        var cardType = "";

        //解析文件 默认后缀名取 data.File
        var fileNameParse = _resTool.parseFileName(data.File);
        //兼容某些File数据不带文件后缀名 解析 data.Title
        if(fileNameParse.fileExt == ""){
            var fileNameParse = _resTool.parseFileName(data.Title);
        }
        //兼容某些File和Title均不带后缀名的数据（作为文件夹存在于目录下，目录下有meta.json描述）widget得type值(由于老的卡片图标可能不全问题，目前老卡片数据格式 由 互动卡片图标 接管)
        if(fileNameParse.fileExt == ""){
            secondWidgetType = "interactiveCard";
            cardType = _this.widgetDataTypeTranslate(data.type);
        }
        //特殊数据，兼容老数据
        if(data.WidgetType == "evaluate"){
            secondWidgetType = "evaluate";
            cardType = data.type || "";
        }
        //特殊数据，note类型
        if(data.WidgetType == "note"){
            secondWidgetType = "note";
            cardType = "";
        }
        //特殊数据，note类型
        if(data.WidgetType == "gallery"){
            secondWidgetType = "gallery";
            cardType = "";
        }
        //特殊数据，只有互动卡片才有secondWidgetType属性
        if(data.WidgetType == "interactiveCard" && data.secondWidgetType){
            secondWidgetType = "interactiveCard";
            cardType = data.secondWidgetType || "";
        }

        //note 以上数据的格式可能不全，后期一定要梳理清楚
        //有老的资源，有新加的互动卡片，功能也有重复。。
        //重要提示：卡片数据的图标不是按照文件后缀名来展示的

        var id = data.Id,
            title = data.Title || fileNameParse.fileName, //title为不包含后缀名的数据
            fileName = fileNameParse.fileName,
            fileExt = fileNameParse.fileExt,
            file = fileName + '.' + fileExt, //file为包含后缀名的数据
            src = data.src,
            widgetType = data.WidgetType,
            resourceId = data.resourceId,
            userName = data.userName;
        var isHavingClass = _mainToolbar.getIsHavingClass();

        //title解析
        var parseTitle = _resTool.parseFileName(title);
        if(parseTitle.fileName){
            title = parseTitle.fileName;
        }else{
            //如果title为空，则将fileName赋值给title
            title = fileName;
        }

        if(isHavingClass) {
            //上课状态下授课包
            var file_1 = "",
                extension = "";

            extension = fileExt;
            file_1 = title;

            var tpl = $('<li>' +
                '<div class="drawer-info">' +
                '<div class="format-number">1</div>' +
                '<div class="format-img"><img src=""></div>' +
                '</div>' +
                '<div class="format-tit"><p class="format-class"><span>{title}</span></p></div>' +
                '</li>');
            //附加属性
            tpl.attr("data-fileId", id);
            tpl.attr("data-file", file);
            tpl.attr("data-resourceId", resourceId);
            tpl.find(".format-number").text(index + 1);
            //secondWidgetType是为互动卡片所特有的，互动卡片的wedgettype相同，根据二级类型不同，显示的图片不同
            tpl.find(".format-img img").attr("src", _this.setDefaultPic(extension,secondWidgetType,cardType));
            tpl.find(".format-img img").attr("alt", file_1);
            tpl.find(".format-img img").attr("title", file_1);
            //上课状态不加p标签，用于内容居中
            tpl.find(".format-tit span").text(file_1);
            tpl.find(".format-tit span").attr("title", file_1);
            tpl.on("mouseup",function(event) {
                if(tpl.attr("draged") == "true"){
                    return 0;
                }
                if(!_this.widgetArr[index]) return;
                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:_ebookContext._curUser._uid,
                    module:'01014',
                    type:'trigger'
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
                // switch (_this.widgetArr[index].WidgetType){
                //     case "audio":
                //         _shellcmd.simpleShellExecute(_this.widgetArr[index].src);
                //         break;
                //     default:
                //         _this.widgetArr[index].resourcePreview();
                //         break;
                // }
                _this.openTeachingFile(_this.widgetArr[index]);
                event.stopPropagation();
            });
            dom.append(tpl);
        } else {
            //下课状态下授课包
            var file_1 = "",
                extension = "";

            extension = fileExt;
            file_1 = title;

            var tpl = $('<li class="">' +
                '<div class="format-number"></div>' +
                '<div class="format-img"><img></div> ' +
                '<div class="format-tit"><p><span><a>{title}</a></span></p></div>' +
                '</li>');
            //附加属性
            tpl.attr("data-fileId", id);
            tpl.attr("data-file", file);
            tpl.attr("data-resourceId", resourceId);
            tpl.find(".format-number").text(index + 1);
            //secondWidgetType是为互动卡片所特有的，互动卡片的wedgettype相同，根据二级类型不同，显示的图片不同
            tpl.find(".format-img img").attr("src", _this.setDefaultPic(extension,secondWidgetType,cardType));
            tpl.find(".format-img img").attr("alt", file_1);
            tpl.find(".format-tit a").text(file_1);
            tpl.find(".format-tit a").attr("title", file_1);
            tpl.find(".format-tit").find("a").on("mouseup",function(event) {
                if(tpl.attr("draged") == "true"){
                    return 0;
                }
                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:_ebookContext._curUser._uid,
                    module:'02006',
                    type:'trigger'
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);

                $(".user-popover").hide();
                if(!_this.widgetArr[index]) return;
                // switch (_this.widgetArr[index].WidgetType){
                //     case "audio":
                //         _shellcmd.simpleShellExecute(_this.widgetArr[index].src);
                //         break;
                //     default:
                //         _this.widgetArr[index].resourcePreview();
                //         break;
                // }
                _this.openTeachingFile(_this.widgetArr[index]);
                event.stopPropagation();
            });
            tpl.on("mouseover",function(){
                var _dom = $(_this.widgetArr[index].Content);
                console.log(_dom.css('-webkit-transform'));
            })

            dom.append(tpl);
        }
    };

    TeachingPackage.prototype.renderTemplateByUnit = function(data,index,dom) {
        var _this = this;
        if(!dom){
            dom = _this.controls.widgetsContent;
        }
        var index = index;
        var secondWidgetType = "";
        var cardType = "";
        if(1 == data._packedFlag){
            //解析文件 默认后缀名取 data.File
            var fileNameParse = _resTool.parseFileName(data.File);
            //兼容某些File数据不带文件后缀名 解析 data.Title
            if(fileNameParse.fileExt == ""){
                var fileNameParse = _resTool.parseFileName(data.Title);
            }
            //兼容某些File和Title均不带后缀名的数据（作为文件夹存在于目录下，目录下有meta.json描述）widget得type值(由于老的卡片图标可能不全问题，目前老卡片数据格式 由 互动卡片图标 接管)
            if(fileNameParse.fileExt == ""){
                secondWidgetType = "interactiveCard";
                cardType = _this.widgetDataTypeTranslate(data.type);
            }
            //特殊数据，兼容老数据
            if(data.WidgetType == "evaluate"){
                secondWidgetType = "evaluate";
                cardType = data.type || "";
            }
            //特殊数据，note类型
            if(data.WidgetType == "note"){
                secondWidgetType = "note";
                cardType = "";
            }
            //特殊数据，note类型
            if(data.WidgetType == "gallery"){
                secondWidgetType = "gallery";
                cardType = "";
            }
            //特殊数据，只有互动卡片才有secondWidgetType属性
            if(data.WidgetType == "interactiveCard" && data.secondWidgetType){
                secondWidgetType = "interactiveCard";
                cardType = data.secondWidgetType || "";
            }

            //note 以上数据的格式可能不全，后期一定要梳理清楚
            //有老的资源，有新加的互动卡片，功能也有重复。。
            //重要提示：卡片数据的图标不是按照文件后缀名来展示的

            var id = data.Id,
                uuid = data.uuid,
                title = data.Title || fileNameParse.fileName, //title为不包含后缀名的数据
                fileName = fileNameParse.fileName,
                fileExt = fileNameParse.fileExt,
                file = fileName + '.' + fileExt, //file为包含后缀名的数据
                src = data.src,
                widgetType = data.WidgetType,
                resourceId = data.resourceId,
                pageIndex = data.pageIndex,
                userName = data.userName;
        }else{
            var id = data.widgetId,
                uuid = data.uuid,
                title = data.title, //title为不包含后缀名的数据
                fileName = data.fileName,
                fileExt = data.extension,
                file = fileName + '.' + data.fileExt, //file为包含后缀名的数据
                src = path.join(path.trimPosix(Config.binPath), 'user/' + _ebookContext.getUser().getName() + '/books/' + data.bookCode + '/' + data.uuid + '/' + data.fileName + '.' + data.extension),
                widgetType = data.WidgetType,
                resourceId = data.fid,
                pageIndex = data.pageIndex,
                userName = data.creator;
        }
        //title解析
        var parseTitle = _resTool.parseFileName(title);
        if(parseTitle.fileName && parseTitle.fileName != ""){
            title = parseTitle.fileName;
        }else{
            //如果title为空，则将fileName赋值给title
            title = fileName;
        }


        var isHavingClass = _mainToolbar.getIsHavingClass();

        if(isHavingClass) {
            //上课状态下授课包
            var file_1 = "",
                extension = "";

            extension = fileExt;
            file_1 = title;

            var tpl = $('<li>' +
                '<div class="drawer-info">' +
                '<div class="format-number">1</div>' +
                '<div class="format-img"><img src=""></div>' +
                '</div>' +
                '<div class="format-tit"><p class="format-class"><span>{title}</span></p></div>' +
                '</li>');
            //附加属性
            tpl.attr("data-fileId", id);
            tpl.attr("data-uuid", uuid);
            tpl.attr("data-file", file);
            tpl.attr("data-resourceId", resourceId);
            tpl.find(".format-number").text(index + 1);
            //secondWidgetType是为互动卡片所特有的，互动卡片的wedgettype相同，根据二级类型不同，显示的图片不同
            tpl.find(".format-img img").attr("src", _this.setDefaultPic(extension,secondWidgetType,cardType));
            tpl.find(".format-img img").attr("alt", file_1);
            tpl.find(".format-img img").attr("title", file_1);
            //上课状态不加p标签，用于内容居中
            tpl.find(".format-tit span").text(file_1);
            tpl.find(".format-tit span").attr("title", file_1);
            tpl.on("click", function (event) {
                var currPage = _this.bookContainer.getPageIndex();
                var currUnit = _this.bookContainer.getPageMetadata(currPage);
                if(1 == data._packedFlag) {
                    var selectWidget = {};
                    if (tpl.attr("draged") == "true") {
                        return 0;
                    }
                    var isOnPage = _this.widgetArr.filter(function(el){
                        return el.uuid == uuid;
                    });
                    if(isOnPage.length == 1){
                        selectWidget = isOnPage[0];
                        _this.openTeachingFile(selectWidget);
                        event.stopPropagation();
                        return false;
                    }else{
                        console.log('widget被实例化,但不在当前视图上');
                        _this.bookContainer.getLessonRes(currUnit).done(function(unitWidget){
                            var findWidget = unitWidget.filter(function(el){
                                return el.uuid == uuid;
                            });
                            if(findWidget.length == 1){
                                var widget = findWidget[0];
                                _this.openTeachingFile(widget);
                            }
                        });
                        return false;
                    }
                }else{
                    console.log('widget未被实例化');
                    _this.bookContainer.getLessonRes(currUnit).done(function(unitWidget){
                        var findWidget = unitWidget.filter(function(el){
                            return el.uuid == uuid;
                        });
                        if(findWidget.length == 1){
                            var widget = findWidget[0];
                            var src = path.join(path.trimPosix(Config.nwexePath), 'user/' + _ebookContext.getUser().getName() + '/books/' + widget.bookCode + '/' + widget.uuid + '/' + widget.fileName + '.' + widget.extension);
                            _shellcmd.isFileExist(src).done(function (ret) {
                                if(ret){
                                    _shellcmd.shellExecute(src);
                                }else{
                                    console.log('资源不存在，打开资源失败');
                                }
                            });
                        }
                    });
                    return false;
                }

                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid: _ebookContext._curUser._uid,
                    module: '01014',
                    type: 'trigger'
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
            });
            dom.append(tpl);
        } else {
            //下课状态下授课包
            var file_1 = "",
                extension = "";

            extension = fileExt;
            file_1 = title;

            var tpl = $('<li class="">' +
                '<div class="format-number"></div>' +
                '<div class="format-img"><img></div> ' +
                '<div class="format-tit"><p><span><a>{title}</a></span></p></div>' +
                '</li>');
            //附加属性
            tpl.attr("data-fileId", id);
            tpl.attr("data-uuid", uuid);
            tpl.attr("data-file", file);
            tpl.attr("data-resourceId", resourceId);
            tpl.find(".format-number").text(index + 1);
            //secondWidgetType是为互动卡片所特有的，互动卡片的wedgettype相同，根据二级类型不同，显示的图片不同
            tpl.find(".format-img img").attr("src", _this.setDefaultPic(extension,secondWidgetType,cardType));
            tpl.find(".format-img img").attr("alt", file_1);
            tpl.find(".format-tit a").text(file_1);
            tpl.find(".format-tit a").attr("title", file_1);
            tpl.find(".format-tit").find("a").on("click", {uuid:uuid,pageIndex:pageIndex}, function (event) {
                var currPage = _this.bookContainer.getPageIndex();
                var currUnit = _this.bookContainer.getPageMetadata(currPage);
                if(1 == data._packedFlag) {
                    var selectWidget = {};
                    if (tpl.attr("draged") == "true") {
                        return 0;
                    }
                    var isOnPage = _this.widgetArr.filter(function(el){
                        return el.uuid == uuid;
                    });
                    if(isOnPage.length == 1) {
                        selectWidget = isOnPage[0];

                        $(".user-popover").hide();
                        _this.openTeachingFile(selectWidget);
                        event.stopPropagation();
                        return false;
                    }else{
                        console.log('widget被实例化,但不在当前视图上');
                        _this.bookContainer.getLessonRes(currUnit).done(function(unitWidget){
                            var findWidget = unitWidget.filter(function(el){
                                return el.uuid == uuid;
                            });
                            if(findWidget.length == 1){
                                var widget = findWidget[0];
                                _this.openTeachingFile(widget);
                            }
                        });
                        return false;
                    }
                }else{
                    // widget未被实例化，转页后执行打开资源操作
                    console.log('widget未被实例化');
                    //策略一：采用本地软件打开策略
                    // _this.bookContainer.getLessonRes(currUnit).done(function(unitWidget){
                    //     var findWidget = unitWidget.filter(function(el){
                    //         return el.uuid == uuid;
                    //     });
                    //     if(findWidget.length == 1){
                    //         var widget = findWidget[0];
                    //         var src = path.join(path.trimPosix(Config.nwexePath), 'user/' + _ebookContext.getUser().getName() + '/books/' + widget.bookCode + '/' + widget.uuid + '/' + widget.fileName + '.' + widget.extension);
                    //         _shellcmd.isFileExist(src).done(function (ret) {
                    //             if(ret){
                    //                 _shellcmd.shellExecute(src);
                    //             }else{
                    //                 console.log('资源不存在，打开资源失败');
                    //             }
                    //         });
                    //     }
                    // });
                    //策略二：跳转到资源所在页，然后进行预览
                    var pageIndex = event.data && event.data.pageIndex || '';
                    if(!pageIndex){
                        console.error("widget未被实例化，打开文件未找到pageIndex,pageIndex=%s",pageIndex);
                        return false;
                    }
                    var pageIndex = parseInt(pageIndex);
                    _this.bookContainer.setPageIndex(parseInt(pageIndex));
                    $(document).data('openPreviewFileFrame',{uuid:uuid});
                    $(document).one('openPreviewFileFrame',{uuid:uuid},function(event){
                        var uuid = event.data && event.data.uuid || '';
                        if(uuid){
                            var dom = $('#sortUl').find("li[data-uuid = " + uuid + "]");
                            if(dom.length > 0){
                                var s = dom.find(".format-number").text();
                                console.log('handle openPreviewFrame,序号' + s);
                                $(dom).find(".format-tit").find("a").trigger('click');
                            }else{
                                console.warn('跳转后在授课包列表里未找到指定序号的DOM');
                            }
                            $(document).removeData('openPreviewFileFrame');
                            $(document).off('openPreviewFileFrame');
                        }
                    });
                    console.log('资源不在当前视图，需要转页');
                    return false;
                }

                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid: _ebookContext._curUser._uid,
                    module: '02006',
                    type: 'trigger'
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
            });
            tpl.on("mouseover", {uuid:uuid}, function (event) {
                var isHavingClass = _mainToolbar.getIsHavingClass();
                var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
                if(!isHavingClass && isTeachingPackage) {
                    var uuid = event.data.uuid;
                    if (uuid) {
                        var findWidget = _this.widgetArr.filter(function (el) {
                            if (1 == el._packedFlag) {
                                return el.uuid == uuid;
                            } else {
                                return false;
                            }
                        });
                        if (findWidget.length > 0) {
                            var target = findWidget[0];
                            var Obj = _ebookContext.getUnTransForm();
                            var _dom = $(target.Content);
                            _dom.find(".format-bignumber").css("-webkit-transform", "matrix(" + (1 * Obj.wZoom) / (Obj.wZoom * 0.7) + ", 0, 0, " + (1 * Obj.hZoom) / (Obj.hZoom * 0.7) + ", 0, 0)");
                            return false;
                        }
                    }
                }
            }).on('mouseout', {uuid:uuid}, function(event){
                var isHavingClass = _mainToolbar.getIsHavingClass();
                var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
                if(!isHavingClass && isTeachingPackage) {
                    var uuid = event.data.uuid;
                    if (uuid) {
                        var findWidget = _this.widgetArr.filter(function (el) {
                            if (1 == el._packedFlag) {
                                return el.uuid == uuid;
                            } else {
                                return false;
                            }
                        });
                        if (findWidget.length > 0) {
                            var target = findWidget[0];
                            if (target.Content) {
                                var _dom = $(target.Content);
                                var Obj = _ebookContext.getUnTransForm();
                                _dom.find(".format-bignumber").css("-webkit-transform", "matrix(1, 0, 0, 1, 0, 0)");
                                return false;
                            }
                        }
                    }
                }
            });
            dom.append(tpl);
        }
    };

    TeachingPackage.prototype.scrollToMinPosition = function(){
        var _this = this;
        if (_this.widgetArr.length > 0) {
            // 待跳转的最小序号uuid
            var uuid_min_sn;
            // 当前视图中widget的uuid合集
            var uuidsOnPage = [];
            _this.widgetArr.forEach(function (val, index, arr) {
                if (1 == val._packedFlag) {
                    var uuid = val.uuid;
                } else {
                    var uuid = val.uuid;
                }
                uuidsOnPage.push(uuid);
            });

            //取得unit的排序信息，并找到页面最小序号的uuid
            var currPage = _this.bookContainer.getPageIndex();
            var currUnit = _this.bookContainer.getPageMetadata(currPage);
            var currUnitSortedWidgets = _this.getSortedDataByUnit(currUnit);
            for (var u = 0, u_count = currUnitSortedWidgets.length; u < u_count; u++) {
                var item = currUnitSortedWidgets[u];
                if (-1 != $.inArray(item.id, uuidsOnPage)) {
                    uuid_min_sn = item.id;
                    break;
                }
            }

            var selectWidget = {};
            if (uuid_min_sn) {
                var widgets = _this.widgetArr.filter(function (el) {
                    return el.uuid == uuid_min_sn;
                });
                if (widgets.length == 1) {
                    selectWidget = widgets[0];
                    if(1 == selectWidget._packedFlag){
                        selectWidget.scrollToPosition(selectWidget);
                    }
                } else {
                    console.log('异常');
                }
            } else {
                //通过排序信息没有在页面上找到最小序号，不作处理
            }
        } else {
            //页面数据为空，不作处理
        }
    };
    exports.Instance = new TeachingPackage();
});