/**
 * Created by njfu@iflytek.com on 2016/10/20.
 */
define(function(require, exports) {

    // 通过 require 引入依赖
    var _resAccessor = require('./resaccessor').Instance,
        _cloudresourceBase = require('./cloudresourcebase'),
        _recommendResUrl = AppRemoteSvcCfg.ResBatch,
        _ebookContext = require('../../ebookcontext').Instance,
        _mainToolbar = require('../toolbar/maintoolbar'),
        path = require('../../../common/path'),
        _resourceContentPage = require('./resourcecontent').Instance,
        _pageItem = require('../pageitem').Instance,
        shellcmd = require('../../../common/shellcmd'),
        _syncRecommend = require('../../book/smartbar/SyncRecommend'),
        _resTool = require('./restool');
    function selectedresource(){
      var _this = this;
          _this.buttons = {};
          _this.controls = {};
          _this.bookContainer = "";
          _this.widgeArr = [];
          _this.selectedItem=null;
          _this.selectedList = {
            origin: [],
            data: [],
            centerRes_data: [],
            total: 0,
            payable_source:[],
            totaldemand_score:0,
            downloadList:[],
            recommendList:[] //当前目录下的分类推荐资源，供相关推荐使用
      };
    }

    selectedresource.prototype = new _cloudresourceBase();
    /**
     *页面初始化
     * */
    selectedresource.prototype.init = function(bookContainer,smartBarEle){
      var _this = this;
      _this.bookContainer = bookContainer;
      _this.smartBarEle = smartBarEle;
      _this.buttons = {
            //2016-09-20 Add
            select_add:$("#select_add"),
            select_cancel:$("#select_cancel"),
            select_batchAdd:$("#select_batchAdd"),
            deleteSyncRecommend:$("#deleteSyncRecommend"),
            //2016-09-26 11:45 added by linwang5iflytek.com
            uploadSyncRecommend:$('#uploadSyncRecommend'),
            //2016-11-4 by njfu@iflytek.com
            updateSyncRecommend:$('#updateSyncRecommend')
        };
      _this.controls = {
            selectedContainer: $(".J_selected_content"),
            //2016-09-20 Add
            selectedList:$("#selectedList")
        };
      //事件绑定
      _this.registerEvent();
    };

    /**
     *同步精选根据资源id获取
     * */
    selectedresource.prototype.getSelectedByPage= function(param){
        var defArr = [];
        var _all_defer = $.Deferred();
        for(var i =0;i<param.allPage.length;i++){
            var p = {
              book:param.book,
              bookPage:param.allPage[i],
              page:1,
              limit:10
            } 
            var defer = edcService.Instance().ersp_resource_perfect_list(p);
            defArr.push(defer);
        }
        $.when.apply(this,defArr).done(function () {
            _all_defer.resolve(arguments);
        }).fail(function(e){
          _all_defer.reject(e);
        });
        return _all_defer.promise();
    };

     /**
     *取得相关推荐资源（取当前单元随机10个资源）
     * */
    selectedresource.prototype.originRes = function(){
        var _this =this;
        var pageMeta = _this.bookContainer.getCurrPageMetadata();
        // var a = {
        //   unit1:pageMeta.unit1 || "",                //目录1
        //   unit2:pageMeta.unit2 || "",                //目录2
        //   unit3:pageMeta.unit3 || "",                //目录3
        //   unit4:pageMeta.unit4 || "",                //目录4
        //   origin_list:[]
        // }
        var grade = (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.grade) || "";
        var subject =(_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.subject) || "";
        var book = (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.bookCode) || "";
        //如果是pdf文件，取到的bookcode是pdf_87843612这样的格式，需要转换为检索到的bookcode，如021-896523这种格式
        // if(book.indexOf("pdf_")!=1&&app_global_pdfInfo.bookCode){
        //     book=app_global_pdfInfo.bookCode;
        // }
        var extension = "doc,docx,rmvb,mp4,avi,wmv,asf,3gp,flv,mpg,mpeg,mpeg4,rm,mpeg4,mov,vob,mkv,m2ts,swf,flash,pic,gif,mov,flv,flc,fla,mpeg,mp3,wma,wav,ogg,ape,mid,midi,tch,**,jpg,jpeg,bmp,png,gif,psd,gsp,gss,ppt,pps,ppsx,pptx";
        var request_param = {
            subject: subject,            //学科
            // grade: "",              //年级
            // publisher: "",          //出版社
            edition: "",            //教材版本
            phase: _this.grade2phase(grade),              //学段
            stage: "",              //年级册别
            quality: "",          // 20-普通资源 21-精品资源
            topic: "08",          // 08 - 同步资源
            book: book,               //书本
            thumbsize: "",   //图片大小
            unit1:pageMeta.unit1 ||  "",                //目录1
            unit2:pageMeta.unit2 ||  "",                //目录2
            unit3:pageMeta.unit3 ||  "",                //目录3
            unit4:pageMeta.unit4 ||  "",                //目录4
            order: "",              //排序
            type: "",               //资源类型
            // volume:"", //册别，这里字段名称为 volume ，程序里用volumn，两者含义一致。
            q: "",                  //关键词
            page: 1,
            extension: extension,          //指定后缀文件筛选
            sortField: "",          //指定下载筛选字段
            sortType: "desc",          //指定下载筛选字段
            source: "IFLYTEK,UGC,MAISUI,XIAOBENZIYUAN,ZHONGBAO,RENJIAOJIAOFU,KXX,GUOJIA,CHANGYAN",//指定下载筛选字段
            limit: "10"
        };
        edcService.Instance().ersp_resource_list(request_param).done(function(ret){
          if(ret && ret.code==0 && ret.data.data){
            console.log(ret);
            // a.origin_list = ret.data.data;
            _this.selectedList.recommendList = ret.data.data;
          }else{
            console.log("请求失败！");
          }
        }).fail(function(e){
            console.log(e);
        });
    };
    /**
     *相关推荐资源批量转化
     * */
     selectedresource.prototype.originResFromOld = function(data){
        var resList = [];
        for(var i =0;i<data.length;i++){
          var item = _resAccessor.resFormatOld(data[i]);
          resList.push(item);
        }
        return resList;
     }
    

    /**
     *同步精选列表数据收集
     * */
    selectedresource.prototype.getSelectedRes = function(){
        var _this = this;

        //遮罩
        _this.controls.selectedContainer.find(".J_show").hide();//隐藏下方按钮
        var info = {
            "status": "resource_loading",
            "tips": "资源加载中...",
            "from": "rescontent"
        };
        _this.renderResStatus(_this.controls.selectedContainer.find("#selectedList"), info);

        var selectedPageList = [];
        _this.originRes();
        _this.selectedList.origin = [];
        $(".selected-bubble").remove();
        // _this.controls.selectedContainer.find(".J_show").hide();
        _this.controls.selectedContainer.find(".J_hidden").hide();
        _this.controls.selectedContainer.find(".format-checkbox").hide();

        var curPage = _this.bookContainer.getPageIndex();
        var viewType = _this.bookContainer.getPageViewType();
        var param ={
            book:_this.bookContainer.bookMetaInfo.bookCode,
            allPage:[],
            bookPage:curPage,
            page:1,
            limit:100
        }
        if(viewType == 3){
            param.allPage.push(curPage);
        }else if(viewType == 1 || viewType == 2){
            param.allPage.push(curPage);
            param.allPage.push(curPage+1);
        }
        shellcmd.checkOnline().done(function (ret) {
            if (!ret) {
                var info = {
                    "status": "net_error",
                    "tips": "网络异常"
                };
                _this.renderResStatus(_this.controls.selectedList, info);
                return 0;
            }else{
              _this.getSelectedByPage(param).done(function(ret){
                if(ret.length > 0){
                    for(var i= 0;i<ret.length;i++){
                      if(ret[i] && ret[i].code == 0){
                         if(ret[i].data && ret[i].data.data && ret[i].data.data.length > 0){
                            var res = ret[i].data.data;
                            selectedPageList=selectedPageList.concat(res);
                         }
                      }else{
                        var info = {
                            "status": "request_error",
                            "tips": "网络请求失败"
                        };
                        _this.renderResStatus(_this.controls.selectedList, info);
                      }
                    }
                    _this.selectedList.origin = selectedPageList;
                    if(selectedPageList.length > 0){
                      _this.render(selectedPageList);
                    }else{
                      var info = {
                          "status": "empty",
                          "tips": "暂无资源"
                      };
                      _this.renderResStatus(_this.controls.selectedList, info);
                    }
                }else{
                  var info = {
                          "status": "empty",
                          "tips": "暂无资源"
                      };
                      _this.renderResStatus(_this.controls.selectedList, info);
                }
              }).fail(function(e){
                  var info = {
                      "status": "request_error",
                      "tips": "网络请求失败"
                  };
                  _this.renderResStatus(_this.controls.selectedList, info);
              });
            }
        });

    };

    /**
     *资源列表展示
     * */
    selectedresource.prototype.render = function(data){
        var _this = this;
        //页面气泡清空
        $(".selected-bubble").remove();
        var $selectedList = _this.controls.selectedContainer.find("#selectedList");
        var $selectedList_res_ul = $selectedList.find(".resources-list");
        if($selectedList.length == 0){
            _this.controls.selectedContainer.html('<div id="selectedList" class="resources"></div>');
            $selectedList = _this.controls.selectedContainer.find("#selectedList");
        }
        var appendStr = '<ul class="resources-list" name="selectedItem"></ul>';

        $selectedList.html(appendStr);

        /**
         * //留给自由组做上传按钮显示的配置
         */
        if(json.selectedResource.syncRecommend){
            $("#uploadSyncRecommend").parent().show();
        }else{
            $("#uploadSyncRecommend").parent().hide();
        }

        if(data.length > 0){
            $($selectedList_res_ul).show();
            _this.controls.selectedContainer.find(".J_show").show();
            var selectedItem = $("ul[name='selectedItem']");
            for(var i = 0;i<data.length;i++){
              var li = $('<li name="selectedTemplate" draggable="false">' +
                  '<div class="format-checkbox" style="display: none"><input name="" type="checkbox" value="" class="ckb_box"></div>' +
                  '<div class="format-img"><img draggable="false" src=""></div>' +
                  /*'<div class="format-tit"><p  class=" format-jh"><span>{title}</span></p></div>'  +*/
                  '<div class="format-tit"><p><span>{title}</span><i class="new" style="display:none;" name="new"></i></p></div>' +
                  '</li>');
              data[i].extension = data[i].resourceName.substring(data[i].resourceName.lastIndexOf(".")+1);    
              data[i].fileName= data[i].resourceName.substring(0,data[i].resourceName.lastIndexOf("."));
              var widget_id = data[i].reserve1 || "";
              var default_pic = _this.setDefaultPic(data[i].extension);
              //li.attr("resourceId", data[i].resourceId);
              li.attr("id", data[i].resourceId);
              li.attr("rid", data[i].rid);
              li.attr("widget_id", widget_id);
              li.attr("data-extension", data[i].extension);
              li.find('img').attr("src", default_pic);
              li.find(".format-tit").find('span').text(data[i].fileName);
              li.find(".format-tit").find('span').attr("title", data[i].fileName);
                li.on("mouseover", {resId: data[i].resourceId},function (event) {
                    var isHavingClass = _mainToolbar.getIsHavingClass();
                    var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
                    if(!isHavingClass && !isTeachingPackage) {
                        var resId = event.data.resId;
                        if (resId) {
                            var currPageRes = _this.bookContainer.getCurrentPageRes();
                            var findWidget = currPageRes.filter(function (el) {
                                if (1 == el._packedFlag) {
                                    return el.resourceId == resId;
                                } else {
                                    return false;
                                }
                            });
                            if (findWidget.length > 0) {
                                var target = findWidget[0];
                                var Obj = _ebookContext.getUnTransForm();
                                var _dom = $(target.Content);
                                _dom.find(".format-bignumber").css("-webkit-transform", "matrix(" + (1 * Obj.wZoom) / (Obj.wZoom * 0.7) + ", 0, 0, " + (1 * Obj.hZoom) / (Obj.hZoom * 0.7) + ", 0, 0)");
                                return false;
                            }
                        }
                    }
                }).on('mouseout', {resId: data[i].resourceId}, function(event){
                    var isHavingClass = _mainToolbar.getIsHavingClass();
                    var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
                    if(!isHavingClass && !isTeachingPackage) {
                        var resId = event.data.resId;
                        if (resId) {
                            var currPageRes = _this.bookContainer.getCurrentPageRes();
                            var findWidget = currPageRes.filter(function (el) {
                                if (1 == el._packedFlag) {
                                    return el.resourceId == resId;
                                } else {
                                    return false;
                                }
                            });
                            if (findWidget.length > 0) {
                                var target = findWidget[0];
                                if (target.Content) {
                                    var _dom = $(target.Content);
                                    var Obj = _ebookContext.getUnTransForm();
                                    _dom.find(".format-bignumber").css("-webkit-transform", "matrix(1, 0, 0, 1, 0, 0)");
                                    return false;
                                }
                            }
                        }
                    }
                });
              if (-1 != $.inArray(data[i].resourceId, _this.getHasDownload("hasDownload"))) {
                  li.addClass("gray");
              }
              if(_this.isNewRes(data[i])){
                  li.find(".format-tit").find('p').addClass("format-jh");
                  li.find("i[name=new]").show();
              }else{
                  li.find("i[name=new]").remove();
              }
              //列表展示
              selectedItem.append(li);
              //对应页面添加气泡
              _this.addContent(data[i]);
              //信息存入数组
              _this.selectedList.data.push(data[i]);
            }
        }else{
            //资源为空
            var info = {
                "status": "empty",
                "tips": "暂无资源"
            };
            _this.renderResStatus(_this.controls.selectedList, info);
            _this.controls.selectedContainer.find(".J_show").hide();
        }
    };

    /**
     *灰色气泡展示
     *
     *@param res 资源信息
     * */
     selectedresource.prototype.addContent = function(res){
        var _this = this;
        //当前页码
        var currentPageIndex = _this.bookContainer.getPageIndex();
        //单双页
        var viewType = _this.bookContainer.getPageViewType();
        //获取当前页面上的资源
        var curpageRes = _this.bookContainer.getCurrentPageRes();
        //气泡生成
        var curpageRes_rlist = curpageRes.filter(function(el){
            return el.md5 == res.md5;
        });
        if(curpageRes_rlist.length ==0){
          var bubble = _this.setContent(res,viewType);
          if(viewType == 1 || viewType == 2){
              if(res.bookPage == currentPageIndex){
                  $(".leftPageWrapper").find(".pageItem").append(bubble);
              }else{
                  $(".rightPageWrapper").find(".pageItem").append(bubble);
              }
          }else{
              $(".viewdom").append(bubble);
          }
        }else{
          curpageRes_rlist[0].resourceId = res.resourceId;
        }
     };

    /**
     *判断资源状态
     *
     *@param res 资源信息
     * */
     selectedresource.prototype.isNewRes = function(res){
        //判断规则：reserve1拓展字段，如果 == 0则为更新资源；如果为空则为新上传的资源
        var _this = this;
        var isnew = false;
        if(res.reserve1 && res.reserve1 != 0){
          //使用上传工具上传的资源
          isnew = false;
        }else{
          var now=Date.parse(new Date());
          var updateTime=Date.parse(res.updateTime);
          var day=parseInt((now-updateTime)/(1000*60*60*24));
          console.log(day+"天");
          if(res.createTime == res.updateTime && !res.reserve1){
            //新上传的资源
            if(day>json.selectedResource.new_day){
              isnew = false;
            }else{
              isnew = true;
            }
          }else{
            //更新的资源
            if(res.reserve1 == 0){
              if(day>json.selectedResource.new_day){
                isnew = false;
              }else{
                isnew = true;
              }
            }
          }
        }
        return isnew;
     };

    /**
     *生成灰色默认气泡
     *
     *@param res 资源信息
     * */
     selectedresource.prototype.setContent = function(res,viewType){
        var Obj = _ebookContext.getUnTransForm();
        var widget_id = res.reserve1 || "";
        var content = $('<div class="jxbubble-positioning selected-bubble" widget_id="'+widget_id+'" id="bubble_'+res.resourceId+'"  style="position: absolute;-webkit-transform:matrix('+ Obj.wZoom*0.7 + ",0,0," + Obj.hZoom*0.71 + ",0,0"+ ');"></div>')
            .append('<div class="format-bignumber2 format-number" draggable="false"></div>')
            .css({
                'top': Math.abs(res.positionY) + 'px',
                'left':Math.abs(res.positionX) + 'px'
            });
        var a = $(".J_selected_content").is(":visible");
        if(a){
            content.css("display","block");
        }else{
            content.css("display","none");
        }
        //鼠标移到气泡上触发时间
        (this.style && this.style.tiny !== 'true') ? (content.find("#tiny").hide()) : content.find("#normal").hide();
        return content;
     };

     /**
     *生成资源小详情框
     *
     *@param res 资源信息
     * */
     selectedresource.prototype.setSmartPop = function(res){
        var _this = this; 
        var _selectedRes = res; 
        $("#smartbar_pop").remove();
        var smartbar_pop = $(
            '<div class="jxpop-box w290 selectedresource" style="position:absolute;z-index:10;" id="smartbar_pop" resourceId="" >' +
            '<div class="jxpop-main">' +
            '<div class="jxpop-taba mlr5">' +
            '<p class="fsize14" name="res_title">与西湖相关的古诗</p>' +
            '<p><button type="button" class="btn-gray" id="select_reviewResContent">查看详情</button></p>' +
            '</div>' +
            '<div class="jxpop-poety selected-pop">' +
            '<button type="button" class="btn-black left" id="smart_img_pre"><i class="icon iconfont">&#xe625;</i></button>' +
            '<button type="button" class="btn-black right" id="smart_img_next"><i class="icon iconfont">&#xe626;</i></button>' +
            '<img name="res_image" id="viewImg" src=""  >' +
            '</div>' +
            '<div class="editor_text text_ellipsis" name="description">' +
            '雪孩子变成了白云，雪孩子变成了白云。雪孩子变成了白云。' +
            '</div>' +
            '<div class="ma5">' +
            '<p class="mt5">资源作者：<a  name="auth_name"  class="blue">李老师</a></p>' +
            '<span class="star2"><em name="resourceStarsId" style="width:70%;"></em></span>' +
            '</div>' +
            '</div>' +
            '<div class="jxpop-btnbar">' +
            '   <button type="button" class="btn-blue" id="addToBook_selected"><i class="icon iconfont"  >&#xe603;</i>加入课本</button>' +
            '</div>' +
            '</div>');
        //根据是否已经存在小资源弹框，来判断是加载还是隐藏弹窗
        if (($("#smallPreviewviewBox").is(":visible") && $("#smartbar_pop").length != 0) && ($("#smartbar_pop").attr("resourceid") == _that.id)) {
            $("#smallPreviewviewBox").empty();
        } else {
            $("#smallPreviewviewBox")[0].style.display = "block";
            $("#smallPreviewviewBox").empty();
            //取当前页面显示类型 --单双页
            var viewType = _this.bookContainer.getPageViewType();
            if(viewType == 3){
                $(".viewdom").append(smartbar_pop);
                $(".pageItem").mouseup(function(){
                    $("#smartbar_pop").remove();
                });
            }else if(viewType == 1 || viewType == 2){
                $("#smallPreviewviewBox").append(smartbar_pop);
            }
            //$("#smallPreviewviewBox").show();
        };
        var Obj = _ebookContext.getUnTransForm();
        var left = parseInt($("#bubble_"+_selectedRes.id).css("left"))/Obj.wZoom;
        var top = parseInt($("#bubble_"+_selectedRes.id).css("top"))/Obj.hZoom;
        var canvas_top = parseInt($(".pageItem").css("height"))/Obj.hZoom;
        var canvas_left = parseInt($(".pageItem").css("width"))/Obj.wZoom;
        var pop_width =  parseInt($("#smartbar_pop").css("width"));
        var buble_width = parseInt($(".selected-bubble").css("width"));
        //取当前页码
        var currentPageIndex = _this.bookContainer.getPageIndex();
        $("#smartbar_pop").css({
            position: "absolute",
            "z-index": 10
        });
        if(left >= (pop_width+buble_width +10) ){
            if(currentPageIndex != _selectedRes.extra.bookPage){
                left = left + canvas_left;
            }
            if(viewType == 3){
                $("#smartbar_pop").css("left", left - (pop_width + buble_width));
            }else if(viewType == 1 || viewType == 2){
                $("#smartbar_pop").css("left", $(".J_resource_center_bar").width() + left - (pop_width + 10));
            }
        }else{
            if(currentPageIndex != _selectedRes.extra.bookPage){
                left = left + canvas_left;
            }
            if(viewType == 3){
                $("#smartbar_pop").css("left",left+ buble_width/2 + 10);
            }else if(viewType == 1 || viewType == 2){
                $("#smartbar_pop").css("left", $(".J_resource_center_bar").width() + left + buble_width/2 + 10);
            }
        }

        if(top >= 175){
            if(viewType == 3){
                if((top + 175 + 30) > canvas_top){
                    $("#smartbar_pop").css("bottom",5);
                }else{
                    $("#smartbar_pop").css("top",top - 175);
                }
            }else if(viewType == 1 || viewType == 2){
                if((top + 175 + 30) > canvas_top){
                    $("#smartbar_pop").css("bottom",58 + 5);
                }else{
                    $("#smartbar_pop").css("top",top - 175 + 30);
                }
            }
        }else{
            $("#smartbar_pop").css("top",30 + 5);
        }
        $("#smartbar_pop").attr('resourceId', _selectedRes.id);
        smartbar_pop.find("a[name='auth_name']").html(_selectedRes.creator);
        smartbar_pop.find("a[name='auth_name']").attr('contend-name', _selectedRes.uploader);
        smartbar_pop.find("div[name='description']").html($.trim(_selectedRes.description).replace(/[\r\n]/g, ""));
        smartbar_pop.find("div[name='description']").attr("title", $.trim(_selectedRes.description).replace(/[\r\n]/g, ""));
        var _title = "";
        if (_selectedRes.title && _selectedRes.title.length > 10)
            _title = _selectedRes.title.substr(0, 10) + "···";
        else
            _title = _selectedRes.title;

        smartbar_pop.find("p[name='res_title']").attr("title", _selectedRes.title).html(_title);
        if (_selectedRes.statistics) {
            smartbar_pop.find("em[name='resStar']").css("width", _selectedRes.statistics.score + "%");
        }

        //评价分数
        if (_selectedRes) {
            //如果有分数，使用分数，如果数据中没有分数，使用scorecount*20来代替分数（scorecount*20相对不够准确）
            if (_selectedRes.statistics.score == "0" || !_selectedRes.statistics.score) {
                var percent = _selectedRes.statistics.scorecount * 20 + "%";
            } else {
                var percent = _selectedRes.statistics.score + "%";
            }
        } else {
            if (_selectedRes.statistics.score == "0" || !_selectedRes.statistics.score) {
                var percent = _selectedRes.statistics.scorecount * 20 + "%";
            } else {
                var percent = _selectedRes.statistics.score + "%";
            }
        }
        $('em[name="resourceStarsId"]').css("width", percent);
        //多张缩略图
        if (_selectedRes && _selectedRes.screenshot && _selectedRes.screenshot[2]) {
            //screenshots 有，不用单缩略图
            $("#viewImg").remove();
            $("#smart_img_pre").show();
            $("#smart_img_next").show();
            var _imgTemp = null;
            for (var temp in _selectedRes.screenshot) {
                if (temp == 1) {
                    _imgTemp = $('<img name="res_image" class="img_show" src="assert/images/default_01.jpg" >');
                } else {
                    _imgTemp = $('<img name="res_image" class="img_hide" src="assert/images/default_01.jpg" >');
                }
                _imgTemp.attr("src", _selectedRes.screenshot[temp]);
                smartbar_pop.find(".selected-pop").append(_imgTemp);
            }
        } else {
            $("#smart_img_pre").hide();
            $("#smart_img_next").hide();
            if (_selectedRes.thumburl){
              $("#viewImg").attr("src", _selectedRes.thumburl);
            }else{
              $("#viewImg").attr("src",_this.setDefaultThumbnail(_selectedRes.extension));
            }
        };

        $("#addToBook_selected").attr("rid", _selectedRes.extra.rid);
        $(".selected-pop").attr("rid", _selectedRes.extra.rid);
        $("#select_reviewResContent").attr("rid", _selectedRes.extra.rid);
        return smartbar_pop;
     };
    // 逐个资源依次进行扣费（批量下载）
    selectedresource.prototype.deductScore=function(arr,index,deffer){
        var dtd=deffer;
        var resultData=arr;
        if(!resultData[index]){//如果resultData[index]不存在，返回
            dtd.resolve();
        }else{
            var need_credit=resultData[index].exchangeCredit;
            var resourceid=resultData[index].id;
            var title= resultData[index].title;
            var param ={
                userId:_ebookContext.getUser().getUid(),
                action:"download",
                score:-need_credit,
                resId:resourceid,
                data:title
            };
            edcService.Instance().ersp_resource_user_credit_update(param).done(function(ret){
                index++;
                _this.deductScore(resultData,index,dtd);
            }).fail(function(err){
                index++;
                _this.deductScore(resultData,index,dtd);
            })
        }
        return dtd;
    }

    /**
     *事件绑定
     * */
    selectedresource.prototype.registerEvent = function(){
        console.log("registerEvent");
        var _this = this;
        //TODO:这里不仅仅只是单双页切换，后期考虑放在同一个入口处
        //单双页切换
        $(_this.bookContainer).bind('bookViewChanged',function(){
            if(!_isHavingClass){
                $("#smartbar_pop").remove();
                _this.getSelectedRes();
            }
        });

        //批量添加状态切换
        _this.buttons.select_batchAdd.click(function(){
            _this.controls.selectedContainer.find(".J_show").hide();
            _this.controls.selectedContainer.find(".J_hidden").show();
            _this.controls.selectedContainer.find(".format-checkbox").show();
        });
        //返回添加状态切换
        _this.buttons.select_cancel.click(function(){
            _this.controls.selectedContainer.find(".J_show").show();
            _this.controls.selectedContainer.find(".J_hidden").hide();
            _this.controls.selectedContainer.find(".format-checkbox").hide();
            $("#selectedList").find("input").attr('checked', false).prop("checked", false);
        });

        //同步精选-批量删除
        _this.buttons.deleteSyncRecommend.click(function(){
            $("#smartbar_pop").remove();//移除资源弹框
            var checkedRes = [];
            var $itemDom = _this.common_operate("find",["#selectedList","li"]);
            for (var i = 0 ;i < $itemDom.length ; ++i){
                if(_this.common_operate('find' , [$itemDom[i] , 'input']).is(":checked")){
                    var data_id = _this.common_operate('getAttribute', [$itemDom[i], 'rid']);
                    checkedRes.push(data_id);
                }
            }
            if(checkedRes.length>0){
                var param ={
                    book:_this.bookContainer.bookMetaInfo.bookCode,
                    rid:checkedRes.join()
                }
                console.log(param);
                edcService.Instance().ersp_resource_perfect_delete(param).done(function (ret) {
                    if(ret && ret.code == 0 && ret.data){
                      if(ret.data.data == true || ret.data.data == "true"){
                          _this.getSelectedRes();
                      }
                    }else{
                        var info = {
                            "status": "request_error",
                            "tips": "网络请求失败"
                        };
                        _this.renderResStatus(_this.controls.selectedList, info);
                    }
                    console.log(ret);
                }).fail(function(e){
                    console.log(e);
                });
            }else{
                tipsDialog({id:"ljshs",content:'无删除的资源'});
                return;
            }
        });

        //同步精选-更新
        _this.buttons.updateSyncRecommend.click(function(){
           $("#smartbar_pop").remove();//移除资源弹框
            var checkedRes = [];
            var $itemDom = _this.common_operate("find",["#selectedList","li"]);
            for (var i = 0 ;i < $itemDom.length ; ++i){
                if(_this.common_operate('find' , [$itemDom[i] , 'input']).is(":checked")){
                    var data_id = _this.common_operate('getAttribute', [$itemDom[i], 'rid']);
                    checkedRes.push(data_id);
                }
            }
            if(checkedRes.length==0){
                tipsDialog({id:"slected_update",content:'无更新的资源'});
                return;
            }else if(checkedRes.length>1){
                tipsDialog({id:"slected_update",content:'只支持单个资源的更新'});
                return;
            }else if(checkedRes.length==1){
                var res = _this.selectedList.origin.filter(function(el){
                  return el.rid == checkedRes[0]
                });
                if(res.length>=0){
                  _this.showbomb(res[0]);
                }
            }
        });

        //同步精选-加入课本(小详情框)
        $(document).on("click","#addToBook_selected",function(event){
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            var resultData={};
            var rid = $(this).attr("rid");
            var flag = _this.selectedList.origin.filter(function(el){
              return el.rid == rid;
            });
            $("#smartbar_pop").remove();
            edcService.Instance().api_ersp_resource_get_ext({id:flag[0].resourceId,autov:false}).done(function(ret){
              if(ret && ret.code == 0 && ret.data.data[0]){
                if (!getBlackboardFlag()){
                    resultData =_resAccessor.resFormatOld(ret.data.data[0]);
                    resultData.extra = flag[0];
                    resultData.resFrom = "selected";
                    //添加资源下载的当前页码
                    resultData.pageIndex = _download_pageIndex;
                    var userId = _ebookContext.getUser().getUid();
                    _this.selectedItem =resultData;
                    newWidgetPos = null;
                    if(resultData.payModel==1&&resultData.exchangeCredit!=0){//需要付费
                        var paydownloaded=false;
                        var params={
                            action:"download",
                            userId:userId,
                            resId:resultData.id
                        };
                        //先查询该用户是否已经对此资源付费
                        edcService.Instance().ersp_resource_user_credit_action(params).done(function(ret){
                            paydownloaded=ret.data.data;
                            //todo 开发时使用
                            //paydownloaded=false;
                            if(paydownloaded==true){//用户已付费
                                $("#pop_alreadyPay_select").show();
                            }else {//用户未付费
                                var params = {
                                    userId: userId,
                                };
                                //获得用户现在拥有的积分
                                edcService.Instance().ersp_resource_user_credit_get(params).done(function (ret) {
                                    //用户现在拥有的积分
                                    var total_credit = ret.data.data.toFixed(1);
                                    var need_credit = resultData.exchangeCredit;
                                    if (total_credit && need_credit) {
                                        $("#pop_pay_select").show();
                                        $("#pop_pay_select p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前有" + total_credit + "积分，确认下载么？";
                                        _this.selectedItem.totalCredit = total_credit;
                                    }
                                }).fail(function(err){
                                    console.log(err);
                                })
                            }
                        }).fail(function(err){
                            console.log(err);
                        })
                    }else{//不需要付费
                        var dataIds=[];
                        dataIds.push(resultData.id);
                        _this.downLoadFile(resultData);
                        _this.storageDownloading(dataIds,[resultData],'id',{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});//加入下载队列
                        var $itemDom = _this.common_operate("find",["#selectedList","li"]);//更新动画
                        var last=0;
                        for(i=0;i<$itemDom.length;i++){
                            if($itemDom[i].id==resultData.id){
                                last=i;
                                break;
                            }
                        }
                        _this.addAnimation($itemDom,last);
                    }
                    event.stopPropagation();
                    return false;
                } else {
                    var array = [];
                    array[0] = $(this).attr('srcPath');
                    _this.bookContainer.insertWidget(array[0],'');

                    //监管
                    var action = LogManager.action.trigger;
                    var params = {};
                    params.module = '1130624';
                    var user_id = _ebookContext.getUser().getUid();
                    if(user_id != '0' && user_id){
                        params.user_id =user_id;
                    }
                    LogManager.statistics(action,params);
                }
              }else{
                  _this.getResDetail(flag[0].resourceId,false).done(function(ret){
                      if(ret && ret.code==0){
                        if(ret.data.data){
                          resultData = ret.data.data;
                          resultData.extra = flag[0];
                          resultData.resFrom = "selected";
                          var dataIds=[];
                          dataIds.push(resultData.id);
                          _this.downLoadFile(resultData);
                          _this.storageDownloading(dataIds,[resultData],'id',{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});//加入下载队列
                          var $itemDom = _this.common_operate("find",["#selectedList","li"]);//更新动画
                          var last=0;
                          for(i=0;i<$itemDom.length;i++){
                              if($itemDom[i].id==resultData.id){
                                  last=i;
                                  break;
                              }
                          }
                          _this.addAnimation($itemDom,last);
                        }
                      }else{
                        console.log("请求失败！");
                      }
                  }).fail(function(e){
                    console.log(e);
                  });
              }
            }).fail(function(e){
              console.log(e);
            });
        });

        //同步精选-批量加入课本(资源条)
        _this.buttons.select_add.click(function(){
            var userId = _ebookContext.getUser().getUid();
            $("#smartbar_pop").remove();//移除资源弹框

            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;

            var selectedIds = [],//所有资源id
                selectedres_origin = [],//所有同步精选资源
                selectedRes = [],//所有资源详情
                last = 0; //最后选中的列表序号

            var $itemDom = _this.common_operate("find",["#selectedList","li"]);
            for (var i = 0 ;i < $itemDom.length ; ++i){
                if(_this.common_operate('find' , [$itemDom[i] , 'input']).is(":checked")){
                    var data_id = _this.common_operate('getAttribute', [$itemDom[i], 'id']);
                    var data = _this.selectedList.origin.filter(function(el){
                        return el.resourceId == data_id;
                    });
                    if(data.length>0){
                      selectedIds.push(data[0].resourceId);
                      selectedres_origin.push(data[0]);
                    }
                    //
                    //_this.batchadd_download(data_id);
                    last = i;
                    //选择过后，将选择状态清除将选择状态清除
                    // $($itemDom[i]).find('input').attr('checked', false).prop("checked", false);
                }
            }
            if(selectedres_origin.length==0){//如果没有勾选资源则结束
                tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "请勾选要加入课本的资源"
                });
                return ;
            }else{
                shellcmd.checkOnline().done(function(online){
                    if(online){
                        _this.getListByResIds(selectedres_origin).done(function(ret){
                            if(ret && ret.length>0){
                                for(var i=0;i<ret.length;i++){
                                    if(ret[i] && ret[i].code==0 && ret[i].data.data.length>0){
                                        var res =_resAccessor.resFormatOld(ret[i].data.data[0]);
                                        var data = selectedres_origin.filter(function(el){
                                            return el.resourceId == res.id;
                                        });
                                        res.extra = data[0];
                                        //添加下载资源时的当前页
                                        res.pageIndex = _download_pageIndex;
                                        _this.batchadd_download(res);
                                        selectedRes.push(ret[i].data.data[0]);
                                    } else {
                                        console.log(selectedres_origin[i]);
                                        (function (i) {
                                            _this.getResDetail(selectedres_origin[i].resourceId, false).done(function (ret1) {
                                                if (ret1 && ret1.code == 0) {
                                                    if (ret1.data.data) {
                                                        var res = ret1.data.data;
                                                        res.extra = selectedres_origin[i];
                                                        res.payModel = 0;
                                                        res.exchangeCredit = 0;
                                                        //添加下载资源时的当前页
                                                        res.pageIndex = _download_pageIndex;
                                                        _this.batchadd_download(res);
                                                        selectedRes.push(res);
                                                    }
                                                } else {
                                                    console.log("请求失败！");
                                                }
                                                // tipsDialog({id:_getRandomString(),content:'资源为空或不存在！'});
                                            });
                                        })(i);

                                    }
                                }
                                //有付费资源的话，将付费资源放入selectedPayableData中
                                var selectedPayableData=[];
                                for(var i=0;i<selectedRes.length;i++){
                                    //TODO 开发时使用
                                    //resultData[0].payModel=1;
                                    //resultData[0].exchangeCredit=2;
                                    if(selectedRes[i].payModel==1 && selectedRes[i].exchangeCredit!=0){

                                        selectedPayableData.push(selectedRes[i]);
                                    }
                                    _this.selectedList.downloadList.push(selectedRes[i]);
                                }
                                var dtd = $.Deferred();
                                _this.selectedList.totaldemand_score=0;
                                _this.selectedList.payable_source=[];
                                //先查询付费资源，得到一共未付费的积分数量
                                $.when(_this.getTotalNeedScore(selectedPayableData,0,dtd)).done(function(){
                                    if( selectedPayableData.length==0){//没有付费资源
                                        //更新动画
                                        var $itemDom = _this.common_operate("find",["#selectedList","li"]);
                                        _this.addAnimation($itemDom,last);
                                        _this.storageDownloading(selectedIds,selectedRes,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});//加入下载队列
                                        setTimeout(function(){
                                            $(document).dequeue("selectedIds");
                                        },100);
                                    }else if(_this.selectedList.totaldemand_score==0){//有付费资源但是所有资源都已经付费
                                        $("#batch_alreadyPay_select").show();
                                    }else{//有付费资源且有资源未付费
                                        var params = {
                                            userId: userId,
                                        };
                                        //获得用户现在拥有的积分
                                        edcService.Instance().ersp_resource_user_credit_get(params).done(function (ret) {
                                            //用户现在拥有的积分
                                            var total_credit = ret.data.data.toFixed(1);
                                            var need_credit = _this.selectedList.totaldemand_score;
                                            if (total_credit && need_credit) {
                                                $("#batch_pay_select").show();
                                                $("#batch_pay_select p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前有" + total_credit + "积分，确认下载么？";
                                                $("#batch_pay_select .btn-blue").attr("total_credit",total_credit);
                                            }
                                        }).fail(function(err){
                                            console.log(err);
                                        });
                                    }
                                });
                            }
                        }).fail(function(e){
                            console.log(e);
                        });
                    }else{
                        //网络异常
                        tipsDialog({
                            "id": "uploadToBeike" + new Date().getTime(),
                            "content": "网络异常"
                        });
                    }
                });
            }
           
        });
        
        //付费资源，扣费继续下载(批量加入课本)
        $("#batch_pay_select .btn-blue").click(function(){
            $("#batch_pay_select").hide();
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            //逐个资源依次进行扣费，所有资源扣费完成后进行下载
            var need_credit = _this.selectedList.totaldemand_score;
            var total_credit= $("#batch_pay_select .btn-blue").attr("total_credit");
            if(total_credit-need_credit>=0){
                var dtd = $.Deferred();
                var resultData= _this.selectedList.payable_source;
                $.when(_this.deductScore(resultData,0,dtd)).done(function(){
                    //获取选中列表元素id的集合和选中的最下方的元素（动画从最下方元素开始）
                    var selectedIds=[];
                    var last=0;
                    var $itemDom = _this.common_operate("find",["#selectedList","li"]);
                    for (var i = 0 ;i < $itemDom.length ; ++i){
                        if(_this.common_operate('find' , [$itemDom[i] , 'input']).is(":checked")){
                            var data_id = _this.common_operate('getAttribute', [$itemDom[i], 'id']);
                            selectedIds.push(data_id);
                            last = i;
                        }
                    }
                    //存储下载队列
                    _this.storageDownloading(selectedIds,_this.selectedList.downloadList,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});
                    //更新动画
                    _this.addAnimation($itemDom,last);
                    setTimeout(function(){
                        $(document).dequeue("selectedIds");
                    },100);
                })
            }else{
                showAlertTips("您当前积分不足");
                $(document).clearQueue("selectedIds");
            }

        });
        //付费资源：扣费取消下载(批量加入课本)
        $("#batch_pay_select .btn-gray").click(function(){//取消按钮
            $("#batch_pay_select").hide();
            $(document).clearQueue("selectedIds");
        })
        $("#batch_pay_select a").click(function(){//右上角的×
            $("#batch_pay_select").hide();
            $(document).clearQueue("selectedIds");
        })

        //付费资源：已扣费，继续下载(批量加入课本)
        $("#batch_alreadyPay_select .btn-blue").click(function(){
            $("#batch_alreadyPay_select").hide();
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            //获取选中列表元素id的集合和选中的最下方的元素（动画从最下方元素开始）
            var selectedIds=[];
            var last=0;
            var $itemDom = _this.common_operate("find",["#selectedList","li"]);
            for (var i = 0 ;i < $itemDom.length ; ++i){
                if(_this.common_operate('find' , [$itemDom[i] , 'input']).is(":checked")){
                    var data_id = _this.common_operate('getAttribute', [$itemDom[i], 'id']);
                    selectedIds.push(data_id);
                    last = i;
                }
            }
            // var recommendListOriginData = _this.recommendList.data_origin;
            //更新动画
            _this.addAnimation($itemDom,last);
            //存储下载队列
            _this.storageDownloading(selectedIds,_this.selectedList.downloadList,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});
            setTimeout(function(){
                $(document).dequeue("selectedIds");
            },100);
        })
        //付费资源：已扣费，不继续下载(批量加入课本)
        $("#batch_alreadyPay_select .btn-gray").click(function(){//取消按钮
            $("#batch_alreadyPay_select").hide();
            $(document).clearQueue("selectedIds");
        })
        $("#batch_alreadyPay_select a").click(function(){//右上角的×
            $("#batch_alreadyPay_select").hide();
            $(document).clearQueue("selectedIds");
        })

        //付费资源：已扣费，继续下载(小的资源预览框加入课本按钮)
        $("#pop_alreadyPay_select .btn-blue").click(function(){
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            var resultData = _this.selectedItem;
            var last=0;
            var dataIds=[];
            dataIds.push(resultData.id);
            var $itemDom = _this.common_operate("find",["#selectedList","li"]);
            for(i=0;i<$itemDom.length;i++){
                if($itemDom[i].id==resultData.id){
                    last=i;
                    break;
                }
            }
            _this.storageDownloading(dataIds,[_this.selectedItem],'id',{currPageMetadata:_download_currPageMetadata,pageIndex:resultData.pageIndex,bookCode:_download_bookCode});//加入下载队列
            //更新动画
            _this.addAnimation($itemDom,last);
            $("#smartbar_pop").remove();
            $("#pop_alreadyPay_select").hide();
            _this.downLoadFile(resultData);
        })
        //付费资源：已扣费，不继续下载(小的资源预览框加入课本按钮)
        $("#pop_alreadyPay_select .btn-gray").click(function(){//取消按钮
            $("#pop_alreadyPay_select").hide();
        })
        $("#pop_alreadyPay_select a").click(function(){//右上角的×
            $("#pop_alreadyPay_select").hide();
        })

               //付费资源，扣费继续下载(小的资源预览框加入课本按钮)
        $("#pop_pay_select .btn-blue").click(function(){
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            var resultData = _this.selectedItem;
            var last=0;
            var dataIds=[];
            dataIds.push(resultData.id);
 
            var $itemDom = _this.common_operate("find",["#recommendList","li"]);
            for(i=0;i<$itemDom.length;i++){
                if($itemDom[i].id==resultData.id){
                    last=i;
                    break;
                }
            }
            _this.storageDownloading(dataIds,[_this.selectedItem],'id',{currPageMetadata:_download_currPageMetadata,pageIndex:resultData.pageIndex,bookCode:_download_bookCode});//加入下载队列
            //更新动画
            _this.addAnimation($itemDom,last);
            var need_credit= parseInt(resultData.exchangeCredit).toFixed(1);//需要积分为正，下载资源扣分设置为负值
            var total_credit=parseInt(resultData.totalCredit).toFixed(1);
            var title= resultData.title;
            var resourceid= resultData.id;
            if(total_credit-need_credit>=0){
                var param ={
                    userId:_ebookContext.getUser().getUid(),
                    action:"download",
                    score:-need_credit,
                    resId:resourceid,
                    data:title
                };
                edcService.Instance().ersp_resource_user_credit_update(param).done(function(ret){
                    if(!ret||ret.code!=0){
                        tipsDialog({
                            "id": "uploading" + new Date().getTime(),
                            "content": "资源添加失败"
                        });
                        return;
                    }
                    $("#pop_pay_select").hide();
                    _this.downLoadFile(resultData);
                }).fail(function(err){
                    console.log(err);
                        tipsDialog({
                            "id": "uploading" + new Date().getTime(),
                            "content": "资源添加失败"
                        });
                        return;
                })
            }else{
                showAlertTips("您当前积分不足");
            }
        })
        //付费资源：扣费取消下载(小的资源预览框加入课本按钮)
        $("#pop_pay_select .btn-gray").click(function(){//取消按钮
            $("#pop_pay_select").hide();
        })
        $("#pop_pay_select a").click(function(){//右上角的×
            $("#pop_pay_select").hide();
        })

        //同步精选-小详情框(资源条点击)
        /*
        *为了解决一个bug附加的，资源编辑框弹出规则：筛选同步精选列表与当前视图的本地授课资源rid或resourceId或weightId相同的资源
        *如果无资源弹出小的详情框；如果只有一个则弹出对应编辑框;如果是多个再根据名称查询弹出编辑框
        */
        $(document).on("click","ul[name='selectedItem'] li, li[name=selectedTemplate]", function (e) {
            //关闭目录（目录不是由popover组件生成，暂无统一的处理办法）
            if(!$("#directory_box_left").is(":hidden")){
                $("#directory_box_left").hide();
            }
            var resourceid = $(this).attr("id");
            var rid = $(this).attr("rid");
            var widget_id = $(this).attr("widget_id");
            var flag = _this.selectedList.origin.filter(function(el){
              return el.rid == rid;
            });
            var curpageRes = _this.bookContainer.getCurrentPageRes();
            var haved_exeist = curpageRes.filter(function(el){
                // return el.resourceId == flag[0].resourceId || el.Id== flag[0].reserve1;
                return el.md5 == flag[0].md5;
            });
            if(flag.length>0){
                var res = {};

                if(haved_exeist.length == 1){
                    res = haved_exeist[0];
                }

                if(haved_exeist.length > 1){
                    //为了解决匹配多个资源的问题
            
                    var result = curpageRes.filter(function(el){
                        var fileNameParse = _resTool.parseFileName(el.File);
                        // //兼容某些File数据不带文件后缀名 解析 data.Title
                        if(fileNameParse.fileExt == ""){
                            var fileNameParse = _resTool.parseFileName(el.Title);
                        }
                        var file_title = fileNameParse.file;
                        return (el.resourceId == flag[0].resourceId || el.Id== flag[0].reserve1) && file_title == flag[0].resourceName;
                    });
                    res = result[0];
                }
                if($.isEmptyObject(res)){
                    // 关闭全局widget弹窗
                    if(app_global_curWidget && app_global_curWidget.Content){
                        if(app_global_curWidget.Content.popover('isShow','intro')){
                            app_global_curWidget.Content.popover('hide','intro');
                        }
                        if(app_global_curWidget.Content.popover('isShow','toolbar')){
                            app_global_curWidget.Content.popover('hide','toolbar');
                        }
                    }
                  _this.getResDetail(flag[0].resourceId,false).done(function(ret){
                      if(ret && ret.code==0){
                        if(ret.data.data){
                          var res = ret.data.data;
                          res.extra = flag[0];
                          _this.setSmartPop(res);
                        }
                      }else{
                        console.log("请求失败！");
                      }
                  }).fail(function(e){
                    console.log(e);
                  });
                }else{
                  // 触发蓝色气泡点击事件
                  if(res.WidgetType == "note"){
                      res.resourcePreview();
                  }else{
                      res.showEdit($("#"+res.Id),res);
                  }
                }
            } 
        });
        //同步精选-小详情框(灰色气泡点击)
        $(document).on("click",".selected-bubble", function (e) {
          var id = $(this).attr("id");
          var resourceid = id.slice(7);
          var flag = _this.selectedList.origin.filter(function(el){
            return el.resourceId == resourceid;
          });
          if(flag.length>0){
            var resourceid = flag[0].resourceId;
          }
          _this.getResDetail(resourceid,false).done(function(ret){
            if(ret && ret.code==0){
              if(ret.data.data){
                var res = ret.data.data;
                res.extra = flag[0];
                _this.setSmartPop(res);
              }
              console.log(res);
            }else{
              console.log("请求失败！");
            }
          }).fail(function(e){
            console.log(e);
          });
        });

        //通过缩略图点击进入详情页
        $(document).on("click", ".jxpop-poety.selected-pop,#select_reviewResContent", function(){
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'01016',
                type:'trigger',
                bookCode:_ebookContext.curBookCode
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            var  resultData ={};
            //隐藏弹框
            $("#smallPreviewviewBox").empty();
            var origin = [];
            var rid = $(this).attr("rid");
            var flag = _this.selectedList.origin.filter(function(el){
              return el.rid == rid;
            });
            _this.getResDetail(flag[0].resourceId,true).done(function(ret){
                if (ret && ret.code==0) {
                  if(ret.data.data){
                    if(ret.data.thumburl!=null&&ret.data.thumburl!=""){
                        resultData.thumburl = ret.data.thumburl;
                    }
                    resultData = ret.data.data;
                    resultData.screenshots= ret.data.data.screenshot;
                    resultData.resFrom = "selected";
                    resultData.extra = flag[0];
                    //请求列表接口获取付费信息
                    _this.getResListOne(flag[0].resourceId,true).done(function(list_ret){
                      if(list_ret && list_ret.code==0 && list_ret.data.data.length>0){
                        resultData.payModel = list_ret.data.data[0].payModel;
                        resultData.exchangeCredit = list_ret.data.data[0].exchangeCredit;
                        // resultData.thumburl = list_ret.data.data[0].thumbnail;
                      }else{
                        resultData.payModel = "";
                        resultData.exchangeCredit = 0;
                      }
                      resultData.origin =_this.originResFromOld(_this.selectedList.recommendList);
                      _resourceContentPage.showResContentPanel(resultData);
                    }).fail(function(e){
                      resultData.origin =_this.originResFromOld(_this.selectedList.recommendList);
                      _resourceContentPage.showResContentPanel(resultData);
                        // _this.getResDetails(_this.selectedList.origin).done(function(ret1){
                        //   for(var i=0;i<ret1.length;i++){
                        //     if(ret1[i].code == 0 && ret1[i].data.data){
                        //       origin.push(ret1[i].data.data);
                        //     }
                        //   }
                        //   resultData.origin = origin;
                        //   console.log(resultData);
                        //   _resourceContentPage.showResContentPanel(resultData);
                        // }).fail(function(e){
                        //   console.log(e);
                        // });
                        // console.log("请求失败！");
                    });
                  }
                }else{
                  console.log("请求失败！");
                }
            }).fail(function(e){
               console.log(e);
            });
        });

        //气泡与列表联动样式变化
        $(document).on("mouseover","ul[name='selectedItem'] li, li[name=selectedTemplate]",function(){
            var Obj = _ebookContext.getUnTransForm();
            var id = $(this).attr("id");
            $("#bubble_"+id).css("-webkit-transform","matrix("+Obj.wZoom+", 0, 0, "+Obj.hZoom+", 0, 0)");
        })
        $(document).on("mouseover",".selected-bubble",function(){
            var Obj = _ebookContext.getUnTransForm();
            var b_id = $(this).attr("id");
            var id = b_id.slice(7);
            $(this).css("-webkit-transform","matrix("+Obj.wZoom+", 0, 0, "+Obj.hZoom+", 0, 0)");
            $("#"+id).css({"color":"#4b99f0","background":"#e9eff2"});
        })
        $(document).on("mouseout","ul[name='selectedItem'] li, li[name=selectedTemplate]",function(){
            var Obj = _ebookContext.getUnTransForm();
            var id = $(this).attr("id");
            $("#bubble_"+id).css("-webkit-transform","matrix("+Obj.wZoom*0.7+", 0, 0, "+Obj.hZoom*0.71+", 0, 0)");
        })
        $(document).on("mouseout",".selected-bubble",function(){
            var Obj = _ebookContext.getUnTransForm();
            var b_id = $(this).attr("id");
            var id = b_id.slice(7);
            $(this).css("-webkit-transform","matrix("+Obj.wZoom*0.7+", 0, 0, "+Obj.hZoom*0.71+", 0, 0)");
            $("#"+id).css({"color":"","background":""});
        })

        //授课资源删除后气泡是否展示找回
        $(document).on("bubble_add",function(e,param){
          _this.getSelectedRes();
        });
        //mtbk导入后刷新同步精选
        $(document).on("mtbk_improt_toSelected",function(e,param){
          _this.getSelectedRes();
        });
        //同步精选资源上传后刷新同步精选
        $(document).on("upload_toSelected",function(e,param){
          _this.getSelectedRes();
        });
        //同步精选资源上传后刷新同步精选
        $(document).on("update_toSelected",function(e,param){
          _this.getSelectedRes();
        });

        $(document).on('mouseover',".format-bignumber", function(event){
            var isHavingClass = _mainToolbar.getIsHavingClass();
            var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
            // 当前频道
            var channel_cur = $("#J_selected").hasClass('btn-tabactive');
            if(!isHavingClass && !isTeachingPackage && channel_cur) {
                var _dom = $(this).parent();
                var widgetId = _dom.attr("id");
                var resId;

                if (widgetId) {
                    var widgetArr = _this.bookContainer.getCurrentPageRes();
                    var findWidget = widgetArr.filter(function (el) {
                        return el.Id == widgetId;
                    })
                    if (findWidget.length > 0) {
                        var targetWidget = findWidget[0];
                        resId = targetWidget.resourceId;
                        if (resId) {
                            var selectedData = _this.selectedList.origin;
                            var findList = selectedData.filter(function(el){
                                return el.resourceId == resId;
                            });
                            if(findList.length > 0){
                                var Obj = _ebookContext.getUnTransForm();
                                _dom.find(".format-bignumber").css("-webkit-transform", "matrix(" + (1 * Obj.wZoom) / (Obj.wZoom * 0.7) + ", 0, 0, " + (1 * Obj.hZoom) / (Obj.hZoom * 0.7) + ", 0, 0)");
                                _this.controls.selectedContainer.find("#" + resId).css({
                                    'color': '#4b99f0',
                                    'background': '#e9eff2'
                                });
                                return false;
                            }
                        }
                    }
                }
            }
        }).on('mouseout',".format-bignumber", function(event){
            var isHavingClass = _mainToolbar.getIsHavingClass();
            var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
            // 当前频道
            var channel_cur = $("#J_selected").hasClass('btn-tabactive');
            if(!isHavingClass && !isTeachingPackage && channel_cur) {
                var _dom = $(this).parent();
                var widgetId = _dom.attr("id");
                var resId;

                if (widgetId) {
                    var widgetArr = _this.bookContainer.getCurrentPageRes();
                    var findWidget = widgetArr.filter(function (el) {
                        return el.Id == widgetId;
                    })
                    if (findWidget.length > 0) {
                        var targetWidget = findWidget[0];
                        resId = targetWidget.resourceId;
                        if (resId) {
                            var Obj = _ebookContext.getUnTransForm();
                            _dom.find(".format-bignumber").css("-webkit-transform", "matrix(1, 0, 0, 1, 0, 0)");
                            _this.controls.selectedContainer.find("#" + resId).removeAttr("style");
                            return false;
                        }
                    }
                }
            }
            return false;
        });

        /**
         * 点击批量上传到资源组的功能
         */
        _this.buttons.uploadSyncRecommend.click(function () {
            var curpageRes = _this.bookContainer.getCurrentPageRes();
            var curPage = _this.bookContainer.getPageIndex();
            var unitInfo = _this.bookContainer.getCurrPageMetadata();
            _syncRecommend.init(curpageRes,curPage,_this.bookContainer.bookMetaInfo,unitInfo);
            console.log('over');
        });
        

    };

    /**
     * 获取所有id列表资源详情
     * @param resList
     */
    selectedresource.prototype.getResDetails = function(resList){
        var _this = this;
        var defArr = [];
        var _all_defer = $.Deferred();
        for(var i =0;i<resList.length;i++){
            var param={
                id: resList[i].resourceId,
                platform: resList[i].platForm || ""
            }

            var defer = edcService.Instance().ersp_resource_get(param);
            defArr.push(defer);
        }
        $.when.apply(this,defArr).done(function () {
            _all_defer.resolve(arguments);
        })
        return _all_defer.promise();
    }
     /**
     * 获取所有id列表资源详情
     * @param resList
     */
    selectedresource.prototype.getResDetail = function(resourceid,flag){
        var def = jQuery.Deferred();
        var param ={
          id:resourceid,
          autov:flag || false,
          platform:""
        }
        edcService.Instance().ersp_resource_get(param).done(function(ret){
          def.resolve(ret);
        }).fail(function(e){
            def.reject(e);
        });
        return def.promise();
    }
   /**
     * 获取所有id列表资源详情
     * @param resList
     */
    selectedresource.prototype.getResListOne = function(resourceid,flag){
        var def = jQuery.Deferred();
        var param ={
          id:resourceid,
          autov:flag || false
        }
        edcService.Instance().api_ersp_resource_get_ext(param).done(function(ret){
          def.resolve(ret);
        }).fail(function(e){
            def.reject(e);
        });
        return def.promise();
    }
    

     /**
     *同步精选-批量添加下载
     *
     */
    selectedresource.prototype.batchadd_download = function(resultData) {
        var _this = this;
        $(document).queue("selectedIds",function(){
            if (!getBlackboardFlag()) {
                resultData.resFrom = "selected";
                resultData && _this.downLoadFile(resultData);
            }
        });
    }

    /**
     *同步精选-去除付费资源中“已付费”的资源，返回还需要付费积分
     *
     */
    selectedresource.prototype.getTotalNeedScore=function(arr,index,deffer){
        var dtd=deffer;
        var _this = this;
        var resultDataArray=arr;
        var index=index;
        if(!resultDataArray[index]){//如果resultDataArray[index]无值，返回
            dtd.resolve();
        }else{
            var userId = _ebookContext.getUser().getUid();
            var paydownloaded = false;
            var params={
                action:"download",
                userId:userId,
                resId:resultDataArray[index].id
            };
            //先查询该用户是否已经对此资源付费
            edcService.Instance().ersp_resource_user_credit_action(params).done(function(ret){
                paydownloaded = ret.data.data;
                //TODO 开发时使用
                //paydownloaded=false;
                if (paydownloaded == true) {//用户已付费
                }else{
                    //用户未付费
                    _this.selectedList.totaldemand_score+=resultDataArray[index].exchangeCredit;
                    _this.selectedList.payable_source.push(resultDataArray[index]);
                }
                index++;
                _this.getTotalNeedScore(resultDataArray,index,dtd)
            }).fail(function(err){
                index++;
                _this.getTotalNeedScore(resultDataArray,index,dtd)
            })
        }
        return dtd;
    };

    /**
     *同步精选根据资源id获取
     * */
    selectedresource.prototype.getListByResIds= function(resList){
        var _this = this;
        var defArr = [];
        var _all_defer = $.Deferred();
        for(var i =0;i<resList.length;i++){
            var param={
                id: resList[i].resourceId,
                autov:false
            }
            var defer = edcService.Instance().api_ersp_resource_get_ext(param);
            defArr.push(defer);
        }
        $.when.apply(this,defArr).done(function () {
            _all_defer.resolve(arguments);
        })
        return _all_defer.promise();
    };

    /**
     * 更新弹框
     * 
     */
    selectedresource.prototype.showbomb = function(resource){
        var _this = this;
        var Domstr = $("#selected_update_wenjian")[0].innerHTML;
        var dom = $(Domstr);
        var p =[];
        //设置弹窗遮盖层
        var overlay = $('<div class="commonTipOverlay"></div>');
        overlay.css({
            "position":"fixed",
            "left":"0px",
            "top":"0px",
            "opacity":"0",
            "background": "#eee",
            "z-index": "600",
            "width": "100%",
            "height": "100%"
        });
        //设置样式 - 相对于课本内容居中
        var setedLeft = ($("#bookwarp").width() - dom.outerWidth()) / 2 + 'px';
        var setedTop = ($("#bookwarp").height() - dom.outerHeight()) / 2 + 'px';
        dom.css('left', setedLeft);
        dom.css('top', setedTop);
        dom.css('z-index', 1002);
        dom.draggable({
            cursor: "move",
            containment: $("#bookContainer"),
            handle: ".jxpop-tab"
        });

        //绑定事件
        $(dom).on("click","a[name='close']",function () {
            dom.remove();
            overlay.remove();
            //close_callback && close_callback();
        });
        $(dom).on("click","button[name='complete']",function () {
            if(p.length>0){
              var unitInfo = _this.bookContainer.getCurrPageMetadata();
              var act ="update";
              _syncRecommend.init(p,p.bookPage,_this.bookContainer.bookMetaInfo,unitInfo,act);
              dom.remove();
              overlay.remove();
            }else{
              dom.remove();
              overlay.remove();
            }
            
            //complete_callback && complete_callback();
            
        });
        $(dom).on("click","#selected_rource",function () {
          var ret = { "multi": true, "ext": []};
          shellcmd.openFileDialog(ret).done(function(res){ 
            if(res.length == 1){
              var src = res[0].replace(/\\/g, "/") ||"";
              var File = src.substring(src.lastIndexOf("/")+1);
              var Title = File.substring(0,File.lastIndexOf("."));
              p[0] = {
                rid:resource.rid,
                File:File,
                Id:resource.reserve1 || "",
                Left:resource.positionX,
                Top:resource.positionY,
                Title:Title,
                resourceId:resource.resourceId,
                src:src,
                bookPage:resource.bookPage
              }
              $("#selected_title").text(File);
            }
          }).fail(function(e){
            console.log(e);
          });

        });
        $(dom).on("click","button[name='cancel']",function () {
            dom.remove();
            overlay.remove();
            //cancel_callback && cancel_callback();
        });
        //展示
        $("body").append(overlay);
        $("body").append(dom);
    };
    
     /**
     * 生成随机长度的字符串
     * @param len 生成的长度 可选 未传则生成32的
     * @private
     */
    function _getRandomString(len) {
        var len = len || 32;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
        var maxPos = $chars.length;
        var pwd = '';
        for (var i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd.toLowerCase();
    }

  
    // 通过 exports 对外提供接口
    exports.Instance = new selectedresource();

});