define(function (require, exports, module) {
    require('zTree');
    require('kkpager');
    var _cloudresourceBase = require('./cloudresourcebase');
    var _resourceContentPage = require('./resourcecontent').Instance;
    var _resAccessor = require('./resaccessor').Instance;
    var _shellcmd = require('../../../common/shellcmd');
    var _ebookContext = require('../../ebookcontext').Instance;
    var commonfunc = require('../../../common/commonfunc');

    //中心用户appName
    var _default_appName = "cyyun";

    function search() {
        var _this = this;
        _this.isInit = 1;
        //TODO::改为配置
        _this.typeList = [{
                name: "课件",
                code: "0600"
            },
            {
                name: "教案",
                code: "0100"
            },
            {
                name: "导学案",
                code: "2015"
            },
            {
                name: "素材",
                code: "0300"
            },
            {
                name: "习题",
                code: "0400"
            }
        ];
        //王哒哒修改
        // _this.phaseList=["演示","小学","初中","高中"];
        _this.phaseList = ["小学", "初中", "高中"];
        _this.subjectFilter = ["思想品德", "信息技术"]
        //初始化带过来的值 
        _this.initParam = {};
        _this.bookContainer = "";
        _this.param = {
            phase: "",
            subject: "",
            edition: "",
            book: "",
            unit1: "",
            unit2: "",
            unit3: "",
            unit4: "",
            type: "",
            topic: "08",
            sortField: "",
            sortType: "DESC",
            source: "UGC,IFLYTEK,MAISUI,KXX,XIAOBENZIYUAN,ZHONGBAO,CHANGYAN",
            q: "", //{'searchType':'querystring','searchLogic':'should','value':'"+ keyword +"','highlight':'false','analyzer':'cnword_stop'}
            field: "", //搜索必要字段 "title,description,tags,author,knowledge,content"
            page: 1,
            limit: 10,
            extension: "",
            payModel: "",
            quality: "",
            isOnlyOneCount: false,
            appName: "", //用户平台标识
            platform: "" //资源平台
        };
        //当前页的数据列表
        _this.resOrigin = [];

    }
    search.prototype = new _cloudresourceBase();
    search.prototype.init = function (bookContainer) {
        var _this = this;
        _this.bookContainer = bookContainer;
        this.bindEvent();
    }
    search.prototype.bindEvent = function () {
        var _this = this;
        //打开搜索框
        $(document).on("click", "#searchBtn", function () {
            //绑定滚轮事件
            global_scoll_flag = true;
            $(".user-popover").hide();
            $("#smartbar_pop").remove();
            $("#cloudResLibTplPanel").css("display", "block");
            var exportPanel = $(document).find("#cloudResLibTplPanel");
            $("#cloudResLibTplPanel").parent().show();
            exportPanel.css({ //设置位置left：(书本宽度-搜索框宽度)/2 + 左侧宽度;top:(书本高度-搜索框高度)/2 + 头部高度
                position: 'absolute',
                left: ($("#bookwarp").outerWidth() - exportPanel.outerWidth()) / 2 + $(".J_after_class").outerWidth(),
                top: ($("#bookwarp").outerHeight() - exportPanel.outerHeight()) / 2 + $("#header").outerHeight(),
            }).draggable({ //设置可拖动
                containment: $("#bookContainer"),
                handle: ".jxpop-tab"
            });
            var book = (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.bookCode) || "";
            var pageMeta = _this.bookContainer.getCurrPageMetadata();
            var keyWords = $("#smartSearchInput1").val();
            $(".searchbox").find("[name='key']").val(keyWords)
            _this.getBookDetail(book).done(function (ret) {

                if (ret) {
                    var param = {
                        book: ret.properties && ret.properties.book[0] || "",
                        phase: ret.properties && ret.properties.phase[0] || "",
                        subject: ret.properties && ret.properties.subject[0] || "",
                        edition: ret.properties && ret.properties.edition[0] || "",
                        unit1: pageMeta.unit1,
                        unit2: pageMeta.unit2,
                        unit3: pageMeta.unit3,
                        unit4: pageMeta.unit4,
                        keyWords: keyWords
                    }
                    if (param.phase != '07') {
                        _this.initParam = param;
                    }

                    _this.open();
                }
            }).fail(function (e) {
                console.log("获取书本详情失败");
                addTipDialog("网络请求失败");
            });
        });
        //关闭搜索框
        $(document).on("click", "#cloudResourceClose", function () {
            //绑定滚轮事件
            global_scoll_flag = false;
            $("#cloudResLibTplPanel").hide();
            $("#cloudResLibTplPanel").parent().hide();
            $("#phase-list1").hide();
            $("#subject-list1").hide();
            $("#edition-list1").hide();
            $("#book-list1").hide();
            _this.isInit = 1;
        });

        //学段，学科，版本，教材选择
        $(document).on('click', '#phase-list a,#phase-list1 a', function () {
            $("#phase").find('a').removeClass("active");
            var _self = this;
            var phase = $(_self).attr("data-value");
            console.log("phase", phase)
            if (!phase) {
                $(_self).addClass("active");
            }
            _this.setPhase(phase);

        });
        $(document).on('click', '#subject-list a,#subject-list1 a', function () {
            $("#subject").find('a').removeClass("active");
            var _self = this;
            var subject = $(_self).attr("data-value");
            if (!subject) {
                $(_self).addClass("active");
            }
            _this.setSubject(subject);
        });
        $(document).on('click', '#edition-list a,#edition-list1 a', function () {
            $("#edition").find('a').removeClass("active");
            var _self = this;
            var edition = $(_self).attr("data-value");
            if (!edition) {
                $(_self).addClass("active");
            }
            _this.setEdition(edition);
        });
        $(document).on('click', '#book-list a,#book-list1 a', function () {
            $("#books").find('a').removeClass("active");
            var _self = this;
            var book = $(_self).attr("data-value");
            if (!book) {
                $(_self).addClass("active");
            }
            _this.setBook(book);
        });
        $(document).on('click', '#type a', function () {
            $("#type").find('a').removeClass("active");
            var _self = this;
            var type = $(_self).attr("data-value");
            _this.setType(type);
        });

        //学段，学科，版本，教材展开收起控制
        $("#phase .fr").click(function () {
            $("#phase-list1").slideToggle(200, function () {
                if ($(this).is(":hidden")) {
                    $("#phase .fr").html('<a href="javascript:;"><i class="icon iconfont">&#xe638;</i>更多</a>');
                } else {
                    $("#phase .fr").html('<a href="javascript:;"><i class="icon iconfont">&#xe627;</i>收起</a>');
                }
            })
        });
        $("#subject .fr").click(function () {
            $("#subject-list1").slideToggle(200, function () {
                if ($(this).is(":hidden")) {
                    $("#subject .fr").html('<a href="javascript:;"><i class="icon iconfont">&#xe638;</i>更多</a>');
                } else {
                    $("#subject .fr").html('<a href="javascript:;"><i class="icon iconfont">&#xe627;</i>收起</a>');
                }
            });
        });
        $("#edition .fr").click(function () {
            $("#edition-list1").slideToggle(200, function () {
                if ($(this).is(":hidden")) {
                    $("#edition .fr").html('<a href="javascript:;"><i class="icon iconfont">&#xe638;</i>更多</a>');
                } else {
                    $("#edition .fr").html('<a href="javascript:;"><i class="icon iconfont">&#xe627;</i>收起</a>');
                }
            })
        });
        $("#books .fr").click(function () {
            $("#book-list1").slideToggle(200, function () {
                if ($(this).is(":hidden")) {
                    $("#books .fr").html('<a href="javascript:;"><i class="icon iconfont">&#xe638;</i>更多</a>');
                } else {
                    $("#books .fr").html('<a href="javascript:;"><i class="icon iconfont">&#xe627;</i>收起</a>');
                }
            })
        });
        //排序方式点击
        $("#sortField").find("a").click(function () {
            $("#sortField").find("a").removeClass("blue");
            var _self = this;
            var sortField = $(_self).attr("data-value");
            _this.param.isOnlyOneCount = true; //只刷新当前类型的统计量
            _this.resetSort(sortField, true);

            // search.setSortField(sortField);
        });
        $(".searchbox .btn-blue").click(function () {
            var keyWords = $(".searchbox").find("[name='key']").val();
            _this.setKeyWords(keyWords);
            _this.setPage(1);
            _this.getResList(_this.param).done(function (ret) {
                _this.setViewList(ret);
            }).fail(function (e) {
                console.log("获取资源列表失败");
            });
        });
        //手写点击
        $("#searchInkWrit").click(function () {
            var searchInput = $(".searchbox").find("[name='key']");
            _shellcmd.callSingleton('iFlyInk.exe', "write", searchInput);
            setTimeout(function () {
                $(".searchbox").find("[name='key']").focus();
            }, 500);
        });
        //键盘输入
        $("#searchKeyboad").click(function () {
            var searchInput = $(".searchbox").find("[name='key']");
            _shellcmd.callIme("keyboard", searchInput);
            $(".searchbox").find("[name='key']").focus();
        });
        //回车查询
        $(document).find("[name='key']").on("keypress", function (e) {
            e = e ? e : window.event;
            var keyCode = e.which ? e.which : e.keyCode;
            if (keyCode == 13) {
                var keyWords = $(".searchbox").find("[name='key']").val();
                _this.setKeyWords(keyWords);
                _this.setPage(1);
                _this.getResList(_this.param).done(function (ret) {
                    _this.setViewList(ret);
                }).fail(function (e) {
                    console.log("获取资源列表失败");
                });
            }
        });
        //资源频道点击
        $(document).on("click", "#resChannel input", function () {
            var channel = $("input[name='channel-set']:checked").attr("id");
            var extension = "";
            switch (channel) {
                case "radio-all":
                    extension = "";
                    break;
                case "radio-file":
                    extension = "doc,docx,ppt,pps,ppsx,pptx,xls,xlsx,txt,pdf,rtf,chm,html,xml";
                    break;
                case "radio-img":
                    extension = "jpg,jpeg,bmp,png,gif,psd,gsp,gss";
                    break;
                case "radio-audio":
                    extension = "mp3,wma,wav, ogg,ape,mid,midi,tch";
                    break;
                case "radio-video":
                    extension = "rmvb,mp4,avi,wmv,asf,3gp,flv,mpg,mpeg,mpeg4,rm,mpeg4, mov,vob,mkv,m2ts";
                    break;
                case "radio-animation":
                    extension = "swf,flash,pic,gif,mov,flv,flc,fla,mpeg";
                    break;
                default:
                    extension = "";
                    break;
            }
            _this.setExtension(extension);
            _this.resetSort();

        });
        //免费或全部
        $(document).on("click", "input[name='payModel']", function () {
            if (_this.param.payModel === 0) {
                $("input[name='payModel']").prop("checked", false);
                $("input[name='payModel']").parent().removeClass("blue");
                _this.setPayModel("");
            } else if (_this.param.payModel == "") {
                $("input[name='payModel']").prop("checked", true);
                $("input[name='payModel']").parent().addClass("blue");
                _this.setPayModel(0);
            }
            _this.param.isOnlyOneCount = true; //只刷新当前类型的统计量
            _this.setPage(1);
            _this.getResList(_this.param).done(function (ret) {
                _this.setViewList(ret);
            }).fail(function (e) {
                console.log("获取资源列表失败");
            });
        });
        //精品或非精品
        $(document).on("click", "input[name='quality']", function () {
            if (_this.param.quality === 21) {
                $("input[name='quality']").prop("checked", false);
                $("input[name='quality']").parent().removeClass("blue");
                _this.setQuality("");
            } else if (_this.param.quality == "") {
                $("input[name='quality']").prop("checked", true);
                $("input[name='quality']").parent().addClass("blue");
                _this.setQuality(21);
            }
            _this.param.isOnlyOneCount = true; //只刷新当前类型的统计量
            _this.setPage(1);
            _this.getResList(_this.param).done(function (ret) {
                _this.setViewList(ret);
            }).fail(function (e) {
                console.log("获取资源列表失败");
            });
        });
        $(document).on("click", "#gotoshare", function () {
            var url;
            var appName = _ebookContext.getUser().getUserAppName();
            _this.isAppNameExist(appName).done(function (ret) {
                //查询平台资源
                if (ret && appName != _default_appName) {
                    // 地方云 单点登录-资源中心
                    $.ajax({
                        url: Base_Cfg.ITA_BASE + "/platformconfig",
                        success: function (ret) {
                            var filterResults = ret.filter(function (row) {
                                return row.appname == appName;
                            });
                            if (filterResults.length == 0) {
                                url = AppRemoteSvcCfg.GOTOSHARE;
                                commonfunc.openWebPage(url);
                            } else {
                                var config = filterResults[0];
                                url = config.rescenterAD;
                                if (!url) {
                                    url = AppRemoteSvcCfg.GOTOSHARE;
                                }
                                commonfunc.openWebPage(url);
                            }
                        },
                        error: function () {
                            url = AppRemoteSvcCfg.GOTOSHARE;
                            commonfunc.openWebPage(url);
                        }
                    });
                } else {
                    url = AppRemoteSvcCfg.GOTOSHARE;
                    commonfunc.openWebPage(url);
                }
            }).fail(function (e) {
                url = AppRemoteSvcCfg.GOTOSHARE;
                commonfunc.openWebPage(url);
            });
        });

        //付费资源，扣费继续下载
        $(document).on("click", "#search_payforResources .btn-blue", function () {
            var id = $("#search_payforResources").attr("resid");
            var purpose = $("#search_payforResources").attr("purpose");
            var file = _this.resOrigin.filter(function (el) {
                return el.id == id;
            });

            var userId = _ebookContext.getUser().getUid();

            if (file[0]) {
                console.log(file[0]);
                var resultData = _resAccessor.resFormatOld(file[0]);
                resultData.type = _this.param.type || "";
                resultData.view_source = file[0].view_source || "";
                if (resultData.title.indexOf("." + resultData.extension) != -1) {
                    resultData.title = resultData.title.substring(0, resultData.title.indexOf("." + resultData.extension));
                }
                resultData.resFrom = "yun_search";
                if (resultData.view_source) {
                    resultData.creator = resultData.view_source;
                }
                resultData.purpose = purpose;

                _shellcmd.checkOnline().done(function (online) {
                    if (online) {
                        var params = {
                            userId: userId
                        };
                        //获得用户现在拥有的积分
                        edcService.Instance().ersp_resource_user_credit_get(params).done(function (ret) {
                            //用户现在拥有的积分
                            var total_credit = ret.data.data.toFixed(1);
                            var need_credit = parseInt(resultData.exchangeCredit).toFixed(1); //需要积分为正，下载资源扣分设置为负值
                            var title = resultData.title;
                            var resourceid = resultData.id;
                            if (total_credit - need_credit >= 0) {
                                var param = {
                                    userId: userId,
                                    action: "download",
                                    score: -need_credit,
                                    resId: resourceid,
                                    data: title
                                };
                                edcService.Instance().ersp_resource_user_credit_update(param).done(function (ret) {
                                    if (!ret || ret.code != 0) {
                                        tipsDialog({
                                            "id": "uploading" + new Date().getTime(),
                                            "content": "资源添加失败"
                                        });
                                    } else {
                                        $("#search_payforResources").attr("resid", "");
                                        $("#search_payforResources").attr("purpose", "");
                                        $("#search_payforResources").hide();
                                        if (purpose == "saveToPrepare") {
                                            $("li[data-id='" + id + "']").find(".saveToPrepare").parent().hide();
                                            $("li[data-id='" + id + "']").find(".progress_prepare").show();
                                        } else {
                                            $("li[data-id='" + id + "']").find(".saveToIflybook").parent().hide();
                                            $("li[data-id='" + id + "']").find(".progress_ib").show();
                                        }
                                        _this.downLoadFile(resultData);
                                    }
                                }).fail(function (err) {
                                    console.log(err);
                                    tipsDialog({
                                        "id": "uploading" + new Date().getTime(),
                                        "content": "资源添加失败"
                                    });
                                })
                            } else {
                                $("#search_payforResources").hide();
                            }
                        });
                    }
                });
            }
        });
        //付费资源：扣费取消下载
        $(document).on("click", "#search_payforResources .btn-gray", function () { //取消按钮
            $("#search_payforResources").attr("resid", "");
            $("#search_payforResources").attr("purpose", "");
            $("#search_payforResources").hide();
        });
        $(document).on("click", "#search_payforResources a", function () { //右上角的×
            $("#search_payforResources").attr("resid", "");
            $("#search_payforResources").attr("purpose", "");
            $("#search_payforResources").hide();
        });
        //付费资源：已扣费，继续下载
        $(document).on("click", "#search_alreadyPayforResources .btn-blue", function () {
            var id = $("#search_alreadyPayforResources").attr("resid");
            var purpose = $("#search_alreadyPayforResources").attr("purpose");
            var file = _this.resOrigin.filter(function (el) {
                return el.id == id;
            });

            if (file[0]) {
                console.log(file[0]);
                var resultData = _resAccessor.resFormatOld(file[0]);
                resultData.type = _this.param.type || "";
                resultData.view_source = file[0].view_source || "";
                if (resultData.title.indexOf("." + resultData.extension) != -1) {
                    resultData.title = resultData.title.substring(0, resultData.title.indexOf("." + resultData.extension));
                }
                resultData.resFrom = "yun_search";
                if (resultData.view_source) {
                    resultData.creator = resultData.view_source;
                }
                resultData.purpose = purpose;
                //console.log(_this.initParam);
                //console.log(downloadfile);

                _shellcmd.checkOnline().done(function (online) {
                    if (online) {
                        if (purpose == "saveToPrepare") {
                            $("li[data-id='" + id + "']").find(".saveToPrepare").parent().hide();
                            $("li[data-id='" + id + "']").find(".progress_prepare").show();
                        } else {
                            $("li[data-id='" + id + "']").find(".saveToIflybook").parent().hide();
                            $("li[data-id='" + id + "']").find(".progress_ib").show();
                        }
                        // $("#smartbar_pop").remove();
                        $("#search_alreadyPayforResources").attr("resid", "");
                        $("#search_alreadyPayforResources").attr("purpose", "");
                        $("#search_alreadyPayforResources").hide();
                        _this.downLoadFile(resultData);
                    }
                });
            }
        });
        //付费资源：已扣费，不继续下载
        $(document).on("click", "#search_alreadyPayforResources .btn-gray", function () { //取消按钮
            $("#search_alreadyPayforResources").attr("resid", "");
            $("#search_alreadyPayforResources").attr("purpose", "");
            $("#search_alreadyPayforResources").hide();
        });
        $(document).on("click", "#search_alreadyPayforResources a", function () { //右上角的×
            $("#search_alreadyPayforResources").attr("resid", "");
            $("#search_alreadyPayforResources").attr("purpose", "");
            $("#search_alreadyPayforResources").hide();
        });
    };
    search.prototype.open = function () {
        var _this = this;
        _this.getPhaseList("phase").done(function (ret) {
            $("#phase-list").empty();
            for (var i = 0; i < ret.length; i++) {
                $("#phase-list").append('<a href="javascript:;" data-value="' + ret[i].code + '">' + ret[i].name + '</a>');
            }
            var phase = "";
            console.log('isInit', _this.isInit)
            console.log('initParam', _this.initParam.phase)

            if (_this.isInit && _this.initParam.phase) {
                console.log(23)
                phase = _this.initParam.phase;
            } else {
                phase = ret[0].code;
            }
            _this.setPhase(phase);
            $("#phase-list a").triggerHandler("click");
        }).fail(function (e) {
            console.log("获取学科失败！");
            addTipDialog("网络请求失败");
        });
    }

    //设置学段
    search.prototype.setPhase = function (param) {
        var _this = this;
        _this.param.phase = param;
        $("#phase").find('[data-value="' + _this.param.phase + '"]').addClass("active");
        _this.getSubjectList().done(function (ret) {
            $("#subject-list").empty();
            $("#subject-list1").empty();
            $("#subject").find(".fr").empty();
            //加上这一块的判断是为了防止接口返回的数据缺失做的异常处理
            if (!$.isArray(ret) || !ret) {
                _this.isInit = 0;
                // _this.open();
                console.log("获取学科失败！");
                addTipDialog("获取学科为空！");
                return;
            }
            if (ret.length > 10) {
                $("#subject").find(".fr").append('<a href="javascript:;"><i class="icon iconfont">&#xe638;</i>更多</a>');
                $("#subject-list1").hide();
            }

            for (var i = 0; i < ret.length; i++) {
                if (i > 9) {
                    $("#subject-list1").append('<a href="javascript:;" data-value="' + ret[i].code + '">' + ret[i].name + '</a>');
                } else {
                    //为了兼容全学科书籍做的处理
                    if (ret[i].name != "其他") {
                        $("#subject-list").append('<a href="javascript:;" data-value="' + ret[i].code + '">' + ret[i].name + '</a>');
                    }
                }
            }
            var subject = "";
            if (_this.isInit && _this.initParam.subject) {
                subject = _this.initParam.subject;
            } else {
                subject = ret[0].code;
            }
            _this.setSubject(subject);
        }).fail(function (e) {
            console.log("获取学科失败！");
            addTipDialog("网络请求失败");
        });
    }
    search.prototype.setSubject = function (subject) {
        var _this = this;
        _this.param.subject = subject;
        $("#subject").find('[data-value="' + _this.param.subject + '"]').addClass("active");
        //如果选中的学科隐藏则展开
        // if($("#subject-list1").find('[data-value="'+search.subject+'"]').length>0){
        //  $("#subject .fr").trigger("click");
        // }
        _this.getEditionList().done(function (ret) {
            $("#edition-list").empty();
            $("#edition-list1").empty();
            $("#edition").find(".fr").empty();
            //加上这一块的判断是为了防止接口返回的数据缺失做的异常处理
            if (!$.isArray(ret) || !ret) {
                _this.isInit = 0;
                // _this.open();
                console.log("获取版本失败！");
                addTipDialog("获取版本为空！");
                return;
            }
            if (ret.length > 7) {
                $("#edition").find(".fr").append('<a href="javascript:;"><i class="icon iconfont">&#xe638;</i>更多</a>');
                $("#edition-list1").hide();
            }
            for (var i = 0; i < ret.length; i++) {
                if (i > 6) {
                    $("#edition-list1").append('<a href="javascript:;" data-value="' + ret[i].code + '">' + ret[i].name + '</a>');
                } else {
                    $("#edition-list").append('<a href="javascript:;" data-value="' + ret[i].code + '">' + ret[i].name + '</a>');
                }
            }
            var edition = "";
            //初始化位置
            if (_this.isInit && _this.initParam.edition) {
                edition = _this.initParam.edition;
            } else {
                edition = ret[0].code;
            }
            _this.setEdition(edition);
        }).fail(function (e) {
            console.log("获取版本失败！");
            addTipDialog("网络请求失败");
        });

    }
    search.prototype.setEdition = function (edition) {
        var _this = this;
        _this.param.edition = edition;
        $("#edition").find('[data-value="' + _this.param.edition + '"]').addClass("active");
        //如果选中的书本隐藏则展开
        // if($("#edition-list1").find('[data-value="'+search.edition+'"]').length>0){
        //  $("#edition .fr").trigger("click");
        // }
        _this.getBookList().done(function (ret) {
            $("#book-list").empty();
            $("#book-list1").empty();
            $("#books").find(".fr").empty();
            //加上这一块的判断是为了防止接口返回的数据缺失做的异常处理
            if (!ret || !$.isArray(ret)) {
                _this.isInit = 0;
                // _this.open();
                addTipDialog("获取书本为空！");
                return;
            }
            if (ret.length > 5) {
                $("#books").find(".fr").append('<a href="javascript:;"><i class="icon iconfont">&#xe638;</i>更多</a>');
                $("#book-list1").hide();
            }
            for (var i = 0; i < ret.length; i++) {
                if (i > 4) {
                    $("#book-list1").append('<a  href="javascript:;" data-value="' + ret[i].code + '">' + ret[i].name + '</a>');
                } else {
                    $("#book-list").append('<a  href="javascript:;" data-value="' + ret[i].code + '">' + ret[i].name + '</a>');
                }
            }
            var book = "";
            //初始位置
            if (_this.isInit && _this.initParam.book) {
                book = _this.initParam.book;
            } else {
                book = ret[0].code;
            }
            _this.setBook(book);

        }).fail(function (e) {
            console.log("获取书本失败！");
            addTipDialog("网络请求失败");
        });
    }
    search.prototype.setBook = function (book) {
        var _this = this;
        _this.param.book = book;
        $("#books").find('[data-value="' + _this.param.book + '"]').addClass("active");
        //面包屑
        var phaseName = $("#phase").find(".active").text();
        var subjectName = $("#subject").find(".active").text();
        var editionName = $("#edition").find(".active").text();
        var bookName = $("#books").find(".active").text();
        // <div class="jxpop-crumbs">您已选择：<a>小学</a> &gt; 语文 &gt; 人教版 &gt; 语文人教一年级上册</div>
        $(".jxpop-crumbs").html('您已选择：' + phaseName + ' &gt; ' + subjectName + ' &gt; ' + editionName + ' &gt;' + bookName);
        //加载目录树
        var bookName = $("[data-value ='" + _this.param.book + "']").text();

        if (_this.isInit) {
            _this.setUnit(_this.initParam);
        } else {
            _this.setUnit({});
        }
        _this.getMenu(_this.param).done(function (ret) {
            if (ret) {
                var str = JSON.stringify(ret);
                _this.formatMenu(str, _this.param.book, "", bookName);
            }
        }).fail(function (e) {
            console.log("获取书本目录失败");
            addTipDialog("网络请求失败");
        });
        //重置付费与精品的状态
        _this.setType();
    }
    search.prototype.setUnit = function (param) {
        var _this = this;
        _this.param.unit1 = param.unit1;
        _this.param.unit2 = param.unit2;
        _this.param.unit3 = param.unit3;
        _this.param.unit4 = param.unit4;
    }
    search.prototype.setType = function (type) {
        var _this = this;
        if (type) {
            _this.param.type = type;
        } else {
            var typeList = _this.getTypeList(_this.param.phase);
            _this.param.type = typeList[0].code;
            $("#type").empty();
            for (var i = 0; i < typeList.length; i++) {
                $("#type").append('<a href="javascript:;" data-value="' + typeList[i].code + '">' + typeList[i].name + '<span></span></a>');
            }
        }
        $("#type").find('[data-value="' + _this.param.type + '"]').addClass("active");
        //判断是否为素材资源,重置radio的选中状态
        _this.setExtension("");
        if (_this.param.type == "0300") {
            $("#resChannel").css("display", "block");
            $("input[id='radio-all']").prop("checked", true);
        } else {
            $("#resChannel").css("display", "none");
        }
        if (_this.isInit) {
            var keyWords = _this.initParam.keyWords;
            _this.isInit = 0;
        } else {
            //重置搜索关键词
            $(".searchbox").find("[name='key']").val("");
        }
        _this.setKeyWords(keyWords);
        _this.setPage(1);
        //重置排序方式
        _this.resetSort();
    }
    search.prototype.setKeyWords = function (keyWords) {
        var _this = this;
        _this.param.q = keyWords ? "{'searchType':'querystring','searchLogic':'should','value':'" + keyWords + "','highlight':'false','analyzer':'cnword_stop'}" : "";
        _this.param.field = keyWords ? "title,description,tags,author,knowledge,content" : "";
    }
    search.prototype.setSortType = function (sortType) {
        var _this = this;
        _this.param.sortType = sortType;
    }
    search.prototype.setSortField = function (sortField) {
        var _this = this;
        _this.param.sortField = sortField;
        _this.setPage(1);
        _this.getResList(_this.param).done(function (ret) {
            _this.setViewList(ret);
        }).fail(function (e) {
            console.log("获取资源列表失败");
        });
    }
    search.prototype.setPage = function (page) {
        var _this = this;
        _this.param.page = page;
    }
    search.prototype.setExtension = function (extension) {
        var _this = this;
        _this.param.extension = extension;
    }
    search.prototype.setPayModel = function (payModel) {
        var _this = this;
        _this.param.payModel = payModel;
    }
    search.prototype.setQuality = function (quality) {
        var _this = this;
        _this.param.quality = quality;
    }
    //资源列表展示数据处理
    search.prototype.setViewList = function (result) {
        var _this = this;
        var viewList = [];
        fun(0, result.data[0], result.data.length);

        function fun(index, res, length) {
            if (index >= length) {
                _this.resListRender(viewList, result.total);
                return viewList;
            }
            if (res.source == "UGC") {
                if (res.creator && typeof res.creator === "string") {
                    var p = {
                        key: "loginName",
                        value: res.creator
                    }
                    edcService.Instance().core_user_get(p).done(function (ret) {
                        if (ret && ret.code == 0 && ret.data) {
                            res.view_source = setSource(res.source, ret.data.userName);
                        } else {
                            res.view_source = setSource(res.source, "");
                        }
                        viewList.push(res);
                        index++;
                        fun(index, result.data[index], result.data.length);
                    }).fail(function (e) {
                        res.view_source = setSource(res.source, res.creator);
                        viewList.push(res);
                        index++;
                        fun(index, result.data[index], result.data.length);
                    });
                } else {
                    res.view_source = setSource(res.source, "");
                    viewList.push(res);
                    index++;
                    fun(index, result.data[index], result.data.length);
                }
            } else if (res.source == "XIAOBENZIYUAN") {
                res.view_source = setSource(res.source, res.creator);
                viewList.push(res);
                index++;
                fun(index, result.data[index], result.data.length);
            } else {
                res.view_source = setSource(res.source);
                viewList.push(res);
                index++;
                fun(index, result.data[index], result.data.length);
            }
        }
    }
    //资源列表渲染
    search.prototype.resListRender = function (result, total) {
        var _this = this;
        var viewList = result;
        //备份一份当前页面数据
        _this.resOrigin = viewList;

        $(".jxres-list").empty();
        if (viewList.length == 0) {
            $("#resList").hide();
            $("#null_tip").show();
            return;
        } else {
            $("#resList").show();
            $("#null_tip").hide();
        }
        var lis = [];
        for (var i = 0; i < viewList.length; i++) {
            var li = _this.produceResLi(viewList[i]);
            lis.push(li);
        }

        $(".jxres-list").append(lis);
        //分页
        if (total > _this.param.limit) {
            //生成分页
            //有些参数是可选的，比如lang，若不传有默认值
            var config = {
                pno: _this.param.page,
                //总页码
                total: Math.ceil(total / _this.param.limit),
                //总数据条数
                totalRecords: total,
                mode: 'click', //默认值是link，可选link或者click
                click: function (n) {
                    this.selectPage(n);
                    //每次翻页都到搜索框头部
                    window.location.href = "#tohead";
                    _this.setPage(n);
                    _this.getResList(_this.param).done(function (ret) {
                        _this.setViewList(ret);
                    }).fail(function (e) {
                        console.log("获取资源列表失败");
                    });
                    return false;
                }
            }
            kkpager.init(config);
            kkpager.generPageHtml(config);
        } else {
            $("#kkpager").empty();
        }
    }

    search.prototype.produceResLi = function (res) {
        var _this = this;
        //预览图
        var view_thumbnail = setThumbnail(res.thumbnail, res.extension);
        //付费展示
        var view_pay = "";
        if (res.payModel == 1 && res.exchangeCredit > 0) {
            view_pay = res.exchangeCredit + "积分";
        } else {
            view_pay = "免费";
        }
        //上传时间
        var view_uploadTime = formatTime(res.uploadTime);
        //小图标
        var view_icon = setIcon(res.extension);

        res.description = _shellcmd.analyzeHtml(res.description);

        var li = $('<li data-id="' + res.id + '">' +
            '<div class="resimg"><img src="' + view_thumbnail + '" onerror="javascript:this.src=\'assert/static/common/images/thb_72X72/thb_default.png\';"></div>' +
            '<div class="resinfo">' +
            '    <p class="fsize14"><i><img src="' + view_icon + '"></i><span class="_title" style="margin-left:3px;display: inline;">' + res.title + '</span></p>' +
            '    <p>' + res.description + '</p>' +
            '    <p><font  style="padding:0;font-size:12px;"><span class="green">' + view_pay + '</span><span>/ ' + res.view_source + ' / ' + view_uploadTime + ' 上传 / ' + res.viewCount + '次预览 / ' + res.downloadCount + '次下载 / ' + res.commentCount + '条评价 /</span></font>' +
            '       <span class="star" style="padding:0; margin:0;"></span>' +
            '    </p>' +
            '</div>' +
            '<div class="resbtn">' +
            '    <p><button type="button" data-id="' + res.id + '"  class="btn-gray search_preview">预览</button></p>' +
            '    <div class="resbtn-jd clearfix progress_prepare" style="display: none;">' +
            '        <div class="progressbar fl"><p style="width:0%" name="toPrepare"></p></div>' +
            '        <div class="fr"><button type="button" class="btn-emptyred" style="display: none"><i class="icon iconfont">&#xe635;</i></button></div>' +
            '    </div>' +
            '    <p><button type="button" data-id="' + res.id + '"  class="btn-gray saveToIflybook">加入课本</button></p>' +
            '    <div class="resbtn-jd clearfix progress_ib" style="display: none;">' +
            '        <div class="progressbar fl"><p style="width:0%" name="toIb"></p></div>' +
            '        <div class="fr"><button type="button" class="btn-emptyred" style="display: none"><i class="icon iconfont">&#xe635;</i></button></div>' +
            '    </div>' +
            '</div>' +
            '</li>');
        //星评
        var scoreCount = (res.score / 100 * 5).toFixed(1);
        setStar(li, scoreCount);
        //资源条点击预览(详情框)
        li.on("click", ".search_preview", function () {
            var id = li.attr("data-id");
            var file = _this.resOrigin.filter(function (el) {
                return el.id == id;
            });
            if (file[0]) {
                file[0].resFrom = "yun_search";
                // if(file[0].fileurl.lastIndexOf("http")!=0){
                //     file[0].fileurl=file[0].fileurl.substring(file[0].fileurl.lastIndexOf("http"));
                // }
                var p = {
                    id: file[0].id,
                    autov: true
                };
                //get接口添加平台参数 by njfu
                if (json.get_platfrom) {
                    p.platform = file[0].platform || "";
                }
                edcService.Instance().ersp_resource_get(p).done(function (ret) {
                    if (ret && ret.code == 0 && ret.data.data) {
                        // var viewFile = ret.data.data;
                        var viewFile = _resAccessor.resFormatOld(file[0]);
                        if (ret.data.data.thumburl != null && ret.data.data.thumburl != "") {
                            viewFile.thumburl = ret.data.data.thumburl;
                        }
                        viewFile.statistics = ret.data.data.statistics;
                        viewFile.screenshots = ret.data.data.screenshot;
                        viewFile.origin = _this.originResFromOld(_this.resOrigin);
                        _resourceContentPage.showResContentPanel(viewFile);
                    } else {
                        console.log("获取资源详情失败");
                        addTipDialog("网络请求失败");
                    }
                }).fail(function (e) {
                    console.log(e);
                    addTipDialog("网络请求失败");
                });
            }
        });
        //加入备课本 -需求变更，该事件被废弃 by njfu
        li.on("click", ".saveToPrepare", function (event) {
            var _self = this;
            // var id = $(_self).attr("data-id");
            var id = res.id;
            var file = _this.resOrigin.filter(function (el) {
                return el.id == id;
            });

            var userId = _ebookContext.getUser().getUid();

            if (file[0]) {
                console.log(file[0]);
                var resultData = _resAccessor.resFormatOld(file[0]);
                resultData.type = _this.param.type || "";
                resultData.view_source = file[0].view_source || "";
                if (resultData.title.indexOf("." + resultData.extension) != -1) {
                    resultData.title = resultData.title.substring(0, resultData.title.indexOf("." + resultData.extension));
                }
                resultData.resFrom = "yun_search";
                resultData.purpose = "saveToPrepare"; //添加参数，标志 存至备课本

                //用户昵称可以直接拿到
                if (resultData.view_source) {
                    resultData.creator = resultData.view_source;
                }
                //console.log(_this.initParam);
                //console.log(downloadfile);

                _shellcmd.checkOnline().done(function (online) {
                    if (online) {
                        //判断是否是付费资源
                        if (resultData.payModel == 1 && resultData.exchangeCredit != 0) { //需要付费
                            var paydownloaded = false;
                            var params = {
                                action: "download",
                                userId: userId,
                                resId: resultData.id
                            };
                            //先查询该用户是否已经对此资源付费
                            edcService.Instance().ersp_resource_user_credit_action(params).done(function (ret) {
                                paydownloaded = ret.data.data;
                                //todo 开发时使用
                                // paydownloaded=false;
                                if (paydownloaded == true) { //用户已付费
                                    $("#search_alreadyPayforResources").attr("resid", id);
                                    $("#search_alreadyPayforResources").attr("purpose", "saveToPrepare");
                                    $("#search_alreadyPayforResources").show();
                                } else { //用户未付费
                                    var params = {
                                        userId: userId
                                    };
                                    //获得用户现在拥有的积分
                                    edcService.Instance().ersp_resource_user_credit_get(params).done(function (ret) {
                                        //用户现在拥有的积分
                                        var total_credit = ret.data.data.toFixed(1);
                                        var need_credit = resultData.exchangeCredit;
                                        if (total_credit && need_credit) {
                                            $("#search_payforResources").attr("resid", id);
                                            $("#search_payforResources").attr("purpose", "saveToPrepare");
                                            $("#search_payforResources").show();
                                            if (need_credit - total_credit > 0) { //所需积分比用户总积分多
                                                $("#search_payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前积分不足";
                                                $("#search_payforResources .btn-gray").hide();
                                            } else {
                                                $("#search_payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前有" + total_credit + "积分，确认下载么？";
                                            }
                                        }
                                    }).fail(function (err) {
                                        console.log(err);
                                    })
                                }
                            }).fail(function (err) {
                                console.log(err);

                            })
                        } else {
                            //隐藏按钮
                            $(_self).parent().hide();
                            //显示进度条
                            $(_self).parent().siblings(".progress_prepare").show();

                            _this.downLoadFile(resultData);
                        }
                    } else {
                        //网络异常
                        var exportPanel = $(document).find("#previewFail");
                        exportPanel.css({ //设置位置
                            position: 'absolute',
                            left: ($(window).width() + 204 - exportPanel.outerWidth()) / 2,
                            top: ($(window).height() - exportPanel.outerHeight()) / 2 + $(document).scrollTop(),
                        }).draggable({
                            containment: $("#bookContainer"),
                            handle: ".jxpop-tab"
                        });
                        $(exportPanel).find(".jxpop-main").html("").html("网络异常");
                        $(exportPanel).show();
                        return;
                    }
                });
            }
            event.stopPropagation();
        });
        //加入课本
        li.on("click", ".saveToIflybook", function (event) {
            var _self = this;
            var id = $(_self).attr("data-id");
            var file = _this.resOrigin.filter(function (el) {
                return el.id == id;
            });

            var userId = _ebookContext.getUser().getUid();

            if (file[0]) {
                console.log(file[0]);
                var resultData = _resAccessor.resFormatOld(file[0]);
                resultData.type = _this.param.type || "";
                resultData.view_source = file[0].view_source || "";

                if (resultData.title.indexOf("." + resultData.extension) != -1) {
                    resultData.title = resultData.title.substring(0, resultData.title.indexOf("." + resultData.extension));
                }
                resultData.resFrom = "yun_search";
                //用户昵称可以直接拿到
                if (resultData.view_source) {
                    resultData.creator = resultData.view_source;
                }
                //console.log(_this.initParam);
                //console.log(downloadfile);

                _shellcmd.checkOnline().done(function (online) {
                    if (online) {
                        //判断是否是付费资源
                        if (resultData.payModel == 1 && resultData.exchangeCredit != 0) { //需要付费
                            var paydownloaded = false;
                            var params = {
                                action: "download",
                                userId: userId,
                                resId: resultData.id
                            };
                            //先查询该用户是否已经对此资源付费
                            edcService.Instance().ersp_resource_user_credit_action(params).done(function (ret) {
                                paydownloaded = ret.data.data;
                                //todo 开发时使用
                                // paydownloaded=false;
                                if (paydownloaded == true) { //用户已付费
                                    $("#search_alreadyPayforResources").attr("resid", id);
                                    $("#search_alreadyPayforResources").show();
                                } else { //用户未付费
                                    var params = {
                                        userId: userId
                                    };
                                    //获得用户现在拥有的积分
                                    edcService.Instance().ersp_resource_user_credit_get(params).done(function (ret) {
                                        //用户现在拥有的积分
                                        var total_credit = ret.data.data.toFixed(1);
                                        var need_credit = resultData.exchangeCredit;
                                        if (total_credit && need_credit) {
                                            $("#search_payforResources").attr("resid", id);
                                            $("#search_payforResources").show();
                                            if (need_credit - total_credit > 0) { //所需积分比用户总积分多
                                                $("#search_payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前积分不足";
                                                $("#search_payforResources .btn-gray").hide();
                                            } else {
                                                $("#search_payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前有" + total_credit + "积分，确认下载么？";
                                            }
                                        }
                                    }).fail(function (err) {
                                        console.log(err);
                                    })
                                }
                            }).fail(function (err) {
                                console.log(err);

                            })
                        } else {
                            //隐藏按钮
                            $(_self).parent().hide();
                            //显示进度条
                            $(_self).parent().siblings(".progress_ib").show();

                            _this.downLoadFile(resultData);
                        }
                    } else {
                        //网络异常
                        var exportPanel = $(document).find("#previewFail");
                        exportPanel.css({ //设置位置
                            position: 'absolute',
                            left: ($(window).width() + 204 - exportPanel.outerWidth()) / 2,
                            top: ($(window).height() - exportPanel.outerHeight()) / 2 + $(document).scrollTop()
                        }).draggable({
                            containment: $("#bookContainer"),
                            handle: ".jxpop-tab"
                        });
                        $(exportPanel).find(".jxpop-main").html("").html("网络异常");
                        $(exportPanel).show();
                        return;
                    }
                });
            }
            event.stopPropagation();
        });

        return li;
    };

    /**
     *相关推荐资源批量转化
     * */
    search.prototype.originResFromOld = function (data) {
        var resList = [];
        for (var i = 0; i < data.length; i++) {
            var item = _resAccessor.resFormatOld(data[i]);
            resList.push(item);
        }
        return resList;
    };
    //时间格式YYYY-MM-DD
    function add0(m) {
        return m < 10 ? '0' + m : m
    }

    function formatTime(shijianchuo) {
        //shijianchuo是整数，否则要parseInt转换
        var time = new Date(shijianchuo);
        var y = time.getFullYear();
        var m = time.getMonth() + 1;
        var d = time.getDate();
        var h = time.getHours();
        var mm = time.getMinutes();
        var s = time.getSeconds();
        return y + '-' + add0(m) + '-' + add0(d);
    }
    //设置缩略图(按类型给默认的缩率图，有点不太合理)
    function setThumbnail(thumbnail, extension) {
        var str = "";
        if (thumbnail) {
            return thumbnail;
        } else {
            switch (extension) {
                case "doc":
                case "docx":
                    str = "doc";
                    break;
                case "ppt":
                case "pptx":
                case "pps":
                case "ppsx":
                    str = "ppt";
                    break;
                case "jpg":
                case "jpeg":
                case "bmp":
                case "png":
                case "gif":
                case "psd":
                case "gsp":
                case "gss":
                    str = "img";
                    break;
                case "mp3":
                case "wma":
                case "wav":
                case "ogg":
                case "ape":
                case "mid":
                case "midi":
                case "tch":
                    str = "audio";
                    break;
                case "rmvb":
                case "mp4":
                case "avi":
                case "wmv":
                case "asf":
                case "3gp":
                case "flv":
                case "mpg":
                case "mpeg":
                case "mpeg4":
                case "rm":
                case "mov":
                case "vob":
                case "mkv":
                case "m2ts":

                case "swf":
                case "flash":
                case "pic":
                case "gif":
                case "mov":
                case "flv":
                case "flc":
                case "fla":
                case "mpeg":
                    str = "video";
                    break;
                default:
                    str = "default";
                    break;
            };
            return "assert/static/common/images/thb_72X72/thb_" + str + ".png";
        }
    }
    //设置icon TODO::UI提供默认icon
    function setIcon(extension) {
        var icon = "";
        switch (extension) {
            case "doc":
            case "docx":
                icon = "word";
                break;
            case "rtf":
                icon = "rtf";
                break;
            case "chm":
                icon = "chm";
                break;
            case "html":
                icon = "html";
                break;
            case "ppt":
            case "pptx":
            case "pps":
            case "ppsx":
                icon = "ppt";
                break;
            case "xls":
            case "xlsx":
                icon = "excel";
                break;
            case "txt":
                icon = "txt";
                break;
            case "pdf":
                icon = "pdf";
                break;
            case "jpg":
            case "jpeg":
            case "bmp":
            case "png":
            case "gif":
            case "psd":
            case "gsp":
            case "gss":
                icon = "img";
                break;
            case "mp3":
            case "wma":
            case "wav":
            case "ogg":
            case "ape":
            case "mid":
            case "midi":
            case "tch":
                icon = "sound";
                break;
            case "rmvb":
            case "mp4":
            case "avi":
            case "wmv":
            case "asf":
            case "3gp":
            case "flv":
            case "mpg":
            case "mpeg":
            case "mpeg4":
            case "rm":
            case "mov":
            case "vob":
            case "mkv":
            case "m2ts":
                icon = "movie";
                break;
            case "swf":
            case "flash":
            case "pic":
            case "gif":
            case "mov":
            case "flv":
            case "flc":
            case "fla":
            case "mpeg":
                icon = "swf";
                break;
            default:
                icon = "default";
                break;
        };
        return "assert/static/common/images/icon_16X16/img_" + icon + ".png";
    }
    //设置来源
    function setSource(source, creator) {
        var view_source = "";
        switch (source) {
            case "KXX":
                view_source = "酷学习";
                break;
            case "IFLY-AI":
            case "IFLYTEK":
                view_source = "畅言教育";
                break;
            case "UGC":
            case "XIAOBENZIYUAN":
                view_source = creator || "匿名";
                break;
            case "GUOJIA":
            case "EDU":
                view_source = "国家教育资源平台";
                break;
            case "RENJIAOJIAOFU":
                view_source = "人教教辅";
                break;
            default:
                view_source = "畅言教育";
                break;
        };
        return view_source;
    }
    //设置星评
    function setStar(dom, scoreCount) {
        var fullstar = 0;
        var banstar = 0;
        var nonestar = 0;
        fullstar = parseInt(scoreCount);
        banstar = (scoreCount % 1) > 0 ? 1 : 0;
        nonestar = 5 - fullstar - banstar;
        for (var i = 0; i < fullstar; i++) {
            dom.find('.star').append('<i class="star-bright"></i>');
        }
        for (var i = 0; i < banstar; i++) {
            dom.find('.star').append('<i class="star-brightalf"></i>');
        }
        for (var i = 0; i < nonestar; i++) {
            dom.find('.star').append('<i class="star-gray"></i>');
        }
    }
    //重置排序状态  flag:是否不重置勾选状态
    search.prototype.resetSort = function (sortField, flag) {
        var _this = this;
        //重置付费与精品 sortField有值时表示是同一层级
        if (!flag) {
            _this.resetPayAndQuality();
        }

        $("#sortField").find("a").removeClass("blue");
        $("#sortField").find("a i").html("&#xe640;");
        if (sortField == _this.param.sortField) {
            if (_this.param.sortType == "DESC") {
                _this.setSortType("ASC");
                $("#sortField").find('[data-value="' + sortField + '"] i').html("&#xe639;");
            } else {
                $("#sortField").find('[data-value="' + sortField + '"] i').html("&#xe640;");
                _this.setSortType("DESC");
            }
        } else {
            _this.setSortType("DESC");
        }
        if (sortField) {
            _this.setSortField(sortField);
            $("#sortField").find('[data-value="' + sortField + '"]').addClass("blue");
        } else {
            _this.setSortField("");
            $("#sortField").find('[data-value=""]').addClass("blue");
        }

    }
    //重置精品与付费状态
    search.prototype.resetPayAndQuality = function (sortField) {
        var _this = this;
        _this.setPayModel("");
        _this.setQuality("");
        $("input[name='payModel']").prop("checked", false);
        $("input[name='payModel']").parent().removeClass("blue");
        $("input[name='quality']").prop("checked", false);
        $("input[name='quality']").parent().removeClass("blue");
    }

    //获取学段列表
    search.prototype.getPhaseList = function (param) {
        var _this = this;
        var def = jQuery.Deferred();
        var p = {
            type: param
        }
        edcService.Instance().core_common_dic_get(p).done(function (ret) {
            if (ret && ret.code == 0) {
                var viewPhase = [];
                for (var i = 0; i < _this.phaseList.length; i++) {
                    var f = ret.data.filter(function (el) {
                        return el.name == _this.phaseList[i];
                    });
                    viewPhase.push(f[0]);
                }
                def.resolve(viewPhase);
            } else {
                addTipDialog("网络请求失败");
            }

        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    }
    //获取学科列表
    search.prototype.getSubjectList = function () {
        var _this = this;
        var def = jQuery.Deferred();
        var p = {
            phase: _this.param.phase || ""
        }
        edcService.Instance().ersp_resource_metadata_subject_list(p).done(function (ret) {

            if (ret && ret.code == 0) {
                var f = ret.data.data.filter(function (el) {
                    return _this.subjectFilter.indexOf(el.name) == -1;
                });
                def.resolve(f);
            } else {
                addTipDialog("网络请求失败");
            }
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    }
    //获取版本列表
    search.prototype.getEditionList = function () {
        var _this = this;
        var def = jQuery.Deferred();
        var p = {
            phase: _this.param.phase || "",
            subject: _this.param.subject || ""
        }
        edcService.Instance().ersp_resource_metadata_edition_list(p).done(function (ret) {
            if (ret && ret.code == 0) {
                def.resolve(ret.data.data);
            } else {
                addTipDialog("网络请求失败");
            }
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    }
    //获取教材列表
    search.prototype.getBookList = function () {
        var _this = this;
        var def = jQuery.Deferred();
        var p = {
            phase: _this.param.phase || "",
            subject: _this.param.subject || "",
            edition: _this.param.edition || "",
            limit: 50,
            page: 1
        }
        edcService.Instance().ersp_resource_metadata_book_list(p).done(function (ret) {
            if (ret && ret.code == 0) {
                def.resolve(ret.data.data);
            } else {
                addTipDialog("网络请求失败");
            }
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    }
    search.prototype.getBookDetail = function (bookCode) {
        var def = jQuery.Deferred();
        var p = {
            bookCode: bookCode
        }
        edcService.Instance().ersp_resource_metadata_book_get(p).done(function (ret) {
            if (ret && ret.code == 0) {
                def.resolve(ret.data.data);
            } else {
                addTipDialog("网络请求失败");
            }
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    }
    search.prototype.getUint = function (param) {}
    //获取资源类型
    search.prototype.getTypeList = function (param) {
        var _this = this;
        var viewType = [];
        if (param == "05") {
            viewType = _this.typeList;
        } else {
            viewType = _this.typeList.filter(function (el) {
                return el.name != "导学案";
            });
        }
        return viewType;
    }
    //根据类型获取资源的统计量
    search.prototype.getResCountByType = function (param) {
        var _this = this;
        var p = {
            key: "type",
            topic: "08",
            source: "UGC,IFLYTEK,MAISUI,KXX,XIAOBENZIYUAN,ZHONGBAO"
        }
        if (param.book) {
            p.book = param.book;
        }
        if (param.unit1) {
            p.unit1 = param.unit1;
        }
        if (param.unit2) {
            p.unit2 = param.unit2;
        }
        if (param.unit3) {
            p.unit3 = param.unit3;
        }
        if (param.unit4) {
            p.unit4 = param.unit4;
        }
        if (param.payModel === 0) {
            p.payModel = param.payModel;
        }
        if (param.quality === 21) {
            p.quality = param.quality;
        }
        if (param.appName) {
            p.appName = param.appName;
        }
        if (param.platform) {
            p.platform = param.platform;
        }
        //接口不支持带有关键词查询的数据统计量，故不显示
        if (param.q || param.field) {
            $("#type").find('a span').html("");
            return;
        }
        edcService.Instance().ersp_resource_staticResource(p).done(function (ret) {
            if (ret && ret.code == 0 && ret.data.data) {
                //只刷新当前类型的统计量做特殊处理
                if (param.isOnlyOneCount) {
                    if (ret.data.data[param.type]) {
                        $("#type").find('[data-value=' + param.type + '] span').html("(" + ret.data.data[param.type] + ")");
                    } else {
                        $("#type").find('[data-value=' + param.type + '] span').html("(0)");
                    }
                    _this.param.isOnlyOneCount = false;
                    return;
                }
                for (var i = 0; i < _this.typeList.length; i++) {
                    if (ret.data.data[_this.typeList[i].code]) {
                        $("#type").find('[data-value=' + _this.typeList[i].code + '] span').html("(" + ret.data.data[_this.typeList[i].code] + ")");
                    } else {
                        $("#type").find('[data-value=' + _this.typeList[i].code + '] span').html("(0)");
                    }
                }
            } else {
                console.log("获取统计量失败");
            }
        }).fail(function (e) {
            console.log("获取统计量失败");
        });
    }
    //根据选择信息获取资源列表
    search.prototype.getResList = function (param) {
        var def = jQuery.Deferred();
        var _this = this;
        var p = {
            phase: param.phase || "",
            subject: param.subject || "",
            edition: param.edition || "",
            book: param.book || "",
            unit1: param.unit1 || "",
            unit2: param.unit2 || "",
            unit3: param.unit3 || "",
            unit4: param.unit4 || "",
            type: param.type || "",
            sortField: param.sortField || "",
            sortType: param.sortType || "",
            q: param.q || "",
            source: param.source || "",
            field: param.field || "", //搜索必要字段
            extension: param.extension || "",
            topic: param.topic || "",
            payModel: param.payModel === 0 ? 0 : "",
            quality: param.quality || "",
            limit: 10,
            page: param.page || 1
        }
        var appName = _ebookContext.getUser().getUserAppName();
        _this.isAppNameExist(appName).done(function (ret) {
            //查询平台资源
            if (ret && appName != _default_appName) {
                p.appName = appName;
                p.platform = "";
                // _this.getResCountByType(p);
                edcService.Instance().ersp_resource_platform_list(p).done(function (ret) {
                    if (ret && ret.code == 0) {
                        def.resolve(ret.data);
                    } else {
                        addTipDialog("网络请求失败");
                    }
                }).fail(function (e) {
                    def.reject(e);
                });
                console.log(appName);
            } else {
                _this.getResCountByType(param);
                edcService.Instance().ersp_resource_list(p).done(function (ret) {
                    if (ret && ret.code == 0) {
                        def.resolve(ret.data);
                    } else {
                        addTipDialog("网络请求失败");
                    }
                }).fail(function (e) {
                    def.reject(e);
                });
            }
        }).fail(function (e) {
            //失败查询中心数据
            _this.getResCountByType(param);
            edcService.Instance().ersp_resource_list(p).done(function (ret) {
                if (ret && ret.code == 0) {
                    def.resolve(ret.data);
                } else {
                    addTipDialog("网络请求失败");
                }
            }).fail(function (e) {
                def.reject(e);
            });
        });
        return def.promise();
    }
    //根据书本获取教材目录
    search.prototype.getMenu = function (param) {
        var def = jQuery.Deferred();
        var p = {
            bookCode: param.book
        }
        edcService.Instance().ersp_resource_metadata_book_unit_list(p).done(function (ret) {
            if (ret && ret.code == 0) {
                def.resolve(ret.data);
            } else {
                console.log("获取书本目录失败");
                addTipDialog("网络请求失败");
            }
        }).fail(function (e) {
            def.reject(e);
            addTipDialog("网络请求失败");
        });
        return def.promise();
    }
    /**
     * 将cycore数据转为ztree数据
     *
     * 书本目录加载
     */
    search.prototype.MenuFormat = function () {
        var _self = this;

        function MenuNode() {
            this.name = "";
            this.Unit1 = "";
            this.Unit2 = "";
            this.Unit3 = "";
            this.Unit4 = "";
            this.children = "";
            this.open = "";
        }

        this.zTreeJson = function (Unit1s, thisName) {
            var list = _self.turnMenuNode(Unit1s)
            var rootJson = new MenuNode();
            rootJson.children = list;
            if (thisName) {
                rootJson.name = thisName;
            }

            rootJson.open = true;
            return rootJson;

        };
        this.turnMenuNode = function (Unit1s) {
            var obj = null;
            var list = [];
            var Units = Unit1s;
            for (var i = 0, len = Units.length; i < len; i++) {
                obj = new MenuNode();
                obj.name = Units[i].name;
                obj.Unit1 = Units[i].code;
                obj.Unit2 = "";
                obj.Unit3 = "";
                obj.Unit4 = "";
                if (Units[i].courses.length > 0) {
                    obj.children = Unit2(Units[i].courses, obj.Unit1);
                    obj.open = true;
                }
                list.push(obj);
            }
            return list;
        }

        function Unit2(Unit2s, unit1code) {
            var obj = null;
            var list = [];
            var Units = Unit2s;
            for (var i = 0, len = Units.length; i < len; i++) {
                obj = new MenuNode();
                obj.name = Units[i].name;
                obj.Unit1 = unit1code;
                obj.Unit2 = Units[i].code;
                //  obj.Unit2 = i ;
                obj.Unit3 = "";
                obj.Unit4 = "";
                if (Units[i].courses.length > 0) {
                    obj.children = Unit3(Units[i].courses, unit1code, obj.Unit2);
                    obj.open = true;
                }
                list.push(obj);
            }
            return list;
        }

        function Unit3(Unit3s, unit1code, unit2code) {
            var obj = null;
            var list = [];
            var Units = Unit3s;
            for (var i = 0, len = Units.length; i < len; i++) {
                obj = new MenuNode();
                obj.name = Units[i].name;
                obj.Unit1 = unit1code;
                obj.Unit2 = unit2code;
                obj.Unit3 = Units[i].code;
                //           obj.Unit3 = i ;
                obj.Unit4 = "";
                if (Units[i].courses.length > 0) {
                    obj.children = Unit4(Units[i].courses, unit1code, unit2code, obj.Unit3);
                    obj.open = true;
                }
                list.push(obj);
            }
            return list;
        }

        function Unit4(Unit3s, unit1code, unit2code, unit3code) {
            var obj = null;
            var list = [];
            var Units = Unit3s;
            for (var i = 0, len = Units.length; i < len; i++) {
                obj = new MenuNode();
                obj.name = Units[i].name;
                obj.Unit1 = unit1code;
                obj.Unit2 = unit2code;
                obj.Unit3 = unit3code;
                obj.Unit4 = Units[i].code;
                //           obj.Unit4 = i ;
                list.push(obj);
            }
            return list;
        }
    }
    search.prototype.loadMenu = function (jsonObj, unit) {
        var _this = this;
        var menuNode = jsonObj;
        var setting = {
            data: {
                key: {
                    title: "name"
                },
                simpleData: {
                    enable: true
                }
            },
            callback: {
                beforeClick: beforeClick,
                onClick: onClick
            }
        };


        $.fn.zTree.init($("#mainMenu"), setting, menuNode);
        if (unit) {
            var treeObj = $.fn.zTree.getZTreeObj("mainMenu");
            var node = treeObj.getNodesByFilter(function (node) {
                return node.Unit1 == unit.unit1 && node.Unit2 == unit.unit2 && node.Unit3 == unit.unit3 && node.Unit4 == unit.unit4;
            }, false);
            if (node[0]) {
                treeObj.selectNode(node[0], false);
            }
        }
        //目录点击前触发
        function beforeClick(treeId, treeNode, clickFlag) {
            // 
        }

        //目录点击时触发，基本信息已经保存
        function onClick(event, treeId, treeNode, clickFlag) {
            var unit = {
                unit1: treeNode.Unit1,
                unit2: treeNode.Unit2,
                unit3: treeNode.Unit3,
                unit4: treeNode.Unit4
            }

            _this.setUnit(unit);
            _this.setType();
            // _this.setPage(1);
            // _this.getResList(_this.param).done(function(ret){
            //     _this.setViewList(ret);
            // }).fail(function(e){
            //     console.log("获取资源列表失败");
            // });
        }
    }
    search.prototype.formatMenu = function (str, bookcode, callback, thisName) {
        var _this = this;
        var menuJson = JSON.parse(str);
        var menuParser = new _this.MenuFormat();
        var menujson = menuParser.zTreeJson(menuJson.data, thisName);
        callback && callback;
        _this.loadMenu(menujson, _this.param);
    };

    function addTipDialog(tips, buttons, callback) {
        if (!tips) return;
        $.Zebra_Dialog(tips, {
            'type': 'information',
            'title': AppTips.WarmTips,
            'buttons': buttons == undefined ? [AppTips.OkTips] : buttons,
            'onClose': function (caption) {
                if (typeof callback === 'function') callback(caption);
            }
        });
    }

    exports.Instance = new search();
});
//拓展date方法，但是放在这里不合适 by njfu
Date.prototype.format = function (format) {
    var o = {
        "M+": this.getMonth() + 1, //month
        "d+": this.getDate(), //day
        "h+": this.getHours(), //hour
        "m+": this.getMinutes(), //minute
        "s+": this.getSeconds(), //second
        "q+": Math.floor((this.getMonth() + 3) / 3), //quarter
        "S": this.getMilliseconds() //millisecond
    }
    if (/(y+)/.test(format)) format = format.replace(RegExp.$1,
        (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(format))
            format = format.replace(RegExp.$1,
                RegExp.$1.length == 1 ? o[k] :
                ("00" + o[k]).substr(("" + o[k]).length));
    return format;
}