;define(function (require, exports) {

    var _cloudresourceBase = require('../resbar/cloudresourcebase');
    var _snsBase = AppRemoteSvcCfgBase.CYSNSBASEFEED + "?";
    var _ebookContext = require('../../ebookcontext').Instance;
    var _shellCmd = require('../../../common/shellcmd');
    var ResPageControl = require('./resourcepagecontrol').ResourcePageControl;
    var _resourceErr = require('./resourceerror').Instance;
    var _scoreUrlBase = AppSvcHelper.CYSVC + "&";
    var _resAccessor = require('./resaccessor').Instance;
    var _path = require('../../../common/path');
    var _pptIcwsAccessor = require('./ppticwsaccessor').Instance;


    function ResContent() {
        var _self = this;

        var _hasInit = false;

//        var _login = false;

        var _resPageControl = null;

        //存放多张缩略图的数组
        var _thumbnailArr = [];

        //多张缩略图的索引
        var _currIndex = 0;
        //多张索引图最大组数，一组5张缩略图
        var _maxGroup = 1;
        //多张索引图改变前组数，一组5张缩略图
        var _previousGroup = 1;
        //多张索引图改变后组数，一组5张缩略图
        var _nowGroup = 1;

        //打分成功标志
        var _scoreSucess = false;

        //下载相关参数
        var _downloadParam = {};
        $.each(("id title author thumbnail description keywords publisher " +
        "subject volumn bookCode username realname unit course fileSize grade " +
        "category file extension source sourcepage savepath dbpath photo").split(" "), function (i, name) {

            _downloadParam[name] = '';
        });
        var aboutres = [];//相关资源推荐

        var _indexUrl = '';

        //添加评论
//        var _addComment = {
//            method  : 'sns.feed.addcomment',
//            uid     : '',
//            content : '',
//            to_comment_id:'',
//            to_uid  : '',
//            resourceId : ''
//        };
        var _addComment = {
            method: 'res.comment.add',
            uid: '',
            content: '',
            to_comment_id: '',
            to_uid: '',
            rid: '',
            app: 'C6SakiHO'
        };

        //获取评论
        var _getComment = {
            method: 'res.comment.list.all',
            rid: '',
            page: 1,
            limit: 10,
            app: 'C6SakiHO'
        }

        //打分
        var _score = {
            method: 'res.resource.statistic.update',
            key: 'scorecount',
            resourceid: '',
            score: ''
        }

        //增加阅读数
        var _addViewCount = {
            method: 'res.resource.statistic.update',
            key: 'viewcount',
            resourceid: ''
        }

        //让label标签加1
        var _addLabel = {
            method: 'res.label.add',
            uid: '',
            resId: '',
            labelId: ''

        }

        //获取某个资源的label列表
        var _getLabel = {
            method: 'res.label.list',
            resId: ''
        }

        var _addDownloadCount = {
            method: 'res.resource.statistic.update',
            key: 'downloadcount',
            resourceid: ''

        }

        //资源详情框：用户评论
        var _commentTplLogin = '<li>' +
            '<p class="clearfix"><a href="javascript:;" class="blue_text" userid="{userid}" name="people">{commentor}：</a>{commentContent}</p>' +
            '<p class="clearfix"><span class="fl gray">{time}</span><span class="fr"><a href="javascript:;" flag="commentFlag" class="blue_text">回复评论</a></span></p>' +
            '<p class="clearfix" style="display: none;"><textarea class="fl" name="" type="text" style="font-size: 1em" value=""></textarea><span class="fr" style="float:left"><a href="javascript:;" flag="replyFlag" myuid={uid} mycommentid={commentid} resId={resourceId} class="smartbar_btn" style="width: 50px; margin-top: 3px;" title="回复">回复</a></span></p>' +
            '</li>';
        var _commentTplNoLogin = '<li>' +
            '<p class="clearfix"><a href="javascript:;" class="blue_text" userid="{userid}" name="people">{commentor}：</a>{commentContent}</p>' +
            '<p class="clearfix" style="display: none"><span class="fl gray">{time}</span><span class="fr"><a href="javascript:;" flag="commentFlag" class="blue_text">回复评论</a></span></p>' +
            '<p class="clearfix" style="display: none;"><textarea  class="fl" name="" type="text" style="font-size: 1em" value=""></textarea><span class="fr" style="float:left"><a href="javascript:;" flag="replyFlag" myuid={uid} mycommentid={commentid} resId={resourceId} class="smartbar_btn" style="width: 50px; margin-top: 3px;" title="回复">回复</a></span></p>' +
            '</li>';
        var _commentTpl = '';

        var _otherCommentTplLogin = '<li>' +
            '<p class="clearfix"><a href="javascript:;" class="blue_text" userid="{userid}" name="people">{subjector}</a><a> 对 </a><a href="javascript:;" class="blue_text" userid="{to_userid}" name="people">{objector}</a><a>说：</a>{commentContent}</p>' +
            '<p class="clearfix"><span class="fl gray">{time}</span><span class="fr"><a href="javascript:;" flag="commentFlag" class="blue_text">回复评论</a></span></p>' +
            '<p class="clearfix" style="display: none"><textarea class="fl" name="" type="text" style="font-size: 1em" value=""></textarea><span class="fr" style="float:left"><a href="javascript:;" flag="replyFlag" myuid={uid} mycommentid={commentid} resId={resourceId} class="smartbar_btn" style="width: 50px; margin-top: 3px;" title="回复">回复</a></span></p>' +
            '</li>';
        var _otherCommentTplNoLogin = '<li>' +
            '<p class="clearfix"><a href="javascript:;" class="blue_text" userid="{userid}" name="people">{subjector}</a><a> 对 </a><a href="javascript:;" class="blue_text" userid="{to_userid}" name="people">{objector}</a><a>说：</a>{commentContent}</p>' +
            '<p class="clearfix" style="display: none"><span class="fl gray">{time}</span><span class="fr"><a href="javascript:;" flag="commentFlag" class="blue_text">回复评论</a></span></p>' +
            '<p class="clearfix" style="display: none"><textarea class="fl" name="" type="text" style="font-size: 1em" value=""></textarea><span class="fr" style="float:left"><a href="javascript:;" flag="replyFlag" myuid={uid} mycommentid={commentid} resId={resourceId} class="smartbar_btn" style="width: 50px; margin-top: 3px;" title="回复">回复</a></span></p>' +
            '</li>';

        var _otherCommentTpl = '';

        //资源详情框：相关资源推荐
        var relatedRecommendItem = '<li name="relatedRecommendItem" resourceid="{resourceid}">' +
            '<div class="comments-img"><img src="assert/static/common/images/icon_16X16/{extension}.png"></div>' +
            '<div class="comments-tit">' +
            '<div class="comments-kt"><p title="{sourceNametitle}" style="min-width:120px;">{sourceName}</p><p class="comments-time" title="评分数：{scoreT}分"><b class="blue">{score}分</b>（{scorecount}人评分）</p></div>' +
            '<div class="comments-ktl"><span class="gray">大小：{sourceLength}MB</span><span class="gray">浏览：{browseNum}</span><span class="gray">{time}</span></div>' +
            '</div>' +
            '</li>';

        var _relatedRecommendItem = '';

        //var _compressionTpl = '<a href="#" class="yx_btnred">内容详实(<em>272</em>)</a><a href="#" class="yx_btnorange">内容原创(<em>402</em>)</a><a href="#" class="yx_btnblue">趣味性强(<em>322</em>)</a><a href="#" class="yx_btngreen">效果美观(<em>182</em>)</a><a href="#" class="yx_btnred">互动性强(<em>282</em>)</a><a href="#" class="yx_btnorange">素材质量一般(<em>22</em>)</a><a href="#" class="yx_btnblue">不符合教学要求(<em>2</em>)</a>';

        //var _compressionTpl = '<a href="#" class="yx_btnred">内容详实(<em>272</em>)</a><a href="#" class="yx_btnorange">内容原创(<em>402</em>)</a><a href="#" class="yx_btnblue">趣味性强(<em>322</em>)</a><a href="#" class="yx_btngreen">效果美观(<em>182</em>)</a><a href="#" class="yx_btnred">互动性强(<em>282</em>)</a><a href="#" class="yx_btnorange">素材质量一般(<em>22</em>)</a><a href="#" class="yx_btnblue">不符合教学要求(<em>2</em>)</a><a href="#" class="yx_btngreen">实用性强(<em>2</em>)</a><a href="#" class="yx_btnred">思路新颖(<em>2</em>)</a><a href="#" class="yx_btnorange">内容非常生动(<em>2</em>)</a><a href="#" class="yx_btnblue">应用价值不高(<em>2</em>)</a>';
        _self.bookContainer = null;
        _self.smartBarEle = null;
        _self.resultData = null;
        _self.commentorIdname = [];
        _self.commentorInfo = [];
        _self.resultOrigin = [];
        _self.buttons = {
            btn_closeResCntPage: $("#btn_closeResCntPage"),
            btn_resourcepreview: $("#btn_resourcepreview"),
            btn_addToBook: $("#btn_addToBook"),
            btn_IComment: $("#btn_IComment")
        };

        _self.controls = {
            resourceContentPage: $("#resourceContentPage"),
            resourceCntTitle: $("#resourceCntTitle"),
            commentArea: $("#commentArea"),
            commentList: $("#commentList"),
            scoreStarId: $("#scoreStarId"),
            resShareId: $("#resShareId"),
            commentsTextarea: $("#comments-textarea"),
            findErrorId: $("#findErrorId"),
            userCompressionId: $("#userCompressionId"),
            resourceTitleId: $("#resourceTitleId"),
            commentsCounts: $("#commentsCounts"),
            resourceStarsId: $("#resourceStarsId"),
            resourceAuthorId: $("#resourceAuthorId"),
            extensionTypeId: $("#extensionTypeId"),
            previewCountId: $("#previewCountId"),
            downloadCountId: $("#downloadCountId"),
            byteCountId: $("#byteCountId"),
            uploadTimeId: $("#uploadTimeId"),
            resourceDesId: $("#resourceDesId"),
            editorPreId: $("#editorPreId"),
            editorNextId: $("#editorNextId"),
            smalleditorPreId: $("#smalleditorPreId"),
            smalleditorNextId: $("#smalleditorNextId"),
            viewThumbsId: $("#viewThumbsId"),
            viewMoreThumbsId: $("#viewMoreThumbsId"),
            viewThumbsListId: $("#viewThumbsListId"),
            downloadresId: $("#downloadresId"),
            resContProBarId: $("#resContProBarId"),
            realBarId: $("#realBarId"),
            cancelResContId: $("#cancelResContId"),
            comments_dl: $("#comments_dl"),
            relatedRecommendList: $("#relatedRecommendList"),
            detailResTitle: $("#detail_res_title"),
            resAuthor: $("#res_author")
        };

        _self.init = function (bookContainer, smartBarEle) {
            if (_hasInit) {
                return;
            }
            setGlobalContextResContMgr(_self);
            _hasInit = true;
            _self.bookContainer = bookContainer;
            _self.smartBarEle = smartBarEle;

            _resPageControl = new ResPageControl("resContPageContr");
            _resPageControl.onclick = function (index) {
                _self.getComments(index).done(function (retObj) {
                    var deffer = $.Deferred();
                    $.when(_self.renderComments(retObj, deffer)).done(
                        function () {
                            _self.bindEvents()
                        })
                })
            }

            _self.buttons.btn_closeResCntPage.click(function () {
                _self.closeResContentPanel();
            })

            _self.controls.resourceContentPage.draggable({

                handle: _self.controls.resourceCntTitle,
                containment: $("#wrap")
            });

            //预览
            _self.buttons.btn_resourcepreview.click(function () {

                //temp eshop监管 linwang5@iflytek.com
                var resFrom = _self.resultData.resFrom;
                if (resFrom == 'selected') {
                    var staticParams = {
                        uid: _ebookContext._curUser._uid,
                        module: '01016',
                        type: 'trigger',
                        bookCode: _ebookContext.curBookCode
                    };
                    edcService.Instance().api_eshop_baseStatics(staticParams);
                } else if (resFrom == 'recommend') {
                    var staticParams = {
                        uid: _ebookContext._curUser._uid,
                        module: '01017',
                        type: 'trigger',
                        bookCode: _ebookContext.curBookCode
                    };
                    edcService.Instance().api_eshop_baseStatics(staticParams);
                }

                var type = _self.resultData.extension;
                var url = _self.resultData.previewurl;
                if (url) {
                    _self.closeResContentPanel();
                    _self.previewRes(type, url, _self.resultData);
                } else {
                    _this.showCommonTip({
                        "title": "温馨提示",
                        "content": "该资源不支持在线预览，请下载后查看"
                    });
                }
            });

            //直接点击图片区域也是预览效果
            _self.controls.viewThumbsId.click(function () {
                var type = _self.resultData.extension;
                var url = _self.resultData.previewurl;
                if (url) {
                    _self.closeResContentPanel();
                    _self.previewRes(type, url, _self.resultData);
                }
            });

            //加入课本
            _self.buttons.btn_addToBook.click(function () {
                var curPageIndex = _self.bookContainer.getPageIndex();  //下载时当前页
                _self.resultData.pageIndex = curPageIndex;
                var paydownloaded = false;
                var resultData = _self.resultData;

                newWidgetPos = null;
                // resultData.sourcepage = "resourcecontent";
                var userId = _ebookContext.getUser().getUid();
                //todo 开发时使用
                // resultData.payModel=1;
                // resultData.exchangeCredit=20000;
                if (resultData.payModel == 1 && resultData.exchangeCredit != 0) {
                    //付费资源，先判断用户对此资源是否已经付费，已经付费直接下载，未付费则查询用户有多少积分
                    var params = {
                        action: "download",
                        userId: userId,
                        resId: resultData.id
                    };
                    edcService.Instance().ersp_resource_user_credit_action(params).done(function (ret) {
                        paydownloaded = ret.data.data;
                        //todo 开发时使用
                        // paydownloaded=false;
                        if (paydownloaded == true) {//用户已付费
                            $("#alreadyPayforResources").show();
                        } else {//用户未付费
                            var params = {
                                userId: userId,
                            };
                            //获得用户现在拥有的积分
                            edcService.Instance().ersp_resource_user_credit_get(params).done(function (ret) {
                                //用户现在拥有的积分
                                var total_credit = ret.data.data.toFixed(1);
                                var need_credit = resultData.exchangeCredit;
                                if (total_credit && need_credit) {
                                    $("#payforResources").show();
                                    _self.resultData.totalCredit = total_credit;
                                    if (need_credit - total_credit > 0) {//需要积分大于总积分
                                        $("#payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前积分不足";
                                        $("#payforResources .btn-gray").hide();
                                    } else {
                                        $("#payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前有" + total_credit + "积分，确认下载么？";
                                    }
                                }
                            }).fail(function (err) {
                                console.log(err);
                            })
                        }
                    }).fail(function (err) {
                        console.log(err);
                    })
                } else {//非付费资源直接下载
                    _self._swithToBar();
                    /*if (resultData.resFrom && resultData.resFrom == "selected") {
                        _self.downLoadFile(resultData, "CloudresourceBase");
                    } else {
                        _self.downLoadFile(resultData, "resourcecontent");
                    }*/
                    _self.downLoadFile(resultData);
                }
                ;
            });
            //付费资源，扣费继续下载
            $("#payforResources .btn-blue").click(function () {
                var resultData = _self.resultData;
                var need_credit = parseInt(resultData.exchangeCredit).toFixed(1);//需要积分为正，下载资源扣分设置为负值
                var total_credit = parseInt(resultData.totalCredit).toFixed(1);
                var title = resultData.title;
                var resourceid = resultData.id;
                //请求扣费接口进行扣费
                if (total_credit - need_credit >= 0) {
                    var param = {
                        userId: _ebookContext.getUser().getUid(),
                        action: "download",
                        score: -need_credit,
                        resId: resourceid,
                        data: title
                    };
                    edcService.Instance().ersp_resource_user_credit_update(param).done(function (ret) {
                        $("#payforResources").hide();
                        _self._swithToBar();
                        /*if (resultData.resFrom && resultData.resFrom == "selected") {
                            _self.downLoadFile(resultData, "CloudresourceBase");
                        } else {
                            _self.downLoadFile(resultData, "resourcecontent");
                        }*/
                        _self.downLoadFile(resultData);
                    }).fail(function (err) {
                        console.log(err);
                    });
                } else {
                    $("#payforResources").hide();
                }
                ;
            });
            //付费资源：扣费取消下载
            $("#payforResources .btn-gray").click(function () {//取消按钮
                $("#payforResources").hide();
            });
            $("#payforResources a").click(function () {//右上角的×
                $("#payforResources").hide();
            });

            //付费资源：已扣费，继续下载
            $("#alreadyPayforResources .btn-blue").click(function () {
                var resultData = _self.resultData;
                $("#alreadyPayforResources").hide();
                _self._swithToBar();
                /*if (resultData.resFrom && resultData.resFrom == "selected") {
                    _self.downLoadFile(resultData, "CloudresourceBase");
                } else {
                    _self.downLoadFile(resultData, "resourcecontent");
                }*/
                _self.downLoadFile(resultData);
            });
            //付费资源：已扣费，不继续下载
            $("#alreadyPayforResources .btn-gray").click(function () {//取消按钮
                $("#alreadyPayforResources").hide();
            });
            $("#alreadyPayforResources a").click(function () {//右上角的×
                $("#alreadyPayforResources").hide();
            });


            //我要评论
            _self.buttons.btn_IComment.click(function () {
                var uid, resId, content;
                uid = _ebookContext.getUser().getUid();
                resId = _self.resultData.id;
                content = _self.controls.commentArea.val();
                //有评论内容则继续，否则提示错误
                if (content) {
                    //第一步、判断是否初次评论
                    var param = {
                        action: "comment",//根据需要确定，如"download","score"等
                        userId: uid,//用户id
                        resId: resId//资源id
                    };
                    edcService.Instance().ersp_resource_user_credit_action(param).done(function (ret) {
                        if (ret.code == "0" && ret.data.data == false) {//返回值为false是初次评论
                            //第二步、如果是初次评论，记录用户行为并且积分加1
                            var api_ersp_user_credit_update_param = {
                                userId: uid,
                                action: "comment",
                                score: 1, //"+5,-5"
                                resId: resId,
                                data: _self.resultData.title
                            };
                            edcService.Instance().ersp_resource_user_credit_update(api_ersp_user_credit_update_param).done(function (ret) {
                                if (ret.code == "0") {
                                    //第三步、添加评论
                                    _self.addOneComment(uid, resId, content).done(function () {
                                        showAlertTips("恭喜评论成功，首次评价积分+1！");
                                        //评论成功，输入框清空
                                        _self.controls.commentArea.val("");
                                        var param = {
                                            "resourceId": _self.resultData.id,
                                            "page": 1
                                        };
                                        //第四步、评论成功，刷新评论列表并绑定事件
                                        _self.getCommentList(param).done(function(ret){
                                            _self.renderComments(ret).done(function(){
                                                _self.bindEvents();
                                            });
                                        }).fail(function(e){
                                            _self.bindEvents();
                                            console.log("获取评论列表失败");
                                        });
                                    }).fail(function () {
                                        showAlertTips("评论失败，请稍后再试");
                                    })
                                } else {
                                    showAlertTips("评论失败，请稍后再试");
                                }
                            }).fail(function () {
                                showAlertTips("评论失败，请稍后再试");
                            })
                        } else {//不是首次评论，不增加积分，省略第二步。
                            //第三步、添加评论
                            _self.addOneComment(uid, resId, content).done(function () {
                                showAlertTips("恭喜评论成功");
                                //评论成功，输入框清空
                                _self.controls.commentArea.val("");
                                var param = {
                                    "resourceId": _self.resultData.id,
                                    "page": 1
                                };
                                //第四步、评论成功，刷新评论列表并绑定事件
                                _self.getCommentList(param).done(function(ret){
                                    _self.renderComments(ret).done(function(){
                                        _self.bindEvents();
                                    });
                                }).fail(function(e){
                                    _self.bindEvents();
                                    console.log("获取评论列表失败");
                                });
                            }).fail(function () {
                                showAlertTips("评论失败，请稍后再试");
                            })
                        }
                    });
                } else {
                    showAlertTips("评论内容不能为空");
                }
            })

            //为打分星星控件绑定事件
            var starsDomList = _self.controls.scoreStarId.find('input');
            starsDomList.click(function () {
                //if(sessionStorage.getItem(_self.resultData.id) === 'true'){
                //    showAlertTips("您已打分成功，不能重复打分");
                //    return;
                //}
                var index = $(this).index();
                var params = {
                    action: "score",
                    userId: _ebookContext.getUser().getUid(),
                    resId: _self.resultData.id
                };
                //第一步，判断用户是否已经打过分
                edcService.Instance().ersp_resource_user_credit_action(params).done(function (ret) {
                    if (ret.code == "0") {
                        if (ret.data.data == false) {

                            $.each(starsDomList, function () {
                                $(this).removeClass('star_btn').addClass('star_btngray');
                            })
                            var newStarts = starsDomList.slice(0, index + 1);
                            $.each(newStarts, function () {
                                $(this).removeClass('star_btngray').addClass('star_btn');
                            })
                            var resourceid = _self.resultData.id;
                            var scoreval = (index + 1);
                            var scoreRq = _score;
                            scoreRq.resourceid = resourceid;
                            scoreRq.score = scoreval;
                            //新增资源评分
                            var param = {
                                "id": resourceid,
                                "score": scoreval * 20
                            };
                            //第二步，如果未评分，提交打分
                            edcService.Instance().ersp_resource_score_add(param).done(function (result) {
                                console.log(result);
                                if (result.data.data == true) {
                                    var param = {
                                        userId: _ebookContext.getUser().getUid(),
                                        action: "score",
                                        score: 1,
                                        resId: resourceid,
                                        data: _self.resultData.title
                                    };
                                    //第三步，请求接口记录用户打分这个行为，并且积分+1
                                    edcService.Instance().ersp_resource_user_credit_update(param).done(function (ret) {
                                        if (ret.code == "0") {
                                            sessionStorage.setItem(resourceid, 'true');
                                            showAlertTips("打分成功，积分+1！");
                                        } else {
                                            showAlertTips("打分失败，请重试");
                                        }
                                    })
                                } else {
                                    showAlertTips("打分失败，请重试");
                                }
                            });
                        } else {
                            showAlertTips("您已打分成功，不能重复打分");
                            return;
                        }
                    } else {
                        showAlertTips("打分失败，请重试");
                    }

                })

            })

            //资源分享
            _self.controls.resShareId.click(function () {

                _self.resultData.type = '4';//表示从资源中心分享
                _self.shareResToCloud(_self.resultData, "资源已分享到我的主页");
            })

            //资源纠错
            _self.controls.findErrorId.click(function () {
                _resourceErr.showResErrorPanel(_self.resultData);
            })

            //多张缩略图切换事件绑定
            _self.controls.editorPreId.click(function () {
                _self.viewPreImg();
            });

            _self.controls.smalleditorPreId.click(function () {
                _self.viewPreImg();
            });

            _self.controls.editorNextId.click(function () {
                _self.viewNextImg();
            });

            _self.controls.smalleditorNextId.click(function () {
                _self.viewNextImg();
            });

            //下载另存为事件绑定
            _self.controls.downloadresId.click(function () {
                var resultData = _self.resultData;
                var fileName = resultData.title || resultData.id;
                var dotExt = "." + resultData.extension;
                var downloadParam = _downloadParam;
                downloadParam.id = resultData.id;
                downloadParam.title = resultData.title;
                downloadParam.file = resultData.fileurl;
                downloadParam.dbpath = _ebookContext.getUser().getUserDbFullPath();
                downloadParam.sourcepage = "resourcecontent";

                _shellCmd.saveFileDialog(fileName, dotExt).done(function (ret) {
                    console.log(ret);
                    var pathRes = "";
                    if (ret && ret.length > 0) {
                        pathRes = ret[0];
                    }
                    else return;
                    pathRes = pathRes.replace(/\\/g, "\/");
//                    downloadParam.title = pathRes;
                    var ffname = pathRes + '.' + resultData.extension;
                    _shellCmd.isFileExist(ffname).done(function (result) {
                        if (result) {
                            //同名文件存在，弹出对话框询问是否覆盖
                            $.Zebra_Dialog("此位置包含同名文件，是否替换？", {
                                'type': 'question',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.CancelTips, AppTips.OkTips],
                                'onClose': function (capition) {
                                    if (capition == AppTips.OkTips) {
                                        _self._downloadFile(pathRes, downloadParam);
                                    }
                                    else if (capition == AppTips.CancelTips) {
                                        return;
                                    }

                                }
                            });
                        } else {
                            _self._downloadFile(pathRes, downloadParam);

                        }
                    })

                })
            })


            //我要评论的文本区域绑定事件
            _self.controls.commentArea.bind('input propertychange', function () {
                var len = $(this).val().length;
                if (len > 200) {
                    //答案过长，截断处理
                    $(this).val($(this).val().substr(0, 200));
                    showAlertTips('评论不能超过200字');
                }
            })

            //点击资源作者跳转其个人主页
            _self.controls.resourceAuthorId.click(function () {
                /**
                 * 注释时间：2015.4.18 区域平台暂时屏蔽
                 */
//                _indexUrl && _shellCmd.openPageOutside(_indexUrl);
            })

            //绑定大家印象事件
            _self.controls.userCompressionId.find('span').click(function () {
                var that = this;
                var labelId = $(this).attr('labelId');
                var userId = _ebookContext.getUser().getUid();
                var param = {
                    userId: userId,
                    resId: _self.resultData.id,
                    labelId: labelId
                }
                //第一步这个是判断该用户有没有添加该印象
                edcService.Instance().ersp_resource_label_user_exist(param).done(function (retObj) {
                    if (retObj.data.data == true || retObj.code != "0") {//retObj.code=0是接口正常时的情况，如果code不等于0，接口出错，不给用户评价功能
                        showAlertTips('您不能重复评价该印象');
                        return;
                    } else {
                        var param = {
                            action: "impression",
                            userId: _ebookContext.getUser().getUid(),
                            resId: _self.resultData.id
                        }
                        // 第二步，判读用户有没有添加过本资源的其他印象
                        edcService.Instance().ersp_resource_user_credit_action(param).done(function (ret) {
                            if (ret.code == "0") {
                                if (ret.data.data == false) {
                                    //没有添加过本标签且没有添加过本资源其他标签
                                    //第三步，添加课件印象
                                    var param = {
                                        id: _self.resultData.id,
                                        userId: _ebookContext.getUser().getUid(),
                                        labelId: labelId
                                    };
                                    edcService.Instance().ersp_resource_label_add(param).done(function (ret) {
                                        if (ret.data.data == true && ret.code == "0") {
                                            //添加成功，手动刷新印象数
                                            var v = $(that).find('em')[0].innerHTML;
                                            $(that).find('em')[0].innerHTML = parseInt(v) + 1;
                                            sessionStorage.setItem(_self.resultData.id + '_' + labelId, 'true');
                                            //其实第三步才会记录用户行为并且积分+1，但实际上这里用户已经评论成功了，告诉用户评论成功
                                            showAlertTips("课件印象评价成功，积分+1！");
                                            //第四步，记录用户行为并积分+1
                                            var api_ersp_user_credit_update_param = {
                                                userId: userId,
                                                action: "impression",
                                                score: 1,
                                                resId: _self.resultData.id,
                                                data: _self.resultData.title
                                            }
                                            edcService.Instance().ersp_resource_user_credit_update(api_ersp_user_credit_update_param).done(function (ret) {
                                                console.log(ret);
                                            }).fail(function (err) {
                                                console.log(err);
                                            })
                                        }
                                    }).fail(function (err) {
                                        console.log(err);
                                        showAlertTips('印象评价失败，请重试');
                                    });
                                } else {
                                    // 添加过本资源其他标签没添加过本标签
                                    //第二步，添加课件印象
                                    var param = {
                                        id: _self.resultData.id,
                                        userId: _ebookContext.getUser().getUid(),
                                        labelId: labelId
                                    };
                                    edcService.Instance().ersp_resource_label_add(param).done(function (ret) {
                                        if (ret.data.data == true && ret.code == "0") {
                                            //添加成功，手动刷新印象数
                                            var v = $(that).find('em')[0].innerHTML;
                                            $(that).find('em')[0].innerHTML = parseInt(v) + 1;
                                            sessionStorage.setItem(_self.resultData.id + '_' + labelId, 'true');
                                            // showAlertTips("课件印象评价成功！");
                                        }
                                    }).fail(function (err) {
                                        console.log(err);
                                        showAlertTips('印象评价失败，请重试');
                                    });
                                }
                            } else {
                                showAlertTips('印象评价失败，请重试');
                            }
                        })
                    }
                }).fail(function (err) {
                    console.log(err);
                })
            })
            _resourceErr.init(bookContainer, smartBarEle);

        };


        //切换到"加入课本视图"
        _self._swithToAddBook = function () {
            _self.buttons.btn_addToBook.show();
            _self.controls.resContProBarId.hide();
            _self.controls.realBarId.css('width', '0%');
            _self.controls.realBarId[0].innerHTML = '0%';
        }

        //切换到"进度条视图"

        _self._swithToBar = function () {
            _self.buttons.btn_addToBook.hide();
            _self.controls.resContProBarId.show();
        }

        //下载
        _self._downloadFile = function (pathRes, downloadParam) {
            var index = pathRes.lastIndexOf('/');
            var dir = pathRes.substring(0, index).trim();
            var savePath = _path.toPosix(dir);
            var saveTitle = pathRes.substring(index + 1, pathRes.length).trim();
            downloadParam.savepath = savePath;
            downloadParam.title = saveTitle;
            downloadParam.filesavename = saveTitle;
            downloadParam.sourcepage = 'resourcecontentsave';

            var str = JSON.stringify(downloadParam);
            _shellCmd.fileDownload(str);
        }

        //预览下一张缩略图
        _self.viewNextImg = function () {
            var classCurIndex = 0;
            _previousGroup = Math.ceil((_currIndex + 1) / 5);
            if (_currIndex >= _thumbnailArr.length - 1) {
                _currIndex = 0;
            } else {
                _currIndex = _currIndex + 1;
            }
            _nowGroup = Math.ceil((_currIndex + 1) / 5);
            if (_previousGroup != _nowGroup) {
                _self.thumbnailDynamic()
            }
            _self.showImg(_currIndex);
            classCurIndex = _currIndex % 5
            $("#viewThumbsListId").children().removeClass("active");
            $("#viewThumbsListId").children().eq(classCurIndex).addClass("active");
        }

        //预览上一张缩略图
        _self.viewPreImg = function () {
            var classCurIndex = 0;
            _previousGroup = Math.ceil((_currIndex + 1) / 5);
            if (_currIndex <= 0) {
                _currIndex = _thumbnailArr.length - 1;
            } else {
                _currIndex = _currIndex - 1;
            }
            ;
            _nowGroup = Math.ceil((_currIndex + 1) / 5);
            if (_previousGroup != _nowGroup) {
                _self.thumbnailDynamic();
            }
            ;
            _self.showImg(_currIndex);
            classCurIndex = _currIndex % 5;
            $("#viewThumbsListId").children().removeClass("active");
            $("#viewThumbsListId").children().eq(classCurIndex).addClass("active");
        };

        _self.showImg = function (index) {
            _self.controls.viewThumbsId.attr('src', _thumbnailArr[index]);
        };


        /**
         * 展示资源详情页（大的预览框）
         * @param resultData 资源数据
         */
        _self.showResContentPanel = function (resultData) {

            _self.clearData();
            //全局滚轮事件标志
            global_scoll_flag4 = true;

            //显示资源详情框
            _self.controls.resourceContentPage.show();
            $("#resourceContentPage").parent().show();
            _self.controls.detailResTitle.html(resultData.title);
            //判断是登录还是未登录，未登录不让用我要评论功能
            if (_ebookContext.getUser().getName() == AppCfg.defaultuser) {
                _self.controls.comments_dl.css('display', 'none');
                _self.controls.commentsTextarea.css('display', 'none');
                _self.controls.commentList.css('display', 'none');
                $.each(_self.controls.userCompressionId.find('a'), function () {
                    $(this).removeClass().addClass('yx_btngray');
                })
            } else {
                _self.controls.comments_dl.css('display', 'block');
                _self.controls.commentsTextarea.css('display', 'block');
                _self.controls.commentList.css('display', 'block');
            }
            //居中显示
            var bookContainerWidth = _self.bookContainer.getContent().width(),
                resourcePageWidth = _self.controls.resourceContentPage.width(),
                left = ((bookContainerWidth - resourcePageWidth) / 2 + $(".J_resource_center_bar").width()).toFixed(2),
                bookContainerHeight = _self.bookContainer.getContent().height();
            _self.controls.resourceContentPage.css({
                left: left + "px",
                top: "80px"
            });
            var containerWidth = parseInt($("#bookContainer").css("width"))
            var containerHeight = parseInt($("#bookContainer").css("height"))
            if (containerWidth < 800) {
                correctToBaseResolution(_self.controls.resourceContentPage, {keepScale: true});
                _self.controls.resourceContentPage.css("top", "-60px");
                _self.controls.resourceContentPage.draggable({disabled: true});
            }
            if (containerHeight < 762) {
                _self.controls.resourceContentPage.css({
                    top: "inherit",
                    //bottom: "50px"
                });
                //$("#resourceContentPage .jxpop-main").height($("#resourceContentPage .jxpop-main").height()-35)
            }
            //将resulteData赋值给_self.resultData
            _self.resultData = resultData;
            //根据是否付费资源显示下载按钮
            if (resultData.payModel == 1 && resultData.exchangeCredit != 0) {
                $("#btn_addToBook").html(resultData.exchangeCredit + "积分下载课件");
            } else {
                $("#btn_addToBook").html("免费下载课件");
            }
            //显示资源预览图
            _currIndex = 0;
            _thumbnailArr = [];
            _nowGroup = 1;
            if (resultData.screenshots && resultData.screenshots[1] != null && resultData.screenshots[1] != "") {
                for (var i in resultData.screenshots) {
                    _thumbnailArr.push(resultData.screenshots[i]);
                }
                ;
            } else if (resultData.thumburl != null && resultData.thumburl != "") {
                _thumbnailArr.push(resultData.thumburl);
            } else {
                // _thumbnailArr.push("assert/static/pop/images/jxpop-poety.png");
                _thumbnailArr.push(_this.setDefaultThumbnail(resultData.extension));
            }

            //显示资源预览图
            _self.controls.viewThumbsId.attr('src', _thumbnailArr[0]);

            if (_thumbnailArr.length == 1) {
                //这时只有一张缩略图，应该隐藏左右翻图片的箭头
                _self.controls.editorPreId.hide();
                _self.controls.editorNextId.hide();

            } else {
                //显示左右箭头
                _self.controls.editorPreId.show();
                _self.controls.editorNextId.show();
            }
            ;
            if (_thumbnailArr.length < 5) {
                _self.controls.smalleditorPreId.hide();
                _self.controls.smalleditorNextId.hide();
            } else {
                _self.controls.smalleditorPreId.show();
                _self.controls.smalleditorNextId.show();
            }
            ;
            //清空缩略图
            _self.controls.viewThumbsListId.empty();
            //初次加载缩略图
            _self.thumbnailDynamic();
            //给第一张缩略图加样式
            $("#viewThumbsListId").children().eq(0).addClass("active");

            //显示标题
            _self.controls.resourceTitleId[0].innerHTML = resultData.title.length > 14 ? resultData.title.substring(0, 12) + '...' : resultData.title;
            _self.controls.resourceTitleId.attr('title', resultData.title);

            //先清空相关资源推荐
            _self.controls.relatedRecommendList.empty();
            //对所有资源按照下载量进行排序
            aboutres = resultData.origin;
            resultData.origin.sort(function (a, b) {
                return b.statistics.downloadcount - a.statistics.downloadcount;
            })
            //显示相关资源推荐
            if (resultData.origin.length > 1) {
                //一共展示多少推荐资源
                var sourcecount = 0;
                for (var i = 0; i < resultData.origin.length; i++) {
                    var sourceItem = resultData.origin[i];
                    if (sourceItem.id == resultData.id) {
                        continue;
                    } else {
                        sourcecount++;
                        //itemCreattime
                        if (sourcecount < 5) {
                            var extension = sourceItem.extension;
                            var itemName = sourceItem.title;
                            //.length>18?sourceItem.title.substring(0,16)+'...':sourceItem.title+"."+extension;
                            var itemLength = (sourceItem.length / 1024 / 1024).toFixed(1);
                            if (itemLength == "0.0") {
                                itemLength = 0.1;
                            }
                            var itemViewcount = sourceItem.statistics.viewcount;
                            var itemScorecount = sourceItem.statistics.scorecount;
                            var itemCreattime = new Date(sourceItem.createtime).format('yyyy-MM-dd');
                            var resourceid = sourceItem.id;
                            var score = Math.round(sourceItem.statistics.score / 20);
                            _relatedRecommendItem = relatedRecommendItem.replace("{sourceName}", itemName)
                                .replace("{sourceNametitle}", itemName)
                                .replace("{score}", score)
                                .replace("{scoreT}", score)
                                .replace("{sourceLength}", itemLength)
                                .replace("{browseNum}", itemViewcount)
                                .replace("{scorecount}", itemScorecount)
                                .replace("{time}", itemCreattime)
                                .replace("{resourceid}", resourceid);
                            //根据文件格式不同加载不同图标
                            switch (extension) {
                                case "ppt":
                                case "pptx":
                                case "pps":
                                case "ppsx":
                                    _relatedRecommendItem = _relatedRecommendItem.replace("{extension}", "img_ppt");
                                    break;
                                case "doc":
                                case "docx":
                                    _relatedRecommendItem = _relatedRecommendItem.replace("{extension}", "img_word");
                                    break;
                                case "jpg":
                                case "jpeg":
                                case "bmp":
                                case "png":
                                case "gif":
                                case "psd":
                                case "gsp":
                                case "gss":
                                    _relatedRecommendItem = _relatedRecommendItem.replace("{extension}", "img_img");
                                    break;
                                case "mp3":
                                case "wma":
                                case "wav":
                                case "ogg":
                                case "ape":
                                case "mid":
                                case "midi":
                                case "tch":
                                    _relatedRecommendItem = _relatedRecommendItem.replace("{extension}", "img_sound");
                                    break;
                                case "rmvb":
                                case "mp4":
                                case "avi":
                                case "wmv":
                                case "asf":
                                case "3gp":
                                case "flv":
                                case "mpg":
                                case "mpeg":
                                case "mpeg4":
                                case "rm":
                                case "mpeg4":
                                case "mov":
                                case "vob":
                                case "mkv":
                                case "m2ts":
                                    _relatedRecommendItem = _relatedRecommendItem.replace("{extension}", "img_movie");
                                    break;
                                case "swf":
                                case "flash":
                                case "flc":
                                case "fla":
                                case "pic":
                                case "gif":
                                case "mov":
                                case "flv":
                                case "mpeg":
                                    _relatedRecommendItem = _relatedRecommendItem.replace("{extension}", "img_swf");
                                    break;
                                default:
                                    _relatedRecommendItem = _relatedRecommendItem.replace("{extension}", "img_default");
                                    break;
                            }
                            _self.controls.relatedRecommendList.append(_relatedRecommendItem);
                        } else {
                            break;
                        }
                    }
                }
                //设置整个详情框可拖动
                $("#resourceContentPage").draggable({handle: ".jxpop-tab"});
            }

            ////显示资源作者
            //_self.controls.resourceAuthorId[0].innerHTML = resultData.creator;
//
//            //显示基本信息
//            _self.controls.extensionTypeId[0].innerHTML = "格式"+resultData.extension;
            //
//            var time1 = new Date(resultData.lastmodify);
//            var time2 = time1.Format("yyyy-MM-dd hh:mm:ss");
//
//            _self.controls.uploadTimeId[0].innerHTML = time2 +"上传";
//
            //显示畅言号资源
            // || resultData.quality == '21'
            if (resultData.productId == "changyanhao") {
                _self.controls.resAuthor.find("a[name=auth_name]").html(resultData.show_author);
                _self.controls.resAuthor.show();
            } else {
                _self.controls.resAuthor.hide();
            }
            if (resultData.statistics) {
                _self.controls.previewCountId[0].innerHTML = resultData.statistics.viewcount;
                _self.controls.downloadCountId[0].innerHTML = resultData.statistics.downloadcount;
                //评分数
                _self.controls.commentsCounts[0].innerHTML = '(' + resultData.statistics.scorecount + '人评分)';
                //显示星星数
                var percent = resultData.statistics.score + "%";
                _self.controls.resourceStarsId.css('width', percent);
            }

            _self.controls.byteCountId[0].innerHTML = (resultData.length / 1024 / 1024).toFixed(1) == 0.0 ? 0.1 + "M" : (resultData.length / 1024 / 1024).toFixed(1) + "M";

            _self.controls.resourceDesId[0].innerHTML = "内容简介：" + resultData.description;
            // _self.controls.resourceDesId[0].setAttribute("title",resultData.description.replace(/^\s+|\s+$/g,""));

            //获取并显示大家印象列表
            var label_listparam = {
                resId: resultData.id
            }
            edcService.Instance().ersp_resource_label_list(label_listparam).done(function (ret) {
                if (ret.code == 0) {
                    var ret = ret.data;
                    _self.renderLabelList(ret);
                }
            });
            //获取并显示用户评论
            var comment_listparam = {
                resourceId: resultData.id,
                page: 1
            }
            _self.getCommentList(comment_listparam).done(function(ret){
                _self.renderComments(ret).done(function(){
                    _self.bindEvents();
                });
            }).fail(function(e){
                _self.bindEvents();
                console.log("获取评论列表失败");
            });
        }

        //根据查看的缩略图下标动态的加载缩略图
        _self.thumbnailDynamic = function () {
            _self.controls.viewThumbsListId.empty();
            var begin = 1;
            var end = 5;
            begin = (_nowGroup - 1) * 5
            end = begin + 5;
            for (var i = begin; i < end; i++) {
                if (_thumbnailArr[i]) {
                    _self.controls.viewThumbsListId.append("<li><img  name='viewThumbsli' src=" + _thumbnailArr[i] + "></li>");//添加子元素
                }
            }
            ;
        };
        //点击小预览图，替换到大预览图
        $(document).on("click", '#viewThumbsListId li', function (e) {
            //这两行是添加样式
            $(this).siblings('.active').removeClass()
            $(this).addClass("active")
            var index = $(this).index();
            _currIndex = (_nowGroup - 1) * 5 + index;
            var src = e.target.src;
            _self.controls.viewThumbsId.attr('src', src);
        });

        //相关推荐资源点击打开 这一块是将recommendresource.js中的代码拷贝过来的，具体参数 @kaiyi  by njfu
        $(document).on("click","li[name=relatedRecommendItem]", function () {
            var resourceid=$(this).attr("resourceid");
            var param={
                id:resourceid,
                autov: true
            }
            //get接口添加平台参数 by njfu
            var res = aboutres.filter(function(el){
                return el.id == resourceid;
            });
            if(res.length > 0){
                if(json.get_platfrom){
                    param.platform = res[0].platForm || "";
                }
            }
            
            edcService.Instance().ersp_resource_get(param).done(function(ret){
                var resource= aboutres.filter(function(el){
                    return el.id==resourceid;
                })[0];
                var ret=ret.data;
                if(ret.data){
                    //下面这几行代码都是为了能够复用showResContentPanel方法而做的数据处理
                    ret.statistics=ret.data.statistics;
                    ret.screenshots=ret.data.screenshot;
                    ret.origin=aboutres;
                    ret.title=ret.data.title;
                    ret.id=ret.data.id;
                    ret.description=ret.data.description;
                    ret.length=ret.data.length;
                    ret.extension=ret.data.extension;
                    ret.previewurl=ret.data.previewurl;
                    ret.platForm=ret.data.platform;
                    ret.creator=ret.data.creator;
                    ret.fileurl=ret.data.fileurl;
                    ret.lastmodify=ret.data.lastmodify;
                    ret.thumburl=ret.data.thumburl;
                    ret.payModel=resource && resource.payModel || 0;
                    ret.exchangeCredit=resource && resource.exchangeCredit || 0;
                }else{
                    ret=aboutres.filter(function(el){
                        return el.id==resourceid;
                    })[0];
                    ret.origin= aboutres;
                }

                _self.showResContentPanel(ret);

            }).fail(function(e){
                //失败处理
                showAlertTips("网络请求失败");
                console.log(e);
            });
        });


        /**
         * 展示大家印象标签列表
         */
        _self.renderLabelList = function (retObj) {
            userId = _ebookContext.getUser().getUid();
//           retObj = [{"labelId":1,"labelName":"内容详实","labelCount":1},{"labelId":2,"labelName":"内容原创","labelCount":1},{"labelId":3,"labelName":"趣味性强","labelCount":0},{"labelId":4,"labelName":"效果美观","labelCount":0},{"labelId":5,"labelName":"互动性强","labelCount":0},{"labelId":6,"labelName":"素材质量一般","labelCount":0},{"labelId":7,"labelName":"不符合教学要求","labelCount":0},{"labelId":8,"labelName":"实用性强","labelCount":0},{"labelId":9,"labelName":"思路新颖","labelCount":0},{"labelId":10,"labelName":"内容非常生动","labelCount":0},{"labelId":11,"labelName":"应用价值不高","labelCount":0}];
            for (var i = 0, len = retObj.data.length; i < len; i++) {
                var lid = retObj.data[i]["labelId"];
                var str = 'span[labelId=' + lid + ']';
                var aDom = _self.controls.userCompressionId.find(str);
                aDom.find('em')[0].innerHTML = retObj.data[i]["labelCount"];
            }
        }


        /**
         *
         * @param uid 增加评论的人
         * @param resouceId 评论资源的id
         * @param content 评论内容
         * @param to_uid 对谁评论，可以为空
         * 2016/9/8 重写 ---by kaiyi
         */
        _self.addOneComment = function (uid, resouceId, content, to_uid, to_comment_id) {
            var defer = $.Deferred();
            var param = {
                "resourceId": resouceId || "", //资源Id
                "uid": uid || "", //用户Id
                "content": content || "", // 评论内容
                "toCommentId": to_comment_id || "", //被评论的评论Id
                "toUid": to_uid || "" //被评论的用户
            };
            edcService.Instance().ersp_resource_comment_add(param).done(function (ret) {
                    if (ret.code == "0") {
                        defer.resolve();
                    } else {
                        defer.reject();
                    }
                }
            )
            return defer.promise();
        }

        /**
         *
         * @param page 评论页
         * @returns {*}
         */
        _self.getComments = function (page) {
            var def = $.Deferred();
            var getComment = _getComment;
            getComment.rid = _self.resultData.id;
            getComment.page = page;
            var url = AppCenterSvcHelper.CYSVC + '&access_token=changyanyun&' + $.param(getComment);
            _shellCmd.getHttpRequest(url).done(function (ret) {
                if (ret) {
                    _resPageControl.init(page, getComment.limit, ret.total);
                    _resPageControl.render();
                    //给页面上评论数赋值--是评分数，而不是评论数
//                    _self.controls.commentsCounts[0].innerHTML = '('+JSON.parse(ret).total +'人评论)';

                    def.resolve(ret);
                } else {
                    def.resolve(ret);
                }

            })
            return def.promise();

        }

        /**
         * 渲染评论
         * @param retObj 获得评论对象
         */
        _self.renderComments = function (retObj) {
            // var deffer = deffer;
            var deffer = $.Deferred();
            var retObj = retObj.data;
            if (_ebookContext.getUser().getName() == AppCfg.defaultuser) {
                _commentTpl = _commentTplNoLogin;
                _otherCommentTpl = _otherCommentTplNoLogin;
            } else {
                _commentTpl = _commentTplLogin;
                _otherCommentTpl = _otherCommentTplLogin;
            }
            var commentTpl;
            _self.controls.commentList.empty();
            //这一段将所有评论用户的id组成一个不重复的数组
            var pre_userid = [];
            var userid = [];
            var hash = {};
            if (retObj.data) {
                for (var i = 0; i < retObj.data.length; i++) {
                    var uid = retObj.data[i].uid;
                    var toUid = retObj.data[i].toUid;
                    if (uid != "") {
                        pre_userid.push(uid);
                    }
                    if (toUid != "") {
                        pre_userid.push(toUid);
                    }
                }
            }
            for (var i = 0, elem; (elem = pre_userid[i]) != null; i++) {
                if (!hash[elem]) {
                    userid.push(elem);
                    hash[elem] = true;
                }
            }

            _self.commentorInfo = retObj;
            var funs = [];
            for(var i = 0;i<userid.length;i++){
                (function(i){
                    funs.push(_self.getUsernameByUid(userid[i]));
                })(i)
            }
            $.when.apply({},funs).done(function(){
                _self.commentorIdname = arguments;
                var retObj = _self.pretreatmentComments(_self.commentorInfo);
                _self.controls.commentList.empty();
                var i = 0, len = retObj.data.length;
                for (i = 0; i < len; i++) {
                    if (!retObj.data[i].toUid || retObj.data[i].toUid == "0") {
                        //没有toUsername，则是一个人的评论
                        commentTpl = _commentTpl;
                        var newDate = new Date();
                        var time = retObj.data[i].ctime;
                        var content = (retObj.data[i].content).replace(/&/g, '&amp;');
                        // 转义"<"
                        content = content.replace(/</g, '&lt;');

                        commentTpl = commentTpl.replace("{commentor}", retObj.data[i].userName)
                            .replace("{commentContent}", (content))
                            .replace("{time}", time)
                            .replace("{uid}", retObj.data[i].uid)
                            .replace("{commentid}", retObj.data[i].toCommentId)
                            .replace("{resourceId}", _self.resultData.id)
                            .replace("{userid}", retObj.data[i].uid)
                            .replace("{to_userid}", retObj.data[i].toUid);
                        _self.controls.commentList.append(commentTpl);

                    } else {
                        commentTpl = _otherCommentTpl;
                        var time = retObj.data[i].ctime;
                        var content = (retObj.data[i].content).replace(/&/g, '&amp;');
                        // 转义"<"
                        content = content.replace(/</g, '&lt;');

                        commentTpl = commentTpl.replace("{subjector}", retObj.data[i].userName)
                            .replace("{objector}", retObj.data[i].touserName)
                            .replace("{commentContent}", (content))
                            .replace("{time}", time)
                            .replace("{uid}", retObj.data[i].uid)
                            .replace("{commentid}", retObj.data[i].comment_id)
                            .replace("{resourceId}", _self.resultData.id)
                            .replace("{userid}", retObj.data[i].uid)
                            .replace("{to_userid}", retObj.data[i].toUid);
                        _self.controls.commentList.append(commentTpl);
                    }
                }
                deffer.resolve();
            });
            // var dtd = $.Deferred();
            // $.when(_self.getUsernames(userid, 0, dtd)).done(
            //     function () {
            //         var retObj = _self.pretreatmentComments(_self.commentorInfo);
            //         _self.controls.commentList.empty();
            //         var i = 0, len = retObj.data.length;
            //         for (i = 0; i < len; i++) {
            //             if (!retObj.data[i].toUid || retObj.data[i].toUid == "0") {
            //                 //没有toUsername，则是一个人的评论
            //                 commentTpl = _commentTpl;
            //                 var newDate = new Date();
            //                 var time = retObj.data[i].ctime;
            //                 var content = (retObj.data[i].content).replace(/&/g, '&amp');
            //                 commentTpl = commentTpl.replace("{commentor}", retObj.data[i].userName)
            //                     .replace("{commentContent}", (content))
            //                     .replace("{time}", time)
            //                     .replace("{uid}", retObj.data[i].uid)
            //                     .replace("{commentid}", retObj.data[i].toCommentId)
            //                     .replace("{resourceId}", _self.resultData.id)
            //                     .replace("{userid}", retObj.data[i].uid)
            //                     .replace("{to_userid}", retObj.data[i].toUid);
            //                 _self.controls.commentList.append(commentTpl);

            //             } else {
            //                 commentTpl = _otherCommentTpl;
            //                 var time = retObj.data[i].ctime;
            //                 var content = (retObj.data[i].content).replace(/&/g, '&amp');
            //                 commentTpl = commentTpl.replace("{subjector}", retObj.data[i].userName)
            //                     .replace("{objector}", retObj.data[i].touserName)
            //                     .replace("{commentContent}", (content))
            //                     .replace("{time}", time)
            //                     .replace("{uid}", retObj.data[i].uid)
            //                     .replace("{commentid}", retObj.data[i].comment_id)
            //                     .replace("{resourceId}", _self.resultData.id)
            //                     .replace("{userid}", retObj.data[i].uid)
            //                     .replace("{to_userid}", retObj.data[i].toUid);
            //                 _self.controls.commentList.append(commentTpl);
            //             }
            //         }
            //         deffer.resolve();
            //     }
            // )
            return deffer.promise();
        };

        //参数是用户id数组，返回用户id+name数组
        _self.getUsernames = function (arr, index, deffer) {
            var userid = arr;
            var index = index;
            var dtd = deffer;
            //如果没有人评论，直接返回
            if (!userid[index]) {
                dtd.resolve();
            } else {
                //有人评论，在第一次创建$deffer对象，依次递归直到最后依次请求接口
                var param = {
                    "key": "id",
                    "value": userid[index]
                };
                edcService.Instance().core_user_get(param).done(function (ret) {
                    var arr, userName, userId;
                    if (ret && ret.code == 0) {
                        var result = ret.data;
                        if (!result) {
                            userName = "未知用户";
                            userId = "0";
                            arr = [{"uid": userId, "userName": userName}];
                        } else {
                            arr = [{"uid": userid[index], "userName": result.userName ? result.userName : "未知用户"}];
                        }
                    } else {
                        arr = [{"uid": userid[index], "userName": "未知用户"}];
                    }
                    var exist_arr = _self.commentorIdname;
                    var is_exist = _self.commentorIdname.filter(function (el) {
                        return el.uid == userid[index];
                    });
                    if (is_exist.length == 0) {
                        _self.commentorIdname = $.merge(exist_arr, arr);
                    }
                    ;
                    index++;
                    _self.getUsernames(userid, index, dtd);
                }).fail(function () {
                    var arr = [{"uid": userid[index], "userName": "未知用户"}];
                    var exist_arr = _self.commentorIdname;
                    var is_exist = _self.commentorIdname.filter(function (el) {
                        return el.uid == userid[index];
                    });
                    if (is_exist.length == 0) {
                        _self.commentorIdname = $.merge(exist_arr, arr);
                    }
                    ;
                    index++;
                    _self.getUsernames(userid, index, dtd)
                });

            }
            return dtd;
        }


        /**
         * 根据uid获取用户名 by njfu 2017-03-07
         * @param uid 
         */
        _self.getUsernameByUid = function(uid){
            var def = jQuery.Deferred();
            //返回值
            var back = {
                uid: uid,
                userName:"" 
            };
            var param = {
                "key": "id",
                "value": uid
            };
            edcService.Instance().core_user_get(param).done(function(ret){
                if(ret && ret.code == 0 && ret.data){
                    back.userName = ret.data.userName || "未知用户";
                    def.resolve(back);
                }else{
                    back.userName ="未知用户";
                    def.resolve(back);
                }
            }).fail(function(){
                back.userName ="未知用户";
                def.resolve(back);
            });
            return def.promise();
        }

        /**
         * 获取评论列表 by njfu 2017-03-07
         * 
         */
        _self.getCommentList = function(param){
            var def = jQuery.Deferred();
            var p = {
                "resourceId": param.resourceId,
                "page": param.page,
                "limit": 100
            };
            edcService.Instance().ersp_resource_comment_list(p).done(function(ret){
                if(ret && ret.code == 0){
                    def.resolve(ret);
                }
            }).fail(function(e){
                def.reject(e);
            });
            return def.promise();
        }

        //预处理评论数据，为评论数据添加用户名称
        _self.pretreatmentComments = function (retObj) {
            var retObj = retObj;
            if (retObj.data) {
                var commentorIdname = _self.commentorIdname;
                for (var i = 0; i < retObj.data.length; i++) {
                    retObj.data[i].userName = "";
                    retObj.data[i].touserName = "";
                }
                for (var i = 0; i < retObj.data.length; i++) {
                    for (var j = 0; j < commentorIdname.length; j++) {
                        if (retObj.data[i].uid == commentorIdname[j].uid) {
                            retObj.data[i].userName = commentorIdname[j].userName;
                        }
                        if (retObj.data[i].toUid == commentorIdname[j].uid) {
                            retObj.data[i].touserName = commentorIdname[j].userName;
                        }
                    }
                }
            }
            return retObj;
        }


        _self.bindEvents = function () {
            _self.controls.commentList.find('a[flag=commentFlag]').click(function () {
                if ($(this).html() == "回复评论") {
                    $(this).html("收起回复");
                    $(this).parent().parent().next().show();
                } else if ($(this).html() == "收起回复") {
                    $(this).html("回复评论");
                    $(this).parent().parent().next().hide();
                }

            });
            _self.controls.commentList.find('a[flag=replyFlag]').click(function () {
                var content = $(this).parent().parent().find('textarea').val();
                if (content) {
                    var uid = _ebookContext.getUser().getUid();
                    var resId = $(this).attr("resId");
                    var to_uid = $(this).attr("myuid");
                    var to_comment_id = $(this).attr("mycommentid");
                    var param = {
                        "resourceId": resId, //资源Id
                        "uid": uid, //用户Id
                        "content": content, // 评论内容
                        "toCommentId": 0, //被评论的评论Id
                        "toUid": to_uid //被评论的用户
                    };
                    edcService.Instance().ersp_resource_comment_add(param).done(function (retObj) {
                        //_self.addOneComment(uid,resId,content,to_uid,to_comment_id).done(function(retObj){
                        if (retObj.data) {
                            //评论成功，刷新评论列表
                            _self.controls.commentArea.val("");
                            var param = {
                                "resourceId": _self.resultData.id,
                                "page": 1
                            };
                            _self.getCommentList(param).done(function(ret){
                                _self.renderComments(ret).done(function(){
                                    _self.bindEvents();
                                });
                            }).fail(function(e){
                                _self.bindEvents();
                                console.log("获取评论列表失败");
                            });
                        } else {
                            console.error('评论失败')
                        }
                    }).fail(function(e){
                        showAlertTips("评论失败");
                    });
                } else {
                    showAlertTips("回复内容不能为空");
                }

            })

            _self.controls.commentList.find('input').bind('input propertychange', function () {
                var len = $(this).val().length;
                if (len > 200) {
                    //答案过长，截断处理
                    $(this).val($(this).val().substr(0, 200));
                    showAlertTips('评论不能超过200字');
                }
            })

            //点击评论者图标链接相应个人主页-------屏蔽2015.9.9
//            _self.controls.commentList.find('a[name=people]').click(function(){
//                var uid = $(this).attr('userid');
////                alert(uid);
//                var url = AppRemoteSvcCfg.SNSMainPage + uid;
//                _shellCmd.openPageOutside(url);
//
//            })
        }

        _self.closeResContentPanel = function () {
            //全局滚轮事件标志
            global_scoll_flag4 = false;
            _self.controls.resourceContentPage.hide();
            $("#resourceContentPage").parent().hide();
            //关闭窗口时将数组清空
            _self.clearData();

        }

        _self.clearData = function () {
            _thumbnailArr = [];
            _currIndex = 0;
            _indexUrl = '';
            _self.controls.commentArea.val("");
            _scoreSucess = false;
            //_self.buttons.btn_addToBook.removeClass().addClass('greenbtn');
            _self._resetStar();
            _self._swithToAddBook();
            _self._resumeLabelUI();
        }

        _self._resumeLabelUI = function () {
            var aDomList = _self.controls.userCompressionId.find('a');
            $(aDomList[0]).removeClass().addClass('yx_btnred');
            $(aDomList[1]).removeClass().addClass('yx_btnorange');
            $(aDomList[2]).removeClass().addClass('yx_btnblue');
            $(aDomList[3]).removeClass().addClass('yx_btngreen');
            $(aDomList[4]).removeClass().addClass('yx_btnred');
            $(aDomList[5]).removeClass().addClass('yx_btnorange');
            $(aDomList[6]).removeClass().addClass('yx_btnblue');
            $(aDomList[7]).removeClass().addClass('yx_btngreen');
            $(aDomList[8]).removeClass().addClass('yx_btnred');
            $(aDomList[9]).removeClass().addClass('yx_btnorange');
            $(aDomList[10]).removeClass().addClass('yx_btnblue');
        }

        _self._resetStar = function () {
            var starsDomList = _self.controls.scoreStarId.find('input');
            $.each(starsDomList, function () {
                $(this).removeClass('star_btn').addClass('star_btngray');
            })

        }

        _self._addDownloadCount = function (id) {
            var defer = $.Deferred();

            //下载完成后还应该给下载数加1.
            var addDownload = _addDownloadCount;
            addDownload.resourceid = id;
//            var url = _scoreUrlBase + $.param(addDownload);
            var url = getPlatFormCfg(_self.resultData.platForm) + "&" + $.param(addDownload);
            _ebookContext.getUser().getDataByUserToken(url).done(function (result) {
                defer.resolve(result);
            })
            return defer.promise();
        }

        /**
         * 拷贝资源文件
         * @param obj
         */
        _self.copyResFile = function (obj) {
            /**
             * 下载完成后将缩率图拷贝至书本页文件夹
             * 从localresource文件夹下的对应id文件夹下的thumbnail文件拷贝至userbook下对应书本页,并且重命名为`资源id.jpg`
             */
            var basePath = _path.trimPosix(Config.binPath);
            var src = basePath + obj.data.rawData.savepath + '/thumbnail.jpg';
            var dest = '';
            if (_self.bookContainer.getPageViewType() === 4) {
                //黑板试图
                dest = _path.trimPosix(_ebookContext.getUser().getUserWBPath()) +
                    '/' + _self.bookContainer.getWbIndex() + '/' + obj.data.id + '.jpg';
            } else {
                dest = _path.trimPosix(_ebookContext.getUser().getUserBookBasePath()) +
                    '/' + _self.bookContainer.bookCode + '/' + _self.bookContainer.getPageIndex() + '/' + obj.data.id + '.jpg';
            }

            _shellCmd.UcopyFile(src, dest);
        }

        _self.onMessageReceived = function (obj) {
            if (obj.evt == 'file_download') {
                if (obj.data.sourcepage == 'resourcecontent') {

                    if (obj.data.progress <= 1) {
                        var pro = (Number(obj.data.progress) * 100).toFixed(0) + "%";
                        console.log(pro);
                        if (pro == "-1%") {
                            tipsDialog({
                                "id": "uploading" + new Date().getTime(),
                                "content": "资源添加失败"
                            });
                            _self.buttons.btn_addToBook.show();
                            _self.controls.resContProBarId.hide();
                            return;
                        } else {
                            //                        $("#"+obj.data.id).find('.book_progress').css('width',pro);
                            _self.controls.resContProBarId.find("i").css('width', pro);
                            $(_self.controls.realBarId[0]).css("margin-top", "-5px");
                            _self.controls.realBarId[0].innerHTML = pro;
                            tipsDialog({
                                "id": "uploading" + new Date().getTime(),
                                "content": "资源添加中......"
                            });
                        }
                    }
                    //下载完成
                    if (obj.data.progress >= 2) {
                        //假刷新下载量+1
                        $("#downloadCountId").html(Number($("#downloadCountId").html()) + 1)
                       // _self.controls.realBarId.css('width', '100%');
                        //资源详情详情框
                        _self.controls.resContProBarId.find("i").css("width", "100%");
                        _self.controls.realBarId[0].innerHTML = '100%';
                        var array = [];
                        var basePath = _path.trimPosix(Config.binPath);
                        array[0] = obj.data.file;
                        var option = {
                            userName: obj.data.rawData.author,
                            userPhoto: "",
                            score: obj.data.rawData.score,
                            uploadTime: obj.data.rawData.uploadTime,
                            resourceId: obj.data.id,
                            fileInfo: obj.data.rawData,
                            timestamp: obj.data.rawData.timestamp,
                            insertToTA: false
                        };

                        var downFile = obj.data.rawData;
                        option.toTPInfo = {
                            userName: obj.extension.userName,
                            bookCode: downFile.bookcode,
                            path: obj.data.file,
                            fileName: downFile.title + "." + downFile.fileExt,
                            unit1: downFile.unit1,
                            unit2: downFile.unit2,
                            unit3: downFile.unit3,
                            unit4: downFile.unit4,
                            uuid: obj.extension.uuid,
                            title: downFile.title,
                            pageCode: '',
                            // position: "",
                            creator: downFile.author,
                            uploader: downFile.uploader,
                            description: downFile.description,
                            widgetId: '',   //书库导入资源时传
                            widgetType: '', //书库导入资源时传
                            resId: downFile.id,
                            fid: downFile.fid,
                            source: downFile.source,
                            resFrom: downFile.resFrom,
                            pageIndex: downFile.pageIndex   //需要在下载之前获取
                        };

                        var pageindex = 1;
                        if(downFile.resFrom == "selected"){
                            var $pageItem = $('.viewdom .pageItem');
                            //考虑下载过程中翻页情况，点击下载时的当前页
                            var currentPageIndex = downFile.pageIndex;
                            var x = Math.abs(downFile.extra.positionX);
                            var y = Math.abs(downFile.extra.positionY);
                            //存放到数据库中位置的格式
                            option.toTPInfo.position = x + ";" + y + ";0;0;";   //x;y;0;0;
                            if(downFile.pageNum != currentPageIndex){
                                pageindex = 2;
                                //资源下载在右页
                                option.toTPInfo.pageIndex += 1;
                            }

                            var opt = $.extend({multiFiles: array,posType:1,downloadPageIndex:downFile._downloadPageIndex}, option);
                            $(document).find("#bubble_"+downFile.id).remove();
                            _this.bookContainer.insertWidgetWithPos(array[0], [x, y], pageindex, opt);
                        } else {
                            _self.bookContainer.insertWidget(array, option);
                        }

                        _self._swithToAddBook();

                        // _self._addDownloadCount(obj.data.id).done(function(ret){
                        //     console.log(ret);
                        // });

                        var downloadCount = {
                            id: obj.data.id
                        };
                        edcService.Instance().ersp_resource_download_inc(downloadCount).done(function (ret) {
                            console.log(ret);
                        }).fail(function () {
                        });

                        /*_self.copyResFile(obj);

                         var downFile=obj.data.rawData;
                         var condition = {
                         "filename" : downFile.title,
                         "unit1" : downFile.unit1,
                         "unit2" : downFile.unit2,
                         "unit3" : downFile.unit3,
                         "unit4" : downFile.unit4,
                         "timestamp" : downFile.timestamp,
                         "fileid" : downFile.id,
                         "type" : downFile.fileExt,
                         "bookcode" : downFile.bookcode,
                         "filepath" : downFile.title + '.' + downFile.fileExt,
                         "filesavepath":downFile.savepath,
                         "lasttime" : downFile.lasttime,
                         "creator": downFile.author,
                         "size": downFile.fileSize
                         };
                         // condition.filepath = condition.filename + '.' + downFile.fileExt;
                         var localBookPath,localThumbnail;
                         localBookPath =_path.trimPosix(_ebookContext.getUser().getUserBookBasePath()) +
                         '/' + _self.bookContainer.bookCode + '/' + _self.bookContainer.getPageIndex()+ '/' +condition.filepath;
                         // localBookPath=localBookPath.replace(/\//g, "\\");
                         //写备课本的本地文件目录和数据库
                         _pptIcwsAccessor.addInfoWithCopyFile(condition,localBookPath).done(function(ret){
                         console.log("success");
                         }).fail(function(e){
                         console.log("写数据库失败");
                         });
                         */
                        /* tipsDialog({
                         "id": "uploading" + new Date().getTime(),
                         "content": "资源添加成功"
                         });*/
                    }
                }
                else if (obj.data.sourcepage == 'resourcecontentsave') {
                    //下载完成
                    if (obj.data.progress >= 2) {
                        _self._addDownloadCount(obj.data.id).done(function (ret) {
                            console.log(ret);
                        });
                    }
                }
            }
        }


    }

    ResContent.prototype = new _cloudresourceBase();
    exports.Instance = new ResContent();
})
