define(function(require, exports, module){
    require('jquery');
    var _resAccessor = require('./resaccessor').Instance,
        _pptIcwsAccessor = require('./ppticwsaccessor').Instance,
        _teachingPackage = require('./teachingpackage').Instance,
        _resTool = require('./restool'),
        _searchPanel = require('./search').Instance,
        _defaultDefine = require('../../define'),
        _ebookContext = require('../../ebookcontext').Instance,
        _shellcmd = require('../../../common/shellcmd'),
        _path = require('../../../common/path'),
        _cloudresourceBase = require('./cloudresourcebase'),
        _mainToolbar = require('../toolbar/maintoolbar'),
        _sideToolbar = require('../toolbar/sidetoolbar'),
        _canvasManager = require('../../paint/canvasmgr').Instance,
        shellcmd = require('../../../common/shellcmd'),
        _recommendResUrl = AppCenterSvcCfg.ResBatch,
        _editionRqstUrl = AppSvcHelper.CYSVC + '&',
        _recommendRes = require('./recommendresource').Instance,
        _preparereRes = require('./prepareresource').Instance,
        _selectedRes = require('./selectedresource').Instance,
        _synRes = require('../smartbar/synchronizeresource').Instance,
        _pdfbook =require('../pdf/pdfbook').Instance,
        _localResMgr = require('../toolbar/localres').Instance,
        curtainmgr = require('../curtainmgr').Instance,
        path = require('../../../common/path'),
        fs = nodereq("fs");
    //资源分类名称
    var _resType={
        "0100": "教案",
        "0300": "素材",
        "0400": "习题",
        "0600": "课件",
        "1901": "微课",
        "2015": "导学案"
    }
    //按照此序列进行排序
    var _resTypeArr=[
        "0600",//课件
        "0100",//教案
        "2015",//导学案
        "1901",//微课
        "0400",//习题
        "0300" //素材
    ];

    function ResBar(){
        var _this = this;
        _this.bookContainer = null;
    }
    ResBar.prototype = new _cloudresourceBase();

    //初始化
    ResBar.prototype.init = function(bookContainer){
        var _this = this;
        _this.editStatus = false;
        _this.bookContainer = bookContainer;
        _this.bookContainWidth = '';

        _this.smartBarEle = $('#smartbar');
        _this.smartBarPop = $('#smartbar_pop');
        _this.smartBarTool = $('#smartbar_tool');
        _this.smartBarTitle = _this.smartBarEle.find("div[name=title_click]");
        _this.smartBarContent = _this.smartBarEle.find('.resource_tool_cont2');

        _this.buttons = {
            selectedBtn: $("#J_selected"),
            recommmendBtn: $("#J_recommend"),
            lessonPrepareBtn: $("#J_lessonprepare"),
            localPrepareBtn: $("#J_localprepare"),
            cloudPrepareBtn: $("#J_cloudprepare"),
            recommendArrowBtn: $("#J_recommend_arrow")
        };
        _this.controls = {
            tabBar: $(".J_resource_center_bar .tabbar"),
            selectedContainer: $(".J_selected_content"),
            recommmendContainer: $(".J_recommend_content"),
            lessonPrepareContainer: $(".J_lesssonprepare_content"),
            localPrepareContainer: $(".J_localprepare_content"),
            cloudPrepareContainer: $(".J_cloudprepare_content"),
            recommendDropBox: $(".J_recommend_submenu")
        };

        var bookContainerWidth = bookContainer.getContent().width(),
            smartBarWidth = _this.smartBarEle.width(),
            left = ((bookContainerWidth - smartBarWidth) / 2).toFixed(2),
            height = _this.smartBarTitle.height() + _this.smartBarContent.height();
        this.bookContainWidth = bookContainerWidth;
        _this.smartBarEle
            .css("left", "0px")
            .data("realHeight", height);
        //当前标签页，分类推荐
        // _this.currLable = 'recommend';
        _this.currLable = 'selected';
        //刷新区域
        _this.refreshArea = {
            // label:type
            "all":["selected","recommend","localLessonPrepare","cloudLessonPrepares","teachingPackage"],
            "selected":"selected",
            "recommend":"recommend",
            "lesssonPrepare":["localLessonPrepare","cloudLessonPrepares"],
            "localLessonPrepare":"localLessonPrepare",
            "cloudLessonPrepares":"cloudLessonPrepares",
            "teachingPackage":"teachingPackage"
        };
        //备课本展示到页面的数据
        _this.lesssonPrepares = {
            "local":{
                total:0,
                origin:[],
                data:[]
            },
            "cloud":{
                total:0,
                origin:[],
                data:[]
            },
        }
        _this.bookContainer = bookContainer;
        //设置上课状态
        _this.setIsHavingClass(false);
        _this.registerEvent();
        //初始化同步精选
        _selectedRes.init(bookContainer, _this.smartBarEle);
        //初始化推荐资源
        _recommendRes.init(bookContainer, _this.smartBarEle);
        //初始化备课本
        _preparereRes.init(bookContainer);
        setGlobalContextPrepareSource(_preparereRes);
        //初始化授课包
        _teachingPackage.init(bookContainer);
        localStorage.removeItem("recommend_download");
        //初始化同步资源
        _synRes.init(bookContainer, _this.smartBarEle);
        //初始化备课本资源
        _pptIcwsAccessor.init(_ebookContext.getUser());
        //初始化云资源搜索
        _searchPanel.init(bookContainer);
        //初始化dpf类
        _pdfbook.init(bookContainer);
        _this.refreshbyLabel("all");
        
        // 显示云资源 王哒哒
        _this.buttons.recommmendBtn.trigger("click")
    };

    /**
     * SmartBar事件绑定
     */
    ResBar.prototype.registerEvent = function () {
        var _this = this,
            resourceList = _this.smartBarContent.find('.resource_tool_cont_box'),
            left = parseInt(_this.smartBarEle.css("left").replace(/px/gi, "")),
            bottom, width;

        //鼠标划入资源栏，锁定全局滚动 资源中心工具栏,上课模式授课包
        //注意：这里绑定的是左侧区域，如果在这个区域做了滚动限制，则会被mouseout方法重置。
        $("#wrap").on("mouseover",".J_leftbar,.drawer-left,.J_teacking_package_left_content,.J_teacking_package_right_content",function(){
            global_scoll_flag4 = true;
        });
        $("#wrap").on("mouseout",".J_leftbar,.drawer-left,.J_teacking_package_left_content,.J_teacking_package_right_content",function(){
            global_scoll_flag4 = false;
        });

        //smartBar拖动移位
        $("#smartbar").draggable({
            disabled: false,
            handle: _this.smartBarTitle,
            containment: 'parent',
            distance: 30,
            helper: 'clone',
            //opacity: 0.5,
            iframeFix: true,
            start: function (event, ui) {
                $("#editorflagbottom").hide();
                $("#editorflagtop").hide();
                $("#smartbar_pop").remove();
                $("#smartbar_tool").hide();
                $('#pluginpanel').hide();
                _this.showStatus.tool = false;
            },
            stop: function (event, ui) {

                if ($("#smartbar").attr("flag") == "top") {
                    $("#smartbar").attr("flag", "bottom");
                    $("#top_tit").hide();
                    $("#bottom_tit").show();

                    $("#smartbar").css("top", "0px");
                    $("#smartbar").css("bottom", "");
//                    $("#smartbar").css("-webkit-transform", "");
                } else {
                    $("#smartbar").css("top", "");
                    $("#smartbar").css("bottom", "0px");
                    $("#top_tit").show();
                    $("#bottom_tit").hide();


                    $("#smartbar").attr("flag", "top");
//                    $("#smartbar").css("-webkit-transform", "rotate(180deg)");
                }
            }
        });

        //在线搜索中的本地打开FileDialog
        $("#openFileDialog").on("mouseup", function () {
            // _this.resetSmartBarEle(null);
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'02002',
                type:'trigger'
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            $("#closeAddSource").trigger("click");
            setTimeout(_this.openFileDialog.call(_this, this), 0);
        });



        //打开tool
        $("#newCreate").on("click", function () {
            bottom = $("#smartbar").find(".resource_tool_cont2").css("height");
            width = $(this).parent().width();
            left = left - width;
            _this.resetSmartBarEle('tool');
            if (_this.showStatus.tool) {
                if ($("#smartbar").attr("flag") == "top") {
                    _this.smartBarTool.removeClass('new_pop_up').addClass('new_pop');
                    _this.smartBarTool.find('.new_pop_con_up').removeClass('new_pop_con_up').addClass('new_pop_con');
                    _this.smartBarTool.css({
                        left: _this.bookContainWidth - 125,
                        bottom: bottom,
                        top: "",
                        display: 'block',
                        position: "absolute",
                        "z-index": 550
                    });
                } else {
                    _this.smartBarTool.removeClass('new_pop').addClass('new_pop_up');
                    _this.smartBarTool.find('.new_pop_con').removeClass('new_pop_con').addClass('new_pop_con_up');
                    _this.smartBarTool.css({
                        left: _this.bookContainWidth - 125,
                        bottom: "",
                        top: bottom,
                        display: 'block',
                        position: "absolute",
                        "z-index": 550
                    });
                }
            }
        });
        //绑定tool事件
        $(document).on("click","#smartbar_btnAudio" ,function () {
            // _this.resetSmartBarEle('tool_li');
            var self = this;
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'02001',
                type:'trigger',
                cardId:$(this).attr('id')
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            // if ($(self).index() == 0) {
            shellcmd.shellexecutewithargs(Config.binPath + 'audio/AudioEditTool.exe');
            // }
            //关闭添加资源弹窗
            $("#closeAddSource").trigger("click");

        });


        //刷新授课本
        $("#J_teaching_package").on("click",function(e){
            $(".user-popover").hide();
            $("#smartbar_pop").remove();
            _canvasManager.setIsEditing(true );
            _this.bookContainer.setIsEditing(true);
            _this.setCurrLabel(""); //重置默认页面，默认会一直刷新授课包
            // _this.refreshbyLabel("teachingPackage");
            _this.refresh(_this.refreshArea["teachingPackage"]);

        });

        //资源中心
        $("#J_res_center").click(function(){
            $(".user-popover").hide();
            $("#smartbar_pop").remove();
            _canvasManager.setIsEditing(true);
            _this.bookContainer.setIsEditing(true);
            _this.refreshbyLabel("lesssonPrepare");
        });
        /*

         $("#J_having_class").click(function () {
         _canvasManager.setIsEditing(false );
         _this.bookContainer.setIsEditing(false);
         });
         $("#J_after_class").click(function () {
         _canvasManager.setIsEditing(true);
         _this.bookContainer.setIsEditing(true);
         $("a[name=deletefile]").hide();//隐藏弹框中的删除按钮
         });
         */


        //添加资源
        $("#addSourceBtn").on("click",function(){

            // 王哒哒修改
            var staticParams = {
                uid: _ebookContext._curUser._uid,
                module: '02002',
                type: 'trigger'
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            // $("#closeAddSource").trigger("click");
            setTimeout(_this.openFileDialog.call(_this, this), 0);

            // $(".user-popover").hide();
            // $("#smartbar_pop").remove();
            // $("#onlineSearchContainer").css("display","none");
            // $("#addSourceContainer").css("display","block");
            // $("#addSourceContainer").parent().show();
            // //绑定滚轮事件
            // global_scoll_flag = true;

            // //设置样式 - 相对于课本内容居中
            // var setedHeight = 480;
            // var fixLeft = $(".J_leftbar").width() || 0;
            // var fixTop = 30; //页面顶部
            // var setedLeft = ($("#bookwarp").width() - $("#addSourceContainer").outerWidth()) / 2;
            // var setedTop = ($("#bookwarp").height() - setedHeight) / 2;
            // var xpos = (parseFloat(setedLeft) + parseFloat(fixLeft)) + 'px';
            // var ypos = (parseFloat(setedTop) + parseFloat(fixTop)) + 'px';

            // var exportPanel = $(document).find("#addSourceContainer");
            // exportPanel.css({  //设置位置
            //     position: 'absolute',
            //     left: xpos,
            //     top: ypos
            // }).draggable({               //设置可拖动
            //     containment: $("#bookContainer"),
            //     handle: ".jxpop-tab"
            // });
        });

        //去资源中心
        //去资源中心
        $("#goSourceCenter").click(function(){
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'02003',
                type:'trigger'
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            $("#addSourceContainer").hide();
            $("#addSourceContainer").parent().hide();
            $("#J_res_center").trigger("click");
        })

        $("#closeAddSource").click(function(){
            //绑定滚轮事件
            global_scoll_flag = false;
            $("#addSourceContainer").hide();
            $("#addSourceContainer").parent().hide();
        });

        //点击同步精选按钮
        _this.buttons.selectedBtn.click(function () {
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'01001',
                type:'trigger',
                bookCode:_ebookContext.curBookCode
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);

            $(".user-popover").hide();
            $("#smartbar_pop").remove();
            //_this.setSelectedTab(_this.buttons.selectedBtn, "btn-tabactive");
            _this.buttons.selectedBtn.addClass("btn-tabactive");
            _this.buttons.recommmendBtn.parent().removeClass("tab_active");
            _this.controls.recommendDropBox.hide();

            _this.setCurrLabel("selected");
            $(".rescontent").hide();
            _this.controls.selectedContainer.show();

            _this.refreshbyLabel("selected");
            event.stopPropagation();
        });
        //点击推荐(云推荐/校本/央馆)按钮
        _this.buttons.recommmendBtn.click(function () {
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'01002',
                type:'trigger',
                bookCode:_ebookContext.curBookCode
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);

            $(".user-popover").hide();
            $("#smartbar_pop").remove();
            _this.controls.recommmendContainer.find(".format-checkbox").hide();
            //_this.setSelectedTab(_this.buttons.recommmendBtn, "btn-tabactive");
            _this.buttons.recommmendBtn.parent().addClass("tab_active");
            _this.buttons.selectedBtn.removeClass("btn-tabactive");
            //隐藏下拉框
            _this.controls.recommendDropBox.hide();

            _this.setCurrLabel("recommend");
            $(".rescontent").hide();
            _this.controls.recommmendContainer.show();
            _this.refreshbyLabel("recommend");
            // event.stopPropagation();
        });
        //点击下拉菜单
        $(document).on("click", "#J_recommend_arrow", function () {
            //显示/隐藏下拉框
            _this.controls.recommendDropBox.toggle();
            //判断如果有"新"角标，点击下拉框隐藏，同时将新的频道写入服务器数据库
            if ($("#J_leftToolbar_tabtips_new").css("display") != "none"){
                $("#J_leftToolbar_tabtips_new").hide();
                //更新用户资源频道
                ResBar.prototype.updateUserChannel();
            }
        });
        //选择分类推荐下拉菜单选项
        $(document).on("click", ".J_recommend_cloud, .J_recommend_yg, .J_recommend_xb", function () {
            $(this).addClass("li_selected");
            $(this).siblings().removeClass("li_selected");
            /*//判断选择的频道与当前是否相同 不相同：清空列表并加上遮罩
            if (_this.buttons.recommmendBtn.attr("content") != $(this).attr("content")){
                _this.controls.recommmendContainer.find(".J_show").hide();//隐藏下方按钮
                _this.controls.recommmendContainer.find("#recommendList").html("");//清空列表
                var info = {
                    "status": "resource_loading",
                    "tips": "数据加载中...",
                    "from": "rescontent"
                };
                _this.renderResStatus(_this.controls.recommmendContainer.find("#recommendList"), info);
            }*/
            _this.buttons.recommmendBtn.html($(this).html());
            _this.buttons.recommmendBtn.attr("content", $(this).attr("content"));
            _this.controls.recommendDropBox.hide();
            _this.buttons.recommmendBtn.trigger("click");
            return false;
        });
        //点击资源列表、搜索框    隐藏下拉框
        $(".J_recommend_content, .J_selected_content, #searchBtn").mousedown(function () {
            _this.controls.recommendDropBox.hide();
        });
        _this.buttons.lessonPrepareBtn.click(function (event) {
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'01003',
                type:'trigger',
                bookCode:_ebookContext.curBookCode
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);

            $(".user-popover").hide();
            $("#smartbar_pop").remove();
            _this.setCurrLabel("cloudLessonPrepares");
            //进入云备课本模式
            _this.setSelectedTab(_this.buttons.cloudPrepareBtn,"empty-active");

            //设置弹窗遮盖层
            var overlay = $('<div class="prepareDialogOverlay"></div>');
            overlay.css({
                "position":"fixed",
                "left":"0px",
                "top":"0px",
                "opacity":"0",
                "background": "#eee",
                "z-index": "100",
                "width": "100%",
                "height": "100%"
            });

            //设置样式 - 相对于课本内容居中
            var setedHeight = 508;
            var fixLeft = $(".J_leftbar").width() || 0;
            var fixTop = 30; //页面顶部
            var setedLeft = ($("#bookwarp").width() - _this.controls.lessonPrepareContainer.outerWidth()) / 2;
            var setedTop = ($("#bookwarp").height() - setedHeight) / 2;
            _this.controls.lessonPrepareContainer.css('left', (parseFloat(setedLeft) + parseFloat(fixLeft)) + 'px');
            _this.controls.lessonPrepareContainer.css('top', (parseFloat(setedTop) + parseFloat(fixTop)) + 'px');
            _this.controls.lessonPrepareContainer.css('z-index', '150');

            //设置可拖动
            _this.controls.lessonPrepareContainer.draggable({
                cursor: "move",
                containment: $("#bookContainer"),
                handle: ".jxpop-tab"
            });
            //绑定事件
            $(_this.controls.lessonPrepareContainer).on("click","a[name='close']",function () {
                //绑定滚轮事件
                window.global_scoll_flag = false;
                _this.controls.lessonPrepareContainer.hide();
                overlay.remove();
            });

            $("body").append(overlay);
            _this.refreshbyLabel("cloudLessonPrepares");
            //关闭卡片弹窗
            $("#closeAddSource").trigger("click");
            _this.controls.lessonPrepareContainer.show();
            _this.controls.cloudPrepareContainer.show();
            _this.controls.localPrepareContainer.hide();
            //绑定滚轮事件
            window.global_scoll_flag = true;
            event.stopPropagation();
        });
        _this.buttons.localPrepareBtn.click(function () {
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'01003',
                type:'trigger',
                bookCode:_ebookContext.curBookCode
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            _this.setSelectedTab(_this.buttons.localPrepareBtn,"empty-active");
            _this.setCurrLabel("localLessonPrepare");
            _this.controls.cloudPrepareContainer.hide();
            _this.controls.localPrepareContainer.show();
            _this.refreshbyLabel("localLessonPrepare");
            event.stopPropagation();
        });
        _this.buttons.cloudPrepareBtn.click(function () {
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'01012',
                type:'trigger',
                bookCode:_ebookContext.curBookCode
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            _this.setSelectedTab(_this.buttons.cloudPrepareBtn,"empty-active");
            _this.setCurrLabel("cloudLessonPrepares");
            _this.controls.localPrepareContainer.hide();
            _this.controls.cloudPrepareContainer.show();
            _this.refreshbyLabel("cloudLessonPrepares");
            event.stopPropagation();
        });
    };

    ResBar.prototype.setSelectedTab = function($dom,className){
        var _this = this;
        $($dom).siblings().removeClass(className);
        $($dom).addClass(className);
    };

    //设置是否上课状态 true-上课 false-下课 //初始化设置
    ResBar.prototype.setIsHavingClass = function (status) {
        var _this = this;
        var editStatus = status;

        //设置主工具栏上课状态
        _mainToolbar.setIsHavingClass(editStatus);
    };




    //刷新资源信息
    ResBar.prototype.refresh = function(refreshType){
        var _this = this;
        if(typeof(refreshType) == "string") {
            refreshType = refreshType.split(",") || [];
        };

        var i = 0,
            length = refreshType.length;
        for(; i < length; i++) {
            if (refreshType[i] == "selected") {
                _selectedRes.getSelectedRes();
            }
            if (refreshType[i] == "recommend") {
                _recommendRes.getRecommend();
            }
            if (refreshType[i] == "localLessonPrepare") {
                _preparereRes.getLocalLessonPrepares();
            }
            if (refreshType[i] == "cloudLessonPrepares") {
                _preparereRes.getEdcCloudLessonPrepares();
            }
            if (refreshType[i] == "teachingPackage") {
                _teachingPackage.getWidgets();
            }
        }
    };

    //刷新指定位置资源
    ResBar.prototype.refreshbyLabel = function(label){
        var _this = this;
        //|| typeof (_this.refreshArea[_this.currLable]) == "undefined"
        if(typeof (label) == "undefined") {
            label = "all";
        }
        if(_this.getCurrLabel() != ""){
            label = _this.getCurrLabel();
        }
        //刷新授课包(这里公用，总是刷新授课包)
        _this.refresh(_this.refreshArea["teachingPackage"]);
        _this.refresh(_this.refreshArea[label]);
    };

    //设置当前标签页
    ResBar.prototype.setCurrLabel = function(label){
        var _this = this;
        _this.currLable = label;
        //alert(label);
    };

    //取得当前标签页
    ResBar.prototype.getCurrLabel = function(){
        var _this = this;
        return _this.currLable;
    };

    //当前页面属性
    ResBar.prototype.getPageMeta = function(){
        var _this = this;
        var pageMeta =_this.bookContainer.getCurrPageMetadata();
        return pageMeta;
    };

    //添加本地资源
    ResBar.prototype.openFileDialog = function (ele) {

        //设置打开文件为可编辑状态
        var _this=this;
        // _this.isEditing=true;
        //  _this.openSmartBar();
        //   _this.setIsEditing(_this.isEditing);

        var domEle = ele;
        return function () {
            var extFilter = _defaultDefine.extFilter;
            var ret = "", index = 0, type = extFilter.type;
            var calcFilter = function (arr) {
                var extArr = "";
                var args = arguments;
                if (arr instanceof  Array) {
                    for (var k = 0; k < arr.length; ++k) {
                        extArr += '*' + arr[k] + ';';
                    }
                }
                else if (arr instanceof Object) {
                    $.each(arr, function (i, e) {
                        extArr += args.callee(e);
                    });
                }
                return extArr;
            };

            $.each(extFilter.array, function (i, e) {
                var extArr = calcFilter(e);
                ret += type[index] + "|" + extArr + ";|";
                ++index;
            });

            /// 使用新的opendialog 方法
            ret = { "multi": true, "ext": []};
            _shellcmd.openFileDialog(ret).done(
                function (result) {
                    var mtbkFile = [];
                    result = result.filter(function(el){
                        var parseFileName = _resTool.parseFileName(el);
                        var fileExt = parseFileName.fileExt;
                        if(fileExt.toLowerCase() == 'mtbk'){
                            mtbkFile.push(el);
                            return false;
                        }else{
                            return true;
                        }
                    });
                    if (result) {
                        var _userName = decodeURI(_ebookContext.getUser()._userName) || _ebookContext.getUser()._name;
                        var pageMeta = _this.getCurrPageMetadata();
                        var bookMeta = _this.getBookMetaInfo();
                        // //清空写入TA数据库的队列
                        // $(document).clearQueue("writeTaPreparebookDb");
                        // //清空写入IFB数据库的队列
                        // $(document).clearQueue("writeIfbDb");
                        for(var i=0;i<result.length;i++){
                            var timestamp = new Date().Format("yyyyMMddhhmmssS");
                            var parseFileName = _resTool.parseFileName(result[i]);
                            var file = parseFileName.file;
                            var fileName = parseFileName.fileName;
                            var fileExt = parseFileName.fileExt;
                            var size = fs.statSync(result[i]).size;
                            var uuid = _pptIcwsAccessor.createUuid();
                            var condition = {
                                "filename" : fileName,
                                "unit1" : pageMeta.unit1,
                                "unit2" : pageMeta.unit2,
                                "unit3" : pageMeta.unit3,
                                "unit4" : pageMeta.unit4,
                                "timestamp" : timestamp,
                                "fileid" : uuid ,
                                "type" : fileExt,
                                "bookcode" : bookMeta.bookCode,
                                "filepath" : fileName+"."+fileExt,
                                "lasttime" : new Date().Format("yyyy-MM-dd hh:mm:ss"),
                                "creator": _ebookContext.getUser().getUserName(),
                                "size": size
                            };
                            var conditionForIfb={
                                "title":fileName,
                                "id" :uuid,
                                "file":"",
                                "source":"local",
                                "grade" :"",
                                "subject" :"",
                                "unit" :"",
                                "bookCode"  :bookMeta.bookCode,
                                "extension"  :fileExt,
                                "downloadDate":new Date().Format("yyyy-MM-dd hh:mm:ss")
                            };
                            // //写入TA数据库，拷贝文件到TA目录下
                            // _this.writeTaDb(condition,result[i]);
                            // //写入IFB数据库
                            // _this.writeIfbDb(conditionForIfb);
                            //带后缀
                            var fileFullName=result[i].substring(result[0].lastIndexOf("\\")+1);
                            var fileName=fileFullName.substring(0,fileFullName.indexOf("."));
                            var fileExt=fileFullName.substring(fileFullName.indexOf(".")+1);
                            //插入书本
                            var fileInfo={
                                fileName:fileName,
                                fileSize:"12312",
                                lasttime:new Date().Format("yyyy-MM-dd hh:mm:ss"),
                                timestamp:timestamp,
                                fileid:uuid,
                                fileExt:fileExt,
                                resFrom:"local",
                                description:""
                            }
                            var widgets = _this.bookContainer.getCurrentPageRes();
                            _this.bookContainer.insertWidget([result[i]], {
                                userName: _userName,
                                resourceId:condition.fileid,
                                timestamp:timestamp,
                                userName:condition.creator,
                                fileInfo:fileInfo,
                                posType:2,

                            });
                            tipsDialog({
                                "id": "uploading" + new Date().getTime(),
                                "content": "资源添加中..."
                            });
                        };

                        // setTimeout(function(){
                        //     $(document).dequeue("writeTaPreparebookDb");
                        //     $(document).dequeue("writeIfbDb");
                        //     //资源添加成功提示，（资源添加暂时没有成功或者失败反馈（@王瑞 这部分要处理），暂时只能统一给予提示）
                        //     tipsDialog({
                        //         "id": "uploading" + new Date().getTime(),
                        //         "content": "资源添加成功"
                        //     });
                        // },100);

                        $(domEle).removeClass('current');

                        //监管
                        var action = LogManager.action.trigger;
                        var params = {};
                        params.module = '1130306';
                        var user_id = _ebookContext.getUser().getUid();
                        if(user_id != '0' && user_id){
                            params.user_id =user_id;
                        }
                        LogManager.statistics(action,params);
                    }

                    if(mtbkFile.length > 0){
                        tipsDialog({
                            "id": "uploading" + new Date().getTime(),
                            "content": "不支持导入授课包文件（.mtbk）..."
                        });
                    }
                });
        };
    };
    ResBar.prototype.writeTaDb = function (condition,filePath){
        $(document).queue("writeTaPreparebookDb",function(){
            //写备课本本地资源数据库
            _pptIcwsAccessor.addInfoWithCopyFile(condition,filePath).done(function(ret){
                console.log("写TA备课本数据库成功");
                $(document).dequeue("writeTaPreparebookDb");
            }).fail(function(e){
                console.log("写TA备课本数据库失败");
                $(document).dequeue("writeTaPreparebookDb");
            });
        });
    };
    ResBar.prototype.writeIfbDb = function (condition){
        $(document).queue("writeIfbDb",function(){
            //写入ifb数据库
            var ifbDbpath=Config.binPath+"users/"+_ebookContext._curUser._name+"/userdb.db";
            // var ifbDbpath="D:/workspace/EPD_TA5.0(GIT)/TA/plugins/62/bin/users/User1471614971096/userdb.db";
            if(ifbDbpath.indexOf("file:///")!=-1){
                ifbDbpath=ifbDbpath.substring(8);
            };
            var sqlite3 = nodereq('sqlite3').verbose();
            var db = new sqlite3.Database(ifbDbpath);
            var sql = 'insert into Resources(title,id,file,source,grade,' +
                'subject,unit,bookCode,' +
                'extension,downloadDate) values("'
                + condition.title + '","'
                + condition.id + '","'
                + condition.file+ '","'
                + condition.source+'","'
                + condition.grade +'","'
                + condition.subject +'","'
                + condition.unit +'","'
                + condition.bookCode  +'","'
                + condition.extension  +'","'
                + condition.downloadDate + '")';
            db.exec(sql, function (err, rows) {
                if(err){
                    console.log("写IFB数据库失败");
                }else{
                    console.log("写IFB数据库成功");
                };
                $(document).dequeue("writeIfbDb");
                db.close();
            });
        });
    };

    ResBar.prototype.updateUserChannel = function () {
        var channelStr = "";
        var uid = _ebookContext.getUser().getUid();
        //遍历下拉列表中频道
        $(".J_recommend_submenu li").each(function () {
            channelStr = channelStr + $(this).attr("content") + ",";
        });
        channelStr = channelStr.substring(0, channelStr.length - 1);
        var url_update = AppRemoteSvcCfg.userChannelInsertOrUpdateUrl;
        // var url_update = "http://localhost:8090/taUser/insertOrUpdateUserChannel";
        shellcmd.getHttpRequestJSON(url_update, {"userId":uid, "channel":channelStr}).done(function (ret) {
            if (ret && ret.code == 1){
                console.log("更新用户频道成功");
            } else {
                console.log("更新用户频道失败");
            }
        });
    };

    //绘制页面
    ResBar.prototype.render = function(){
        var _this = this;
    };

    exports.Instance = new ResBar();
    exports.ResBar = ResBar;
});
