define(function (require, exports) {
    var _define = require('../../define'),
        _resAccessor = require('./resaccessor').Instance,
        _cloudresourceBase = require('./cloudresourcebase'),
        _recommendResUrl = AppRemoteSvcCfg.ResBatch,
        _ebookContext = require('../../ebookcontext').Instance,
        _mainToolbar = require('../toolbar/maintoolbar'),
        path = require('../../../common/path'),
        _resourceContentPage = require('./resourcecontent').Instance,
        shellcmd = require('../../../common/shellcmd'),
        prepareresource = require('./prepareresource').Instance;

    //资源分类名称
    var _resType={
        "0100": "教案",
        "0300": "素材",
        "0400": "习题",
        "0600": "课件",
        "1901": "微课",
        "2015": "导学案"
    }
    //按照此序列进行排序
    var _resTypeArr=[
        "0600",//课件
        "0100",//教案
        "2015",//导学案
        "1901",//微课
        "0400",//习题
        "0300" //素材
    ];
    //中心用户appName
    var _default_appName = "cyyun";
    //频道：云推荐/校本/央馆
    var channel = "yun";

    function recommendresource(){
        var _this = this;

        _this.buttons = {};
        _this.controls = {};
        _this.bookContainer = "";
        _this.smartBarContent="";
        //以下为初始化参数，实际参数会覆盖初始化参数
        _this.request = {
            subject: "",            //学科
            grade: "",              //年级
            publisher: "",          //出版社
            edition: "",            //教材版本
            phase: "",              //学段
            stage: "",              //年级册别
            quality: "",          // 20-普通资源 21-精品资源
            topic: "08",          // 08 - 同步资源
            book: "",               //书本
            thumbsize: "",   //图片大小
            unit1:"",                //目录1
            unit2:"",                //目录2
            unit3:"",                //目录3
            unit4:"",                //目录4
            order: "",              //排序
            type: "",               //资源类型
            volume:"", //册别，这里字段名称为 volume ，程序里用volumn，两者含义一致。
            q: "",                  //关键词
            page: 1,
            extension: "",          //指定后缀文件筛选
            sortField: "downloadCount",          //指定下载筛选字段
            sortType: "desc",          //指定下载筛选字段
            source: "IFLYTEK,UGC,MAISUI,XIAOBENZIYUAN,ZHONGBAO,RENJIAOJIAOFU,KXX,GUOJIA,CHANGYAN",//指定下载筛选字段
            limit: "500"
        };
        _this.recommendList = {
            origin: [],
            data: [],
            data_origin: [],
            total: 0,
            payable_source:[],
            totaldemand_score:0
        };
        _this.showStatus = {
            netdisk: false,
            search: false,
            tool: false,
            syn: false,
            resource: []
        };

    }
    recommendresource.prototype = new _cloudresourceBase();
    /**
     * 初始化
     * @param bookContainer
     */
    recommendresource.prototype.init = function(bookContainer,smartBarEle){
        var _this = this;
        _this.bookContainer = bookContainer;
        _this.smartBarEle = smartBarEle;
        _this.smartBarPop = $('#smartbar_pop');
        _this.smartBarTool = $('#smartbar_tool');
        _this.smartBarTitle = _this.smartBarEle.find('.new_pop_tit2');
        _this.smartBarContent = _this.smartBarEle.find('.resource_tool_cont2');
        _this.recommendItem=null;
        _this.buttons = {
            selectedBtn: $("#J_selected"),
            recommmendBtn: $("#J_recommend"),
            lessonPrepareBtn: $("#J_lessonprepare"),
            localPrepareBtn: $("#J_localprepare"),
            cloudPrepareBtn: $("#J_cloudprepare")
        };
        _this.controls = {
            tabBar: $(".J_resource_center_bar .tabbar"),
            selectedContainer: $(".J_selected_content"),
            recommmendContainer: $(".J_recommend_content"),
            lessonPrepareContainer: $(".J_lesssonprepare_content"),
            localPrepareContainer: $(".J_localprepare_content"),
            cloudPrepareContainer: $(".J_cloudprepare_content"),
            teachingPackageContainer: $(".J_teaching_package_content")
        };
        //初始化推荐频道   下拉菜单选项
        _this.initChannel();
        _this.registerEvent();
        //资源详情页初始化
        _resourceContentPage.init(bookContainer,_this.smartBarEle);
    };

    //分类推荐
    recommendresource.prototype.getRecommend = function() {
        var _this = this;

        //遮罩
        _this.controls.recommmendContainer.find(".J_show").hide();//隐藏下方按钮
        _this.controls.recommmendContainer.find("#recommendList").html("");//清空列表
        var info = {
            "status": "resource_loading",
            "tips": "资源加载中...",
            "from": "rescontent"
        };
        _this.renderResStatus(_this.controls.recommmendContainer.find("#recommendList"), info);

        //中心用户appName
        // _this.controls.recommmendContainer.find(".J_show").hide();
        _this.controls.recommmendContainer.find(".J_hidden").hide();
        //频道
        var channel_cur = $("#J_recommend").attr("content");
        channel = channel_cur ? channel_cur : channel;
        switch (channel){
            case 'yun'://云推荐/区域云推荐
                //分平台控制
                var appName = _ebookContext.getUser().getUserAppName();
                _this.isAppNameExist(appName).done(function (ret) {
                    if(ret){
                        _this.getRecommendData(appName);
                    }else{
                        _this.getRecommendData(_default_appName);
                    }
                }).fail(function(e){
                    _this.getRecommendData(_default_appName);
                });
                break;
            case 'xiaoben'://校本资源
                console.log("校本资源");
                prepareresource.getUserInfo("id",  _ebookContext.getUser().getUid()).done(function (ret) {
                    if (ret){
                        var openId = ret.data.id;
                        var param = {
                            openId: openId,
                            userId: openId
                        };
                        edcService.Instance()["core_user_org_detail"](param).done(function(ret1){
                            if (!ret1 || !ret1.data || !ret1.data.extInfo || !ret1.data.extInfo.school[0] || !ret1.data.extInfo.school[0].id){
                                var info = {
                                    "status": "net_error",
                                    "tips": "获取学校信息失败"
                                };
                                _this.renderResStatus(_this.controls.recommmendContainer.find("#recommendList"), info);
                                _this.controls.recommmendContainer.find(".J_show").hide();
                                return 0;
                            } else {
                                var schoolId = ret1.data.extInfo.school[0].id;
                                _this.getRecommendData("", schoolId);
                            }
                        })
                    } else {
                        var info = {
                            "status": "net_error",
                            "tips": "获取学校信息失败"
                        };
                        _this.renderResStatus(_this.controls.recommmendContainer.find("#recommendList"), info);
                        _this.controls.recommmendContainer.find(".J_show").hide();
                        return 0;
                    }
                });
                break;
            case 'yangguan'://央馆
                console.log("央馆资源");
                _this.getRecommendDataYG();
                break;
        }

    };

    //分类推荐--央馆资源code列表
    recommendresource.prototype.getRecommendDataYG = function() {
        var _this = this;
        if (!getBlackboardFlag()) {
            shellcmd.checkOnline().done(function (ret) {
                if (!ret) {
                    var info = {
                        "status": "net_error",
                        "tips": "网络异常"
                    };
                    _this.renderResStatus(_this.controls.recommmendContainer.find("#recommendList"), info);
                    _this.controls.recommmendContainer.find(".J_show").hide();
                    /*//加入区域标记
                    _this.renderToolBarTips(appName);*/
                    return 0;
                } else {
                    //访问node拿到央馆推荐资源列表
                    var url = AppRemoteSvcCfg.erspUrl;
                    // var url = "http://localhost:8090/ersp";
                    shellcmd.getHttpRequestJSON(url, _this.getRequestByApp("", {page:1,limit:10})).done(function (ret) {
                        //判断当前频道是否是央馆 不是：不显示央馆列表(防止点击频道过快或者资源加载太慢导致 资源数据串了)
                        var channel_cur = $("#J_recommend").attr("content");
                        if (channel_cur == "yangguan"){
                            if (!ret || ret.code == -1 || ret.data == ""){
                                var info = {
                                    "status": "empty",
                                    "tips": "暂无资源"
                                };
                                _this.renderResStatus(_this.controls.recommmendContainer.find("#recommendList"), info);
                                _this.controls.recommmendContainer.find(".J_show").hide();
                                return 0;
                            } else {
                                var data = ret.data;
                                _this.renderYG(ret.data);
                            }
                        }
                    })
                }
            });
        }
    };

    //分类推荐数据拉取（分平台）
    recommendresource.prototype.getRecommendData = function(appName, schoolId) {
        var _this = this;
        appName = appName || "cyyun";
        if (!getBlackboardFlag()) {
            shellcmd.checkOnline().done(function (ret) {
                if (!ret) {
                    var info = {
                        "status": "net_error",
                        "tips": "网络异常"
                    };
                    _this.renderResStatus(_this.controls.recommmendContainer.find("#recommendList"), info);
                    _this.controls.recommmendContainer.find(".J_show").hide();
                    //加入区域标记
                    _this.renderToolBarTips(appName);
                    return 0;
                }else {
                    //获取精品列表数据
                    var recommendData = [];
                    //普通资源(按精品资源和download排序)
                    _this.getRecommendByApp(appName, function (ret) {
                        if (ret == "netError") {
                            var info = {
                                "status": "request_error",
                                "tips": "网络请求失败"
                            };
                            _this.renderResStatus(_this.controls.recommmendContainer.find("#recommendList"), info);
                            _this.controls.recommmendContainer.find(".J_show").hide();
                            //加入区域标记
                            _this.renderToolBarTips(appName);
                            return 0;
                        } else {
                            //合并数据
                            recommendData.push.apply(recommendData, ret);
                            _this.recommendList.origin = {
                                data: recommendData,
                                total: recommendData.length
                            };
                            var filters = {};
                            //解析数据
                            _resAccessor.resDataFilterByResType(recommendData, _resType, _resTypeArr, filters).done(function (ret1) {
                                _this.recommendList.data_origin = ret1.origin;
                                var beforeSetOrder = [];
                                beforeSetOrder["data"] = ret1.data;
                                if (ret1.total <= 0) {
                                    var info = {
                                        "status": "empty",
                                        "tips": "暂无资源"
                                    };
                                    _this.renderResStatus(_this.controls.recommmendContainer.find("#recommendList"), info);
                                    _this.controls.recommmendContainer.find(".J_show").hide();
                                    //加入区域标记
                                    _this.renderToolBarTips(appName);
                                    return 0;
                                } else {
                                    //设置排序
                                    _this.setOrderRecommendList(beforeSetOrder);
                                }
                            });
                        }
                    },{platform:"",appName:appName}, schoolId);
                }
            });
        }
    };

    /**
     * 获取分类推荐普通资源
     * @param appName
     * @param callback
     */
    recommendresource.prototype.getRecommendByApp = function(appName,callback,param, schoolId) {
        var _this = this;
        //结果集
        var result = [];
        //请求数据的初始页码
        var page = 1;
        //初始化总页数，这个设置的要比page值高
        var totalPage = 2;
        //每次拉取数据的limit值
        var LIMIT = 50;
        //终止循环的标记
        var flag = false;
        appName = appName || "";
        var platform = param && param.platform || "";

        var list = function(_page ,totalPage, callback) {
            if (_page >= totalPage || true == flag) {
                callback && callback(result);
                return ;
            }
            var param = _this.getRequestByApp(appName, {page: _page, limit: LIMIT,appName:appName,platform:platform});
            var interface = "ersp_resource_platform_list";
            //中心平台个性化接口
            if(appName == _default_appName){
                interface = "ersp_resource_list";
            }
            //判断是否为校本资源查询
            if (schoolId){
                interface = "ersp_xbzy_resource_list";
                param.schoolId = schoolId;
                //校本资源特殊参数单独处理
                //上传的校本资源没有phase字段
                param.phase = "";
                //校本资源source 为小写，大写好像查不出来
                param.source = "xiaobenziyuan,XIAOBENZIYUAN";
            }

            edcService.Instance()[interface](param).done(function(ret){
                if(ret && ret.code == 0){
                    var res = ret.data && ret.data.data|| [];
                    var total = ret.data && ret.data.total|| 0;
                    //合并数据
                    result.push.apply(result,res);
                    var totalPage = Math.ceil(total / LIMIT);
                    if(res.length > 0) {
                        //测试素材是否是否达到20条（测试条件）
                        var test_0300 = result.filter(function (el) {
                            var item_type = "";
                            //取第一个type值(老接口也是这样处理的)
                            if (Object.prototype.toString.apply(el.type) === '[object Array]') {
                                item_type = el.type && el.type[0] || "";
                            }
                            if (Object.prototype.toString.apply(el.type) === '[object String]') {
                                item_type = el.type && el.type.split(",")[0] || "";
                            }
                            if (item_type == "0300") {
                                return el;
                            }
                        });
                        if(test_0300.length >= 20){
                            flag = true;
                        }
                    }else{
                        flag = true;
                    }
                    list(_page + 1,totalPage,callback);
                }else{
                    callback && callback("netError");
                }
            }).fail(function(e){
                callback && callback("netError");
            });
        };
        //请求数据
        list(page,totalPage,callback);
    }

    /**
     * 获取同步精选模块请求参数
     */
    recommendresource.prototype.getRequestByApp = function(appName,param) {
        var _this = this;
        appName = appName || _default_appName;
        var result = {};

        // "0100": "教案",
        //     "0300": "素材",
        //     "0400": "习题",
        //     "0600": "课件"

        //不要加grade和publish参数(畅言云网站上没有加)
        // _this.request.grade = (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.grade) || "";
        // _this.request.publisher = (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.publisher) || "";
        // 接口请求时不能加volume参数，因为返回的结果和畅言云不一致
        // _this.request.volume = (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.volumn) || "";
        var grade = (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.grade) || "";
        var subject =(_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.subject) || "";
        var book = (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.bookCode) || "";
        var extension = "doc,docx,rmvb,mp4,avi,wmv,asf,3gp,flv,mpg,mpeg,mpeg4,rm,mpeg4,mov,vob,mkv,m2ts,swf,flash,pic,gif,mov,flv,flc,fla,mpeg,mp3,wma,wav,ogg,ape,mid,midi,tch,**,jpg,jpeg,bmp,png,gif,psd,gsp,gss,ppt,pps,ppsx,pptx";
        var pageMeta = _this.bookContainer.getCurrPageMetadata();
        var request_common = {
            subject: subject,            //学科
            // grade: "",              //年级
            // publisher: "",          //出版社
            edition: "",            //教材版本
            phase: _this.grade2phase(grade)||  "",              //学段
            stage: "",              //年级册别
            quality: "",          // 20-普通资源 21-精品资源
            topic: "08",          // 08 - 同步资源
            book: book,               //书本
            thumbsize: "",   //图片大小
            unit1:pageMeta.unit1 ||  "",                //目录1
            unit2:pageMeta.unit2 ||  "",                //目录2
            unit3:pageMeta.unit3 ||  "",                //目录3
            unit4:pageMeta.unit4 ||  "",                //目录4
            order: "",              //排序
            type: "",               //资源类型
            // volume:"", //册别，这里字段名称为 volume ，程序里用volumn，两者含义一致。
            q: "",                  //关键词
            page: 1,
            sortField: "quality,downloadCount",          //指定下载筛选字段
            sortType: "desc",          //指定下载筛选字段
            //校本资源这里不能区分大小写
            source: "IFLYTEK,UGC,MAISUI,XIAOBENZIYUAN,ZHONGBAO,RENJIAOJIAOFU,KXX,GUOJIA,CHANGYAN",//指定下载筛选字段
            extension : extension,      //指定后缀文件筛选
            limit: "50"
        };

        //pdf分支；如果是pdf文件且有相似书本，重写参数(优先使用app_global_pdfInfo)
        if(book.indexOf("pdf_")!=1&&app_global_pdfInfo.similarBookCode){
            request_common.book=app_global_pdfInfo.similarBookCode||(_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.bookCode)||"";
            if(request_common.unit1==""){
                request_common.unit1="undefined";
            }
        }

        request_common.quality = param && param.quality || "";
        request_common.page = param && param.page || "1";
        request_common.limit = param && param.limit || "50";
        request_common.extension = param && param.extension || extension;
        //区域平台用户个性化参数
        if(appName != _default_appName) {
            request_common.appName = appName;
            request_common.platform = param && param.platform || "";
        }
        result = request_common;
        return result;
    }

    /**
     * 设置推荐资源Item
     * @param result
     */
    recommendresource.prototype.setRecommendResItem = function(result,status){
        var _this = this;
        //定义展示的数据格式
        var _resExtension={
            "0100": ["doc","docx"], //教案
            "0300": ["rmvb","mp4","avi","wmv","asf","3gp","flv","mpg","mpeg","mpeg4","rm","mov","vob","mkv","m2ts","**","swf","flash","pic","gif","mov","flv","flc","fla","mpeg","**","mp3","wma","wav","ogg","ape","mid","midi","tch","**","jpg","jpeg","bmp","png","gif","psd","gsp","gss"], //素材
            "0400": "", //习题
            "0600": ["ppt","pps","ppsx","pptx"], //课件
            "1901": ["rmvb","mp4","avi","wmv","asf","3gp","flv","mpg","mpeg","mpeg4","rm","mov","vob","mkv","m2ts","swf","flash","flc","fla"],//微课
            "2015": ["doc","docx"] //导学案
        };
        _this.showStatus.resource=status;
        var beforeSort = result;
        //按下载量排序（因为请求接口时带了按下载量排序的规则，这里不再进行sort排序）
        // for(var i=0,count = beforeSort.length;i < count;i++) {
        //     var item = beforeSort[i];
        //     var tmp_sort = beforeSort[i]["data"].sort(function(a,b){return (b.statistics.downloadcount - a.statistics.downloadcount)});
        //     item.data = [];
        //     item.data = tmp_sort;
        // }
        //兼容之前的result变量名
        result = beforeSort;
        var appName = _ebookContext.getUser().getUserAppName();
        var render_result = [];

        var _containerWidth = parseInt($("#bookContainer").css("width"));
        var _containerHeight = parseInt($("#bookContainer").css("height"));
        var $recommendList = _this.controls.recommmendContainer.find("#recommendList");

        if($recommendList.length == 0){
            _this.controls.recommmendContainer.html('<div id="recommendList" class="resources"></div>');
        }
        $recommendList.html("").append(
                '<div class="resources-tip resources-tipgreen" style="display:none;"><span>课件</span><em></em></div>' +
                '<ul class="resources-list" content="0" name="recommendItem"></ul>' +
                '<div class="resources-tip resources-tipblue" style="display:none;"><span>教案</span><em></em></div>' +
                '<ul class="resources-list" content="1" name="recommendItem"></ul>' +
                '<div class="resources-tip resources-tipred" style="display:none;"><span>导学案</span><em></em></div>' +
                '<ul class="resources-list" content="2" name="recommendItem"></ul>' +
                '<div class="resources-tip resources-tipgreen" style="display:none;"><span>微课</span><em></em></div>' +
                '<ul class="resources-list" content="3" name="recommendItem"></ul>' +
                '<div class="resources-tip resources-tipred" style="display:none;"><span>习题</span><em></em></div>' +
                '<ul class="resources-list" content="4" name="recommendItem"></ul>' +
                '<div class="resources-tip resources-tiporange" style="display:none;"><span>素材</span><em></em></div>' +
                '<ul class="resources-list" content="5" name="recommendItem"></ul>' +
                '<!--<p align="center"><a href="#" class="gray">加载更多…</a></p>-->' +
                '</div>'
                );
        // $recommendList.css("width",(_containerWidth-266-16*2-10)*0.99+"px");
        // $recommendList.css("height",(_containerHeight - 200) + "px");
        //根据不同分辨率来计算显示的数目
        // var resTotal = parseInt((_containerWidth-266-16*2-10)*0.99/67);
        // var resTotal = parseInt((_containerHeight-200)*0.99/60);
        var resTotal = 0;
        for(var i = 0,count = result.length;i < count;i ++){
            resTotal += result[i]["total"];
        }
        var showItemCount = 2 + 2 + 2 + 2 + 2 + 20;

        for(var i=0;i<7;i++){
            $($("ul[name='recommendItem']")[i]).html("");
        }

        if (!getBlackboardFlag()){
            //清空列表
            _this.controls.recommmendContainer.find(".J_open").attr("disabled",true).prop("disabled",true);

            //A代表课件
            //B代表教案
            //E代表导学案
            //F代表微课
            //C代表习题
            //D代表素材
            var A= 0, B= 0, E=0, F=0, C= 0, D=0;//E、F后面新加的两个type，排序在习题前
            var A1 = 0, B1= 0, E1=0, F1=0, C1= 0, D1=0; //每个分类的统计数
            //Now标识当前应该塞到那个分类里
            var Now= 0;
            for(var i=0; i<resTotal; i++){
                Now = Now%6;
                if(Now==0){
                    if(A1<2){
                        var data =  result[Now].data,
                            total = result[Now].total,
                            resType= result[Now].type,
                            recommendItem = $("ul[name='recommendItem']");
                        $(recommendItem[Now]).attr("resType",resType);
                        if(data[A] && (-1 != $.inArray(data[A].extension,_resExtension[resType])))
                        {
                            render_result.push(data[A]);
                            _this.beforeRender(A,resType,data,$(recommendItem[Now]));
                            A++;
                            A1++;
                            Now++;
                            continue;
                        }else{
                            A++;
                            Now++;
                        }
                    }else{
                        Now++;
                    }
                }
                if(Now==1){
                    if(B1<2){
                        var data =  result[Now].data,
                            total = result[Now].total,
                            resType= result[Now].type,
                            recommendItem = $("ul[name='recommendItem']");
                        $(recommendItem[Now]).attr("resType",resType);
                        if(data[B] && (-1 != $.inArray(data[B].extension,_resExtension[resType])))
                        {
                            render_result.push(data[B]);
                            _this.beforeRender(B,resType,data,$(recommendItem[Now]));
                            B++;
                            B1++;
                            Now++;
                            continue;
                        }else{
                            B++;
                            Now++;
                        }
                    }else{
                        Now++;
                    }
                }
                if(Now==2){
                    if(E1<2){
                        var data =  result[Now].data,
                            total = result[Now].total,
                            resType= result[Now].type,
                            recommendItem = $("ul[name='recommendItem']");
                        $(recommendItem[Now]).attr("resType",resType);
                        if(data[E])
                        {
                            render_result.push(data[E]);
                            _this.beforeRender(E,resType,data,$(recommendItem[Now]));
                            E++;
                            E1++;
                            Now++;
                            continue;
                        }else{
                            E++;
                            Now++;
                        }
                    }else{
                        Now++;
                    }
                }
                if(Now==3){
                    if(F1<2){
                        var data =  result[Now].data,
                            total = result[Now].total,
                            resType= result[Now].type,
                            recommendItem = $("ul[name='recommendItem']");
                        $(recommendItem[Now]).attr("resType",resType);
                        if(data[F])
                        {
                            render_result.push(data[F]);
                            _this.beforeRender(F,resType,data,$(recommendItem[Now]));
                            F++;
                            F1++;
                            Now++;
                            continue;
                        }else{
                            F++;
                            Now++;
                        }
                    }else{
                        Now++;
                    }
                }
                if(Now==4){
                    if(C1<2) {
                        var data = result[Now].data,
                            total = result[Now].total,
                            resType = result[Now].type,
                            recommendItem = $("ul[name='recommendItem']");
                        $(recommendItem[Now]).attr("resType", resType);
                        if (data[C]) {
                            render_result.push(data[C]);
                            _this.beforeRender(C, resType, data, $(recommendItem[Now]));
                            C++;
                            C1++;
                            Now++;
                            continue;
                        } else {
                            C++;
                            Now++;
                        }
                    }else{
                        Now++;
                    }
                }
                if(Now==5){
                    if(D1<20) {
                        var data = result[Now].data,
                            total = result[Now].total,
                            resType = result[Now].type,
                            recommendItem = $("ul[name='recommendItem']");
                        $(recommendItem[Now]).attr("resType", resType);
                        if (data[D] && (-1 != $.inArray(data[D].extension,_resExtension[resType]))) {
                            render_result.push(data[D]);
                            _this.beforeRender(D, resType, data, $(recommendItem[Now]));
                            D++;
                            D1++;
                            Now++;
                            continue;
                        } else {
                            D++;
                            Now++;
                        }
                    }else{
                        Now++;
                    }
                }
            }
            //处理按钮
            _this.controls.recommmendContainer.find(".J_open").attr("disabled",false).prop("disabled",false);

            // var $recommendList_re_group = $recommendList.find(".re_group");
            var $recommendList_res_tips = $recommendList.find(".resources-tip");
            var $recommendList_res_ul = $recommendList.find(".resources-list");
            //   $($('.re_group').find('span')[0]).html('');
            $($recommendList_res_tips[4]).hide();
            //A代表课件,若A=0表示无该分类资源，隐藏该分类
            (A1==0) ? $($recommendList_res_tips[0]).hide() : $($recommendList_res_tips[0]).show();
            (A1==0) ? $($recommendList_res_ul[0]).hide() : $($recommendList_res_ul[0]).show();
            //B代表教案,若B=0表示无该分类资源，隐藏该分类
            (B1==0) ? $($recommendList_res_tips[1]).hide() : $($recommendList_res_tips[1]).show();
            (B1==0) ? $($recommendList_res_ul[1]).hide() : $($recommendList_res_ul[1]).show();
            //E代表导学案,若E=0表示无该分类资源，隐藏该分类
            (E1==0) ? $($recommendList_res_tips[2]).hide() : $($recommendList_res_tips[2]).show();
            (E1==0) ? $($recommendList_res_ul[2]).hide() : $($recommendList_res_ul[2]).show();
            //F代表微课,若F=0表示无该分类资源，隐藏该分类
            (F1==0) ? $($recommendList_res_tips[3]).hide() : $($recommendList_res_tips[3]).show();
            (F1==0) ? $($recommendList_res_ul[3]).hide() : $($recommendList_res_ul[3]).show();
            //C代表习题,若C=0表示无该分类资源，隐藏该分类
            (C1==0) ? $($recommendList_res_tips[4]).hide() : $($recommendList_res_tips[4]).show();
            (C1==0) ? $($recommendList_res_ul[4]).hide() : $($recommendList_res_ul[4]).show();
            //D代表素材,若D=0表示无该分类资源，隐藏该分类
            (D1==0) ? $($recommendList_res_tips[5]).hide() : $($recommendList_res_tips[5]).show();
            (D1==0) ? $($recommendList_res_ul[5]).hide() : $($recommendList_res_ul[5]).show();
            if(A1 + B1 + C1 + D1 + E1 + F1 <= 0){
                // 解析返回数据为空
                var info = {
                    "status" : "empty",
                    "tips" : "暂无资源"
                };
                _this.renderResStatus(_this.controls.recommmendContainer.find("#recommendList"),info);
                _this.controls.recommmendContainer.find(".J_show").hide();
                //加入区域标记
                _this.renderToolBarTips(appName);
            } else {
                //加入区域标记
                _this.renderToolBarTips(appName);
                //有数据时，判断资源来源是否来源于畅言云资源（中心资源）<因为数据可能来源于畅言云>
                /*if(appName && appName != "" && result.length >= 0){
                    var record = _this.cacheAppName(appName);
                    if(record) {
                        var _platform = record.platform || "";
                        var checked = render_result.filter(function (el) {
                            return el.platForm == _platform;
                        });
                        //取中心的标记
                        if (checked.length == 0) {
                            _this.renderToolBarTips(_default_appName);
                        }else{
                            //加入区域标记
                            _this.renderToolBarTips(appName);
                        }
                    }else{
                        edcService.Instance().api_eshop_home_getUserAreaName({
                            appName: appName,
                            format: "json"
                        }).done(function (ret) {
                            if (ret && ret.code == 0 && ret.data) {
                                var area_result = ret.data.data || [];
                                if (area_result.length > 0) {
                                    var _platform = area_result[0]['platform'] || "";
                                    var checked = render_result.filter(function (el) {
                                        return el.platForm == _platform;
                                    });
                                    //取中心的标记
                                    if (checked.length == 0) {
                                        _this.renderToolBarTips(_default_appName);
                                    }else{
                                        //加入区域标记
                                        _this.renderToolBarTips(appName);
                                    }
                                }
                            }
                        });
                    }
                };*/
                //重置列表状态
                var $itemDom = _this.common_operate("find",[_this.controls.recommmendContainer,"li"]);
                for (var i = 0 ;i < $itemDom.length ; ++i) {
                    if (_this.common_operate('find', [$itemDom[i], "input"]).is(":checked")) {
                        $($itemDom[i]).find("input").attr('checked', false).prop("checked", false);
                    }
                }
                _this.controls.recommmendContainer.find(".format-checkbox").hide();
                if(_this.controls.recommmendContainer.find(".J_show").is(":hidden")){
                    _this.controls.recommmendContainer.find(".J_show").show();
                }
            }
        } else {
            //   $recommendList_re_group = $recommendList.find(".re_group");
            //   $($recommendList_re_group[0]).show();
            var recommendItem = $("ul[name='recommendItem']");
            // $($('.re_group').find('span')[4]).html('模板');
            var resNum = resTotal > result.length ? result.length : resTotal;
            for( i = 0 ;i < resNum; i++){
                _this.renderSubjectTemplate(result[i],i,$(recommendItem[4]));
            }
        }
    };

    /**
     * 这个渲染方法时在白板下的页面渲染，新需求已经没有这块的展示了
     */
    recommendresource.prototype.renderSubjectTemplate = function(data, index, container){
        var _this = this;
        var li = $('<li name="">' +
            '<div class="format-checkbox" style="display: none"><input name="" type="checkbox" value="" class="ckb_box"></div>' +
            '<div class="format-img"><img src=""></div>' +
            '<div class="format-tit"><p>{title}</p></div>' +
                '<button class="batchAddToBook"></button>'+
            '</li>');
        var type = data[index].extension,
            url = _this.setDefaultPic(type);
        (data[index].thumburl.length == 0) && (data[index].thumburl = "assert/images/default_01.jpg");
        li.attr("id", data[index].id);
        li.attr("data-extension", data[index].extension);
        li.attr("contend", index);
        li.attr("index", index);
        li.find('img').attr("src", url);
        li.find('a').attr("title", data[index].title);
        //去除《》中的内容
        // var _title = data[index].title.replace(/^[《].*[》]/i,"");
        var _title = data[index].title;
        if(_title)
        // _title = _title.length >5 ? _title.substr(0, 5) + "···" : _title;
            _title = _title.length >5 ? _title.substr(0, 8) + "···" : _title;
        else{
            _title = data[index].title;
        }
        li.find(".format-tit").find('p').text(_title);

        // var _containerWidth = parseInt($("#bookContainer").css("width"));
        // if(_containerWidth<1000){
        //     li.css("width","54px");
        // }
        container.append(li);
        $("li[name=subjectTemplate]").hover(function(){
            $(this).find('a').css("color","red");
        },function(){
            $(this).find('a').css("color","black");
        });
    };

    /**
     * 插入页面前 处理校本资源作者(上传者)名称
     * @param
     */
    recommendresource.prototype.beforeRender = function (index, resType,data,container) {
        var _this = this;
        var author = "";
        var source = data[index].source.toUpperCase();
        if (source == "UGC" || source == "XIAOBENZIYUAN"){
            var p = {};
            var uploader = data[index].uploader;
            var creator = data[index].creator;
            //畅言号资源creator不做处理
            if (data[index].productId == "changyanhao"){
                author = creator;
                _this.render(index, resType,data,container,author);
            } else {
                creator = (creator).replace(/(^s*)|(s*$)/g, "").length == 0 ? uploader : creator;
                if (source == "UGC"){
                    p ={
                        key:"loginName",
                        value:creator
                    };
                } else {
                    p ={
                        key:"loginName",
                        value:uploader
                    };
                }
                edcService.Instance().core_user_get(p).done(function(ret){
                    if(ret && ret.code == 0 && ret.data){
                        author = _this.setSourceForAuthor(source,ret.data.userName);
                    }else{
                        author = _this.setSourceForAuthor(source,"匿名");
                    }
                    _this.render(index, resType,data,container,author);
                }).fail(function(e){
                    author = _this.setSourceForAuthor(source,"匿名");
                    _this.render(index, resType,data,container,author);
                });
            }

        } else {
            author = _this.setSourceForAuthor(source);
            _this.render(index, resType,data,container,author);
        }
    };

    /**
     * 插入到页面
     * @param index 下标
     * @param resType 分类
     * @param data  数据
     * @param container 容器
     *
     */
    recommendresource.prototype.render = function(index, resType,data,container,author){
        var _this = this;
        var li = $('<li name="subjectTemplate" draggable="true">' +
            '<div class="format-checkbox" style="display: none"><input name="" type="checkbox" value="" class="ckb_box"></div>' +
            '<div class="format-img"><img draggable="false" src="" ></div>' +
            '<div class="format-tit"><p><span>{title}</span><i class="changyanhao" style="display:none"></i><i class="quality" style="display:none;" name="quality"></i></p><p class="res_author" style="white-space:nowrap; overflow:hidden; text-overflow:ellipsis;"></p></div>' +
            // '<!--------------------下面这个按钮用于批量添加控制，请不要删除------------>'+
            // '<button class="invisibleAddBtn" style="display:none;"></button>'+
            '</li>');
        var type = data[index].extension,
            url = _this.setDefaultPic(type),
            quality = data[index].quality,
            productId = data[index].productId;
        if(data[index].thumburl != null && data[index].thumburl.length == 0){
            data[index].thumburl = "assert/images/default_01.jpg";
        }
        li.attr("id", data[index].id);
        li.attr("data-extension", data[index].extension);
        // var _containerWidth = parseInt($("#bookContainer").css("width"));
        // if(_containerWidth<1000){
        //     li.css("width","54px");
        // }
        li.attr("contend", index);
        li.attr("resType", resType);
        li.find('img').attr("src", url);
        li.find('a').attr("title", data[index].title);
        //去除《》中的内容
        // var _title = data[index].title.replace(/^[《].*[》]/i,"");
        var _title = data[index].title;
        li.find(".format-tit").find('span').text(_title);
        li.find(".format-tit").find('span').attr("title",_title);
        if(-1 != $.inArray(data[index].id,_this.getHasDownload("hasDownload"))){
            li.addClass("gray");
        }
        li.on("mouseover", {resId:data[index].id}, function (event) {
            var isHavingClass = _mainToolbar.getIsHavingClass();
            var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
            if(!isHavingClass && !isTeachingPackage) {
                var resId = event.data.resId;
                if (resId) {
                    var currPageRes = _this.bookContainer.getCurrentPageRes();
                    var findWidget = currPageRes.filter(function (el) {
                        if (1 == el._packedFlag) {
                            return el.resourceId == resId;
                        } else {
                            return false;
                        }
                    });
                    if (findWidget.length > 0) {
                        var target = findWidget[0];
                        var Obj = _ebookContext.getUnTransForm();
                        var _dom = $(target.Content);
                        _dom.find(".format-bignumber").css("-webkit-transform", "matrix(" + (1 * Obj.wZoom) / (Obj.wZoom * 0.7) + ", 0, 0, " + (1 * Obj.hZoom) / (Obj.hZoom * 0.7) + ", 0, 0)");
                        return false;
                    }
                }
            }
        }).on('mouseout', {resId:data[index].id}, function(event){
            var isHavingClass = _mainToolbar.getIsHavingClass();
            var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
            if(!isHavingClass && !isTeachingPackage) {
                var resId = event.data.resId;
                if (resId) {
                    var currPageRes = _this.bookContainer.getCurrentPageRes();
                    var findWidget = currPageRes.filter(function (el) {
                        if (1 == el._packedFlag) {
                            return el.resourceId == resId;
                        } else {
                            return false;
                        }
                    });
                    if (findWidget.length > 0) {
                        var target = findWidget[0];
                        if (target.Content) {
                            var _dom = $(target.Content);
                            var Obj = _ebookContext.getUnTransForm();
                            _dom.find(".format-bignumber").css("-webkit-transform", "matrix(1, 0, 0, 1, 0, 0)");
                            return false;
                        }
                    }
                }
            }
        });
        //畅言号资源     --优先显示       || quality == "21"
        if (productId == "changyanhao"){
            author = author ? author : "匿名";
            li.find(".format-tit").find('p').addClass("format-jh");
            li.find(".format-tit .res_author").html("作者： " + author);
            li.find(".format-tit .changyanhao").show();
        } else {
            //精品资源
            if(quality == "21"){
                li.find(".format-tit").find('p').addClass("format-jh");
                li.find("i[name=quality]").show();
            }else{
                li.find("i[name=quality]").remove();
            }
        }

        //校本资源显示上传者
        if (channel == "xb"){
            author = author ? author : "匿名";
            li.find(".format-tit .res_author").html("作者： " + author);
        }
        container.append(li);
        /* $("li[name=recommendItemLi]").hover(function(){
         $(this).find('a').css("color","red");
         },function(){
         $(this).find('a').css("color","black");
         });*/
    };

    /**
     * 央馆资源插入到页面
     *
     */
    recommendresource.prototype.renderYG = function(data){
        var _this = this;
        //判断当前频道是否是央馆 不是：不显示央馆列表(防止点击频道过快或者资源加载太慢导致 资源数据串了)
        var channel_cur = $("#J_recommend").attr("content");
        if (channel_cur == "yangguan"){
            var items = [];
            $("#recommendList").html('<ul class="resources-list" id="ersp_res"></ul>');
            for (var i=0; i < data.length; i++){
                var res = data[i];
                var author = (typeof(res.author) == "undefined" || (res.author).replace(/(^s*)|(s*$)/g, "").length == 0) ?  "匿名" : res.author;
                var _li = $('<li ><div class="format-img"><img src="assert/static/common/images/youkebao.png"/></div><div class="format-tit"><p class="format-jh"><span resurl="' + res.url  + '" title="' + author + '">作者： ' + author + '</span></p></div></li>');
                $(_li).on("click",{url:res.url},function(event){
                    // 关闭全局widget弹窗
                    if(app_global_curWidget && app_global_curWidget.Content){
                        if(app_global_curWidget.Content.popover('isShow','intro')){
                            app_global_curWidget.Content.popover('hide','intro');
                        }
                        if(app_global_curWidget.Content.popover('isShow','toolbar')){
                            app_global_curWidget.Content.popover('hide','toolbar');
                        }
                    }
                    //关闭目录（目录不是由popover组件生成，暂无统一的处理办法）
                    if(!$("#directory_box_left").is(":hidden")){
                        $("#directory_box_left").hide();
                    }
                    var url = event.data && event.data.url;
                    if(url){
                        gui.Shell.openExternal(url);
                    }else{
                        console.error("跳转的链接不存在");
                    }
                    console.log(url);
                });
                items.push(_li);
            }
            $("#ersp_res").append(items);
        }
    };

    /**
     * 抽出   小资源预览框显示
     * @param
     */
    recommendresource.prototype.resoureShowSmall = function (i, index, currentIndex, dom, data, that) {
        var _this = this;
        var _that = that;
        var smartbar_pop = dom;
        var _recommendItem = data;
        var containerWidth = parseInt($("#bookContainer").css("width"));
        if (containerWidth < 800 && (i == 0 && index == 0)) {
            smartbar_pop.css("marginLeft", "3px")
                .removeClass("re_group_block_warp").addClass("re_group_block_warp_top_yf").addClass("re_group_block_warp2");
        } else if (containerWidth > 800 && ((i == 0 && index == 0) || currentIndex == 0)) {
            smartbar_pop.css("marginLeft", "3px");
            smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowbot").addClass("ic_arrowtop").css("marginLeft", "-72px");
        } else if (containerWidth > 800 && ((i == 0 && index == 1) || currentIndex == 1)) {
            smartbar_pop.css("marginLeft", "3px");
            smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowbot").addClass("ic_arrowtop").css("marginLeft", "-30px");
        }
        else {
            smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowbot").addClass("ic_arrowtop");
        }
        $("#addToBook").attr("content_li", i).attr("content_li_a", index);
        var user = _ebookContext.getUser();
        if (user._name === 'defaultuser' || user._userName === 'defaultuser') {
            $("#shareToWeb").hide();
        } else {
            $("#shareToWeb").attr("content_li", i).attr("content_li_a", index);
        }
        $("#reviewResContent").attr("content_li", i).attr("content_li_a", index);
        $("#reviewComments").attr("content_li", i).attr("content_li_a", index);
        $(".jxpop-poety").attr("content_li", i).attr("content_li_a", index);
        $("#smartbar_pop").attr('resourceId', _that.id);
        $("#smartbar_pop").css("left", $(".J_resource_center_bar").width() - 3);
        //判断是否为畅言号资源
        // || _recommendItem.quality == "21"
        if (_recommendItem.productId == "changyanhao"){
            smartbar_pop.find("a[name=auth_name]").siblings().show();
        } else {
            smartbar_pop.find("a[name=auth_name]").siblings().hide();
        }

        smartbar_pop.find("a[name='auth_name']").html(_recommendItem.show_author);
        smartbar_pop.find("a[name='auth_name']").attr('contend-name', _recommendItem.uploader);
        smartbar_pop.find("div[name='description']").html($.trim(_recommendItem.description).replace(/[\r\n]/g, ""));
        smartbar_pop.find("div[name='description']").attr("title", $.trim(_recommendItem.description).replace(/[\r\n]/g, ""));
        var _title = "";
        if (_recommendItem.title && _recommendItem.title.length > 10)
            _title = _recommendItem.title.substr(0, 10) + "···";
        else
            _title = _recommendItem.title;

        smartbar_pop.find("p[name='res_title']").attr("title", _recommendItem.title).html(_title);
        if (_recommendItem.statistics) {
            smartbar_pop.find("em[name='resStar']").css("width", _recommendItem.statistics.score + "%");
        }

        //评价分数
        //有可能_recommendItem.detailInfo为空，如果为空，使用_recommendItem自有数据
        if (_recommendItem.detailInfo) {
            //如果有分数，使用分数，如果数据中没有分数，使用scorecount*20来代替分数（scorecount*20相对不够准确）
            if (_recommendItem.detailInfo.statistics.score == "0" || !_recommendItem.detailInfo.statistics.score) {
                var percent = _recommendItem.detailInfo.statistics.scorecount * 20 + "%";
            } else {
                var percent = _recommendItem.detailInfo.statistics.score + "%";
            }
        } else {
            if (_recommendItem.statistics.score == "0" || !_recommendItem.statistics.score) {
                var percent = _recommendItem.statistics.scorecount * 20 + "%";
            } else {
                var percent = _recommendItem.statistics.score + "%";
            }
        }
        $('em[name="resourceStarsId"]').css("width", percent);

        //_recommend//多张缩略图Item.detailInfo.screenshots[1] 是为了防止服务端返回空对象
        if (_recommendItem.detailInfo && _recommendItem.detailInfo.screenshot && _recommendItem.detailInfo.screenshot[2]) {
            //screenshots 有，不用单缩略图
            $("#viewImg").remove();
            $("#smart_img_pre").show();
            $("#smart_img_next").show();
            var _imgTemp = null;
            for (var temp in _recommendItem.detailInfo.screenshot) {
                if (temp == 1) {
                    _imgTemp = $('<img name="res_image" class="img_show" src="assert/static/pop/images/jxpop-poety.png" >');
                } else {
                    _imgTemp = $('<img name="res_image" class="img_hide" src="assert/static/pop/images/jxpop-poety.png" >');
                }
                _imgTemp.attr("src", _recommendItem.detailInfo.screenshot[temp]);
                smartbar_pop.find(".jxpop-poety").append(_imgTemp);
            }
        } else {
            $("#smart_img_pre").hide();
            $("#smart_img_next").hide();
            if (_recommendItem.thumburl){
                $("#viewImg").attr("src", _recommendItem.thumburl);
            }else{
                $("#viewImg").attr("src",_this.setDefaultThumbnail(_recommendItem.extension));
            }
        }

        var height = $(_that).offset().top;
        if (height + $("#smartbar_pop").height() - $("#leftToolbar").height() < 0) {
            $("#smartbar_pop").css({
                bottom: "",
                top: height,
                position: "absolute",
                "z-index": 10
            })
        } else {
            $("#smartbar_pop").css({
                bottom: "58px",
                position: "absolute",
                "z-index": 10
            })
        }

    };

    /**
     * 设置资源来源(显示作者规则)
     * @param
     */
    recommendresource.prototype.setSourceForAuthor = function(source,creator){
        var source = source.toUpperCase();
        var view_source ="";
        switch(source){
            case "KXX":
                view_source = "酷学习";
                break;
            case "IFLY-AI":
            case "IFLYTEK":
                view_source = "畅言教育";
                break;
            case "UGC":
            case "XIAOBENZIYUAN":
            case "xiaobenziyuan":
                view_source = creator;
                break;
            case "GUOJIA":
            case "EDU":
                view_source = "国家教育资源平台";
                break;
            case "RENJIAOJIAOFU":
                view_source = "人教教辅";
                break;
            default:
                view_source = "畅言教育";
                break;
        }
        return view_source;
    };

    /**
     * 初始化分类推荐频道    下拉框选项(云推荐/区域云推荐、校本资源、央馆资源)
     * @param
     */
    recommendresource.prototype.initChannel = function(){
        var _this = this;
        var count = 0;  //统计频道的数量
        var channelList = [];   //存放用户当前所拥有的频道
        var updateChannal = false;  //考虑到有时服务异常问题，如果请求异常，则不更新服务器频道

        //云推荐/区域云推荐频道确定
        var channel_yun = '<li class="J_recommend_cloud li_selected" content="yun">云推荐</li>';
        count++;
        $(".J_recommend_submenu").append(channel_yun);
        channelList.push("yun");
        //区域云
        var appName = _ebookContext.getUser().getUserAppName();
        //加入区域标记
        _this.renderToolBarTips(appName);

        /*//央馆资源频道确定
        var channel_yg = '<li class="J_recommend_yg" content="yangguan">央馆优课</li>';
        count++;
        $(".J_recommend_submenu").append(channel_yg);
        channelList.push("yangguan");*/

        //todo 如果有多个频道需要异步方法来确认，需要使用when方法
        //校本资源频道确定
        prepareresource.getUserInfo("id",  _ebookContext.getUser().getUid()).done(function (ret) {
            if (ret){
                var loginName = ret.data.loginName;
                var openId = ret.data.id;
                var param = {
                    openId: openId,
                    userId: openId
                };
                edcService.Instance()["core_user_org_detail"](param).done(function(retDetail){
                    if (retDetail && retDetail.data && retDetail.data.extInfo && retDetail.data.extInfo.school[0] && retDetail.data.extInfo.school[0].id){
                        var schoolId = retDetail.data.extInfo.school[0].id;
                        var source = "xiaobenziyuan,XIAOBENZIYUAN";
                        var interface = "ersp_xbzy_resource_list";
                        var param = {
                            schoolId : schoolId,
                            source : source,
                            page : 1,
                            limit : 1
                        };
                        edcService.Instance()[interface](param).done(function(ret){
                            if(ret && ret.code == 0){
                                var total = ret.data && ret.data.total || 0;
                                if (total > 0){
                                   var channel_xb = '<li class="J_recommend_xb" content="xiaoben">校本推荐</li>';
                                    count++;
                                    $(".J_recommend_submenu").append(channel_xb);
                                    channelList.push("xiaoben");
                                } else {
                                    updateChannal = true;
                                }
                            }
                            dealChannel(count);
                            dealUserChannel(channelList);
                        }).fail(function (e) {
                            console.log(e);
                            dealChannel(count);
                            dealUserChannel(channelList);
                        });
                    } else {
                        console.log(retDetail);
                        dealChannel(count);
                        dealUserChannel(channelList);
                    }
                }).fail(function (e) {
                    console.log(e);
                    dealChannel(count);
                    dealUserChannel(channelList);
                });
            } else {
                console.log(ret);
                dealChannel(count);
                dealUserChannel(channelList);
            }
        }).fail(function (e) {
            console.log(e);
            dealChannel(count);
            dealUserChannel(channelList);
        });

        //根据频道数量决定显不显示下拉框  1：下拉箭头显灰，不可点击  >1:可点击，显示下拉框
        function dealChannel(count){
           // count = 1;
            //判断count的值
            if (count > 1){    //下拉箭头可点击
                $("#J_recommend").siblings(".btn-arrow").attr("id", "J_recommend_arrow");
            } else {    //下拉箭头禁灰
                //移除下拉箭头
                $("#J_recommend").siblings(".btn-arrow").remove();
                //设置padding-right为0
                $("#J_recommend").css("padding-right", 0);
                //去除下拉框id属性，使得点击不会展示下拉框
                // $("#J_recommend").siblings(".btn-arrow").removeAttr("id");
                // $("#J_recommend").siblings(".btn-arrow").css({"cursor":"default", "color":"gray"});
            }
        }

        //处理用户频道，判断是否有新频道
        function dealUserChannel(channelList) {
            var uid = _ebookContext.getUser().getUid();
            //获取服务器端存储的用户频道
            var url = AppRemoteSvcCfg.userChannelGetUrl;
            // var url = "http://localhost:8090/taUser/getUserChannelList";
            shellcmd.getHttpRequestJSON(url, {"userId":uid}).done(function (ret) {
                if (!ret || ret.code == -1 || ret.data.length == 0){  //没有查到用户频道
                    //插入用户频道
                    var channelStr = "";
                    for (var i=0; i < channelList.length; i++){
                        if (i != (channelList.length - 1)){
                            channelStr += (channelList[i] + ",");
                        } else {
                            channelStr += channelList[i];
                        }
                    }
                    var url_insert = AppRemoteSvcCfg.userChannelInsertOrUpdateUrl;
                    // var url_insert = "http://localhost:8090/taUser/insertOrUpdateUserChannel";
                    shellcmd.getHttpRequestJSON(url_insert, {"userId":uid, "channel":channelStr}).done(function (insertRet) {
                        if (insertRet && insertRet.code == 1){
                            console.log("插入用户频道成功");
                        } else {
                            console.log("插入用户频道失败");
                        }
                    });
                } else {
                    var hasNewChannel = false;  //判断是否有新频道
                    //服务器存储的channel
                    var channelOrgin = ret.data && ret.data[0] && ret.data[0].channel;
                    if (channelOrgin){
                        var channelOrginList = channelOrgin.split(",");
                        for (var j=0; j < channelList.length; j++){
                            if ($.inArray(channelList[j], channelOrginList) == -1){ //有新频道
                                hasNewChannel = true;
                                break;
                            }
                        }
                        if (hasNewChannel){     //显示"新"角标
                            $("#J_leftToolbar_tabtips_new").find("p").html("").html("新");
                            $("#J_leftToolbar_tabtips_new").show();
                        } else {
                            if (channelList.length < channelOrginList.length && updateChannal){  //当前频道数量小于服务器上频道数量
                                //更新服务器上频道的数量
                                var channelStr = "";
                                for (var i=0; i < channelList.length; i++){
                                    if (i != (channelList.length - 1)){
                                        channelStr += (channelList[i] + ",");
                                    } else {
                                        channelStr += channelList[i];
                                    }
                                }
                                var url_update = AppRemoteSvcCfg.userChannelInsertOrUpdateUrl;
                                // var url_update = "http://localhost:8090/taUser/insertOrUpdateUserChannel";
                                shellcmd.getHttpRequestJSON(url_update, {"userId":uid, "channel":channelStr}).done(function (updateRet) {
                                    if (updateRet && updateRet.code == 1){
                                        console.log("更新用户频道成功");
                                    } else {
                                        console.log("更新用户频道失败");
                                    }
                                });
                            }
                        }
                    }
                }
            });
        }
    };

    /**
     * 事件绑定
     */
    recommendresource.prototype.registerEvent=function(){
        var _this = this,
            resourceList = this.smartBarContent.find('.resource_tool_cont_box'),
            left = parseInt(_this.smartBarEle.css("left").replace(/px/gi, "")),
            bottom, width;

        var PopFrame = function(curEle){
            if (!getBlackboardFlag()){
                var smartbar_pop = $('<div class="re_group_block_warp" id="smartbar_pop" style="margin-left: -60px;">'+
                    '<div class="re_group_block_con re_group_block_con_bar">'+
                    '<dl>'+
                    '<dd class="re_gr_img"><img id="viewImg" src="assert/images/re_gr_img01.png" alt="" ></dd>'+
                    '<dd class="re_gr_btn clearfix">'+
                    '<span id="viewRes">预览</span>'+
                    '<span id="addToBook">加入课本</span>'+
                    '</dd>'+
                    '<dd class="re_gr_text">可直接拖动加入课本</dd>'+
                    '</dl>'+
                    '</div>'+
                    '</div>');

                var containerWidth = parseInt($("#bookContainer").css("width"))
                if (containerWidth < 800&&(i==0&&index==0)) {
                    if($("#smartbar").attr("flag")=="top")
                        smartbar_pop.css("marginLeft","-30px").addClass("re_group_block_warp2");
                    else
                        smartbar_pop.css("marginLeft","-30px")
                            .removeClass("re_group_block_warp").addClass("re_group_block_warp_top_yf").addClass("re_group_block_warp2");
                }else{
                    if($("#smartbar").attr("flag")=="top"){
                        smartbar_pop.removeClass("re_group_block_warp_top01").addClass("re_group_block_warp");
                        smartbar_pop.find(".re_group_block_con_top01").removeClass("re_group_block_con_top01").addClass("re_group_block_con");

                    }else{
                        smartbar_pop.removeClass("re_group_block_warp").addClass("re_group_block_warp_top01");
                        smartbar_pop.find(".re_group_block_con").removeClass("re_group_block_con").addClass("re_group_block_con_top01");

                    }
                }
                curEle.append(smartbar_pop);
            } else {
                smartbar_pop =
                    $('<div class="wrap" id="smartbar_pop" style="z-index :1 ;position: absolute;bottom: 81px;left:-113px"><div class="re_group2 relative">'+
                        '<div class="editor_tit_smartBar clearfix">'+
                        '<p style="float: left">田字格</p>'+
                        '</div>'+
                        '<div class="editor_con">' +
                        '<div class="editor_photo_smartBar"><img id = "viewImg"src="images/default_01.jpg" alt=""></div>' +
                        '<div class="editor_btnbar_smartBar">'+
                        '<div class="line"></div>' +
                        '<div class="btn_smartBar">' +
                        '<div id = "addToBook" class="smartbar_btn_smartBar">加入黑板</div>'+
                        '<div id = "viewRes" class="smartbar_btn_smartBar">预览</div>'+
                        '</div>'+
                        '</div>'+
                        '</div>' +
                        '</div>' +
                        '<i class="ic_arrowbot absolute" style="margin-left: -9px"></i>'+
                        '</div>');
                if ($("#smartbar").attr("flag")=="top"){
                    if (curEle.attr("index") == 0){
                        smartbar_pop.css('left','-34px');
                        smartbar_pop.find('i').css('margin-left','-86px');
                    } else if(curEle.attr("index") == 1){
                        smartbar_pop.css('left','-94px');
                        smartbar_pop.find('i').css('margin-left','-28px');
                    }
                } else {
                    smartbar_pop.find('i').removeClass('ic_arrowbot').addClass('ic_arrowtop');
                    smartbar_pop.find('i').css('margin-top','1px');
                    if (curEle.attr("index") == 0){
                        smartbar_pop.css('left','-34px');
                        smartbar_pop.find('i').css('margin-left','-88px');
                    } else if(curEle.attr("index") == 1){
                        smartbar_pop.css('left','-95px');
                        smartbar_pop.find('i').css('margin-left','-27px');
                    }
                }
                //var realName = path.basename(curEle.attr('srcPath'),'.jpg');
                smartbar_pop.find('p').text(curEle.find('p').text());
                curEle.append(smartbar_pop);

            }

            if($("#smartbar").attr("flag")=="top"){
                $("#smartbar_pop").css({
                    bottom:"81px",
                    top:""
                })
            }else{
                $("#smartbar_pop").css({
                    bottom:"",
                    top:"81px"
                })
            }
        }

          //点击复选框事件,组织冒泡
        $(document).on("click",".ckb_box",function(event){
            event.stopPropagation();
        });

        //推荐资源列表点击单个资源弹出小的资源详情框
        $(document).on("click","ul[name='recommendItem'] li, li[name=subjectTemplate]", function (e) {
            //关闭目录（目录不是由popover组件生成，暂无统一的处理办法）
            if(!$("#directory_box_left").is(":hidden")){
                $("#directory_box_left").hide();
            }
            var _that = this;
            var isSelf = false;
            var currentIndex = $("li[name='subjectTemplate']").index($(this));
            if (!getBlackboardFlag()){
                var index = $(this).attr("contend"),
                    resType = $(this).attr("resType");
                for(var i in _resTypeArr){
                    if(_resTypeArr[i]==resType) break;
                }
                //i为资源分类下标 index为该分类下的下标
                _this.resetSmartBarEle('resource', i , index);
                var _recommendItem = _this.recommendList.data[i].data[index];
                _this.recommendItem=_recommendItem;

                var curpageIndex = _this.bookContainer.getPageIndex();
                //存放下载时的当前页码
                _this.recommendItem.pageIndex = curpageIndex;

                var curpageRes = _this.bookContainer.getCurrentPageRes();
                var flag = curpageRes.filter(function(el){
                    return el.resourceId == _recommendItem.id;
                });

               /* var curpageRes = _this.bookContainer.getCurrentPageRes();
                var flag = curpageRes.filter(function(el){
                    return el.resourceId == _recommendItem.id;
                });*/
                if(flag.length >= 1){
                  //触发蓝色气泡点击事件
                  if(flag[0].WidgetType == "note"){
                    flag[0].resourcePreview();
                  }else{
                    flag[0].showEdit($("#"+flag[0].Id),flag[0]);
                  }
                }else{
                    var param={
                        id:_recommendItem.id,
                        autov: false
                    };
                    //get接口添加平台参数 by njfu
                    if(json.get_platfrom){
                        param.platform = _recommendItem.platForm || "";
                    }
                    edcService.Instance().ersp_resource_get(param).done(function(ret) {
                        if (ret.code == "0") {
                            //通过接口得到“资源详情页”数据，将数据放入_recommendItem.detailInfo中，预览框中需要部分详细信息。
                            _recommendItem.detailInfo = ret.data.data;
                            //默认图片
                            var defaultPic = _this.setDefaultThumbnail(_recommendItem.detailInfo.extension);
                            var smartbar_pop = $(
                                '<div class="jxpop-box w290" id="smartbar_pop" resourceId="" >' +
                                '<div class="jxpop-main">' +
                                '<div class="jxpop-taba mlr5">' +
                                '<p class="fsize14" name="res_title">与西湖相关的古诗</p>' +
                                '<p><button type="button" class="btn-gray" id="reviewResContent">查看详情</button></p>' +
                                '</div>' +
                                '<div class="jxpop-poety recommendresource-pop">' +
                                '<button type="button" class="btn-black left" id="smart_img_pre"><i class="icon iconfont">&#xe625;</i></button>' +
                                '<button type="button" class="btn-black right" id="smart_img_next"><i class="icon iconfont">&#xe626;</i></button>' +
                                '<img name="res_image" id="viewImg" src="" onerror="javascript:this.src=\''+defaultPic+'\'">' +
                                '</div>' +
                                '<div class="editor_text text_ellipsis" name="description">' +
                                '雪孩子变成了白云，雪孩子变成了白云。雪孩子变成了白云。' +
                                '</div>' +
                                '<div class="ma5">' +
                                '<p class="mt5">资源作者：<i style="display:none"><img src="assert/static/common/images/icon-cyh.png" style="margin-bottom:-3px;"/> - </i><a  name="auth_name"  class="blue">李老师</a></p>' +
                                '<span class="star2"><em name="resourceStarsId" style="width:70%;"></em></span>' +
                                '</div>' +
                                '</div>' +
                                '<div class="jxpop-btnbar">' +
                                '   <button type="button" class="btn-blue" id="addToBook"><i class="icon iconfont"  >&#xe603;</i>加入课本</button>' +
                                '</div>' +
                                '</div>');

                            //根据是否已经存在小资源弹框，来判断是加载还是隐藏弹窗
                            if (($("#smallPreviewviewBox").is(":visible") && $("#smartbar_pop").length != 0) && ($("#smartbar_pop").attr("resourceid") == _that.id)) {
                                $("#smallPreviewviewBox").empty();
                            } else {
                                $("#smallPreviewviewBox")[0].style.display = "block";
                                $("#smallPreviewviewBox").empty();
                                $("#smallPreviewviewBox").append(smartbar_pop);
                                //$("#smallPreviewviewBox").show();
                            }
                            $("#viewImg").attr("src",_this.setDefaultThumbnail(_recommendItem.extension));
                            var detailData = {};
                            ret.data&&ret.data.data&&(detailData = ret.data.data);

                            if (detailData && (detailData.source.toUpperCase() == "UGC" || detailData.source.toUpperCase() == "XIAOBENZIYUAN")){
                                var author = "";
                                //畅言号资源特殊处理
                                if (detailData.productid == "changyanhao"){
                                    _recommendItem.show_author = detailData.creator;
                                    _this.resoureShowSmall(i, index, currentIndex, smartbar_pop, _recommendItem, _that);
                                } else {
                                    if (detailData.source == "UGC"){
                                        author = (detailData.creator).replace(/(^s*)|(s*$)/g, "").length == 0 ? detailData.uploader : detailData.creator;
                                    } else {
                                        author = detailData.uploader;
                                    }
                                    var p ={
                                        key:"loginName",
                                        value:author
                                    };

                                    edcService.Instance().core_user_get(p).done(function(ret1){
                                        if(ret1 && ret1.code == 0 && ret1.data){
                                            _recommendItem.show_author = _this.setSourceForAuthor(detailData.source,ret1.data.userName);
                                        }else{
                                            _recommendItem.show_author = _this.setSourceForAuthor(detailData.source,"匿名");
                                        }
                                        _this.resoureShowSmall(i, index, currentIndex, smartbar_pop, _recommendItem, _that);
                                    }).fail(function(e){
                                        _recommendItem.show_author = _this.setSourceForAuthor(detailData.source,"匿名");
                                        _this.resoureShowSmall(i, index, currentIndex, smartbar_pop, _recommendItem, _that);
                                    });
                                }

                            } else {
                                _recommendItem.show_author = _this.setSourceForAuthor(detailData.source);
                                _this.resoureShowSmall(i, index, currentIndex, smartbar_pop, _recommendItem, _that);
                            }

                            /*var containerWidth = parseInt($("#bookContainer").css("width"));
                            if (containerWidth < 800 && (i == 0 && index == 0)) {
                                smartbar_pop.css("marginLeft", "3px")
                                    .removeClass("re_group_block_warp").addClass("re_group_block_warp_top_yf").addClass("re_group_block_warp2");
                            } else if (containerWidth > 800 && ((i == 0 && index == 0) || currentIndex == 0)) {
                                smartbar_pop.css("marginLeft", "3px");
                                smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowbot").addClass("ic_arrowtop").css("marginLeft", "-72px");
                            } else if (containerWidth > 800 && ((i == 0 && index == 1) || currentIndex == 1)) {
                                smartbar_pop.css("marginLeft", "3px");
                                smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowbot").addClass("ic_arrowtop").css("marginLeft", "-30px");
                            }
                            else {
                                smartbar_pop.find("i[name=arrow]").removeClass("ic_arrowbot").addClass("ic_arrowtop");
                            }
                            $("#addToBook").attr("content_li", i).attr("content_li_a", index);
                            var user = _ebookContext.getUser();
                            if (user._name === 'defaultuser' || user._userName === 'defaultuser') {
                                $("#shareToWeb").hide();
                            } else {
                                $("#shareToWeb").attr("content_li", i).attr("content_li_a", index);
                            }
                            $("#reviewResContent").attr("content_li", i).attr("content_li_a", index);
                            $("#reviewComments").attr("content_li", i).attr("content_li_a", index);
                            $(".jxpop-poety").attr("content_li", i).attr("content_li_a", index);
                            $("#smartbar_pop").attr('resourceId', _that.id);
                            $("#smartbar_pop").css("left", $(".J_resource_center_bar").width() - 3);
                            //判断是否为畅言号资源
                            // || _recommendItem.quality == "21"
                            if (_recommendItem.productId == "changyanhao"){
                                smartbar_pop.find("a[name=auth_name]").siblings().show();
                            } else {
                                smartbar_pop.find("a[name=auth_name]").siblings().hide();
                            }

                            smartbar_pop.find("a[name='auth_name']").html(_recommendItem.creator);
                            smartbar_pop.find("a[name='auth_name']").attr('contend-name', _recommendItem.uploader);
                            smartbar_pop.find("div[name='description']").html($.trim(_recommendItem.description).replace(/[\r\n]/g, ""));
                            smartbar_pop.find("div[name='description']").attr("title", $.trim(_recommendItem.description).replace(/[\r\n]/g, ""));
                            var _title = "";
                            if (_recommendItem.title && _recommendItem.title.length > 10)
                                _title = _recommendItem.title.substr(0, 10) + "···";
                            else
                                _title = _recommendItem.title;

                            smartbar_pop.find("p[name='res_title']").attr("title", _recommendItem.title).html(_title);
                            if (_recommendItem.statistics) {
                                smartbar_pop.find("em[name='resStar']").css("width", _recommendItem.statistics.score + "%");
                            }

                            //评价分数
                            //有可能_recommendItem.detailInfo为空，如果为空，使用_recommendItem自有数据
                            if (_recommendItem.detailInfo) {
                                //如果有分数，使用分数，如果数据中没有分数，使用scorecount*20来代替分数（scorecount*20相对不够准确）
                                if (_recommendItem.detailInfo.statistics.score == "0" || !_recommendItem.detailInfo.statistics.score) {
                                    var percent = _recommendItem.detailInfo.statistics.scorecount * 20 + "%";
                                } else {
                                    var percent = _recommendItem.detailInfo.statistics.score + "%";
                                }
                            } else {
                                if (_recommendItem.statistics.score == "0" || !_recommendItem.statistics.score) {
                                    var percent = _recommendItem.statistics.scorecount * 20 + "%";
                                } else {
                                    var percent = _recommendItem.statistics.score + "%";
                                }
                            }
                            $('em[name="resourceStarsId"]').css("width", percent);

                            //_recommend//多张缩略图Item.detailInfo.screenshots[1] 是为了防止服务端返回空对象
                            if (_recommendItem.detailInfo && _recommendItem.detailInfo.screenshot && _recommendItem.detailInfo.screenshot[2]) {
                                //screenshots 有，不用单缩略图
                                $("#viewImg").remove();
                                $("#smart_img_pre").show();
                                $("#smart_img_next").show();
                                var _imgTemp = null;
                                for (var temp in _recommendItem.detailInfo.screenshot) {
                                    if (temp == 1) {
                                        _imgTemp = $('<img name="res_image" class="img_show" src="assert/images/default_01.jpg" >');
                                    } else {
                                        _imgTemp = $('<img name="res_image" class="img_hide" src="assert/images/default_01.jpg" >');
                                    }
                                    _imgTemp.attr("src", _recommendItem.detailInfo.screenshot[temp]);
                                    smartbar_pop.find(".jxpop-poety").append(_imgTemp);
                                }
                            } else {
                                $("#smart_img_pre").hide();
                                $("#smart_img_next").hide();
                                if (_recommendItem.thumburl){
                                    $("#viewImg").attr("src", _recommendItem.thumburl);
                                }else{
                                    $("#viewImg").attr("src",_this.setDefaultThumbnail(_recommendItem.extension));
                                }
                            }

                            var height = $(_that).offset().top;
                            if (height + $("#smartbar_pop").height() - $("#leftToolbar").height() < 0) {
                                $("#smartbar_pop").css({
                                    bottom: "",
                                    top: height,
                                    position: "absolute",
                                    "z-index": 10
                                })
                            } else {
                                $("#smartbar_pop").css({
                                    bottom: "58px",
                                    position: "absolute",
                                    "z-index": 10
                                })
                            }*/
                        }
                    });
                }
                //};
            } else {
                if (isSelf == false){
                    PopFrame($(this));
                    $("#viewRes").attr("srcPath", $(this).attr("srcPath"));
                    $("#viewRes").attr("srcName", $(this).find('a').attr('title'));
                    $("#addToBook").attr("srcPath", $(this).attr("srcPath"));
                    $("#viewImg").attr("src", $(this).attr("srcPath"));
                }

            }
            //_this.resetSmartBarEle('resource', resType_index , index);
            //新关闭已经存在的气泡

        });

        $(document).on('click',"a[name='auth_name']", function(e){
            /**
             * 以下代码注释时间：2015.4.18
             * 原因：区域平台展会屏蔽
             */
//            var upLoadName = $(this).text();
//            var url = AppRemoteSvcCfg.GeRenZhongXin + upLoadName;
//            _ebookContext.getUser().getDataByUserToken(url).done(function(userInfo){
//                if(userInfo)
//                {
//                    var userServiceUrl = AppRemoteSvcCfg.SNSID +userInfo.id;
//                    shellcmd.getHttpRequest(userServiceUrl).done(function(res){
//                        if(res)
//                        {
//                            var res = JSON.parse(res);
//                            var indexUrl = ''
//                            console.log(res);
//                            if(AppVersionCfg.AppVersion == "YueJiaoYun"){
//                                indexUrl= AppRemoteSvcCfg.YJYSNSMainPage + res.uid;
//                            }else{
//                                indexUrl= AppRemoteSvcCfg.SNSMainPage + res.uid;
//                            }
//                            res.uid && shellcmd.openPageOutside(indexUrl);
//                        }
//                    });
//                }
//            });
//            $("li[name='recommendItemLi'] , li[name=subjectTemplate]").find("#smartbar_pop").remove();
//            e.stopPropagation();
        });

        //通过缩略图点击进入详情页
        $(document).on("click", ".jxpop-poety.recommendresource-pop", function(){
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'01017',
                type:'trigger',
                bookCode:_ebookContext.curBookCode
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            //隐藏弹框
            $("#smallPreviewviewBox").empty();
            var resType_index = $(this).attr("content_li"),
                index = $(this).attr("content_li_a"),
                resultData =_this.recommendList.data[resType_index].data[index];
            var resourceid=$(this).parent().parent().attr("resourceid");
            resultData.resFrom = "recommend";
            if(resultData.fileurl.lastIndexOf("http")!=0){
                resultData.fileurl=resultData.fileurl.substring(resultData.fileurl.lastIndexOf("http"));
            }
            var param={
                id:resourceid,
                autov: true
            }
            //get接口添加平台参数 by njfu
            if(json.get_platfrom){
                param.platform = resultData.platForm || "";
            }
            edcService.Instance().ersp_resource_get(param).done(function(ret){
                if(ret.data.data){
                    var ret=ret.data;
                    if(ret.data.thumburl!=null&&ret.data.thumburl!=""){
                        resultData.thumburl = ret.data.thumburl;
                    }
                    resultData.statistics = ret.data.statistics;
                    resultData.screenshots= ret.data.screenshot;
                }
                resultData.origin=_this.recommendList.data_origin;
                _resourceContentPage.showResContentPanel(resultData);

            }).fail(function(e){
                //失败处理
                console.log(e);
            });
        });

		//资源弹出框图片翻页----前一张
        $(document).on("click","#smart_img_pre",function(e){
            $("#smart_img_pre").show();
            $("#smart_img_next").show();
            var prev =$(".img_show").prev("img[name=res_image]");
            var length = $("img[name=res_image]").length;
            if(prev.length>0){
                $(".img_show").removeClass("img_show").addClass("img_hide");
                prev.removeClass("img_hide").addClass("img_show");
            }else{
                $(".img_show").removeClass("img_show").addClass("img_hide");
                $($("img[name=res_image]")[length-1]).removeClass("img_hide").addClass("img_show");
              //  $("#smart_img_pre").hide();
            }
            e.stopPropagation();
        });

        //资源弹出框图片翻页----后一张
        $(document).on("click","#smart_img_next",function(e){
            $("#smart_img_pre").show();
            $("#smart_img_next").show();
            var next = $(".img_show").next("img[name=res_image]");
            var length = $("img[name=res_image]").length;
            if(next.length>0){
                $(".img_show").removeClass("img_show").addClass("img_hide");
                next.removeClass("img_hide").addClass("img_show");
            }else if(length>0){
                $(".img_show").removeClass("img_show").addClass("img_hide");
                $($("img[name=res_image]")[0]).removeClass("img_hide").addClass("img_show");
               // $("#smart_img_next").hide();
            }
            e.stopPropagation();
        });
        //推荐资源---查看资源
        $(document).on("click","#viewRes",function(event){
            if(!getBlackboardFlag()){
                var resType_index = $(this).attr("content_li");
                var index = $(this).attr("content_li_a");
                var resultData = _this.recommendList.data[resType_index].data[index];
                var type = resultData.extension;
                var url = resultData.previewurl;
                $("#smartbar_pop").remove();
                resultData.resFrom = "recommend";
                _this.resetSmartBarEle('resource', resType_index , index);
                _this.previewRes(type, url,resultData);
                event.stopPropagation();
                return false;
            } else{
                $("#smartbar_pop").remove();
                 url = $(this).attr('srcPath');
                 type = path.extname(url);
                 type = type.replace('.','');
                 resultData = {"title" : $(this).attr('srcName') , "url" : url};
                _this.previewRes(type, url, resultData);
                event.stopPropagation();
                return false;
            }

        });



        //推荐资源---加入到书本
        $(document).on("click","#addToBook",function(event){
            $("#smartbar_pop").remove();
            newWidgetPos = null;
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            if (!getBlackboardFlag()){
                var recommendListOriginData = _this.recommendList.data_origin;
                var resType_index = $(this).attr("content_li"),
                    index = $(this).attr("content_li_a"),
                    resultData =_this.recommendList.data[resType_index].data[index];
                if(resultData.fileurl.lastIndexOf("http")!=0){
                    resultData.fileurl=resultData.fileurl.substring(resultData.fileurl.lastIndexOf("http"));
                }
                //添加资源下载的当前页码
                resultData.pageIndex = _download_pageIndex;
                var userId = _ebookContext.getUser().getUid();
                resultData.resFrom = "recommend";
                newWidgetPos = null;
                //todo 开发时使用
                // resultData.payModel=1;
                // resultData.exchangeCredit=20000;
                if(resultData.payModel==1&&resultData.exchangeCredit!=0){//需要付费
                    var paydownloaded=false;
                    var params={
                        action:"download",
                        userId:userId,
                        resId:resultData.id
                    };
                    //先查询该用户是否已经对此资源付费
                    edcService.Instance().ersp_resource_user_credit_action(params).done(function(ret){
                        paydownloaded=ret.data.data;
                        //todo 开发时使用
                        // paydownloaded=false;
                        if(paydownloaded==true){//用户已付费
                            $("#preview_alreadyPayforResources").show();
                        }else {//用户未付费
                            var params = {
                                userId: userId
                            };
                            //获得用户现在拥有的积分
                            edcService.Instance().ersp_resource_user_credit_get(params).done(function (ret) {
                                //用户现在拥有的积分
                                var total_credit = ret.data.data.toFixed(1);
                                var need_credit = resultData.exchangeCredit;
                                if (total_credit && need_credit) {
                                    $("#preview_payforResources").show();
                                    _this.recommendItem.totalCredit = total_credit;
                                    if(need_credit-total_credit>0){//所需积分比用户总积分多
                                        $("#preview_payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前积分不足";
                                        $("#preview_payforResources .btn-gray").hide();
                                    }else{
                                        $("#preview_payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前有" + total_credit + "积分，确认下载么？";
                                    }
                                }
                            }).fail(function(err){
                                console.log(err);
                            })
                        }
                    }).fail(function(err){
                        console.log(err);

                    })
                }else{//不需要付费
                    $("#smartbar_pop").remove();
                    var dataIds=[];
                    dataIds.push(resultData.id);
                    _this.downLoadFile(resultData);
                    _this.storageDownloading(dataIds,recommendListOriginData,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});//加入下载队列
                    var $itemDom = _this.common_operate("find",["#recommendList","li"]);//更新动画
                    var last=i;
                    for(i=0;i<$itemDom.length;i++){
                        if($itemDom[i].id==resultData.id){
                            last=i;
                            break;
                        }
                    }
                    _this.addAnimation($itemDom,last);
                }
                event.stopPropagation();
                return false;
            } else {
                var array = [];
                array[0] = $(this).attr('srcPath');
                _this.bookContainer.insertWidget(array[0],'');

                //监管
                var action = LogManager.action.trigger;
                var params = {};
                params.module = '1130624';
                var user_id = _ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                LogManager.statistics(action,params);
            }

        });
        //付费资源，扣费继续下载(小的资源预览框加入课本按钮)
        $("#preview_payforResources .btn-blue").click(function(){
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            var resultData = _this.recommendItem;
            var last=0;
            var dataIds=[];
            dataIds.push(resultData.id);
            var recommendListOriginData = _this.recommendList.data_origin;
            var $itemDom = _this.common_operate("find",["#recommendList","li"]);
            for(i=0;i<$itemDom.length;i++){
                if($itemDom[i].id==resultData.id){
                    last=i;
                    break;
                }
            }
            // _this.storageDownloading(dataIds,recommendListOriginData,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});//加入下载队列
            // //更新动画
            // _this.addAnimation($itemDom,last);
            var need_credit= parseInt(resultData.exchangeCredit).toFixed(1);//需要积分为正，下载资源扣分设置为负值
            var total_credit=parseInt(resultData.totalCredit).toFixed(1);
            var title= resultData.title;
            var resourceid= resultData.id;
            if(total_credit-need_credit>=0){
                _this.storageDownloading(dataIds,recommendListOriginData,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:resultData.pageIndex,bookCode:_download_bookCode});//加入下载队列
                //更新动画
                _this.addAnimation($itemDom,last);
                var param ={
                    userId:_ebookContext.getUser().getUid(),
                    action:"download",
                    score:-need_credit,
                    resId:resourceid,
                    data:title
                };
                edcService.Instance().ersp_resource_user_credit_update(param).done(function(ret){
                    if(!ret||ret.code!=0){
                        tipsDialog({
                            "id": "uploading" + new Date().getTime(),
                            "content": "资源添加失败"
                        });
                        return;
                    }
                    $("#preview_payforResources").hide();
                    _this.downLoadFile(resultData);
                }).fail(function(err){
                    console.log(err);
                        tipsDialog({
                            "id": "uploading" + new Date().getTime(),
                            "content": "资源添加失败"
                        });
                        return;
                })
            }else{
                $("#preview_payforResources").hide();
            }
        })
        //付费资源：扣费取消下载(小的资源预览框加入课本按钮)
        $("#preview_payforResources .btn-gray").click(function(){//取消按钮
            $("#preview_payforResources").hide();
        })
        $("#preview_payforResources a").click(function(){//右上角的×
            $("#preview_payforResources").hide();
        })

        //付费资源：已扣费，继续下载(小的资源预览框加入课本按钮)
        $("#preview_alreadyPayforResources .btn-blue").click(function(){
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            var resultData = _this.recommendItem;
            var last=0;
            var dataIds=[];
            dataIds.push(resultData.id);
            var recommendListOriginData = _this.recommendList.data_origin;
            var $itemDom = _this.common_operate("find",["#recommendList","li"]);
            for(i=0;i<$itemDom.length;i++){
                if($itemDom[i].id==resultData.id){
                    last=i;
                    break;
                }
            }
            _this.storageDownloading(dataIds,recommendListOriginData,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:resultData.pageIndex,bookCode:_download_bookCode}
            );//加入下载队列
            //更新动画
            _this.addAnimation($itemDom,last);
            $("#smartbar_pop").remove();
            $("#preview_alreadyPayforResources").hide();
            _this.downLoadFile(resultData);
        })
        //付费资源：已扣费，不继续下载(小的资源预览框加入课本按钮)
        $("#preview_alreadyPayforResources .btn-gray").click(function(){//取消按钮
            $("#preview_alreadyPayforResources").hide();
        })
        $("#preview_alreadyPayforResources a").click(function(){//右上角的×
            $("#preview_alreadyPayforResources").hide();
        })

        //控制下载的按钮显示和隐藏
        // $(document).on("click",".fltj_batchAddShow",function () {
        //     _this.controls.recommmendContainer.find(".format-checkbox").show();
        //     _this.controls.recommmendContainer.find(".batchAddControl").show();//加入课本和取消按钮显示
        //     _this.controls.recommmendContainer.find(".fltj_batchAddShow").hide();//批量加入按钮隐藏
        //     $("#recommendList .ckb_box" ).css("display","inherit");
        // });

        //控制下载的按钮显示和隐藏
        $(_this.controls.recommmendContainer).find(".J_open").on("click",function(){
            _this.controls.recommmendContainer.find(".format-checkbox").show();
            _this.controls.recommmendContainer.find(".J_show").toggle();
            _this.controls.recommmendContainer.find(".J_hidden").toggle();
        });

        $(_this.controls.recommmendContainer).find(".J_close").on("click",function(){
            var $itemDom = _this.common_operate("find",["#recommendList","li"]);
            for (var i = 0 ;i < $itemDom.length ; ++i) {
                if (_this.common_operate('find', [$itemDom[i], 'input']).is(":checked")) {
                    //取消下载后，将勾选状态清除
                    $($itemDom[i]).find('input').attr('checked', false).prop("checked", false);
                }
            }
            _this.controls.recommmendContainer.find(".format-checkbox").hide();
            _this.controls.recommmendContainer.find(".J_show").toggle();
            _this.controls.recommmendContainer.find(".J_hidden").toggle();
        });

        //推荐资源批量加入课本（批量下载）
        $(document).on("click","#fltj_batchAdd",function(){
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            var userId = _ebookContext.getUser().getUid();
            $("#smartbar_pop").remove();//移除资源弹框
            var recommendListOriginData = _this.recommendList.data_origin;
            var selectedIds = [],
                selectedRes = [],
                last = 0; //最后选中的列表序号
            var filesInfos = {};

            var $itemDom = _this.common_operate("find",["#recommendList","li"]);
            for (var i = 0 ;i < $itemDom.length ; ++i){
                if(_this.common_operate('find' , [$itemDom[i] , 'input']).is(":checked")){
                    var data_id = _this.common_operate('getAttribute', [$itemDom[i], 'id']);
                    selectedIds.push(data_id);
                    //_this.batchAdd(data_id);
                    _this.batchAdd(data_id, _download_pageIndex);
                    last = i;
                    //选择过后，将选择状态清除将选择状态清除
                    // $($itemDom[i]).find('input').attr('checked', false).prop("checked", false);
                }
            }
            //
            if(selectedIds.length==0){//如果没有勾选资源则结束
                tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "请勾选要加入课本的资源"
                });
                return 0;
            }else{
                shellcmd.checkOnline().done(function(online){
                    if(online){
                        //有付费资源的话，将付费资源放入selectedPayableData中
                        var selectedPayableData=[];
                        for(var i=0;i<selectedIds.length;i++){
                            var resultData= _this.recommendList.data_origin.filter(function(el){
                                return  el.id ==selectedIds[i];
                            });
                            //TODO 开发时使用
                            // resultData[0].payModel=1;
                            // resultData[0].exchangeCredit=2;
                            if(resultData[0].payModel==1&&resultData[0].exchangeCredit!=0){
                                selectedPayableData.push(resultData[0]);
                            }
                        }
                        var dtd = $.Deferred();
                        _this.recommendList.totaldemand_score=0;
                        _this.recommendList.payable_source=[];
                        //先查询付费资源，得到一共未付费的积分数量
                        $.when(_this.getTotalNeedScore(selectedPayableData,0,dtd)).done(function(){
                            if( selectedPayableData.length==0){//没有付费资源
                                //更新动画
                                var $itemDom = _this.common_operate("find",["#recommendList","li"]);
                                _this.addAnimation($itemDom,last);
                                _this.storageDownloading(selectedIds,recommendListOriginData,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});//加入下载队列
                                setTimeout(function(){
                                    $(document).dequeue("selectedIds");
                                },100);
                            }else if(_this.recommendList.totaldemand_score==0){//有付费资源但是所有资源都已经付费
                                $("#batch_alreadyPayforResources").show();
                            }else{//有付费资源且有资源未付费
                                var params = {
                                    userId: userId,
                                };
                                //获得用户现在拥有的积分
                                edcService.Instance().ersp_resource_user_credit_get(params).done(function (ret) {
                                    //用户现在拥有的积分
                                    var total_credit = ret.data.data.toFixed(1);
                                    var need_credit = _this.recommendList.totaldemand_score;
                                    if (total_credit && need_credit) {
                                        $("#batch_payforResources").show();
                                        $("#batch_payforResources .btn-blue").attr("total_credit",total_credit);
                                        if(need_credit-total_credit>0){//需要的积分比总积分多
                                            $("#batch_payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前积分不足";
                                            $("#batch_payforResources .btn-gray").hide();
                                        }else{
                                            $("#batch_payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前有" + total_credit + "积分，确认下载么？";
                                        }
                                    }
                                }).fail(function(err){
                                    console.log(err);
                                });
                            }
                        });
                    }else{
                        //网络异常
                        tipsDialog({
                            "id": "uploadToBeike" + new Date().getTime(),
                            "content": "网络异常"
                        });
                    }
                });
            }
        });

        //去除付费资源中“已付费”的资源，返回还需要付费积分
        recommendresource.prototype.getTotalNeedScore=function(arr,index,deffer){
            var dtd=deffer;
            var _this = this;
            var resultDataArray=arr;
            var index=index;
            if(!resultDataArray[index]){//如果resultDataArray[index]无值，返回
                dtd.resolve();
            }else{
                var userId = _ebookContext.getUser().getUid();
                var paydownloaded = false;
                var params={
                    action:"download",
                    userId:userId,
                    resId:resultDataArray[index].id
                };
                //先查询该用户是否已经对此资源付费
                edcService.Instance().ersp_resource_user_credit_action(params).done(function(ret){
                    paydownloaded = ret.data.data;
                    //TODO 开发时使用
                    // paydownloaded=false;
                    if (paydownloaded == true) {//用户已付费
                    }else{
                        //用户未付费
                        _this.recommendList.totaldemand_score+=resultDataArray[index].exchangeCredit;
                        _this.recommendList.payable_source.push(resultDataArray[index]);
                    }
                    index++;
                    _this.getTotalNeedScore(resultDataArray,index,dtd)
                }).fail(function(err){
                    index++;
                    _this.getTotalNeedScore(resultDataArray,index,dtd)
                })
            }
            return dtd;
        };

        // 逐个资源依次进行扣费（批量下载）
        recommendresource.prototype.deductScore=function(arr,index,deffer){
            var dtd=deffer;
            var resultData=arr;
            if(!resultData[index]){//如果resultData[index]不存在，返回
                dtd.resolve();
            }else{
                var need_credit=resultData[index].exchangeCredit;
                var resourceid=resultData[index].id;
                var title= resultData[index].title;
                var param ={
                    userId:_ebookContext.getUser().getUid(),
                    action:"download",
                    score:-need_credit,
                    resId:resourceid,
                    data:title
                };
                edcService.Instance().ersp_resource_user_credit_update(param).done(function(ret){
                    index++;
                    _this.deductScore(resultData,index,dtd);
                }).fail(function(err){
                    index++;
                    _this.deductScore(resultData,index,dtd);
                })
            }
            return dtd;
        }

        //付费资源，扣费继续下载(批量加入课本)
        $("#batch_payforResources .btn-blue").click(function(){
            $("#batch_payforResources").hide();
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            //逐个资源依次进行扣费，所有资源扣费完成后进行下载
            var need_credit = _this.recommendList.totaldemand_score;
            var total_credit= $("#batch_payforResources .btn-blue").attr("total_credit")
            if(total_credit-need_credit>=0){
                var dtd = $.Deferred();
                var resultData= _this.recommendList.payable_source;
                $.when(_this.deductScore(resultData,0,dtd)).done(function(){
                    //获取选中列表元素id的集合和选中的最下方的元素（动画从最下方元素开始）
                    var selectedIds=[];
                    var last=0;
                    var $itemDom = _this.common_operate("find",["#recommendList","li"]);
                    for (var i = 0 ;i < $itemDom.length ; ++i){
                        if(_this.common_operate('find' , [$itemDom[i] , 'input']).is(":checked")){
                            var data_id = _this.common_operate('getAttribute', [$itemDom[i], 'id']);
                            selectedIds.push(data_id);
                            last = i;
                        }
                    }
                    var recommendListOriginData = _this.recommendList.data_origin;
                    //存储下载队列
                    _this.storageDownloading(selectedIds,recommendListOriginData,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});
                    //更新动画
                    _this.addAnimation($itemDom,last);
                    setTimeout(function(){
                        $(document).dequeue("selectedIds");
                    },100);
                })
            }else{
                $("#batch_payforResources").hide();
                $(document).clearQueue("selectedIds");
            }

        });
        //付费资源：扣费取消下载(批量加入课本)
        $("#batch_payforResources .btn-gray").click(function(){//取消按钮
            $("#batch_payforResources").hide();
            $(document).clearQueue("selectedIds");
        })
        $("#batch_payforResources a").click(function(){//右上角的×
            $("#batch_payforResources").hide();
            $(document).clearQueue("selectedIds");
        })

        //付费资源：已扣费，继续下载(批量加入课本)
        $("#batch_alreadyPayforResources .btn-blue").click(function(){
            $("#batch_alreadyPayforResources").hide();
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            //获取选中列表元素id的集合和选中的最下方的元素（动画从最下方元素开始）
            var selectedIds=[];
            var last=0;
            var $itemDom = _this.common_operate("find",["#recommendList","li"]);
            for (var i = 0 ;i < $itemDom.length ; ++i){
                if(_this.common_operate('find' , [$itemDom[i] , 'input']).is(":checked")){
                    var data_id = _this.common_operate('getAttribute', [$itemDom[i], 'id']);
                    selectedIds.push(data_id);
                    last = i;
                }
            }
            var recommendListOriginData = _this.recommendList.data_origin;
            //更新动画
            _this.addAnimation($itemDom,last);
            //存储下载队列
            _this.storageDownloading(selectedIds,recommendListOriginData,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});
            setTimeout(function(){
                $(document).dequeue("selectedIds");
            },100);
        })
        //付费资源：已扣费，不继续下载(批量加入课本)
        $("#batch_alreadyPayforResources .btn-gray").click(function(){//取消按钮
            $("#batch_alreadyPayforResources").hide();
            $(document).clearQueue("selectedIds");
        })
        $("#batch_alreadyPayforResources a").click(function(){//右上角的×
            $("#batch_alreadyPayforResources").hide();
            $(document).clearQueue("selectedIds");
        })

        //取消批量下载
        // $(document).on("click","#fltj_batchAddCancel",function () {
        //     $("#smartbar_pop").remove();
        //     _this.controls.recommmendContainer.find(".fltj_batchAddShow").show();
        //     _this.controls.recommmendContainer.find(".batchAddControl").hide();
        //     _this.controls.recommmendContainer.find(".format-checkbox").hide();
        //     var recommendListOriginData = _this.recommendList.data_origin;
        //     var selectedIds = [],
        //         selectedRes = [],
        //         last = 0; //最后选中的列表序号
        //     var $itemDom = _this.common_operate("find",["#recommendList","li"]);
        //     for (var i = 0 ;i < $itemDom.length ; ++i) {
        //         if (_this.common_operate('find', [$itemDom[i], 'input']).is(":checked")) {
        //             //取消下载后，将勾选状态清除
        //             $($itemDom[i]).find('input').attr('checked', false).prop("checked", false);
        //         }
        //     }
        //    // $(document).clearQueue("selectedIds");
        // });

        // $("#fltj_batchAddCancel").click(function (){
        //     $("#smartbar_pop").remove();
        //     var loadchecked= $("ul[name=recommendItem] li").find("input");//所有复选框
        //     var loadbtn= $("ul[name=recommendItem] li").find("button");//勾选的待下载资源
        //     for(i=0;i<loadchecked.length; i++){
        //         if ($(loadchecked[i]).is(":checked")) {
        //             $(loadchecked[i]).prop("checked", false);
        //             cancelBatchDownload(loadbtn[i]);
        //         } else {
        //             $(loadchecked[i]).prop("checked", false);
        //         }
        //
        //     }
        //     $(document).clearQueue("batchAddToBook");
        // })

        //查看详情reviewResContent(资源详情框)
        $(document).on("click","#reviewResContent",function(event){

            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'01017',
                type:'trigger',
                bookCode:_ebookContext.curBookCode
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);

            var show_author = $("a[name=auth_name]").html();
            //隐藏弹框
            $("#smallPreviewviewBox").empty();
            var resType_index = $(this).attr("content_li"),
                index = $(this).attr("content_li_a"),
                resultData =_this.recommendList.data[resType_index].data[index];
            resultData.resFrom = "recommend";
            if(resultData.fileurl.lastIndexOf("http")!=0){
                resultData.fileurl=resultData.fileurl.substring(resultData.fileurl.lastIndexOf("http"));
            }
            var param={
                id:resultData.id,
                autov: true
            }
            //get接口添加平台参数 by njfu
            if(json.get_platfrom){
                param.platform = resultData.platForm || "";
            }
            edcService.Instance().ersp_resource_get(param).done(function(ret){
                if(ret.data.data){
                    var ret=ret.data;
                    if(ret.data.thumburl!=null&&ret.data.thumburl!=""){
                        resultData.thumburl = ret.data.thumburl;
                    }
                    resultData.statistics = ret.data.statistics;
                    resultData.screenshots= ret.data.screenshot;
                }
                resultData.origin=_this.recommendList.data_origin;
                resultData.show_author = show_author;
                _resourceContentPage.showResContentPanel(resultData);

            }).fail(function(e){
                //失败处理
                console.log(e);
            });
        });

        //点击资源详情框“相关资源推荐”框内资源触发事件（打开资源详情框）
        // $(document).on("click","li[name=relatedRecommendItem]", function (e) {

        //     var resourceid=$(this).attr("resourceid");
        //     var param={
        //         id:resourceid,
        //         autov: true
        //     }
        //     edcService.Instance().ersp_resource_get(param).done(function(ret){
        //         var resource=_this.recommendList.data_origin.filter(function(el){
        //             return el.id==resourceid;
        //         })[0];
        //         var ret=ret.data;
        //         if(ret.data){
        //             //下面这几行代码都是为了能够复用showResContentPanel方法而做的数据处理
        //             ret.statistics=ret.data.statistics;
        //             ret.screenshots=ret.data.screenshot;
        //             ret.origin=_this.recommendList.data_origin;
        //             ret.title=ret.data.title;
        //             ret.id=ret.data.id;
        //             ret.description=ret.data.description;
        //             ret.length=ret.data.length;
        //             ret.extension=ret.data.extension;
        //             ret.previewurl=ret.data.previewurl;
        //             ret.platForm=ret.data.platForm;
        //             ret.creator=ret.data.creator;
        //             ret.fileurl=ret.data.fileurl;
        //             ret.lastmodify=ret.data.lastmodify;
        //             ret.thumburl=ret.data.thumburl;
        //             ret.payModel=resource && resource.payModel || 0;
        //             ret.exchangeCredit=resource && resource.exchangeCredit || 0;
        //         }else{
        //             ret=_this.recommendList.data_origin.filter(function(el){
        //                 return el.id==resourceid;
        //             })[0];
        //             ret.origin=_this.recommendList.data_origin;
        //         }

        //         _resourceContentPage.showResContentPanel(ret);

        //     }).fail(function(e){
        //         //失败处理
        //         console.log(e);
        //     });
        // });

        //查看评论reviewComments
        $(document).on("click","#reviewComments",function(event){
            var resType_index = $(this).attr("content_li"),
                index = $(this).attr("content_li_a"),
                resultData =_this.recommendList.data[resType_index].data[index];
            resultData.resFrom = "recommend";
            _resourceContentPage.showResContentPanel(resultData);

        })
        //推荐资源----拖拽下载
        $(document).on("dragend","ul[name='recommendItem'] li ,li[name='subjectTemplate'] ",function(e){
            var _that = this;
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            shellcmd.checkOnline().done(function(online){
                if(online){
                    var newWidgetPos = {
                        left : e.originalEvent.clientX,
                        top : e.originalEvent.clientY
                    };
                    var bookRect = document.getElementById("book").getBoundingClientRect();
                    if (newWidgetPos.left < bookRect.left + 10){
                        return;
                    }

                    /* if(e.originalEvent.offsetX < 200){
                     return false;
                     }*/
                    if (!getBlackboardFlag()){
                        var recommendListOriginData = _this.recommendList.data_origin;
                        var $itemDom = _this.common_operate("find",["#recommendList","li"]);
                        var index = $(_that).attr("contend"),
                            resType = $(_that).attr("resType");
                        var userId = _ebookContext.getUser().getUid();
                        var listItem=0;
                        var last=0;
                        var dataIds=[];
                        for(var i in _resTypeArr){
                            if(_resTypeArr[i]==resType) break;
                        }
                        $("li[name='recommendItemLi'] , li[name=subjectTemplate]").find("#smartbar_pop").remove();
                        _this.resetSmartBarEle('resource', i , index);
                        var resultData = _this.recommendList.data[i].data[index];
                        resultData.resFrom = "recommend";
                        resultData.position=newWidgetPos;//这是为了防止过快拖拽时资源重叠
                        if(resultData.fileurl.lastIndexOf("http")!=0){
                            resultData.fileurl=resultData.fileurl.substring(resultData.fileurl.lastIndexOf("http"));
                        }
                        for(i=0;i<$itemDom.length;i++){
                            if($itemDom[i].id==resultData.id){
                                listItem=$itemDom[i];
                                last=i;
                                break;
                            }
                        }
                        dataIds.push(resultData.id);
                        //添加资源下载的当前页码
                        resultData.pageIndex = _download_pageIndex;
                        _this.recommendItem=resultData;

                        //todo 开发使用
                        // resultData.payModel=1;
                        // resultData.exchangeCredit=2;
                        if(resultData.payModel==1&&resultData.exchangeCredit!=0){//需要付费
                            var paydownloaded=false;
                            //先查询该用户是否已经对此资源付费
                            var params={
                                action:"download",
                                userId:userId,
                                resId:resultData.id,
                            };
                            edcService.Instance().ersp_resource_user_credit_action(params).done(function(ret){
                                if(!ret||ret.code!=0){
                                    tipsDialog({
                                        "id": "uploading" + new Date().getTime(),
                                        "content": "资源添加失败"
                                    });
                                    return;
                                }
                                paydownloaded=ret.data.data;
                                //todo 开发使用
                                // paydownloaded=false;
                                if(paydownloaded==true){//用户已付费
                                    $("#preview_alreadyPayforResources").show();
                                }else {//用户未付费
                                    var params = {
                                        userId: userId,
                                    };
                                    //获得用户现在拥有的积分
                                    edcService.Instance().ersp_resource_user_credit_get(params).done(function (ret) {
                                        if(!ret||ret.code!=0){
                                            tipsDialog({
                                                "id": "uploading" + new Date().getTime(),
                                                "content": "资源添加失败"
                                            });
                                            return;
                                        }
                                        //用户现在拥有的积分
                                        var total_credit = ret.data.data.toFixed(1);
                                        var need_credit = resultData.exchangeCredit;
                                        if (total_credit && need_credit) {
                                            if(need_credit-total_credit>0){//需要的积分比总积分多
                                                $("#preview_payforResources").show();
                                                $("#preview_payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前积分不足";
                                                $("#preview_payforResources .btn-gray").hide();
                                            }else{
                                                $("#preview_payforResources").show();
                                                $("#preview_payforResources p")[3].innerHTML = "您勾选的资源需要" + need_credit + "积分，您当前有" + total_credit + "积分，确认下载么？";
                                            }
                                            _this.recommendItem.totalCredit = total_credit;
                                        }
                                    }).fail(function(err){
                                        console.log(err);
                                        tipsDialog({
                                            "id": "uploading" + new Date().getTime(),
                                            "content": "资源添加失败"
                                        });
                                        return;
                                    })
                                }
                            }).fail(function(err){
                                console.log(err);
                                tipsDialog({
                                    "id": "uploading" + new Date().getTime(),
                                    "content": "资源添加失败"
                                });
                            })
                        }else{//不需要付费
                            //双页模式下，判断是否第二页
                            var pageFix = 0;
                            if (_this.bookContainer.getPageViewType() == _define.PageViewType.SimpleDoublePage) {
                                var viewWidth = $("#bookContainer").width();
                                var offetX = resultData.position.left - 204 - viewWidth / 2;
                                if (offetX > 0) {
                                    pageFix = 1;
                                }
                            }
                            //记录下载时页面序号
                            // if(!$.isPlainObject(resultData.extra)){
                            //     resultData.extra = {};
                            // }
                            // resultData.extra._downloadPageIndex = parseInt(_download_pageIndex,10) + parseInt(pageFix,10);

                            resultData && _this.downLoadFile(resultData);
                            _this.storageDownloading(dataIds,recommendListOriginData,'id',{currPageMetadata:_download_currPageMetadata,pageIndex:parseInt(_download_pageIndex,10) + parseInt(pageFix,10),bookCode:_download_bookCode});//加入下载队列
                            //更新动画
                            _this.addAnimation($itemDom,last);
                        }
                    } else {
                        var array = [];
                        array[0] = $(this).attr("srcPath");
                        var $pageItem = $('.pageItem');
                        var isDoublePage = $pageItem.length === 2;
                        var pageindex = 1;
                        var pageScale = _ebookContext.getTransformMatrix($pageItem);
                        var viewWidth =  $("#bookContainer").width();
                        var x, y;
                        if (isDoublePage) {
                            x = (newWidgetPos.left - 70 - viewWidth/2 );
                            //判断是否是第二页
                            if(x>0){
                                x = x / pageScale[0];
                                pageindex = 2;
                            }
                            else{
                                x = (newWidgetPos.left - 70) / pageScale[0];
                            }
                        }
                        else {
                            x = (newWidgetPos.left - 70) / pageScale[0];
                        }
                        y = (newWidgetPos.top - 90) / pageScale[3];
                        _this.bookContainer.insertWidgetWithPos(array[0], [x, y],pageindex, {posType:1});
                    }
                }else{
                    //网络异常
                    tipsDialog({
                        "id": "uploadToBeike" + new Date().getTime(),
                        "content": "网络异常"
                    });
                }
            });
        });

        //分享至畅言云
        $(document).on("click", "#shareToWeb", function(evt){
            var _that = this;
            shellcmd.checkOnline().done(function(ret){
                if(!ret){
                    $.Zebra_Dialog("请先连接网络！", {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [ AppTips.OkTips],
                        'zIndex': 1000
                    });
                    return;
                }
                else{
                    var resType_index = $(_that).attr("content_li"),
                        index = $(_that).attr("content_li_a"),
                        resultData = _this.recommendList.data[resType_index].data[index],
                        type = resultData.extension,
                        previewurl = resultData.previewurl;
                    resultData.resFrom = "recommend";
                    resultData.type='4';
                    _this.shareResToCloud(resultData);
                }
            });
        });

        $(document).on('mouseover',".format-bignumber", function(event){
            var isHavingClass = _mainToolbar.getIsHavingClass();
            var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
            // 当前频道
            var channel_cur = '';
            if(!$("#J_selected").hasClass('btn-tabactive')){
                channel_cur = $("#J_recommend").attr("content") || '';
            }

            if(!isHavingClass && !isTeachingPackage && (-1 != $.inArray(channel_cur.toLocaleLowerCase(),['yun','xiaoben']))) {
                var _dom = $(this).parent();
                var widgetId = _dom.attr("id");
                var resId;

                if (widgetId) {
                    var widgetArr = _this.bookContainer.getCurrentPageRes();
                    var findWidget = widgetArr.filter(function (el) {
                        return el.Id == widgetId;
                    })
                    if (findWidget.length > 0) {
                        var targetWidget = findWidget[0];
                        resId = targetWidget.resourceId;
                        if (resId) {
                            var recommendData = _this.recommendList.data_origin;
                            var findList = recommendData.filter(function(el){
                                return el.id == resId;
                            });
                            if(findList.length > 0){
                                var Obj = _ebookContext.getUnTransForm();
                                _dom.find(".format-bignumber").css("-webkit-transform", "matrix(" + (1 * Obj.wZoom) / (Obj.wZoom * 0.7) + ", 0, 0, " + (1 * Obj.hZoom) / (Obj.hZoom * 0.7) + ", 0, 0)");
                                switch(channel_cur.toLocaleLowerCase()){
                                    case 'yun':
                                        _this.controls.recommmendContainer.find("#" + resId).css({
                                            'color': '#4b99f0',
                                            'background': '#e9eff2'
                                        });
                                        break;
                                    case 'xiaoben':
                                        _this.controls.recommmendContainer.find("#" + resId).css({
                                            'color': '#4b99f0',
                                            'background': '#e9eff2'
                                        });
                                        break;
                                }
                                return false;
                            }
                        }
                    }
                }
            }
        }).on('mouseout',".format-bignumber", function(event){
            var isHavingClass = _mainToolbar.getIsHavingClass();
            var isTeachingPackage=_mainToolbar.getIsTeachingPackage();
            // 当前频道
            var channel_cur = '';
            if(!$("#J_selected").hasClass('btn-tabactive')){
                channel_cur = $("#J_recommend").attr("content") || '';
            }
            if(!isHavingClass && !isTeachingPackage && (-1 != $.inArray(channel_cur.toLocaleLowerCase(),['yun','xiaoben']))) {
                var _dom = $(this).parent();
                var widgetId = _dom.attr("id");
                var resId;

                if (widgetId) {
                    var widgetArr = _this.bookContainer.getCurrentPageRes();
                    var findWidget = widgetArr.filter(function (el) {
                        return el.Id == widgetId;
                    })
                    if (findWidget.length > 0) {
                        var targetWidget = findWidget[0];
                        resId = targetWidget.resourceId;
                        if (resId) {
                            var Obj = _ebookContext.getUnTransForm();
                            _dom.find(".format-bignumber").css("-webkit-transform", "matrix(1, 0, 0, 1, 0, 0)");
                            switch(channel_cur.toLocaleLowerCase()){
                                case 'yun':
                                    _this.controls.recommmendContainer.find("#" + resId).removeAttr("style");
                                    break;
                                case 'xiaoben':
                                    _this.controls.recommmendContainer.find("#" + resId).removeAttr("style");
                                    break;
                            }
                            return false;
                        }
                    }
                }
            }
        });
    };


   // prepareLocalContent     localresource
     //   prepareCloudContent cloudresource
    //var prepareCloudContent=$(document).find("#prepare-cloud-content li");
    //var prepareLocalContent=$(document).find("#prepare-local-lontent");
  // var prepareLocalContent= _preparereRes.controls.prepareLocalContent;
  //  var prepareCloudContent= _preparereRes.controls.prepareCloudContent;
//var cloudItemLi=$(prepareCloudContent).find("li[name='recommendItemLi']");
    //$(document).on("dragend","li[name='recommendItemLi'] ,li[name='subjectTemplate'] ",function(e){
    //    $(document).on("dragend","#prepare-cloud-content li[name='recommendItemLi'],#prepare-local-content li[name='recommendItemLi']",function(e){
    //    newWidgetPos = {
    //        left : e.originalEvent.clientX,
    //        top : e.originalEvent.clientY
    //    }
    //    if (!getBlackboardFlag()){
    //        var _that = this;
    //       // var index = $(_that).attr("contend"),
    //            resType = $(_that).attr("resType");
    //        for(var i in _resTypeArr){
    //            if(_resTypeArr[i]==resType) break;
    //        }
    //        $("li[name='recommendItemLi'] , li[name=subjectTemplate]").find("#smartbar_pop").remove();
    //        //_this.resetSmartBarEle('resource', i , index);
    //        var resultData = _this.recommendList.data[i].data[index];
    //        resultData.resFrom = "recommend";
    //        console.log(resultData);
    //        resultData && _this.downLoadFile(resultData);
    //    } else {
    //        var array = [];
    //        array[0] = $(this).attr("srcPath");
    //        var $pageItem = $('.pageItem');
    //        var isDoublePage = $pageItem.length === 2;
    //        var pageindex = 1;
    //        var pageScale = _ebookContext.getTransformMatrix($pageItem);
    //        var viewWidth =  $("#bookContainer").width();
    //        var x, y;
    //        if (isDoublePage) {
    //            x = (newWidgetPos.left - 70 - viewWidth/2 );
    //            //判断是否是第二页
    //            if(x>0){
    //                x = x / pageScale[0];
    //                pageindex = 2;
    //            }
    //            else{
    //                x = (newWidgetPos.left - 70) / pageScale[0];
    //            }
    //        }
    //        else {
    //            x = (newWidgetPos.left - 70) / pageScale[0];
    //        }
    //        y = (newWidgetPos.top - 90) / pageScale[3];
    //        console.log(x, y);
    //        console.log(newWidgetPos.left, newWidgetPos.top);
    //        _this.bookContainer.insertWidgetWithPos(array[0], [x, y],pageindex, '');
    //    }});

    // recommendresource.prototype.addAnimation=function(downloadIds,last,recommendListData){
    //     var _this=this;
    //
    //     //更新动画
    //     _this.maskLayerAnimate($(downloadIds[last]),$("#J_teaching_package"),"assert/images/20_downloading.png",function(){
    //         if($(_this.controls.teachingPackageContainer).find("ul").length <= 0){
    //             //为空时创建元素
    //             $(_this.controls.teachingPackageContainer).html("").append("<ul></ul>");
    //             $(_this.controls.teachingPackageContainer).find("ul").addClass("resource-list");
    //         }
    //         var downloadingObj = JSON.parse(localStorage.getItem("recommend_download"));
    //         // _this.renderDownloadingFiles(downloadingObj.downloading,$(_this.controls.teachingPackageContainer).find("ul"),"afterClass");
    //     });
    // }



    recommendresource.prototype.batchAdd=function(downloadDataID, pageIndex) {
         var _this = this;
        var _thatID = downloadDataID;
        var resultData= _this.recommendList.data_origin.filter(function(el){
            return  el.id ==_thatID;
        });
        $(document).queue("selectedIds",function(){
            // $("#smartbar_pop").remove();

           /* if(resultData[0].fileurl.lastIndexOf("http")!=0){
                resultData[0].fileurl=resultData[0].fileurl.substring(resultData[0].fileurl.lastIndexOf("http"));
            }*/
            //添加当前页码，防止翻页导致下载位置错误
            resultData[0].pageIndex = pageIndex;

            if (!getBlackboardFlag()) {
                resultData[0].resFrom = "recommend";
                console.log(resultData);
                resultData && _this.downLoadFile(resultData[0]);
            }
       });
    }

    //   //取消批量下载函数
    recommendresource.prototype.cancelBatchDownload=function(cancelDataID){
        var _this = this;
        //var resId=$(cancelBtn).parents("li").attr("id");
        var resId=cancelDataID;
        shellcmd.cancleDownload(resId).done(function (ret) {
            // $("#recommendList").find("#" + resId).find("div[name='downloadGroup']").remove();//删除资源进度条，已不需要
            // $("#" + resId).find("p").show();
            event.stopPropagation();
        });
        event.stopPropagation();
    }

    /**
     * smartBar 重置显示或隐藏状态
     * @param ele
     */
    recommendresource.prototype.resetSmartBarEle = function (ele) {
        for (var i in this.showStatus) {
            if (i == ele) {
                if (typeof this.showStatus[i] == 'object') {
                    for (var j = 0, length = this.showStatus[i].length; j < length; j++) {
                        if (arguments[1] == j) {
                            this.showStatus[i][j][arguments[2]] = !this.showStatus[i][j][arguments[2]];
                        } else {
                            this.showStatus[i][j][arguments[2]] = false;
                        }
                    }
                } else {
                    this.showStatus[i] = !this.showStatus[i];
                }
            } else {
                if (typeof this.showStatus[i] == 'object') {
                    for (j = 0, length = this.showStatus[i].length; j < length; j++) {
                        this.showStatus[i][j][arguments[2]] = false;
                    }
                } else {
                    this.showStatus[i] = false;
                }
            }
        }
    };

    /**
     * 资源返回列表进行排序
     * 按照【课件--教案--习题--素材】的顺序排序      --新增两个类型【课件--教案--导学案--微课--习题--素材】
     * @param result
     */
    recommendresource.prototype.setOrderRecommendList = function (result) {
        var _this = this;
        var total = result.total;
        var _result = {
            data: [],
            total: total
        }
        result = result.data;
        for (var i in _resTypeArr) {
            for (var j in result) {
                if (result[j].type == _resTypeArr[i]) {
                    _result.data.push(result[j]);
                }
            }
        }
        _this.recommendList.data = _result.data;
        for (var i = 0; i < result.length; i++) {
            var data = result[i].data;
            var tempArr = [];
            for (var j = 0; j < data.length; j++) {
                tempArr.push(false);
            }
            _this.showStatus.resource.push(tempArr);
        }
        _this.setRecommendResItem(_this.recommendList.data, _this.showStatus.resource);
    };

    //取得用户选择的数据项
    recommendresource.prototype.getSelectedRecommendItems = function($dom,loopDom){
        var $dom = $($dom),
            loopDom = loopDom;
        var flag = false;
        var $item = $dom.find(loopDom);
        for (var i = 0; i < $item.length; ++i) {
            if ($($item[i]).find('input').attr("checked") == "checked") {
                flag = true;
                break;
            }
        }
        if (flag == false) {
            pageMyPrepare.showCommonTip("请选择要" + specialContent + "的课件", false);
        } else {
            callback && callback();
        }

    };

    exports.Instance = new recommendresource();
})
