define(function (require, exports) {
    require('jquery');
    var _resAccessor = require('./resaccessor').Instance,
        _pptIcwsAccessor = require('./ppticwsaccessor').Instance,
        _resTool = require('./restool'),
        _cloudresourceBase = require('./cloudresourcebase'),
        _recommendResUrl = AppRemoteSvcCfg.ResBatch,
        _ebookContext = require('../../ebookcontext').Instance,
        path = require('../../../common/path'),
        _resourceContentPage = require('./resourcecontent').Instance,
        shellcmd = require('../../../common/shellcmd'),
        _child_process = nodereq("child_process"),
        fs = nodereq("fs");

    var currentDArr = "null";


    function prepareResource(){
        var _this = this;
        _this.buttons = {};
        _this.controls = {};
        //备课本展示到页面的数据
        _this.lesssonPrepares = {
            "local":{
                count:0,
                origin:[],
                data:[]
            },
            "cloud":{
                count:0,
                origin:[],
                data:[]
            },
            "edc_cloud":{
                count:0,
                origin:[],
                data:[]
            }
        };
        //备课本文件操作状态
        _this.filestatus = {
            "upload" : {
                "count" : 0,
                "origin" : [],
                "success":{
                    "origin" : []
                },
                "error":{
                    "origin" : []
                }
            },
            "edc_delete" : {
                "count" : 0,
                "origin" : [],
                "success":{
                    "origin" : []
                },
                "error":{
                    "origin" : []
                }
            },
            "local_delete" : {
                "count" : 0,
                "origin" : [],
                "success":{
                    "origin" : []
                },
                "error":{
                    "origin" : []
                }
            },
            "cloud_delete" : {
                "count" : 0,
                "origin" : [],
                "success":{
                    "origin" : []
                },
                "error":{
                    "origin" : []
                }
            },
            "download" : {
                "count" : 0,
                "origin" : [],
                "success":{
                    "origin" : []
                },
                "error":{
                    "origin" : []
                }
            },
            "to_book" : {
                "count" : 0,
                "origin" : [],
                "success":{
                    "origin" : []
                },
                "error":{
                    "origin" : []
                }
            },
            "import" : {
                "count" : 0,
                "origin" : [],
                "success":{
                    "origin" : []
                },
                "error":{
                    "origin" : []
                }
            },
            "export" : {
                "count" : 0,
                "origin" : [],
                "success":{
                    "origin" : []
                },
                "error":{
                    "origin" : []
                }
            }
        };

        //重置备课本文件操作状态
        _this.clearFileStauts = function(action) {
            if(-1 != $.inArray(action,["upload","download","import","exprot","edc_delete","local_delete","cloud_delete","to_book"])) {
                _this.filestatus[action] = {
                    "count" : 0,
                    "origin" : [],
                    "success":{
                        "origin" : []
                    },
                    "error":{
                        "origin" : []
                    }
                };
            }
        }
    }

    prepareResource.prototype = new _cloudresourceBase();
    /**
     * 初始化
     * @param bookContainer
     */
    prepareResource.prototype.init = function(bookContainer,buttons, controls){
        var _this = this;
        _this.bookContainer = bookContainer;
        _this.buttons = {
            selectedBtn: $("#J_selected"),
            recommmendBtn: $("#J_recommend"),
            lessonPrepareBtn: $("#J_lessonprepare"),
            localPrepareBtn: $("#J_localprepare"),
            cloudPrepareBtn: $("#J_cloudprepare")
        };
        _this.controls = {
            tabBar: $(".J_resource_center_bar .tabbar"),
            selectedContainer: $(".J_selected_content"),
            recommmendContainer: $(".J_recommend_content"),
            lessonPrepareContainer: $(".J_lesssonprepare_content"),
            localPrepareContainer: $(".J_localprepare_content"),
            cloudPrepareContainer: $(".J_cloudprepare_content"),
            teachingPackageContainer: $(".J_teaching_package_content"),
            cloudPreparePreview: $("#smartbar_preview")
        };
        _this.registerEvent();
    };

    prepareResource.prototype.checkDbExist = function(){
        var _this =  this;
        var def = $.Deferred();
        var userDbFullPath = _ebookContext.getUser().getUserPpticwsBasePath() + '/' + 'file.db';
        //判断本地数据库是否存在
        _this.existDbFile(userDbFullPath).done(function(ret){
            if(ret == false){
                _this.copyTemplateDb(_ebookContext.getUser().getUserPpticwsBasePath()).done(function(ret2){
                    //拷贝模板数据库成功
                    def.resolve(ret2);
                });
            } else {
                def.resolve(ret);
            }
        });
        return def.promise();
    };

    //备课本(本地)
    prepareResource.prototype.getLocalLessonPrepares = function(){
        var _this = this;
        _this.controls.lessonPrepareContainer.find(".J_show").hide();
        // _this.controls.lessonPrepareContainer.find(".J_local").show();
        _this.controls.lessonPrepareContainer.find(".J_hidden").hide();
        //数据加载中提示
        var info = {
            "status" : "resource_loading",
            "tips" : "数据加载中...",
            "from" : "prepare"
        };
        _this.renderResStatus($(_this.controls.localPrepareContainer),info);
        var keys = ["bookcode" , "unit1" , "unit2" , "unit3" , "unit4"];
        var vals = [];
        var pageMeta = _this.bookContainer.getCurrPageMetadata();
        vals.push((_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.bookCode) || "");
        vals.push(pageMeta.unit1 || "");
        vals.push(pageMeta.unit2 || "");
        vals.push(pageMeta.unit3 || "");
        vals.push(pageMeta.unit4 || "");
        if(json.TP.useDb) {
            _this.callSearchPreIndex(pageMeta).done(function(ret3){
                var preData = ret3.data || [];
                //过滤文件夹
                preData = preData.filter(function(el){
                    return el.isDir != 1;
                })
                //过滤文件夹
                _this.lesssonPrepares.local.count = preData.length;
                _this.lesssonPrepares.local.origin = preData;
                _this.lesssonPrepares.local.data = _resAccessor.parseLocalLessonPrepares_ext(preData);
                //展示数据
                if(!$(_this.controls.localPrepareContainer).is(":hidden")) {
                    _this.setPrepareResItem(_this.lesssonPrepares.local.data, "local");
                }
            }).fail(function(e){
                if(!$(_this.controls.localPrepareContainer).is(":hidden")) {
                    var info = {
                        "status": "request_error",
                        "tips": "数据请求失败",
                        "from": "prepare"
                    };
                    _this.renderResStatus(_this.controls.localPrepareContainer, info);
                }
            });
        }else{
            _this.checkDbExist().done(function (ret2) {
                //请求本地数据库接口
                _pptIcwsAccessor.selectInfo(keys, vals).done(function (ret) {
                    //反转数据
                    // _resAccessor.reverseData(_pptIcwsAccessor.allInfo).done(function(ret2){
                    //
                    // }).fail(function(e){
                    //     console.log(e);
                    // });
                    _this.lesssonPrepares.local.count = ret.length;
                    _this.lesssonPrepares.local.origin = ret;
                    _this.lesssonPrepares.local.data = _resAccessor.parseLocalLessonPrepares(ret);
                    //展示数据
                    if (!$(_this.controls.localPrepareContainer).is(":hidden")) {
                        _this.setPrepareResItem(_this.lesssonPrepares.local.data, "local");
                    }
                }).fail(function (e) {
                    if (!$(_this.controls.localPrepareContainer).is(":hidden")) {
                        var info = {
                            "status": "request_error",
                            "tips": "数据请求失败",
                            "from": "prepare"
                        };
                        _this.renderResStatus(_this.controls.localPrepareContainer, info);
                    }
                });
            });
        }
    };

    prepareResource.prototype.callSearchPreIndex = function(units){
        var _this = this;
        var def = jQuery.Deferred();
        units = units || {};
        var unit1 = units.unit1 || '',
            unit2 = units.unit2 || '',
            unit3 = units.unit3 || '',
            unit4 = units.unit4 || '';
        var condition = {
            method:'searchPreIndex',
            data: {
                userName: _ebookContext.getUser().getName(),
                bookCode: (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.bookCode) || "",
                unit1: unit1,
                unit2: unit2,
                unit3: unit3,
                unit4: unit4
            }
        };
        console.log(condition);
        hproseClient.hproseCall(condition,function(ret){
            console.log(ret);
            if(ret && ret.code == 1){
                def.resolve(ret);
            }else{
                def.reject(ret);
            }
        },function(e){
            console.error(e);
            def.reject(e);
        });
        return def.promise();
    };

    //备课本(本地)-数据删除
    //eg>deleteFileIds [timestamp1[,timestamp2,...]]
    prepareResource.prototype.deleteLocalLessonPrepares = function(deleteFileIds){
        var _this = this;
        var fileIds = [],
            filesCount = 0;
        var fileIds = deleteFileIds,
            filesCount = fileIds.length;

        //记录状态
        _this.filestatus.local_delete.count = filesCount;
        _this.filestatus.local_delete.origin = fileIds;

        //delete_before();
        for(i = 0;i < filesCount;i++) {
            (function(index){
                setTimeout(function(){
                    delete_item(fileIds[index],index).done(function(rs){
                        var rs = {
                            "code" : "0",
                            "message" : "delete this["+ index +"] success",
                            "index" : index
                        };
                        delete_process(rs);
                    }).fail(function(e){
                        var rs = e;
                        delete_process(rs);
                    });
                });
            })(i);
        }

        var delete_item = function(fileId,index) {
            var def = $.Deferred();
            var fileId = fileId;

            //删除文件
            dele_physic(fileId).done(function (ret) {
                var path = ret;
                //删除数据记录
                _pptIcwsAccessor.deleteInfo(fileId).done(function () {
                    def.resolve();
                }).fail(function(e){
                    var rs = {
                        "code" : "1",
                        "message" : "delete db record error",
                        "index" : index
                    };
                    def.reject(rs);
                });
            }).fail(function(e){
                var rs = {
                    "code" : "1",
                    "message" : e.message,
                    "index" : index
                };
                def.reject(rs);
            });
            return def.promise();
        };
        //删除物理文件
        var dele_physic = function(fileId){
            var def = $.Deferred();
            var baseFolder = _ebookContext.getUser().getUserPpticwsBasePath();
            shellcmd._rmdirASync_ext(baseFolder + '/' + fileId, function(path){
                def.resolve(path);
                //刷新视图
            },function(e){
                switch (e.code) {
                    //删除文件夹失败
                    case "ENOTEMPTY":
                        var rs = {
                            "code" : "1",
                            "message" : "delete physic file[folder] error",
                            "index" : fileId
                        };
                        def.reject(rs);
                        //刷新视图
                        break;
                    //删除文件失败
                    case "EBUSY":
                        var rs = {
                            "code" : "1",
                            "message" : "delete physic file[busy] error",
                            "index" : fileId
                        };
                        def.reject(rs);
                        //刷新视图
                        break;
                    default:
                        //异常情况，保证页面允许继续操作
                        var rs = {
                            "code" : "1",
                            "message" : "delete physic file[unknow] error",
                            "index" : fileId
                        };
                        def.reject(rs);
                        break;
                }
            });
            return def.promise();
        };
        //删除前回调
        var delete_before = function(){};
        //删除全都完成后回调
        var delete_after = function(){
            var successRes = _this.filestatus.local_delete.success.origin;
            var errorRes = _this.filestatus.local_delete.error.origin;
            if(successRes.length < 1) {
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "文件删除失败"
                });
            }
            if(successRes.length > 0 && errorRes.length >0) {
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "已删除" + successRes.length + "个资源,删除失败" + errorRes.length + "个资源"
                });
            }
            if(successRes.length >= 1 && errorRes.length == 0){
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "文件删除成功"
                });
            }
            //清空队列信息
            _this.clearFileStauts("local_delete");
        };
        //删除中回调
        var delete_process = function(rs){
            var index = rs && rs.index;
            var code = rs && rs.code;
            //记录状态
            if(code == "0") {
                _this.filestatus.local_delete.success.origin.push(fileIds[index]);
            } else {
                _this.filestatus.local_delete.error.origin.push(fileIds[index]);
            }

            if(_this.filestatus.local_delete.success.origin.length + _this.filestatus.local_delete.error.origin.length >= filesCount) {
                delete_after();
            }
            //刷新数据
            _this.getLocalLessonPrepares();
        };
    };

    //备课本(云端)-数据删除
    prepareResource.prototype.deleteCloudLessonPrepares = function(deleteFileIds){
        var _this = this;
        var fileIds = [],
            filesCount = 0;
        var fileIds = deleteFileIds,
            filesCount = fileIds.length;

        //记录状态
        _this.filestatus.cloud_delete.count = filesCount;
        _this.filestatus.cloud_delete.origin = fileIds;

        //delete_before();
        for(i = 0;i < filesCount;i++) {
            (function(index){
                setTimeout(function(){
                    delete_item(fileIds[index],index).done(function(rs){
                        var rs = {
                            "code" : "0",
                            "message" : "delete this["+ index +"] success",
                            "index" : index
                        };
                        delete_process(rs);
                    }).fail(function(e){
                        var rs = {
                            "code" : "1",
                            "message" : "error",
                            "index" : index
                        };
                        delete_process(rs);
                    });
                });
            })(i);
        }

        var delete_item = function(fileId,index) {
            var def = $.Deferred();
            var fileId = fileId;
            var openId = "";
            _this.getUserInfo("id",_ebookContext.getUser().getUid()).done(function(ret) {
                //取得用户opendId
                if (!ret) {
                    console.log("请求用户信息失败");
                    return;
                }
                openId = ret.data.id;
                var param = {
                    openId : openId,
                    fileId : fileId
                };
                //删除记录
                edcService.Instance().beike_file_delete(param).done(function(ret){
                    def.resolve();
                }).fail(function (e) {
                    var rs = {
                        "code" : "1",
                        "message" : "call api error",
                        "index" : index
                    };
                    def.reject(rs);
                });
            }).fail(function(e){
                var rs = {
                    "code" : "1",
                    "message" : "get user openId error",
                    "index" : index
                };
                def.reject(rs);
            });
            return def.promise();
        };

        //删除前回调
        var delete_before = function(){};
        //删除全都完成后回调
        var delete_after = function(){
            var successRes = _this.filestatus.cloud_delete.success.origin;
            var errorRes = _this.filestatus.cloud_delete.error.origin;
            if(successRes.length < 1) {
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "文件删除失败"
                });
            }
            if(successRes.length > 0 && errorRes.length >0) {
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "已删除" + successRes.length + "个资源,删除失败" + errorRes.length + "个资源"
                });
            }
            if(successRes.length >= 1 && errorRes.length == 0){
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "文件删除成功"
                });
            }
            //清空队列信息
            _this.clearFileStauts("cloud_delete");
            //刷新数据
            _this.getEdcCloudLessonPrepares();
        };
        //删除中回调
        var delete_process = function(rs){
            var index = rs && rs.index;
            var code = rs && rs.code;
            //记录状态
            if(code == "0") {
                _this.filestatus.cloud_delete.success.origin.push(fileIds[index]);
            } else {
                _this.filestatus.cloud_delete.error.origin.push(fileIds[index]);
            }

            if(_this.filestatus.cloud_delete.success.origin.length + _this.filestatus.cloud_delete.error.origin.length >= filesCount) {
                delete_after();
            }
        };
    };

    //备课本(云端)
    //该模块废弃了，因为云备课本接口换了
    prepareResource.prototype.getCloudLessonPrepares = function(){
        var _this = this;
        //取得筛选条件
        var pageMeta = _this.bookContainer.getCurrPageMetadata();
        var requestBeikes = {
            "uid":_ebookContext._curUser._uid
        };
        var requestFiles = {
            "uid": _ebookContext._curUser._uid,
            "bookcode": (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.bookCode) || "",
            "unit" : pageMeta.unit1,
            "course" : pageMeta.unit2,
            "page" : 1,
            "limit" : 999999
            // type:"ppt,pptx,icw"
        };
        //取得所有的备课本并拉取备课本列表数据
        _resAccessor.api_pan_beike_list(requestBeikes).done(function(ret){
            //判断云端是否存在备课本
            var beikeId = _resAccessor.isExistCloudBeikeId(requestFiles.bookcode,ret);
            if(beikeId) {
                requestFiles.beikeId = beikeId;
                _resAccessor.api_pan_beike_file_list(requestFiles).done(function(ret2){
                    _this.lesssonPrepares.cloud.count = ret2.total;
                    _this.lesssonPrepares.cloud.origin = ret2;
                    _this.lesssonPrepares.cloud.data = _resAccessor.parseCloudLessonPrepares(ret2.data);
                    //展示数据
                    _this.setPrepareResItem(_this.lesssonPrepares.cloud, "cloud");
                    //备课本数据列表
                }).fail();
            } else {
                //没有这个备课本，异常处理
                _this.controls.cloudPrepareContainer.text("该课本还没有创建备课本");
                console.log("该课本还没有创建备课本");
                return;
            }
        }).fail(function(e){
            console.log(e);
        });
    };

    //备课本列表（云端EDC）
    prepareResource.prototype.getEdcCloudLessonPrepares = function(){
        var _this = this;
        _this.controls.lessonPrepareContainer.find(".J_show").hide();
        // _this.controls.lessonPrepareContainer.find(".J_cloud").show();
        _this.controls.lessonPrepareContainer.find(".J_hidden").hide();
        // _this.controls.cloudPrepareContainer.find(".format-checkbox").hide();
        //数据加载中提示
        var info = {
            "status" : "resource_loading",
            "tips" : "数据加载中...",
            "from" : "prepare"
        };
        _this.renderResStatus($(_this.controls.cloudPrepareContainer),info);

        //取得筛选条件
        var pageMeta = _this.bookContainer.getCurrPageMetadata();
        var openId = "";
        shellcmd.checkOnline().done(function(ret) {
            if (!ret) {
                if(!$(_this.controls.cloudPrepareContainer).is(":hidden")) {
                    var info = {
                        "status": "net_error",
                        "tips": "网络异常",
                        "from": "prepare"
                    };
                    _this.renderResStatus(_this.controls.cloudPrepareContainer, info);
                }
                return;
            }
            //请求用户信息
            _this.getUserInfo("id", _ebookContext.getUser().getUid()).done(function (ret) {
                //取得用户opendId
                if (!(ret && ret.data && ret.data.id)) {
                    console.log("请求用户信息失败");
                    if(!$(_this.controls.cloudPrepareContainer).is(":hidden")) {
                        var info = {
                            "status": "request_error",
                            "tips": "网络请求失败",
                            "from": "prepare"
                        };
                        _this.renderResStatus(_this.controls.cloudPrepareContainer, info);
                    }
                    return;
                }
                openId = ret.data.id;
                var requestFiles = {
                    openId: openId,
                    page: 1,
                    limit: 9999,
                    order: "3", //排序方法（1: 修改时间，2:名称(utf8字符顺序) 3:创建时间）
                    type: "",
                    book: (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.bookCode) || "",
                    unit1: pageMeta.unit1,
                    unit2: pageMeta.unit2,
                    unit3: pageMeta.unit3,
                    unit4: pageMeta.unit4,
                    name: "",
                    year: "",
                    month: ""
                };
                //取得备课本列表数据
                edcService.Instance().beike_file_list(requestFiles).done(function (ret) {
                    if (ret.code == 0) {
                        //过滤mtbk文件
                        if(ret && ret.data.fileList && ret.data.fileList.length > 0){
                            ret.data.fileList = ret.data.fileList.filter(function(el){
                                return el.extension != 'mtbk';
                            });
                        }
                        _this.lesssonPrepares.edc_cloud.count = ret.data.total;
                        _this.lesssonPrepares.edc_cloud.origin = ret.data.fileList;
                        _this.lesssonPrepares.edc_cloud.data = ret.data.fileList;
                        //展示数据
                        if(!$(_this.controls.cloudPrepareContainer).is(":hidden")) {
                            _this.setPrepareResItem(_this.lesssonPrepares.edc_cloud.data, "edc_cloud");
                        }
                    } else {
                        //接口返回错误
                        if(!$(_this.controls.cloudPrepareContainer).is(":hidden")) {
                            console.log("数据错误:" + ret.code + "|" + ret.message + "|" + ret.solution);
                            var info = {
                                "status": "request_error",
                                "tips": "网络请求失败",
                                "from": "prepare"
                            };
                            _this.renderResStatus(_this.controls.cloudPrepareContainer, info);
                        }
                    }
                }).fail(function (e) {
                    if(!$(_this.controls.cloudPrepareContainer).is(":hidden")) {
                        var info = {
                            "status": "request_error",
                            "tips": "网络请求失败",
                            "from": "prepare"
                        };
                        _this.renderResStatus(_this.controls.cloudPrepareContainer, info);
                    }
                });
            }).fail(function(e){
                if(!$(_this.controls.cloudPrepareContainer).is(":hidden")) {
                    var info = {
                        "status": "request_error",
                        "tips": "网络请求失败",
                        "from": "prepare"
                    };
                    _this.renderResStatus(_this.controls.cloudPrepareContainer, info);
                }
            });
        });
    };

    prepareResource.prototype.downladEdcCloudLessonPrepares = function(obj){
        var _this = this;
        var filesInfos=[];
        obj = obj || {};

        var id = obj.fid;
        var uid = obj.uid;
        var fid = obj.fid;
        var aliasName = obj.aliasName || "";
        var file = obj.fileName || "";
        var parsedFile = _resTool.parseFileName(file);
        var fileName = parsedFile.fileName;
        var extension = obj.extension || "";
        var size = obj.length || "";
        var author = obj.uid || "";
        var fromApp = obj.fromApp || "";
        var thumbnail=obj.thumbPath;
        var platForm=obj.platForm;

        filesInfos[id] = {};
        filesInfos[id].thumburl =thumbnail;
        filesInfos[id].platForm =platForm;
        filesInfos[id].fileName = fileName;
        filesInfos[id].fileExt = extension;
        filesInfos[id].fileSize = size;
        filesInfos[id].author = author;
        filesInfos[id].from = fromApp;

        var pageIndex = _this.bookContainer.getPageIndex();
        //添加资源下载的当前页码
        obj.pageIndex = pageIndex;
        //将预览窗口名改为资源名
        var title = '';
        obj.title ? (title = obj.title) : (title = '资源预览');
        _this.controls.cloudPreparePreview.find('#previewWinTitle').get(0).innerHTML = title;

        _this.controls.cloudPreparePreview.find('.smartbar_addtobook_btn').text('加入课本');
        _this.controls.cloudPreparePreview.find('.smartbar_addtobook_btn').attr('title', '加入课本');

        _this.controls.cloudPreparePreview.css({
            position: 'absolute',
            left: ($(window).width()+204 - this.preview.outerWidth()) /2,
            top: ($(window).height() - 558) / 2,
            "z-index": 550
        });

        _this.controls.cloudPreparePreview.draggable({
            handle: _this.controls.cloudPreparePreview.find('.smartbar_preview_tit'),
            containment: $("#bookContainer")
        });

        _this.controls.cloudPreparePreview.find(".smartbar_preview_repository_close").click(function () {
            _this.controls.cloudPreparePreview.hide();
            _this.controls.cloudPreparePreview.parent().hide();
            ////左右箭头全局设置,设置为true，表示左右箭头不再翻页
            global_flag = false;
            //解决关闭预览界面后音频仍有可能继续播放的bug，貌似没有stop方法，这里用pause也没有什么影响。
            if ($("#audioId").get(0)) {
                $("#audioId").get(0).pause();
            }
        });

        //绑定事件
        _this.controls.cloudPreparePreview.find('.smartbar_addtobook_btn').unbind('click').bind('click', function () {
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            setTimeout(function () {
                _this.controls.cloudPreparePreview.parent().hide();
            }, 100);

            _this.getPanFilesDownloadUrl(fid).done(function (ret) {//获取下载地址
                if(!ret||ret==""||ret.code!=0){
                    tipsDialog({
                        "id": "uploading" + new Date().getTime(),
                        "content": "资源添加失败"
                    });
                    return 0;
                }else {
                    var downloadFiles = [];
                    var fileId = fid;
                    downloadFiles.push({
                        "fileId": fileId,
                        "fileName": filesInfos[fileId] && filesInfos[fileId].fileName,
                        "fileExt": filesInfos[fileId] && filesInfos[fileId].fileExt,
                        "fileSize": filesInfos[fileId] && filesInfos[fileId].fileSize,
                        "fileUrl": ret.data[fileId],
                        "author": filesInfos[fileId] && filesInfos[fileId].author,
                        "from": filesInfos[fileId] && filesInfos[fileId].from,
                        "thumburl": filesInfos[fileId] && filesInfos[fileId].thumburl,
                        "platForm": filesInfos[fileId] && filesInfos[fileId].platForm
                    });
                    tipsDialog({
                        "id": "uploadToBeike" + new Date().getTime(),
                        "content": "资源添加中......"
                    });
                    _this.storageDownloading([fid], [obj], "fid",{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode}); //加入下载队列
                    downloadFiles && _this.download(downloadFiles);
                }
            }).fail(function(){
                tipsDialog({
                    "id": "uploading" + new Date().getTime(),
                    "content": "资源添加失败"
                });
            });
        });
    };

    //删除备课本（云端EDC）数据（单条数据）
    // eg> fileId: "abcd"
    prepareResource.prototype.deleteEdcCloudLessonPrepares = function(fileId){
        var _this = this;
        var fileId = fileId;
        if(fileId) {
            console.log("fileId不能为空");
            return;
        }
        //取得筛选条件
        var pageMeta = _this.bookContainer.getCurrPageMetadata();
        var openId = "";
        //请求用户信息
        _this.getUserInfo("id",_ebookContext.getUser().getUid()).done(function(ret) {
            //取得用户opendId
            if (!ret) {
                console.log("请求用户信息失败");
                return;
            }
            openId = ret.data.id;
            var request = {
                openId: openId,
                fileId : fileId
            };
            //取得所有的备课本并拉取备课本列表数据
            edcService.Instance().beike_file_delete(request).done(function (ret) {
                if (ret.code == 0) {
                    //删除成功
                    _this.lesssonPrepares.edc_cloud.count--;
                    //更新缓存
                    _this.lesssonPrepares.edc_cloud.data = _this.lesssonPrepares.edc_cloud.data.filter(function(el){
                        return el.fid != openId;
                    });
                    _this.lesssonPrepares.edc_cloud.origin = _this.lesssonPrepares.edc_cloud.origin.filter(function(el){
                        return el.fid != openId;
                    });
                    //展示数据
                    _this.setPrepareResItem(_this.lesssonPrepares.edc_cloud.data, "edc_cloud");
                } else {
                    //接口返回错误
                    console.log("数据错误:" + ret.code + "|" + ret.message + "|" + ret.solution);
                }
            }).fail(function (e) {
                console.log(e);
            });
        });
    };

    /**
     * 设置备课本资源Item
     * @param result
     */
    prepareResource.prototype.setPrepareResItem = function(result,type){
        var _this = this;
        var resType = '';
        var $container = '';
        switch(type){
            case "local":
                resType = 'local';
                $container = _this.controls.localPrepareContainer;
                _this.controls.lessonPrepareContainer.find(".J_open_local").attr("disabled",true).prop("disabled",true);
                break;
            case "cloud":
                resType = 'cloud';
                $container =_this.controls.cloudPrepareContainer;
                break;
            case "edc_cloud":
                resType = 'edc_cloud';
                $container =_this.controls.cloudPrepareContainer;
                _this.controls.lessonPrepareContainer.find(".J_open_cloud").attr("disabled",true).prop("disabled",true);
                break;
            default:
                resType = '';
                break;
        }
        var lessonPrepares = result;
        if (!getBlackboardFlag()){
            if(lessonPrepares.length <= 0) {
                var typeText = (resType == 'local') ? "本地资源" : "云资源";
                var info = {
                    "status" : "empty",
                    "tips" : "暂无资源",
                    "from" : "prepare"
                };
                _this.renderResStatus($container,info);
                _this.controls.lessonPrepareContainer.find(".J_show").hide();
                _this.controls.lessonPrepareContainer.find(".J_hidden").hide();
                // _this.debug_lessonprepare("local",_this.controls.lessonPrepareContainer);
                return;
            }
            var i = 0,
                length = lessonPrepares.length;
            $($container).html("").append("<ul></ul>");
            $($container).find('ul').addClass("jxpop-commend");
            for(;i < length; i++){
                var item = lessonPrepares[i];
                _this.render(resType,item,$($container).find("ul"));
            }
            switch(resType){
                case "local":
                    //重置列表勾选状态
                    var $itemDom = _this.common_operate("find",[_this.controls.localPrepareContainer,"li"]);
                    for (var i = 0 ;i < $itemDom.length ; i++) {
                        if ($(_this.common_operate('find', [$itemDom[i], "input"])).is(":checked")) {
                            $($itemDom[i]).find("input").attr('checked', false).prop("checked", false);
                        }
                    }
                    _this.controls.localPrepareContainer.find(".format-checkbox").hide();
                    break;
                case "cloud":
                case "edc_cloud":
                    //重置列表勾选状态
                    var $itemDom = _this.common_operate("find",[_this.controls.cloudPrepareContainer,"li"]);
                    for (var i = 0 ;i < $itemDom.length ; i++) {
                        if ($(_this.common_operate('find', [$itemDom[i], "input"])).is(":checked")) {
                            $($itemDom[i]).find("input").attr('checked', false).prop("checked", false);
                        }
                    }
                    _this.controls.cloudPrepareContainer.find(".format-checkbox").hide();
                    break;
                default:
                    break;
            }
            //重置列表全选状态
            var $selectAllDom = _this.common_operate("find",[_this.controls.lessonPrepareContainer,".J_selectAll"]);
            for (var i = 0 ;i < $selectAllDom.length ; i++) {
                if ($(_this.common_operate('find', [$selectAllDom[i], "input"])).is(":checked")) {
                    $($selectAllDom[i]).find("input").attr('checked', false).prop("checked", false);
                }
            }
            if(_this.controls.localPrepareContainer.is(":hidden")){
                //云资源
                _this.controls.lessonPrepareContainer.find(".J_show").show();
                _this.controls.lessonPrepareContainer.find(".J_hidden").hide();
                _this.controls.lessonPrepareContainer.find(".J_local").hide();
                _this.controls.lessonPrepareContainer.find(".J_open_cloud").attr("disabled",false).prop("disabled",false);
            }
            if(_this.controls.cloudPrepareContainer.is(":hidden")){
                //本地资源
                _this.controls.lessonPrepareContainer.find(".J_show").show();
                _this.controls.lessonPrepareContainer.find(".J_hidden").hide();
                _this.controls.lessonPrepareContainer.find(".J_cloud").hide();
                _this.controls.lessonPrepareContainer.find(".J_open_local").attr("disabled",false).prop("disabled",false);
            }
            // _this.debug_lessonprepare(resType,_this.controls.lessonPrepareContainer);
        } else{

        }
    };

    prepareResource.prototype.render = function(resType,data,container){
        var _this = this;
        var resType = resType;
        if(resType == "local") {
            var aliasName = data.aliasname || "";
            var name = data.name || "";
            var title = data.title || "";
            var filepath = data.filepath || "";
            var timestamp = data.timestamp || "";
            var uuid = data.uuid || "";
            var extension = data.extension || "";
            var id = data.id;
            var fileFullPath = data.localpath;
            /*var li = $('<li name="prepareItemLi" draggable="true">' +
                '<div class="format-checkbox" style="display: none"><input name="local" type="checkbox" value="" class="ckb_box"></div>' +
                '<div class="format-img"><img draggable="false" src=""></div>' +
                '<div class="format-tit"><p><span name="title">{title}</span></p>' +
                '<font name="add" style="display:none;"><button type="button">加入课本</button></font>' +
                '</div></li>');*/
            var li = $('<li name="prepareItemLi">' +
                '<div class="jxpop-comtit"><input name="local" type="checkbox" value="" class="ckb_box">' +
                '<em class="pl10"><img src="" draggable="false" style="width:24px;heigth:24px;"></em>' +
                '<span class="pl10" name="title">{title}</span></div>' +
                '<div class="jxpop-comsim" name="add"><button type="button" class="btn-gray">加入课本</button></div>' +
                '</li>');
            li.attr("data-id", id);
            li.attr("resType", resType);
            li.attr("data-timestamp", timestamp);
            li.attr("data-uuid", uuid);
            li.attr("data-file", filepath);
            li.find('img').attr("src", _this.setDefaultPic(extension));
            //去除《》中的内容
            // var _title = aliasName.replace(/^[《].*[》]/i,"");
            // if(_title)
            //     _title = _title.length > 12 ? _title.substr(0, 12) + "···" : _title;
            // else{
            //     _title = aliasName;
            // }
            var _title = name;
            li.find("span[name=title]").text(_title);
            li.find("span[name=title]").attr("title", _title);
            li.find("span[name=title]").attr("data-fileFullPath", fileFullPath);
            if(-1 != $.inArray(uuid,_this.getHasDownload("hasDownload"))){
                li.addClass("gray");
            }
            //绑定点击事件
            $(li).find("span[name=title]").bind("click", function() {
                var fileFullPath = $(this).attr("data-fileFullPath");
                _this.openLocalPrepareFile(fileFullPath);
                event.stopPropagation();
            });
            //备课本本地资源加入课本  njfu@iflytek.com 2016年10月20日14:02:26
            $(li).find("button").bind("click", function(event) {
                var $itemDom = _this.common_operate("find",[_this.controls.localPrepareContainer,"li"]);
                var localPrepresData=_this.lesssonPrepares.local.data;
                //给localPrepresData 赋值，用于授课包下载动画时显示   将timestamp值赋给id
                localPrepresData.filter(function (el) {
                    el.creator = el.userName;
                    el.title = el.name;
                    el.id = el.uuid;
                })
                var listItem=0,
                    last=0,
                    fileIds=[],
                    listArr=[];

                var last = $(this).parents("li").index();
                //选择过后，将选择状态清除,更新全选状态
                $(this).parents("li").find("input[name = 'local']").attr('checked', false).prop("checked", false);
                $(this).parents("li").trigger('prepareEvent.localCheck');

                //本地资源唯一标识
                var uuid = _this.common_operate('getAttribute', [$itemDom[last], 'data-uuid']);
                fileIds.push(uuid);
                _this.localBatchAddToBook(fileIds,localPrepresData,"uuid");
                event.stopPropagation();
            });
            //本地资源勾选事件监听
            $(li).on("prepareEvent.localCheck",function(event,params){
                var $itemDom = _this.common_operate("find",[_this.controls.localPrepareContainer,"li"]);
                var $unChecked = $itemDom.filter(function (index) {
                    return $(this).find("input").is(":checked") == false;
                });
                if($unChecked.length > 0){
                    $(_this.controls.lessonPrepareContainer).find(".J_local input").attr('checked', false).prop("checked", false);
                }else{
                    $(_this.controls.lessonPrepareContainer).find(".J_local input").attr('checked', true).prop("checked", true);
                }
                //阻止冒泡
                return false;
            });
            $(li).find("input[name='local']").change(function (event) {
                $(li).trigger('prepareEvent.localCheck');
                //阻止冒泡
                return false;
            });
            container.append(li);
        }

        if(resType == "cloud") {
            var aliasName = data.aliasName || "";
            var fileName = data.fileName || "";
            var extension = data.extension || "";
            var uid = data.uid;
            var fid = data.fid;
            /*var li = $('<li name="prepareItemLi" draggable="true">' +
                '<div class="format-checkbox" style="display: none"><input name="cloud" type="checkbox" value="" class="ckb_box"></div>' +
                '<div class="format-img"><img draggable="false" src=""></div>' +
                '<div class="format-tit"><p><span name="title">{title}</span></p>' +
                '<font name="add" style="display:none;"><button type="button">加入课本</button></font>' +
                '</div></li>');*/
            var li = $('<li name="prepareItemLi">' +
                '<div class="jxpop-comtit"><input name="cloud" type="checkbox" value="" class="ckb_box">' +
                '<em class="pl10"><img src=""></em>' +
                '<span class="pl10" name="title">{title}</span></div>' +
                '<div class="jxpop-comsim" name="add"><button type="button" class="btn-gray">加入课本</button></div>' +
                '</li>');
            li.attr("id", fid);
            li.attr("resType", resType);
            li.find('img').attr("src", _this.setDefaultPic(extension));
            //去除《》中的内容
            // var _title = aliasName.replace(/^[《].*[》]/i,"");
            // if(_title)
            //     _title = _title.length > 12 ? _title.substr(0, 12) + "···" : _title;
            // else{
            //     _title = aliasName;
            // }
            _title = fileName;
            li.find("span[name=title]").text(_title);
            li.find("span[name=title]").attr("title", fileName);
            container.append(li);
        }

        if(resType == "edc_cloud") {
            var aliasName = data.aliasName || "";
            var fileName = data.fileName || "";
            var extension = data.extension || "";
            var uid = data.uid;
            var fid = data.fid;
            /*var li = $('<li name="prepareItemLi" draggable="true" >' +
                '<div class="format-checkbox" style="display: none"><input name="edc_cloud" type="checkbox" value="" class="ckb_box"></div>' +
                '<div class="format-img"><img draggable="false" src=""></div>' +
                '<div class="format-tit"><p><span name="title">{title}</span></p>' +
                '<font name="add" style="display:none;"><button id="prepareAddToBook" type="button">加入课本</button></font>' +
                '</div></li>');*/
            var li = $('<li name="prepareItemLi">' +
                '<div class="jxpop-comtit"><input name="edc_cloud" type="checkbox" value="" class="ckb_box">' +
                '<em class="pl10"><img draggable="false" src="" style="width:24px;heigth:24px;"></em>' +
                '<span class="pl10" name="title">{title}</span></div>' +
                '<div class="jxpop-comsim" name="add"><button type="button" class="btn-gray" id="prepareAddToBook">加入课本</button></div>' +
                '</li>');
            li.attr("id", fid);
            li.attr("data-filePath", fid);
            li.attr("resType", resType);
            li.find('img').attr("src", _this.setDefaultPic(extension));
            $(li).find("span[name=title]").attr("id",fid);
            //去除《》中的内容
            // var _title = aliasName.replace(/^[《].*[》]/i,"");
            // if(_title)
            //     _title = _title.length > 12 ? _title.substr(0, 12) + "···" : _title;
            // else{
            //     _title = aliasName;
            // }
            var _title = fileName;
            li.find("span[name=title]").text(_title);
            if(-1 != $.inArray(fid,_this.getHasDownload("hasDownload"))){
                li.addClass("gray");
            }
            li.find("span[name=title]").attr("title", _title);
            //资源名称-预览 by njfu@iflytek.com 2016-11-2
            $(li).find("span[name=title]").bind("click", function(event) {
                var _that=this;
                var resId = $(_that).attr("id");
                var staticParams = {
                    uid:_ebookContext._curUser._uid,
                    module:'01018',
                    type:'trigger',
                    bookCode:_ebookContext.curBookCode
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
                
                var data = _this.lesssonPrepares.edc_cloud.data.filter(function(el){
                    return  el.fid == resId;
                });
                var resultData=data[0];
                resultData.title=resultData.aliasName;
                var type=resultData.extension;
                var allowExtension = ["jpg","png","gif","jpeg","bmp","mp3","wma","wav","ogg","ape","mid","midi","avi","flv","wmv","3gp","mpg","rmvb","rm","asf","mp4","swf","doc","docx","txt","xlsx","xls","ppt","pptx","pdf","icw"];
                if(-1 == $.inArray(type,allowExtension)) {
                    _this.showCommonTip({
                        "title": "温馨提示",
                        "content": "暂不支持预览 ." + type + "格式"
                    });
                }else{
                    shellcmd.checkOnline().done(function(online){
                        if(online){
                            _this.getUserInfo("id", _ebookContext.getUser().getUid()).done(function (ret) {
                                //取得用户opendId
                                if (!ret) {
                                    _this.showCommonTip({
                                        "title": "温馨提示",
                                        "content": "资源预览失败，请重试。"
                                    });
                                    return;
                                }
                                var openId = ret.data.id;
                                var preview_param = {
                                    "openId": openId,
                                    "fileId": resId
                                };
                                edcService.Instance().pan_file_preview_get(preview_param).done(function (ret) {
                                    if (ret.code == 0) {
                                        var url = ret.data;
                                        if(url != "") {
                                            _resourceContentPage.previewRes(type, url, resultData, function(resInfo){
                                                _this.downladEdcCloudLessonPrepares(resInfo);
                                            });
                                        }else{
                                            _this.showCommonTip({
                                                "title": "温馨提示",
                                                "content": "资源预览失败，文件正在转码中..."
                                            });
                                        }
                                    } else {
                                        _this.showCommonTip({
                                            "title": "温馨提示",
                                            "content": "资源预览失败，请重试。"
                                        });
                                    }
                                }).fail(function () {
                                    _this.showCommonTip({
                                        "title": "温馨提示",
                                        "content": "资源预览失败，请重试。"
                                    });
                                });
                            }).fail(function(e){
                                _this.showCommonTip({
                                    "title": "温馨提示",
                                    "content": "资源预览失败，请重试。"
                                });
                            });
                        }else{
                            tipsDialog({
                                "id": "uploading" + new Date().getTime(),
                                "content": "网络异常"
                            });
                        }
                    });
                }
                event.stopPropagation();
            });
            //资源条-编辑框 by njfu@iflytek.com 2016-11-2
            /*$(li).bind("click",function(e){
                var _that=this;
                var resId = $(_that).attr("id");
                //获取当前页面上的资源  by njfu@iflytek.com 2016年10月20日14:39:09
                var curpageRes = _this.bookContainer.getCurrentPageRes();
                var flag = curpageRes.filter(function(el){
                    return el.resourceId == resId;
                });
                if(flag.length>=1){
                     //触发蓝色气泡点击事件
                  if(flag[0].WidgetType == "note"){
                    flag[0].resourcePreview();
                  }else{
                    flag[0].showEdit($("#"+flag[0].Id),flag[0]);
                  }
                }

            });*/
            //云资源勾选事件监听
            $(li).on("prepareEvent.edcCloudCheck",function(event,params){
                console.log('prepareEvent.edcCloudCheck');
                var $itemDom = _this.common_operate("find",[_this.controls.cloudPrepareContainer,"li"]);
                var $unChecked = $itemDom.filter(function (index) {
                    return $(this).find("input").is(":checked") == false;
                });
                if($unChecked.length > 0){
                    $(_this.controls.lessonPrepareContainer).find(".J_cloud input").attr('checked', false).prop("checked", false);
                }else{
                    $(_this.controls.lessonPrepareContainer).find(".J_cloud input").attr('checked', true).prop("checked", true);
                }
                //阻止冒泡
                return false;
            });
            $(li).find("input[name='edc_cloud']").change(function (event) {
                $(li).trigger('prepareEvent.edcCloudCheck');
                //阻止冒泡
                return false;
            });
            container.append(li);
            
        }
    };
    /**
     * 事件绑定
     */
    prepareResource.prototype.registerEvent=function(){
        var _this = this;
        //监听事件
        $(document).on("insertWidgetSuccess",function(e,param){
            //资源加入课本标记
            if(param && param.insertType == "overlay") {
                //资源覆盖后删除本地存储
                _this.removeStorageDownloading(param.id,false);
            }else{
                //移除下载中本地存储
                _this.removeStorageDownloading(param.id,false);
            }
        });

        //点击本地资源刷新事件
        // $(_this.buttons.localPrepareBtn).on("click",function(){
        //     $(".cloudbatch").hide();//云资源的批量添加按钮
        //     $(".cloudbatchAddControl").hide();
        //     $(".localbatch").show();
        //     $(".local_batchAddShow").show();//本地资源的批量添加按钮
        //     $(".localbatchAddControl").hide();//加入课本和返回按钮隐藏
        //     _this.getLocalLessonPrepares();
        //     event.stopPropagation();
        // });
        //点击云端资源刷新事件
        // $(_this.buttons.cloudPrepareBtn).on("click",function(){
        //     $(".ckb_box").hide();
        //     $(".cloudbatch").show();
        //     $(".localbatch").hide();
        //     $(".localbatchAddControl").hide();
        //     $(".cloud_batchAddShow").show();
        //     $(".cloudbatchAddControl").hide();//加入课本和返回按钮隐藏
        //     _this.getEdcCloudLessonPrepares();
        //     event.stopPropagation();
        // });

        //备课本云资源加入课本按钮
        $(document).on("mouseover mouseout",".J_cloudprepare_content  li[name='prepareItemLi']",function(event){
            switch(event && event.type){
                case 'mouseover':
                    $(this).find("button").attr("id","cloudAddToBook");//给按钮加上id
                    break;
                case 'mouseout':
                    $(this).find("button").removeAttr("id");
                    break;
                default:
                    break;
            }
        });

        //云资源加入课本
        $(document).on("click","#cloudAddToBook",function (event) {
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            var filesInfos=[];
            var edcCloudLessonPrepare = _this.lesssonPrepares.edc_cloud.data || [];
            //edcCloudLessonPrepare 赋值，用于授课包下载动画时显示
            if(edcCloudLessonPrepare.length > 0) {
                edcCloudLessonPrepare.filter(function (el) {
                    el.id = el.fid;
                    if(el.fileName){
                        var parsedFileName = _resTool.parseFileName(el.fileName) || {};
                    }
                    el.title = parsedFileName.fileName || "";
                    el.creator = el.uid;
                });
            }
            var newWidgetPos = null;
            if (!getBlackboardFlag()){
                var _that=$(this).parents("li");//备课本资源的标识符，云资源是id,本地资源是data-timestamp
                var dataIds=[],
                    listArr=[];
                var data = edcCloudLessonPrepare.filter(function(el){
                    return el.fid == _that[0].id;
                });
                dataIds.push(data[0].fid);

                var id=_that[0].id;
                var uid = data[0].uid;
                var fid = data[0].fid;
                var aliasName = data[0].aliasName || "";
                var fileName = data[0].fileName || "";
                var extension = data[0].extension || "";
                var size = data[0].length || "";
                var author = data[0].uid || "";
                var fromApp = data[0].fromApp || "";
                var thumbnail=data[0].thumbPath;
                var platForm=data[0].platForm;

                filesInfos[id] = {};
                filesInfos[id].thumburl =thumbnail;
                filesInfos[id].platForm =platForm;
                filesInfos[id].fileName = fileName;
                filesInfos[id].fileExt = extension;
                filesInfos[id].fileSize = size;
                filesInfos[id].author = author;
                filesInfos[id].from = fromApp;

                //检测网络
                shellcmd.checkOnline().done(function(online){
                    if(online){
                        _this.getPanFilesDownloadUrl(id).done(function(ret) {//获取下载地址
                            if(!ret||ret==""||ret.code!=0){
                                tipsDialog({
                                    "id": "uploading" + new Date().getTime(),
                                    "content": "资源添加失败"
                                });
                                return;
                            }
                            var downloadFiles = [];
                            // for (var i = 0, count = fileIds.length; i < count; i++) {
                            // var fileId = fileIds[i];
                            var fileId = id;
                            downloadFiles.push({
                                "fileId": fileId,
                                "fileName": filesInfos[fileId] && filesInfos[fileId].fileName,
                                "fileExt": filesInfos[fileId] && filesInfos[fileId].fileExt,
                                "fileSize": filesInfos[fileId] && filesInfos[fileId].fileSize,
                                "fileUrl": ret.data[fileId],
                                "author": filesInfos[fileId] && filesInfos[fileId].author,
                                "from": filesInfos[fileId] && filesInfos[fileId].from,
                                "thumburl":filesInfos[fileId]&&filesInfos[fileId].thumburl,
                                "platForm":filesInfos[fileId]&&filesInfos[fileId].platForm
                            });
                            console.log(downloadFiles);
                            //选择过后，将选择状态清除,更新全选状态
                            $(_that).find("input[name = 'edc_cloud']").attr('checked', false).prop("checked", false);
                            $(_that).trigger('prepareEvent.edcCloudCheck');

                            _this.storageDownloading(dataIds,edcCloudLessonPrepare,"fid",{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});//加入下载队列
                            downloadFiles && _this.download(downloadFiles);
                            tipsDialog({
                                "id": "uploading" + new Date().getTime(),
                                "content": "资源添加中......"
                            });

                        }).fail(function(){
                            tipsDialog({
                                "id": "uploading" + new Date().getTime(),
                                "content": "资源添加失败"
                            });
                        });
                    }else{
                        tipsDialog({
                            "id": "uploading" + new Date().getTime(),
                            "content": "网络异常"
                        });
                    }
                });
            }
            //阻止冒泡
            event.stopPropagation();
        });
        //本地资源加入课本按钮事件
        $(_this.controls.localPrepareContainer).on("mouseover mouseout","li[name='prepareItemLi']",function(event){
            switch(event && event.type){
                case 'mouseover':
                    $(this).find("button").attr("id", "localAddToBook");//给按钮加上id
                    break;
                case 'mouseout':
                    $(this).find("button").removeAttr("id");
                    break;
                default:
                    break;
            }
            event.stopPropagation();
        });
        //本地资源点击资源条 by njfu@iflytek.com 2016年10月20日09:33:22
        /*$(_this.controls.localPrepareContainer).on("click","li[name='prepareItemLi']",function(event){
            //获取当前页面上的资源
            var curpageRes = _this.bookContainer.getCurrentPageRes();
             var timestamp = $(this).attr("data-timestamp");
            var flag = curpageRes.filter(function(el){
                return el.timestamp == timestamp;
            });
            if(flag.length>=1){
                 //触发蓝色气泡点击事件
                if(flag[0].WidgetType == "note"){
                    flag[0].resourcePreview();
                  }else{
                    flag[0].showEdit($("#"+flag[0].Id),flag[0]);
                  }
            }
            event.stopPropagation();
        });*/

        //备课本云资源拖拽事件
        /*$(document).on("dragend",".J_cloudprepare_content  li[name='prepareItemLi']",function(e) {
            var _that = this;
            shellcmd.checkOnline().done(function(online){
                if(online){
                    var filesInfos = {};
                    var edcCloudLessonPrepare = _this.lesssonPrepares.edc_cloud.data || [];
                    //edcCloudLessonPrepare 赋值，用于授课包下载动画时显示
                    if(edcCloudLessonPrepare.length > 0) {
                        edcCloudLessonPrepare.filter(function (el) {
                            el.id = el.fid;
                            if(el.fileName){
                                var parsedFileName = _resTool.parseFileName(el.fileName) || {};
                            }
                            el.title = parsedFileName.fileName || "";
                            el.creator = el.uid;
                        });
                    }
                    var newWidgetPos = {
                        left: e.originalEvent.clientX,
                        top: e.originalEvent.clientY
                    }
                    var bookRect = document.getElementById("book").getBoundingClientRect();
                    if (newWidgetPos.left < bookRect.left + 10){
                        return;
                    }

                    if (!getBlackboardFlag()) {
                        var $itemDom = _this.common_operate("find", [_this.controls.cloudPrepareContainer, "li"]);
                        var listItem = 0,
                            last = 0,
                            dataIds = [],
                            listArr = [];
                        var data = edcCloudLessonPrepare.filter(function (el) {
                            return el.fid == _that.id;
                        });
                        for (i = 0; i < $itemDom.length; i++) {
                            if ($itemDom[i].id == data[0].fid) {
                                listItem = $itemDom[i];
                                break;
                            }
                        }
                        dataIds.push(data[0].fid);
                        listArr.push(listItem);
                        var id = _that.id;
                        var uid = data[0].uid;
                        var fid = data[0].fid;
                        var aliasName = data[0].aliasName || "";
                        var fileName = data[0].fileName || "";
                        var extension = data[0].extension || "";
                        var size = data[0].length || "";
                        var author = data[0].uid || "";
                        var fromApp = data[0].fromApp || "";
                        var thumbnail=data[0].thumbPath;
                        var platForm=data[0].platForm;

                        filesInfos[id] = {};
                        filesInfos[id].thumburl =thumbnail;
                        filesInfos[id].platForm =platForm;
                        filesInfos[id].fileName = fileName;
                        filesInfos[id].fileExt = extension;
                        filesInfos[id].fileSize = size;
                        filesInfos[id].author = author;
                        filesInfos[id].from = fromApp;
                        filesInfos[id].position= newWidgetPos;
                        //选择过后，将选择状态清除
                        $(_that).find("input[name = 'edc_cloud']").attr('checked', false).prop("checked", false);

                        _this.getPanFilesDownloadUrl(_that.id).done(function (ret) {//获取下载地址
                            if(!ret||ret==""||ret.code!=0){
                                tipsDialog({
                                    "id": "uploading" + new Date().getTime(),
                                    "content": "资源添加失败"
                                });
                                return;
                            }
                            _this.storageDownloading(dataIds, edcCloudLessonPrepare,"fid");//加入下载队列
                            _this.addAnimation($itemDom, last, edcCloudLessonPrepare);
                            var downloadFiles = [];
                            // for (var i = 0, count = fileIds.length; i < count; i++) {
                            // var fileId = fileIds[i];
                            var fileId = _that.id;
                            downloadFiles.push({
                                "fileId": fileId,
                                "fileName": filesInfos[fileId] && filesInfos[fileId].fileName,
                                "fileExt": filesInfos[fileId] && filesInfos[fileId].fileExt,
                                "fileSize": filesInfos[fileId] && filesInfos[fileId].fileSize,
                                "fileUrl": ret.data[fileId],
                                "author": filesInfos[fileId] && filesInfos[fileId].author,
                                "from": filesInfos[fileId] && filesInfos[fileId].from,
                                "thumburl":filesInfos[fileId]&&filesInfos[fileId].thumburl,
                                "platForm":filesInfos[fileId]&&filesInfos[fileId].platForm,
                                "position": filesInfos[id]&&filesInfos[id].position
                            });
                            // }
                            // resultData.creator = resultData[0].uid;
                            // resultData.id = resultData[0].fid;
                            // resultData.title = resultData[0].aliasname;
                            // resultData.fileurl = resultData[0].downloadpath;
                            // console.log(resultData);
                            // //var resultData = _this.recommendList.data[i].data[index];
                            // // resultData.resFrom = "recommend";
                            console.log(downloadFiles);
                            tipsDialog({
                                "id": "uploadToBeike" + new Date().getTime(),
                                "content": "资源添加中..."
                            });
                            downloadFiles && _this.download(downloadFiles);
                        }).fail(function(){
                            tipsDialog({
                                "id": "uploading" + new Date().getTime(),
                                "content": "资源添加失败"
                            });
                        });

                    } else {
                        var array = [];
                        array[0] = $(this).attr("srcPath");
                        var $pageItem = $('.pageItem');
                        var isDoublePage = $pageItem.length === 2;
                        var pageindex = 1;
                        var pageScale = _ebookContext.getTransformMatrix($pageItem);
                        var viewWidth = $("#bookContainer").width();
                        var x, y;
                        if (isDoublePage) {
                            x = (newWidgetPos.left - 70 - viewWidth/2 );
                            //判断是否是第二页
                            if(x>0){
                                x = x / pageScale[0];
                                pageindex = 2;
                            }
                            else{
                                x = (newWidgetPos.left - 70) / pageScale[0];
                            }
                        }
                        else {
                            x = (newWidgetPos.left - 70) / pageScale[0];
                        }
                        y = (newWidgetPos.top - 90) / pageScale[3];
                        console.log(x, y);
                        console.log(newWidgetPos.left, newWidgetPos.top);
                        _this.bookContainer.insertWidgetWithPos(array[0], [x, y],pageindex, {posType:1});
                    }
                }else{
                    //网络异常
                    tipsDialog({
                        "id": "uploadToBeike" + new Date().getTime(),
                        "content": "网络异常"
                    });
                }
            });
        });*/

        //控制备课本云资源全选功能
        $(_this.controls.lessonPrepareContainer).find(".J_selectAll").on("click","input[name='selectAll']",function(event){
            var isChecked = $(this).is(":checked") ? true: false;
            if(_this.controls.localPrepareContainer.is(":hidden")){
                //云资源
                var $itemDom = _this.common_operate("find",[_this.controls.cloudPrepareContainer,"li"]);
                $itemDom.filter(function (index) {
                    $(this).find("input").attr('checked', isChecked).prop("checked", isChecked);
                });
            }
            if(_this.controls.cloudPrepareContainer.is(":hidden")){
                //本地资源
                var $itemDom = _this.common_operate("find",[_this.controls.localPrepareContainer,"li"]);
                $itemDom.filter(function (index) {
                    $(this).find("input").attr('checked', isChecked).prop("checked", isChecked);
                });
            }
        });

        //本地资源拖拽添加到课本
        /*$(document).on("dragend",".J_localprepare_content  li[name='prepareItemLi']",function(e) {
            var $itemDom = _this.common_operate("find",[_this.controls.localPrepareContainer,"li"]);
            var localPrepresData=_this.lesssonPrepares.local.data || [];
            //给localPrepresData 赋值，用于授课包下载动画时显示   将timestamp值赋给id
            localPrepresData.filter(function (el) {
                el.creator = el.userName;
                el.title = el.name;
                el.id = el.timestamp;
            })
            var listItem=0,
                last=0,
                fileIds=[],
                listArr=[];
            var newWidgetPos = {
                left : e.originalEvent.clientX,
                top : e.originalEvent.clientY
            }
            var bookRect = document.getElementById("book").getBoundingClientRect();
            if (newWidgetPos.left < bookRect.left + 10){
                return;
            }
            var last = $(e.target).index();
            //本地资源唯一标识
            var timestamp = _this.common_operate('getAttribute', [$itemDom[last], 'data-timestamp']);
            tipsDialog({
                "id": "uploading" + new Date().getTime(),
                "content": "资源添加中..."
            });
            fileIds.push(timestamp);
            _this.storageDownloading(fileIds,localPrepresData,"timestamp");//加入下载队列
            _this.addAnimation($itemDom,last,localPrepresData);

            var fileInfo = localPrepresData.filter(function(el){
                return el["timestamp"] == timestamp;
            });
            var result = fileInfo[0] || {};

            var resultPath = result.localpath;
            if (resultPath) {
                var _userName = decodeURI(_ebookContext.getUser()._userName) || _ebookContext.getUser()._name;
                var array = [];
                array[0] = resultPath;
                var $pageItem = $('.viewdom .pageItem');
                var isDoublePage = $pageItem.length === 2;
                var pageindex = 1;
                var pageScale = _ebookContext.getTransformMatrix($pageItem);
                var viewWidth = $("#bookContainer").width();
                var x, y;
                if (isDoublePage) {
                    x = (newWidgetPos.left  - 204 - viewWidth / 2 );
                    //判断是否是第二页
                    if (x > 0) {
                        x = x / pageScale[0];
                        pageindex = 2;
                    } else {
                        x = (newWidgetPos.left-204 ) / pageScale[0];
                    }
                } else {
                    x = (newWidgetPos.left-204 ) / pageScale[0];
                }
                y = (newWidgetPos.top - 55) / pageScale[3];
                var fileid=result.fid;
                var timestamp=result.timestamp;
                var option={userName:_userName,"fileInfo":result,resourceId:fileid,timestamp:timestamp,insertToTA:true,posType:1};
                var opt = $.extend({multiFiles: array,posType:1}, option);
                _this.bookContainer.insertWidgetWithPos(array[0], [x, y], pageindex, opt);
                tipsDialog({
                    "id": "uploading" + new Date().getTime(),
                    "content": "资源添加成功"
                });
            }else{
                tipsDialog({
                    "id": "uploading" + new Date().getTime(),
                    "content": "资源添加失败"
                });
            }
        });*/
        $(_this.controls.lessonPrepareContainer).find("#edc_import").unbind().on("click",function(e){
            var dialog_param = { "multi": true, "ext": [".doc",".docx",".icw",".ppt",".pptx",".jpg",".png",".rmvb",".mp4",".avi",".wmv",".flv",".mp3",".wav",".swf",".flash",".gif"]};
            shellcmd.openFileDialog(dialog_param).done(function(ret){
                _this.clearFileStauts("import");
                _this.import(ret);
            });
        });

        $(_this.controls.lessonPrepareContainer).find("#edc_upload").unbind().on("click",function(e){
            var uploadFiles = [];
            var $itemDom = _this.common_operate("find",[_this.controls.localPrepareContainer,"li"]);
            for (var i = 0 ;i < $itemDom.length ; ++i){
                if(_this.common_operate('find' , [$itemDom[i] , "input[name = 'local']"]).is(":checked")){
                    var data_file = _this.common_operate('getAttribute', [$itemDom[i], 'data-file']);
                    var data_timestamp = _this.common_operate('getAttribute', [$itemDom[i], 'data-timestamp']);
                    var filePath = _ebookContext.getUser().getUserPpticwsBasePath() + '/'+ data_timestamp + "/" + data_file;
                    uploadFiles.push(filePath);
                    //选择过后，将选择状态清除
                    $($itemDom[i]).find("input[name = 'local']").attr('checked', false).prop("checked", false);
                }
            }

            if(_this.checkAllowUpload){
                _this.clearFileStauts("upload");
                _this.upload(uploadFiles);
            } else {
                alert("不允许上传");
            }
        });

        $(_this.controls.lessonPrepareContainer).find("#edc_export").unbind().on("click",function(e){
            var dialog_param = { "multi": true, "ext": [".doc",".docx",".icw",".ppt",".pptx",".jpg",".png",".rmvb",".mp4",".avi",".wmv",".flv",".mp3",".wav",".swf",".flash",".gif"]};
            shellcmd.openFileDialog_NW2('', '', true).done(function(ret){
                var exportFiles = [];
                var $itemDom = _this.common_operate("find",[_this.controls.localPrepareContainer,"li"]);
                for (var i = 0 ;i < $itemDom.length ; ++i){
                    if(_this.common_operate('find' , [$itemDom[i] , "input[name = 'local']"]).is(":checked")){
                        var data_file = _this.common_operate('getAttribute', [$itemDom[i], 'data-file']);
                        var data_timestamp = _this.common_operate('getAttribute', [$itemDom[i], 'data-timestamp']);
                        var filePath = _ebookContext.getUser().getUserPpticwsBasePath() + '/'+ data_timestamp + "/" + data_file;
                        exportFiles.push(filePath);
                        //选择过后，将选择状态清除
                        $($itemDom[i]).find("input[name = 'local']").attr('checked', false).prop("checked", false);
                    }
                }
                // var exportFiles = ["W:\\www\\company\\git-svn\\TA\\ppticws\\20160726130315338_0\\jpeg.jpeg","W:\\www\\company\\git-svn\\TA\\ppticws\\20160726130315338_0\\thumbnail.jpg"];
                _this.export(exportFiles,ret[0]);
            });
        });

        $(_this.controls.lessonPrepareContainer).find("#edc_local_delete").unbind().on("click",function(e){
            var localLessonPrepares = [];
            var $itemDom = _this.common_operate("find",[_this.controls.localPrepareContainer,"li"]);
            for (var i = 0 ;i < $itemDom.length ; ++i){
                if(_this.common_operate('find' , [$itemDom[i] , "input[name = 'local']"]).is(":checked")){
                    var data_timestamp = _this.common_operate('getAttribute', [$itemDom[i], 'data-timestamp']);
                    localLessonPrepares.push(data_timestamp);
                    //选择过后，将选择状态清除
                    $($itemDom[i]).find("input[name = 'local']").attr('checked', false).prop("checked", false);
                }
            }
            // var exportFiles = ["W:\\www\\company\\git-svn\\TA\\ppticws\\20160726130315338_0\\jpeg.jpeg","W:\\www\\company\\git-svn\\TA\\ppticws\\20160726130315338_0\\thumbnail.jpg"];
            // var localLessonPrepares = ["20160715201645483_0","20160724162333343_0","20160724163038692_0"];
            _this.deleteLocalLessonPrepares(localLessonPrepares);
        });

        $(_this.controls.lessonPrepareContainer).find("#edc_cloud_delete").unbind().on("click",function(e){
            var cloudLessonPrepares = [];
            var $itemDom = _this.common_operate("find",[_this.controls.cloudPrepareContainer,"li"]);
            for (var i = 0 ;i < $itemDom.length ; ++i){
                if(_this.common_operate('find' , [$itemDom[i] , "input[name = 'edc_cloud']"]).is(":checked")){
                    var id = _this.common_operate('getAttribute', [$itemDom[i], 'id']);
                    cloudLessonPrepares.push(id);
                    //选择过后，将选择状态清除
                    $($itemDom[i]).find("input[name = 'edc_cloud']").attr('checked', false).prop("checked", false);
                }
            }
            _this.deleteCloudLessonPrepares(cloudLessonPrepares);
        });

        //备课本云资源批量下载
        $(_this.controls.lessonPrepareContainer).find("#edc_cloudDownload").unbind().on("click",function(e){
            //获取当前页面信息
            var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
                _download_pageIndex = _this.bookContainer.getPageIndex(),
                _download_bookCode = _this.bookContainer.bookCode;
            var fileIds = [];
            var filesInfos = {};
            var selectedRes = [];
            var last=0;
            var edcCloudLessonPrepare = _this.lesssonPrepares.edc_cloud.data || [];
            //edcCloudLessonPrepare 赋值，用于授课包下载动画时显示
            if(edcCloudLessonPrepare.length > 0) {
                edcCloudLessonPrepare.filter(function (el) {
                    el.id = el.fid;
                    if(el.fileName){
                        var parsedFileName = _resTool.parseFileName(el.fileName) || {};
                    }
                    el.title = parsedFileName.fileName || "";
                    el.creator = el.uid;
                });
            }
            var $itemDom = _this.common_operate("find",[_this.controls.cloudPrepareContainer,"li"]);
            for (var i = 0 ;i < $itemDom.length ; i++){
                if(_this.common_operate('find' , [$itemDom[i] , "input[name = 'edc_cloud']"]).is(":checked")){
                    var id = _this.common_operate('getAttribute', [$itemDom[i], 'id']);
                    fileIds.push(id);
                    last = i;
                    var data = edcCloudLessonPrepare.filter(function(el){
                        return el.fid == id;
                    });
                    var uid = data[0].uid;
                    var fid = data[0].fid;
                    var aliasName = data[0].aliasName || "";
                    var fileName = data[0].fileName || "";
                    var extension = data[0].extension || "";
                    var size = data[0].length || "";
                    var author = _ebookContext.getUser().getUserName() || "";
                    var fromApp = data[0].fromApp || "";

                    filesInfos[id] = {};
                    filesInfos[id].fileName = aliasName;
                    filesInfos[id].fileExt = extension;
                    filesInfos[id].fileSize = size;
                    filesInfos[id].author = author;
                    filesInfos[id].from = fromApp;
                    // selectedRes.push({"id":fid,"title":fileName,"extension":extension,"creator":author,"thumbnail":""});
                    //选择过后，将选择状态清除,更新全选状态
                    $($itemDom[i]).find("input[name = 'edc_cloud']").attr('checked', false).prop("checked", false);
                    $($itemDom[i]).trigger('prepareEvent.edcCloudCheck');
                }
            }

            // var fileIds = ["232edc11-1f63-4fe5-96b3-e074220f74fd","188ac658-a439-4a7a-8e0b-e057e9867302"];
            // var FileInfos= {
            //     "232edc11-1f63-4fe5-96b3-e074220f74fd": {
            //         "fileName": "第三个人",
            //         "fileExt": "jpg",
            //         "fileSize": "4865",
            //         "author": "2000000001000000061",
            //         "from": "a481dcf13d1fd8b9"
            //     },
            //     "188ac658-a439-4a7a-8e0b-e057e9867302": {
            //         "fileName": "XX",
            //         "fileExt": "jpg",
            //         "fileSize": "7638",
            //         "author": "2000000001000000061",
            //         "from": "a481dcf13d1fd8b9"
            //     }
            // };
            //如果没有勾选资源则结束
            if(fileIds.length == 0){
                tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "请勾选要加入课本的资源"
                });
                return 0;
            }else {
                shellcmd.checkOnline().done(function (online) {
                    if (online) {
                        _this.getPanFilesDownloadUrl(fileIds).done(function (ret) {
                            if (!ret || ret == "" || ret.code != 0) {
                                tipsDialog({
                                    "id": "uploading" + new Date().getTime(),
                                    "content": "资源添加失败"
                                });
                                return;
                            }
                            var downloadFiles = [];
                            for (var i = 0, count = fileIds.length; i < count; i++) {
                                var fileId = fileIds[i];
                                var data = edcCloudLessonPrepare.filter(function (el) {
                                    return el.fid == id;
                                });
                                downloadFiles.push({
                                    "fileId": fileId,
                                    "fileName": filesInfos[fileId] && filesInfos[fileId].fileName,
                                    "fileExt": filesInfos[fileId] && filesInfos[fileId].fileExt,
                                    "fileSize": filesInfos[fileId] && filesInfos[fileId].fileSize,
                                    "fileUrl": ret.data[fileId],
                                    "author": filesInfos[fileId] && filesInfos[fileId].author,
                                    "from": filesInfos[fileId] && filesInfos[fileId].from
                                });
                            }
                            _this.storageDownloading(fileIds, edcCloudLessonPrepare, "fid",{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});//加入下载队列
                            // _this.addAnimation($itemDom, last, edcCloudLessonPrepare);
                            _this.download(downloadFiles);
                        }).fail(function () {
                            tipsDialog({
                                "id": "uploading" + new Date().getTime(),
                                "content": "资源添加失败"
                            });
                        });
                    } else {
                        //网络异常
                        tipsDialog({
                            "id": "uploadToBeike" + new Date().getTime(),
                            "content": "网络异常"
                        });
                    }
                });
            }
        });

        //备课本本地资源批量加入
        $(_this.controls.lessonPrepareContainer).find("#localBatchAddtoBook").on("click",function(){
            var $itemDom = _this.common_operate("find",[_this.controls.localPrepareContainer,"li"]);
            var localPrepresData=_this.lesssonPrepares.local.data;
            //给localPrepresData 赋值，用于授课包下载动画时显示   将timestamp值赋给id
            localPrepresData.filter(function (el) {
                el.creator = el.userName;
                el.title = el.name;
                el.id = el.uuid;
            })
            var listItem=0,
                last=0,
                fileIds=[],
                listArr=[];

            for (var i = 0 ;i < $itemDom.length ; i++) {
                if (_this.common_operate('find', [$itemDom[i], "input[name = 'local']"]).is(":checked")) {
                    //本地资源唯一标识
                    var uuid = _this.common_operate('getAttribute', [$itemDom[i], 'data-uuid']);
                    fileIds.push(uuid);
                    last = i;
                    //选择过后，将选择状态清除，更新全选状态
                    $($itemDom[i]).find("input[name = 'local']").attr('checked', false).prop("checked", false);
                    $($itemDom[i]).trigger('prepareEvent.localCheck');
                }
            }
            if(fileIds.length > 0){
                _this.localBatchAddToBook(fileIds,localPrepresData,"uuid");
            }else{
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "请勾选要加入课本的资源"
                });
            }
        });
    };


    //本地加入课本函数
    prepareResource.prototype.localBatchAddToBook=function (fileIds,fileInfos,idTag) {
        var _this = this;
        //获取当前页面信息
        var _download_currPageMetadata = _this.bookContainer.getCurrPageMetadata(),
            _download_pageIndex = _this.bookContainer.getPageIndex(),
            _download_bookCode = _this.bookContainer.bookCode;
        var fileIds = fileIds || [];
        var fileInfos = fileInfos || [];
        var idTag = idTag || "timestamp";
        var filesCount = fileIds.length;
        //递归循环加入课本资源数据
        _addToBook(0);

        function _addToBook(_index , callback,isIngnore){
            if (_index >= filesCount) {
                callback && callback();
                return ;
            }
            var timestamp = fileIds[_index];
            // fileInfo是数组
            var fileInfo = fileInfos.filter(function(el){
                return el["uuid"] == timestamp;
            });

            _add_item(fileInfo, _index, isIngnore).done(function () {
                _addToBook(_index + 1, callback);
            });
        }

        function _add_item(fileInfo,index,isIngnore){
            //加入课本
            var def = $.Deferred();
            if(isIngnore && isIngnore == true){
                def.resolve();
                return def.promise();
            }
            var index = index;
            var fileInfo = fileInfo[0] || {};
            var exist=false;
            //页面上已有widget
            var existwidgets=_this.bookContainer.getCurrentPageRes();
            for(var i=0;i<existwidgets.length;i++){
                if(existwidgets[i].resourceId==fileInfo.fid){
                    exist=true
                }
            }
            var fileFullPath = fileInfo.localpath;
            fileInfo["from"] = "local";
            shellcmd.isFileExist(fileFullPath).done(function(ret) {
                if(ret){
                    _this.storageDownloading(fileIds,[fileInfo],"uuid",{currPageMetadata:_download_currPageMetadata,pageIndex:_download_pageIndex,bookCode:_download_bookCode});//加入下载队列
                    _this.bookContainer.insertWidget([fileFullPath],{"fileInfo":fileInfo,
                        "userName":fileInfo.userName,
                        "resourceId":fileInfo.fid || "",
                        "insertToTA":true,
                        "timestamp":fileInfo.timestamp,
                        "uuid":fileInfo.uuid
                    });
                    //如果不存在，给出添加成功的提示。如果存在，在pageitem.js的insertWidget方法中会给出提示语，在这里不给提示
                    // 其实这里的逻辑是有问题的，因为并不一定insertWidget一定成功，但是要改动的话需要改动很多地方，而且改动以后效果特别不明显，暂时放一下
                    if(!exist){
                        tipsDialog({
                            "id": "uploading" + new Date().getTime(),
                            "content": "资源添加成功"
                        });
                    }
                    def.resolve();
                }else{
                    tipsDialog({
                        "id": "uploading" + new Date().getTime(),
                        "content": "资源添加失败"
                    });
                    def.reject();
                }
            });
            return def.promise();
        }

    };

    //本地返回
    prepareResource.prototype.cancelBatchDownload=function(cancelDataID){
        var _this = this;
        //var resId=$(cancelBtn).parents("li").attr("id");
        var resId=cancelDataID;
        shellcmd.cancleDownload(resId).done(function (ret) {
            // $("#recommendList").find("#" + resId).find("div[name='downloadGroup']").remove();//删除资源进度条，已不需要
            // $("#" + resId).find("p").show();
            event.stopPropagation();
        });
        event.stopPropagation();
    }
    //接收socket传入数据并做处理
    prepareResource.prototype.onMessageReceived = function (obj) {
        var _this = this;
        var obj = obj;
        //上传成功返回的结果
        if (obj.evt == "prepare_upload") {
            var uploadFiles = _this.filestatus.upload.origin;
            var process = obj.process;
            var index = obj.raw_data.index;
            console.log("----index------");
            console.log(index);
            //结果处理
            if(100 - process > 100) {
                console.log('upload error');
                _this.filestatus.upload.error.origin.push(uploadFiles[index]);
                //跳出循环
                if(_this.filestatus.upload.error.origin.length + _this.filestatus.upload.success.origin.length >= _this.filestatus.upload.count) {
                    _this.upload_after();
                }
            }
            if(100 - process > 0) {
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "文件上传中..."
                });
            }
            if(100 - process == 0){
                var _edc_file_upload_complete_request = obj.raw_data.edc_file_upload_complete_request;
                var _edc_file_add_request = obj.raw_data.edc_file_add_request;
                //文件完成上传和文件上传
                edcService.Instance().pan_file_upload_complete(_edc_file_upload_complete_request).done(function(ret3){
                    if(ret3.code == 0) {
                        console.log(ret3);
                        edcService.Instance().beike_file_add(_edc_file_add_request).done(function (ret4) {
                            console.log(ret4);
                            if(ret4.code == 0){
                                //文件上传成功
                                _this.filestatus.upload.success.origin.push(uploadFiles[index]);
                                //跳出循环
                                if(_this.filestatus.upload.error.origin.length + _this.filestatus.upload.success.origin.length >= _this.filestatus.upload.count) {
                                    _this.upload_after();
                                }
                            }
                        }).fail(function () {
                            console.log("文件上传失败");
                            var tips = tipsDialog({
                                "id": "uploadToBeike" + new Date().getTime(),
                                "content": "文件上传失败"
                            });
                            return 0;
                        });
                    }
                }).fail(function(){
                    console.log("文件完成上传失败");
                    var tips = tipsDialog({
                        "id": "uploadToBeike" + new Date().getTime(),
                        "content": "文件上传失败"
                    });
                    return 0;
                });
            }
        }
        //下载进程返回的结果
        if (obj.evt == "file_download") {
            var downloadFiles = _this.filestatus.download.origin;
            var progress = parseInt(obj.data.progress);

            //var userId = obj.raw_data.userId;
            var fileId = obj.data.id;
            var lessonPrepare_cloud_process_DOM = null;
            var lessonPrepare_cloud_res_DOM=null;

            var fileSavePath=obj.file;//文件存储路径
            //如果是当前用户则显示
            /*if (userId == _ebookContext.getUser().getUid()) {
                lessonPrepare_cloud_process_DOM = _this.controls.cloudPrepareContainer.find("div[myprebook_process=" + fileId + "]");
                lessonPrepare_cloud_res_DOM = _this.controls.cloudPrepareContainer.find("div[fileId=" + fileId + "]");
                lessonPrepare_cloud_res_DOM.hide();
                lessonPrepare_cloud_process_DOM.show();
                //显示进度
                lessonPrepare_cloud_process_DOM.find('div').find('span').css('width', process + '%');
                lessonPrepare_cloud_process_DOM.find('p').html(process.toFixed(0) + '%');
            }*/
            lessonPrepare_cloud_process_DOM = _this.controls.cloudPrepareContainer.find("div[myprebook_process=" + fileId + "]");
            lessonPrepare_cloud_res_DOM = _this.controls.cloudPrepareContainer.find("div[fileId=" + fileId + "]");
            lessonPrepare_cloud_res_DOM.hide();
            lessonPrepare_cloud_process_DOM.show();


            if (2 == progress) {
                var downFile = obj.data.rawData;
                downFile.id=downFile.timestamp;
                var timestamp = downFile.timestamp;
                //downFile.file=obj.file;
                if(downFile.fileName.indexOf("."+downFile.fileExt)!=-1){
                    downFile.fileName=downFile.fileName.substring(0,downFile.fileName.indexOf("."+downFile.fileExt));
                }

                var successItem = downloadFiles.filter(function(el){
                    return el.fileId == fileId;
                });
                _this.filestatus.download.success.origin.push(successItem[0]);
                //更新资源下载量
                _this.updateResDownloadCount(fileId, downFile.from);

                _this.filestatus.to_book.success.origin.push(successItem[0]);
                //跳出循环
                /* if(_this.filestatus.to_book.error.origin.length + _this.filestatus.to_book.success.origin.length >= _this.filestatus.to_book.count) {
                 _this.to_book_after();
                 }*/

                var option = {
                    userName: obj.data.rawData.author,
                    userPhoto: "",
                    score: obj.data.rawData.score,
                    uploadTime: obj.data.rawData.uploadTime,
                    resourceId: obj.data.id,
                    fileInfo: obj.data.rawData,
                    timestamp:obj.data.rawData.timestamp||timestamp,
                    insertFromOuter: true,      //防止资源下载完成后被删掉
                    insertToTA:true
                };

                option.toTPInfo = {
                    userName: obj.extension.userName,
                    bookCode: downFile.bookcode,
                    path: obj.data.file,
                    fileName: downFile.fileName,
                    unit1: downFile.unit1,
                    unit2: downFile.unit2,
                    unit3: downFile.unit3,
                    unit4: downFile.unit4,
                    uuid: obj.extension.uuid,
                    title: downFile.title,
                    pageCode: '',
                    position: "",
                    creator: downFile.author,
                    uploader: downFile.uploader,
                    description: downFile.description,
                    widgetId: '',   //书库导入资源时传
                    widgetType: '', //书库导入资源时传
                    resId: downFile.id,
                    fid: downFile.fid,
                    source: downFile.source,
                    resFrom: downFile.resFrom,
                    pageIndex: downFile.pageIndex   //需要在下载之前获取
                };

                //插入资源到课本
                var array = [];
                array[0] = obj.data.file;
                // var widgets = _this.bookContainer.getCurrentPageRes();
                var position=downFile.position;
                if (position) {
                    //拖拽下载
                    var $pageItem = $('.viewdom .pageItem');
                    var isDoublePage = $pageItem.length === 2;
                    var pageindex = 1;
                    var pageScale = _ebookContext.getTransformMatrix($pageItem);
                    var viewWidth = $("#bookContainer").width();
                    var x, y;
                    if (isDoublePage) {
                        x = (position.left  - 204 - viewWidth / 2 );
                        //判断是否是第二页
                        if (x > 0) {
                            x = x / pageScale[0];
                            pageindex = 2;
                            downFile.pageIndex += 1;
                        }
                        else {
                            x = (position.left - 204 ) / pageScale[0];
                        }
                    }
                    else {
                        x = (position.left - 204 ) / pageScale[0];
                    }
                    y = (position.top - 55) / pageScale[3];

                    //存放到数据库中位置的格式
                    option.toTPInfo.position = x + ";" + y + ";0;0;";//x;y;0;0;

                    var _userName="畅言教育";
                    //如果有作者信息
                    if(downFile.author){
                        _this.getUserInfo("id",downFile.author).done(function(ret){
                            if(ret.code=='0'){
                                _userName=ret.data.userName
                            }
                            option.userName = _userName;
                            option.toTPInfo.creator = _userName;
                            // _this.bookContainer.insertWidgetWithPos(array[0], [x, y], pageindex, $.extend({posType:1}, option),true);
                            dealOptionForInsertWidget($.extend({posType:1}, option), x, y, pageindex);
                        }).fail(function(err){//即使查询失败了也应该能插入卡片，只不过作者为“畅言教育”
                            option.userName = "畅言教育";
                            option.toTPInfo.creator = "畅言教育";
                            // _this.bookContainer.insertWidgetWithPos(array[0], [x, y], pageindex, $.extend({posType:1}, option),true);
                            dealOptionForInsertWidget($.extend({posType:1}, option), x, y, pageindex);
                        })
                    }else{//无作者信息，作者默认畅言教育
                        option.userName = "畅言教育";
                        option.toTPInfo.creator = "畅言教育";
                        // _this.bookContainer.insertWidgetWithPos(array[0], [x, y], pageindex, $.extend({posType:1}, option),true);
                        dealOptionForInsertWidget($.extend({posType:1}, option), x, y, pageindex);
                    }
                }
                else {
                    //单击“加入课本”下载
                    var userName="畅言教育";
                    if(downFile.author){
                        _this.getUserInfo("id",downFile.author).done(function(ret){
                            if(ret.code=='0'){
                                userName=ret.data.userName
                            }
                            option.userName = userName;
                            option.toTPInfo.creator = userName;
                            dealOptionForInsertWidget($.extend({posType:2}, option));
                            // _this.bookContainer.insertWidget(array, $.extend({posType:2}, option));
                        }).fail(function(err){
                            option.userName = userName;
                            option.toTPInfo.creator = userName;
                            dealOptionForInsertWidget($.extend({posType:2}, option));
                            // _this.bookContainer.insertWidget(array, $.extend({posType:2}, option));
                        })
                    }else{
                        option.userName = userName;
                        option.toTPInfo.creator = userName;
                        dealOptionForInsertWidget($.extend({posType:2}, option));
                        // _this.bookContainer.insertWidget(array, $.extend({posType:2}, option));
                    }
                }
                //授课包dom移除展示
                var _recommend_download = {
                    "count": 0,
                    "downloading": [],
                    "success": {
                        "origin": []
                    },
                    "error": {
                        "origin": []
                    }
                };
                var recommend_download = JSON.parse(localStorage.getItem("recommend_download"));
                if(recommend_download){
                    _recommend_download.count = recommend_download.count;
                    for(var i = 0,count = recommend_download.downloading.length; i < count; i++){
                        var item = recommend_download.downloading[i];
                        if(fileId == item.fid){
                            _recommend_download.error.origin.push(item);
                        } else {
                            _recommend_download.downloading.push(item);
                        }
                    }
                    //更新localstorage
                    localStorage.removeItem("recommend_download");
                    localStorage.setItem("recommend_download",JSON.stringify(_recommend_download));
                    //更新页面
                    _this.operateTemplate(_this.controls.teachingPackageContainer.find("#" + fileId),"error",item,"fid");
                }

                /*if(widgets.length==0){
                    tipsDialog({
                        "id": "uploading" + new Date().getTime(),
                        "content": "资源添加成功"
                    });
                }else {
                    for(i=0;i<widgets.length;i++){
                        //看数据结构，有的云资源是fileId和widgetdd resoureId相同，所以加了一个条件
                        if(widgets[i].resourceId==downFile.id||widgets[i].resourceId==downFile.fileId){
                            break;
                        }else if(i==widgets.length-1){
                            tipsDialog({
                                "id": "uploading" + new Date().getTime(),
                                "content": "资源添加成功"
                            });
                        }
                    }
                }*/

                //拷贝缩略图至文件夹
                /*var src = downFile.localThumbPath+'/thumbnail.jpg';
                // var src = _ebookContext.getUser().getUserPpticwsBasePath() + '/'+ timePath+'/thumbnail.jpg';
                var dest = '';
                if (_this.bookContainer.getPageViewType() === 4) {
                    //黑板试图
                    dest = path.trimPosix(_ebookContext.getUser().getUserWBPath()) +
                        '/' + _this.bookContainer.getWbIndex() + '/' + downFile.fileid + '.jpg';
                } else {
                    dest = path.trimPosix(_ebookContext.getUser().getUserBookBasePath()) +
                        '/' + _this.bookContainer.bookCode + '/' + _this.bookContainer.getPageIndex() + '/' + downFile.fileid + '.jpg';
                }
                shellcmd.UcopyFile(src, dest);*/
                //判断 当前页面是否是资源要下载到的页面  [option:下载资源的信息] [x/y:下载有位置的资源的x/y坐标] [pageSite:下载双页模式下 1：左页 2：右页]
                function dealOptionForInsertWidget(option, x, y, pageSite) {
                    if (currentDArr[option.toTPInfo.uuid] != 1){
                        return;
                    }
                    delete currentDArr[option.toTPInfo.uuid];
                    // console.log(option.toTPInfo.fileName+"加入完成");
                    var cachePages = _this.bookContainer.getProviderPages();    //缓存的pageItems
                    var pageItem = cachePages.filter(function (el) {
                        return el.pageIndex == option.toTPInfo.pageIndex;
                    });
                    var curPageIndex = _this.bookContainer.getPageIndex();
                    if (pageItem.length <= 0 || curPageIndex == option.toTPInfo.pageIndex){  //要下载的页面不在缓存中或者当前页就是下载页
                        if (option.toTPInfo.position){  //有位置
                            pageSite = 1;   //同步精选和拖拽下载，如果翻页后是下载的当前页，则这里的pageSite要重新置为1
                            _this.bookContainer.insertWidgetWithPos(array[0], [x, y], pageSite, option, true);
                        } else {    //无位置
                            _this.bookContainer.insertWidget(array, option);
                        }
                    } else {    //要下载的页面在缓存中但是不是当前页
                        var obj1 = {},obj2 = {};
                        try{
                            $.each(array, function (i, file) {
                                obj1 = $.extend({ notCopySrc: true,
                                    insertFromOuter: true,
                                    file: file}, option);
                                obj2 = $.extend({ file: file,
                                    multiFiles: array,
                                    insertFromOuter: true}, option);
                                if (x != "" && y != ""){
                                    obj1.left = x;
                                    obj1.top = y;
                                    obj2.left = x;
                                    obj2.top = y;
                                }
                                if (i) {
                                    //是否要拷贝源文件,因为是批量复制，除了第一个其余都不需要拷贝源文件
                                    pageItem[0].insertWidget(null, obj1);
                                }
                                else {
                                    pageItem[0].insertWidget(null, obj2);
                                }
                            });
                        } catch (e){
                            console.error(e);
                        }

                    }
                }


                //监管
                //如果是当前用户则显示
                if (userId == _ebookContext._curUser._uid){
                    setTimeout(function () {
                        lessonPrepare_cloud_process_DOM.hide();
                        lessonPrepare_cloud_res_DOM.show();
                    }, 1000);
                }
                /*  }).fail(function(e){
                 console.log(" 写数据库失败");
                 });*/
            }
            //else if (100 - process > 100 && userId == _ebookContext.getUser().getUid()) {
            else if (process < 0) {
                var errorItem = downloadFiles.filter(function(el){
                    return el.fileId == fileId;
                });
                _this.filestatus.download.error.origin.push(errorItem[0]);
                _this.filestatus.to_book.error.origin.push(errorItem[0]);
                //跳出循环
                /* if(_this.filestatus.to_book.error.origin.length + _this.filestatus.to_book.success.origin.length >= _this.filestatus.to_book.count) {
                 _this.to_book_after();
                 }*/
                console.log('下载失败，请重试.');
                tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "资源添加失败"
                });

                //授课包dom移除展示
                var _recommend_download = {
                    "count": 0,
                    "downloading": [],
                    "success": {
                        "origin": []
                    },
                    "error": {
                        "origin": []
                    }
                };
                var recommend_download = JSON.parse(localStorage.getItem("recommend_download"));
                if(recommend_download){
                    _recommend_download.count = recommend_download.count;
                    for(var i = 0,count = recommend_download.downloading.length; i < count; i++){
                        var item = recommend_download.downloading[i];
                        if(fileId == item.fid){
                            _recommend_download.error.origin.push(item);
                        } else {
                            _recommend_download.downloading.push(item);
                        }
                    }
                    //更新localstorage
                    localStorage.removeItem("recommend_download");
                    localStorage.setItem("recommend_download",JSON.stringify(_recommend_download));
                    //更新页面
                    _this.operateTemplate(_this.controls.teachingPackageContainer.find("#" + fileId),"error",item,"fid");
                }

                lessonPrepare_cloud_process_DOM.hide();
                lessonPrepare_cloud_res_DOM.show();
            } else if (progress < 1) {
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "资源添加中......"
                });
            }
        }
    };

    //取得当前章节的meta信息
    prepareResource.prototype.getCurrPageMetadata = function(){
        var _this = this;
        var pageMeta = _this.bookContainer.getCurrPageMetadata();
        return pageMeta;
    };

    //取得当前书本的信息
    prepareResource.prototype.getBookMetaInfo = function(){
        var _this = this;
        var bookMeta = _this.bookContainer.bookMetaInfo;
        return bookMeta;
    };

    //取得用户信息
    prepareResource.prototype.getUserInfo = function(key,value){
        var _this = this;
        var def = $.Deferred();
        var param = {
            "key" : key,
            "value" : value
        };
        edcService.Instance().core_user_get(param).done(function(ret){
            def.resolve(ret);
        }).fail(function(e){
            def.reject(false);
        });
        return def.promise();
    };

    //更新资源下载量
    prepareResource.prototype.updateResDownloadCount = function(resId,from) {
        var _this = this;
        var def = $.Deferred();
        var param = {
            id : resId
        };
        edcService.Instance().ersp_resource_download_inc(param).done(function(ret){
            def.resolve(ret);
        });
        return def.promise();
    };

    //资源预上传
    prepareResource.prototype.edcPanFileResourcePrepare = function(args){
        var _this = this;
        var def = $.Deferred();
        var param = {
             openId : args.openId, // 用户登录返回的openId
             extension : args.extension // 文件的后缀名
             // chunks : 1, // 分片上传分片数
             // platForm : args.platForm, // 文件服务使用的appname
             // callbackMethod : args.callbackMethod, // 文件上传完回调方法
             // callbackUrl : args.callbackUrl, // 文件上传完回调地址
             // callbackParams : args.callbackParams, // 文件上传完回调参数
             // callbackProtocol : args.callbackProtocol // 文件上传完回调方法
        };
        edcService.Instance().pan_file_resource_prepare(param).done(function(ret){
            def.resolve(ret);
        });
        return def.promise();
    };

    //文件上传 本地文件-接口-云端
    prepareResource.prototype.checkAllowUpload = function(){
        var _this = this;
        var pageMeta = _this.getCurrPageMetadata();
        if(pageMeta.unit1 != '') {
            return true;
        }
        return false;
    };

    //文件上传 本地文件-接口-云端
    prepareResource.prototype.upload = function(uploadFiles){
        var _this = this;
        var uploadFiles = uploadFiles;
        var i=0,
            filesCount = uploadFiles.length;
        _this.filestatus.upload.count = filesCount;
        _this.filestatus.upload.origin = uploadFiles;
        var openId = '';

        //请求用户信息
        _this.getUserInfo("id",_ebookContext.getUser().getUid()).done(function(ret){
        //取得用户opendId
        if(!ret) {
            console.log("请求用户信息失败");
            return;
        }
        openId = ret.data.id;
        for(;i < filesCount;i++) {
            (function(index){
                setTimeout(function(){
                    upload_item(uploadFiles[index],index).done(function(rs){
                        upload_process(rs);
                    }).fail(function(e){
                        var rs = {
                            "code" : "1",
                            "message" : "error",
                            "index" : index
                        };
                        upload_process(rs);
                    });
                });
            })(i);
        }
        });

        var upload_item = function(fileFullPath,index) {
            var def = $.Deferred();
            var fileFullPath = fileFullPath;
            var platForm = "rrt_ewp";
            var timestamp = new Date().getTime();
            var index = index;
            var parseFileName = _resTool.parseFileName(fileFullPath);
            var fileName = parseFileName.fileName;
            var fileExt = parseFileName.fileExt;
            var bookMeta = _this.getBookMetaInfo();
            var pageMeta = _this.getCurrPageMetadata();
            var edc_file_prepare_request = {
                openId : openId, // 用户登录返回的openId
                extension : fileExt // 文件的后缀名
                // chunks : 1, // 分片上传分片数
                // platForm : platForm, // 文件服务使用的appname
                // callbackMethod : "", // 文件上传完回调方法
                // callbackUrl : "", // 文件上传完回调地址
                // callbackParams : "", // 文件上传完回调参数
                // callbackProtocol : "" // 文件上传完回调方法
            };
            $.when(_resTool.calcMd5(fileFullPath), _this.edcPanFileResourcePrepare(edc_file_prepare_request)).done(function(ret1,ret2){
                if(!ret1) {
                    console.log("文件md5计算失败");
                    var tips = tipsDialog({
                        "id": "uploadToBeike" + new Date().getTime(),
                        "content": "资源添加失败"
                    });
                    return 0;
                }
                if(!ret2) {
                    console.log("文件预上传失败");
                    var tips = tipsDialog({
                        "id": "uploadToBeike" + new Date().getTime(),
                        "content": "资源添加失败"
                    });
                    return 0;
                }
                var uploadChunks = ret2.data.prepareInfo.uploads;

                //完成文件上传参数
                var edc_file_upload_complete_request = {
                    platForm : uploadChunks[0].params.appKey, //prepare返回接口数据中的appKey
                    contextId: uploadChunks[0].params.contextId //prepare接口中返回的contextId
                };

                var fileMD5 = ret1;
                var fileSize = fs.statSync(fileFullPath).size || "";
                var contextId = uploadChunks[0].params.contextId;
                var url = ret2.data.prepareInfo.url;
                //文件上传请求接口
                var edc_file_add_request = {
                    openId : openId,
                    name : fileName,
                    url : url, //文件地址
                    md5 : fileMD5, // 文件md5值
                    length : fileSize, // 文件长度
                    // status : "", // 文件上传状态
                    // token : "", // 结果签名（contextId、url、md5、length、status进行计算）
                    contextId : contextId, // 通过文件服务上传后文件服务返回id
                    description : "", // 文件描述
                    grade : bookMeta.grade || "", // 年级属性
                    subject : bookMeta.subject || "", // 学科属性
                    publisher : bookMeta.publisher || "", // 上下册
                    phase : "", // 版本属性
                    volumn : bookMeta.volumn || "", // Stage
                    edition : "", // 类型属性
                    stage : "", // Stage
                    type : "", // 书本属性
                    book : bookMeta.bookCode || "", // 书本属性
                    unit1 : pageMeta.unit1 || "", // 课本一级目录
                    unit2 : pageMeta.unit2 || "", // 课本二级目录
                    unit3 : pageMeta.unit3 || "", // 课本三级目录
                    unit4 : pageMeta.unit4 || "" // 课本四级目录
                };

                //socket
                var uploadParam = {
                    "config" : {
                        "type":"logic",
                        "action":"ta_upload",
                        "id":0,
                        "from":"ib",
                        "to":"ta_dum"
                    },
                    "data":{
                        "id": "~" + timestamp + "_" + index,
                        "multi":1,
                        "key": "file", //用于socket判断逻辑处理流程
                        // "url": "http://192.168.63.60:50201/v2/files/0/upload",
                        "url": uploadChunks[0].host,
                        "appKey": uploadChunks[0].params.appKey,
                        "contextId": uploadChunks[0].params.contextId,
                        "expires": uploadChunks[0].params.expires,
                        "token": uploadChunks[0].params.token,
                        "file": fileFullPath,
                        "source": "prepareFiles",
                        "evt": "prepare_upload", //用户回调函数判断事件类型
                        "extra": {
                            appKey: uploadChunks[0].params.appKey,
                            contextId: uploadChunks[0].params.contextId,
                            expires: uploadChunks[0].params.expires,
                            token: uploadChunks[0].params.token
                        },
                        "raw_data": {
                            "index" : index,
                            // "url": "http://192.168.6363.60:50201/v2/files/0/upload",
                            "url": uploadChunks[0].host,
                            "appKey": uploadChunks[0].params.appKey,
                            "contextId": uploadChunks[0].params.contextId,
                            "expires": uploadChunks[0].params.expires,
                            "token": uploadChunks[0].params.token,
                            "edc_file_upload_complete_request": edc_file_upload_complete_request,
                            "edc_file_add_request": edc_file_add_request
                        }
                    }
                };
                _this.socketSend(JSON.stringify(uploadParam));
            }).fail(function(e){
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "资源添加失败"
                });
                return 0;
            });
            return def.promise();
        };

        //上传前回调
        var upload_before = function(){};

        //上传中回调
        var upload_process = function(rs){
        //     var index = rs && rs.index;
        //     var code = rs && rs.code;
        //     //记录状态
        //     if(code == "0") {
        //         _this.filestatus.import.success.origin.push(files[index]);
        //     } else {
        //         _this.filestatus.import.error.origin.push(files[index]);
        //     }
        //
        //     if(_this.filestatus.import.success.origin.length + _this.filestatus.import.error.origin.length >= filesCount) {
        //         upload_after();
        //     }
        };
    };

    //上传全都完成后回调
    prepareResource.prototype.upload_after = function(){
        var _this = this;
        var successRes = _this.filestatus.upload.success.origin;
        var errorRes = _this.filestatus.upload.error.origin;
        if(successRes.length < 1) {
            var tips = tipsDialog({
                "id": "uploadToBeike" + new Date().getTime(),
                "content": "文件上传失败"
            });
        }
        if(successRes.length > 0 && errorRes.length >0) {
            var tips = tipsDialog({
                "id": "uploadToBeike" + new Date().getTime(),
                "content": "已上传" + successRes.length + "个课件,上传失败" + errorRes.length + "个课件"
            });
        }
        if(successRes.length >= 1 && errorRes.length == 0){
            var tips = tipsDialog({
                "id": "uploadToBeike" + new Date().getTime(),
                "content": "文件上传成功"
            });
        }
        //清空队列信息
        _this.clearFileStauts("upload");
    };

    //发送socket
    prepareResource.prototype.socketSend = function(data){
        var _this = this;
        var data = JSON.parse(data);
        var obj = {
            "type":data.config.type,
            "action":data.config.action,
            "from":data.config.from,
            "to":data.config.to,
            "id":data.config.id,
            "data":data.data
            // "data":{
            //     "id": data.data.id, //这个id用于多任务处理标记，不可重复
            //     "key":data.data.key,
            //     "url":data.data.url,
            //     "file":data.data.file,
            //     "source": data.data.source,
            //     "evt":data.data.evt,
            //     "raw_data": data.data.raw_data
            // }
        };
        socket.send(obj);
        // var obj = {
        //     "type":"logic",
        //     "action":"ta_upload",
        //     "from":"ib",
        //     "to":"ta_dum",
        //     "id":0,
        //     "data":{"id":"abc","key":"prepareFiles","url":"http://172.16.81.43:4301/4/files/4a8207f5ea014b9a8b0ede6cf3de70ea.book2?r=9990.461848210543","file":"W:/www/company/git-svn/TA/plugins/62/bin/users/defaultuser/ebook/08140101-002/08140101-002.book2"}
        // };
    };

    //获取云端网盘文件下载地址
    prepareResource.prototype.getPanFilesDownloadUrl = function(fileIds){
        var _this = this;
        var def = $.Deferred();
        var fileIds = fileIds;
        var fileIds_param = "";
        var openId = "";
        if(typeof (fileIds) == "object" && Array == fileIds.constructor){
            fileIds_param = fileIds.join(",");
        } else{
            fileIds_param = fileIds;
        }

        _this.getUserInfo("id",_ebookContext.getUser().getUid()).done(function(ret) {
            //取得用户opendId
            if (!ret) {
                console.log("请求用户信息失败");
                def.reject(false);
                return;
            }
            openId = ret.data.id;
            var param = {
                "openId" : openId,
                "fileIds" : fileIds_param
            };
            edcService.Instance().pan_files_download_get(param).done(function(ret){
                if(ret.code == 0) {
                    def.resolve(ret);
                }else{
                    def.reject(false);
                }
            }).fail(function(e){
                def.reject(false);
            });
        }).fail(function(e){
            def.reject(false);
        });
        return def.promise();
    };

    //文件下载 云端文件-本地文件
   /* downloadFiles = [{
        "fileId": "",
        "fileName": "",
        "fileExt": "",
        "fileSize": "",
        "fileUrl": "",
        "author":"",
        "from":""
    }]*/
    prepareResource.prototype.download = function(downloadFiles){
        var _this = this;
        var downloadFiles = downloadFiles;
        var i=0,
            filesCount = downloadFiles.length;
        _this.filestatus.download.count = filesCount;
        _this.filestatus.download.origin = downloadFiles;
        _this.filestatus.to_book.count = filesCount;
        _this.filestatus.to_book.origin = downloadFiles;
        //下载当前页
        var pageIndex = _this.bookContainer.getPageIndex();
        var openId = '';
        var userLoginName = '';

        //请求用户信息
        _this.getUserInfo("id",_ebookContext.getUser().getUid()).done(function(ret){
            //取得用户opendId
            if(!ret) {
                console.log("请求用户信息失败");
                tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "资源添加失败"
                });
                for (; i < filesCount; i++) {
                    (function (index) {
                        _this.removeStorageDownloading(downloadFiles[index]['fileId'], true, "资源添加失败");
                    })(i);
                }
                return;
            }
            openId = ret.data.id;
            userLoginName = ret.data.loginName;

            for(;i < filesCount;i++) {
                (function(index){
                    //下载当前页，防止翻页下载位置错误
                    downloadFiles[index].pageIndex = pageIndex;
                    setTimeout(function(){
                        download_item(downloadFiles[index]).done(function(rs){
                        });
                    });
                })(i);
            }
        }).fail(function (e) {
            for (; i < filesCount; i++) {
                (function (index) {
                    _this.removeStorageDownloading(downloadFiles[index]['fileId'], true, "资源添加失败");
                })(i);
            }
        });

        var download_item = function(downFile) {

            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'01007',
                type:'trigger',
                bookCode:_ebookContext.curBookCode
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);

            var def = $.Deferred();

            // var userLoginName = loginName;
            var downloadParam = {};
            var downFile = downFile;
            var bookMeta = _this.getBookMetaInfo();
            // var pageMeta = _this.getCurrPageMetadata();

            downloadParam.bookcode = bookMeta.bookCode;
            downloadParam.platForm = downFile.platForm;
            downloadParam.from = "beike";
            downloadParam.source = downFile.from;
            downloadParam.fileSize = downFile.fileSize;
            downloadParam.file = downFile.fileUrl;
            downloadParam.author = downFile.author;//这里是用户id
            downloadParam.timestamp = downFile.fileId.replace(/-/g,"");
            downloadParam.fileExt = downFile.fileExt;
            downloadParam.resourceId = downFile.fileId;
            downloadParam.id = downFile.fileId;
            downloadParam.thumburl = downFile.thumburl;
            downloadParam.fileName = downFile.fileName;
            downloadParam.sourcepage = downFile.sourcepage ? downFile.sourcepage : "prepareSource";
            downloadParam.position = downFile.position;
            downloadParam.pageIndex = downFile.pageIndex ? downFile.pageIndex : _this.bookContainer.getPageIndex();
            //获取下载当前页信息
            var pageMeta = _this.bookContainer.getPageMetadata(downloadParam.pageIndex);
            downloadParam.unit1=pageMeta.unit1;
            downloadParam.unit2=pageMeta.unit2;
            downloadParam.unit3=pageMeta.unit3;
            downloadParam.unit4=pageMeta.unit4;
            downloadParam.uid = pageMeta.uid;

            var fileName = downFile.fileName;
            if(fileName.indexOf("."+downFile.fileExt)!=-1){
                fileName=fileName.substring(0,fileName.lastIndexOf("."+downFile.fileExt));
            }
            var file = fileName + "." + downFile.fileExt;
            downloadParam.filepath = file;

            //获取资源下载的存储path(创建)
            var createFolderData = {
                method : "createFolder",
                data : {
                    userName : userLoginName,
                    bookCode : downloadParam.bookcode
                }
            };
            hproseClient.hproseCall(createFolderData, function (createRet) {
                var file_path = "";
                if (createRet.code == -1){
                    _this.removeStorageDownloading(downloadParam.id,true,"资源添加失败");
                } else {
                    var uuid = createRet.data.uuid;
                    var downloadFullPath = createRet.data.path;
                    //文件存储路径(包括文件名)
                    file_path = downloadFullPath + "/" + file;

                    var thumbnail_savePath = "",
                        thumbnail_copyPaths = [];//array
                    // 缩率图下载参数
                    downloadParam.extra_download = [];
                    if (downFile.thumburl && downFile.thumburl != '' && downFile.thumburl != 'none') {
                        // downloadParam.extra_download.push({'url': downFile.thumburl, 'file': [downloadFullPath + '/thumbnail2.jpg']});
                        thumbnail_savePath = path.join(downloadFullPath, downFile.fileId + '.jpg');
                        downloadParam.extra_download.push({'url': downFile.thumburl, 'file': [thumbnail_savePath]});
                        //缩略图下载参数
                        var downloadParamThumbnail = {
                            method : "download",
                            data : {
                                _from : "ib",
                                file : thumbnail_savePath,
                                url : downFile.thumburl,
                                action : "ta_download_thumbnail_photo"
                            }
                        };
                        //发送缩略图下载消息
                        hproseClient.hproseNoti(downloadParamThumbnail);
                    }
                    //资源下载参数
                    var downloadParamRes = {
                        method : "download",
                        data : {
                            _from : "ib",
                            file : file_path,
                            url : downloadParam.file,
                            action : "ta_download",
                            extInfo : downloadParam
                        },
                        extension : {
                            uuid : uuid,
                            userName : userLoginName
                        }
                    };
                    if (currentDArr == 'null'){
                        currentDArr = {};
                    }
                    currentDArr[uuid] = 1;
                    console.log("%c 下载：" + fileName, 'color:green');
                    //发送资源下载消息
                    hproseClient.hproseNoti(downloadParamRes);
                }
            },function(e){
                console.error(e);
                //创建文件夹失败，提示该资源下载失败，并开始下一个资源的下载
                _this.removeStorageDownloading(downloadParam.id,true,"资源添加失败");
            });
            return def.promise();
        };

        /*var download_item = function(downFile,index) {

            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:_ebookContext._curUser._uid,
                module:'01007',
                type:'trigger',
                bookCode:_ebookContext.curBookCode
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);

            var def = $.Deferred();
            var downFile = downFile;
            var index = index;
            var bookMeta = _this.getBookMetaInfo();
            var pageMeta = _this.getCurrPageMetadata();

            var fileId = downFile.fileId;
            var fileName = downFile.fileName;
            var fileExt = downFile.fileExt;
            var fileSize = downFile.fileSize;
            var fileUrl = downFile.fileUrl;
            var author = downFile.author;
            var from = downFile.from;
            if(fileName.indexOf("."+fileExt)!=-1){
                fileName=fileName.substring(0,fileName.lastIndexOf("."+fileExt));
            }
            var file = fileName + "." + fileExt;
            // var file=fileName;
            var date = new Date();
            // var timePath = _resTool.getRandomString();
            var timePath = downFile.fileId.replace(/-/g,"");

            var destFolderPath = _ebookContext.getUser().getUserPpticwsBasePath() + '/'+ timePath;

            var download_params = {};
            download_params.extra_download = [];
            downFile.unit1 = pageMeta ? pageMeta.unit1 : '';
            downFile.unit2 = pageMeta ? pageMeta.unit2 : '';
            downFile.unit3 = pageMeta ? pageMeta.unit3 : '';
            downFile.unit4 = pageMeta ? pageMeta.unit4 : '';
            downFile.timestamp = timePath;
            downFile.fileid = fileId;
            downFile.bookcode = bookMeta.bookCode;
            downFile.filepath = file;
            downFile.lasttime = date.Format('yyyy-MM-dd hh:mm:ss');
            downFile.author = author;
            downFile.from = "beike";
            downFile.localThumbPath=destFolderPath;

            download_params.id = fileId; //这里不要加id属性，区分云资源的fileId
            download_params.resourceId = fileId;
            download_params.url = fileUrl;
            download_params.file = destFolderPath + '/' + file;
            download_params.source = from;
            download_params.extraDate = downFile;
            download_params.key = "file";

            download_params.userId = _ebookContext.getUser().getUid();


            if (downFile.thumburl && downFile.thumburl != '' && downFile.thumburl != 'none'){
                download_params.extra_download.push({'url': downFile.thumburl, 'file': [destFolderPath + '/thumbnail2.jpg']});
            }

            /!*var rawData = JSON.parse(download_params);
            if (!rawData.key) rawData.key = 'prepareFiles';
            var upload_params = {
                id:rawData.id,
                url:rawData.url,
                file:rawData.file,
                key: rawData.key,
                raw_data: data ,
                source: source,
                index:rawData.index,
                evt:"prepare_upload"
            };*!/

            var downloadParam = {
                "config" : {
                    "type":"logic",
                    "action":"ta_download",
                    "id":0,
                    "from":"ib",
                    "to":"ta_dum"
                },
                "data":{
                    "id" : "~" + download_params.id,
                    "key": "file", //用于socket判断逻辑处理流程
                    "url": download_params.url,
                    "file": download_params.file,
                    "source": "prepareFiles",
                    "evt": "prepare_download", //用户回调函数判断事件类型
                    "extra_download":download_params.extra_download,
                    "raw_data": download_params
                }
            };

            fs.exists(destFolderPath, function (exist) {
                // 不存在
                if (!exist) {
                    fs.mkdir(destFolderPath, function(){
                        _this.socketSend(JSON.stringify(downloadParam));
                        console.log("%c 下载：" + fileName, 'color:green');
                    });
                } else {
                        _this.socketSend(JSON.stringify(downloadParam));
                        console.log("%c 下载：" + fileName, 'color:green');
                }
            });
            return def.promise();
        };*/
    };

    //下载全都完成后回调
    prepareResource.prototype.download_after = function(){
        var _this = this;
        var successRes = _this.filestatus.download.success.origin;
        var errorRes = _this.filestatus.download.error.origin;
        if(successRes.length < 1) {
            var tips = tipsDialog({
                "id": "uploadToBeike" + new Date().getTime(),
                "content": "资源添加失败"
            });
        }
        if(successRes.length > 0 && errorRes.length >0) {
            var tips = tipsDialog({
                "id": "uploadToBeike" + new Date().getTime(),
                "content": "已下载" + successRes.length + "个资源,下载失败" + errorRes.length + "个资源"
            });
        }
        if(successRes.length >= 1 && errorRes.length == 0){
            var tips = tipsDialog({
                "id": "uploadToBeike" + new Date().getTime(),
                "content": "文件下载成功"
            });
        }
        //清空队列信息
        _this.clearFileStauts("download");
    };

    //加入课本全部完成后回调
    prepareResource.prototype.to_book_after = function(){
        var _this = this;
        var successRes = _this.filestatus.to_book.success.origin;
        var errorRes = _this.filestatus.to_book.error.origin;
        if(successRes.length < 1) {
            var tips = tipsDialog({
                "id": "uploadToBeike" + new Date().getTime(),
                "content": "资源添加失败"
            });
        }
        if(successRes.length > 0 && errorRes.length >0) {
            var tips = tipsDialog({
                "id": "uploadToBeike" + new Date().getTime(),
                "content": "已添加" + successRes.length + "个资源,添加失败" + errorRes.length + "个资源"
            });
        }
        if(successRes.length >= 1 && errorRes.length == 0){
            // var tips = tipsDialog({
            //     "id": "uploadToBeike" + new Date().getTime(),
            //     "content": "资源添加成功"
            // });
        }
        //清空队列信息
        _this.clearFileStauts("to_book");
    };

    //文件导入 外部设备文件-TA应用-本地DB
    prepareResource.prototype.import = function(importFiles,destFullPath){
        var _this = this;
        var destFullPath = destFullPath;
        var files = [],
            filesCount = 0;
        var files = importFiles,
            filesCount = files.length;

        //记录状态
        _this.filestatus.import.count = filesCount;
        _this.filestatus.import.origin = files;

        //import_before();
        // for(i = 0;i < filesCount;i++) {
        //     (function(index){
        //         setTimeout(function(){
        //             import_item(files[index],index).done(function(rs){
        //                 var rs = {
        //                     "code" : "0",
        //                     "message" : "import this["+ index +"] success",
        //                     "index" : index
        //                 };
        //                 import_process(rs);
        //             }).fail(function(e){
        //                 var rs = {
        //                     "code" : "1",
        //                     "message" : "error",
        //                     "index" : index
        //                 };
        //                 import_process(rs);
        //             });
        //         });
        //     })(i);
        // }

        function import_list (_index , callback) {
            if (_index >= filesCount) {
                callback();
                return ;
            }
            import_item(files[_index] , _index).done(function(){
                var rs = {
                    "code" : "0",
                    "message" : "import this["+ _index +"] success",
                    "index" : _index
                };
                import_process(rs);
                import_list(_index + 1, callback);
            }).fail(function(e){
                var rs = {
                    "code" : "1",
                    "message" : "error",
                    "index" : _index
                };
                import_process(rs);
            });

        }
        import_list(0);

        function import_item(fileFullPath,index) {
            var def = $.Deferred();
            var pageMeta = _this.getCurrPageMetadata();
            var bookMeta = _this.getBookMetaInfo();
            var timestamp = new Date().Format("yyyyMMddhhmmssS") + '_' + index;
            var parseFileName = _resTool.parseFileName(fileFullPath);
            var file = parseFileName.file;
            var fileName = parseFileName.fileName;
            var fileExt = parseFileName.fileExt;
            var size = fs.statSync(fileFullPath).size;
            var condition = {
                "filename" : fileName,
                "unit1" : pageMeta.unit1,
                "unit2" : pageMeta.unit2,
                "unit3" : pageMeta.unit3,
                "unit4" : pageMeta.unit4,
                "timestamp" : timestamp,
                "fileid" : "" ,
                "type" : fileExt,
                "bookcode" : bookMeta.bookCode,
                "filepath" : fileName + fileExt,
                "lasttime" : new Date().Format("yyyy-MM-dd hh:mm:ss"),
                "creator": _ebookContext.getUser().getUserName(),
                "size": size
            };
            //默认模板
            // icw 课件未处理
            var fromPic = null,
                destFileFullPath = null;
            if (fileExt == 'icw'){
                fromPic = _ebookContext.getUser().getPpticwsBasePath() + '/' + 'mr_icw.png';
            }else{
                fromPic = _ebookContext.getUser().getPpticwsBasePath() + '/' + 'mr_ppt.png';
            }

            //创建文件夹
            var destFolderPath = _ebookContext.getUser().getUserPpticwsBasePath() + '/'+ timestamp;

            shellcmd.createDirIfNotExist(destFolderPath).done(function(ret){
                if(!ret){
                    var rs = {
                        "code" : "1",
                        "message" : "create dir error",
                        "index" : index
                    };
                    return def.reject(rs);
                }
                //注意：新增交互式课件时需要重命名文件名称，加入本地备课本不需要在这里重命名文件
                // condition.filename= _this.renameAuto(fileName);
                condition.filepath = condition.filename + '.' + fileExt;

                destFileFullPath = destFolderPath + '/' + condition.filepath;

                //拷贝文件
                shellcmd.copyDir_ext(fromPic , destFolderPath + '/thumbnail.jpg');
                shellcmd.copyDir_ext(fileFullPath , destFileFullPath).done(function(){
                    //写数据库
                    _pptIcwsAccessor.addInfo(condition).done(function(){
                        def.resolve();
                    }).fail(function(){
                        var rs = {
                            "code" : "1",
                            "message" : "db error",
                            "index" : index
                        };
                        def.reject(rs);
                    });
                });
            }).fail(function(){
                var rs = {
                    "code" : "1",
                    "message" : "creat file path error",
                    "index" : index
                };
                def.reject(rs);
            });
            return def.promise();
        };
        //导入前回调
        function import_before(){};
        //导入全都完成后回调
        function import_after(){
            var successRes = _this.filestatus.import.success.origin;
            var errorRes = _this.filestatus.import.error.origin;
            if(successRes.length < 1) {
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "文件导入失败"
                });
            }
            if(successRes.length > 0 && errorRes.length >0) {
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "已导入" + successRes.length + "个资源,导入失败" + errorRes.length + "个资源"
                });
            }
            if(successRes.length >= 1 && errorRes.length == 0){
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "文件导入成功"
                });
            }
            //清空队列信息
            _this.clearFileStauts("import");
        };
        //导入中回调
        function import_process(rs){
            var index = rs && rs.index;
            var code = rs && rs.code;
            //记录状态
            if(code == "0") {
                _this.filestatus.import.success.origin.push(files[index]);
            } else {
                _this.filestatus.import.error.origin.push(files[index]);
            }

            if(_this.filestatus.import.success.origin.length + _this.filestatus.import.error.origin.length >= filesCount) {
                import_after();
            }
            //刷新数据
            _this.getLocalLessonPrepares();
        };
    };

    //文件导出 TA应用-外部设备文件
    prepareResource.prototype.export = function(exportFiles,destFolderPath){
        var _this = this;
        var destFolderPath = destFolderPath;
        var files = [],
            filesCount = 0;
        var files = exportFiles,
            filesCount = files.length;

        //记录状态
        _this.filestatus.export.count = filesCount;
        _this.filestatus.export.origin = files;

        //import_before();
        for(i = 0;i < filesCount;i++) {
            (function(index){
                setTimeout(function(){
                    export_item(files[index],index).done(function(rs){
                        var rs = {
                            "code" : "0",
                            "message" : "export this["+ index +"] success",
                            "index" : index
                        };
                        export_process(rs);
                    }).fail(function(e){
                        var rs = {
                            "code" : "1",
                            "message" : "error",
                            "index" : index
                        };
                        export_process(rs);
                    });
                });
            })(i);
        }

        var export_item = function(fileFullPath,index) {
            var def = $.Deferred();
            var parseFileName = _resTool.parseFileName(fileFullPath);
            var file = parseFileName.file;
            var fileName = parseFileName.fileName;
            var fileExt = parseFileName.fileExt;

            getName(fileName,fileExt,file,destFolderPath).done(function(ret){
                var reTitle = ret;
                var destFileFullPath = destFolderPath.replace(/\\/,'/') + '/' + reTitle;

                //拷贝文件
                shellcmd.copyDir_ext(fileFullPath , destFileFullPath).done(function(){
                    def.resolve();
                });
            });
            return def.promise();
        };

        var getName = function(title,extra,fileName,path){
            var def = $.Deferred();
            var files = fs.readdirSync(path);
            for(var k=0;k<files.length;k++){
                var pointer = files[k].lastIndexOf('.');
                if(pointer!=-1){
                    var extraFilter = files[k].substr(pointer+1).toLowerCase();
                    if(extraFilter == 'ppt'||extraFilter == 'pptx'){
                        files[k] = files[k].substr(0,pointer+1)+extraFilter;
                    }
                }
            }
            if(!existFile(files,fileName)){
                def.resolve(fileName);
            }else{
                var i = 2;
                for(;existFile(files,title + '(' + i + ')' + '.'+ extra);i++){}
                def.resolve(title +'('+ i +')'+ '.' + extra);
            }
            return def.promise();
        };

        var existFile = function(files,name){
            return (JSON.stringify(files).indexOf(name) != -1);
        };

        //导出前回调
        var export_before = function(){};
        //导出全都完成后回调
        var export_after = function(){
            var successRes = _this.filestatus.export.success.origin;
            var errorRes = _this.filestatus.export.error.origin;
            if(successRes.length < 1) {
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "文件导出失败"
                });
            }
            if(successRes.length > 0 && errorRes.length >0) {
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "已导出" + successRes.length + "个资源,导出失败" + errorRes.length + "个资源"
                });
            }
            if(successRes.length >= 1 && errorRes.length == 0){
                var tips = tipsDialog({
                    "id": "uploadToBeike" + new Date().getTime(),
                    "content": "文件导出成功"
                });
            }
            //清空队列信息
            _this.clearFileStauts("export");
        };
        //导出中回调
        var export_process = function(rs){
            var index = rs && rs.index;
            var code = rs && rs.code;
            //记录状态
            if(code == "0") {
                _this.filestatus.export.success.origin.push(files[index]);
            } else {
                _this.filestatus.export.error.origin.push(files[index]);
            }
            if(_this.filestatus.export.success.origin.length + _this.filestatus.export.error.origin.length >= filesCount) {
                export_after();
            }
        };
    };

    //重命名文件
    prepareResource.prototype.renameAuto = function(fileName){
        var _this = this;
        var allInfo = _this.lesssonPrepares.local.origin;
        for (var i = 0 ;i < allInfo.length ; i++){
            if (fileName == allInfo[i].filename){
                var rgExp = /\(\d+\)$/g;
                var matchStr = fileName.match(rgExp);
                if (matchStr){
                    var matchNumber = matchStr[0].match(/\d+/);
                    var curNumberExt = ++matchNumber;
                    fileName = fileName.replace(rgExp , '('+curNumberExt+')');
                } else {
                    fileName += '(2)';
                }
            }
        }
        return fileName;
    };

    prepareResource.prototype.openFileDialog = function (ele) {

        //设置打开文件为可编辑状态
        var _this=this;
        _this.isEditing=true;
        //  _this.openSmartBar();
        //  _this.setIsEditing(_this.isEditing);


        var self = this;
        var domEle = ele;
        return function () {
            var extFilter = _defaultDefine.extFilter;
            var ret = "", index = 0, type = extFilter.type;
            var calcFilter = function (arr) {
                var extArr = "";
                var args = arguments;
                if (arr instanceof  Array) {
                    for (var k = 0; k < arr.length; ++k) {
                        extArr += '*' + arr[k] + ';';
                    }
                }
                else if (arr instanceof Object) {
                    $.each(arr, function (i, e) {
                        extArr += args.callee(e);
                    });
                }
                return extArr;
            };

            $.each(extFilter.array, function (i, e) {
                var extArr = calcFilter(e);
                ret += type[index] + "|" + extArr + ";|";
                ++index;
            });
            /// 使用新的opendialog 方法
            ret = { "multi": true, "ext": []};
            shellcmd.openFileDialog(ret).done(
                function (result) {
                    if (result) {
                        var _userName = decodeURI(_ebookContext.getUser()._userName) || _ebookContext.getUser()._name;
                        self.bookContainer.insertWidget(result, {userName: _userName});
                        $(domEle).removeClass('current');
                        //监管
                        var action = LogManager.action.trigger;
                        var params = {};
                        params.module = '1130306';
                        var user_id = _ebookContext.getUser().getUid();
                        if(user_id != '0' && user_id){
                            params.user_id =user_id;
                        }
                        LogManager.statistics(action,params);
                    }
                });
        }
    };

    //备课本数据导入到课本页面
    prepareResource.prototype.preparesToContent = function(filepath) {

    };

    //打开本地备课本文件(调用本机默认打开文件程序)
    prepareResource.prototype.openLocalPrepareFile = function(filepath){
        var _this = this;
        shellcmd.isFileExist(filepath).done(function(ret) {
            if(ret){
                var openfileHandle = _child_process.exec;
                openfileHandle('start "" "'+filepath+'"');
            } else {
                _this.showCommonTip({
                    "title": "温馨提示",
                    "content": "本地文件不存在"
                });
            }
        });
    };

    prepareResource.prototype.existDbFile = function(dbFolderPath) {
        var _this = this;
        var def = $.Deferred();
        shellcmd.fileOrDirExist(dbFolderPath).done(function(ret){
            def.resolve(ret);
        });
        return def.promise();
    };

    prepareResource.prototype.copyTemplateDb = function(destFolderPath) {
        var _this = this;
        var def = $.Deferred();
        shellcmd.createDirIfNotExist(destFolderPath).done(function(ret) {
            if (!ret) {
                return def.reject();
            }
            var template_db = _ebookContext.getUser().getPpticwsBasePath() + '/' + 'file.db';
            var dbFullPath = destFolderPath + '/' + 'file.db';
            //拷贝文件
            shellcmd.copyDir_ext(template_db, dbFullPath).done(function(ret1){
                def.resolve(true);
            });
        });
        return def.promise();
    };

    prepareResource.prototype.debug_lessonprepare = function(type,$container){
        $container.find(".debug").hide();
        //开发者模式新增操作按钮
        if($("#debug_control").is(":checked")) {
            if (type == "local") {
                $container.find(".local").show();
            }
            if (type == "edc_cloud") {
                $container.find(".edc_cloud").show();
            }
        }
    }


    exports.Instance = new prepareResource();
})


