define(function(require, exports, module){
    require('jquery');
    var shellcmd = require('../../../common/shellcmd'),
        _ebookContext = require('../../ebookcontext').Instance,
        sqlite3 = nodereq("sqlite3").verbose(),
        fs = nodereq("fs");

    var KeiJianType = {
        "PPT": "ppt",
        "PPTX": "pptx",
        "ICW": "icw"
    };

    function PptIcwsAccessor() {
        var _self = this;

        _self.allInfo = [];

        _self.type = KeiJianType.PPT;
        //云端id
        _self.fileid = "";
        //显示给用户看的名称
        _self.filename = "用户自定义名称";
        //文件夹时间戳
        _self.timestamp = "";
        //文件物理地址名称
        _self.filepath = "文件名";

        _self.unit1 = "";
        _self.unit2 = "";
        _self.unit3 = "";
        _self.unit4 = "";
        _self.bookcode = "";
        _self.usedtime = 0;
        _self.lasttime = "";
        _self.creator = "";
        _self.size = 0;

        _self.init = function (user) {
            var _self = this;
            _self.uid = user.getUid();
            _self.username = user.getUserName();
            _self.basepath = user.getUserPpticwsBasePath();
            _self.dbpath = user.getUserPpticwsBasePath() + '/file.db';
        };

        _self.serializeItem = function(type,fileid,filename,timestamp,filepath,unit1,unit2,unit3,unit4,bookcode,usedtime,lasttime,creator,size){
            var _self = this;
            _self.type = type;
            _self.fileid = fileid;
            _self.filename = filename;
            _self.timestamp = timestamp;
            _self.filepath = filepath;
            _self.unit1 = unit1;
            _self.unit2 = unit2;
            _self.unit3 = unit3;
            _self.unit4 = unit4;
            _self.bookcode = bookcode;
            _self.usedtime = usedtime;
            _self.lasttime = lasttime;
            _self.creator = creator;
            _self.size = size;
        };

        //查询所有记录
        _self.getAllInfo = function () {
            var def = $.Deferred();
            var dbpath = _self.dbpath;
            var db = new sqlite3.Database(dbpath);
            // //
            db.all("PRAGMA table_info(ppticws)", function (err, rows) {
                var creator = rows.filter(function (el) {
                    return el.name == "creator"
                });
                if (creator == "") {
                    db.run("ALTER TABLE  ppticws  ADD creator varchar(255) default " + _self.username);
                }
                var size = rows.filter(function (el) {
                    return el.name == "size"
                });
                if (size == "") {
                    db.run("ALTER TABLE  ppticws  ADD size int default 0");
                }
                db.close();
            });
            // // 从数据库中取得所有数据
            db.all("SELECT * FROM ppticws", function (err, rows) {
                rows.forEach(function (el) {
                    try{
                        el.size = fs.statSync(_self.basepath + '/' + el.timestamp + '/' + el.filepath).size;
                    }catch (e){
                        //文件不存异常处理
                    }
                });
                db.close();
                _self.allInfo = _self.formatDBInfo(rows);
                def.resolve();
            });
            return def.promise();
        };

        //添加记录到TA数据库
        _self.addInfo = function (item) {
            var def = $.Deferred();
            var dbpath = _self.dbpath;
            var sqlite3 = nodereq('sqlite3').verbose();
            var db = new sqlite3.Database(dbpath);

            var title = _self._getName(item.filename,item.type,function(title){
                if(title !== item.filename){
                    item.filename = title;
                }
                //不希望数据库中出现undefined才写的这两句
                if(!item.secondType){
                    item.secondType="";
                };
                // var selectSql="select fileid from ppticws where fileid='"+item.fileid +"'";
                var selectSql="select fileid from ppticws where fileid='"+item.fileid+"'and unit1= '"+item.unit1+"'and unit2='"+item.unit2+"' and unit3='"+item.unit3+"'and unit4='"+item.unit4+"' ";
                var insertSql = "insert into ppticws  values('"+
                    item.filename.replace(/'/g,'\'\'') + "','" + item.unit1 + "','" + item.unit2 + "','" +
                    item.unit3 + "','"+ item.unit4 + "','"+ item.timestamp + "','"+
                    item.fileid + "','"+ item.type +"','"+  item.bookcode + "','"+item.secondType+"','iflybook','0','0','"+
                    item.filepath.replace(/'/g,'\'\'') +"','0','"+item.lasttime+ "','"+
                    item.creator + "','"+ item.size +
                    "')";
                var updataSql="update ppticws set lasttime='"+item.lasttime +"' where fileid='"+ item.fileid +"' and timestamp='"+ item.timestamp+"'";
                //查询sql，判断是否已经存在文件，已存在update，不存在insert
                shellcmd.retriveDbAsyn(dbpath,selectSql).done(function(ret){
                // db.exec(selectSql,function(ret){
                    var result=JSON.parse(ret);
                    if(result.data.length>0){
                        // 如果已经存在文件记录，update
                        db.exec(updataSql, function (err, rows) {
                            if(err){
                                console.log("update TA数据库失败！");
                            }else{
                                console.log("update TA数据库成功!");
                            };
                            db.close();
                        });
                    }else{
                        // 如果没有文件记录，insert
                        db.exec(insertSql, function (err, rows) {
                            if(err){
                                console.log("insert TA数据库失败！");
                            }else{
                                console.log("insert TA数据库成功!");
                            };
                            db.close();
                        });
                    }
                    _self.allInfo.push(item);
                    // db.close();
                    def.resolve(_self.allInfo);
                });
                // shellcmd.executeDbAsyn(dbpath,insertSql);
            });
            return def.promise();
        };

        //为本地文件设置uuid;
        _self.createUuid = function () {
            var s = [];
            var hexDigits = "0123456789abcdef";
            for (var i = 0; i < 36; i++) {
                s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
            }
            s[14] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
            s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01
            s[8] = s[13] = s[18] = s[23] = "";

            var uuid = s.join("");
            return uuid;
        };

        //test queue
        _self.testQueue = function(result){
          setTimeout(function(){
            console.log("这是测试queue能不能正常使用的："+result);
            $(document).dequeue("testQueue");
          },2000);
        };

        /**
         * 拷贝文件并添加记录
         * @param item 存入数据库的信息
         * @param fileFullPath 源文件全路径
         * @returns {*}
         */
        _self.addInfoWithCopyFile = function (item,fileFullPath) {
            var def = $.Deferred();
            //时间戳，即用户目录下自动生成的文件夹名称,使用fileid而不是timestamp是因为反复下载同一资源的问题
            var timestamp = item.timestamp;
            //timestamp，退出
            if(timestamp){
                //文件名（带后缀）
                var filepath = item.filepath;
                //创建文件夹
                var destFolderPath = _ebookContext.getUser().getUserPpticwsBasePath() + '/' + timestamp;
                shellcmd.createDirIfNotExist(destFolderPath).done(function (ret) {
                    if (!ret) {
                        console.log("创建文件夹失败");
                        def.reject(false);
                    }
                    var destFileFullPath = destFolderPath + '/' + filepath;
                    //拷贝文件
                    shellcmd.copyDir_ext(fileFullPath, destFileFullPath).done(function () {
                        //写数据库
                        _self.addInfo(item).done(function () {
                            //写数据库成功
                            console.log("写入TA数据库成功");
                            def.resolve(true);
                        }).fail(function (e) {
                            console.log("写入TA数据库失败");
                            def.reject(false);
                        });
                    }).fail(function(){
                        def.reject(false);
                    });
                }).fail(function (){
                    //创建文件夹方法失败
                    def.reject(false);
                });
            }else{
                def.reject(false);
            }
            return def.promise();
        };

        //获得文件名称（去重处理）
        _self.getName = function(title,callback){
            _self.getAllInfo().done(function(){
                if(!_self.exist(title)){
                    callback&&callback(title);
                }else{
                    var i = 2;
                    for(;_self.exist(title+'('+i+')');i++){
                    }
                    callback&&callback(title+'('+i+')');
                }
            }).fail(function(){
                callback&&callback(title);
            });
        };

        //获得文件名称（去重处理）(这个方法比较新，通过title和type共同判断是否重名，保留上面的方法是担心造成其他地方的问题)
        _self._getName = function(title,type,callback){
            _self.getAllInfo().done(function(){
                if(!_self._exist(title,type)){
                    callback&&callback(title);
                }else{
                    var i = 2;
                    for(;_self._exist(title+'('+i+')',type);i++){
                    }
                    callback&&callback(title+'('+i+')');
                }
            }).fail(function(){
                callback&&callback(title);
            });
        };

        //判断文件名是否存在
        _self.exist = function(title){
            return  (JSON.stringify(_self.allInfo).indexOf(title) != -1);
        };

        //判断文件名是否存在(这个方法比较新，通过title和type共同判断是否重名，保留上面的方法是担心造成其他地方的问题)
        _self._exist = function(title,type){
            var exist=_self.allInfo.filter(function(el){return el.filename==title&&el.type==type});
            if(exist.length<1){
                return false;
            }else{
                return true;
            }
        };

        //删除记录
        _self.deleteInfo = function (timestamp) {
            var def = $.Deferred();
            var dbpath = _self.dbpath;
            var db = new sqlite3.Database(dbpath);
            var sql = "delete from ppticws where timestamp='" + timestamp + "'";

            db.exec(sql, function (err, rows) {
                for(var i = 0,len = _self.allInfo.length ;i<len ;i++){
                    if(_self.allInfo[i].timestamp == timestamp){
                        break;
                    }
                }
                _self.allInfo.splice(i,1);
                db.close();
                def.resolve(_self.allInfo);
            });
            return def.promise();
        };

        //获取所有数据
        _self.selectInfo = function (keys, vals) {
            var def = $.Deferred();
            //不使用缓存，与TA部分本地资源即时同步
            _self.allInfo.length = 0;
            if (_self.allInfo.length > 0) {
                def.resolve(_self.selectHelper(keys, vals));
            } else {
                _self.getAllInfo().done(function () {
                    def.resolve(_self.selectHelper(keys, vals));
                })
            }
            return def.promise();
        };

        //输出数据筛选处理
        _self.selectHelper = function(keys, vals) {
            var i, j,len,lenj,flag,list=[];
            if (keys == undefined || vals == undefined){
                return _self.allInfo;
            }
            if(keys.length && vals.length && vals.length == keys.length ){
                for(i = 0,len = _self.allInfo.length;i<len;i++){
                    flag = 0;
                    for(j=0,lenj=vals.length;j<lenj;j++){
                        if(_self.allInfo[i][keys[j]] != vals[j] && vals[j] != ""){
                            flag = 1;
                            break;
                        }
                    }
                    if(!flag){
                        list.push($.extend({},_self.allInfo[i]));
                    }
                }
                return list;
            }
            return _self.allInfo;
        };

        //修改记录信息(根据timestamp查找需要修改的记录)
        /* params={key:[],
        *           var:[],
        *           timestamp:""
        *           }
        * 其中key和value保持数组长度一致并且一一对应
        * */
        _self.updateInfo = function(keys,vals,timestamp){
            var def = $.Deferred();
            var dbpath = _self.dbpath;
            if(keys.length && vals.length && vals.length == keys.length ){
                var sql = "update ppticws set ";
                for(var i= 0,len = keys.length;i<len;i++){
                    sql += keys[i] + "='" + vals[i] + "',"
                }
                sql = sql.replace(/,$/," where timestamp='" + timestamp + "'");
                var db = new sqlite3.Database(dbpath);
                db.exec(sql, function (err, rows) {
                    //改内存中数据
                    for(var i = 0 ,len = _self.allInfo.length;i<len;i++ ){
                        if(_self.allInfo[i].timestamp == timestamp){
                            for(var j = 0,lenj = keys.length;j<lenj;j++){
                                _self.allInfo[i][keys[j]] = vals[j];
                            }
                        }
                    }
                    db.close();
                    def.resolve(_self.allInfo);
                });
            }
            else{
                def.resolve(_self.allInfo);
            }
            return def.promise();
        };

        //修改记录信息（根据bookcode查找需要修改的记录，适用于整本书的记录修改）
        /* params={key:[],
         *           var:[],
         *           timestamp:""
         *           }
         * 其中key和value保持数组长度一致并且一一对应
         * */
        _self.updateInfoByBookcode = function(keys,vals,bookcode){
            var def = $.Deferred();
            var dbpath = _self.dbpath;
            if(keys.length && vals.length && vals.length == keys.length ){
                var sql = "update ppticws set ";
                for(var i= 0,len = keys.length;i<len;i++){
                    sql += keys[i] + "='" + vals[i] + "',"
                }
                sql = sql.replace(/,$/," where bookcode='" + bookcode + "'");
                var db = new sqlite3.Database(dbpath);
                db.exec(sql, function (err, rows) {
                    //改内存中数据
                    for(var i = 0 ,len = _self.allInfo.length;i<len;i++ ){
                        if(_self.allInfo[i].bookcode == bookcode){
                            for(var j = 0,lenj = keys.length;j<lenj;j++){
                                _self.allInfo[i][keys[j]] = vals[j];
                            }
                        }
                    }
                    db.close();
                    def.resolve(_self.allInfo);
                });
            }
            else{
                def.resolve(_self.allInfo);
            }
            return def.promise();
        };

        //数据库返回结果格式化
        _self.formatDBInfo = function (dbret) {
            var i = 0, len = dbret.length;
            var anslist = [], obj;
            for (; i < len; i++) {
                obj = new KeJianItems();
                obj.initInfo(dbret[i].type,dbret[i].fileid,dbret[i].filename,dbret[i].timestamp,dbret[i].filepath,dbret[i].unit1,dbret[i].unit2,dbret[i].unit3,dbret[i].unit4,dbret[i].bookcode,dbret[i].usedtime,dbret[i].lasttime,dbret[i].creator,dbret[i].size);
                anslist.push(obj);
            }
            return anslist;
        };

        _self.updateTime = function(timestamp,callback) {
            _self.updateInfo(["lasttime"] , [new Date().Format("yyyy-MM-dd hh:mm:ss")] , timestamp).done(function(){
                callback && callback();
            });
        };

        _self.existDbFile = function(dbFolderPath) {
            var _self = this;
            var def = $.Deferred();
            shellcmd.fileOrDirExist(dbFolderPath).done(function(ret){
                def.resolve(ret);
            });
            return def.promise();
        };
    }

    function KeJianItems() {
        var _self = this;

        _self.type = KeiJianType.PPT;
        //云端id
        _self.fileid = "";
        //显示给用户看的名称
        _self.filename = "用户自定义名称";
        //文件夹时间戳
        _self.timestamp = "";
        //文件物理地址名称
        _self.filepath = "文件名";

        _self.unit1 = "";
        _self.unit2 = "";
        _self.unit3 = "";
        _self.unit4 = "";
        _self.bookcode = "";
        _self.usedtime = 0;
        _self.lasttime = "";
        _self.creator = "";
        _self.size = 0;

        _self.initInfo = function (type, fileid, filename, timestamp, filepath, unit1, unit2, unit3, unit4, bookcode, usedtime, lasttime, creator, size) {
            _self.type = type;
            _self.fileid = fileid;
            _self.filename = filename;
            _self.timestamp = timestamp;
            _self.filepath = filepath;
            _self.unit1 = unit1;
            _self.unit2 = unit2;
            _self.unit3 = unit3;
            _self.unit4 = unit4;
            _self.bookcode = bookcode;
            _self.usedtime = usedtime;
            _self.lasttime = lasttime;
            _self.creator = creator;
            _self.size = size;
        }
    }

    exports.Instance = new PptIcwsAccessor();
})