/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-14
 * Time: 上午9:04
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    function WhiteBoardPreView() {
        var _self = this;
        _self.Dom = null;
        _self.Container = null;
    }

    WhiteBoardPreView.prototype.init = function (container) {
        var _self = this;
        _self.Dom = {
            curWBNum: $("#curWBNum"),
            WBNum: $("#WBNum"),
            btnWBView: $("#btnWBView")
        }
        _self.Container = container;
        _self.bindCommands();
    }

    WhiteBoardPreView.prototype.bindCommands = function () {
        var _self = this;

        _self.Dom.curWBNum
            .click(function () {
                this.select();
                _self._pageStr = this.value;
                return false;
            })
            .keydown(function (e) {
                if (e.which == 13) {
                    //13 是 Enter 键的键码
                    var _num = this.value ? parseInt(this.value) : 1;
                    (isNaN(_num)) && (_num =1);
                    _self.turnWB(_num);
                }
                else {
                    if (!(e.which == 46) && !(e.which == 8) && !(e.which == 37) && !(e.which == 39)) {
                        if (!((e.which >= 48 && e.which <= 57) || (e.which >= 96 && e.which <= 105))) {
                            e.returnValue = false;
                            return;
                        }
                    }
                }
            })
            .blur(function () {
                var _num = this.value ? parseInt(this.value) : 1;
                (isNaN(_num)) && (_num =1);
                if(_num){
                    _self._pageStr = this.value;
                    _self.turnWB(_num);
//                    _self.buttons.btnPageView.popover('hide');
                    return false;
                }
                else{
                    this.value = _self._pageStr;
                }
            });;
    }

    WhiteBoardPreView.prototype.turnWB = function (num) {
        var _self = this;
        _self.Container.setPageIndex(num);

        var ebookContext = require('../../ebookcontext').Instance;
        //监管
//        var action = LogManager.action.trigger;
//        var params = {};
//        params.module = '1130412';
//        var user_id = ebookContext.getUser().getUid();
//        if(user_id != '0' && user_id){
//            params.user_id =user_id;
//        }
//        LogManager.statistics(action,params);

    }

    //设置icon的数值方法不由这个类自己调用
    //等container翻页结束之后，由container设置
    WhiteBoardPreView.prototype.setWBIcon = function (num) {
        var _self = this;
        _self.Dom.curWBNum.val(num);
    }

    exports.Instance = new WhiteBoardPreView();
});
