/**
 * 页面预览的icon
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 13-12-31
 * Time: 下午6:24
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports) {

    function PagePreViewIcon() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};
        _self.nowPage = 0 ;
        _self.bookPages = [];

        _self.init = function(controls){
            _self.controls = controls;
        }

        _self.initPages = function(pageproviderPages){
            if(_self.bookPages.length <1){
                _self.bookPages = pageproviderPages;
            }
        }

        /**
         * 设置icon的text值，把nowPage保存在这里
         * @param nowPageNum
         */
        _self.setIcon = function(nowPageNum){
            //如果没有传入新值，则保持原值
            _self.nowPage = nowPageNum ? nowPageNum : _self.nowPage;
            var str1 = "",str2 = "";
            if (_self.bookPages && _self.bookPages.length > 0) {
                var page = _self.bookPages[_self.bookPages.length - 1];
                if(page.pageCode){
                    if (_self.nowPage < _self.bookPages.length) {
                        str1 = _self.bookPages[_self.nowPage - 1].pageCode;
                        str2 = page.pageCode;
                    }
                    else {
                        //显示最后一页的“页码/页数”
                        str1 = page.pageCode ;
                        str2 = page.pageCode;
                    }
                }
                else{
                    //正常情况走不到这里
                    //最后一页没有页码（附录），显示总页数
                    str1 = _self.bookPages[_self.nowPage - 1].pageCode;
                    str2 = _self.bookPages.length;
                }
            }
            if (_self.controls.pageNum && _self.controls.curPageNum) {
                _self.controls.curPageNum.val(str1);
                _self.controls.pageNum.text(str2);
            }
            else {
                //解决不能初始化的问题
                //应该是不会执行到这了
                $("#pageNum").text(str);
            }
        }

        _self.getNowPage = function(){
            return _self.nowPage;
        }
    }

    exports.Instance = new PagePreViewIcon();
});