﻿/**
 *
 */
define(function (require, exports, module) {

    require('xml2json');
    require('browserContext');
    var path = require('../../common/path');
    var model = require('../model');
    var PageItem = require('./pageitem').PageItem;
    var WBItem = require('./wbitem').WBItem;
    var ebkContext = require('../ebookcontext').Instance;
    var shellcmd = require('../../common/shellcmd');
    var trace = require('../trace').Instance;
    var remotebookDirAccess = require('../../common/remotebookdiraccess');
    var bookDirParser = require('../../common/bookdirectoryparser');
    var booklichelper = require('../bookshelf/booklichelper.js');
    var bookAccessor = require('../bookshelf/bookaccessor').Instance;
    var pageXmlParser = require('../../common/pagexmlparser').Instance;
    var async = nodereq("async");

    /**
     * 电子书辅助类
     * 主要获取电子书的数据*/
    function PageProvider() {
        var _self = this;
        //book序列化回来的完整对象
        _self.bookObj = null;
        _self.bookPages = [];
        //页面缩放的比例,当前只有拖拽时用到
        _self.zoomRate = 1;
        // 页数
        _self.pageCount = 0;
        //目录信息
        _self.bookMenu = null;

        /**
         * 页面原始尺寸
         * @type {model.Size}
         */
        _self.bookImageSize = new model.Size();

        _self.bookImageSize.width = 1110;
        _self.bookImageSize.height = 1570;

        _self.WBImageSize = new model.Size();

        /**
         *
         * @type {string}
         */
        _self.bookCode = "";
        //tch 文件
        _self.tchFile = "";
        //tch 的bookid
        _self.tchBookId = "";
        //是否为双语课本
        _self.isDoubleLanguage = false;

        _self.wbnum = 1;

        /**
         * 书本资源路径
         * @type {string}
         */
        _self.audioPlayer = null;
        //保存已经解压出来的pageItem
        _self.pages = [];

        /** @type {Array} 书本资源列表*/
        _self.bookWidgets = [];

        /** @type {Array} 幕布资源列表*/
        _self.fadeWidgets = [];

        _self.setPlayer = function (hotspotPlayer, audioPlayer) {
            hotspotPlayer.init(this);
            this.audioPlayer = audioPlayer;
            var hotspotMgr = require('./hotspot/hotspotmgr');
            hotspotMgr.init(hotspotPlayer);
        }

        _self.getUserBookDir = function () {
            return ebkContext.getUserBookPath();
        }

        _self.getUserBookBaseDir = function () {
            return ebkContext.getUser().getUserBookBasePath();
        }

        _self.getUserToken = function () {
            return ebkContext.getMatchToken();
        }

        _self.getStdEncryptBook = function () {
            return  path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + ".book2"));
        }

        _self.getStdBookLic = function () {
            var lic = path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + ".lic"));
            return lic;
        }

        _self.getBookDirectory = function () {
            var dirPath = path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + ".json"));
            return dirPath;
        }

        _self.getBookMenu = function () {
            var dirPath = path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + ".menu"));
            return dirPath;
        }

        _self.getStdBookDir = function () {
            return ebkContext.getStdBookPath();
        }

        _self.getBookXmlFile = function () {
            return path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + '.xml'));
        }

        _self._getTchFile = function () {
            return path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + '.tch'));
        }

        _self._getWBoardPath = function () {
            return ebkContext.getUser().getUserWBPath();
        }

        /**
         * 合并远程和本地书本目录信息
         * @param bookObj
         * @returns {*} 返回空表示合并失败
         * @private
         */
        _self._mergeBookDirction = function (bookObj) {
            var def = $.Deferred();
            //20140617 ---- 资源网关目录查询修改
            if (!_self.bookObj || !_self.bookObj.IndexInfo || !_self.bookObj.IndexInfo.Code) {  //如果这些信息没有，
                def.resolve(null);
                return def.promise();
            }
            var bookId = _self.bookObj.IndexInfo.Code;
            var remoteAccess = new remotebookDirAccess.RemoteBookDirectoryAccess();
            //先用本地已经下载保存的JSON文件
            remoteAccess.getBookDirFromFile(_self.getBookDirectory()).done(function (content) {
                    if (content) {
                        var downloadDate = new Date(content.DownloadDate);
                        var days = Math.ceil((new Date().getTime() - downloadDate.getTime()) / 86400000);
                        if (isNaN(days) && days > 10&&false) {
                            /**
                             * ‘应该更新一下了’,这里为什么要进行这一步？
                             * 现在出问题了，原因？这里代码进行不下去导致无法打开电子书，
                             * 已经有更新的功能，为什么还要这里的？暂时去掉，待长时间分析，by linwang5@iflytek.com 20160107
                             */
                            remoteAccess.getBookDirFromWeb(_self.getBookDirectory(), bookId, ebkContext.getUser()).done(function (newContent) {
                                if (newContent) {
                                    var bookDirectoryParser = new bookDirParser.BookDirectoryParser(newContent.data, bookObj);
                                    var bookJson = bookDirectoryParser.remoteBookJsonAdjust();
                                    if (bookJson) {
                                        //增加标志位兼容1005版本及之前目录没有调整过
                                        bookJson.isNewMenu = true;
                                        remoteAccess.saveRemoteBookDir(bookJson, _self.getBookDirectory());
                                        def.resolve(bookJson);
                                    } else {
                                        def.resolve(content);
                                    }
                                } else { //如果下载的也不可用，则用随书XML
                                    def.resolve(content);
                                }
                            });
                        } else if( !content.isNewMenu) {
                            //为兼容之前1005版本目录没有调整过做的处理，不能简单通过版本号判断，
                            //原来判断条件 AppCfg.version.split('.')[3] < 1006 不正确，因为升级后，这句话恒不成立
                            shellcmd.isFileExist(_self.getBookMenu()).done(function (ret) {
                                if (ret) {
                                    shellcmd.readFileAsync(_self.getBookMenu()).done(function (menuStr) {
                                        var content = JSON.parse(menuStr);
                                        if (content) {
                                            var bookDirectoryParser = new bookDirParser.BookDirectoryParser(content.data, bookObj);
                                            var bookJson = bookDirectoryParser.remoteBookJsonAdjust();
                                            console.log(bookJson);
                                            if (bookJson) {
                                                //增加标志位兼容1005版本及之前目录没有调整过
                                                bookJson.isNewMenu = true;
                                                remoteAccess.saveRemoteBookDir(bookJson, _self.getBookDirectory());
                                                def.resolve(bookJson);
                                            } else {
                                                def.resolve(null);
                                            }
                                        } else { //如果下载的也不可用，则用随书XML
                                            def.resolve(null);
                                        }
                                    })
                                }
                                else{
                                    remoteAccess.getBookDirFromWeb(_self.getBookDirectory(), bookId, ebkContext.getUser()).done(function (newContent) {
                                        if (newContent) {
                                            var bookDirectoryParser = new bookDirParser.BookDirectoryParser(newContent.data, bookObj);
                                            var bookJson = null;
                                            bookJson = bookDirectoryParser.remoteBookJsonAdjust();
                                            if (bookJson) {
                                                //增加标志位兼容1005版本及之前目录没有调整过
                                                bookJson.isNewMenu = true;
                                                remoteAccess.saveRemoteBookDir(bookJson, _self.getBookDirectory());
                                                def.resolve(bookJson);
                                            } else {
                                                def.resolve(bookObj);
                                            }
                                        } else { //如果下载的也不可用，则用随书XML
                                            var bookDirectoryParser = new bookDirParser.BookDirectoryParser([], bookObj);
                                            bookJson = bookDirectoryParser.localXmlJsonAdjust();
                                            if (bookJson) {
                                                def.resolve(bookJson);
                                            }
                                            else{
                                                def.resolve(bookObj);
                                            }
                                        }
                                    });
                                }
                            })
                        }else{
                            def.resolve(content);
                        }
                    } else { //如果本地JSON文件没有，则第一次组装目录
                        shellcmd.isFileExist(_self.getBookMenu()).done(function (ret) {
                            if (ret) {
                                shellcmd.readFileAsync(_self.getBookMenu()).done(function (menuStr) {
                                    var content = JSON.parse(menuStr);
                                    if (content) {
                                        var bookDirectoryParser = new bookDirParser.BookDirectoryParser(content.data, bookObj);
                                        var bookJson = bookDirectoryParser.remoteBookJsonAdjust();
                                        console.log(bookJson);
                                        if (bookJson) {
                                            //增加标志位兼容1005版本及之前目录没有调整过
                                            bookJson.isNewMenu = true;
                                            remoteAccess.saveRemoteBookDir(bookJson, _self.getBookDirectory());
                                            def.resolve(bookJson);
                                        } else {
                                            def.resolve(null);
                                        }
                                    } else { //如果下载的也不可用，则用随书XML
                                        def.resolve(null);
                                    }
                                })
                            }
                            else{
                                remoteAccess.getBookDirFromWeb(_self.getBookDirectory(), bookId, ebkContext.getUser()).done(function (newContent) {
                                    if (newContent) {
                                        var bookDirectoryParser = new bookDirParser.BookDirectoryParser(newContent.data, bookObj);
                                        var bookJson = null;
                                        bookJson = bookDirectoryParser.remoteBookJsonAdjust();
                                        if (bookJson) {
                                            //增加标志位兼容1005版本及之前目录没有调整过
                                            bookJson.isNewMenu = true;
                                            remoteAccess.saveRemoteBookDir(bookJson, _self.getBookDirectory());
                                            def.resolve(bookJson);
                                        } else {
                                            def.resolve(bookObj);
                                        }
                                    } else { //如果下载的也不可用，则用随书XML
                                        var bookDirectoryParser = new bookDirParser.BookDirectoryParser([], bookObj);
                                        if(app_global_pdfInfo.isExistSimilarbooks){//如果是pdf书本并且没有从云端获取到目录信息，返回null
                                            def.resolve(null);
                                        }else{
                                            bookJson = bookDirectoryParser.localXmlJsonAdjust();
                                            if (bookJson) {
                                                def.resolve(bookJson);
                                            }
                                            else{
                                                def.resolve(bookObj);
                                            }
                                        }
                                    }
                                });
                            }
                        })
                    }
                });


            return def.promise();
        }

        /**
         * 加载书本
         * @param {string} bookCode 书本编号
         */
        _self.loadBook = function (bookCode, errorflag) {
            var def = $.Deferred();
            if (_self.bookCode != bookCode || errorflag) {
                ebkContext.setBookCode(bookCode);
                _self.bookCode = bookCode;
                console.time("_getBookObject");
                _self._getBookObject().done(function (obj) {
                    console.timeEnd("解压_getBookObject");
                    console.log(obj);
                    _self.bookObj = obj;
                    var isNewBookObj = false;
                    _self._mergeBookDirction(obj).done(function (newBookObj) {
                        //如果是pdf书本且有相似书本，显示长度为pdf书本原有长度
                        if(app_global_pdfInfo.isExistSimilarbooks){
                            if(_self.bookObj.pages.length-newBookObj.pages.length<0){
                                newBookObj.pages=newBookObj.pages.slice(0,_self.bookObj.pages.length-1);
                            }
                        }
                        if (newBookObj) {
                            _self.bookObj = newBookObj;
                            isNewBookObj = true;
                        }
                        try {
                            _self.isDoubleLanguage = _self.bookObj.DoubleLanguage === "true";
                            _self.tchBookId = _self.bookObj.IndexInfo.TchId;

                            /**************************************************************
                             * Caution:
                             * 如果Unit只有一个单元，转化成数组
                             * 主要是解决18本人教体验书的打开问题
                             *                ----------  by  yczhu
                             *
                             * 下面这一段现在废除
                             *                ----------   by  yczhu  2015年2月9日13:48:54
                             ****************************************************************/
//                            (!_self.bookObj.Units.Unit.length && _self.bookObj.Units.Unit ) &&
//                            (_self.bookObj.Units.Unit = [_self.bookObj.Units.Unit]);
//
//                            var bookMenu = new Array(_self.bookObj.Units.Unit.length);
//                            for (var i = 0; i < _self.bookObj.Units.Unit.length; i++) {
//                                var unit = _self.bookObj.Units.Unit[i];
//                                var unitPageIndex = "-1", unitPageIndexEnd = "-1";  //单元起始页码
//                                if (unit.Pages.BookPage != null && unit.Pages.BookPage.length > 1) {
//
//                                    unitPageIndex = unit.Pages.BookPage[0].Code;
//                                    unitPageIndexEnd = unit.Pages.BookPage[ unit.Pages.BookPage.length - 1].Code
//                                    _self.bookPages = _self.bookPages.concat(unit.Pages.BookPage);
//                                } else if (unit.Pages.BookPage != null) {
//                                    unitPageIndex = unit.Pages.BookPage.Code;
//                                    unitPageIndexEnd = unit.Pages.BookPage.Code;
//                                    _self.bookPages.push(unit.Pages.BookPage);
//                                }
//                                var unitCode = (i + 1).toString();
//                                if (isNewBookObj) {
//                                    unitCode = unit.UnitCode;
//                                } else {    //服务端unitCode均为两位编码，所以如果不足两位，我们需要在前面添加“0”补足为两位编码
//                                    if (unitCode.length < 2) {
//                                        unitCode = "0" + unitCode;
//                                    }
//                                }
//                                var menuItem = new model.MenuItem(unit.Name, unit.Code, unitPageIndex, unitPageIndexEnd, unitCode);
//                                menuItem.courses = unit.Courses.Course;
//                                bookMenu[i] = menuItem;
//                            }
                            _self.bookMenu = _self.bookObj.Menu;
                            var size = _self.bookObj.PageImageSize;
                            _self.bookImageSize.width = size["Width"];
                            _self.bookImageSize.height = size["Height"];
                            _self.pageCount = _self.bookObj.pages.length;
                            _self.bookPages = _self.bookObj.pages;

//                            if (_self.bookObj.Units && _self.bookObj.Units.Unit) {
//                                _self.pageCount = _self._getPageLength(_self.bookObj);
//                            }
                            def.resolve();
                        } catch (ex) {
                            hideLoading();
                        //    console.error('error caugth by pageprovider loadbook');
                            if (!errorflag) {
                                _self.doLicError(bookCode).done(function (ret) {
                                    if (ret) {
                                        ebkContext.setIsU("");
                                        bookAccessor.changeBookIsU(bookCode,"",ebkContext.getUser().getName());
                                        _self.loadBook(bookCode, true).done(function () {
                                            def.resolve();
                                        })
                                    }
                                    else {
                                        _self.openBookError(bookCode);
                                        def.resolve();
                                    }
                                });
                            }
                            else {
                                _self.openBookError(bookCode);
                                def.resolve();
                            }
                        }
                    })
                });
            } else {
                console.warn('book %s is already loaded');
                def.resolve();
            }
            _self._initDir(_self.bookCode);
            return def.promise();
        };

        _self._initDir = function (bookcode) {
            var tmpDir = path.join(ebkContext.getSysTmpPath(), _self.bookCode, 'audio');
            shellcmd.createDirIfNotExist(tmpDir);
        };

        _self._getPageLength = function (book) {
            return _self.bookPages.length;
        };

        /**
         * 获取书本对象（背景 + 热区）
         * @param bookXml
         */
        _self._getBookObject = function () {
            var isPDF = /pdf_\w+/.test(_self.bookCode);
            var def = $.Deferred();
            
            if(isPDF){
                var bookDir = /file:\/(.*)/.exec(path.join(_self.getStdBookDir(),""))[1];
                var fs = nodereq("fs");
                var json = fs.readFileSync(bookDir+"/pdf.flag");
                var pdfInfo = JSON.parse(json);
                //约定，如果预处理查询到了相似的pdf书本，则在flag文件中写入相似书本的bookcode，反之则不写
                //如果存在bookCode，说明存在相似书本
                var bookCode=pdfInfo.BookCode;
                var similarbookName=pdfInfo.BookName;
                if(bookCode){
                    app_global_pdfInfo.isExistSimilarbooks=true;
                    app_global_pdfInfo.similarBookCode=bookCode;
                    app_global_pdfInfo.bookName=pdfInfo.Title;
                }
                if(similarbookName){
                    setTimeout(function(){
                        $("#showSimilarBookName").show();
                        $("#showSimilarBookName .jxpop-tips div")[0].innerHTML=similarbookName;
                    },3000)
                }
                var pdfs = fs.readdirSync(bookDir);
                    pdfs.splice(pdfs.length-1,1);
                var pages = [];
                pdfs.forEach(function(pdf,idx){
                    pages.push({
                        pageCode: (idx+1).toString(),
                        pageIndex: (idx+1),
                        pdf:pdf
                    })
                })
                AppCfg.useDrm = false;
                def.resolve({
                    "IndexInfo":{
                        "Title": pdfInfo.Title,
                        "Code": bookCode,
                        "Grade":pdfInfo.Grade,
                        "Publisher":pdfInfo.Publisher,
                        "Subject":pdfInfo.Subject,
                        "Volumn":pdfInfo.Volumn
                    },
                    "PageImageSize":{
                        "Width": "1240",
                        "Height": "1754"
                    },
                    "pages": pages
                });
            }
            else{

                var xml = null;
                var bookXml = path.join(_self.getStdBookDir(), _self.bookCode + ".xml");
                bookXml = path.trimPosix(bookXml);
                var xml2BookObj = function (xml) {
                    if (isString(xml)) {
                        if (xml.length > 0) {
                            require('xml2json');
                            var obj = $.xml2json(xml);
                            if (obj.DoubleLanguage === "true") {
                                _self.isDoubleLanguage = true;
                            }
                            return obj;
                        }
                    }
                    return xml;
                };

                
                var ret = shellcmd.isFileExistSync(bookXml);
                if (ret) {
                    //如果找到祼的描述文件,就不使用drm了
                    AppCfg.useDrm = false;
                }
                if (!AppCfg.useDrm) {
                    xml = shellcmd.readFile(bookXml);
                    def.resolve(xml2BookObj(xml));
                }
                else {
                    var file = '{0}.xml'.format(_self.bookCode);
    //                AppCfg.saveDRMXAML = true;
                    if (!AppCfg.saveDRMXAML) {
                        _self.retriveDrmRes(file, '').done(function (res) {
                            xml = res;
                            def.resolve(xml2BookObj(xml));
                        });
                    } else {  //save it
                        var tmpDir = path.join(ebkContext.getSysTmpPath(), _self.bookCode);
                        var saveTo = path.join(tmpDir, file);
                        //调用delphi抽文件之前，先判断临时文件temp/iflytek/bookcode是否存在，不存在则创建，避免了底层的bug
                        var isTmpDir = shellcmd.isDirExistSync(tmpDir);
                        if(!isTmpDir){
                            shellcmd.createDir(tmpDir).done(function(r){
    //                            var ret = shellcmd.isFileExistSync(saveTo);
    //                            if (ret) {
    //                                var xmlFile = shellcmd.readFile(saveTo);
    //                                //把XML保存到磁盘中的整个流程走不通，所以这里注释掉。
    //                                // shellcmd.saveFile(xmlFile, _self.getBookXmlFile());
    //                                def.resolve(xml2BookObj(xmlFile));
    //                            } else {
    //                                _self.retriveDrmRes(file, saveTo).done(function (ret) {
    //                                    def.resolve(xml2BookObj(shellcmd.readFile(saveTo)));
    //                                });
    //                            }
                                //总是重新抽取目录xml，防止由于缓存造成的程序bug
                                _self.retriveDrmRes(file, saveTo).done(function (ret) {
                                      def.resolve(xml2BookObj(shellcmd.readFile(saveTo)));
                                });
                            });
                        }else{
    //                        var ret = shellcmd.isFileExistSync(saveTo);
    //                        if (ret) {
    //                            var xmlFile = shellcmd.readFile(saveTo);
    //                            //把XML保存到磁盘中的整个流程走不通，所以这里注释掉。
    //                            // shellcmd.saveFile(xmlFile, _self.getBookXmlFile());
    //                            def.resolve(xml2BookObj(xmlFile));
    //                        } else {
    //                            _self.retriveDrmRes(file, saveTo).done(function (ret) {
    //                                def.resolve(xml2BookObj(shellcmd.readFile(saveTo)));
    //                            });
    //                        }
                            ////总是重新抽取目录xml，防止由于缓存造成的程序bug
                              _self.retriveDrmRes(file, saveTo).done(function (ret) {
                                   def.resolve(xml2BookObj(shellcmd.readFile(saveTo)));
                              });
                        }



                    }
                }
            }
            return def.promise();
        };

        _self.retriveDrmRes = function (file, saveTo) {
            var def = $.Deferred();
            var zip = _self.getStdEncryptBook();
            var lic = _self.getStdBookLic();
            _self.getUserToken().done(function (token) {
                shellcmd.readEncryptFile(token, zip, lic, file, saveTo).done(function (ret) {
                    def.resolve(ret);
                });
            });

            return def.promise();
        };

        _self.isEncryptFileExist = function (file) {
            var def = $.Deferred();
            var zip = _self.getStdEncryptBook();
            shellcmd.isEncryptFileExist(zip, file).done(function (ret) {
                def.resolve(ret);
            });
            return def.promise();
        };

        /**
         * 解析电子书数据对象
         */
        _self.loadPageItem = function (pageIndex, notUseCurrentPageItem) {
            var def = $.Deferred();
            if (!_self._hasPageItem(pageIndex) || notUseCurrentPageItem) {
                var page = new PageItem(_self, pageIndex, _self.audioPlayer);
                if (notUseCurrentPageItem) {
                    page._isModify = true;
                }
                page.load().done(function () {
                    if(json.TP.useDb){
                        _self.pages.push(page);
                        def.resolve(page);
                    }else{
                        _self.pages.push(page);
                        def.resolve(page);
                    }
                });
            } else {
                def.resolve(_self.getPageItem(pageIndex));
            }
            return def.promise();
        };

        /**
         * 解析电子书widget
         * @param pageIndex 页码
         * @param type [unit,page]
         * @returns {*}
         */
        _self.getTPUnit = function (units) {

            var def = $.Deferred();
            units = units || {};
            var unit1 = units.unit1 || '',
                unit2 = units.unit2 || '',
                unit3 = units.unit3 || '',
                unit4 = units.unit4 || '';
            var condition = {
                method:'getTPUnit',
                data: {
                    userName: ebkContext.getUser().getName(),
                    bookCode: _self.bookCode,
                    unit1: unit1,
                    unit2: unit2,
                    unit3: unit3,
                    unit4: unit4,
                    mtbk: false
                }
            };
            console.log(condition);
            hproseClient.hproseCall(condition,function(ret){
                if(ret && ret.code == 1 && ret.data){
                    var rs = ret.data || [];
                    // 过滤mtbk文件和幕布资源
                    rs = rs.filter(function(el){
                        //解析json字符串
                        var _widgetType;
                        var db_widgetType = el.widgetType + '';
                        try{
                            var multipleType = JSON.parse(db_widgetType);
                            _widgetType = multipleType.widgetType || '';
                        }catch(e){
                            _widgetType = db_widgetType;
                        }
                        return (_widgetType.toLowerCase() != 'mtbk');
                    });

                    def.resolve(rs);
                }else{
                    def.reject(ret);
                }
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        };

        /**
         * 删除授课包widgets
         * @param list ['****','*****']  uuid的字符串数组
         * @returns {*}
         */
        _self.deleteTPUuids = function (lists) {
            var def = $.Deferred();
            var condition = {
                method:'deleteTPUuids',
                data: {
                    userName: ebkContext.getUser().getName(),
                    bookCode: _self.bookCode,
                    list: lists
                }
            };
            hproseClient.hproseCall(condition,function(ret){
                console.log(ret);
                if(ret && ret.code == 1){
                    def.resolve(ret);
                }else{
                    def.reject(ret);
                }
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        };

        /**
         * 批量更新授课文件的名称和描述
         * @param lists [{    //JSON数组
     *                  unit1:'', //新的目录
     *                  unit2:'',
     *                  unit3:'',
     *                  unit4:'',
     *                  uuid:'',
     *                  sort:1,  //排序字段
     *                  pageCode:'',
     *                  pageIndex:'',
     *                  position:'',JSON字符串
     *              }]  每个数组项都是JSON结构
         * @returns {*}
         */
        _self.updateTPP = function (lists) {
            var def = $.Deferred();
            var condition = {
                method:'updateTPP',
                data: {
                    userName: ebkContext.getUser().getName(),
                    list: lists
                }
            };
            console.log(condition);
            hproseClient.hproseCall(condition,function(ret){
                console.log(ret);
                if(ret && ret.code == 1){
                    def.resolve(ret);
                }else{
                    def.reject(ret);
                }
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        };

        /**
         * 批量更新授课文件的名称和描述
         * @param lists [{
         *                  title:'',
         *                  description:'',
         *                  uuid:''
         *              },{}]  每个数组项都是JSON结构
         * @returns {*}
         */
        _self.updateTPE = function (lists) {
            var def = $.Deferred();
            var condition = {
                method:'updateTPE',
                data: {
                    userName: ebkContext.getUser().getName(),
                    list: lists
                }
            };
            console.log(condition);
            hproseClient.hproseCall(condition,function(ret){
                console.log(ret);
                if(ret && ret.code == 1){
                    def.resolve(ret);
                }else{
                    def.reject(ret);
                }
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        };

        /**
         * 批量更新授课文件的名称和描述和resId
         * @param lists [{
         *                  title:'',
         *                  description:'',
         *                  uuid:'',
         *                  resId:"",
         *                  resFrom:""
         *              },{}]  每个数组项都是JSON结构
         * @returns {*}
         */
        _self.updateTPER = function (lists) {
            var def = $.Deferred();
            var condition = {
                method:'updateTPER',
                data: {
                    userName: ebkContext.getUser().getName(),
                    list: lists
                }
            };
            console.log(condition);
            hproseClient.hproseCall(condition,function(ret){
                console.log(ret);
                if(ret && ret.code == 1){
                    def.resolve(ret);
                }else{
                    def.reject(ret);
                }
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        };

        /**
         * 缓存单元widgets
         * @param units
         * @param data
         * @returns {boolean}
         */
        _self.setBookWidgets = function(units,data){
            //清空原pageIndex缓存的数据
            units = units || {};
            data = data || [];
            var unit1 = units.unit1 || '',
                unit2 = units.unit2 || '',
                unit3 = units.unit3 || '',
                unit4 = units.unit4 || '';

            //待缓存的数据ids
            var idsInUnitCache = [];
            //单元数据
            var unitData = [];
            //新增的数据
            var addData = [];

            //该单元缓存的数据
            unitCacheData = _self.bookWidgets.filter(function(el){
                //去掉幕布资源
                if(el.unit1 == unit1 && el.unit2 == unit2 && el.unit3 == unit3 && el.unit4 == unit4 && el.WidgetType != "fadeCurtain"){
                    return true;
                }else{
                    return false;
                }
            });

            for(var i = 0,count = unitCacheData.length; i < count; i++){
                idsInUnitCache.push(unitCacheData[i].uuid);
            }
            //去掉幕布资源
            addData = data.filter(function(el){
                if(el.widgetType == "fadeCurtain"){
                    return false;
                }else{
                    if(-1 == jQuery.inArray(el.uuid,idsInUnitCache)){
                        return true;
                    }else{
                        return false;
                    }
                }
            });
            console.log(addData);
            _self.bookWidgets = jQuery.merge(_self.bookWidgets,addData);
            return true;
        };

        /**
         * 更新widget
         * @param units
         * @param data
         * @returns {boolean}
         */
        _self.updateBookWidget = function(widget){
            var newBookWidgets = _self.bookWidgets.filter(function(el){
                if(el.uuid != widget.uuid){
                    return true;
                }else{
                    return false;
                }
            });
            //去掉幕布资源
            if(widget.WidgetType != "fadeCurtain"){
                newBookWidgets.push(widget);
                //更新缓存数据
                _self.bookWidgets = newBookWidgets;
            }else{
                _self.fadeWidgets.push(widget);
            }
            return widget;
        };

        /**
         * 移除widget
         * @param uuid
         * @returns {*}
         */
        _self.deleteBookWidget = function(uuid){
            if(!uuid){
                return false;
            }
            var widget = null;
            var newBookWidgets = _self.bookWidgets.filter(function(el){
                if(el.uuid != uuid){
                    return true;
                }else{
                    widget = el;
                    return false;
                }
            });
            if(widget){
                //更新缓存数据
                _self.bookWidgets = newBookWidgets;
                return widget;
            }else{
                return false;
            }
        };

        /**
         * 查找widget
         * @param units
         * @param data
         * @returns {boolean}
         */
        _self.findBookWidget = function(uuid){
            if(!uuid){
                return false;
            }
            var widget = null;
            var newBookWidgets = _self.bookWidgets.filter(function(el){
                if(el.uuid != uuid){
                    return true;
                }else{
                    widget = el;
                    return false;
                }
            });
            if(widget){
                return widget;
            }else{
                return false;
            }
        };

        /**
         * 获取单元widgets
         * @param units
         * @returns {*}
         */
        _self.getBookWidgets = function(units){
            var def = $.Deferred();
            units = units || {};
            var unit1 = units.unit1 || '',
                unit2 = units.unit2 || '',
                unit3 = units.unit3 || '',
                unit4 = units.unit4 || '';
            //读取缓存
            var bookWidgets = _self.bookWidgets.filter(function(el){
                return el.unit1 == unit1 && el.unit2 == unit2 && el.unit3 == unit3 && el.unit4 == unit4;
            });
            // 缓存不存在
            if(bookWidgets.length == 0){
                _self.getTPUnit(units).done(function(ret){
                    //缓存这份数据
                    _self.setBookWidgets(units,ret);
                    def.resolve(ret);
                }).fail(function(e){
                    def.reject([]);
                });
            }else{
                def.resolve(bookWidgets);
            }
            return def.promise();
        }

        /**
         * 根据页获取widgets
         * @param pageIndex
         * @returns {*}
         */
         _self.getWidgetsByPageIndex = function(pageIndex){
            if(pageIndex){
                var bookWidgets = _self.bookWidgets.filter(function(el){
                    return el.pageIndex == pageIndex;
                });
                return bookWidgets;
            }
         }

        _self.getPageItem = function (pageIndex) {
            //针对pageIndex=1, 进行特殊处理
            var flag = true;
            var tempPageItem = null;
            for (var i = 0, len = _self.pages.length; i < len; i++) {
                if (_self.pages[i].pageIndex === pageIndex) {
                    if(((pageIndex == 1) || (pageIndex == _self.pageCount)) && flag){
                        tempPageItem = _self.pages[i];
                        flag = false;
                        continue;
                    }
                    return _self.pages[i];
                }
            }
            return tempPageItem;
        };

        _self._removePageItem = function (pageIndex) {
            _self.pages = _self.pages.filter(function (p) {
                return p.pageIndex != pageIndex;
            });
        };

        _self._removeWBItem = function (pageIndex) {
            _self.pages = _self.pages.filter(function (p) {
                return p.WBIndex != pageIndex;
            });
        };

        _self._hasPageItem = function (pageIndex) {
            return _self.pages.some(function (p, i, arr) {
                return p.pageIndex === pageIndex;
            });
        };

        _self.unloadWBItem = function (WBIndex) {
            $.each(_self.pages, function () {
                (this.WBIndex === WBIndex) && this.unload();
            });
            _self._removeWBItem(WBIndex);
        };


        _self.unloadPageItem = function (pageIndex) {
            $.each(_self.pages, function () {
                (this.pageIndex === pageIndex) && this.unload();
            });
            _self._removePageItem(pageIndex);
        };

        /**
         * 页面卸载
         * @param {boolean=} index 默认为false，只是卸载当前页面，如果为true，则卸载整个书本页面。如从书本跳转到书架
         */
        _self.unloadAllPage = function (index) {
            $.each(_self.pages, function () {
                this.unload(index);
            });
            _self.pages = [];
        };

        /**
         * 获取当前页面的元数据：所属书本、单元、课时
         * @param pageIndex
         */
        _self.getPageMetadata = function (pageIndex) {
            pageIndex = parseInt(pageIndex);//传入的可能是字符串，强制转化为数字
            var metadata = {};
			//index从1开始，但数组从0开始
            var bookpage = _self.bookPages[pageIndex -1];
            //pdf分支，只有pdf书本才会修改书本目录
            if(app_global_pdfInfo.isExistSimilarbooks){
                bookpage=_self.bookPages.filter(function(el){
                    return el.pageIndex==pageIndex;
                })[0];
            }
            //引入pdf分支后，有可能会出现bookpage为undefined的情况（封面页无信息）
            if(bookpage){
                metadata.unit = bookpage.unit1;
                metadata.course = bookpage.unit2;
                metadata.unit1 = bookpage.unit1;
                metadata.unit2 = bookpage.unit2;
                metadata.unit3 = bookpage.unit3;
                metadata.unit4 = bookpage.unit4;
                metadata.unit1Name = bookpage.unit1Name;
                metadata.unit2Name = bookpage.unit2Name;
                metadata.unit3Name = bookpage.unit3Name;
                metadata.unit4Name = bookpage.unit4Name;
            }
            return metadata;

            /**
             * 下面这一坨都不用了，仅留作参考
             *                   ----  by  yczhu
             */

            //获取单元
//            var unitItem;
//            if (pageIndex >= _self.bookMenu[_self.bookMenu.length - 1].pageIndex) {
//                unitItem = _self.bookMenu[_self.bookMenu.length - 1];
//            } else {
//                for (var i = 0; i < _self.bookMenu.length; i++) {
//                    if (pageIndex >= _self.bookMenu[i].pageIndex && pageIndex < _self.bookMenu[i + 1].pageIndex) {
//                        unitItem = _self.bookMenu[i];
//                        break;
//                    }
//                }
//            }
//
//            //获取课时
//            var courseItem;
//            var courses = $.makeArray(unitItem.courses);
//            if (courses && courses.length == 1) {
//                courseItem = courses[0];
//            } else if (courses && courses.length > 1) {
//                courseItem = courses[0];
//                if (pageIndex > courses[0].ImageIndex) {
//                    for (var i = 1; i <= courses.length; i++) {
//                        if (!courses[i]) { //如果超出索引，则认为是最后一课
//                            courseItem = courses[i - 1];
//                            break;
//                        }
//                        if (pageIndex >= courses[i - 1].ImageIndex && pageIndex < courses[i].ImageIndex) {
//                            courseItem = courses[i - 1];
//                            break;
//                        }
//                    }
//                }
//            }
//            var tempUnit = JSON.parse(JSON.stringify(unitItem, ["title", "pageCode", "pageIndex", "unitCode"]));
//            metadata["unit"] = tempUnit;
//            metadata["course"] = courseItem;
        }

        /**
         * 获取当前单元UnitCode
         * @returns {*}
         * @private
         */
        _self.getUnit = function (currPageIndex) {
            var metadata = _self.getPageMetadata(currPageIndex);
            return metadata.unit.unitCode;
        }

        /**
         * 获取当前课时
         * @param currPageIndex
         * @returns {string}
         */
        _self.getCourse = function (currPageIndex) {
            var metadata = _self.getPageMetadata(currPageIndex);
            var courseCode = metadata.course ? metadata.course.Code : "";
            return courseCode;
        }

        /**
         * 获取点读的音频
         * 暂时是MP3,回头转WOV
         */
        _self.getAudioPath = function (audioId, lan) {
            var def = $.Deferred();
            //真实的资源应该是WOV文件
            var audiofile = 'audio/{0}_{1}.wov'.format(audioId, lan);
            //找不到wov就找MP3
            var audiofileMp3 = 'audio/{0}_{1}.mp3'.format(audioId, lan);
            if (!AppCfg.useDrm) {
                var ret = path.trimPosix(path.join(_self.getStdBookDir(), audiofile));
                if (!shellcmd.isFileExistSync(ret)) {
                    ret = path.trimPosix(path.join(_self.getStdBookDir(), audiofileMp3));
                }
                def.resolve(ret);
            }
            else {
                _self.isEncryptFileExist(audiofileMp3).done(function (isexistMp3) {
                    if (isexistMp3) {
                        //使用MP3
                        audiofile = audiofileMp3;
                    }
                    var tmpDir = path.join(ebkContext.getSysTmpPath(), _self.bookCode);
                    var saveTo = path.join(tmpDir, audiofile);

                    var ret = shellcmd.isFileExistSync(saveTo);
                    if (!ret) {
                        var ret = _self.retriveDrmRes(audiofile, saveTo).done(function (result) {
                            //console.log('get audio from drm:', ret);
                            def.resolve(path.trimPosix(saveTo));
                        });
                    } else {
                        def.resolve(path.trimPosix(saveTo));
                    }
                });
            }
            return def.promise();
        }

        _self.loadWBItem = function (wbnum) {
            var def = $.Deferred();
            _self.wbnum = wbnum ? wbnum : _self.wbnum;
            var page = new WBItem(_self, _self.wbnum, _self._getWBoardPath(), _self.audioPlayer);
            page.load().done(function () {
                _self.pages.push(page);
                def.resolve(page);
            });
            return def.promise();
        }

        //处理删除临时文件,该方法在下面doLicError中调用，为解决bug
        _self._handleDelTmpDir = function(){
            var def = $.Deferred();
            //在这个地方删除tmp文件中已经抽取的临时文件--很挫
            var tmpDir = path.join(ebkContext.getSysTmpPath(), _self.bookCode);
//            var saveTo = path.join(tmpDir, file);
            var tmpXml = tmpDir + '/'+_self.bookCode + '.xml';
            var ret = shellcmd.isFileExistSync(path.trimPosix(tmpXml));
            if(ret){
                shellcmd.deleteFile(path.trimPosix(tmpXml)).done(function(rett){
                    def.resolve();
                })
            }else{
                def.resolve();
            }

            return def.promise();
        }

        _self.doLicError = function (bookCode) {
            var def = $.Deferred();
            var userhere = ebkContext.getUser();

            _self._handleDelTmpDir().done(function(){
                //清除lic
                userhere.getUserToken().done(function (token) {
                    var msg = {
                        licfile: path.trimPosix(ebkContext.getUser().getBookLicenseFullPath(bookCode)),
                        token: token
                    }

                    shellcmd.removeResLicFromMem(JSON.stringify(msg)).done(function () {
                        //先获取bookid 再更新lic
                        bookAccessor.getBookId(bookCode, userhere).done(function (retid) {
                            if (retid) {
                                var task1 = shellcmd.getHardwareType();
                                var task2 = shellcmd.getHardwareInfo(userhere.getName());
                                $.when(task1, task2).done(function (hdType, hdInfo) {
                                    booklichelper.callGetBookLicense(retid, bookCode, userhere, hdInfo, hdType).done(function (ret) {
                                        def.resolve(ret);
                                    })
                                })
                            }
                            else {
                                def.resolve();
                            }
                        })

                    });
                });
            })

            return def.promise();
        }

        _self.openBookError = function (bookCode) {
            $.Zebra_Dialog(AppBookShelfTipsList.OpenBookError, {
                'type': 'information',
                'title': AppTips.WarmTips,
                'buttons': [ AppTips.OkTips],
                'onClose': function (capition) {
                    //这个时候需要清除内存中的该书本的LIC，并返回书架
                    ebkContext.getUser().getUserToken().done(function (token) {
                        var msg = {
                            licfile: path.trimPosix(ebkContext.getUser().getBookLicenseFullPath(bookCode)),
                            token: token
                        }
                        shellcmd.removeResLicFromMem(JSON.stringify(msg));
                        var _pageNavigatorHelper = require('../../common/pagenavigatorhelper');
                        _pageNavigatorHelper.goToBookShelf(ebkContext.getUser());
                    })
                }
            });
        }
        /**
        *mtbk解压后的xaml解析
        *@param(path) 实体文件存储的文件夹位置
        *@param(bookCode) 书本code
        *@param(pages) mtbk中包含的pageIndex集合
        */
        _self.xamlToJsons = function(path,bookCode,pages,callback){
            var resList = [];
            console.time("tojson");
            if(pages.length > 0){
                for(var i=0;i<pages.length;i++){
                    var bookmtbkpath = path + "/" + bookCode + "/" + pages[i] + "/" +pages[i] + ".xaml";
                    // var page = new PageItem(null, pages[i], null);
                    var obj =  _self._readPageObjFromXaml(bookmtbkpath);
                    obj.path = path;
                    var list = _self.resToTp(obj,pages[i],bookCode);
                    resList = resList.concat(list);
                }
                
            }
            var length = 0;
            var funs = [];
            console.timeEnd("tojson");
            
           // for(var j = 0;j<resList.length;j++){
           //      (function(j){
           //          $(document).queue("ressaveToTp",function(){
           //              console.time("saveToTp");
           //              _self.saveToTp(resList[j]).done(function(ret){
           //                  console.timeEnd("saveToTp");
           //                  console.log(ret);
           //                  length ++;
           //                  if(length >= resList.length){
                                
           //                      callback && callback();
           //                  }

           //                  $(document).dequeue("ressaveToTp");
           //              }).fail(function(e){
           //                  onsole.timeEnd("saveToTp");
           //                  console.log(e);
           //                  length ++;
           //                  if(length >= resList.length){
           //                      callback && callback;
           //                  }
           //                  $(document).dequeue("ressaveToTp");
           //              }); 
           //          });
           //      })(j);
           //  }
            // $(document).dequeue("ressaveToTp");
            for(var j = 0;j<resList.length;j++){
                (function (j) {
                    funs.push(function (next) {
                        // console.time("saveToTp");
                        var path = resList[j] && resList[j].path;
                        shellcmd.isExistAndFile(path).done(function (ret) {
                            if (ret) {
                                _self.saveToTp(resList[j]).done(function (ret) {
                                    // console.timeEnd("saveToTp");
                                    next(null, ret);
                                }).fail(function (e) {
                                    // console.timeEnd("saveToTp");
                                    next(null, {code: 2});
                                })
                            } else {
                                // console.timeEnd("saveToTp");
                                next(null, {code: 2});
                            }
                        });
                    });
                })(j);

            }
            async.parallelLimit(funs,1,function(err,results){
                console.log(results);
                callback && callback();
            })
        }
        //单页json数据转换为数据库所需的格式
        _self.resToTp = function(obj,pageIndex,bookCode){
            var list = [];
            if(obj){
                var pageObj = obj.absolutelayout;
                var path = obj.path;
                if(pageObj){
                    for(var k in pageObj){
                        if(pageObj[k]){
                            if(pageObj[k].length > 0){
                                for(var i = 0;i< pageObj[k].length;i++){
                                    var p = {};
                                    var src = pageObj[k][i][k] && pageObj[k][i][k].src || pageObj[k][i].file.src || "";
                                    p.userName = ebkContext.getUser()._name;
                                    p.bookCode = bookCode;
                                    p.path = path + "/" + bookCode +"/"+pageIndex+"/"+src;
                                    p.fileName = src;
                                    p.unit1 = _self.getPageMetadata(pageIndex).unit1;
                                    p.unit2 = _self.getPageMetadata(pageIndex).unit2;
                                    p.unit3 = _self.getPageMetadata(pageIndex).unit3;
                                    p.unit4 = _self.getPageMetadata(pageIndex).unit4;
                                    p.uuid = "";
                                    p.title = src;
                                    p.pageCode = "";
                                    p.pageIndex = pageIndex;
                                    p.position = pageObj[k][i].bound;
                                    p.creator = "畅言教育";
                                    p.uploader = "";
                                    p.description = "";
                                    p.widgetId = pageObj[k][i].id;
                                    if(k == "interactiveCard" && pageObj[k][i].type){
                                        p.widgetType =JSON.stringify({"widgetType":k,"secondWidgetType": pageObj[k][i].type});
                                    }else{
                                        p.widgetType = k;
                                    }
                                    p.resId = (pageObj[k][i][k] && pageObj[k][i][k].resourceId) || (pageObj[k][i].file && pageObj[k][i].file.resourceId)|| "";
                                    p.fid = "";
                                    p.source = "";
                                    p.resFrom = "local";
                                    list.push(p);
                                }
                            }else{
                                var p = {};
                                var src = pageObj[k][k] && pageObj[k][k].src || pageObj[k].file.src || "";
                                p.userName = ebkContext.getUser()._name;
                                p.bookCode = bookCode;
                                p.path = path + "/" + bookCode +"/"+pageIndex+"/"+src;
                                p.fileName = src;
                                p.unit1 = _self.getPageMetadata(pageIndex).unit1;
                                p.unit2 = _self.getPageMetadata(pageIndex).unit2;
                                p.unit3 = _self.getPageMetadata(pageIndex).unit3;
                                p.unit4 = _self.getPageMetadata(pageIndex).unit4;
                                p.uuid = "";
                                p.title = src;
                                p.pageCode = "";
                                p.pageIndex = pageIndex;
                                p.position = pageObj[k].bound;
                                p.creator = "畅言教育";
                                p.uploader = "";
                                p.description = "";
                                p.widgetId = pageObj[k].id;
                                if(k == "interactiveCard" && pageObj[k].type){
                                    p.widgetType = JSON.stringify({"widgetType":k,"secondWidgetType": pageObj[k].type});
                                }else{
                                    p.widgetType = k; 
                                }
                                p.widgetType = k;
                                p.resId = (pageObj[k][k] && pageObj[k][k].resourceId ) || (pageObj[k].file && pageObj[k].file.resourceId)|| "";
                                p.fid = "";
                                p.source = "";
                                p.resFrom = "local";
                                list.push(p);
                            }
                        }
                    }
                }
            }
            return list;
        }
        /*
        *保存授课包资源
        *@param(param)
        */
        _self.saveToTp = function(param){
            var def = jQuery.Deferred();
            var p = {
                method:'addTPFile',
                data:{
                    userName:param.userName,
                    bookCode:param.bookCode,
                    path:param.path,
                    fileName:param.fileName || "未知文件",
                    unit1:param.unit1 || "",
                    unit2:param.unit2 || "",
                    unit3:param.unit3 || "",
                    unit4:param.unit4 || "",
                    uuid:param.uuid || "",
                    title:param.title,
                    pageCode:param.pageCode || "",
                    pageIndex:param.pageIndex || "",
                    position:param.position,
                    creator:param.creator || "",
                    uploader:param.uploader || "",
                    description:param.description || "",
                    widgetId:param.widgetId || "",
                    widgetType:param.widgetType || "",
                    resId:param.resId || "",
                    fid:param.fid || "",
                    source:param.source || "",
                    resFrom:param.resFrom || ""
                }
            }
            hproseClient.hproseCall(p,function(ret){
                def.resolve(ret);
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        }
        /*
        *导出mtbk
        *@param(param)
        */
        _self.exportMtbk = function(param){
            var def = jQuery.Deferred();
            var p = {
                method:'exportMtbk',
                data:{
                    userName: ebkContext.getUser().getName(),
                    bookCode: _self.bookCode,
                    dbfiles:param.dbfiles,//导出的数据集合
                    fileName:param.fileName
                }        
            }
            hproseClient.hproseCall(p,function(ret){
                def.resolve(ret);
            },function(e){
                console.error(e);
                def.reject(e);
            }),{timeout:5*60*1000};
            return def.promise();
        }
        /**
        *将数据库中读取的数据转化为xmal
        *@param(file) 文件信息
        *@param(widgetType) 数据类型
        *
        */
        _self.dbFileToXml =function(file,widgetType){
            var xmltype;
            var xmlres;
            //TODO::数据转换
            // if(!isWidget){
                xmlres = _self.dbFormatWidget(file);
            // }else{
            //     xmlres = file;
            // }
            switch(xmlres.WidgetType){
                case 'img':
                    xmltype = "img";
                    break;
                case 'gallery':
                    xmltype = "file";
                    break;
                case 'choice':
                    xmltype = "file";
                    break;
                case 'flash':
                    xmltype = "flash";
                    break;
                case 'video':
                    xmltype = "video";
                    break;
                case 'audio':
                    xmltype = "audio";
                    break;
                case 'exercise':
                    xmltype = "file";
                    break;
                case 'evaluate':
                    xmltype = "file";
                    break;
                case 'onlineRes':
                    xmltype = "file";
                    break;
                case 'proc3rd':
                    xmltype = "file";
                    break;
                case 'note':
                    xmltype = "note";
                    break;
                case 'icw':
                    xmltype = "icw";
                    break;
                case 'imgPaint':
                    xmltype = "imgPaint";
                    break;
                case 'fadeCurtain':
                    xmltype = "fadeCurtain";
                    break;
                case 'vote':
                    xmltype = "vote";
                    break;
                case 'interactiveCard':
                    xmltype = "file";
                    break;
                default :
                    xmltype = "file";
                    break
            };
            var xmlResult = '\n<eb:';
            var widgetContent;
            widgetContent = '\n<'+xmltype+' src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}" timestamp="{12}"  title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />'
                .format(xmlres.File, xmlres.Title ,
                    (xmlres.showTitleFlag === undefined) ? true : xmlres.showTitleFlag ,
                    (xmlres.showIconFlag === undefined) ? true : xmlres.showIconFlag,
                    xmlres.layout.src, xmlres.layout.style,xmlres.description,xmlres.userName,xmlres.uploadTime,xmlres.score,xmlres.userAddressInfo,xmlres.resourceId,xmlres.timestamp);

            widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
                '\n<event action="closed" style="zoomout_anim" />';
             var bound = xmlres.bound || (xmlres.Left+";"+xmlres.Top+";"+xmlres.PlayAreaWidth+";"+xmlres.PlayAreaHeight);
                xmlResult += '{0} id="{1}" bound="{2}" editable="{3}" style="{4}" '
                    .format(xmlres.WidgetType, xmlres.Id,bound, xmlres.IsEditing,xmlres.style.toString());
            if(xmlres.type && xmlres.WidgetType == "interactiveCard"){
               xmlResult += 'type="' + xmlres.type + '"'; 
            }
            xmlResult += ">";
            xmlResult += widgetContent;
            xmlResult += "\n</eb:{0}>".format(xmlres.WidgetType);
            return xmlResult;
        }
        _self.toPageXml = function (files,pageIndex) {
            var hotSpotXaml = "";
            if (hotSpotXaml !== "") hotSpotXaml = "\n<eb:hotspot>" + hotSpotXaml + "\n</eb:hotspot>";
            var widgetsXaml = "";
            $.each(files, function (i, e) {
                widgetsXaml += _self.dbFileToXml(e,e.widgetType);
            });
            if (widgetsXaml !== "") widgetsXaml = "\n<eb:absolutelayout>" + widgetsXaml + "\n</eb:absolutelayout>"
            var xml = "<eb:page background=\"" + pageIndex + ".jpg\" xmlns:eb=\"EBookLib\">" + hotSpotXaml + widgetsXaml + "\n</eb:page>";
            return xml;
        };
        _self.dbFormatWidget = function(file){
            var wtp = parseWidgetTypeField(file.widgetType);
            var p = {
                File: file.extension ? (file.fileName + "." + file.extension) : file.fileName,
                Title: file.fileName,
                showTitleFlag: false,
                showIconFlag: false,
                layout: {
                    src: "",
                    style: ""
                },
                description:file.description || "",
                userName:file.creator || "",
                uploadTime:file.uploadTime || "",
                score:"0",
                userAddressInfo:"",
                resourceId:file.resId || "",
                timestamp:"",
                WidgetType:wtp.widgetType || "",
                Id:file.widgetId || "",
                bound:file.position || "0;120;0;0" ,
                IsEditing:false,
                style:""
            };
            if(file.extension){
                p.realPath = path.join(path.trimPosix(Config.nwexePath), 'user/' + ebkContext.getUser().getName() + '/books/' + file.bookCode + '/' + file.uuid + '/' + file.fileName + '.' + file.extension) || "";
            }else{
                p.realPath = path.join(path.trimPosix(Config.nwexePath), 'user/' + ebkContext.getUser().getName() + '/books/' + file.bookCode + '/' + file.uuid + '/' + file.fileName) || "";
            }
            if(wtp.widgetType == "interactiveCard" && wtp.secondWidgetType){
                p.type =  wtp.secondWidgetType;
            }
            return p;
        }
        //获取当前书本的所有授课资源
        _self.getTpBook = function(){
            var def = jQuery.Deferred();
            var p = {
                method:'getTPBook',
                data:{
                    userName: ebkContext.getUser().getName(),
                    bookCode: _self.bookCode,
                    mtbk:false
                }        
            }
            hproseClient.hproseCall(p,function(ret){
                if(ret && ret.code == 1 && ret.data){
                    def.resolve(ret.data);
                }else{
                    def.reject(ret);
                }
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        }
        /*
        *根据pageIndex批量删除授课资源
        *@param(data) pageIndex的字符
        */
        _self.deleteTPIndex = function(data){
            var def = jQuery.Deferred();
            var p = {
                method:'deleteTPIndex',
                data:{
                    userName: ebkContext.getUser().getName(),
                    bookCode: _self.bookCode,
                    pageIndex:data
                }        
            }
            hproseClient.hproseCall(p,function(ret){
                if(ret && ret.code == 1){
                    def.resolve(ret);
                }else{
                    def.reject(ret);
                }
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        }
        /*
        *添加mtbk资源存至授课包
        *@param(param)
        */
        _self.addMTBKFile = function(param){
            var def = jQuery.Deferred();
            var p = {
                method:'addMTBKFile',
                data:{
                    userName:param.userName,
                    bookCode:param.bookCode,
                    path:param.path,
                    fileName:param.fileName || "未知文件",
                    unit1:param.unit1 || "",
                    unit2:param.unit2 || "",
                    unit3:param.unit3 || "",
                    unit4:param.unit4 || "",
                    uuid:param.uuid || "",
                    title:param.title,
                    pageCode:param.pageCode || "",
                    pageIndex:param.pageIndex || "",
                    position:param.position,
                    creator:param.creator || "",
                    uploader:param.uploader || "",
                    description:param.description || "",
                    widgetId:param.widgetId || "",
                    widgetType:param.widgetType || "",
                    resId:param.resId || "",
                    fid:param.fid || "",
                    source:param.source || "",
                    resFrom:param.resFrom || ""
                }
            }
            hproseClient.hproseCall(p,function(ret){
                def.resolve(ret);
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        }
        /**
         * 获取mtbk里面的书本和index信息
         * @param obj = {
         *      method:'getMTBKInfo',
         *      data:{
         *          path:'d:/demo/example.mtbk' 授课包文件的绝对地址
         *      }
         * }
         * @param cb
         */
        _self.getMTBKInfo = function(path){
            var def = jQuery.Deferred();
            var p = {
                method:'getMTBKInfo',
                data:{
                    path:path
                }
            }
            hproseClient.hproseCall(p,function(ret){
                if(ret && ret.code == 1){
                    def.resolve(ret.data);
                }else{
                    def.reject(ret);
                }
                
            },function(e){
                console.error(e);
                def.reject(e);
            });
            return def.promise();
        }
        /**
         * 获取页面JSON对象
         * @param {String} xaml xaml文件路径
         * @returns {JSON} 转换后的JSON对象
         * @private
         */
        _self._readPageObjFromXaml = function (xaml) {
            console.log(xaml);
            var xml = shellcmd.readFile(xaml);
            if (isString(xml)) {
                if (xml.length > 0) {
                    // console.time('xmltojson: Page');
                    var obj2 = pageXmlParser.ToJSON(xml);
                    // console.timeEnd('xmltojson: Page');
                    return obj2;
                }
            }
            return xml;
        };

        /**
         * 解析数据库widgetType字段
         * @param str 普通字符串或者json字符串
         * @returns {{widgetType: string, secondWidgetType: string}}
         */
        function parseWidgetTypeField(str) {
            var result = {
                widgetType: '',
                secondWidgetType: ''
            };
            // 识别为字符串
            if((typeof str === 'string') && str.length > 0){
                var _widgetType;
                var _secondWidgetType;
                try{
                    var multipleType = JSON.parse(str);
                    _widgetType = multipleType.widgetType || '';
                    _secondWidgetType = multipleType.secondWidgetType || '';
                }catch(e){
                    _widgetType = str;
                }
                result.widgetType = _widgetType;
                result.secondWidgetType = _secondWidgetType;
            }
            // 识别为对象
            if((typeof str === 'object') && c.hasOwnProperty('widgetType')){
                result.widgetType = str.widgetType;
                result.secondWidgetType = str.secondWidgetType;
            }
            return result;
        };

    }


    exports.Instance = new PageProvider();
});