/**
 * Created by linwang5 on 2015/12/8.
 * 此功能是为了用户在选择插入资源的时候选择了网盘插入mtbk资源，导入课本
 */
;
define(function(require,exports,module){
    require('jquery');
    var importRes = require("./importmtbk").Instance;
    var ibWSLogic = require("../../../ibWSLogic");
    var ebookContext = require('../../ebookcontext').Instance;
    var shellcmd = require('../../../common/shellcmd');
    //
    var downTemPath = '', mtbkList = null, _bookContainer, importWebContent=null;
    var folderType = {
        "defaultUser":{
            "yun_mtbk":""
        }
    }; //记录用户特定类型文件夹对应的id
    var singlePageNumber = 6;//可以显示的页码总长度
    //
    var singleMtbkTemplate =
        '<li>'+
            '<div ><img src="assert/static/common/images/icon_32X32/default32.png" alt="图片"></div>'+
            '<div class="resinfo" title="{{title}}">'+
                '<p>{{mtbkName}}</p>'+
                '<p><font>{{updateTime}}</font><font>大小：{{size}}M</font><font>格式：.{{extension}}</font></p>'+
            '</div>'+
            '<div class="resbtn">'+
                '<p><button type="button" fileId="{{fileId}}" class="btn-gray addMtbk_Btn" style="cursor: pointer;">加入课本</button></p>'+
            '</div>'+
       ' </li>';

/*
         '<li class="{{mr28}}">'+
    '<div class="disk_name" title="{{title}}">'+
    '<p>{{mtbkName}}</p>'+
    '</div>'+
    '<a style="cursor: pointer;" fileId="{{fileId}}" class="smartbar_btn w110 " >加入课本</a>'+
    '</li>';*/
    //初始化
    var mtbkoriginlist = [];
    function init(obj){
        mtbkoriginlist = [];
        _bookContainer = obj&&obj._bookContainer||undefined;
        importWebContent = initHtmlDom();
        bindEvent();
        getEdcMtbkList(1);
    }

    function initHtmlDom(){
        var webMtbkContent = $(document.getElementById('webMtbkListPanel_template').innerHTML);
        $("body").append(webMtbkContent);
        var importPanel = webMtbkContent.find("#webMtbkListPanel");
        importPanel.css({  //设置位置
            position: 'absolute',
            left: ($(window).width() - importPanel.outerWidth()) / 2+102,
            top: ($(window).height() - importPanel.outerHeight()) / 2 + $(document).scrollTop()
        }).draggable({               //设置可拖动
            containment: "body",
            handle: ".jxpop-tab"
        });

        return importPanel;
    }
    /*
    * 获取列表已替换为edc接口，该函数废弃
    * --by xinfang3 -20160926
    */
    //获取列表
    function getMtbkList(page){
        var user = ebookContext.getUser();
        importWebContent.find('.disk_list').html('<div style="margin-top:22%;text-align: center;"><img src="assert/images/loadingWebMTBK.gif"><p>正在加载，请稍候...</p></div>')
        var params = {
            uid:user._uid,
            folderType:'yun_mtbk',//仅仅请求mtbk格式的文件
            page:page,
            limit:6,
            order:3,//按创建时间排序
            isDesc:true
        }
       var url = AppRemoteSvcCfg.getFileOnlyList  + $.param(params);
        ebookContext.getUser().getDataByUserToken(url).done(function(ret){
            mtbkList = ret;
            mtbkList.curPage = page;
            showMtbkList();
            getMtbkMoreInfo();
        })

    }

    /*
    * 获取列表edc接口，返回的数据(当前书的mtbk资源以及当前课的mtbk资源,假分页)
    * --by njfu -20170213
    */
    function getEdcMtbkList(page) {
        mtbkList = {};
        mtbkList['total'] = 0;
        mtbkList['data'] = [];
        mtbkList['curPage'] = page;
        var user = ebookContext.getUser();
        importWebContent.find('.disk_list').html('<div style="margin-top:22%;text-align: center;"><img src="assert/images/loadingWebMTBK.gif"><p>正在加载，请稍候...</p></div>');
        var param_core_user = {
            'key': "id",
            'value': user._uid
        };

        edcService.Instance().core_user_get(param_core_user).done(function (ret) {
            if (ret.code == 0) {
                var _user_info = ret.data || {};
                var _openId = _user_info.id || "";

                var requestFiles = {
                    openId: _openId,
                    page: page,
                    limit: 100,
                    extensions: "mtbk", //特定的授课包文件
                    book: _bookContainer.bookCode || "", //特定的授课包文件
                    order: "3" //排序方法（1: 修改时间，2:名称(utf8字符顺序) 3:创建时间）
                };
                edcService.Instance().beike_file_list(requestFiles).done(function (ret) {
                    if(ret && ret.code == 0){
                        var bookobj = _bookContainer.getCurrPageMetadata();
                        var _directly_info = ret.data;
                        _directly_info.fileList = ret.data.fileList.filter(function(el){
                          var cp = el.customProperties;
                          if(!cp.unit1){cp.unit1 = ""};
                          if(!cp.unit2){cp.unit2 = ""};
                          if(!cp.unit3){cp.unit3 = ""};
                          if(!cp.unit4){cp.unit4 = ""};
                          return !cp.unit || (cp.unit1 == bookobj.unit1 && cp.unit2 == bookobj.unit2 && cp.unit3 == bookobj.unit3 && cp.unit4 == bookobj.unit4)
                        });
                        mtbkoriginlist = _directly_info.fileList;
                        if(_directly_info && _directly_info.fileList && _directly_info.fileList.length > 0){
                            mtbkList['data'] = _directly_info.fileList;
                            mtbkList['total'] = _directly_info.fileList.length;
                            mtbkList['curPage'] = page;
                        }
                        showMtbkList(page);
                    }else{
                        showMtbkErr();
                        console.log(ret);
                    }
                }).fail(function(e){
                    showMtbkErr();
                    console.log(e);
                });
            } else {
                showMtbkErr();
                console.log(ret);
            }
        }).fail(function(e){
            showMtbkErr();
            console.log(e);
        });
    }

    /**
     * 获取edc网盘接口特定目录的dirId (该方法不使用了)
     * @param user
     * @param flag
     * @returns {*}
     */
    function getEdcSpecialDirId(user,flag){
        var def = jQuery.Deferred();
        var dirId = "";
        var _openId = user && user.id || "";
        flag = flag || "yun_mtbk";
        if(_openId == ""){
            def.reject(false);
        }
        if(folderType && folderType[_openId] && folderType[_openId]['yun_mtbk'] != ""){
            def.resolve(folderType[_openId]['yun_mtbk']);
        }else {
            //获取mtbk yun_mtb类型的文件夹所在的dirId
            var param_pan_root_directly = {
                "openId": _openId,
                "coverDir": true,
                "coverFile": false,
                "order": "3", //1：修改时间，2：名称，3：创建时间
                "dirId": 0
            };
            edcService.Instance().pan_children_directly(param_pan_root_directly).done(function (ret) {
                if (ret.code == 0) {
                    var _root_folders = ret.data;
                    var folders = _root_folders.fileList || [];
                    if (_root_folders.total > 0) {
                        for (var i = 0, count = folders.length; i < count; i++) {
                            var item = folders[i];
                            if (item.folderType == flag) {
                                dirId = item.fid;
                                break;
                            }
                        }
                        folderType[_openId] = {};
                        folderType[_openId]['yun_mtbk'] = dirId;
                        def.resolve(dirId);
                    } else {
                        def.reject(false);
                    }
                } else {
                    console.log(ret);
                }
            }).fail(function (e) {
                console.log(e);
            });
        }
        return def.promise();
    }

    //绑定事件
    function getMtbkMoreInfo(){
        var data = mtbkList.data;
        var len = data&&data.length?data.length:0;
        for(var i = 0;i<len;i++){
            getEdcFileDetail(data[i].fid).done(function(ret){
                if(!ret||ret==''||typeof ret !== 'object') return;
                 for(var i in mtbkList.data){
                    if(ret.fid == mtbkList.data[i].fid){
                        mtbkList.data[i].downloadpath = ret.fileEntity && ret.fileEntity.downLoadUrl || "";
                        break;
                    }
                 }
            })
        }
    }

    function bindEvent(){
        //绑定导入事件（先下载）
        importWebContent.unbind();
        importWebContent.on('click','.close_Import',function(event){
            importWebContent.parent().remove();
            event.stopPropagation();
        });
        //点击加入课本
        importWebContent.on('click','button.addMtbk_Btn',function(event){
            //add online check.
            var fid = $(this).attr('fileId');
            $.Zebra_Dialog(AppImportAndExportTips.ImportTips, {
                'type': 'question',
                'title': AppTips.WarmTips,
                'buttons': [AppTips.CancelTips, AppTips.OkTips],
                'onClose': function (capition) {
                   if (capition == AppTips.OkTips){
                       var data = mtbkList.data;
                       for(var i = 0;i<data.length;i++){
                           if(fid == data[i].fid){
                               importWebContent.parent().remove();
                               // 缓存的数据，data[i]中本身不存在downloadpath字段
                               // 在此加上异常处理，防止云端返回的filename字段中不包含后缀 by njfu
                               var str = shellcmd.parseFileName(data[i].fileName);
                               if(data[i].downloadpath){
                                    if(str.fileExt != data[i].extension){
                                        data[i].fileName = data[i].fileName + "." + data[i].extension;
                                    }
                                   downLoadMtbk(data[i].downloadpath,data[i].fileName);
                                   break;
                               }else{
                                   $("#loading_tip").remove();
                                   showLoading({tips:AppImportAndExportTips.WebImportDownloading});
                                   getEdcFileDetail(data[i].fid).done(function(ret){
                                       if(ret && ret.fileEntity && ret.fileEntity.downLoadUrl){
                                           mtbkList.data[i].downloadpath = ret.fileEntity && ret.fileEntity.downLoadUrl;
                                           if(str.fileExt != data[i].extension){
                                                data[i].fileName = data[i].fileName + "." + data[i].extension;
                                           }
                                           downLoadMtbk(data[i].downloadpath,data[i].fileName);
                                       }else{
                                           $("#loading_tip").remove();
                                           tipsDialog({
                                               "id":"downloadfail" + new Date().getTime(),
                                               "content":"文件下载失败"
                                           });
                                       }
                                   }).fail(function(e){
                                       $("#loading_tip").remove();
                                       tipsDialog({
                                           "id":"downloadfail" + new Date().getTime(),
                                           "content":"文件下载失败"
                                       });
                                   });
                                   break;
                               }
                           }
                       }
                   event.stopPropagation();

                   }
                }
            });

            event.stopPropagation();
        });

        //点击页码
        importWebContent.on('click','.connent_page input',function(){
            var index = $(this).val();
            if(index=='上一页'){
                // getEdcMtbkList(mtbkList.curPage-1);
                showMtbkList(mtbkList.curPage-1);
            }else if(index=='下一页'){
                showMtbkList(mtbkList.curPage+1);
                // getEdcMtbkList(mtbkList.curPage+1);
            }else{
                var indexInt = parseInt(index);
                // indexInt!=mtbkList.curPage&&getEdcMtbkList(indexInt);
                indexInt!=mtbkList.curPage&&showMtbkList(indexInt);
            }
        });

        importWebContent.on('mouseover','.btn_flip,.btn_flip2',function(){
            var index = $(this).val();
            if(index=='上一页'||index=='下一页'||parseInt(index)!=mtbkList.curPage) this.className='btn_flip2';

        });
        importWebContent.on('mouseout','.btn_flip,.btn_flip2',function(){
            var index = $(this).val();
            if(index=='上一页'||index=='下一页'||parseInt(index)!=mtbkList.curPage) this.className='btn_flip';
        });
    }

    //显示mtbk列表
    /**
     * note(xinfang3):新老接口转换 modifyTime -> modifyTime,name->fileName
     */
    function showMtbkList(page){
      // var data = mtbkList.data;
      mtbkList.curPage = page;
      var start = (page-1)*singlePageNumber;
      var end = (page-1)*singlePageNumber + singlePageNumber;
      var data = mtbkoriginlist.slice(start,end);
      var DomSum = '';
      var len = data&&data.length?data.length:0;
      for(var i = 0;i<len;i++){
          var updateTime= timestampFormat(data[i].modifyTime * 1000,10);
          // var size=data[i].length/1000000;//以兆为单位
          var size=(data[i].length/1024)/1024;//以兆为单位
          size=size.toFixed(2);
          // size=parseFloat(size,2);
         var mr28 = '';
         ((i+1)%3 != 0)&&(mr28='mr28');
          var extension = data[i].extension || 'mtbk';

         var strTmp = singleMtbkTemplate.replace('{{mtbkName}}',data[i].fileName).replace('{{title}}',data[i].fileName).replace('{{fileId}}',data[i].fid).replace('{{updateTime}}',updateTime).replace('{{size}}',size).replace('{{mr28}}',mr28).replace('{{extension}}',extension);
          DomSum += strTmp;
      }
      importWebContent.find('.disk_list').html(DomSum);
      if(!len){
          if(data&&data.length==0){
              importWebContent.find('.disk_list').html('<div style="margin-top:22%;text-align: center;"><img src="assert/images/failWebMTBK.png"><p style="font-size: medium">暂时还没有资源哦~</p></div>');
          }else{
              importWebContent.find('.disk_list').html('<div style="margin-top:22%;text-align: center;"><img src="assert/images/failWebMTBK.png"><p style="font-size: medium">啊哦，资源走失了，等会再试试吧~！</p></div>')
          }
      }
        initIndex();
    }

    function showMtbkErr(){
        importWebContent.find('.disk_list').html('<div style="margin-top:22%;text-align: center;"><img src="assert/images/failWebMTBK.png"><p style="font-size: medium">啊哦，资源走失了，等会再试试吧~！</p></div>')
    }
    //

    function initIndex(){
        importWebContent.find('.connent_page').html('');
        var len = mtbkList&&mtbkList.total?mtbkList.total:0;
        len = Math.ceil(len / singlePageNumber);
        var indexDom = createIndex(mtbkList.curPage,len);
        importWebContent.find('.connent_page').html(indexDom);

    }

     function createIndex(currentPage, totalPages) {
        var domStr = '';
        if (totalPages <= 1) {
            return domStr;
        }
        var halfTotal = totalPages / 2 + 1;
        var distance = 2;
        var stackList = new Array();
        var queueList = new Array();
        var i = 0;
        for (i = currentPage - 1; i >= 1 && (distance + 2 >= totalPages || (halfTotal < currentPage)); i--) {
                stackList.push('<input type="button" style="cursor: pointer;" value="'+i.toString()+'" class="btn_flip"/>');
        }

        for (; stackList.length >= 1;) {
            queueList.push(stackList.pop());
        }
         queueList.push('<input type="button" value="'+currentPage.toString()+'" class="btn_flip2"/>');
        for (i = currentPage + 1; i <= totalPages && (distance + 2 >= totalPages || (halfTotal >= currentPage)); i++) {
            queueList.push('<input type="button" style="cursor: pointer;" value="'+i.toString()+'" class="btn_flip"/>');
        }
        for (var k = 0; k < queueList.length; k++) {
            domStr += queueList[k];
        }
        if(currentPage == 1){
            domStr +='<input type="button" style="cursor: pointer;" value="下一页" class="btn_flip"/>';
        }else if(currentPage== totalPages){
            domStr +='<input type="button" style="cursor: pointer;" value="上一页" class="btn_flip"/>';
        }else{
            domStr +='<input type="button" style="cursor: pointer;" value="上一页" class="btn_flip"/><input type="button" value="下一页" class="btn_flip"/>';
        }

         return domStr;
    }


    function downLoadMtbk(path,name){
        var obj ={
            sourcepage:'webMtbkImport',
            id:_getRandomString(),
            file:path,
            savepath:process.env.TMP||process.env.TEMP,
            filesavename:name
        };
        $("#loading_tip").remove();
        showLoading({tips:AppImportAndExportTips.WebImportDownloading});
        shellcmd.fileDownload(JSON.stringify(obj));

    }

    function onReciveMessage(_data){
        if(_data.data.progress <0){
            hideLoading();
            //show download error
            $.Zebra_Dialog(AppImportAndExportTips.WebImportDownloadfail, {
                'type': 'information',
                'title': AppTips.WarmTips,
                'buttons': [ AppTips.OkTips]
            });
            return;
        }

        if(_data.data.progress >1){
            hideLoading();
            importRes.importBookResFromDownloadPath(_data.data.file);
        }


    }

    /*
     * 获取网盘文件详细信息已替换为edc接口，该函数废弃
     * --by xinfang3 -20160926
     */
    function getFileDetail(fid){
        var user = ebookContext.getUser(),def = $.Deferred();
        var params = {
            method:'pan.file.get',
            uid:user._uid,
            fileId:fid,
            thumbWidth:'120',
            thumbHeight:'90'
        }
        var url = AppSvcHelper.CYSVC+ '&'  + $.param(params);
        ebookContext.getUser().getDataByUserToken(url).done(function(ret){
            def.resolve(ret);
        })
        return def.promise();
    }

    function getEdcFileDetail(fid){
        var user = ebookContext.getUser(),def = $.Deferred();
        var param_core_user = {
            'key':"id",
            'value':user._uid
        };
        edcService.Instance().core_user_get(param_core_user).done(function(ret){
            if(ret.code == 0) {
                var _user_info = ret.data || {};
                var _openId = _user_info.id || "";
                var param_pan_file_detail = {
                    "openId": _openId,
                    "thumbSize": "DEFAULT",
                    "fileId": fid
                };
                edcService.Instance().pan_file_detail(param_pan_file_detail).done(function(ret){
                    if(ret.code == 0){
                        var _file_info = ret.data;
                        def.resolve(_file_info);
                    }else{
                        def.reject(false);
                    }
                }).fail(function(e){
                    def.reject(false);
                });
            }else{
                def.reject(false);
            }
        }).fail(function(e){
            def.reject(false);
        });
        return def.promise();
    }

    /**
     * 生成随机长度的字符串
     * @param len 生成的长度 可选 未传则生成32的
     * @private
     */
    function _getRandomString(len){
        var len = len||32;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
        var maxPos = $chars.length;
        var pwd = '';
        for (var i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd.toLowerCase();
    }

    function timestampFormat(str,length){
        if($.isNumeric(str)){
            var date = new Date(parseInt(str));
            var Y = date.getFullYear() + '-';
            var M = (date.getMonth()+1 < 10 ? '0'+(date.getMonth()+1) : date.getMonth()+1) + '-';
            var D = (date.getDate()+1 < 10 ? '0'+(date.getDate()) : date.getDate()) + ' ';
            var h = date.getHours() + ':';
            var m = date.getMinutes() + ':';
            var s = date.getSeconds();
            str = Y+M+D+h+m+s;
        }
        return str.substr(0, length);
    }

    exports.init = init;
    exports.onReciveMessage = onReciveMessage;

});
