/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 下午4:43
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {

    var actionType = require('../../trace').ActionType;
    var _pageProvider = require('../pageprovider').Instance;
    var _containerHelper = require('../containerhelper');
    var ebookContext = require('../../ebookcontext').Instance;
    var shellcmd = require('../../../common/shellcmd');
    var path = require('../../../common/path');
    var _path = nodereq('path');
    var define = require('../../define');
    var commonfunc = require('../../../common/commonfunc');
    var _pptIcwsAccessor = require('../resbar/ppticwsaccessor').Instance;
    var async = nodereq("async");
    var pageXmlParser = require('../../../common/pagexmlparser').Instance;
    var fs = nodereq("fs");
    var model = require('../../model');

    function ImportRes() {
        var _this = this;
        _this.MainTips = {
            'Error_Mtbk_File_Not_Exist': '授课包文件不存在',
            'Error_Mtbk_File_Read': '读取授课包文件失败',
            'Error_Mtbk_Unzip': '解压授课包文件失败',
            'Status_Mtbk_File_Empty': '您导入的授课包无资源',
            'Error_Sys_Unknow': '未知错误',
            'Error_Calc_File_Md5': '计算文件md5失败',
            'Error_Look_File_Info': '查询文件基本信息失败',
            'Error_Mtbk_Not_Match': '导入的mtbk文件和当前课本不匹配',
            'Error_Delete_TP_Db_Record': '删除授课本数据库记录失败',
            'Status_Import_Failed': '授课包导入失败',
            'Status_Import_Success': '授课包导入成功',
            'Status_Import_User_Cancel': '取消导入授课包',
            // ---- 删除课本资源的tips仅供开发人员快速清除书本资源使用
            'Status_Delete_User_Cancel': '取消删除课本资源',
            'Status_Delete_BookRes_Success': '课本资源删除成功',
            'Status_Delete_BookRes_Failed': '课本资源删除失败'
            // ---- 删除课本资源的tips仅供开发人员快速清除书本资源使用
        };
        // md5计算失败时默认值
        _this.skipMd5 = "unknowMd5";
        // 页码前缀
        _this.pageIndexPreFix = "pageIndex_";
        _this.config = {
            // md5相同时是否根据文件最后修改时间来覆盖原资源
            isOverWriteOnMd5Equal: false,
            // 是否强制计算书本资源md5值
            forceCalcBookResMd5: false,
            // 是否强制计算MTBK资源md5值
            forceCalcMtbkResMd5: false
        };
    }

    /**
     * 生产标准的error结构
     * @param code
     * @param msg
     * @param stack
     * @returns {{code: (*|number), msg: (*|string), stack: (*|{})}}
     */
    ImportRes.prototype.buildError = function (code, msg, stack) {
        var _this = this;
        var code = code || -1,
            msg = msg || "",
            stack = stack || {};
        return {code: code, msg: msg, stack: stack};
    }

    /**
     * 标准的error结构转换为结果文字提示
     * @param e
     * @returns {string}
     */
    ImportRes.prototype.handleErrorToTips = function (e) {
        var _this = this;
        var msg = e && e.msg || "";
        var errorContent = "";
        if (msg) {
            switch (msg) {
                case _this.MainTips.Error_Mtbk_File_Not_Exist:
                    errorContent = _this.MainTips.Error_Mtbk_File_Not_Exist;
                    break;
                case _this.MainTips.Error_Mtbk_File_Read:
                    errorContent = _this.MainTips.Error_Mtbk_File_Read;
                    break;
                case _this.MainTips.Error_Mtbk_Unzip:
                    errorContent = _this.MainTips.Error_Mtbk_Unzip;
                    break;
                case _this.MainTips.Status_Mtbk_File_Empty:
                    errorContent = _this.MainTips.Status_Mtbk_File_Empty;
                    break;
                case _this.MainTips.Error_Sys_Unknow:
                    break;
                case _this.MainTips.Error_Calc_File_Md5:
                    errorContent = _this.MainTips.Error_Calc_File_Md5;
                    break;
                case _this.MainTips.Error_Look_File_Info:
                    errorContent = _this.MainTips.Error_Look_File_Info;
                    break;
                case _this.MainTips.Error_Mtbk_Not_Match:
                    errorContent = _this.MainTips.Error_Mtbk_Not_Match;
                    break;
                case _this.MainTips.Error_Delete_TP_Db_Record:
                    errorContent = _this.MainTips.Error_Delete_TP_Db_Record;
                    break;
                case _this.MainTips.Status_Import_Failed:
                    errorContent = _this.MainTips.Status_Import_Failed;
                    break;
                case _this.MainTips.Status_Import_User_Cancel:
                    errorContent = _this.MainTips.Status_Import_User_Cancel;
                    break;
                default:
                    errorContent = _this.MainTips.Status_Import_Failed;
            }
        } else {
            errorContent = _this.MainTips.Status_Import_Failed;
        }
        return errorContent;
    }

    ImportRes.prototype.importBookRes = function () {
        var _this = this;
        var def = $.Deferred();
        // 保存当前课本资源序号
        $(document).trigger("widgetLoaded", {action: "reset"});
        var tips = '';
        shellcmd.resImport().done(function (ret) {
            var mtbkBookCode = _pageProvider.bookCode;
            var mtbkFilePath = path.trimPosix(path.toPosix(ret.trim()));
            var unzipFolderPath = path.dirname(path.trimPosix(_pageProvider.getUserBookDir()));

            $.Zebra_Dialog(AppImportAndExportTips.ImportTips, {
                'type': 'question',
                'title': AppTips.WarmTips,
                'buttons': [AppTips.CancelTips, AppTips.OkTips],
                'onClose': function (capition) {
                    if (capition == AppTips.OkTips) {
                        _this.importMtbkResByBookCode(mtbkBookCode, mtbkFilePath, unzipFolderPath).done(function (ret) {
                            window.console.log(ret);
                        }).fail(function (e) {
                            window.console.error(e);
                        });
                    } else {
                        tipsDialog({
                            "id": "importing" + new Date().getTime(),
                            "content": _this.MainTips.Status_Import_User_Cancel
                        });
                    }
                }
            });
            // AlertCover(importPath);
        });
        return def.promise();
    }

    ImportRes.prototype.importBookResFromDownloadPath = function (localPath) {
        var _this = this;
        // 保存当前课本资源序号
        $(document).trigger("widgetLoaded", {action: "reset"});
        //此本地路径是网盘中的mtbk下载到本地后的地址
        var mtbkBookCode = _pageProvider.bookCode;
        var mtbkFilePath = path.trimPosix(path.toPosix(localPath.trim()));
        var unzipFolderPath = path.dirname(path.trimPosix(_pageProvider.getUserBookDir()));
        _this.importMtbkResByBookCode(mtbkBookCode, mtbkFilePath, unzipFolderPath).done(function (ret) {
            window.console.log(ret);
        }).fail(function (e) {
            window.console.error(e);
        });
    }

    /**
     * 解压mtbk文件到指定目录
     * @param mtbkFilePath
     * @param unzipFolderPath
     * @returns {*}
     */
    ImportRes.prototype.unzipMtbkFile = function (mtbkFilePath, unzipFolderPath) {
        var _this = this;
        var def = $.Deferred();
        var command = '{"zippath":"' + mtbkFilePath + '","despath":"' + unzipFolderPath + '"}';
        shellcmd.unzip(command).done(function (ret) {
            // ret returns true or false
            if (ret) {
                def.resolve(true);
            } else {
                def.reject(_this.buildError(-1, _this.MainTips.Error_Mtbk_Unzip, ret));
            }
        });
        return def.promise();
    }

    /**
     * 读取mtbk文件概要信息
     * @param mtbkFilePath
     * @returns {*}
     */
    ImportRes.prototype.readMtbkFile = function (mtbkFilePath) {
        var _this = this;
        var def = $.Deferred();
        var safeMtbkFilePath = path.trimPosix(path.toPosix(mtbkFilePath));
        _pageProvider.getMTBKInfo(safeMtbkFilePath).done(function (ret) {
            if (ret && ret.bookCode && ret.pageList && $.isArray(ret.pageList) && ret.pageList.length > 0) {
                var info = {
                    bookCode: ret.bookCode || "",
                    pageList: ret.pageList || []
                };
                def.resolve(info);
            } else {
                def.reject(_this.buildError(-1, _this.MainTips.Status_Mtbk_File_Empty, ret));
            }
        }).fail(function (e) {
            def.reject(_this.buildError(-1, _this.MainTips.Error_Mtbk_File_Read, e));
        });
        return def.promise();
    }

    /**
     * 读取解压后的mtbk文件夹信息（通过读取xaml文件信息）
     * @param bookCode
     * @param folderList
     * @param unzipFolderPath
     */
    ImportRes.prototype.readMtbkFolder = function (bookCode, folderListArr, unzipFolderPath) {
        var _this = this;
        var def = $.Deferred();
        var info = {
            bookCode: bookCode,
            mtbkPagesArr: [],
            mtbkResArr: [],
            rawMtbkInfoArr: []
        };
        var pagesArr = folderListArr || [];
        var pagesCount = pagesArr.length;
        // 判断目录是否为空
        if (pagesCount > 0) {
            var basePath = path.join(path.trimPosix(unzipFolderPath), bookCode);
            var _resArr = [];
            var _rawMtbkInfo = [];
            for (var i = 0; i < pagesCount; i++) {
                var xamlFilePath = path.join(basePath, pagesArr[i], pagesArr[i] + '.xaml');
                // 解析xaml资源
                var xamlObj = _this.readPageObjectFromXaml(xamlFilePath) || {};
                var objToArr = _this.translateXamlObj(xamlObj.absolutelayout);
                objToArr.filter(function (el) {
                    el.pageIndex = pagesArr[i];
                    el.xamlFolderPath = path.join(basePath, pagesArr[i]);
                    return true;
                });
                if (objToArr.length > 0) {
                    _resArr.push.apply(_resArr, objToArr);
                }
                _rawMtbkInfo.push(xamlObj);
            }
            // 判断解析的xaml资源是否为空
            if (_resArr.length > 0) {
                // 赋值
                info.mtbkPagesArr = pagesArr;
                info.mtbkResArr = _resArr;
                info.rawMtbkInfoArr = _rawMtbkInfo;
                setTimeout(function () {
                    def.resolve(info);
                }, 0);
            } else {
                setTimeout(function () {
                    def.reject(_this.buildError(-1, _this.MainTips.Status_Mtbk_File_Empty));
                }, 0);
            }
        } else {
            setTimeout(function () {
                def.reject(_this.buildError(-1, _this.MainTips.Status_Mtbk_File_Empty));
            }, 0);
        }
        return def.promise();
    }

    /**
     * 读取并解析xaml文件
     * @param xaml
     * @returns {*|string}
     * @private
     */
    ImportRes.prototype.readPageObjectFromXaml = function (xaml) {
        var _this = this;
        var xml = null;
        try {
            xml = shellcmd.readFile(xaml);
            if (isString(xml)) {
                if (xml.length > 0) {
                    var obj2 = pageXmlParser.ToJSON(xml);
                    return obj2;
                }
            }
        } catch (e) {
            window.console.error(e);
        }
        return xml;
    }

    /**
     * 转换xmal对象到数组
     * @param absolutelayout
     * @returns {Array}
     */
    ImportRes.prototype.translateXamlObj = function (absolutelayout) {
        var _this = this;
        var resArr = [];
        if (absolutelayout) {
            for (var key in absolutelayout) {
                // key需要是一个字符串，且不能为空
                if (key && typeof key === "string" && key.length > 0 && absolutelayout.hasOwnProperty(key)) {
                    var value = $.makeArray(absolutelayout[key]);
                    $.each(value, function (i, data) {
                        // 卡片类型,注意约定把xaml中的类型字段的第一个字母大写后作为卡片的类型，如absolutelayout.video,则创建define.WidgetType.Video类型的卡片,这样减少许多if else
                        if (data && typeof data === "object") {
                            var cardType = define.WidgetType[key[0].toUpperCase() + key.substr(1)];
                            data.WidgetType = cardType;
                            resArr.push(data);
                        }
                    });
                }
            }
        }
        return resArr;
    }

    /**
     * 解压mtbk文件并解析所有目录xaml文件
     * @param mtbkFilePath
     * @param unzipFolderPath
     * @returns {*}
     */
    ImportRes.prototype.readAndUnzipMtbkFile = function (mtbkBookCode, mtbkFilePath, unzipFolderPath) {
        var _this = this;
        var def = $.Deferred();
        var bookContainer = getGlobalBookContainer();
        mtbkBookCode = mtbkBookCode || _pageProvider.bookCode;
        var eBookCode;
        eBookCode = mtbkBookCode;
        var spendTimeFlag = {
            "readMtbkFile": "读取mtbk文件耗时：",
            "unzipMtbkFile": "解压缩mtbk文件耗时：",
            "readMtbkFolder": "读取xmal文件总耗时："
        }
        window.console.time(spendTimeFlag.readMtbkFile);
        _this.readMtbkFile(mtbkFilePath).done(function (mtbkBaseInfo) {
            window.console.timeEnd(spendTimeFlag.readMtbkFile);
            var bookCode = mtbkBaseInfo.bookCode;
            var pageListArr = mtbkBaseInfo.pageList;
            // 是否匹配当前课本
            if (bookCode && (bookCode == mtbkBookCode || bookCode == eBookCode)) {
                if ($.isArray(pageListArr) && pageListArr.length > 0) {
                    window.console.time(spendTimeFlag.unzipMtbkFile);
                    _this.unzipMtbkFile(mtbkFilePath, unzipFolderPath).done(function (unzipStatus) {
                        window.console.timeEnd(spendTimeFlag.unzipMtbkFile);
                        window.console.time(spendTimeFlag.readMtbkFolder);
                        _this.readMtbkFolder(bookCode, pageListArr, unzipFolderPath).done(function (mtbkResInfo) {
                            window.console.timeEnd(spendTimeFlag.readMtbkFolder);
                            def.resolve({
                                bookCode: bookCode,
                                pageListArr: pageListArr,
                                mtbkPagesArr: mtbkResInfo.mtbkPagesArr,
                                mtbkResArr: mtbkResInfo.mtbkResArr,
                                rawMtbkInfoArr: mtbkResInfo.rawMtbkInfoArr,
                            });
                        }).fail(function (e) {
                            window.console.timeEnd(spendTimeFlag.readMtbkFolder);
                            def.reject(e);
                        });
                    }).fail(function (e) {
                        window.console.timeEnd(spendTimeFlag.unzipMtbkFile);
                        def.reject(e);
                    });
                } else {
                    def.reject(_this.buildError(-1, _this.MainTips.Status_Mtbk_File_Empty));
                }
            } else {
                def.reject(_this.buildError(-1, _this.MainTips.Error_Mtbk_Not_Match));
            }
        }).fail(function (e) {
            window.console.timeEnd(spendTimeFlag.readMtbkFile);
            def.reject(e);
        });
        return def.promise();
    }

    /**
     * 获取文件属性信息
     * @param path
     * @returns {*}
     */
    ImportRes.prototype.fileStat = function (path) {
        var _this = this;
        var def = $.Deferred();
        fs.stat(path, function (err, pro) {
            if (err) {
                window.console.error(err);
                def.reject(err);
            } else {
                def.resolve({
                    path: path,
                    size: pro.size,//B 字节
                    isDir: pro.isDirectory(),
                    isFile: pro.isFile(),
                    atime: pro.atime,
                    ctime: pro.ctime,
                    mtime: pro.mtime
                });
            }
        });
        return def.promise();
    }

    /**
     * 比较两个文件修改时间，返回最新的文件
     * @param bookFileInfo
     * @param mtbkFileInfo
     * @returns {*}
     */
    ImportRes.prototype.getLatestFile = function (filePath1, filePath2) {
        var _this = this;
        var def = $.Deferred();
        $.when(_this.fileStat(filePath1), _this.fileStat(filePath2)).done(function (File1Stat, File2Stat) {
            if (File1Stat.ctime && File2Stat.ctime) {
                var file1_ctime = new Date(File1Stat.ctime).getTime();
                var file2_ctime = new Date(File2Stat.ctime).getTime();
                if (file1_ctime - file2_ctime) {
                    def.resolve({
                        latestFile: filePath1,
                        latestFileStat: File1Stat,
                        olderFile: filePath2,
                        olderFileStat: File2Stat
                    });
                } else {
                    def.resolve({
                        latestFile: filePath2,
                        latestFileStat: File2Stat,
                        olderFile: filePath1,
                        olderFileStat: File1Stat
                    });
                }
            } else {
                def.reject(_this.MainTips.Error_Look_File_Info);
            }
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    }

    /**
     * 比较两个文件的md5是否相同(读取文件信息)
     * @param bookFileInfo
     * @param mtbkFileInfo
     * @returns {*}
     */
    ImportRes.prototype.isMd5Equal = function (filePath1, filePath2) {
        var _this = this;
        var def = $.Deferred();
        $.when(shellcmd.getMd5(filePath1), shellcmd.getMd5(filePath2)).done(function (file1Md5, file2Md5) {
            if (file1Md5 == file2Md5) {
                def.resolve(true);
            } else {
                def.resolve(false);
            }
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    }

    /**
     * 比较两个文件的最后修改时间(读取文件信息)
     */
    ImportRes.prototype.compareFileModifyTime = function (filePath1, filePath2) {
        var _this = this;
        var def = $.Deferred();
        _this.getLatestFile(filePath1, filePath2).done(function (latest) {
            var latestFilePath = latest.latestFile,
                latestFileStat = latest.latestFileStat,
                olderFilePath = latest.olderFile,
                olderFileStat = latest.olderFileStat;
            if (latestFilePath == filePath1) {
                def.resolve({
                    latestFilePath: filePath1,
                    latestFileStat: latestFileStat,
                    olderFilePath: olderFilePath,
                    olderFileStat: olderFileStat
                });
            } else {
                def.resolve({
                    latestFilePath: filePath2,
                    latestFileStat: latestFileStat,
                    olderFilePath: olderFilePath,
                    olderFileStat: olderFileStat
                });
            }
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    }

    /**
     * 比较文件最新修改时间
     * @param bookFileInfo
     * @param mtbkFileInfo
     * @returns {*}
     */
    ImportRes.prototype.isOverwriteFileByModifyTime = function (bookFileInfo, mtbkFileInfo) {
        var _this = this;
        var def = $.Deferred();
        var bookFilePath = bookFileInfo._forImportField.fileFullPath || "",
            mtbkFilePath = mtbkFileInfo._forImportField.fileFullPath || "";
        _this.compareFileModifyTime(bookFilePath, mtbkFilePath).done(function (latest) {
            if (latest.latestFilePath == bookFilePath) {
                def.resolve({
                    isOverwrite: false,
                    latestFileInfo: bookFileInfo,
                    olderFileInfo: mtbkFileInfo,
                    latestFilePath: latest.latestFilePath,
                    latestFileStat: latest.latestFileStat,
                    olderFilePath: latest.olderFilePath,
                    olderFileStat: latest.olderFileStat
                });
            } else {
                def.resolve({
                    isOverwrite: true,
                    latestFileInfo: mtbkFileInfo,
                    olderFileInfo: bookFileInfo,
                    latestFilePath: latest.latestFilePath,
                    latestFileStat: latest.latestFileStat,
                    olderFilePath: latest.olderFilePath,
                    olderFileStat: latest.olderFileStat
                });
            }
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    }

    /**
     * 按pageIndex(页/单元)合并书本资源和mtbk资源
     * @param pageIndex
     * @param mtbkResArr
     * @returns {*}
     * 以要导入mtbk资源为基准，当md5相同时，保留修改时间最近的资源
     * {md5,pageIndex,fileFullPath,fileName}
     */
    ImportRes.prototype.mergeResArr = function (bookResArr, mtbkResArr) {
        var _this = this;
        var def = $.Deferred();
        var md5EqualCount = 0,
            md5EqualArr = [],
            overwriteArr = [];
        var shouldDelResArr = [],
            shouldAddResArr = [];
        var bookResMd5 = {},
            mtbkResMd5 = {};
        /**
         * 计算md5
         * 生成结构体如下：
         * {pageIndex_1:{md5_1:[],md5_2:[]},pageIndex_2:{md5_1:[],md5_2:[]},...}
         */
        bookResArr.forEach(function (val, index, arr) {
            var pageIndex = val._forImportField.pageIndex,
                fileFullPath = val._forImportField.fileFullPath,
                md5 = val._forImportField.md5 || _this.skipMd5;
            var page_key = _this.pageIndexPreFix + pageIndex;
            if (bookResMd5.hasOwnProperty(page_key)) {
                if (bookResMd5[page_key].hasOwnProperty(md5)) {
                    bookResMd5[page_key][md5].push(val);
                } else {
                    bookResMd5[page_key][md5] = [val];
                }
            } else {
                bookResMd5[page_key] = {};
                bookResMd5[page_key][md5] = [val];
            }
        });

        mtbkResArr.forEach(function (val, index, arr) {
            var pageIndex = val._forImportField.pageIndex,
                fileFullPath = val._forImportField.fileFullPath,
                md5 = val._forImportField.md5 || _this.skipMd5;
            var page_key = _this.pageIndexPreFix + pageIndex;
            if (mtbkResMd5.hasOwnProperty(page_key)) {
                if (mtbkResMd5[page_key].hasOwnProperty(md5)) {
                    mtbkResMd5[page_key][md5].push(val);
                } else {
                    mtbkResMd5[page_key][md5] = [val];
                }
            } else {
                mtbkResMd5[page_key] = {};
                mtbkResMd5[page_key][md5] = [val];
            }
        });

        var funcList = [];
        for (var i = 0, count = mtbkResArr.length; i < count; i++) {
            var val = mtbkResArr[i];
            var pageIndex = val._forImportField.pageIndex,
                fileFullPath = val._forImportField.fileFullPath,
                md5 = val._forImportField.md5;
            var page_key = _this.pageIndexPreFix + pageIndex;
            if (bookResMd5.hasOwnProperty(page_key) && bookResMd5[page_key].hasOwnProperty(md5) && (md5 != _this.skipMd5)) {
                /**
                 * 要导入的资源和课本资源md5重复(保留最新的)
                 * 需求变动：md5重复资源保留书本资源，不作覆盖处理
                 */
                if (_this.config.isOverWriteOnMd5Equal && $.isArray(bookResMd5[page_key][md5]) && (bookResMd5[page_key][md5].length == 1)) {
                    (function (bookFileInfo, mtbkFileInfo) {
                        funcList.push(function (next) {
                            _this.isOverwriteFileByModifyTime(bookFileInfo, mtbkFileInfo).done(function (overObj) {
                                next(null, {code: 1, data: overObj});
                            }).fail(function (e) {
                                next(null, {code: -1, error: e});
                            });
                        });
                    })(bookResMd5[page_key][md5][0], val);
                } else {
                    md5EqualCount++;
                    md5EqualArr.push(bookResMd5[page_key][md5][0]);
                    // 页面上存在多个md5相同资源..不作覆盖处理
                    // pass
                }
            } else {
                // 要导入的资源是新资源
                shouldAddResArr.push(val);
            }
        }

        if (funcList.length > 0) {
            async.parallelLimit(funcList, 5, function (err, results) {
                for (var i = 0, count = results.length; i < count; i++) {
                    var item = results[i] || {};
                    var compareRs = item.data || {};
                    if (compareRs.isOverwrite == true) {
                        // 记录覆盖时position
                        shouldDelResArr.push(compareRs.olderFileInfo);
                        shouldAddResArr.push(compareRs.latestFileInfo);
                        overwriteArr.push(compareRs.olderFileInfo);
                    } else {
                        // 不覆盖 pass
                        md5EqualCount++;
                        md5EqualArr.push(bookResMd5[page_key][md5][0]);
                    }
                }
                def.resolve({
                    shouldDelResArr: shouldDelResArr,
                    shouldAddResArr: shouldAddResArr,
                    md5EqualCount: md5EqualCount,
                    md5EqualArr: md5EqualArr,
                    overwriteArr: overwriteArr
                });
            });
        } else {
            def.resolve({
                shouldDelResArr: shouldDelResArr,
                shouldAddResArr: shouldAddResArr,
                md5EqualCount: md5EqualCount,
                md5EqualArr: md5EqualArr,
                overwriteArr: overwriteArr
            });
        }
        return def.promise();
    }

    /**
     * 删除书本资源（同步删除数据库记录和书本widget）
     * @param deleteResArr
     * @returns {*}
     */
    ImportRes.prototype.deleteBookResByUuid = function (deleteResArr) {
        var _this = this;
        var def = $.Deferred();
        var nowPageItems = {};
        var sortedRes = {};
        var task = [];
        var errorCount = 0,
            okCount = 0;
        if (deleteResArr.length > 0) {
            _pageProvider.pages.forEach(function (val, index, arr) {
                var pageIndex = val.pageIndex;
                if (pageIndex) {
                    var page_key = _this.pageIndexPreFix + pageIndex;
                    if (!nowPageItems.hasOwnProperty(page_key)) {
                        nowPageItems[page_key] = val;
                    }
                }
            });

            for (var i = 0, count = deleteResArr.length; i < count; i++) {
                var resObj = deleteResArr[i];
                var pageIndex = resObj._forImportField.pageIndex;
                var page_key = _this.pageIndexPreFix + pageIndex;
                if (!sortedRes.hasOwnProperty(page_key)) {
                    sortedRes[page_key] = [];
                }
                sortedRes[page_key].push(resObj);
            }

            var deleteResInBook = function (next, uuidArr, pageItem) {
                var def = $.Deferred();
                if ($.isArray(uuidArr) && uuidArr.length > 0) {
                    pageItem.removeWidgetByUuid(uuidArr, false).done(function (ret) {
                        next(null, {code: 1, data: uuidArr});
                    }).fail(function (e) {
                        next(null, {code: -1, error: e});
                    });
                } else {
                    next(null, {code: 1, data: []});
                }
                return def.promise();
            }

            var deleteResNotInBook = function (next, uuidArr) {
                var def = $.Deferred();
                if ($.isArray(uuidArr) && uuidArr.length > 0) {
                    _pageProvider.deleteTPUuids(uuidArr).done(function (ret) {
                        next(null, {code: 1, data: uuidArr, rawData: ret});
                    }).fail(function (e) {
                        next(null, {code: -1, error: e});
                    });
                } else {
                    next(null, {code: 1, data: []});
                }
                return def.promise();
            }

            for (var page_key in sortedRes) {
                if (sortedRes.hasOwnProperty(page_key)) {
                    var uuids = [];
                    sortedRes[page_key].filter(function (el) {
                        uuids.push(el.uuid);
                    })
                    if (nowPageItems.hasOwnProperty(page_key)) {
                        // 当前视图
                        (function (uuids, pageItem) {
                            task.push(function (next) {
                                deleteResInBook(next, uuids, pageItem);
                            });
                        })(uuids, nowPageItems[page_key]);
                    } else {
                        // 非当前视图
                        (function (uuids) {
                            task.push(function (next) {
                                deleteResNotInBook(next, uuids);
                            });
                        })(uuids);
                    }
                }
            }

            async.parallel(task, function (err, result) {
                var taskResultArr = [],
                    taskErrorArr = [];
                if (err) {
                    window.console.error(err);
                    def.reject({code: -1, err: err});
                } else {
                    for (var i = 0, count = result.length; i < count; i++) {
                        var item = result[i] || {};
                        if (item.code == 1) {
                            okCount++;
                            taskResultArr.push.apply(taskResultArr, (item.data || []));
                        } else {
                            errorCount++;
                            taskErrorArr.push(item.error);
                        }
                    }
                    def.resolve({
                        code: 1,
                        data: taskResultArr,
                        count: {errorCount: errorCount, okCount: okCount},
                        taskError: taskErrorArr
                    });
                }
            });
        } else {
            setTimeout(function () {
                def.resolve({code: 1, msg: '不需要删除课本资源', data: [], count: {errorCount: errorCount, okCount: okCount}});
            }, 10);
        }
        return def.promise();
    }

    /**
     * 书本数据通用格式,(数据库原始记录格式~widget缓存格式)
     * @param resObj
     * var standard = {
                bookCode: resObj
                createTime: "2016-06-21 16:07:47"
                creator: "互联教学助手测试教师"
                description: ""
                extension: "pdf"
                fid: ""
                fileName: "03  表达式与运算符"
                md5: "e59c4abbae6fab65c729455872f2120c"
                modifyTime: "2008-05-27 08:28:50"
                pageCode: ""
                pageIndex: "7"
                position: "662;120;0;0"
                resFrom: "local"
                resId: "e94a4c9e2e384df889c176f4d42d0bd9"
                reserve1: ""
                reserve2: ""
                reserve3: ""
                sort: 2
                source: ""
                title: "03  表达式与运算符.pdf"
                unit1: "03"
                unit2: ""
                unit3: ""
                unit4: ""
                uploader: "互联教学助手测试教师"
                uuid: "yne2jrys8ywbzzje37fcazgqyg32dn6b"
                widgetId: "proc3rd_4116144261"
                widgetType: "proc3rd"
            };
     */
    ImportRes.prototype.formatBookResField = function (resObj, dataFrom) {
        var _this = this;
        dataFrom = dataFrom || "book";
        var standard;
        if (dataFrom == "book") {
            if (1 != resObj._packedFlag) {
                standard = {
                    bookCode: resObj.bookCode || "",
                    createTime: resObj.createTime || "",
                    creator: resObj.creator || "",
                    description: resObj.description || "",
                    extension: resObj.extension || "",
                    fid: resObj.fid || "",
                    fileName: resObj.fileName || "",
                    md5: resObj.md5 || "",
                    modifyTime: resObj.modifyTime || "",
                    pageCode: resObj.pageCode || "",
                    pageIndex: resObj.pageIndex || "",
                    position: resObj.position || "",
                    resFrom: resObj.resFrom || "",
                    resId: resObj.resId || "",
                    reserve1: resObj.reserve1 || "",
                    reserve2: resObj.reserve2 || "",
                    reserve3: resObj.reserve3 || "",
                    sort: resObj.sort || "",
                    source: resObj.source || "",
                    title: resObj.title || "",
                    unit1: resObj.unit1 || "",
                    unit2: resObj.unit2 || "",
                    unit3: resObj.unit3 || "",
                    unit4: resObj.unit4 || "",
                    uploader: resObj.uploader || "",
                    uuid: resObj.uuid || "",
                    widgetId: resObj.widgetId || ""
                };
                if (resObj.extension) {
                    standard.realPath = path.join(ebookContext.getUser().getUserBookResourceBasePath(resObj.bookCode), resObj.uuid, resObj.fileName + '.' + resObj.extension);
                } else {
                    standard.realPath = path.join(ebookContext.getUser().getUserBookResourceBasePath(resObj.bookCode), resObj.uuid, resObj.fileName);
                }

                // 处理widgetType
                standard.widgetTypeString = resObj.widgetType || "";
                //解析json字符串
                var multipleType = _this.parseWidgetTypeField(resObj.widgetType);
                standard.widgetType = multipleType.widgetType || "";
                standard.secondWidgetType = multipleType.secondWidgetType || "";
            } else {
                /**
                 * File: "02  数据类型、常量与变量.pdf"
                 Height: 60
                 Id: "proc3rd_4116144259"
                 IsEditing: false
                 Left: 182
                 PlayAreaHeight: 0
                 PlayAreaWidth: 0
                 Title: "02  数据类型、常量与变量.pdf"
                 Top: 120
                 WidgetType: "proc3rd"
                 Width: 58
                 _packedFlag: 1
                 description: ""
                 infoWidget: InfoWidget
                 isModify: true
                 layout: Object
                 md5: "5da4acb1521199ef07dfb1d61a02e4cc"
                 obj: Object
                 pageIndex: "7"
                 realPath: "W:/www/company/git-svn/TA/user/tatest02/books/13170425-022/miecydwhyiz53nic7g2sbpncbpnzddeb/02  数据类型、常量与变量.pdf"
                 resourceId: "d5f471c18a2e488d936d0d4a1fdd63a4"
                 score: "0"
                 showIconFlag: false
                 showTitleFlag: false
                 sort: 1
                 src: "W:/www/company/git-svn/TA/user/tatest02/books/13170425-022/miecydwhyiz53nic7g2sbpncbpnzddeb/02  数据类型、常量与变量.pdf"
                 style: Object
                 timestamp: "2008-05-19 15:31:50"
                 unit1: "03"
                 unit2: ""
                 unit3: ""
                 unit4: ""
                 uploadTime: ""
                 userAddressInfo: ""
                 userName: "互联教学助手测试教师"
                 uuid: "miecydwhyiz53nic7g2sbpncbpnzddeb"
                 */
                resObj.Left = resObj.Left || 0;
                resObj.Top = resObj.Top || 0;
                resObj.Width = resObj.Width || 0;
                resObj.Height = resObj.Height || 0;
                var bound = (new model.Bound(resObj.left, resObj.Top, resObj.Width, resObj.Height)).serialize();
                var firstNode = resObj[resObj.WidgetType] || {};
                standard = {
                    createTime: resObj.timestamp || firstNode.timestamp || "",
                    creator: resObj.userName || firstNode.userName || "",
                    description: resObj.description || firstNode.description || "",
                    extension: "", // 暂不做解析了，置空，后续用到时解析standard.fileName吧
                    fid: resObj.fid || "",
                    fileName: resObj.File || "",
                    md5: resObj.md5 || "",
                    modifyTime: "",
                    pageCode: "",
                    pageIndex: resObj.pageIndex || "",
                    position: bound || "",
                    resFrom: "",
                    resId: resObj.resourceId || firstNode.resourceId || "",
                    reserve1: "",
                    reserve2: "",
                    reserve3: "",
                    sort: resObj.sort || "",
                    source: "",
                    title: resObj.Title || "",
                    unit1: resObj.unit1 || "",
                    unit2: resObj.unit2 || "",
                    unit3: resObj.unit3 || "",
                    unit4: resObj.unit4 || "",
                    uploader: resObj.userName || firstNode.userName || "",
                    uuid: resObj.uuid || "",
                    widgetId: resObj.Id || ""
                };
                standard._packedFlag = resObj._packedFlag;
                standard.bookCode = resObj.bookCode || _pageProvider.bookCode || "";
                standard.realPath = resObj.realPath || resObj.src || (path.join(ebookContext.getUser().getUserBookResourceBasePath(resObj.bookCode), resObj.uuid, resObj.File));

                // 处理widgetType
                standard.widgetType = resObj.WidgetType || "";
                if (resObj.secondWidgetType) {
                    standard.secondWidgetType = resObj.secondWidgetType || "";
                }
                var _widgetType = resObj.WidgetType || "";
                if (define.WidgetType.InteractiveCard == resObj.WidgetType) {
                    if (resObj.secondWidgetType) {
                        _widgetType = JSON.stringify({
                            widgetType: resObj.WidgetType,
                            secondWidgetType: resObj.secondWidgetType
                        });
                    }
                }
                standard.widgetTypeString = _widgetType;
            }
            //公共参数统一赋值
        }

        if (dataFrom == "mtbk") {
            var resourceProprety;
            var bound = bound || "";
            var _widgetType = resObj.WidgetType || "";
            if (_widgetType) {
                switch (_widgetType) {
                    case define.WidgetType.Img:
                        resourceProprety = 'img';
                        break;
                    case define.WidgetType.Video:
                        resourceProprety = 'video';
                        break;
                    case define.WidgetType.Flash:
                        resourceProprety = 'flash';
                        break;
                    case define.WidgetType.Gallery:
                        resourceProprety = 'file';
                        break;
                    case define.WidgetType.Evaluate:
                        resourceProprety = 'file';
                        break;
                    case define.WidgetType.Choice:
                        resourceProprety = 'file';
                        break;
                    case define.WidgetType.OnlineRes:
                        resourceProprety = 'file';
                        break;
                    case define.WidgetType.Proc3rd:
                        resourceProprety = 'file';
                        break;
                    case define.WidgetType.Audio:
                        resourceProprety = 'audio';
                        break;
                    case define.WidgetType.Note:
                        resourceProprety = 'note';
                        break;
                    case define.WidgetType.FadeCurtain:
                        resourceProprety = 'fadeCurtain';
                        break;
                    case define.WidgetType.Icw :
                        resourceProprety = 'icw';
                        break;
                    case define.WidgetType.ImgPaint :
                        resourceProprety = 'imgPaint';
                        break;
                    case define.WidgetType.Vote:
                        resourceProprety = 'vote';
                        break;
                    case define.WidgetType.InteractiveCard:
                        resourceProprety = 'file';
                        break;
                    default:
                        resourceProprety = _widgetType;
                        break;
                }
                var firstNode = resObj[resourceProprety] || {};
                if (resObj.type) {
                    firstNode.secondWidgetType = resObj.type;
                }
                standard = {
                    createTime: firstNode.timestamp || "",
                    creator: firstNode.userName || "畅言教育",
                    description: firstNode.description || "",
                    extension: "", // 暂不做解析了，置空，后续用到时解析standard.fileName吧
                    fid: "",
                    fileName: firstNode.src || "",
                    md5: firstNode.md5 || "",
                    modifyTime: "",
                    pageCode: "",
                    pageIndex: resObj.pageIndex || "",
                    position: resObj.bound || "",
                    resFrom: "",
                    resId: firstNode.resourceId || "",
                    reserve1: "",
                    reserve2: "",
                    reserve3: "",
                    sort: firstNode.sort || "",
                    source: "",
                    title: firstNode.title || "",
                    unit1: resObj.unit1 || "",
                    unit2: resObj.unit2 || "",
                    unit3: resObj.unit3 || "",
                    unit4: resObj.unit4 || "",
                    uploader: firstNode.userName || "畅言教育",
                    uuid: "",
                    widgetId: resObj.id || ""
                };
                standard.bookCode = _pageProvider.bookCode || "";
                standard.xamlFolderPath = resObj.xamlFolderPath || "";
                standard.realPath = (path.join(resObj.xamlFolderPath, firstNode.src));

                // 处理widgetType
                standard.widgetType = resObj.WidgetType || "";
                if (firstNode.secondWidgetType) {
                    standard.secondWidgetType = firstNode.secondWidgetType || "";
                }
                var _widgetType = resObj.WidgetType || "";
                if (define.WidgetType.InteractiveCard == resObj.WidgetType) {
                    if (firstNode.secondWidgetType) {
                        _widgetType = JSON.stringify({
                            widgetType: resObj.WidgetType,
                            secondWidgetType: firstNode.secondWidgetType
                        });
                    }
                }
                standard.widgetTypeString = _widgetType;
            }
        }

        standard._forImportField = {};
        standard._forImportField.pageIndex = standard.pageIndex;
        standard._forImportField.fileFullPath = standard.realPath;
        standard._forImportField.md5 = standard.md5;
        standard._forImportField.fileFrom = dataFrom;
        return standard;
    }

    /**
     * 解析数据库widgetType字段
     * @param str 普通字符串或者json字符串
     * @returns {{widgetType: string, secondWidgetType: string}}
     */
    ImportRes.prototype.parseWidgetTypeField = function (str) {
        var _this = this;
        var result = {
            widgetType: '',
            secondWidgetType: ''
        };
        // 识别为字符串
        if ((typeof str === 'string') && str.length > 0) {
            var _widgetType;
            var _secondWidgetType;
            try {
                var multipleType = JSON.parse(str);
                _widgetType = multipleType.widgetType || '';
                _secondWidgetType = multipleType.secondWidgetType || '';
            } catch (e) {
                _widgetType = str;
            }
            result.widgetType = _widgetType;
            result.secondWidgetType = _secondWidgetType;
        }
        // 识别为对象
        if ((typeof str === 'object') && c.hasOwnProperty('widgetType')) {
            result.widgetType = str.widgetType;
            result.secondWidgetType = str.secondWidgetType;
        }
        return result;
    }

    /**
     * 格式化数据为写数据库标准格式
     * @param resObj
     * @returns {{}}
     */
    ImportRes.prototype.formatToDbField = function (resObj, type) {
        var _this = this;
        var standard = {};
        var fileFrom;
        if(resObj && resObj._forImportField && resObj._forImportField.fileFrom){
            fileFrom = resObj._forImportField.fileFrom;
        }
        var formatType = type || fileFrom || "";
        if (formatType) {
            var pageMetaData = _pageProvider.getPageMetadata(resObj._forImportField.pageIndex);
            switch (formatType.toLowerCase()) {
                case "mtbk":
                case "book":
                    standard = {
                        userName: ebookContext.getUser().getName() || "",
                        bookCode: resObj.bookCode || _pageProvider.bookCode || "",
                        path: resObj._forImportField.fileFullPath,
                        fileName: resObj.fileName || "未知文件",
                        unit1: pageMetaData.unit1 || "",
                        unit2: pageMetaData.unit2 || "",
                        unit3: pageMetaData.unit3 || "",
                        unit4: pageMetaData.unit4 || "",
                        uuid: "",
                        title: resObj.title || "",
                        pageCode: resObj.pageCode || "",
                        pageIndex: resObj._forImportField.pageIndex || "",
                        position: resObj.position || "0;0;0;0",
                        creator: resObj.creator || '畅言教育',
                        uploader: resObj.uploader || '',
                        description: resObj.description || "",
                        widgetId: resObj.widgetId || "",
                        widgetType: resObj.widgetTypeString || "",
                        resId: resObj.resId || "",
                        fid: "",
                        sort: resObj.sort || "",
                        source: resObj.source || "",
                        resFrom: resObj.resFrom || "local"
                    };
                    return standard;
                default:
                    return resObj;
            }
        } else {
            cosole.error('formatToDbField 未设置转换数据的类型');
            return resObj;
        }
    }

    /**
     * 资源加入到课本
     * @param addResArr
     * @returns {*}
     */
    ImportRes.prototype.addResArr = function (addResArr) {
        var _this = this;
        var def = $.Deferred();
        var nowPageItems = {};
        var savedToDbRes = {};
        var task = [];
        var errorCount = 0,
            okCount = 0;
        if (addResArr.length > 0) {
            _pageProvider.pages.forEach(function (val, index, arr) {
                var pageIndex = val.pageIndex;
                if (pageIndex) {
                    var page_key = _this.pageIndexPreFix + pageIndex;
                    if (!nowPageItems.hasOwnProperty(page_key)) {
                        nowPageItems[page_key] = val;
                    }
                }
            });

            // 先保证写入数据库
            for (var i = 0, count = addResArr.length; i < count; i++) {
                var resObj = addResArr[i];
                var pageIndex = resObj._forImportField.pageIndex;
                var page_key = _this.pageIndexPreFix + pageIndex;
                if (!savedToDbRes.hasOwnProperty(page_key)) {
                    savedToDbRes[page_key] = [];
                }
                savedToDbRes[page_key].push(resObj);
                var formatRes = _this.formatToDbField(resObj);
                (function (formatRes) {
                    task.push(function (next) {
                        try {
                            // 解析加密资源
                            try {
                                var base = _path.dirname(process.execPath);
                                var getResInfo = nodereq(_path.join(base, "tools/edcres/edcres")).getResInfo;
                                var info = getResInfo(formatRes.path);
                                var tags = [];
                                if (info.code === 0 && info.resInfo.resType === 16) {
                                    tags.push('17');
                                }
                                var tagString = tags.join();
                                formatRes.tag = tagString;
                            } catch (e) {
                            }

                            _pageProvider.saveToTp(formatRes).done(function (ret) {
                                if (ret && ret.code == 1) {
                                    next(null, {code: 1, data: ret.data, rawData: formatRes});
                                } else {
                                    next(null, {code: -1, error: ret, rawData: formatRes});
                                }
                            }).fail(function (e) {
                                window.console.timeEnd("saveToTp" + formatRes.fileName + formatRes.pageIndex);
                                next(null, {code: -2, error: e, rawData: formatRes});
                            });
                        }catch(e){
                            window.console.error(e);
                        }
                    })
                })(formatRes);
            }

            async.parallelLimit(task, 1, function (err, results) {
                var taskResultArr = [],
                    taskErrorArr = [];
                var needRefreshResInBook = {};
                var needUpdateResInBook = [];
                for (var i = 0, count = results.length; i < count; i++) {
                    var item = results[i] || {};
                    if (item.code == 1) {
                        okCount++;
                        var dbDataObj = item.data || {};
                        taskResultArr.push(dbDataObj);
                    } else {
                        errorCount++;
                        taskErrorArr.push(item.rawData);
                    }
                }
                def.resolve({
                    code: 1,
                    data: taskResultArr,
                    count: {errorCount: errorCount, okCount: okCount},
                    taskErrorArr: taskErrorArr
                });
            });
        } else {
            setTimeout(function () {
                def.resolve({code: 1, msg: '不需要添加资源到课本', data: [], count: {errorCount: errorCount, okCount: okCount}});
            }, 10);
        }
        return def.promise();
    }

    /**
     * 渲染新资源到当前课本视图
     * @param dbDataArr 新资源列表（数据库字段结构）
     */
    ImportRes.prototype.renderResWidget = function (dbDataArr) {
        var _this = this;
        var def = $.Deferred();
        var nowPageItems = {};
        _pageProvider.pages.forEach(function (val, index, arr) {
            var pageIndex = Number(val.pageIndex);
            if (!isNaN(pageIndex) && pageIndex) {
                var page_key = _this.pageIndexPreFix + pageIndex;
                if (!nowPageItems.hasOwnProperty(page_key)) {
                    nowPageItems[page_key] = val;
                }
            }
        });
        if (dbDataArr && $.isArray(dbDataArr)) {
            if (dbDataArr.length > 0) {
                var needRefreshResInBook = {};
                var needUpdateResInBook = [];
                for (var i = 0, count = dbDataArr.length; i < count; i++) {
                    var dbDataObj = dbDataArr[i] || {};
                    // 新增到数据库成功后，再渲染到页面
                    var pageIndex = dbDataObj.pageIndex;
                    var page_key = _this.pageIndexPreFix + pageIndex;
                    if (nowPageItems.hasOwnProperty(page_key)) {
                        if (!needRefreshResInBook.hasOwnProperty(page_key)) {
                            needRefreshResInBook[page_key] = [];
                        }

                        var bounds = dbDataObj.position && (typeof dbDataObj.position === "string") && dbDataObj.position.split(';');
                        if ((parseFloat(bounds[0]) == 0) && (parseFloat(bounds[1]) == 0)) {
                            // 插入到课本的资源随机位置
                            dbDataObj.posType = 2;
                        }
                        needRefreshResInBook[page_key].push(dbDataObj);
                    } else {
                        // 不在当前视图，则只更新缓存
                        needUpdateResInBook.push(dbDataObj);
                    }
                }
                // 刷新页面资源数据（加载图标）
                for (var page_key in needRefreshResInBook) {
                    if (needRefreshResInBook.hasOwnProperty(page_key)) {
                        var pageIndex;
                        try {
                            pageIndex = parseInt(page_key.replace(_this.pageIndexPreFix, '')) || 1;
                        } catch (e) {
                            pageIndex = 1;
                            window.console.error(e);
                        }
                        _pageProvider.loadPageItem(pageIndex).done(function (pageItem) {
                            pageItem._loadWidget_ext(needRefreshResInBook[page_key]);
                        });
                        /**
                         * 直接采用_loadWidget_ext会造成第一页资源无法直接展示，翻页后才展示。
                         * 是因为取得的pageItem的dom不在页面上，但原因未知
                         * 目前采用loadPageItem()方法取得页面pageItem，暂时可以正常显示
                         * 原因待进一步分析...
                         */
                        // nowPageItems[page_key]._loadWidget_ext(needRefreshResInBook[page_key]);
                    }
                }
                // 更新缓存数据
                for (var i = 0, count = needUpdateResInBook.length; i < count; i++) {
                    var item = needUpdateResInBook[i];
                    _pageProvider.updateBookWidget(item);
                }
            } else {
                setTimeout(function () {
                    def.resolve();
                });
            }
        } else {
            setTimeout(function () {
                def.reject();
            });
        }
        return def.promise();
    }

    /**
     * 按pageIndex(页/单元)合并导入资源到课本
     * @param pageIndex
     * @param mtbkResArr
     * @returns {*}
     */
    ImportRes.prototype.handleImportResByPageIndex = function (pageIndex, mtbkArr) {
        var _this = this;
        var def = $.Deferred();
        var bookContainer = getGlobalBookContainer();
        var bookResArr = [],
            mtbkResArr = [];
        var calcBookResMd5Task = [],
            calcMtbkResMd5Task = [];
        var okCount = 0,
            errorCount = 0;
        var findMtbkRes = mtbkArr.filter(function (el) {
            return el.pageIndex == pageIndex;
        });
        var pageMetaData = _pageProvider.getPageMetadata(pageIndex);
        var units = {
            unit1: pageMetaData.unit1,
            unit2: pageMetaData.unit2,
            unit3: pageMetaData.unit3,
            unit4: pageMetaData.unit4
        };
        var getResExec;
        getResExec = _pageProvider.getBookWidgets(units);
        // 获取pageIndex对应单元的资源
        try {
            getResExec.done(function (pageInUnitResArr) {
                /**
                 * findBookRes 按页/单元查询的指定pageIndex上的资源
                 * maxSortValue 按页/单元查询的资源排序值的最大值
                 * @type {Array}
                 */
                var findBookRes = [],
                    maxSortValue = 0;
                pageInUnitResArr.filter(function (el) {
                    if (el.pageIndex == pageIndex) {
                        findBookRes.push(el);
                    }
                    var sortValue = Number(el.sort);
                    if (!isNaN(sortValue) && (sortValue > maxSortValue)) {
                        maxSortValue = sortValue;
                    }
                });
                findBookRes.forEach(function (val, index, arr) {
                    var standardBookRes = _this.formatBookResField(val, 'book');
                    if (!_this.config.forceCalcBookResMd5 && standardBookRes.md5) {
                        bookResArr.push(standardBookRes);
                    } else {
                        (function (standardBookRes) {
                            calcBookResMd5Task.push(function (next) {
                                try {
                                    var filePath = standardBookRes._forImportField.fileFullPath;
                                    shellcmd.getMd5(filePath).done(function (fileMd5) {
                                        // 同时更新_forImportField字段属性
                                        standardBookRes._forImportField.md5 = fileMd5;
                                        standardBookRes.md5 = fileMd5;
                                        next(null, {code: 1, data: standardBookRes});
                                    }).fail(function (e) {
                                        standardBookRes.md5 = _this.skipMd5;
                                        next(null, {code: -1, data: standardBookRes});
                                    });
                                } catch (e) {
                                    window.console.error(e);
                                }
                            });
                        })(standardBookRes);
                    }
                });
                findMtbkRes.forEach(function (val, index, arr) {
                    var standardMtbkRes = _this.formatBookResField(val, 'mtbk');
                    var n = Number(standardMtbkRes.sort);
                    // 按页面现有资源排序的基础上，追加新资源
                    if (!isNaN(n) && (n > 0)) {
                        standardMtbkRes.sort = maxSortValue + n;
                    } else {
                        standardMtbkRes.sort = maxSortValue + 1;
                    }
                    if (!_this.config.forceCalcMtbkResMd5 && standardMtbkRes.md5) {
                        mtbkResArr.push(standardMtbkRes);
                    } else {
                        (function (standardMtbkRes) {
                            calcMtbkResMd5Task.push(function (next) {
                                try {
                                    var filePath = standardMtbkRes._forImportField.fileFullPath;
                                    shellcmd.getMd5(filePath).done(function (fileMd5) {
                                        // 同时更新_forImportField字段属性
                                        standardMtbkRes._forImportField.md5 = fileMd5;
                                        standardMtbkRes.md5 = fileMd5;
                                        next(null, {code: 1, data: standardMtbkRes});
                                    }).fail(function (e) {
                                        standardMtbkRes.md5 = _this.skipMd5;
                                        next(null, {code: -1, data: standardMtbkRes});
                                    });
                                } catch (e) {
                                    window.console.error(e);
                                }
                            });
                        })(standardMtbkRes);
                    }
                });
                var task1 = (function (calcBookResMd5Task) {
                    var def = $.Deferred();
                    var calcMd5Func = calcBookResMd5Task;
                    if (calcMd5Func.length > 0) {
                        async.parallel(calcMd5Func, function (err, result) {
                            var taskResultArr = [];
                            if (err) {
                                def.reject(err);
                            } else {
                                for (var i = 0, count = result.length; i < count; i++) {
                                    // 不判断失败
                                    var item = result[i] || {};
                                    taskResultArr.push(item.data);
                                }
                                def.resolve({code: 1, data: taskResultArr});
                            }
                        });
                    } else {
                        def.resolve({code: 1, data: []})
                    }
                    return def.promise();
                })(calcBookResMd5Task);
                var task2 = (function (calcMtbkResMd5Task) {
                    var def = $.Deferred();
                    var calcMd5Func = calcMtbkResMd5Task;
                    if (calcMd5Func.length > 0) {
                        async.parallel(calcMd5Func, function (err, result) {
                            var taskResultArr = [];
                            if (err) {
                                def.reject(err);
                            } else {
                                for (var i = 0, count = result.length; i < count; i++) {
                                    // 不判断失败
                                    var item = result[i] || {};
                                    taskResultArr.push(item.data);
                                }
                                def.resolve({code: 1, data: taskResultArr});
                            }
                        });
                    } else {
                        def.resolve({code: 1, data: []})
                    }
                    return def.promise();
                })(calcMtbkResMd5Task);
                $.when(task1, task2).done(function (result1, result2) {
                    bookResArr.push.apply(bookResArr, result1.data);
                    mtbkResArr.push.apply(mtbkResArr, result2.data);
                    try {
                        _this.mergeResArr(bookResArr, mtbkResArr).done(function (mergedArr) {
                            var shouldDelResArr = mergedArr.shouldDelResArr;
                            var shouldAddResArr = mergedArr.shouldAddResArr;
                            var md5EqualCount = mergedArr.md5EqualCount;
                            var md5EqualArr = mergedArr.md5EqualArr;
                            var overwriteArr = mergedArr.overwriteArr;
                            // 需要先删除课本资源，再插入新资源
                            _this.deleteBookResByUuid(shouldDelResArr).done(function () {
                                _this.addResArr(shouldAddResArr).done(function (addResult) {
                                    var count = addResult && addResult.count || {};
                                    var okDataArr = addResult && addResult.data || [];
                                    okCount = count.okCount;
                                    errorCount = count.errorCount;
                                    def.resolve({
                                        code: 1,
                                        data: okDataArr,
                                        okCount: okCount,
                                        errorCount: errorCount,
                                        md5EqualCount: md5EqualCount,
                                        md5EqualArr: md5EqualArr,
                                        overwriteArr: overwriteArr
                                    });
                                }).fail(function (e) {
                                    def.reject({code: -1, error: e});
                                });
                            }).fail(function (e) {
                                def.reject(e);
                            });
                        });
                    } catch (e) {
                        window.console.error(e);
                    }
                }).fail(function (e) {
                    def.reject(e);
                });
            }).fail(function (e) {
                def.reject(e);
            });
        }catch(e){
            window.console.error(e);
        }
        return def.promise();
    }

    /**
     * 导入资源到课本
     * @returns {*}
     */
    ImportRes.prototype.handleImportRes = function (mtbkBookCode, mtbkFilePath, unzipFolderPath) {
        var _this = this;
        var def = $.Deferred();
        var spendTimeFlag = {
            "importRes": "MTBK授课包导入功能总耗时",
            "readAndUnzipMtbkFile": "解析MTBK文件包总耗时",
            "handleImportResByPageIndex": "处理第 {pageIndex} 页的MTBK导入总耗时"
        }
        window.console.time(spendTimeFlag.importRes);
        var task = [];
        var okCount = 0,
            errorCount = 0;
        var taskRecord = {};
        if (!unzipFolderPath) {
            unzipFolderPath = path.dirname(path.trimPosix(_pageProvider.getUserBookDir()));
        }
        window.console.time(spendTimeFlag.readAndUnzipMtbkFile);
        if (_pageProvider.bookCode) {
            _this.readAndUnzipMtbkFile(mtbkBookCode, mtbkFilePath, unzipFolderPath).done(function (mtbkInfo) {
                window.console.timeEnd(spendTimeFlag.readAndUnzipMtbkFile);
                var bookCode = mtbkInfo.bookCode,
                    pageListArr = mtbkInfo.pageListArr,
                    mtbkPagesArr = mtbkInfo.mtbkPagesArr,
                    mtbkResArr = mtbkInfo.mtbkResArr,
                    rawMtbkInfoArr = mtbkInfo.rawMtbkInfoArr;

                showLoading({tips: AppTips.handingImport}, mtbkPagesArr.length * 1000);
                for (var i = 0, count = mtbkPagesArr.length; i < count; i++) {
                    var pageIndex = mtbkPagesArr[i];
                    var mtbkArrInPage = mtbkResArr.filter(function (el) {
                        return el.pageIndex == pageIndex;
                    });
                    (function (pageIndex, mtbkArrInPage) {
                        task.push(function (next) {
                            window.console.time(("" + spendTimeFlag.handleImportResByPageIndex).replace("{pageIndex}", pageIndex));
                            try {
                                _this.handleImportResByPageIndex(pageIndex, mtbkArrInPage).done(function (ret) {
                                    window.console.timeEnd(("" + spendTimeFlag.handleImportResByPageIndex).replace("{pageIndex}", pageIndex));
                                    if ($("#loading_tip").length == 0) {
                                        showLoading({tips: AppTips.handingImport});
                                    } else {
                                        if ($("#loading_tip").find('.cancelBtn').is(":visible")) {
                                            showLoading({tips: AppTips.handingImport});
                                        }
                                    }
                                    next(null, {
                                        code: 1,
                                        data: (ret.data || []),
                                        pageIndex: pageIndex,
                                        okCount: ret.okCount,
                                        errorCount: ret.errorCount,
                                        taskData: mtbkArrInPage,
                                        md5EqualCount: ret.md5EqualCount,
                                        md5EqualArr: ret.md5EqualArr,
                                        overwriteArr: ret.overwriteArr
                                    });
                                }).fail(function (e) {
                                    window.console.timeEnd(("" + spendTimeFlag.handleImportResByPageIndex).replace("{pageIndex}", pageIndex));
                                    next(null, {code: -1, error: e, pageIndex: pageIndex, taskData: mtbkArrInPage});
                                });
                            } catch (e) {
                                window.console.error("导入第%s页资源发生异常", pageIndex);
                                window.console.error(e);
                            }
                        })
                    })(pageIndex, mtbkArrInPage);
                }

                async.parallelLimit(task, 27, function (err, results) {
                    var taskResultArr = [];
                    if (err) {
                        window.console.timeEnd(spendTimeFlag.importRes);
                        window.console.error(err);
                        def.reject(err);
                    } else {
                        // 对结果的分析
                        for (var i = 0, count = results.length; i < count; i++) {
                            var item = results[i] || {};
                            // 简单处理
                            if (item.code == 1) {
                                okCount++;
                            } else {
                                errorCount++;
                            }
                            taskResultArr.push(item);
                        }
                    }
                    window.console.timeEnd(spendTimeFlag.importRes);
                    def.resolve({
                        code: 1,
                        data: taskResultArr,
                        count: {errorCount: errorCount, okCount: okCount}
                    });
                });
            }).fail(function (e) {
                window.console.timeEnd(spendTimeFlag.readAndUnzipMtbkFile);
                def.reject(e);
            });
        } else {
            def.reject('Could not get bookcode while import bookres');
        }
        return def.promise();
    }

    /**
     * 按bookCode清空书本资源
     * @param bookCode
     * @returns {*}
     */
    ImportRes.prototype.cleanBookResByBookCode = function (bookCode) {
        var _this = this;
        var def = $.Deferred();
        var spendTimeFlag = {
            "cleanDbBookRes": "根据bookCode清空数据库总耗时：",
            "cleanBookResByBookCode": "根据bookCode删除全书资源总耗时："
        }
        window.console.time(spendTimeFlag.cleanBookResByBookCode);
        // 空值处理
        if (!bookCode) {
            bookCode = _pageProvider.bookCode;
        }
        if (bookCode == _pageProvider.bookCode) {
            var task = [];
            var okCount = 0,
                errorCount = 0;
            var nowPageItems = {};
            window.console.time(spendTimeFlag.cleanDbBookRes);
            _pageProvider.deleteTPBook(bookCode, {mtbk: false}).done(function (ret) {
                window.console.timeEnd(spendTimeFlag.cleanDbBookRes);
                _pageProvider.pages.forEach(function (val, index, arr) {
                    var pageIndex = val.pageIndex;
                    if (pageIndex) {
                        var page_key = _this.pageIndexPreFix + pageIndex;
                        if (!nowPageItems.hasOwnProperty(page_key)) {
                            nowPageItems[page_key] = val;
                        }
                        (function (pageIndex) {
                            task.push(function (next) {
                                var pageMetaData = _pageProvider.getPageMetadata(pageIndex);
                                var units = {
                                    unit1: pageMetaData.unit1,
                                    unit2: pageMetaData.unit2,
                                    unit3: pageMetaData.unit3,
                                    unit4: pageMetaData.unit4
                                };
                                _pageProvider.getBookWidgets(units).done(function (pageInUnitResArr) {
                                    var findBookRes = pageInUnitResArr.filter(function (el) {
                                        return el.pageIndex == pageIndex;
                                    });
                                    next(null, {code: 1, data: findBookRes});
                                }).fail(function (e) {
                                    next(null, {code: -1, error: e});
                                });
                            })
                        })(pageIndex);
                    }
                });
                async.parallel(task, function (err, results) {
                    var taskResultArr = [];
                    if (err) {
                        window.console.error(err);
                        window.console.timeEnd(spendTimeFlag.cleanBookResByBookCode);
                        def.reject(err);
                    } else {
                        // todo 对结果的分析
                        for (var i = 0, count = results.length; i < count; i++) {
                            var item = results[i] || {};
                            if (item.code == 1) {
                                okCount++;
                                taskResultArr.push.apply(taskResultArr, (item.data || []));
                            } else {
                                errorCount++;
                            }
                        }
                        if (taskResultArr.length > 0) {
                            var preDeleteResArr = [];
                            for (var i = 0, count = taskResultArr.length; i < count; i++) {
                                preDeleteResArr.push(_this.formatBookResField(taskResultArr[i]));
                            }
                            _this.deleteBookResByUuid(preDeleteResArr).done(function (ret) {
                                window.console.log(ret);
                                // 简单处理，初始化书本资源
                                _pageProvider.bookWidgets = [];
                                // 重置页面widget数据
                                $(document).trigger("widgetLoaded", {action: "reset"});
                                window.console.timeEnd(spendTimeFlag.cleanBookResByBookCode);
                                def.resolve({code: 1, data: ret.data});
                            }).fail(function (e) {
                                window.console.timeEnd(spendTimeFlag.cleanBookResByBookCode);
                                def.reject(e);
                            });
                        } else {
                            window.console.timeEnd(spendTimeFlag.cleanBookResByBookCode);
                            def.resolve({code: 1, data: []});
                        }
                    }
                });
            }).fail(function (e) {
                def.reject(_this.buildError(-1, _this.MainTips.Error_Delete_TP_Db_Record, e));
            });
        } else {
            setTimeout(function () {
                window.console.timeEnd(spendTimeFlag.cleanBookResByBookCode);
                def.reject(_this.buildError(-1, _this.MainTips.Error_Mtbk_Not_Match));
            }, 0);
        }
        return def.promise();
    }

    /**
     * 按bookCode导入mtbk资源（自带UI提示）
     * @param mtbkBookCode
     * @param mtbkFilePath
     * @param unzipFolderPath
     * @returns {*}
     */
    ImportRes.prototype.importMtbkResByBookCode = function (mtbkBookCode, mtbkFilePath, unzipFolderPath) {
        var _this = this;
        var def = $.Deferred();
        showLoading({tips: AppTips.handingImport});
        _this.handleImportRes(mtbkBookCode, mtbkFilePath, unzipFolderPath).done(function (ret) {
            // 新加入课本资源列表
            var resList = [];
            if (ret && typeof ret === "object" && $.isArray(ret.data) && ret.data.length > 0) {
                var appendResArr = ret.data;
                appendResArr.forEach(function (el) {
                    if (el && typeof el === "object" && (el.code == 1)) {
                        if (el.data && $.isArray(el.data) && el.data.length > 0) {
                            resList = resList.concat(el.data);
                        }
                    }
                });
            }
            _this.renderResWidget(resList).done(function (render) {
                console.log(render);
            }).fail(function (e) {
                console.log(e);
            });
            hideLoading();
            var tips = _this.MainTips.Status_Import_Success;
            tipsDialog({
                "id": "importing" + new Date().getTime(),
                "content": '<span class="success_box_right"></span>' + tips
            });
            // 授课包资源导入后刷新同步精选
            $(document).trigger('mtbk_improt_toSelected');
            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130501';
            var user_id = ebookContext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);
            def.resolve(ret);
        }).fail(function (e) {
            hideLoading();
            tips = _this.handleErrorToTips(e);
            if (tips) {
                switch (tips) {
                    case _this.MainTips.Error_Mtbk_File_Not_Exist:
                    case _this.MainTips.Error_Mtbk_File_Read:
                    case _this.MainTips.Error_Mtbk_Unzip:
                    case _this.MainTips.Status_Mtbk_File_Empty:
                    case _this.MainTips.Error_Mtbk_Not_Match:
                        addTipDialog(tips);
                        break;
                    default:
                        tipsDialog({
                            "id": "importing" + new Date().getTime(),
                            "content": tips
                        });
                }
            } else {
                tipsDialog({
                    "id": "importing" + new Date().getTime(),
                    "content": _this.MainTips.Status_Import_Failed
                });
            }
            // 授课包资源导入后刷新同步精选
            $(document).trigger('mtbk_improt_toSelected');
            def.reject(e);
        });
        return def.promise();
    }

    /**
     * 按bookCode删除书本资源（自带UI提示）
     * @param bookCode
     * @returns {*}
     */
    ImportRes.prototype.deleteBookResByBookCode = function (bookCode) {
        var _this = this;
        var def = $.Deferred();
        // 空值处理
        if (!bookCode) {
            bookCode = _pageProvider.bookCode;
        }
        $.Zebra_Dialog('删除课本所有资源', {
            'type': 'question',
            'title': AppTips.WarmTips,
            'buttons': [AppTips.CancelTips, AppTips.OkTips],
            'onClose': function (capition) {
                if (capition == AppTips.OkTips) {
                    _this.cleanBookResByBookCode(bookCode).done(function (ret) {
                        var tips = _this.MainTips.Status_Delete_BookRes_Success;
                        tipsDialog({
                            "id": "importing" + new Date().getTime(),
                            "content": '<span class="success_box_right"></span>' + tips
                        });
                        def.resolve(ret);
                    }).fail(function (e) {
                        tipsDialog({
                            "id": "importing" + new Date().getTime(),
                            "content": _this.MainTips.Status_Delete_BookRes_Failed
                        });
                        def.reject(e);
                    });
                } else {
                    tipsDialog({
                        "id": "importing" + new Date().getTime(),
                        "content": _this.MainTips.Status_Delete_User_Cancel
                    });
                    def.reject(_this.buildError(-1, _this.MainTips.Status_Delete_User_Cancel));
                }
            }
        });
        return def.promise();
    }

    /**
     * 打开书本检测mtbk文件是否存在
     * @returns {*}
     */
    ImportRes.prototype.firstImportMtbkCheck = function (bookCode) {
        var _this = this;
        var def = $.Deferred();
        var mtbkBookCode = bookCode || _pageProvider.bookCode;
        var mtbkFilePath = path.join(path.trimPosix(_pageProvider.getUserBookDir()), mtbkBookCode + '.mtbk');
        var unzipFolderPath = path.dirname(path.trimPosix(_pageProvider.getUserBookDir()));
        shellcmd.isExistAndFile(mtbkFilePath).done(function (ret) {
            if (ret) {
                _this.showCommonTip({
                    "title": "温馨提示",
                    "content": "您从书库中已下载的课本资源是否导入?",
                    "completeText": "导入",
                    "cancelText": "删除",
                    "complete": function () {
                        _this.importMtbkResByBookCode(mtbkBookCode, mtbkFilePath, unzipFolderPath).done(function (ret) {
                            window.console.log(ret);
                            shellcmd.deleteFile(mtbkFilePath).done(function (unlinkMtbkFileStatus) {
                                if (unlinkMtbkFileStatus == false) {
                                    window.console.error("删除mtbk文件失败");
                                }
                            }).fail(function (e) {
                                window.console.error(e);
                            });
                        }).fail(function (e) {
                            window.console.error(e);
                        });
                    },
                    "cancel": function () {
                        // 删除mtbk文件
                        shellcmd.deleteFile(mtbkFilePath).done(function (unlinkMtbkFileStatus) {
                            if (unlinkMtbkFileStatus == false) {
                                window.console.error("删除mtbk文件失败");
                            }
                        }).fail(function (e) {
                            window.console.error(e);
                        });
                    }
                });
            }
        });
        return def.promise();
    }

    /**
     * 普通弹窗提示,单例(可以再完善)
     * xinfang3
     */
    ImportRes.prototype.showCommonTip = function (content, obj) {
        var _this = this;
        var Domstr = $("#template_first_import_mtbk")[0].innerHTML;
        if (typeof content === "object") {
            obj = content;
            content = undefined;
        }
        if (typeof obj == "undefined") {
            obj = {};
        }
        var s = {
            "title": "提示",
            "content": "",
            "z-index": "1002",
            "complete": "",
            "close": "",
            "cancel": "",
            "completeText": "确定",
            "closeText": "关闭",
            "cancelText": "取消",
            "draggable": "true",
            "overlay": {}
        };
        var title = obj.title || s.title;
        var content = content || obj.content || s.content;
        var index = obj["z-index"] || s["z-index"];
        var complete_callback = obj.complete || s.complete;
        var close_callback = obj.close || s.close;
        var cancel_callback = obj.cancel || s.cancel;
        var completeText = obj.completeText || s.completeText;
        var closeText = obj.closeText || s.closeText;
        var cancelText = obj.cancelText || s.cancelText;
        var draggable = obj.draggable || s.draggable;
        var overlayObj = obj.overlay || s.overlay;

        var dom = $(Domstr);
        //设置弹窗遮盖层
        var overlay = overlayObj.dom && $(overlayObj.dom) || $('<div class="commonTipOverlay"></div>');
        overlay.css({
            "position": "fixed",
            "left": "0px",
            "top": "0px",
            "opacity": "0",
            "background": "#eee",
            "z-index": "600",
            "width": "100%",
            "height": "100%"
        });
        //自定义配置（临时方案-覆盖）
        if (overlayObj.css) {
            overlay.css(overlayObj.css);
        }

        //设置文本
        dom.find("p[name='title']").html("").html(title);
        dom.find("div[name='content']").html("").html(content);

        dom.find("a[name='close']").attr("title", closeText);

        dom.find("button[name='complete']").html("").html(completeText);
        if (cancel_callback) {
            dom.find("button[name='cancel']").html("").html(cancelText);
        } else {
            dom.find("button[name='cancel']").remove();
        }

        //设置样式 - 相对于课本内容居中
        var correctLeft = $(".J_leftbar").width() || 0;
        var setedLeft = (correctLeft + ($("#bookwarp").width() - dom.outerWidth()) / 2) + 'px';
        var setedTop = ($("#bookwarp").height() - dom.outerHeight()) / 2 + 'px';
        dom.css('left', setedLeft);
        dom.css('top', setedTop);
        dom.css('z-index', index);

        //设置可拖动
        if (draggable != "false") {
            dom.draggable({
                cursor: "move",
                containment: $("#bookContainer"),
                handle: ".jxpop-tab"
            });
        }

        //绑定事件
        $(dom).on("click", "a[name='close']", function () {
            dom.remove();
            overlay.remove();
            close_callback && close_callback();
        });
        $(dom).on("click", "button[name='complete']", function () {
            dom.remove();
            overlay.remove();
            complete_callback && complete_callback();
        });
        $(dom).on("click", "button[name='cancel']", function () {
            dom.remove();
            overlay.remove();
            cancel_callback && cancel_callback();
        });
        //展示
        $("body").append(overlay);
        $("body").append(dom);
    }

    /**
     * note:该方法已废弃
     * ->原有导入流程
     */
    function AlertCover(importPath){
        $.Zebra_Dialog(AppImportAndExportTips.ImportTips, {
            'type': 'question',
            'title': AppTips.WarmTips,
            'buttons': [AppTips.CancelTips, AppTips.OkTips],
            'onClose': function (capition) {
                (capition == AppTips.OkTips) && CoverBook(importPath);
            }
        });
    }

    /**
     * note:该方法已废弃
     * ->原有导入流程
     */
    function CoverBook(importPath,cb){
        var coverBookTimeLable = "coverBook";
        window.console.time(coverBookTimeLable)
        var tips;
        //判断导入文件是否合法
        importPath = importPath.replace(/\\/g,"/");
        _pageProvider.getMTBKInfo(importPath).done(function(ret){
            var data = ret;
            if(data.pageList && data.pageList.length>0){
                if (data && data.bookCode == _pageProvider.bookCode) {
                    window.console.log({account: ebookContext.getUser().getName(), bookCode: _pageProvider.bookCode, filePath: importPath});
                    //     trace.log('ebook', actionType.StartImportTeb, {account: ebookContext.getUser().getName(), bookCode: _pageProvider.bookCode, filePath: importPath});
                    var pathDir = path.dirname(path.trimPosix(_pageProvider.getUserBookDir()));
                    var args = '{"zippath":"' + importPath + '","despath":"' + pathDir + '"}';
                    if(json.TP.useDb){
                        showLoading({tips:AppTips.handingImport},300000);
                        var tips = tipsDialog({
                            "id":"importing" + new Date().getTime(),
                            "content":"授课包导入中..."
                        });
                        window.console.time("deleteTPIndex");
                        _pageProvider.deleteTPIndex(data.pageList).done(function(result){
                            window.console.timeEnd("deleteTPIndex");
                            if(result){
                                //清除页面授课资源缓存

                                $.each(_pageProvider.bookWidgets, function (i, e) {
                                    if(e._packedFlag){
                                        var deleteWidget = _pageProvider.deleteBookWidget(e.uuid);
                                        deleteWidget.destroy(false);
                                        $(document).trigger("importDeleteWidget",{"id":deleteWidget.uuid,"file":"","origin":{},"pageIndex":deleteWidget.pageIndex}); //删除页面widgets成功
                                    }
                                });
                                // $(document).trigger("importGetWidget");
                                shellcmd.unzip(args).done(function (ret) {
                                    cb && cb();
                                    if (ret) {
                                        _pageProvider.xamlToJsons(pathDir,data.bookCode,data.pageList,function(){
                                            //先刷新左侧列表
                                            _pageProvider.bookWidgets = [];
                                            $(document).trigger("importGetWidget");
                                            // $(document).trigger("importGetWidget");
                                            //刷新页面缓存中的数据
                                            window.console.time("getTPUnit");
                                            var pageunits = [];
                                            $.each(_pageProvider.pages, function (i, e) {
                                                var bookobj = _pageProvider.getPageMetadata(e.pageIndex);
                                                var p = pageunits.filter(function(el){
                                                    return el.unit1 == bookobj.unit1 && el.unit2 == bookobj.unit2 && el.unit3 == bookobj.unit3 && el.unit4 == bookobj.unit4;
                                                });
                                                if(p.length > 0){
                                                    // pageunits.push(p[0]);
                                                }else{
                                                    pageunits.push(bookobj);
                                                }
                                            });
                                            var funs = [];
                                            for(var i = 0; i<pageunits.length;i++){
                                                // funs.push(_pageProvider.getTPUnit(pageunits[i]));
                                                (function(i){
                                                    funs.push(function(next){
                                                        _pageProvider.getTPUnit(pageunits[i]).done(function(ret){
                                                            next(null,ret);
                                                        }).fail(function(e){
                                                            next(null,[]);
                                                        })
                                                    });
                                                })(i);
                                            }
                                            async.parallel(funs,function(err,results){
                                                window.console.log(results);
                                                var dblist = [];
                                                $.each(results,function(index,e){
                                                    dblist = $.merge(e,dblist);
                                                })
                                                // hideLoading();
                                                $.each(_pageProvider.pages,function(i,pageItem){
                                                    var list = dblist.filter(function(el){
                                                        return el.pageIndex == pageItem.pageIndex;
                                                    });
                                                    pageItem._loadWidget_ext(list);
                                                });
                                                //授课包资源导入后刷新同步精选
                                                $(document).trigger('mtbk_improt_toSelected');
                                                hideLoading();
                                                var tips = tipsDialog({
                                                    "id":"importing" + new Date().getTime(),
                                                    "content":'<span class="success_box_right"></span>授课包导入成功'
                                                });
                                                window.console.timeEnd(coverBookTimeLable);
                                            })

                                        });
                                    }else{
                                        window.console.log("解压失败！！！");
                                        hideLoading();
                                        var tips = tipsDialog({
                                            "id":"importing" + new Date().getTime(),
                                            "content":"授课包导入失败"
                                        });
                                    }
                                }).fail(function(){
                                    window.console.log("解压失败！！！");
                                    hideLoading();
                                    var tips = tipsDialog({
                                        "id":"importing" + new Date().getTime(),
                                        "content":"授课包导入失败"
                                    });
                                });
                            }else{
                                hideLoading();
                                window.console.log("清空页面数据库数据失败");
                                var tips = tipsDialog({
                                    "id":"importing" + new Date().getTime(),
                                    "content":"授课包导入失败"
                                });
                            }
                        }).fail(function(e){
                            window.console.timeEnd("deleteTPIndex");
                            hideLoading();
                            window.console.log("清空页面数据库数据失败");
                            var tips = tipsDialog({
                                "id":"importing" + new Date().getTime(),
                                "content":"授课包导入失败"
                            });
                        });

                    }else{
                        //清空书本资源后导入资源
                        _containerHelper._clearBookRes(data.pageList,_pageProvider).done(function () {
                            showLoading({tips:AppTips.handingImport});
                            shellcmd.unzip(args).done(function (ret) {
                                hideLoading();
                                if (ret) {
                                    $.each(_pageProvider.pages, function (i, e) {
                                        if ($.inArray("" + e.pageIndex, data.pageList) != -1)
                                            e.importBookRes();
                                    });
                                    //$(_canvasManager).trigger('restoreStrokeWithoutHidePageCanvas');
                                    tips = AppImportAndExportTips.ImportSuccess;
                                    //监管
                                    var action = LogManager.action.trigger;
                                    var params = {};
                                    params.module = '1130501';
                                    var user_id = ebookContext.getUser().getUid();
                                    if(user_id != '0' && user_id){
                                        params.user_id =user_id;
                                    }
                                    LogManager.statistics(action,params);

                                }
                                else tips = AppImportAndExportTips.ImportFailed;
                                addTipDialog(tips);
                                //         trace.log('ebook', actionType.EndImportTeb, {bookCode: _pageProvider.bookCode});
                                //清除IFB中书本资源，将TA备课本中对应的所有资源设置为“其他资源”
                                var key=["fromapp"];
                                var value=[""];
                                var bookcode=ebookContext.curBookCode;
                                _pptIcwsAccessor.updateInfoByBookcode(key,value,bookcode).done(function(){
                                    $(document).trigger('mtbk_improt_toSelected');
                                    window.console.log("清空TA数据库成功，本书已删除资源标记为本地资源！");
                                }).fail(function(){
                                    window.console.log("清空TA数据库失败，本书已删除资源标未能记为本地资源！");
                                });
                            })
                        });
                    }
                }else {
                    hideLoading();
                    tips = AppImportAndExportTips.ImportInvalid;
                    addTipDialog(tips);
                    //     trace.log('ebook', actionType.EndImportTeb, {bookCode: _pageProvider.bookCode});
                }
            }else{
                addTipDialog("您导入的授课包无资源!");
            }
        }).fail(function(e){
            hideLoading();
            tips = AppImportAndExportTips.ImportInvalid;
            addTipDialog(tips);
        });


        // shellcmd.getZipInnercode(importPath).done(function (ret) {
        //     var data = null;
        //     if (ret == 'file illegal'){
        //         tips = AppImportAndExportTips.ImportInvalid;
        //         addTipDialog(tips);
        //         return;
        //     }
        //     if (ret != ""){
        //         data = eval('(' + ret + ')');
        //     }
        //     if (data && data.bookcode == _pageProvider.bookCode) {
        //         console.log({account: ebookContext.getUser().getName(), bookCode: _pageProvider.bookCode, filePath: importPath});
        //         //     trace.log('ebook', actionType.StartImportTeb, {account: ebookContext.getUser().getName(), bookCode: _pageProvider.bookCode, filePath: importPath});
        //         var pathDir = path.dirname(path.trimPosix(_pageProvider.getUserBookDir()));
        //         var args = '{"zippath":"' + importPath + '","despath":"' + pathDir + '"}';
        //         if(json.TP.useDb){
        //             showLoading({tips:AppTips.handingImport},500000);
        //             var tips = tipsDialog({
        //                 "id":"importing" + new Date().getTime(),
        //                 "content":"授课包导入中..."
        //             });
        //             console.time("deleteTPIndex");
        //             _pageProvider.deleteTPIndex(data.files).done(function(result){
        //                 console.timeEnd("deleteTPIndex");
        //                 if(result){
        //                     //清除页面授课资源缓存

        //                     $.each(_pageProvider.bookWidgets, function (i, e) {
        //                         if(e._packedFlag){
        //                             var deleteWidget = _pageProvider.deleteBookWidget(e.uuid);
        //                             deleteWidget.destroy(false);
        //                             $(document).trigger("importDeleteWidget",{"id":deleteWidget.uuid,"file":"","origin":{},"pageIndex":deleteWidget.pageIndex}); //删除页面widgets成功
        //                         }
        //                     });
        //                     // $(document).trigger("importGetWidget");
        //                     shellcmd.unzip(args).done(function (ret) {
        //                         cb && cb();
        //                         if (ret) {
        //                             _pageProvider.xamlToJsons(pathDir,data.bookcode,data.files,function(){
        //                                 //先刷新左侧列表
        //                                 _pageProvider.bookWidgets = [];
        //                                 $(document).trigger("importGetWidget");
        //                                 // $(document).trigger("importGetWidget");
        //                                 //刷新页面缓存中的数据
        //                                 console.time("getTPUnit");
        //                                 var pageunits = [];
        //                                 $.each(_pageProvider.pages, function (i, e) {
        //                                     var bookobj = _pageProvider.getPageMetadata(e.pageIndex);
        //                                     var p = pageunits.filter(function(el){
        //                                         return el.unit1 == bookobj.unit1 && el.unit2 == bookobj.unit2 && el.unit3 == bookobj.unit3 && el.unit4 == bookobj.unit4;
        //                                     });
        //                                     if(p.length > 0){
        //                                         // pageunits.push(p[0]);
        //                                     }else{
        //                                         pageunits.push(bookobj);
        //                                     }
        //                                 });
        //                                 var funs = [];
        //                                 for(var i = 0; i<pageunits.length;i++){
        //                                     // funs.push(_pageProvider.getTPUnit(pageunits[i]));
        //                                     (function(i){
        //                                         funs.push(function(next){
        //                                             _pageProvider.getTPUnit(pageunits[i]).done(function(ret){
        //                                                 next(null,ret);
        //                                             }).fail(function(e){
        //                                                 next(null,[]);
        //                                             })
        //                                         });
        //                                     })(i);
        //                                 }
        //                                 async.parallel(funs,function(err,results){
        //                                     console.log(results);
        //                                     var dblist = [];
        //                                     $.each(results,function(index,e){
        //                                         dblist = $.merge(e,dblist);
        //                                     })
        //                                     // hideLoading();
        //                                     $.each(_pageProvider.pages,function(i,pageItem){
        //                                         var list = dblist.filter(function(el){
        //                                             return el.pageIndex == pageItem.pageIndex;
        //                                         });
        //                                         pageItem._loadWidget_ext(list);
        //                                     });
        //                                     //授课包资源导入后刷新同步精选
        //                                     $(document).trigger('mtbk_improt_toSelected');
        //                                     hideLoading();
        //                                     var tips = tipsDialog({
        //                                         "id":"importing" + new Date().getTime(),
        //                                         "content":'<span class="success_box_right"></span>授课包导入成功'
        //                                     });
        //                                 })
        //                                 // console.timeEnd("getTPUnit");
        //                                 // console.time("getTPUnitres");
        //                                 // console.log(funs);
        //                                 // $.when.apply({},funs).done(function(){
        //                                 //     console.timeEnd("getTPUnitres");
        //                                 //     console.log(arguments);
        //                                 //     var dblist = [];
        //                                 //     $.each(arguments,function(index,e){
        //                                 //         dblist = $.merge(e,dblist);
        //                                 //     })
        //                                 //     // hideLoading();
        //                                 //     $.each(_pageProvider.pages,function(i,pageItem){
        //                                 //         var list = dblist.filter(function(el){
        //                                 //             return el.pageIndex == pageItem.pageIndex;
        //                                 //         });
        //                                 //         pageItem._loadWidget_ext(list);
        //                                 //     });
        //                                 //     //授课包资源导入后刷新同步精选
        //                                 //     $(document).trigger('mtbk_improt_toSelected');
        //                                 //     hideLoading();
        //                                 //     var tips = tipsDialog({
        //                                 //         "id":"importing" + new Date().getTime(),
        //                                 //         "content":'<span class="success_box_right"></span>授课包导入成功'
        //                                 //     });
        //                                 //     // tips = AppImportAndExportTips.ImportSuccess;
        //                                 //     // addTipDialog(tips);
        //                                 // }).fail(function(e){
        //                                 //     console.timeEnd("getTPUnit");
        //                                 //     hideLoading();
        //                                 //     var tips = tipsDialog({
        //                                 //         "id":"importing" + new Date().getTime(),
        //                                 //         "content":"资源刷新失败，请手动翻页刷新"
        //                                 //     });
        //                                 //     console.log("资源刷新失败，请手动翻页刷新");
        //                                 // });
        //                             });
        //                         }else{
        //                             console.log("解压失败！！！");
        //                             hideLoading();
        //                             var tips = tipsDialog({
        //                                 "id":"importing" + new Date().getTime(),
        //                                 "content":"授课包导入失败"
        //                             });
        //                         }
        //                     })
        //                 }else{
        //                     hideLoading();
        //                     console.log("清空页面数据库数据失败");
        //                     var tips = tipsDialog({
        //                         "id":"importing" + new Date().getTime(),
        //                         "content":"授课包导入失败"
        //                     });
        //                 }
        //             }).fail(function(e){
        //                 console.timeEnd("deleteTPIndex");
        //                 hideLoading();
        //                 console.log("清空页面数据库数据失败");
        //                 var tips = tipsDialog({
        //                     "id":"importing" + new Date().getTime(),
        //                     "content":"授课包导入失败"
        //                 });
        //             });

        //         }else{
        //            //清空书本资源后导入资源
        //             _containerHelper._clearBookRes(data.files,_pageProvider).done(function () {
        //                 showLoading({tips:AppTips.handingImport});
        //                 shellcmd.unzip(args).done(function (ret) {
        //                     hideLoading();
        //                     if (ret) {
        //                         $.each(_pageProvider.pages, function (i, e) {
        //                             if ($.inArray("" + e.pageIndex, data.files) != -1)
        //                                 e.importBookRes();
        //                         });
        //                         //$(_canvasManager).trigger('restoreStrokeWithoutHidePageCanvas');
        //                         tips = AppImportAndExportTips.ImportSuccess;
        //                         //监管
        //                         var action = LogManager.action.trigger;
        //                         var params = {};
        //                         params.module = '1130501';
        //                         var user_id = ebookContext.getUser().getUid();
        //                         if(user_id != '0' && user_id){
        //                             params.user_id =user_id;
        //                         }
        //                         LogManager.statistics(action,params);

        //                     }
        //                     else tips = AppImportAndExportTips.ImportFailed;
        //                     addTipDialog(tips);
        //                     //         trace.log('ebook', actionType.EndImportTeb, {bookCode: _pageProvider.bookCode});
        //                     //清除IFB中书本资源，将TA备课本中对应的所有资源设置为“其他资源”
        //                     var key=["fromapp"];
        //                     var value=[""];
        //                     var bookcode=ebookContext.curBookCode;
        //                     _pptIcwsAccessor.updateInfoByBookcode(key,value,bookcode).done(function(){
        //                          $(document).trigger('mtbk_improt_toSelected');
        //                         console.log("清空TA数据库成功，本书已删除资源标记为本地资源！");
        //                     }).fail(function(){
        //                         console.log("清空TA数据库失败，本书已删除资源标未能记为本地资源！");
        //                     });
        //                 })
        //             });
        //         }
        //     }else {
        //         tips = AppImportAndExportTips.ImportInvalid;
        //         addTipDialog(tips);
        //         //     trace.log('ebook', actionType.EndImportTeb, {bookCode: _pageProvider.bookCode});
        //     }
        // });
    }

    function addTipDialog(tips, buttons, callback) {
        if (!tips) return;
        $.Zebra_Dialog(tips, {
            'type': 'information',
            'title': AppTips.WarmTips,
            'buttons': buttons == undefined ? [AppTips.OkTips] : buttons,
            'onClose': function (caption) {
                if (typeof callback === 'function') callback(caption);
            }
        });
    }
    function getResByPages(pages,list){
        var pagesResList = [];
        if(pages.length>0){
            for(var i =0;i<pages.length;i++){
                var reses = list.filter(function(el){
                    return el.pageIndex == pages[i].pageIndex;
                });
                if(reses.length>0){
                    pagesResList.push(reses);
                }
            }
        }
        return pagesResList;
    }

    exports.Instance = new ImportRes();
});
