/**
 * Created by pengfu on 15-8-18.
 */
;
define(function(require,exports){

    function Converter(){
        var path = nodereq('path');
        var fs = nodereq('fs');
        var shellcmd = require('../../../common/shellcmd');

        var Errors = {

            'CreateMediaDirError':100,
            'ReadSrcXmlError':101,
            'CopyXmlError':103,
            'ConvertTaskError':104,
            'SaveXmlError':105,
            'CreateDstDirError':106
        }

        var Corrects = {
            'OnePageCorrect':200,
            'AllPagesCorret':201
        }

        var tebkFolder = Config.nwexePath + 'plugins/62/bin/tebk';

        var XMLWorker = {
            /**
             * xml字符串转为对象
             * @param xmlStr
             * @returns {HTMLDocument}
             */
            "string2XML": function (xmlStr){
                var parser = new window.DOMParser();
                return parser.parseFromString(xmlStr,"text/xml");
            },

            /**
             * xml序列化
             * @param xmlDoc
             * @returns {string}
             */
            "xml2Str": function(xmlDoc){
                var s = new window.XMLSerializer();
                return s.serializeToString(xmlDoc);
            },

            "save2XMLFile": function(filePath, xmlStr){
                fs.writeFileSync(filePath,xmlStr);
            }
        };

        var fileTag = {
            "eb:img":"img",
            "eb:audio":"audio",
            "eb:video":"video",
            "eb:flash":"flash",
            "eb:proc3rd":"file",
            "eb:note":"note",
            "eb:evaluate":"file",
            "eb:gallery":"file"
        };


        var convertSinglePage = function(mtbkFolder,bookCode, folderName){
            var def = $.Deferred();
            var xamlName = folderName+".xaml";//mtbk与tebk的xaml name
            var srcXml = path.join(mtbkFolder,bookCode,folderName,xamlName);
            var dstDir = path.join(tebkFolder,bookCode,folderName);
            var dstXml = path.join(tebkFolder,bookCode,folderName,xamlName);
            var isExist = shellcmd.isFileExistSync(srcXml);
            if(!isExist){
                def.resolve(Corrects.OnePageCorrect);

            }else{
                fs.readFile(srcXml,'utf-8', function (err, data) {
                    if (err){
                        console.error(err);
                        def.resolve(Errors.ReadSrcXmlError);
                    }
                    var xmlDoc = XMLWorker.string2XML(data);
                    var resRootNode = xmlDoc.getElementsByTagName("absolutelayout")[0];
                    if(!resRootNode){//没有absolutelayout节点，直接拷贝xml

                        shellcmd.createDirIfNotExist(dstDir).done(function(rt){
                            if(rt){
                                try{
                                    XMLWorker.save2XMLFile(dstXml, XMLWorker.xml2Str(xmlDoc));
                                    def.resolve(Corrects.OnePageCorrect);
                                }catch (e){
                                    console.error(e);
                                    def.resolve(Errors.SaveXmlError);
                                }

                            }else{
                                console.error('Errors.CreateDstDirError');
                                def.resolve(Errors.CreateDstDirError);
                            }
                        })


                    }
                    var resourceNodes = resRootNode.children;
                    var nodes2Remove = [],nodes2Do=[];

                    for(var i=0;i<resourceNodes.length;i++){
                        var resNode = resourceNodes[i],nodeName = resNode.nodeName;
                        if(nodeName == "eb:evaluate"|| nodeName == "eb:gallery" || nodeName == "eb:choice" || nodeName == "eb:fadeCurtain" || nodeName == 'eb:note' || nodeName=="eb:icw" || nodeName == "eb:vote"){       //卡片的转化暂时不支持
                            nodes2Remove.push(resNode);
                        }else{
                            nodes2Do.push(resNode);
                        }

                    }
                    for(var j=0;j<nodes2Remove.length;j++){              //删除卡片信息
                        //resRootNode.removeChild(nodes2Remove[j]);
                        (nodes2Remove[j]).remove();
                    }

                    //以上均为同步方法
                    var nodeCopy = function(k){
                        if(k >= nodes2Do.length){
                            //完成，
                            shellcmd.createDirIfNotExist(dstDir).done(function(rt){
                                if(rt){
                                    try{
                                        XMLWorker.save2XMLFile(dstXml, XMLWorker.xml2Str(xmlDoc));
                                        def.resolve(Corrects.OnePageCorrect);
                                    }catch (e){
                                        console.error(e);
                                        def.resolve(Errors.SaveXmlError);
                                    }

                                }else{
                                    console.error('Errors.CreateDstDirError');
                                    def.resolve(Errors.CreateDstDirError);
                                }
                            })


                        }
                        var resNode = resourceNodes[k];
                        var tagName = fileTag[resNode.nodeName];
                        var resFileDom = resNode.getElementsByTagName(tagName)[0];
                        var fileName = resFileDom.getAttribute("src");
                        resFileDom.setAttribute("src","../media/" + fileName);      //修改资源路径信息
                        shellcmd.copyFile(path.join(mtbkFolder,bookCode,folderName, fileName), path.join(tebkFolder,bookCode, "media", fileName)).done(function(ret){
                            if(ret){
                                ++k;
                                nodeCopy(k);
                            }else{
                                def.resolve(Errors.CopyXmlError);
                            }
                        })

                    }
                    nodeCopy(0);

                });
            }

            return def.promise();

        }


        this.convert2Tebk = function(argsJson){
            var def = $.Deferred();
//            argsJson = {"exportpos":"E:/Project/EPD_TAssistant/Branches/DistrictSolution/V1/Development/Source/Client/Main/TA/node_modules/syscmd","name":"授课文件-全学科电子课本演示 V1.020158181945",
//                "rootdir":"E:/Project/EPD_TAssistant/Branches/DistrictSolution/V1/Development/Source/Client/Main/TA/plugins/62/bin/users/liantiaojs2/userbook",
//                "bookcode":"13170425-022",
//                "folders":["1","2","3"]};
            var mtbkFolder = argsJson.rootdir;
            var bookCode = argsJson.bookcode;
            var mediafolder = path.join(tebkFolder,bookCode, "media");
            shellcmd.createDirIfNotExist(mediafolder).done(function(ret){
                if(!ret){
                    //TODO:def.resolve
                    console.error("create dir failed!");
                    def.resolve(Errors.CreateMediaDirError);

                }
                var convertPages = function(ii){
                    if(ii >= argsJson.folders.length){
                        def.resolve(Corrects.AllPagesCorret);
                    }else{
                        convertSinglePage(mtbkFolder,bookCode,argsJson.folders[ii]).done(function(result){
                            if(result == Corrects.OnePageCorrect){
                                ++ii;
                                convertPages(ii);
                            }else{
                                console.error('Corrects.ConvertTaskError');
                                def.resolve(Errors.ConvertTaskError);
                            }
                        })
                    }
                };
                convertPages(0);
            })

            return def.promise();

        }

    }
    exports.Instance = new Converter();
})
