;
define(function(require,exports){

    /***************************************************************
     *
     *   Caution : 这个功能模块是为了做翻页动画（页脚翘起翻转的那种）
     *   存在一些不明确的已知问题，已经废弃
     *   可以询问jhwang 和 luxing 获知详细
     *
     *   在您确定维护修改之前，请慎重
     *
     *                 ------------- by yczhu
     *
     *   2014/7/8   WBgoEB 和 EBgoWB 没有维护和重写
     *   2014/11/25  上述函数已经废弃，不用维护
     ****************************************************************/


    require('jqjson');
    require('hammer');
    var model = require('../../model');
    var define = require('../../define');
    var trace = require('../../trace').Instance;
    var BookViewBase = require("./bookviewbase").BookViewBase;


    /**
     * TurnJS双页视图
     * @param {jQuery} container
     * @param {PageProvider} pageProvider
     * @param {number?} pageIndex
     * @extend  BookViewBase
     */
    function TurnDoublePageView(container, pageProvider, pageIndex) {
        require('turn');

        var _container = container;
        var _pageProvider = pageProvider;
        var _viewDOM;
        var _zoomCSS;
        var _pageIndex = pageIndex || 1;
        var _self = this;

        //console.log('TurnDoublePageView::Construct, pageIndex:%d', _pageIndex);

        function _init() {
            var viewWidth = _container.width();
            var viewHeight = _container.height();

            //console.log('TurnDoublePageView, width:%d, height:%d, imageSize:%s', width, height, $.toJSON(_pageProvider.bookImageSize));
            var imageSize = _pageProvider.bookImageSize;
            var zoomX = viewWidth / 2 / imageSize.width;
            var zoomY = viewHeight / imageSize.height;
            _pageProvider.zoomRate = zoomX;

            var translateX = -imageSize.width * (1 - zoomX) / 2;
            var translateY = -imageSize.height * (1 - zoomY) / 2;
            _zoomCSS = {
                '-webkit-transform': 'matrix(' + zoomX + ',0,0,' + zoomY + ',' + translateX + ' ,' + translateY + ')'

            };
            _viewDOM = $('<div></div>').width(viewWidth).height(viewHeight);
            _container.append(_viewDOM);

            setTimeout(function () {
                _createView(_viewDOM);
            }, 0);
        }

        function _createView(viewDOM) {
            viewDOM.turn({
                acceleration: true, // 是否启用硬件加速
                pages: _pageProvider.pageCount,
                page: _pageIndex,
                elevation: 0,
                duration: 200, // 翻页动画持续时间，取0时取消动画
                gradients: true, // 是否开启渐变
                //                gradients: !$.isTouch,
                when: {
                    turning: function (e, page, view) {
                        $(_self).trigger('beforePageChange');
                        // Gets the range of pages that the book needs right now
                        var range = $(this).turn('range', page);
                        // Check if each page is within the book
                        for (page = range[0]; page <= range[1]; page++)
                            _addPage(page, $(this));
                    },
                    turned: function (event, page, pageObj) {
                        $(_self).trigger('pageChanged');
                    }
                }
            });
            //add a page cover
            // viewDOM.turn('addPage', $('<div/>').html("<h1>Book Conver Page</h1>"), 1);

            viewDOM.bind('pageunload', function (e, pageIndex) {
                _pageProvider.unloadPageItem(pageIndex);
            });
            //            viewDOM.turn("display", "single");
        }

        /**
         * @param pageIndex
         * @param book
         * @private
         */
        function _addPage(pageIndex, book) {
            // 	First check if the page is already in the book
            if (!book.turn('hasPage', pageIndex)) {
                // Create an element for this page
                var element = $('<div />', {
                    'class': 'page ' + ((pageIndex % 2 == 0) ? 'odd' : 'even'),
                    'id': 'page-' + pageIndex
                }).html('<i class="loader"></i>');
                // If not then add the page
                book.turn('addPage', element, pageIndex);
                _pageIndex = pageIndex;
                // Let's assum that the data is comming from the server and the request takes 1s.
                setTimeout(function () {
                    element.empty();
                    _pageProvider.loadPageItem(pageIndex).done(function (ret) {
                        var pageDOM = ret.getContent().css(_zoomCSS);
                        element.append(pageDOM);
                    });

                }, 10);
            }
        }

        /**
         * @inheritDoc
         */
        this.isNextPageEnable = function () {
            return _pageIndex <= _pageProvider.pageCount - 1;
        };

        /**
         * @inheritDoc
         */
        this.nextPage = function () {
            if (_self.isNextPageEnable()) {
                _self.setPageIndex(_pageIndex + 2);
            }
        };

        /**
         * @inheritDoc
         */
        this.isPreviousPageEnable = function () {
            return _pageIndex > 1;
        };

        /**
         * @inheritDoc
         */
        this.previousPage = function () {
            if (_pageIndex <= 2) {
                _self.setPageIndex(2);
            } else {
                _self.setPageIndex(_pageIndex - 2);
            }
        };

        /**
         *
         */
        this.getPageIndex = function () {
            return _viewDOM.turn('page');
        };


        /**
         *  @inheritDoc
         */
        this.refresh = function () {
            _self.setPageIndex(_pageIndex);
        };

        /**
         *  @inheritDoc
         */
        this.setPageIndex = function (pageIndex) {
            //TODO: 只是让它能跑通
            var def = $.Deferred();
            $(_self).trigger('beforePageChange');
            _viewDOM.turn('page', pageIndex);
            _pageIndex = pageIndex;
            $(_self).trigger('pageChanged');
            if (_self._isEditing) _self.setIsEditing(_self._isEditing);
            if($(document).data('openPreviewFrame') && ($(document).data('openPreviewFrame')).uuid){
                console.log('new widget trigger openPreviewFrame -- turndouble');
                $(document).trigger('openPreviewFrame');
            }
            if($(document).data('openPreviewFileFrame') && ($(document).data('openPreviewFileFrame')).uuid){
                console.log('new widget trigger openPreviewFileFrame -- turndouble');
                $(document).trigger('openPreviewFileFrame');
            }

            def.resolve();
            return def.promise();
        };

        /**
         * @inheritDoc
         */
        this.getViewDOM = function () {
            return _viewDOM;
        };

        /**
         * @inheritDoc
         */
        this.getShowPageItem = function () {
            var arr = _viewDOM.turn('view');
            var items = [];
            for (var i = 0; i < _pageProvider.pages.length; i++) {
                var curPageIndex = _pageProvider.pages[i].pageIndex;
                if ($.inArray(curPageIndex, arr) >= 0) {
                    items.push(_pageProvider.pages[i]);
                }
            }
            //console.log('showpageitem:', items);
            return items;
        };

        /**
         *
         * @param canvas
         */
        this.paintStroke = function (canvas, isStrokeChanged) {
            var showPageItems = _self.getShowPageItem();
            //console.log("showPageItems:" + showPageItems);
            var w = canvas.width;
            var h = canvas.height;

            // TODO: 判断左页或右页不存在的情况
            var leftPageItem = showPageItems[0];
            if (leftPageItem) leftPageItem.paintStroke(canvas, new model.Bound(0, 0, w / 2, h), isStrokeChanged);
            var rightPaeItem = showPageItems[1];
            if (rightPaeItem) rightPaeItem.paintStroke(canvas, new model.Bound(w / 2, 0, w / 2, h), isStrokeChanged);
        };

        /**
         * 恢复笔迹
         * @param {HTMLCanvasElement} canvas
         */
        this.restoreStroke = function (canvas) {
            var showPageItems = this.getShowPageItem();
            var w = canvas.width;
            var h = canvas.height;
            //console.log('restoreStroke, canvas size:{w:%s, h:%s}', w, h);

            // TODO: 判断左页或右页不存在的情况
            var leftPageItem = showPageItems[0];
            if (leftPageItem) leftPageItem.restoreStroke(canvas, new model.Bound(0, 0, w / 2, h));

            var rightPageItem = showPageItems[1];
            if (rightPageItem) rightPageItem.restoreStroke(canvas, new model.Bound(w / 2, 0, w / 2, h));
        };

        _init();
    }

    TurnDoublePageView.prototype = new BookViewBase();
    TurnDoublePageView.prototype.constructor = TurnDoublePageView;

    exports.TurnDoublePageView = TurnDoublePageView;

});