/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 14-7-5
 * Time: 下午3:19
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {

    require('jqjson');
    require('hammer');
    var model = require('../../model');
    var define = require('../../define');
    //这个pageitem可以认为是只有用到加载翻页动画
    var PageItem = require('../pageitem').PageItem;

    var trace = require('../../trace').Instance;
    var actionType = require('../../trace').ActionType;
    var BookViewBase = require("./bookviewbase").BookViewBase;
    var commFunc = require("../../../common/commonfunc");
    var pdfbook=require("../pdf/pdfbook").Instance;

    /**
     * 简单双页视图
     * @param {jQuery} container
     * @param {PageProvider} pageProvider
     * @extend  BookViewBase
     */
    function SimpleDoublePageView(container, pageProvider) {

        /**
         * 翻页响应区域
         * @const
         * @type {number}
         */
        var TURN_CORNER_AREA = 70;

        /**
         * 最大翻页次数
         * @type {number}
         * @const
         */
        var MAX_TURN_PAGE_COUNT = 8;

        var _container = container;
        var _pageProvider = pageProvider;
        var _ltCorner, _lbCorner, _rtCorner, _rbCorner;

        var _self = this;

        /**
         * @type {jQuery}
         */
        var _viewDOM;
        var _tempView;
        var _pageTransformCSS;
        var _pageIndex = 0;
        var _oldPageIndex = 0;
        var _newPageIndex = 0;
        var _preparePageIndex = -1;
        var _timeOut;
        var _isSlideLeft;
        var _pageTurnCount = 0; // 页面翻页次数

        var _leftPageWrapper, _leftPageItem, _leftPageIndex;
        var _rightPageWrapper, _rightPageItem, _rightPageIndex;

        var _exleftPageWrapper, _exleftPageItem, _exleftPageIndex;
        var _exrightPageWrapper, _exrightPageItem, _exrightPageIndex;

        var _tempexLeftPage,_tempLeftPage;
        var _tempRightPage,_tempexRightPage;

        this.isTempViewAnimating = false;

        function _init() {
            var viewWidth = _container.width();
            var viewHeight = _container.height();
            var imageSize = _pageProvider.bookImageSize;

            _viewDOM = $('<div/>').attr('class', 'viewdom').css({
                'width': viewWidth + 'px',
                'height': viewHeight + 'px',
                'position': 'relative'
            });

            var pageWrapperCss = {width: viewWidth / 2 + 'px', height: viewHeight + 'px', float: 'left'};
            _exleftPageWrapper = $('<div/>').attr('class', 'exleftPageWrapper').css(pageWrapperCss);
            _leftPageWrapper = $('<div/>').attr('class', 'leftPageWrapper').css(pageWrapperCss);
            _rightPageWrapper = $('<div/>').attr('class', 'rightPageWrapper').css(pageWrapperCss);
            _exrightPageWrapper = $('<div/>').attr('class', 'exrightPageWrapper').css(pageWrapperCss);
            _viewDOM.append(_leftPageWrapper).append(_rightPageWrapper);
            _container.append(_viewDOM);

            var zoomX = viewWidth / 2 / imageSize.width;
            var zoomY = viewHeight / imageSize.height;
            _pageProvider.zoomRate = zoomX;

            var translateX = -imageSize.width * (1 - zoomX) / 2;
            var translateY = -imageSize.height * (1 - zoomY) / 2;
            _pageTransformCSS = {
                '-webkit-transform': 'matrix(' + zoomX + ',0,0,' + zoomY + ',' + translateX + ' ,' + translateY + ')'
            };

            _setTurnPageCorner(imageSize.width, imageSize.height);
            _bindEvents();

            //增加水平滑动翻页动画效果
            _tempView = $('<div/>').attr("class", "tempView").css({
                'width': imageSize.width * 4 + 'px',
                'height': imageSize.height + 'px',
                'position': 'absolute',
                'class': 'tempView',
                'zIndex': 200,
                'display': "none",
                'top': '0px' ,
                'webkit-transform':"translate3d(" + (-viewWidth/2) + "px,0,0)"
            });

            var tempPageCss = {"width": viewWidth / 2, "height": viewHeight, "float": "left"};
            _tempexLeftPage = $('<div/>').attr('class', 'tempexLeftPage').css(tempPageCss);
            _tempLeftPage = $('<div/>').attr('class', 'tempLeftPage').css(tempPageCss);
            _tempRightPage = $('<div/>').attr('class', 'tempRightPage').css(tempPageCss);
            _tempexRightPage = $('<div/>').attr('class', 'tempexRightPage').css(tempPageCss);
            _tempView.append(_tempexLeftPage).append(_tempLeftPage).append(_tempRightPage).append(_tempexRightPage);
            _container.append(_tempView);

            _bindTranstionEndEvent();
        }

        function _setTurnPageCorner(pageWidth, pageHeight) {
            _ltCorner = new model.Bound(0, 0, TURN_CORNER_AREA, TURN_CORNER_AREA);
            _lbCorner = new model.Bound(0, pageHeight - TURN_CORNER_AREA, TURN_CORNER_AREA, TURN_CORNER_AREA);
            _rtCorner = new model.Bound(pageWidth - TURN_CORNER_AREA, 0, TURN_CORNER_AREA, TURN_CORNER_AREA);
            _rbCorner = new model.Bound(_rtCorner.left, _lbCorner.top, TURN_CORNER_AREA, TURN_CORNER_AREA);
        }

        function _getClickPoint(wrapper, e) {
            var wrapperOffset = $(wrapper).offset();
            var targetOffset = $(e.target).offset();
            var point = new model.Point(targetOffset.left - wrapperOffset.left + e.offsetX, targetOffset.top - wrapperOffset.top + e.offsetY);
            return point;
        }

        function _bindEvents() {

//            // 左页页角点击翻页事件处理
//            _leftPageWrapper.click(function (e) {
//                var point = _getClickPoint(this, e);
//                if (_ltCorner.isContainsPoint(point) || _lbCorner.isContainsPoint(point)) {
//                    _self.previousPage();
//                }
//            });
//
//            // 右页页角点击翻页事件处理
//            _rightPageWrapper.click(function (e) {
//                var point = _getClickPoint(this, e);
//                if (_rtCorner.isContainsPoint(point) || _rbCorner.isContainsPoint(point)) {
//                    _self.nextPage();
//                }
//            })
        }

        /**
         * @inheritDoc
         */
        this.isNextPageEnable = function () {
            return _pageIndex < _pageProvider.pageCount - 1;
        };

        /**
         * @inheritDoc
         */
        this.nextPage = function () {
            if (_self.isNextPageEnable()) {
                if (_pageIndex >= _pageProvider.pageCount - 2) {
                    _self.setPageIndex(_pageProvider.pageCount - 1);
                } else {
                    _self.setPageIndex(_pageIndex + 1);
                }
            }
        };

        /**
         * @inheritDoc
         */
        this.isPreviousPageEnable = function () {
            return _pageIndex > 1;
        };

        /**
         * @inheritDoc
         */
        this.previousPage = function () {
            if (_pageIndex <= 2) {
                _self.setPageIndex(1);
            } else {
                _self.setPageIndex(_pageIndex - 1);
            }
        };

        /**
         *  @inheritDoc
         */
        this.refresh = function () {
            var notUseCurrentPageItem = true;
            var leftload = _pageProvider.loadPageItem(_pageIndex - 0, notUseCurrentPageItem);
            var rightload = _pageProvider.loadPageItem(_pageIndex - 0 + 1, notUseCurrentPageItem);
            $.when(leftload, rightload).done(function (ret1, ret2) {
                _leftPageItem = ret1;
                _rightPageItem = ret2;
                var tmp = _pageIndex;
                _pageIndex = -1;
                _self.setPageIndex(tmp);
            });

        };

        /**
         *  @inheritDoc
         */
        this.setPageIndex = function (newPageIndex) {
            var def = $.Deferred();
            if (newPageIndex === _pageIndex) {
                return def.resolve(false);
            }
            //修复bug：单页模式下处于最后一页再切换到双页模式下会出现最后一页处于左页，右页显示空白
            (newPageIndex >= _pageProvider.pageCount - 1) && (newPageIndex = _pageProvider.pageCount - 1);
            (newPageIndex > _pageProvider.pageCount) && (newPageIndex = _pageProvider.pageCount - 2);
            (newPageIndex <= 0) && ( newPageIndex = 1);

            if (_pageIndex !== newPageIndex) {
                _self.isPageLoading = true;
                _oldPageIndex = _pageIndex;
                _newPageIndex = newPageIndex;

                var range = Math.abs(newPageIndex - _pageIndex);
                if (AppCfg.useSlideAnimation) {
                    if (_self.isTempViewAnimating) {
                        _preparePageIndex = newPageIndex;
                        clearTimeout(_timeOut);
                        _timeOut = setTimeout(function () {
                            _self.setPageIndex(_preparePageIndex);
                        }, 200);
                        return;
                    }
                    if (_pageIndex != 0 && range < 2) {
                        (_pageIndex > newPageIndex) && (_isSlideLeft = true);
                        (_pageIndex < newPageIndex) && (_isSlideLeft = false);
                        _self.showAnimateSlide(_isSlideLeft);
                    } else {
                        showLoading({tips: AppBlackBoardTipsList.Loading});
                        _self.isTempViewAnimating = true;
                        if(_exleftPageItem){
                            _pageProvider.unloadPageItem(_exleftPageItem.pageIndex);
                            _exleftPageItem.getContent().remove();
                            _exleftPageWrapper.empty();
                        }
                        if (_leftPageItem) {
                            _pageProvider.unloadPageItem(_leftPageItem.pageIndex);
                            _leftPageItem.getContent().remove();
                            _leftPageWrapper.empty();
                        }
                        if (_rightPageItem) {
                            _pageProvider.unloadPageItem(_rightPageItem.pageIndex);
                            _rightPageItem.getContent().remove();
                            _rightPageWrapper.empty();
                        }
                        if(_exrightPageItem){
                            _pageProvider.unloadPageItem(_exrightPageItem.pageIndex);
                            _exrightPageItem.getContent().remove();
                            _exrightPageWrapper.empty();
                        }

                        var pre = newPageIndex - 0 - 1;
                        var next = newPageIndex - 0 + 2;
                        (pre < 1) && (pre = 1);
                        (next > _pageProvider.pageCount) && (next = _pageProvider.pageCount);

                        var exleftload = _pageProvider.loadPageItem(pre);
                        var leftload = _pageProvider.loadPageItem(newPageIndex - 0);
                        var exrightload =  _pageProvider.loadPageItem(next);
                        var rightload = _pageProvider.loadPageItem(newPageIndex - 0 + 1);
                        $.when(exleftload,leftload, rightload,exrightload).done(function (ret1, ret2,ret3,ret4) {
                             console.log('--------------' + ret1.pageObject.background + ret2.pageObject.background + ret3.pageObject.background + ret4.pageObject.background);
                            _leftPageItem = ret2;
                            _leftPageItem.getContent().css(_pageTransformCSS);
                            if (_leftPageItem) {
                                _leftPageWrapper.empty().append(_leftPageItem.getContent());
                            }

                            _rightPageItem = ret3;
                            _rightPageItem.getContent().css(_pageTransformCSS);
                            if (_rightPageItem) {
                                _rightPageWrapper.empty().append(_rightPageItem.getContent());
                            }

                            _exleftPageItem = ret1;
                            _exleftPageItem.getContent().css(_pageTransformCSS);
                            if (_exleftPageItem) {
                                _exleftPageWrapper.empty().append(_exleftPageItem.getContent());
                            }

                            _exrightPageItem = ret4;
                            _exrightPageItem.getContent().css(_pageTransformCSS);
                            if (_exrightPageItem) {
                                _exrightPageWrapper.empty().append(_exrightPageItem.getContent());
                            }

                            _shiftTempView();
                            _self.unTransFormWidget();

                            if (_self._isEditing) _self.setIsEditing(_self._isEditing);
                            _pageIndex = newPageIndex;
                            if (_pageIndex !== 0) {
                                $(_self).trigger('pageChanged', {oldIndex: _pageIndex, newIndex: newPageIndex});
                            }
                            trace.log('ebook', actionType.SetPage, {pageIndex: _pageIndex});
                            _self.isTempViewAnimating = false;
                            def.resolve(newPageIndex);
                            setTimeout(function () {
                                hideLoading();
                                _self.isPageLoading = false;
                                if($(document).data('openPreviewFrame') && ($(document).data('openPreviewFrame')).uuid){
                                console.log('new widget trigger openPreviewFrame -- simpledouble');
                                $(document).trigger('openPreviewFrame');
                                }
                                if($(document).data('openPreviewFileFrame') && ($(document).data('openPreviewFileFrame')).uuid){
                                console.log('new widget trigger openPreviewFileFrame -- simpledouble');
                                $(document).trigger('openPreviewFileFrame');
                                }
                            }, 0);
                        });
                    }
                } else {
                    showLoading({tips: AppBlackBoardTipsList.Loading});
                }
                if (_leftPageItem && _rightPageItem) {
                    $(_self).trigger('beforePageChange', {oldIndex: _pageIndex, newIndex: newPageIndex});
                }
                _pageIndex = newPageIndex;
            }
            else def.resolve(false);
            return def.promise();
        };

        function _bindTranstionEndEvent(){
            _tempView.on('webkitTransitionEnd', function(){
                console.log("tempView webkitTransitionEnd");
                if(!_self.isTempViewAnimating) return;
                var pageToLoad = _isSlideLeft ? _newPageIndex - 1 : _newPageIndex + 2;
                (pageToLoad < 1) && (pageToLoad = 1);
                (pageToLoad > _pageProvider.pageCount) && (pageToLoad = _pageProvider.pageCount);
                _pageProvider.loadPageItem(pageToLoad).done(function(ret){
                    _shiftViewDOM(ret);
                    _viewDOM.show();
                    _tempView.hide();
                    _shiftTempView();
                    _self.unTransFormWidget();
                    try{
                        if (_self._isEditing) _self.setIsEditing(_self._isEditing);
                    }catch(e){
                        console.log(e);
                    }
                    if (_pageIndex !== 0) {
                        $(_self).trigger('pageChanged', {oldIndex: _oldPageIndex, newIndex: _newPageIndex});
                    }
                    _self.isTempViewAnimating = false;
                    $("#pdfIdentResult").hide();
                    setTimeout(function () {
                        hideLoading();
                        _self.isPageLoading = false;
                        _pageTurnCount++;
                        if(_pageTurnCount >= MAX_TURN_PAGE_COUNT) {
                            _pageTurnCount = 0;
                            commFunc.clearMemory();
                        }
                        if($(document).data('openPreviewFrame') && ($(document).data('openPreviewFrame')).uuid){
                            console.info('cached widget trigger openPreviewFrame');
                            $(document).trigger('openPreviewFrame');
                        }
                        if($(document).data('openPreviewFileFrame') && ($(document).data('openPreviewFileFrame')).uuid){
                            console.info('cached widget trigger openPreviewFileFrame');
                            $(document).trigger('openPreviewFileFrame');
                        }
                    }, 0);
                });
            });
        }

        function _shiftViewDOM(ret){
            if(_isSlideLeft){
                if(_pageIndex != _pageProvider.pageCount - 2){
                    _pageProvider.unloadPageItem(_exrightPageItem.pageIndex);
                }
                if(_exrightPageItem.pageIndex != _rightPageItem.pageIndex){
                    _exrightPageItem.getContent().remove();
                }
                _exrightPageWrapper.empty();

                _exrightPageItem = _rightPageItem;
                _exrightPageWrapper.empty().append(_exrightPageItem.getContent());

                _rightPageItem = _leftPageItem;
                _rightPageWrapper.empty().append(_rightPageItem.getContent());

                _leftPageItem = _exleftPageItem;
                _leftPageWrapper.empty().append(_leftPageItem.getContent());

                _exleftPageItem = ret;
                _exleftPageItem.getContent().css(_pageTransformCSS);
                if (_exleftPageItem && _pageIndex != 1) {
                    _exleftPageWrapper.empty().append(_exleftPageItem.getContent());
                }

            }else{
                if(_pageIndex != 2){
                    _pageProvider.unloadPageItem(_exleftPageItem.pageIndex);
                }
                if(_exleftPageItem.pageIndex != _leftPageItem.pageIndex)
                    _exleftPageItem.getContent().remove();
                _exleftPageWrapper.empty();

                _exleftPageItem = _leftPageItem;
                _exleftPageWrapper.empty().append(_exleftPageItem.getContent());

                _leftPageItem = _rightPageItem;
                _leftPageWrapper.empty().append(_leftPageItem.getContent());

                _rightPageItem = _exrightPageItem;
                _rightPageWrapper.empty().append(_rightPageItem.getContent());

                _exrightPageItem = ret;
                _exrightPageItem.getContent().css(_pageTransformCSS);
                if (_exrightPageItem && _pageIndex != _pageProvider.pageCount - 1 ) {
                    _exrightPageWrapper.empty().append(_exrightPageItem.getContent());
                }
            }
        }

        function _shiftTempView(){

            _tempLeftPage.empty().append(_leftPageItem.getContent().clone());
            _tempRightPage.empty().append(_rightPageItem.getContent().clone());
            _tempexLeftPage.empty().append(_exleftPageItem.getContent().clone());
            _tempexRightPage.empty().append( _exrightPageItem.getContent().clone());

            _tempView.css({
                'webkit-transform':"translate3d(" + (-_container.width()/2) + "px,0,0)",
                "-webkit-transition":"",
                "transition":"",
                "-webkit-transform-style": ""
            });

        }

        /***
         * 预加载两页做动画
         * @private
         */
        this._preloadPage = function (curIdx) {
            var pre = curIdx - 1;
            var next = curIdx + 2;
            if (pre > 0) {
                var p1 = new PageItem(_pageProvider, pre, null);
                p1.loadBackground();
            }
            if (next <= pageProvider.pageCount) {
                var p2 = new PageItem(_pageProvider, next, null);
                p2.loadBackground();
            }
        };

        /**
         * 获取左右滑动动画所需的图片,返回三页的图片数组
         * @param curIdx     当前的页索引
         * @param isSlideToLeft 是否向左滑动
         */
        this.getAnimationPageImgs = function (curIdx, isSlideToLeft) {
            var arr = [];
            var pre = curIdx - 1;
            var next = curIdx + 2;
            //滑不动了
            if ((pre <= 0 && isSlideToLeft ) || (isSlideToLeft == false && (next > pageProvider.pageCount))) {
                return arr;
            }
            if (isSlideToLeft) {
                var p1 = new PageItem(_pageProvider, pre, null);
                var p2 = new PageItem(_pageProvider, curIdx, null);
                var p3 = new PageItem(_pageProvider, curIdx + 1, null);
                var bg1 = p1.getBackgroud();
                var bg2 = p2.getBackgroud();
                var bg3 = p3.getBackgroud();
                if (bg1 == null || bg2 == null || bg3 == null)
                    return arr;
                arr.push(bg1);
                arr.push(bg2);
                arr.push(bg3);
            } else {
                var p1 = new PageItem(_pageProvider, curIdx, null);
                var p2 = new PageItem(_pageProvider, curIdx + 1, null);
                var p3 = new PageItem(_pageProvider, curIdx + 2, null);
                var bg1 = p1.getBackgroud();
                var bg2 = p2.getBackgroud();
                var bg3 = p3.getBackgroud();
                if (bg1 == null || bg2 == null || bg3 == null)
                    return arr;
                arr.push(bg1);
                arr.push(bg2);
                arr.push(bg3);
            }
            return arr;
        };

        /**
         * @inheritDoc
         */
        this.getPageIndex = function () {
            return _pageIndex;
        };

        /**
         * @inheritDoc
         */
        this.getViewDOM = function () {
            return _viewDOM;
        };

        /**
         * @inheritDoc
         */
        this.getTempViewDOM = function(){
            return _tempView;
        };

        /**
         * @inheritDoc
         */
        this.getShowPageItem = function () {
            var arr = [];
            _leftPageItem && arr.push(_leftPageItem);
            _rightPageItem && arr.push(_rightPageItem);
            return arr;
        };

        /**
         * 把canvasmgr的笔迹绘制到这里以便于保存
         * @param canvas
         */
        this.paintStroke = function (canvas, isStrokeChanged) {
            var showPageItems = this.getShowPageItem();
            //console.log(showPageItems);
            var w = canvas.width;
            var h = canvas.height;

            // TODO: 判断左页或右页不存在的情况
            var leftPageItem = showPageItems[0];
            leftPageItem.paintStroke(canvas, new model.Bound(0, 0, w / 2, h), isStrokeChanged);

            var rightPaeItem = showPageItems[1];
            rightPaeItem.paintStroke(canvas, new model.Bound(w / 2, 0, w / 2, h), isStrokeChanged);
        };

        /**
         * 恢复笔迹
         * @param {HTMLCanvasElement} canvas
         */
        this.restoreStroke = function (canvas) {
            var showPageItems = this.getShowPageItem();
            var w = canvas.width;
            var h = canvas.height;
            //console.log('restoreStroke, canvas size:{w:%s, h:%s}', w, h);

            // TODO: 判断左页或右页不存在的情况
            var leftPageItem = showPageItems[0];
            leftPageItem.restoreStroke(canvas, new model.Bound(0, 0, w / 2, h));

            var rightPageItem = showPageItems[1];
            rightPageItem.restoreStroke(canvas, new model.Bound(w / 2, 0, w / 2, h));
        };

        /**
         * 保存笔迹
         */
        this.saveStrokesToLocal = function () {
            var showPageItems = this.getShowPageItem();
            var leftPageItem = showPageItems[0];
            leftPageItem.saveStrokesToLocal();

            var rightPageItem = showPageItems[1];
            rightPageItem.saveStrokesToLocal();
        }

        /**
         * 翻页动画显示
         * @param isSlideToLeft {boolean} 是否向前滑动
         */

        this.showAnimateSlide = function (isSlideToLeft) {
            var viewWidth = _container.width();
            _self.isTempViewAnimating = true;
//            _tempView.show();
            _tempView.css({
                // "z-index":200,
                "z-index":0,
                display:""
            });

            if (isSlideToLeft === true) {
                setTimeout(function(){
                    _tempView.css({
                        "-webkit-transform":"translate3d(0,0,0)",
                        "-webkit-transition":"-webkit-transform 0.2s ease 0s",
                        "-webkit-transform-style": "preserve-3d"
                    });
                },10)
            }
            if (isSlideToLeft === false) {
                setTimeout(function(){
                    _tempView.css({
                        "-webkit-transform":"translate3d(" + (-viewWidth) + "px,0,0)",
                        "-webkit-transition":"-webkit-transform 0.2s ease 0s",
                        "-webkit-transform-style": "preserve-3d"
                    });
                },10)
            }
        };

        _init();
    }

    SimpleDoublePageView.prototype = new BookViewBase();
    SimpleDoublePageView.prototype.constructor = SimpleDoublePageView;

    exports.SimpleDoublePageView = SimpleDoublePageView;
});
