/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-2
 * Time: 下午2:16
 * To change this template use File | Settings | File Templates.
 */
;
/****************************************************************
 * 黑板辅助类
 * 主要存放一些与黑板界面本身无关的后台逻辑
 *
 * 比如 把手势数组识别成文字，把文字合成读音。
 * 这个文件里的代码大多数可以复用。
 * 一些在重构黑板逻辑时不知道该往哪放的函数也在这里。见谅。
 *
 *               -----------  by yczhu
 *
 * 2014/07/25   现在虽然黑板模块已经废弃，但是白板视图的StrokeResult.js
 *      和canvasmgr.js还是会用到这个模块,请不要随意删除
 *
 ****************************************************************/
define(function (require, exports) {
    require("zebra_dialog");
    var speechUiDefine = require('../../speechui/code/define');
    var define = require('../define');
    var md5helper = require('../../common/md5helper');
    var shellcmd = require('../../common/shellcmd');
    var path = require('../../common/path');

    /**
     * 去除手势数组首位的[-1,-1]
     */
    function _removeFirstJoint(strokes) {
        for (var i = 0; i < strokes.length; i++) {
            if (strokes[i][0] == -1 && strokes[i][1] == -1) {
                if (!strokes[i - 1]) {
                    strokes.splice(i, 1);
                    strokes = _removeFirstJoint(strokes);
                }
            }
        }
        return strokes;
    }

    /**
     * 去除手势数组连续的[-1,-1]
     */
    function _removeSerialJoints(strokes) {
        for (var i = 0; i < strokes.length; i++) {
            if (strokes[i][0] == -1 && strokes[i][1] == -1) {
                if (strokes[i + 1]) {
                    if (strokes[i + 1][0] == -1 && strokes[i + 1][1] == -1) {
                        strokes.splice(i + 1, 1);
                        i -= 1;
                    }
                }
            }
        }
        return strokes;
    }

    /**
     * 替换匹配的笔迹坐标
     */
    function _replaceClearedPoints(clearAreaPoints, strokes) {
        //将板擦覆盖区域的点与笔迹中记录的点进行匹配，相等则替换成[-1,-1]
        for (var k = 0; k < clearAreaPoints.length; k++) {
            for (var x = 0; x < strokes.length; x++) {
                if (clearAreaPoints[k][0] == strokes[x][0] &&
                    clearAreaPoints[k][1] == strokes[x][1]) {
                    strokes.splice(x, 1, [-1, -1]);
                }
            }
        }
        return strokes;
    }

    /**
     * 计算被擦除区域的点阵坐标
     * @param {Object} startPoint 擦除区域的起点坐标
     * @param {Object} size 擦除区域的宽高
     * @private
     */
    function _computeClearAreaPoints(startPoint, size) {
        var Points = [];
        for (var i = 0; i < size.width; i++) {
            for (var j = 0; j < size.height; j++) {
                Points.push([startPoint.x + i, startPoint.y + j]);
            }
        }
        return Points;
    }

    /**
     * Caution:
     * 这个函数是为了简化清除笔迹的过程，应该比以前的效果好。
     * 现在仅在canvasmgr里面替换使用，
     * 是对上面_computeClearAreaPoints和_replaceClearedPoints组合使用后的一点点优化。
     * O（n^2）替换成了O（n）,而且n的数量大大减少。
     *          -----  by  yczhu
     */
    function _clearPoints(startPoint, size, strokes) {
       var _left =  size.width > 0 ? startPoint.x : startPoint.x + size.width;
        var _right =  size.width > 0 ? startPoint.x + size.width : startPoint.x ;
        var _top = size.height > 0 ? startPoint.y : startPoint.y + size.height;
        var _bottom = size.height > 0 ? startPoint.y + size.height : startPoint.y;
        for (var k = 0; k < strokes.length; k++) {
            if ((strokes[k][0] < _right) && (strokes[k][0] >= _left) &&
                (strokes[k][1] < _bottom) && (strokes[k][1] >= _top)) {
                strokes.splice(k, 1, [-1, -1]);
            }
        }
        return strokes;
    }

    /**
     * 显示提示内容
     * @param tips {string}
     */
    function _showTips(tips) {
        $.Zebra_Dialog(tips, {
            'type': 'information',
            'title': AppTips.WarmTips,
            'buttons': [ AppTips.OkTips],
            'zIndex': 1000
        });
    };

    /**
     * 播放音频
     */
    function _audioPlay(path, player) {
        //path已经是绝对路径了
//        var path = Config.binPath + path;
        //path已经是绝对路径了
        player[0].src = path;
        player[0].play();
    }

    /**
     * 生成评测所需的card对象
     */
    function _createMeta(cardType, result) {
        var words = result.originalWords;
        var speecher = result.speecher;
        var cardName = "";
        var wordObjArr = [];
        for (var i = 0; i < words.length; i++) {
            cardName += words[i];
            var audio = md5helper.hex_md5(words[i]) + "_" + speecher + i + ".wav";
            var wordObj = {"word": words[i], "audio": audio};
            wordObjArr.push(wordObj);
        }
        var jsonObj = {cardtype: cardType,
            thumbnail: "",
            title: cardName,
            keywords: cardName,
            words: wordObjArr};
        if (cardType == define.EvalCardType.Cn_Word) {
            jsonObj.py = result.py;
        }
        var cardPath = "temp/BlackBoard/" + md5helper.hex_md5(cardName);
        var card = {cardInfo: jsonObj, cardPath: cardPath};
        return card;
    }

    /**
     * 获取卡片内容
     */
    function _getCardOptions(cardInfo, cardPath) {
        var cardOptions = null;
        var cardType = cardInfo.cardtype;
        // 英文单词评测
        if (cardType == define.EvalCardType.En_Word) {
            var wordsArr = cardInfo.words;
            var constFilePath = cardPath + "/";
            var audioPaths = new Array();
            var words = new Array();

            for (var i = 0; i < wordsArr.length; i++) {
                var audioPath = constFilePath + wordsArr[i].audio;
                audioPaths[i] = audioPath.replace('file:/', '');
                words.push(wordsArr[i].word);
            }
            var options = {
                paperContent: '[word]\n' + words.join('\n'),
                audios: audioPaths
            };
            cardOptions = {
                cardName: speechUiDefine.CardName.EnWordEval,
                options: options
            };
        }
        // 中文字词评测
        else if (cardType == define.EvalCardType.Cn_Word) {
            var wordsArr = cardInfo.words;
            var constFilePath = cardPath + "/";
            var audioPaths = new Array();
            var words = new Array();
            var wordsType = 1; // 单字
            var paperContent = cardInfo.py;

            for (var i = 0; i < wordsArr.length; i++) {
                var audioPath = constFilePath.replace("file:/", "") + wordsArr[i].audio;
                words.push(wordsArr[i].word);
                if (words[i].length > 1) {
                    wordsType = 2;  //词
                }
                audioPaths[i] = audioPath;
            }
            //将paperContent中的\r去掉（系统自动把\r变成了\0）
            paperContent = paperContent.replace(/\0/g, "");
            var options = {
                paperContent: paperContent,
                audios: audioPaths,
                isSyllable: wordsType == 1
            };
            cardOptions = {
                cardName: speechUiDefine.CardName.CnWordEval,
                options: options
            };
        }
        return cardOptions;
    }

    /**
     * 合成音频
     * @param  {Array} words
     * @param  {String} speecher
     * @returns {{originalWords: Array, resultWords: Array, audioPaths: Array, py: String, speecher: String}}
     */
    function _textToSpeech(words, speecher, useCSSML, cssmlWords) {
        var def = $.Deferred();
//            if (!ebookContext.getUser() || !ebookContext.getUser().getIsOnline()) {
//                _showTips(AppTips.LocalLoignMsg);
//                def.resolve(null);
//            }
//            else {
        {
            shellcmd.checkOnline().done(function (isNetWorking) {
                if (!isNetWorking) {
                    hideLoading();
                    _showTips(AppTips.NetWorkConnectFailed);
                    def.resolve(null);
                    return def.promise();
                }
                var result = {
                    originalWords: words,
                    resultWords: [],
                    audioPaths: [],
                    py: "",
                    pyArr: [],
                    everyPyArr: [],
                    speecher: speecher
                };
                var paperContent = '<customizer: interphonic>\n';
                var isCnSpeecher = (speecher === "xiaoyan" || speecher === "xiaoyu" || speecher === "wangru");
                var cardName = "";
                for (var i = 0; i < words.length; i++) {
                    cardName += words[i];
                }
                cardName = md5helper.hex_md5(cardName);
//                var constFilePath = "temp/BlackBoard/" + cardName + "/";
                var constFilePath = path.trimPosix(Config.binPath) + "temp/BlackBoard/" + cardName + "/";
                shellcmd.createDir(constFilePath).done(function (createResult) {
                    if (!createResult) {
                        hideLoading();
                        _showTips(AppBlackBoardTipsList.CreateDirFailed);
                        def.resolve(null);
                        return def.promise();
                    }
                    paperContent = '<customizer: interphonic>\n';
                    var i = 0;
                    var audioPath = constFilePath + md5helper.hex_md5(words[i]) + "_" + speecher + "0.wav";
                    var audioJson = "";
                    var callbackFunc = function (index, audioJson) {
                        if (index <= words.length) {
                            audioPath = constFilePath + md5helper.hex_md5(words[index - 1]) + "_" + speecher + (index - 1) + ".wav";
                            audioJson = audioJson.replace(/\n/g, "").replace(/\r/g, "");
                            if (isCnSpeecher) {
                                if (audioJson != "") {
                                    try {
                                        var jsonObj = JSON.parse(audioJson);
                                        var pyArr = jsonObj[0].Sentence.Phrase;
                                        var everyPyArr = [];
                                        var everyPyStr = "";
                                        var test1 = /([^\d]{1})er(\d)/;
                                        var test2 = /([^\d]{2})r(\d)/;
                                        for (var j = 0; j < pyArr.length; j++) {
                                            //引擎自动分词结果
                                            var hz = pyArr[j].Hz;
                                            result.resultWords.push(hz);
                                            //分词对应拼音
                                            var py = pyArr[j].Py;
                                            if (!(test1.test(py))) {
                                                py = py.replace(test2, "$1$2er2");
                                            }
                                            everyPyStr = everyPyStr + py;
                                            py = py.replace(/(\d)/g, "$1|");
                                            var lastIndex = py.lastIndexOf("|");
                                            py = py.substring(0, lastIndex);
                                            paperContent += hz + "\n" + py + "\n\n";
                                            result.pyArr.push(py);
                                        }
                                        everyPyStr = everyPyStr.replace(/(\d)/g, "$1,");
                                        console.log("--1--" + everyPyStr);
                                        var lastIndx = everyPyStr.lastIndexOf(",");
                                        everyPyStr = everyPyStr.substring(0, lastIndx);
                                        everyPyArr = everyPyStr.split(",");
                                        result.everyPyArr = everyPyArr;
                                    } catch (ex) {
                                        hideLoading();
                                        _showTips(AppTips.NetWorkConnectFailed);
                                        def.resolve(null);
                                        return def.promise();
                                    }
                                }
                            }
                            result.audioPaths.push(audioPath);
                            if (index < words.length) {
                                var newAudioPath = constFilePath + md5helper.hex_md5(words[index]) + "_" + speecher + index + ".wav";
                                if (useCSSML) {
                                    shellcmd.text2speech(cssmlWords[index], speecher, newAudioPath, useCSSML).done(function (audioJson) {
                                        callbackFunc(++index, audioJson);
                                    });
                                } else {
                                    shellcmd.text2speech(words[index], speecher, newAudioPath, useCSSML).done(function (audioJson) {
                                        callbackFunc(++index, audioJson);
                                    });
                                }
                            }
                            if (index === words.length) {
                                result.py = paperContent;
                                def.resolve(result);
                            }
                        }
                    };
                    if (useCSSML) {
                        shellcmd.text2speech(cssmlWords[i], speecher, audioPath, useCSSML).done(function (audioJson) {
                            console.log(audioJson);
                            callbackFunc(++i, audioJson);
                        });
                    } else {
                        shellcmd.text2speech(words[i], speecher, audioPath, useCSSML).done(function (audioJson) {
                            callbackFunc(++i, audioJson);
                        });
                    }
                });
            });
        }
        return def.promise();
    }

    /**
     * 识别笔迹
     * @param  {Number} language 语言编码标记
     */
    function _strokes2Words(lan, strokes) {
        var def = $.Deferred();
        if (strokes.length === 0) {
            def.resolve(null);
            return def.promise();
        }
        var jsonStr = JSON.stringify({"lan": lan, "manner": 8193, "mode": 1, "data": strokes});
        shellcmd.hcr(jsonStr).done(function (wordStr) {
            if (wordStr === "") {
                def.resolve(null);
                return def.promise();
            } else {
                console.log("笔迹识别结果： " + wordStr);
                def.resolve(wordStr);
            }
        });
        return def.promise();
    }

    /**
     *  这个函数只是为了减少代码间依赖
     *  无实际意义
     */
    function initShellTTs() {
        var def = $.Deferred();
        shellcmd.initTTS().done(function (initResult) {
            def.resolve(initResult);
        });
        return def.promise();
    }

    function checkShellUrlAccess(){
        var def = $.Deferred();
        shellcmd.checkUrlAccess().done(function (initResult) {
            def.resolve(initResult);
        });
        return def.promise();
    }

    function checkShellOnline(){
        var def = $.Deferred();
        shellcmd.checkOnline().done(function(ret){
            def.resolve(ret);
        })
        return def.promise();
    }

    function _getDOM() {
        var DOMObj = {
            ENtoolBar: $("#blackBoardENToolBar"),
            CNtoolBar: $("#blackBoardCNToolBar"),
            blackboardContainer: $("#blackBoardContainer"),
            canvasContainer: $("#blackBoardCanvasDiv"),
            penColorEles: $('#blackBoardPenColors').children(),
            penSizeEles: $("#blackBoardPenWidths").children(),
            toolBar: $("#blackBoardToolBar"),
            penCtrl: $("#blackBoardPenControl"),
            eraserCtrl: $("#blackBoardEraserControl"),
            penBtn: $('#btnBlackBoardPen'),
            eraserBtn: $('#btnBlackBoardEraser'),
            strokeAndDic: $("#blackBoardStrokeAndDicControl"),
            evalControl: $("#blackBoardEvalControl"),
            minEraBtn: $("#btnBlackBoardMinEraser"),
            midEraBtn: $("#btnBlackBoardMidEraser"),
            bigEraBtn: $("#btnBlackBoardBigEraser"),
            clearBtn: $('#btnBlackBoardClear'),
            areaEraBtn: $("#btnBlackBoardAreaEraser"),
            hideBtn: $('#btnBlackBoardExit'),
            chineseBtn: $("#btnBlackBoardChinese"),
            englishBtn: $("#btnBlackBoardEnglish"),
            chineseExit: $("#btnBlackBoardCNExit"),
            englishExit: $("#btnBlackBoardENExit"),
            xiaoyanBtn: $('#btnBlackBoardXiaoyan'),
            xiaoyuBtn: $('#btnBlackBoardXiaoyu'),
            maryBtn: $('#btnBlackBoardMarry'),
            herryBtn: $('#btnBlackBoardHenrey'),
            nextPageBtn: $("#btnBlackBoardNextPage"),
            prePageBtn: $("#btnBlackBoardPrePage"),
            pyBtn: $("#btnBlackBoardPinYin"),
            dicBtn: $("#btnBlackBoardDictionary"),
            strokeBtn: $("#btnBlackBoardStrokeOrder"),
            evalBtn: $('#btnBlackBoardEvaluate'),
            player: $("#blackBoardPlayer"),
            strokeCanvas: null,
            tempCanvas: null,
            textToScreenDiv: null,
            textToScreenArea: null,
            /** @type {CanvasRenderingContext2D} */
            strokeContext: null,
            tempContext: null
        }
        DOMObj.eraserTypeEles = DOMObj.eraserCtrl.children().children();
        DOMObj.toolBarChildren = DOMObj.toolBar.children();
        return DOMObj;
    }

    /**
     * strokes 存放笔迹
     * clearAreaPoints 存放区域擦除的点 （直觉上觉得这里可以再优化）
     * toStrokeResultWordStr 笔迹识别结果字符串
     * toStrokeResultWords 笔记识别后拆分的单个字/单词
     * strokeOrderResultWordArr 单个字词/单词的分页结果
     */
    function _initConInfo() {
        return {
            strokes: [],
            clearAreaPoints: [],
            toStrokeResultWordStr: null,
            toStrokeResultWords: [],
            strokeOrderResultWordArr: []
        }
    }

    function _nextBlackBoard(i) {
        return i < 10 ? i + 1 : 10;
    }

    function _preBlackBoard(i) {
        return i > 0 ? i - 1 : 0;
    }

    function _showCard(card,CardWrapper) {
        var speechuiIndex = AppRemoteSvcCfg.SpeechUIPageUrl;
        if (AppCfg.isDebug) {
            speechuiIndex += "?d=" + new Date().getTime();
        }
        checkShellUrlAccess(speechuiIndex).done(function (ret) {
            if (ret) {
                var cardOptions = null;
                try {
                    cardOptions = _getCardOptions(card.cardInfo, card.cardPath);
                } catch (ex) {
                    _showTips(AppBlackBoardTipsList.ReadCardOptionsFailed);
                }
                if (cardOptions) {
                    var frameId = cardOptions.cardName + '_' + new Date().getTime();
                    var iframeWidth = Config.Width - 100, iframeHeight = Config.Height;
                    var cardIframe = $('<iframe frameborder="0" allowtransparency="true" scrolling="no" id="' + frameId + '" src="' + speechuiIndex + '"></iframe>').load(function () {
                        var _self = this;
                        var element = $(_self.contentWindow.document.body);
                        setTimeout(function () {
                            $(_self.contentWindow.document).ready(function () {
                                var elementHeight = element.outerHeight();
                                var scale = correctToBaseResolution(element, {max_width: iframeWidth, max_height: iframeHeight, width: element.outerWidth(), height: elementHeight});

                                if (!(scale[0] == 1 && scale[3] == 1))
                                    element.css({
                                        '-webkit-transform': 'matrix(' + scale.join(',') + ')'
                                    });

                                scale[0] = 1 / scale[0], scale[3] = 1 / scale[3];
                                if (scale[0] > 1 || scale[3] > 1) {
                                    element.find("#recorder").css({
                                        'transform-origin': '-100% 100%',
                                        '-webkit-transform': 'matrix(' + scale.join(',') + ')'
                                    })
                                }

                                //可能会解决卡片不居中的问题
                                var screenHeight = window.screen.height;
                                //var speechuiPaddingTop = (screenHeight - elementHeight)/2;
                                var speechuiPaddingTop = (Config.Height - 540)/2;
                                element.css("padding-top",speechuiPaddingTop);

//                                document.removeEventListener('mousedown',fun,true);
//                                cardIframe.show();

                                cardIframe.show();
                            })
                        }, 1000);
                        dispatchClientMsg({evt: 'loadCard', data: cardOptions});
                    });
                    registerIframe(frameId, '*');
                    cardIframe.hide();
                    CardWrapper.show(cardIframe[0]);
                }
            }
            else {
                _showTips(AppTips.RequestServerPageFailed);
            }
        });
    }

    var instanceObj = {
        ToolType: {
            Mouse: 'mouse',
            Pen: 'pen',
            Eraser: 'eraser',
            SmallEraser: 'Small',
            NormalEraser: 'Normal',
            BigEraser: 'Big',
            AreaEraser: 'areaEraser',
            TransPenYellow: 'transPenYellow',
            TransPenRed: 'transPenRed',
            TransPenBlue: 'transPenBlue',
            isRight:'true'
        },
        EraserSize: {
            Small: 14,
            Normal: 34,
            Big: 54
        },
        LanguageType: {
            Chinese: 2147483904,
            English: 7,
            PinYin: 3221225472
        },
        TextType: {
            Chinese: "chinese",
            English: "english",
            PinYin: "pinyin"
        },
        cursor: {
			penCursor: "url(assert/images/pencur02.png),auto",
            minEraCursor: "url(assert/images/bc_14f.cur),auto",
            midEraCursor: "url(assert/images/bc_34f.cur),auto",
            bigEraCursor: "url(assert/images/bc_54f.cur),auto",
            areaEraCursor: "url(assert/images/bc_area.cur),auto",
            auto: "auto"
        },
        removeFirstJoint: _removeFirstJoint,
        removeSerialJoints: _removeSerialJoints,
        showTips: _showTips,
        computeClearAreaPoints: _computeClearAreaPoints,
        clearPoints : _clearPoints,
        audioPlay: _audioPlay,
        getCardOptions: _getCardOptions,
        createMeta: _createMeta,
        textToSpeech: _textToSpeech,
        strokes2Words: _strokes2Words,
        replaceClearedPoints: _replaceClearedPoints,
        getDOM: _getDOM,
        initConInfo: _initConInfo,
        preBlackBoard: _preBlackBoard,
        nextBlackBoard: _nextBlackBoard,
        initShellTTs: initShellTTs,
        checkShellUrlAccess : checkShellUrlAccess,
        checkShellOnline : checkShellOnline,
        showCard : _showCard
    }

    exports.instance = instanceObj;
});
