/**
 * 新建工程
 */

define(function (require, exports) {

    var WorkBase = require("./workbase.js").WorkBase;
    var shellcmd = require("../common/shellcmd.js").shellcmd;
    var container = require("../books/container.js").ContainerInstance;

    function NewWork() {
        var _self = this;

        _self.actName = "newWork";

        _self.do = function () {
            Alert(AppTips.SaveBeforeNew);

            _self.__proto__.do.call(_self,{name:"11111fortest"});
        }

        _self.undo = function(){
            Alert("撤销新建任务");
        }

        _self.createWork = function(){
            var _bookDir = Config.ebookBasePath + "/演示";
            shellcmd.makeDir(_bookDir).done(function(){
                var srcCover = Config.ebookBasePath + "/defaultcover.png",
                    dstCover = _bookDir + "/演示_Thumbnail.png";
                shellcmd.copyFile(srcCover,dstCover).done(function(){
                    container.init();
                });
            });
        }
    }

    NewWork.prototype = new WorkBase();
    NewWork.prototype.constructor = NewWork;

    exports.NewWorkInstance = new NewWork();
});


