/**
 * 操作记录列表项
 * 供撤销用
 */

define(function (require, exports) {

    function DoList() {
        var _self = this;
        var _list = [];

       /**
        * 添加操作记录
        * 参数格式 ：
        * {
        *   action : "XXX",
        *   data : {}
        * }
        */
        _self.record = function (jsonObj) {
            if (_list.length < AppCfg.DolistLength) {
                _list.push(jsonObj);
            }
            else {
                _list.shift();
                _list.push(jsonObj);
            }
        }

        //获取操作记录，供撤销操作使用
        _self.revert = function () {
            return (_list.length > 0) ? _list.pop() : "";
        }

        //清空操作记录，供保存使用
        _self.clear = function(){
            _list = [];
        }
    }

    exports.DoListInstance = new DoList();
})
