﻿/**
 * 公共函数，包括文件读写等
 */

define(function (require, exports) {

    var fs = nodereq("fs");
    var gui = nodereq('nw.gui');
    var win = gui.Window.get();
    var cp = nodereq("child_process");
    var shellcmd = {};

    /**
     * 读文件，同步
     * @param filePath
     * @returns {string}
     */
    shellcmd.readFile = function (filePath) {
        if (!filePath)
            throw new Error("error arguement");
        try {
            return fs.readFileSync(filePath, encoding = 'utf8');
        } catch (err) {
            console.error(err.message);
            return "";
        }
    }

    /**
     * 写文件，同步
     * @param {!string} content 可选，如果为空则认为是写入空字符串
     * @param {!string} filePath 文件路径
     */
    shellcmd.writeFile = function (filePath, content) {
        var path = nodereq('path');
        if (!filePath)
            throw new Error("error arguement");
        var ct = content || "";
        try {
            fs.writeFileSync(filePath, ct);
        } catch (err) {
            console.error(err);
        }
    }

    /**
     * 拷贝文件
     * @param {!string} content 可选，如果为空则认为是写入空字符串
     * @param {!string} filePath 文件路径
     */
    shellcmd.copyFile = function (src, des) {
        var defer = jQuery.Deferred();
        var fileReadStream = fs.createReadStream(src);
        var fileWriteStream = fs.createWriteStream(des);
        fileReadStream.pipe(fileWriteStream);
        fileWriteStream.on('error', function () {
            console.log('copy failed');
            defer.resolve(false);
        });
        fileWriteStream.on('close', function () {
            console.log('copy over');
            defer.resolve(true);
        });
        return defer.promise();
    }

    /**
     * 打开对话框
     * @param {object=}  opt_params  可选参数  eg: {accept: ".doc,.ppt"}
     */
    shellcmd.openFileDialog = function (opt_params) {
        var defer = jQuery.Deferred();
        var fileDialog = jQuery('<input style="display:none;"  type="file"/>');
        //动态创建，不用依赖于界面
        if (fileDialog.length) {
            if (opt_params) {
                for (var attr in opt_params)
                    fileDialog.attr(attr, opt_params[attr]);
            }
            fileDialog.one('change', function () {
                defer.resolve(fileDialog.val());
            });
            fileDialog.trigger('click');
            if (opt_params) {
                for (var attr in opt_params)
                    fileDialog.removeAttr(attr);
            }
        }
        return defer.promise();
    }

    /**
     * 保存对话框
     * @param opt_params
     * @returns {*}
     */
    shellcmd.saveFileDialog = function (opt_params) {
        opt_params = opt_params || {};
        if (!opt_params.nwsaveas)
            opt_params.nwsaveas = "";
        var defer = jQuery.Deferred();
        this.openFileDialog(opt_params, "save").done(function (ret) {
            console.log("save file: " + ret);
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /**
     * 写入注册表
     * @param regPath {string} 要写入的注册表项路径，例如"HKEY_LOCAL_MACHINE\\SOFTWARE\\iflytek\\LPD /v installPath"
     * @param regValue {string} 写入的值，例如"E:\Project\EPD_EP1.0\Trunk\Development\Source\Client"
     */
    shellcmd.writeREG = function (regPath, regValue) {
        regValue = regValue.replace(/ /g, "\" \"");
        var expression = "REG ADD " + regPath + " /t reg_sz /d " + regValue + " /f";
        cp.exec(expression, function (error, stdout, stderr) {
            if (error != null) {
                console.error('exec error:' + error);
            }
        });
    }

    /**
     * 检测是否联网
     * @return {string} "true"表示联网，"false"表示未联网
     */
    shellcmd.checkOnLine = function () {
        var def = jQuery.Deferred();
        var exec = cp.exec, child;
        try {
            child = exec('ping -n 1 -w 200 www.baidu.com', {
                timeout: 0,
                maxBuffer: 200 * 1024,
                killSignal: 'SIGTERM'
            }, function (error, stdout, stderr) {
                //shellcmd.log('网络判断::'+JSON.stringify(error))
                if (error !== null) {
                    def.resolve(false);
                }
                else {
                    def.resolve(true);
                }
            });
        } catch (ex) {
            def.reject();
        }
        return def.promise();
    }

    /**
     * 操作本地文件
     * @param path
     * @param callback
     */
    shellcmd.handleFile = function (path, content, callbackObj) {
        'use strict'
        callbackObj = callbackObj || {};
        var success = callbackObj.success;
        var fail = callbackObj.fail;
        var type = callbackObj.type;
        //写文件
        if (type == "write") {
            shellcmd.writeFile(path, content || '');
            success && success();
            //读文件
        } else {
            fs.exists(path, function (exist) {
                // 不存在
                if (exist) {
                    var result = shellcmd.readFile(path);
                    success && success(result);
                } else {
                    fail && fail();
                }
            });
        }
    }

    shellcmd.log = function (msg) {
        fs.appendFile(APP_CONFIG.BASE_PATH + "/log.txt", '\r\n ------' + new Date() + ':' + msg, function () {
        });
    }

    shellcmd.makeDir = function(path){
        var def = $.Deferred();
        fs.mkdir(path,function(){
            def.resolve();
        });
        return def.promise();
    }

    shellcmd.fileOrDirExist = function(path){
        var def = $.Deferred();
        fs.exists(path,function(exist){
            def.resolve(exist);
        });
        return def.promise();
    }

    shellcmd.minApp = function(){
        win.minimize();
    }

    shellcmd.closeApp = function(){
        win.close(true);
    }

    exports.shellcmd = shellcmd;
});

