/**
 * 将xml转换成json对象，性能比较好
 * Date: 2013/08/29
 * Author: luxing@iflytek.com
 * @version 1.0
 *
 * 这一块是直接从iflybook里面拿过来的
 */

define(function(require,exports){

    function PageXmlParser() {
        // if arrayMap, all node of xmlDocument will be put into an array
        // if not arrayMap, all single node of xmlDocument wil be treated as property
        this.ToJSON = function (str, arrayMap) {
            str = replaceSpecialString(str);
            var xmlDoc = null;

            var domParser = new DOMParser();
            xmlDoc = domParser.parseFromString(str, 'text/xml');

            if (xmlDoc.hasChildNodes()) {
                var node = this.ParseNode(xmlDoc, arrayMap);
                //node["X-Parse-Engine"]="MX.Util.XML";
                //node["X-JSMX-Framework"]="Version 1.2";
                node = _parseXmalObj(node);
                return node;
            }
            return null;
        };

        this.ParseNode = function (xmlNode, arrayMap) {
            var node =
            {
                //"$attribute":null,
                //"$count":0,
                //"$name":xmlNode.nodeName,
                //"$type":xmlNode.nodeType,
                //"$value":""
            };
            var _node = null;
            if (xmlNode.attributes)	// because xmlNode.hasAttributes() method just work in FF
            {
                for (var i = 0, n = xmlNode.attributes.length; i < n; ++i) {
                    _node = xmlNode.attributes[i];
                    node[_node.nodeName] = _node.nodeValue;	// or escape(_node.nodeValue)?
                }
            }
            if (xmlNode.hasChildNodes()) {
                //if(xmlNode.firstChild.nodeType==3)
                //{
                //	node["$value"] = xmlNode.firstChild.nodeValue.replace(/\n\r*/g, "").replace(/^\s+/, "").replace(/\s+$/, "");
                //}
                var name = "";
                var p = null;
                var count = 0;
                for (var i = 0, n = xmlNode.childNodes.length; i < n; ++i) {
                    _node = xmlNode.childNodes[i];
                    if (_node.nodeType == 3) continue;
                    name = _node.nodeName;
                    p = this.ParseNode(_node, arrayMap);
                    if (node[name] == null) {
                        //node["$count"]++;
                        if (!arrayMap) {
                            count = 0;
                            for (var c = 0, m = xmlNode.childNodes.length; c < m; ++c) {
                                if (xmlNode.childNodes[c].tagName == name)count++;
                                if (count == 2) break;
                            }
                            if (count == 1) {
                                node[name] = p;
                                continue;
                            }
                        }
                        node[name] = [];
                    }
                    node[name].push(p);
                }
            }
            return node;
        };
    }

    function _parseXmalObj(obj) {
        var xmalObj;
        for (var attr in obj) {
            xmalObj = obj[attr];
        }
        xmalObj = _replaceNameSpace(xmalObj);
        return xmalObj;
    }


    function _replaceNameSpace(obj) {
        var newObj = {};
        for (var attr in obj) {
            if (attr == "eb:HotspotControl.Audio") {
                newObj[attr] = obj[attr];
            } else {
                var newAttr = attr.replace("eb:", "");
                newObj[newAttr] = obj[attr];
            }

            if (typeof newObj[newAttr] == "object") {
                if (newObj[newAttr] instanceof Array) {
                    var arr = new Array();
                    for (var i = 0; i < newObj[newAttr].length; i++) {
                        arr[i] = _replaceNameSpace(newObj[newAttr][i]);
                    }
                    newObj[newAttr] = arr;
                } else {
                    newObj[newAttr] = _replaceNameSpace(newObj[newAttr]);
                }

            }
        }
        return newObj;
    }

    /**
     * 对xnl中的特殊字符转义
     * @param str
     * @returns {*}
     */
    function replaceSpecialString(str) {
        if (!str) return null;
        var replaceSrc = "&<>\'\"" ,
            replaceDst = ["&amp;", "&lt;", "&gt;", "&apos;", "&quot;"];

        var index = false, pos;
        for (var i = 0, len = str.length; i < len; ++i) {
            if (str[i] === '"') {
                index = !index;
                //转义双引号中的双引号
                if (!index && i + 1 < len && str[i + 1] !== ' ' && str[i + 1] !== '>' && str[i + 1] != '/')
                    index = true;
                else continue;
            }
            if (index) {
                if ((pos = replaceSrc.indexOf(str[i])) != -1)
                    str = str.substr(0, i) + replaceDst[pos] + str.substr(i + 1);
            }
        }
        return str;
    }

    exports.Instance = new PageXmlParser();
})
