/**
 * 书本辅助类，提供基本book信息
 * 包括书本，目录等
 */

define(function (require, exports) {

    var Page = require("./page.js").Page;

    var menu = require("./menu.js").MenuInstance;

    function Provider() {

        var _self = this,
            //已加载的页面数据缓存
            _loadpages = {},

            //书本的基本信息
            _book = {
                bookName: "演示",
                grade: "13",
                subject: "17",
                volum: "04",
                publisher: "25",
                coverPath: "演示_Thumbnail.png"
            }

        _self.setBookName = function (name) {
            _book.bookName = name;
        }

        _self.setBookGrade = function (grade) {
            _book.grade = grade;
        }

        _self.setBookVolum = function (volum) {
            _book.volum = volum;
        }

        _self.setBookSubject = function (subject) {
            _book.subject = subject;
        }

        _self.setBookPublisher = function (publisher) {
            _book.publisher = publisher;
        }

        _self.setBookCover = function (coverPath) {
            _book.coverPath = coverPath;
        }

        _self.getBookInfo = function () {
            return _book;
        }

        _self.getBookPath = function () {
            return Config.ebookBasePath + _book.bookName;
        }

        _self.getBookJsonMenuPath = function(){
            return _self.getBookPath() + "/" + _book.bookName + ".json";
        }

        _self.getAllPagesNumNext = function () {
            return menu.getAllPagesNum()+1;
        }

        _self.loadPage = function (num) {
            var def = $.Deferred();
            if (_loadpages[num]) {
                def.resolve(_loadpages[num]);
            }
            else {
                var newPage = new Page();
                newPage.init(num, _book.bookName).done(function () {
                    _loadpages[num] = newPage;
                    def.resolve(newPage);
                });
            }
            return def.promise();
        }

        _self.savePage = function(num){
            num = parseInt(num);
            if(_loadpages[num]){
                _loadpages[num].save();
            }
        }

        _self.saveMenu = function(){
            menu.saveMenu(_self.getBookJsonMenuPath());
        }

        _self.addPage = function(pagenum){
            menu.addPage(pagenum);
        }

        _self.saveOneHots = function(x,y,w,h,num){
            num = parseInt(num);
            if(_loadpages[num]){
                _loadpages[num].saveOneHots(x,y,w,h);
            }
        }

    }

    exports.ProviderInstance = new Provider();
});

