/**
 * 书本数据总入口
 */
define(function (require, exports) {

    var provider = require("./provider").ProviderInstance;
    var shellcmd = require("../common/shellcmd.js").shellcmd;
    var bookView = require("./bookview.js").BookViewInstance;


    function Container() {
        var _self = this;
        //当前页码，页面切换时要改动
        var _curPageNum = 0;

        //初始化一些信息，第一次打开时调用
        _self.init = function(){
            _curPageNum = 0;
            _self.showBookInfo();
        }

        //缩放显示区域
        _self.zoom = function () {
            bookView.zoom();
        }

        //保存书本
        _self.saveBook = function () {
            //保存热区描述
            saveCurPage();
            //保存目录json
            saveMenu();
        }

        //添加一页(最后一页)
        _self.addOnePage = function (srcpath) {
            //获取页码
            var pagenum = provider.getAllPagesNumNext(),
                bookInfo = provider.getBookInfo(),
            //TODO : 后缀名重新获取
                filename = pagenum + ".jpg",
                fileFolder = Config.ebookBasePath + "/" + bookInfo.bookName + "/" + pagenum;
            //页面文件夹
            shellcmd.fileOrDirExist(fileFolder).done(function (exist) {
                if (exist) {
                    addPageHelper(fileFolder, filename, srcpath, pagenum);
                }
                else {
                    shellcmd.makeDir(fileFolder).done(function () {
                        addPageHelper(fileFolder, filename, srcpath, pagenum);
                    })
                }
            });
        }

        //页面跳转
        _self.goToPage = function (num) {
            saveCurPage();
            //TODO:过场动画，稍候提示等
            _self.loadPage(num);
            _curPageNum = num;
        }

        //页面加载
        _self.loadPage = function (num) {
            provider.loadPage(num).done(function (pageObj) {
                bookView.changePage(pageObj);
            });
        }

        //添加热区,仅仅是将热区绘制面板show出来
        _self.addHots = function () {
            bookView.showPaintCanvas();
        }

        //添加热区
        _self.saveOneHots = function(x,y,w,h){
            bookView.showOneHots(x,y,w,h);
            provider.saveOneHots(x,y,w,h,_curPageNum);
        }

        //显示书本信息
        _self.showBookInfo = function () {
            bookView.showBookInfo(provider.getBookInfo(), provider.getBookPath());
        }

        //改变书本信息
        _self.changeBookInfo = function(grade,volum,subject,publisher){
            grade && provider.setBookGrade(grade);
            volum && provider.setBookVolum(volum);
            subject && provider.setBookSubject(subject);
            publisher && provider.setBookPublisher(publisher);
        }

        //改变封面
        _self.changeCover = function (srcPath) {
            var dstPath = provider.getBookPath() + "/" + provider.getBookInfo().coverPath;
            //封面改变时，覆盖原图片，保持封面名称不变
            shellcmd.copyFile(srcPath, dstPath).done(function (ret) {

                //TODO : 这里应该加个随机数刷新缓存
                bookView.showCover(dstPath + "?id=111");
            });
        }

        //私有函数，只在类内部使用
        //添加页面辅助函数
        function addPageHelper(fileFolder, fileName, srcPath, pagenum) {
            var dstPath = fileFolder + "/" + fileName;
            //将底图copy进目录
            shellcmd.copyFile(srcPath, dstPath).done(function (ret) {
                if (ret) {
                    //添加一页目录
                    provider.addPage(pagenum);
                    //打开这一页
                    _self.goToPage(pagenum);
                }
            });
        }

        function saveCurPage(){
            provider.savePage(_curPageNum);
        }

        function saveMenu(){
            provider.saveMenu();
        }
    }

    exports.ContainerInstance = new Container();
});
