define(function (require, exports) {

    function BookView() {
        var _self = this;

        var $bookView = $("#bookView"),
            $hotsCanvas = $("#hotsCanvas"),
            $paintCanvas = $("#paintCanvas"),
            $bookCover = $("#bookCover");

        var canvasw = $bookView.css("width"),canvash = $bookView.css("height");

        $hotsCanvas.attr("width",canvasw).attr("height",canvash).hide();
        $paintCanvas.attr("width",canvasw).attr("height",canvash).hide();

        var paintCanvasCtx = $paintCanvas[0].getContext("2d");
        paintCanvasCtx.strokeStyle = "blue";
        paintCanvasCtx.lineWidth = 1;

        var hotsCanvasCtx = $hotsCanvas[0].getContext("2d");
        paintCanvasCtx.strokeStyle = "red";
        paintCanvasCtx.lineWidth = 1;

        //TODO : 这儿有点蛋疼，返回值是计算后的像素值
        _self.zoom = function () {
            var _width = $bookView.css("width");
            if (_width == "80%") {
                $bookView.css("width", "100%");
            }
            else {
                $bookView.css("width", "80%");
            }
        }

        _self.changePage = function (pageObj) {
            var bgpath = pageObj.getBG();
            $bookView.css("background", "url(" + bgpath + ")").text("");

            var Hots = pageObj.getHots();
            loadHots(Hots);
        }

        _self.showOneHots = function(x,y,w,h){
            $hotsCanvas.show();
            hotsCanvasCtx.strokeRect(x,y,w,h);
        }

        _self.showBookInfo = function (book, bookPath) {
            console.log(bookPath + "/" + book.coverPath);
            _self.showCover(bookPath + "/" + book.coverPath);
        }

        _self.showCover = function (src) {
            $bookCover.attr("src", src);
        }

        //TODO:显示绘制画布
        _self.showPaintCanvas = function(){
            $paintCanvas.show();
        }

        //TODO : $hotsCanvas 渲染热区
        function loadHots (hots){
            $hotsCanvas.show();
        }
    }

    exports.BookViewInstance = new BookView();
});
