/**
 * cretor: zzsun@iflytek.com
 * date: 2014年6月3日
 * description: 用户服务
 */


var userServer = function (opt) {

}
var APP_CONFIG={};
var path = require('path');
var fs = require('fs');
var querystring = require('querystring');
var http = require('http');
//根目录
APP_CONFIG.BASE_PATH = path.resolve('../../').replace(/\\/g, '/');
//请求的服务器地址
APP_CONFIG.HOST='172.16.95.26';
APP_CONFIG.PATH='/sns/api/assistantapi.php?method=validate_user';
/**
 * 构造函数
 * @returns {userServer}
 */
function constr(){
    var user = new userServer();
    return user;
}

/**
 * 获取用户信息
 * _userInfo={
 * 		    "name"       	//姓名
			"grade"   		//年级
			"phone" 		//手机号码
			"photo" 		//用户头像
			"school" 		//所在学校
			"subject"		//学科
			"userAccount"   //用户账户名
			"email"    		//邮箱 
			"sex"         	//性别
			"appName"       //所属平台
 * }
 */
userServer.prototype.getUserInfo = function(){
	//返回的用户信息
    var userInfo;
    var path = APP_CONFIG.BASE_PATH + "/uli.dat";
    console.log(path);
    try{
        var localUserInfo = shellcmd.readFile(path);
        userInfo =  JSON.parse(localUserInfo);
    }
    catch (e){
        console.error(e.message);
        var _userInfo="";
        return _userInfo;
    }
    var _userInfo = {
        "login_name":userInfo.loginName,   //用户名
        "name": userInfo.userName,         	//姓名
        "grade": userInfo.gradeName,   	//年级
        "phone" : userInfo.groupName,  	//手机号码
        "photo" : userInfo.photo,      	//用户头像
        "school" : userInfo.schoolName,	//所在学校
        "subject": userInfo.subjectName,	//学科
        "userAccount": userInfo.userid,    //用户账户名
        "email":userInfo.email,         	//邮箱
        "sex":userInfo.gender,             	//性别
        "appName":userInfo.appName          //归属信息
    }
    return _userInfo;
}

/**
 * 用户登录
 * @param LoginInfo={
 *          "username":***,
 *          "password":***
 * }
 * callback={
 *      success:function(){},
 *      fail:function(){}
 * }
 */
userServer.prototype.login=function(loginInfo,callback){
    var success = callback.success;
    var fail = callback.fail;
    var postDataLog = {
        'login_name': loginInfo.username || "",
        'password': loginInfo.password || "",
        "ll":""
    };
    var postData = querystring.stringify(postDataLog);
    //新建消息
    var options = {
        host: APP_CONFIG.HOST,
        port: 80,
        path: APP_CONFIG.PATH,
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
            //'Content-Length': postData.length
        }
    };
    var reqHttps = http.request(options, function (resHttps) {
        console.log("statusCode: ", resHttps.statusCode);
        console.log("headers: ", resHttps.headers);
        resHttps.setEncoding('utf8');
        var body=""
        resHttps.on('data', function (body1) {
            console.log("body:" + body1);
            body = JSON.parse(body1);
        });
        resHttps.on('end', function () {
            if(resHttps.statusCode==200){
                if (body.statuscode == 1) {
                    var $userInfo = body.data.user;
                    var userPath = APP_CONFIG.BASE_PATH + "/uli.dat";
                    var loginPath = APP_CONFIG.BASE_PATH + "/login.dat";
                    shellcmd.writeFile(userPath, JSON.stringify($userInfo));
                    shellcmd.writeFile(loginPath, JSON.stringify(loginInfo));
                    success&&success(body);
                } else {
                    fail&&fail(body);
                }
            }
        });
    });
    reqHttps.write(postData + '\n');
    reqHttps.end();
    reqHttps.on('error', function (e) {
        console.error("error:" + e);
        return "系统异常：" + e.message;
    });


}

/**
 * 读文件，同步
 * @param filePath
 * @returns {string}
 */
var shellcmd={};
shellcmd.readFile = function(filePath) {
    if (!filePath)
        throw new Error("error arguement");
    try {
        return fs.readFileSync(filePath, encoding = 'utf8');
    } catch (err) {
        console.error(err.message);
        return "";
    }
}
/**
 * 写文件，同步
 * @param {!string} content 可选，如果为空则认为是写入空字符串
 * @param {!string} filePath 文件路径
 */
shellcmd.writeFile = function(filePath, content) {
    if (!filePath)
        throw new Error("error arguement");
    var ct = content || "";
    try {
        fs.writeFileSync(filePath, ct);
    } catch (err) {
        console.error(err);
        return "";
    }
}

module.exports = constr;
