/**
 * cretor: zzsun@iflytek.com
 * date: 2014年5月20日
 * description: 用户统计
 */

var querystring = require('querystring');
var http = require('http');
var fs = require('fs');
var statistLog = function (opt) {

}

/**
 * 构造函数
 * @param appid
 * @returns {statistLog}
 */
function constr(appid){
    var sta = new statistLog();
    sta.appid = appid;
    return sta;
}
constr.a=0;
setInterval(function(){
	constr.a++;
	console.error(constr.a);
},2000);
//账户标识字段
var account = "";
//应用id
var _appid = "";
var path = require('path');
var fs = require('fs');
var APP_CONFIG={};
//请求的服务器地址
APP_CONFIG.HOST='192.168.62.72';
APP_CONFIG.PATH='/TeacherAssistant1.0/Server/main_controller-setMainAction.html';
//本地存储guid字段名
APP_CONFIG.GUID = "main-guid";
//本地存储reportlog字段名
APP_CONFIG.REPORTLOG = "analysis-reportlog";
//设置上传时间间隔
APP_CONFIG.REPORT_TIME_INTERVAL = 3 * 60 * 1000;
//根目录
APP_CONFIG.BASE_PATH = path.resolve('../../').replace(/\\/g, '/');
/**
 *  立即上报
 *  默认参数 0  代表立即上传
 */
statistLog.prototype.autoReport = function (action) {
    var _guid="";
    _appid = this.appid;
    var path = APP_CONFIG.BASE_PATH + "/guid.dat";
    try{
        _guid = shellcmd.readFile(path);
        _guid =  JSON.parse(_guid);
    }
    catch (e){
        console.error(e.message);
    }
    if (_guid) {
        account = _guid;
    }
    console.log(_guid)
    action = action || "start";
    convert(action, 0);
}

/**
 * 执行某个操作时记录
 *
 * action 用户行为描述
 * type 记录方式，1为保存本地 0为直接上传
 */
statistLog.prototype.trace = function (action) {
    var _guid;
    _appid = this.appid;
    action = action || 'app';
    var path = APP_CONFIG.BASE_PATH + "/guid.dat";
    try{
        _guid = shellcmd.readFile(path);
        _guid = JSON.parse(_guid);
    }
    catch (e){
        console.error(e.message);
    }
    if (_guid) {
        account = _guid;
    }
    convert(action, 1);
}

/**
 * log存储在本地
 * localstorage.analysis-analysis-reportLog= {"json":json=[json1,json2,json3···]}
 * type 记录方式，1为保存本地 0为直接上传
 */
var convert = function (action, type) {
    var reportList = [];
    //新建Log记录数组，
    var report_time = new Date();
    report_time = report_time.getFullYear() + "-" + (report_time.getMonth() + 1) + "-" + report_time.getDate() +
        " " + report_time.getHours() + ":" + report_time.getMinutes() + ":" + report_time.getSeconds();
    var  username="";
    var path = APP_CONFIG.BASE_PATH + "/uli.dat";
    try{
        var localUserInfo = shellcmd.readFile(path);
        var userInfo =  JSON.parse(localUserInfo);
        username = userInfo.loginName;
    }
    catch (e){
        console.error(e.message);
        username="";
    }
    //把当前的用户行为记录构造成json
    var postData = {
        "uci_userName":username,//用户名
        "uci_guid": account,    //用户guid
        "uci_content": action||'',  //用户行为
        "uci_appid": _appid||'',          //行为类型
        "uci_time": report_time   //时间戳
    };
    //获取本地存储的日志
    var path = APP_CONFIG.BASE_PATH + "/report.log";
    try{
        var localLog = shellcmd.readFile(path);
        reportList =  JSON.parse(localLog);
    }
    catch (e){
        console.error(e.message);
    }
    console.log(postData)
    reportList.push(postData);
    var path = APP_CONFIG.BASE_PATH + "/report.log";
    shellcmd.writeFile(path, JSON.stringify(reportList));
    //if (type == 0) {
     //   upload();
   // }
}
/**
 * log上传
 */
var upload = function () {
    var path = APP_CONFIG.BASE_PATH + "/report.log";
    fs.exists(path, function(exist) {
        // 存在
        if (exist) {
            var postData="";
            //获取本地存储的日志
            try{
                var localLog = shellcmd.readFile(path);
                postData =  JSON.parse(localLog);
            }
            catch (e){
                console.error(e.message);
            }
          //   postData = querystring.stringify(postDataLog);
            //新建消息
            var options = {
                host: APP_CONFIG.HOST,
                port: 80,
                path: APP_CONFIG.PATH,
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                    //'Content-Length': postData.length
                }
            };
            var reqHttps = http.request(options, function (resHttps) {
                console.log("statusCode: ", resHttps.statusCode);
                console.log("headers: ", resHttps.headers);
                resHttps.setEncoding('utf8');
                resHttps.on('data', function (body1) {
                    console.log("body:" + body1);
                });
                resHttps.on('end', function () {
                   if(resHttps.statusCode==200){
                       //移除本地记录
                       var path = APP_CONFIG.BASE_PATH + "/report.log";
                       shellcmd.writeFile(path, "");
                   }
                });
            });
            reqHttps.write(postData + '\n');
            reqHttps.end();
            reqHttps.on('error', function (e) {
                console.error("error:" + e);
                return "系统异常：" + e.message;
            });

        }
    });
}
var shellcmd={};
/**
 * 读文件，同步
 * @param filePath
 * @returns {string}
 */
shellcmd.readFile = function(filePath) {
    if (!filePath)
        throw new Error("error arguement");
    try {
        return fs.readFileSync(filePath, encoding = 'utf8');
    } catch (err) {
        console.error(err.message);
        return "";
    }
}
/**
 * 写文件，同步
 * @param {!string} content 可选，如果为空则认为是写入空字符串
 * @param {!string} filePath 文件路径
 */
shellcmd.writeFile = function(filePath, content) {
    if (!filePath)
        throw new Error("error arguement");
    var ct = content || "";
    try {
        fs.writeFileSync(filePath, ct);
    } catch (err) {
        console.error(err);
        return "";
    }
}

//statistLog.autoReport("");

module.exports = constr;

//设置3分钟自动上报
//setInterval(upload, APP_CONFIG.REPORT_TIME_INTERVAL);
