
//var os = require("./module/node-0.10.24/AddonOS");
//var uuid = require('D:/Projects/EPD_EP1.0/Trunk/Development/Source/SlideApp/bin/main/editor/assert/js/widget/pptcard/test/lib/uuid');
var uuid = window.require('../node_modules/logcenter/lib/uuid');
//var osInfo = JSON.parse(os.GetDeviceInfo());

LogParam = {
	"product"			: "jsj",							//产品（枚举）【必填】
	"app"				: "jsj",							//应用【必填】
	"module"			: "",								//模块代码，需要应用自定义模块映射关系【必填】
	"device"			: {									//设备
		"model_number"	: "",								//型号
		"os_version"	: "",						//操作系统版本
		"resolution"	: "",								//分辨率
		"position"		: "",								//设备地域信息
		"mac"			: "",					            //mac地址
		"imei"			: ""								//移动设备国际身份码
	},
	"platform"			: "windows",						//平台
	"action"			: "",								//主要操作的函数名称【必填】
	"param"				: "",								//参数
	"result"			: "",								//结果
	"timestamp"			: "",								//时间戳 【必填】
	"end_time"			: "",								//结束时间
	"user_id"			: "",								//用户id
	"session_id"		: "",			                    //会话id
    "guid"              :""                                 //guid
}

function TrackParam() {

	// 配置基础信息
	this.ConfigBaseInfo = function(config) {
		for(var attr in config) {
			if(LogParam[attr] != undefined && typeof(LogParam[attr]) != "object") {
				LogParam[attr] = config[attr];
			}
		}
	}

	// 配置设备信息
	this.ConfigDeviceInfo = function(config) {
		for(var attr in config) {
			if(LogParam["device"][attr] != undefined) {
				LogParam["device"][attr] = config[attr];
			}
		}
	}

	//创建监控参数
	this.CreateParam = function() {
		var param = cloneObj(LogParam);
//		param["timestamp"] = new Date().toISOString();
		return param;
	}

	//检测参数类型是否匹配和关键字段信息
	this.CheckParam = function(param) {
		if(!equal(LogParam, param)){
			return false;
		}
		return (param["product"] != "" && param["app"] != "" && param["module"] != "" && param["action"] != "" && param["timestamp"] != "" && param["session_id"] != "");
	}

	// 检测参数类型是否匹配
	function equal(param1, param2) {
		if(typeof(param1) != typeof(param2)) {
			return false;
		}
		if(typeof(param1) == 'object'){
			for(var i in param1) {
				if(param2[i] == 'undefined') {
					return false;
				}
				if(!equal(param1[i], param2[i])) {
					return false;
				}
			}	
		}
		return true;
	}

	// 拷贝参数对象
	function cloneObj(obj) {
		if(typeof(obj) != 'object') {
			return obj;
		}
		if(obj == null) {
			return obj;
		}
		var newObj = new Object();
		for(var i in obj) {
			newObj[i] = cloneObj(obj[i]);
		}
		return newObj;
	}
}

exports.TrackParam = TrackParam;
