module.exports = function(grunt) {

  var pkg = grunt.file.readJSON('package.json');
  var target = grunt.option('target') || 'test'; 	// Ŀ
  if(target != 'test' && target != 'production') {
	 grunt.fail.fatal('unexpect target:' + target);
  }

  // Project configuration.
  grunt.initConfig({
    pkg: (function(){
		pkg.target = target;
		
		grunt.log.writeln(['target:' + target, 'src:' + pkg.path.src, 'dist:' + pkg.path.dist]);
	
		return pkg;
	})(), 
	
	
	
	concat: {	
		js:{
			files:{
				'<%= pkg.path.src %>/edc-security.js':
				[
					'<%= pkg.path.src %>/jsbn.js',
					'<%= pkg.path.src %>/prng4.js',
					'<%= pkg.path.src %>/rng.js',
					'<%= pkg.path.src %>/rsa.js'
				]
			}
		}
	},
	
    uglify: {
		main: {
            options: {
                //Ҫѹrequire
                mangle: {
                    except:['require','exports','module','this','_this','_self','self']
                },
				beautify : false
               // mangle:false
            },
			files: [{
				expand: true,
				cwd: '<%= pkg.path.src %>',
				src: ['edc-security.js'],
				dest: '<%= pkg.path.dist %>',
				ext: '.min.js'
			}]
		}
	}
  });

  // Load the plugin that provides the "uglify" task.
  
  grunt.loadNpmTasks('grunt-contrib-copy');
  grunt.loadNpmTasks('grunt-contrib-clean');
  grunt.loadNpmTasks('grunt-contrib-cssmin');
  grunt.loadNpmTasks('grunt-contrib-uglify');
  grunt.loadNpmTasks('grunt-contrib-concat'); 
  grunt.loadNpmTasks('grunt-filerev');
  grunt.loadNpmTasks('grunt-usemin');
  
  grunt.registerTask('log', 'log somethi', function(){
	  console.log('hahaha');
	  console.dir(grunt.filerev.summary);
  })
  grunt.registerTask('build',['concat', 'uglify']);
 

  // Default task(s).
  grunt.registerTask('default', ['build']);

};