/**
 * Created by JJ on 15-6-7.
 */

// the number of current uploading;
var curUploadCnt = 0;
// the number of a batch of upload ;
var uploadTotal = 0;
var uploadFail = 0;
var uploadFailIndex = [];
// the number of current sharing;
var curShareCnt = 0;
// the number of a batch of share ;
var shareTotal = 0 ;


function UI_operate($DOM_list , op_type_list , Target_list){
    var op_type_sets = ['remove' , 'show' , 'hide' , 'append'];
    if (!($DOM_list instanceof Array)){
        $DOM_list = [$DOM_list];
    }
    if (!(op_type_list instanceof Array)){
        op_type_list = [op_type_list];
    }
    if (!(Target_list instanceof Array)){
        Target_list = [Target_list];
    }

    op_type_list.forEach(function(it){
        if (op_type_sets.indexOf(it) == -1){
            return false;
        }
    });
    $DOM_list.forEach(function(it , i){
        if (typeof it == 'string'){
            if(it[0] == '#'){
                it = it.replace(/^#/ , '');
                it = $('#'+it);
            }
        }
        if(op_type_list[i] == op_type_sets[0]){
            it.remove();
        } else if(op_type_list[i] == op_type_sets[1]){
            it.show();
        }else if(op_type_list[i] == op_type_sets[2]){
            it.hide();
        } else if (op_type_list[i] == op_type_sets[3]){
            it.append(Target_list[0]);
        }
    });
    return true;
}


function common_operate(op_list , paramList){
    var return_value_arr = [];
    var op_type_sets = ['getItemLi' , 'getAttribute' , 'isHidden' ,'find' , 'setAttribute'];
    //if (op_type_sets.indexOf())
    if (!(op_list instanceof Array)){
        op_list = [op_list];
    }
    if (!(paramList[0] instanceof Array)){
        paramList = [paramList];
    }
    paramList.forEach(function(it){
        if (!(it[0] instanceof $)){
            if (!(typeof it[0] == 'string')){
                it[0] = $(it[0]);
            }
        }
    });
    var op = "";
    paramList.forEach(function(it , i){
        var param = it;
        op = op_list[i] || op;
        if (typeof param[0] == 'string'){
            if(param[0][0] == '#'){
                param[0] = param[0].replace(/^#/ , '');
                param[0] = $('#'+param[0]);
            }
        }
        if (op == op_type_sets[0]){
            return_value_arr.push( param[0].parents(param[1]));
        } else if (op == op_type_sets[1]){
            return_value_arr.push( param[0].attr(param[1]));
        }else if(op == op_type_sets[2]){
            return_value_arr.push(param[0].find(param[1]).is(':hidden'));
        }else if(op == op_type_sets[3]){
            return_value_arr.push(param[0].find(param[1]));
        }else if(op == op_type_sets[4]){
            return_value_arr.push(param[0].attr(param[1] , param[2]));
        }
    });
    return return_value_arr.length == 1 ? return_value_arr[0] : return_value_arr;
}

function HttpRequest(url , callback){
    var def = $.Deferred();
    $.ajax({
        url: url,
        type: "post",
        timeout: 30000,
        dataType: "json",
        success: function (result) {
            console.log(result);
            callback&&callback(result);
            def.resolve(result);
        },
        error: function (er) {
            console.log(er);
            callback&&callback({length:0,total:0,data:{length:0}});
            def.resolve(er);
        }
    });
    return def.promise();
}

/**
 * // 本地课件实现类
 * @param uid 用户uid
 */
function class_local(uid){

    var _self = this;
    // 本地课件列表展示的DOM模板
    var DomTemplate_item = '<li  index={{_index}} style="cursor: pointer;margin-bottom: 9px">'+
                                '<div class="add-pre-inforing">'+
                                 '<p class="pre-inforimg prepare_local_img"><img style="height: inherit;width: 211px;" src="{{thumbnail}}" title = "{{tips_title}}" onerror="javascript:this.src=' + "'" + 'assets/images/new_load_error.png'+" ';"+'"' + '></p>' +
                                 '<p class="pre-infortext" style="width: 190px;" title= "{{tip_title}}">{{title}}</p>' +
                                 '<p class="pre-checkbox" style="display: none;cursor: pointer;left: initial;right: 5px;"><input style="cursor: pointer;" name="" type="checkbox" value="" ></p>' +
                                 '<p id = "toolbar_beike" class="pre-btnbar prepare_local_toolbar" style="display: none"><span id = "fr" class="fr"><img src="assets/images/open_ico.png">打开</span></p>' +
//                                  '<div id = "toolbar_beike_upload" class="" style="display: none;position: absolute;background: #000000;opacity: 0.8;top:82px;left:0px;height: 25px;width: 154px"> '+
//                                     '<div id = "beike_yun_upProgress" class="jd-block clearfix" style="display:none;position:absolute;left: 1px ; top:4px">'+
//                                        '<p class="fl" style="width: 100px"><span id = "process_beike_upload"></span></p>'+
//                                     '</div>'+
//                                  '</div>' +
//                                  '<b class="fl" id = "processData_beike_upload" style="display:none;color : white ;position: absolute;left: 59px ; top:88px">上传中...</b>'+
                               '</div>'+
                             '</li>';
    var DomTemplate_page = '';
    // 当前数据模型, 来此数据库映射到AllInfo后的筛选数据
    var dataModel = null;
    // 数据库操作类
    var dbaccessor;
    // 当前页码
    _self.cur_page = 1;
    // 所有页数
    _self.allPage = 1;

    this.getDataModel = function(){
        return dataModel;
    };

    /**
     * 反转dataModel数据，为了从后往前展示数据
     * @param dataModel
     * @returns {*}
     */
    function reverseData(dataModel) {
        if (! (dataModel instanceof Array)){
            return null;
        }
        for (var i = 0 ,j = dataModel.length - 1 ;i < j ; ++i , --j){
            var tmp = dataModel[i];
            dataModel[i] = dataModel[j];
            dataModel[j] = tmp;
        }
        return dataModel;
    }

    /**
     * 产生筛选的keys 和 values
     * @returns {{}}
     */
    this.getSelectInfo = function(){
        var selectInfo = {} ;
        selectInfo.keys = ["bookcode" , "unit1" , "unit2" , "unit3" , "unit4"];
        var vals = [];
        pageMyPrepare.curBookMetaInfo&&(vals.push(pageMyPrepare.books[pageMyPrepare.curBookIndex].bookCode),
            vals.push(pageMyPrepare.curBookMetaInfo.Unit1),
            vals.push(pageMyPrepare.curBookMetaInfo.Unit2),
            vals.push(pageMyPrepare.curBookMetaInfo.Unit3),
            vals.push(pageMyPrepare.curBookMetaInfo.Unit4));
        selectInfo.vals = vals;
        return selectInfo;
    };


    function updateDataModel(keys,vals){

        var def = $.Deferred();
        (!dbaccessor)&&(pageMyPrepare.dbaccessor = dbaccessor = new KeJian.InfoAccess(uid));

        dbaccessor.selectInfo(keys,vals).done(function(ret){
            dataModel = ret;
            dataModel = reverseData(dataModel);
            _self.allPage = Math.ceil(dataModel.length / pageMyPrepare.localCoursewareCfg.itemShowNumber);
            def.resolve();
        });
        return def.promise();
    }

    function getSelectedItemInfo(callback , share){
        var selectedItemInfo_sets = [];
        var $item = common_operate('find' , ['#pre-inforlist2' , 'li']);
        for (var i = 0 ;i < $item.length ; ++i){
            if(common_operate('getAttribute',[common_operate('find' , [$item[i] , '.pre-checkbox input']), 'checked'])){
                var index = parseInt(common_operate('getAttribute' , [$item[i] , 'index']));
                //选择过后，将旋转状态清除
                $($item[i]).find('.pre-checkbox input').attr('checked' , false).prop("checked" , false);
                callback&&callback(($item[i]) , share);
                console.log(dataModel[index-1]);
                var filePath = dataModel[index-1].filepath;
                var timestamp = dataModel[index-1].timestamp;
                var type = dataModel[index-1].type;
                var srcPath = APP_CONFIG.PPTICWS_PATH + uid + '/'+ timestamp + '/' + filePath;
                selectedItemInfo_sets.push({"filepath": srcPath , "timestamp" : timestamp,"type":type,index:index});
            }
        }
        return selectedItemInfo_sets;
    }

    function ItemSelectAreaHide($Dom , share){
        if (!share){
            uploadTotal ++ ; // 上传总数增加
            curUploadCnt ++;
        } else {
            shareTotal ++ ;
            curShareCnt ++;
        }
        common_operate('setAttribute' , [[ common_operate('find' , [[$Dom , '.pre-checkbox input']]) , 'checked' , false]]);
        UI_operate(common_operate('find' , [[$Dom , '.pre-checkbox']]) ,'hide' );

    }


    function getFileNameFromPath(filePath){
        var file = filePath.substr(filePath.lastIndexOf('/')+1);
        var fileName = file.substr(0,file.lastIndexOf('.'));
        return fileName;
    }


    /**
     * 初始化数据，产生第一次展示数据
     * @param keys
     * @param vals
     * @returns {*}
     */
    this.init = function(keys ,vals){
        var def = $.Deferred();
        _self.cur_page = 1;
        dbaccessor = new KeJian.InfoAccess(uid);
        pageMyPrepare.dbaccessor = dbaccessor;
        updateDataModel(keys , vals).done(function(){
            def.resolve();
        });
        return def.promise();

    };

    /**
     * 刷新展示
     * @param refreshType refresType = Add 时 表示新增课件后的展示
     */
    this.refresh = function(refreshType){

        $('#selectAll_local').removeAttr('checked');
        var selectKV = this.getSelectInfo();
        updateDataModel(selectKV.keys , selectKV.vals).done(function(){
            if (refreshType == "Add"){
                _self.cur_page = 1;
            } else {
                _self.cur_page = (_self.cur_page>_self.allPage?_self.allPage:_self.cur_page);
            }
            pageMyPrepare.indexInit(_self.cur_page ,_self.allPage ,'courseware_local' , _self.prePage ,_self.nextPage ,_self.anyPage);
            _self.anyPage(_self.cur_page);
        });
    };

    /**
     * 放映课件
     * @param $DOM
     * @param isPlay
     */
    this.doWithPPTICW = function($DOM , isPlay){
        var exec = require("child_process").exec;
        var index = parseInt($DOM.parents('li').attr("index"));
        var filePath = APP_CONFIG.PPTICWS_PATH + uid + '/'+ dataModel[index-1].timestamp + '/' + dataModel[index-1].filepath;
        var fileType = dataModel[index-1].type;
        if (APP_CONFIG.KeiJianType.PPT == fileType || APP_CONFIG.KeiJianType.PPTX == fileType) {
            shellcmd.playOrEditPPT(filePath , isPlay );
        } else if (APP_CONFIG.KeiJianType.ICW == fileType) {
            shellcmd.playOrEditICW(filePath, isPlay);
        }
        dbaccessor.updateTime(dataModel[index-1].timestamp);
    };
    /**
     * 分享至班级
     */
   this.send_interact_data = function(params){
       var srcPathCollect = []; // 文件路径集合
       var classIds = '';
       var content = '';
       var bookInfo = pageMyPrepare.curBookMetaInfo;
       var attachInfo = '';
       var attachments = [];
       var labelIds = '';
       //上传的文件集合
       srcPathCollect = pageMyPrepare.sendFilesObj;//getSelectedItemInfo();
       //要发送的标题内容
       if(bookInfo.Unit1==''||!bookInfo.Unit1){
           content = pageMyPrepare.books[pageMyPrepare.curBookIndex].title;
       }else{
           content = bookInfo.Name;
       }
       for(var i =0 ;i<pageMyPrepare.sendClassesStr.length;i++){
           classIds = classIds+pageMyPrepare.sendClassesStr[i]+',';
       }
       classIds = classIds.substr(0,classIds.length-1);
       for(var k = 0;k<srcPathCollect.length;k++){
           /*var thisType = srcPathCollect[k].type=='icw'?'6':'4';*/
           var thisType= pageMyPrepare.sendFilesObj[0].$model.extension.split("_")[1]
           var thisTypecode=0;
           if(thisType=="word"){
               thisTypecode=5}
           else if(thisType=="ppt"){
               thisTypecode=4
           }else if(thisType=="music"){
               thisTypecode=1
           }else if(thisType=="video"){
               thisTypecode=2
           }else if(thisType=="pic"){
               thisTypecode=0
           }
           attachInfo += "{attachType:" + thisTypecode + ",duration:0},";
           var filepath = APP_CONFIG.PPTICWS_PATH + uid + '/'+ srcPathCollect[k].timestamp + '/' + srcPathCollect[k].filepath
           attachments.push(filepath);
       }
       attachInfo = attachInfo.substr(0,attachInfo.length-1);
       attachInfo = "["+attachInfo+"]";
       //TODO：获取标签
       _self.getLabelId().done(function(result){
             labelIds = result;
             _self.start_send_interact(pageMyPrepare.userInfo.id,content,attachments,classIds,attachInfo,labelIds);
             LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'24',ta_app:'beike'},null);
       }).fail(function(){
           pageMyPrepare.showCommonTip('获取发送的标签失败，请尝试重新发送',false);
       });
       this.start_send_interact = function(ownerId,content,attachments,classIds,attachInfo,labelIds){
           //下面注释掉的两行代码是调用获取接口的方法获取url，现在使用配置文件获取接口，暂时不删除这两行代码，有可能后期会用到
           //TA_Token_Manager.getInterface(function(interUrl){
           //    interUrl += "method=jx.feed.add&version=1.0&format=json&ownerId="+ownerId+"&content="+content+"&classIds="+classIds+"&attachInfo="+attachInfo+"&labelIds="+labelIds+"&fromApp=3";
               var url= APP_CONFIG.SHARELOCALTOCLASS+"&ownerId="+ownerId+"&content="+content+"&classIds="+classIds+"&attachInfo="+attachInfo+"&labelIds="+labelIds+"&fromApp=3";
               var idFlag = shellcmd._getRandomString();
               var json = {
                   type : "logic",
                   action : "ta_upload",
                   from : "ta",
                   to : "ta_dum",
                   "data" : {
                       id :idFlag ,
                       url : encodeURI(url),
                       key : "attachments",
                       file : attachments,
                       source:"prepare_send_interact",
                       uid:ownerId
                   }
               };
               socket&&socket.send(json);
               socket&&pageMyPrepare.beikeTipOnly('process','温馨提示','正在发送，请稍候');
               pageMyPrepare.send_to_interact_list.push(idFlag);
           //},pageMyPrepare.resCenterFlag);
       }
   };


    /**
     * 云文件分享至云资源网关
     */
    this.send_interact_data_tocloud = function(params){
        var def = jQuery.Deferred();
        TA_Token_Manager.getInterface(function(interUrl){
            var srcPathCollect= myprebook.localDbInfo.filter(function(el){return el.checked == true;});
            var extension=myprebook.extensionView;
            var typeCode="";
            if(extension=="word"){
                typeCode="0100";  //教学设计
            }else if(extension=="ppt"){
                typeCode="0600";//同步课件
            }else{
                typeCode="0300"//素材
            }
            //获取年级和阶段
            var phase = '';
            var grade=pageMyPrepare.books[pageMyPrepare.curBookIndex].grade;
            switch(grade){
                case "01":case "02":case "03":case "04":case "05":case "06":
                phase = '03'; //小学
                break;
                case "07":case "08":case "09":
                phase = '04'; //初中
                break;
                case "19":
                    phase = '05'; //高中
                    break;
                case "20": //职教1
                case "21": //职教2
                    phase = '05'; //高中
                    break;
                default:
                    phase = ''; //其他
                    break;
            }
            //file为当前选中资源信息
            var file=myprebook.localDbInfo.filter(function(el){return el.checked==true})[0];
            var fileindex={
                general:{
                    source:"UGC",
                    extension:srcPathCollect[0].extension_db,
                    creator:pageMyPrepare.userInfo.loginName,
                    uploader:pageMyPrepare.userInfo.loginName,
                    quality:"20"
                },
                properties:{
                    subject:pageMyPrepare.userInfo.subject,
                    phase:phase,
                    grade:grade,
                    book:pageMyPrepare.books[pageMyPrepare.curBookIndex].bookCode,
                    edition:"",
                    stage:"",
                    volumn:pageMyPrepare.books[pageMyPrepare.curBookIndex].volumn,
                    unit1:pageMyPrepare.curBookMetaInfo.Unit1!=""?pageMyPrepare.curBookMetaInfo.Unit1:null,
                    unit2:pageMyPrepare.curBookMetaInfo.Unit2!=""?pageMyPrepare.curBookMetaInfo.Unit2:null,
                    unit3:pageMyPrepare.curBookMetaInfo.Unit3!=""?pageMyPrepare.curBookMetaInfo.Unit3:null,
                    unit4:pageMyPrepare.curBookMetaInfo.Unit4!=""?pageMyPrepare.curBookMetaInfo.Unit4:null,
                    type:typeCode,//资源对应类型编码
                    rrtlevel1:"08",
                    knowledge:null
                },
            }
            fileindex=JSON.stringify(fileindex);
            var fileInfo={
                filename:file.aliasname,
                filepath:file.downloadpath,
                length:file.length,
                md5:file.md5?file.md5:""
            };
            fileInfo=JSON.stringify(fileInfo);
            //var url=interUrl+'method=pan.file.export&version=1.0&format=json&labelType=3&uid='        //旧接口方法
            var url=APP_CONFIG.SHARECLOUDTOGATEWAY//新接口方法
                +"&fileInfo="+fileInfo +"&fileIndex="+fileindex+"&auditStatus=0";
            $.ajax({
                url:url,
                type:'post',
                timeout:4000,
                dataType:'json',
                success:function(result){
                    pageMyPrepare.beikeTipOnly('success', '温馨提示', '资源已分享成功');
                },
                error:function(err){
                    console.log(err);
                    def.reject();
                    pageMyPrepare.beikeTipOnly('fail', '温馨提示', '分享失败！');
                }
            });
        },pageMyPrepare.resCenterFlag);
        return def.promise();
    };


   //获取课件导学的标签
   this.getLabelId = function(){
       //TODO：获取标签
       var def = jQuery.Deferred();
       TA_Token_Manager.getInterface(function(interUrl){
           $.ajax({
               url:interUrl+'method=jx.label.extend.list&version=1.0&format=json&labelType=3',
               type:'get',
               timeout:4000,
               dataType:'json',
               success:function(result){
                   var flag = false;
                   for(var i in result){
                       if(result[i].labelName == '课前导学'){
                           def.resolve(result[i].labelId);
                           flag = true;
                       }
                   }
                   if(!flag) def.reject();
               },
               error:function(err){
                   console.log(err);
                   def.reject();
               }
           });
       },pageMyPrepare.resCenterFlag);
       return def.promise();
   };
    /**
     * 上传课件
     */
     var calcMd5 = function(fp){
        var fs=require("fs");
        var crypto = require("crypto");
        var content = fs.readFileSync(fp);
        var md5Sum = crypto.createHash('md5');
        return md5Sum.update(content).digest('hex');
     };
        this.upload = function(share){
            var srcPathCollect = []; // 文件路径集合
            // 循环扫描DOM，通过dataModel的下标值获取勾选项信息
            if (pageMyPrepare.curBookMetaInfo.Unit1 == "" ){
                var str = '上传';
                if(share) str = '分享';
                pageMyPrepare.showCommonTip("当前目录不是课题，请选择具体的课题后"+str,false);
                return;
            }
            srcPathCollect= myprebook.localDbInfo.filter(function(el){return el.checked == true;});
            uploadTotal =srcPathCollect.length;
            curUploadCnt =srcPathCollect.length;
            uploadFail = 0;
            uploadFailIndex = [];
    /*        var allFileSize = pageMyPrepare.checkFileSizeAll(srcPathCollect);
            if(allFileSize>200) {
                pageMyPrepare.showCommonTip('文件总大小超过200M，请重新选择',false);
                return;
            }*/
            pageMyPrepare.beikeTipOnly('process','温馨提示','正在上传，请稍候');
            //TODO:EDC
            for (var i = 0 ; i < srcPathCollect.length  ; ++i){
                (function(i){
                    $(document).queue("beikeQueueUpload",function(){
                        var filePath = srcPathCollect[i].filepath;
                        var isBeikeRes = srcPathCollect[i].fromIfb;
                        var srcPath = APP_CONFIG.PPTICWS_PATH + uid + '/'+ srcPathCollect[i].timestamp + '/' + srcPathCollect[i].filepath;
                        //判断文件是否存在
                        fs.exists(srcPath, function(exist) {
                            if(true != exist){
                                curUploadCnt--;
                                uploadFail++;
                                $(document).dequeue("beikeQueueUpload");
                                beike_file_upload_result();
                            }else{
                                //文件存在 - 进入下载流程
                                var fileName = getFileNameFromPath(filePath);
                                var timestamp = srcPathCollect[i].timestamp;
                                var extension = path.extname(path.basename(srcPath));
                                extension = extension.substr(1,extension.length - 1)
                                var index =i;/* srcPathCollect[i].index*/
                                fileName = encodeURIComponent(fileName);
                                var bookMeta = pageMyPrepare.books[pageMyPrepare.curBookIndex];
                                var pageMeta = pageMyPrepare.curBookMetaInfo;
                                var md5 = calcMd5(srcPath);
                                edcService.Instance().pan_file_resource_prepare({
                                    openId:pageMyPrepare.userInfo._sso_openId,
                                    extension:extension
                                }).done(function(ret){
                                    if(ret.code == 0){
                                        var uploadChunks = ret.data.prepareInfo.uploads;

                                        //完成文件上传参数
                                        var edc_file_upload_complete_request = {
                                            platForm : uploadChunks[0].params.appKey, //prepare返回接口数据中的appKey
                                            contextId: uploadChunks[0].params.contextId //prepare接口中返回的contextId
                                        };
                                        var contextId = uploadChunks[0].params.contextId;
                                        var url = ret.data.prepareInfo.url;
                                        //文件上传请求接口
                                        var edc_file_add_request = {
                                            openId : pageMyPrepare.userInfo._sso_openId,
                                            name : path.basename(path.basename(srcPath)),
                                            url : url, //文件地址
                                            md5 : md5, // 文件md5值
                                            length : fs.statSync(srcPath).size, // 文件长度
                                            // status : "", // 文件上传状态
                                            // token : "", // 结果签名（contextId、url、md5、length、status进行计算）
                                            contextId : contextId, // 通过文件服务上传后文件服务返回id
                                            description : "", // 文件描述
                                            grade : bookMeta.grade, // 年级属性
                                            subject : bookMeta.subject, // 学科属性
                                            publisher : bookMeta.publisher, // 上下册
                                            phase : "", // 版本属性
                                            volumn : bookMeta.volumn, // Stage
                                            edition : "", // 类型属性
                                            stage : "", // Stage
                                            type : "", // 书本属性
                                            book : bookMeta.bookCode, // 书本属性
                                            unit1 : pageMeta.Unit1, // 课本一级目录
                                            unit2 : pageMeta.Unit2, // 课本二级目录
                                            unit3 : pageMeta.Unit3, // 课本三级目录
                                            unit4 : pageMeta.Unit4, // 课本四级目录
                                            beikeType: isBeikeRes ? "beike" : ""
                                        };

                                        //socket
                                        var data = {
                                            "config" : {
                                                "type":"logic",
                                                "action":"ta_upload",
                                                "id":0,
                                                "from":"ib",
                                                "to":"ta_dum"
                                            },
                                            "data":{
                                                "id": timestamp,
                                                "multi":1,
                                                "key": "file", //用于socket判断逻辑处理流程
                                                // "url": "http://192.168.63.60:50201/v2/files/0/upload",
                                                "url": uploadChunks[0].host,
                                                "appKey": uploadChunks[0].params.appKey,
                                                "contextId": uploadChunks[0].params.contextId,
                                                "expires": uploadChunks[0].params.expires,
                                                "token": uploadChunks[0].params.token,
                                                "file": srcPath,
                                                "source": "beike_upload",
                                                "evt": "prepare_upload", //用户回调函数判断事件类型
                                                "extra": {
                                                    appKey: uploadChunks[0].params.appKey,
                                                    contextId: uploadChunks[0].params.contextId,
                                                    expires: uploadChunks[0].params.expires,
                                                    token: uploadChunks[0].params.token
                                                },
                                                "raw_data": {
                                                    "index" : index,
                                                    // "url": "http://192.168.6363.60:50201/v2/files/0/upload",
                                                    "url": uploadChunks[0].host,
                                                    "appKey": uploadChunks[0].params.appKey,
                                                    "contextId": uploadChunks[0].params.contextId,
                                                    "expires": uploadChunks[0].params.expires,
                                                    "token": uploadChunks[0].params.token,
                                                    "edc_file_upload_complete_request": edc_file_upload_complete_request,
                                                    "edc_file_add_request": edc_file_add_request
                                                }
                                            }
                                        };
                                        var obj = {
                                            "type":data.config.type,
                                            "action":data.config.action,
                                            "from":data.config.from,
                                            "to":data.config.to,
                                            "id":data.config.id,
                                            "data":data.data
                                        };
                                        socket.send(obj);
                                    }
                                })
                            }
                        });
                    });
                })(i);
            }
            $(document).dequeue("beikeQueueUpload");
            // getAccessToken(true , function(err , token){
            //     if (!err){
            //         if(!share){
            //             pageMyPrepare.beikeTipOnly('process','温馨提示','正在上传，请稍候');
            //         }
            //         for (var i = 0 ; i < srcPathCollect.length  ; ++i){
            //             var filePath = srcPathCollect[i].filepath;
            //             var srcPath = APP_CONFIG.PPTICWS_PATH + uid + '/'+ srcPathCollect[i].timestamp + '/' + srcPathCollect[i].filepath;
            //             var fileName = getFileNameFromPath(filePath);
            //             var timestamp = srcPathCollect[i].timestamp;
            //             var index =i;/* srcPathCollect[i].index*/
            //             fileName = encodeURIComponent(fileName);
            //             var uploadURL;
            //              uploadURL = APP_CONFIG.UPLOADTOBEIKE + '&uid=' + uid + '&fileName=' +fileName  + '&bookCode=' + pageMyPrepare.books[pageMyPrepare.curBookIndex].bookCode +
            //                 '&unitCode=' + pageMyPrepare.curBookMetaInfo.Unit1 + '&courseCode=' + pageMyPrepare.curBookMetaInfo.Unit2 + '&aliasName=' +fileName + '&access_token=' +  (token||"")+"&isCover=false";
            //           console.log(uploadURL);
            //             var uploadParam = {
            //                 id : timestamp,
            //                 url : uploadURL,
            //                 file : srcPath,
            //                 index:index
            //             };
            //             uploadByWS(JSON.stringify(uploadParam) , share?'beike_share' : 'beike_upload'); // 启动上传
            //         }
            //     }
            // });
            function uploadByWS(data , source){
                var rawData = JSON.parse(data);
                if (!rawData.key) rawData.key = 'multiFile';
                var upload_params = {
                    id:rawData.id,
                    url:rawData.url,
                    file:rawData.file,
                    key: rawData.key,
                    raw_data:data ,
                    source : source,
                    index:rawData.index
                }
                socket.send({"type":"logic","action":"ta_upload","from":"ib","to":"ta_dum","data":upload_params});
            }
        };

    //分享

    this.share = function(){
        _self.upload(true);
    };
    /**
     * 本地资源分享到资源中心（上传过程）
     */
    this.sharelocaltoSoureCenter = function(share){
        //var srcPathCollect= myprebook.localDbInfo.filter(function(el){return el.checked == true;})//暂时只能单一文件上传，需要批量上传需修改，暂时保留注释
        //uploadTotal =srcPathCollect.length;
        //curUploadCnt =0;
        var file=myprebook.localDbInfo.filter(function(el){return el.checked==true})[0]; //选中的文件信息
        TA_Token_Manager.getInterface(function(uploadURL){
            var fileName = file.name;
            var srcPath = APP_CONFIG.PPTICWS_PATH + uid + '/'+ file.timestamp + '/' + file.filepath;
            var timestamp = file.timestamp;
            var bookCode=file.bookcode;
            var extension=myprebook.extensionView;    //获得文件类型，将文件类型显示到页面
            var typeCode="";
            if(extension=="word"){
                typeCode="0100";  //教学设计
            }else if(extension=="ppt"){
                typeCode="0600";//同步课件
            }else{
                typeCode="0300"//素材
            }
            var curBookMetaInfo = pageMyPrepare.books.filter(function(el){ //根据bookcode选择到当前选中的书本,返回值是个数组
                        return el.bookCode == bookCode ;
                    });
            var fileindex={
                    edition:[],
                    volumn:[curBookMetaInfo[0].volumn],
                    rrtlevel1:["08"],//必填
                    subject:[curBookMetaInfo[0].subject],
                    unit1:[file.unit1!=""?file.unit1:null],
                    unit2:[file.unit2!=""?file.unit2:null],
                    type:[typeCode],
                    stage:[],
                    publisher:[curBookMetaInfo[0].publisher],
                    course:[],
                    unit:[],
                    book:[curBookMetaInfo[0].bookCode],
                    grade:[curBookMetaInfo[0].grade],
                    phase:[],
                    quality:["20"]
                    };
            //uploadURL += "method=res.resource.add&version=1.0&format=json&auditstatus="+"OK"+'&title='+encodeURIComponent(fileName)+"&fileindex="+JSON.stringify(fileindexs);
            uploadURL += "method=res.resource.add&version=1.0&format=json&auditstatus=PENDING&title="+fileName+"&source=UGC&creator="+pageMyPrepare.userInfo.loginName
                +"&uploader="+pageMyPrepare.userInfo.loginName+"&fileindex="+JSON.stringify(fileindex);
            var json = {
                type : "logic",
                action : "ta_upload",
                from : "ta",
                to : "ta_dum",
                data : {
                    id :timestamp,
                    url : encodeURI(uploadURL),
                    key : "multiFile",
                    file : srcPath,
                    source:"sharetoSourceCenter_upload"
                }
            };
            socket&&socket.send(json);
        });
    };

    /**
     * 导出课件
     * @param desPath
     */
    this.export = function(desPath){
        var alertDialog =  new Alert_In_Ex_port(2000,1500,"export");
/*        myprebook.localDbInfo.forEach(function(el){
            el.from=="local"?el.checked = true:el.checked=false;
        });*/
        var srcPathCollect = myprebook.localDbInfo.filter(function(el){
            return el.checked == true && el.from=="local";
        });
        /**
         * 递归导出
         * @param _index 导出课件在课件集合中的下标
         * @param callback 导出完毕后的回调函数
         */
        function export_iter(_index , callback) {
            if (_index >= srcPathCollect.length){
                callback();
                return ;
            }
            var srcPath = APP_CONFIG.PPTICWS_PATH + uid + '/'+ srcPathCollect[_index].timestamp + '/' + srcPathCollect[_index].filepath;
            /*console.log(srcPath);*/
            var src =  srcPathCollect[_index].filepath;
            var fileName = src.substr(src.lastIndexOf('/')+1);
            var title = fileName.substr(0,fileName.lastIndexOf('.'));
            var extra = fileName.substr(fileName.lastIndexOf('.'));
            getName(title,extra,fileName,desPath,function(reTitle){
                var copyPath = desPath.replace(/\\/,'/') + '/'+reTitle;
                shellcmd.copyDir(srcPath , copyPath).done(function(){
                    export_iter(_index + 1 , callback);
                })
            });
        }

        function getName(title,extra,fileName,path,callback){
            var fs = require('fs');
            var files = fs.readdirSync(path);
            for(var k=0;k<files.length;k++){
                var pointer = files[k].lastIndexOf('.');
                if(pointer!=-1){
                   var extraFilter = files[k].substr(pointer+1).toLowerCase();
                    if(extraFilter == 'ppt'||extraFilter == 'pptx'){
                        files[k] = files[k].substr(0,pointer+1)+extraFilter;
                    }
                }
            }
                if(!existFile(files,fileName)){
                    callback&&callback(fileName);
                }else{
                    var i = 2;
                    for(;existFile(files,title+'('+i+')'+extra);i++){

                    }
                    callback&&callback(title+'('+i+')'+extra);
                }

        }

        function existFile(files,name){
            return  (JSON.stringify(files).indexOf(name)!=-1);
        }

        alertDialog.alertDoing(function(){
            //设置居中
            pageMyPrepare.setBeikeCenterPosition($('#im_ex_port'));
        });
        export_iter(0 , function(){
            $('#selectAll_local').removeAttr('checked');
            alertDialog.alertDone(function(){
                //设置居中
                pageMyPrepare.setBeikeCenterPosition($('#im_ex_port_done'));
                LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'18',ta_app:'beike'},null);
            });
        });

    };

    /**
     * 改变目录
     * @param moveDir
     * @param callback
     */
   this.changeMenu = function(moveDir , callback){
       var bookcodeArr = [];
       var unit1 = moveDir&&moveDir.Unit1;
       var unit2 = moveDir&&moveDir.Unit2;
       var unit3 = moveDir&&moveDir.Unit3;
       var unit4 = moveDir&&moveDir.Unit4;
       var bookcode = pageMyPrepare.books&&pageMyPrepare.books[pageMyPrepare.curBookIndex].bookCode;
       if (unit1==undefined){
           alert("please choose the menu!!!");
           return ;
       }
       bookcodeArr = getSelectedItemInfo();
       update_iter(0 , function(){
               // callback();
              _self.refresh();
           LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'15',ta_app:'beike'},null);

       });

       function update_iter(_index , callback){
           if (_index >= bookcodeArr.length){
               callback();
               return ;
           }
           changeWithSQL(bookcodeArr[_index].timestamp).done(function(){
               update_iter(_index + 1 , callback);
           })
       }

       function changeWithSQL(timestamp){
           var def = $.Deferred();
           var OpItem = null;
            for (var i = 0 ; i < dbaccessor.allInfo.length ; ++i){
                if (dbaccessor.allInfo[i].timestamp == timestamp ){
                    OpItem = dbaccessor.allInfo[i];
                    OpItem.unit1 = unit1;
                    OpItem.unit2 = unit2;
                    OpItem.unit3 = unit3;
                    OpItem.unit4 = unit4;
                    break;
                }
            }
           dbaccessor.deleteInfo(timestamp).done(function(){
               dbaccessor.addInfo(OpItem).done(function(){
                    def.resolve();
               })

           })
           return def.promise();
       }
   };

    // 导入
    this.import = function (srcfile){
        var alertDialog =  new Alert_In_Ex_port(2000,1500,"import");
        var fileCollect = [];
        fileCollect = srcfile.split(';');
        var collectLen = fileCollect.length;

        function import_once (filePath , index) {
            var def = $.Deferred();
            var timestamp = new Date().Format("yyyyMMddhhmmssS") + '_' + index;
            var uuid=getUuid();
            var fileName = filePath.split('\\');
            fileName = fileName[fileName.length -1 ];
            var ext = fileName.split('.');
            fileName = ext[0];
            ext = ext[ext.length - 1];
            ext = ext.toLowerCase();
            fileName = fileName + '.'+ext;
            var size=fs.statSync(filePath).size;
            var desPath = APP_CONFIG.PPTICWS_PATH + uid + '/'+ timestamp;
            var item = {
                "filename" : fileName,
                "unit1" : pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit1,
                "unit2" : pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit2,
                "unit3" : pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit3,
                "unit4" : pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit4,
                "timestamp" : timestamp ,
                "fileid" : uuid ,
                "type" : ext,
                "bookcode" : pageMyPrepare.books[pageMyPrepare.curBookIndex].bookCode,
                "filepath" : fileName,
                "lasttime" : new Date().Format("yyyy-MM-dd hh:mm:ss"),
                "creator":pageMyPrepare.userInfo.userName,
                "size":size,
            };
         //   new waiting('导入中...').shadeMain();
            //TODO::添加文件到备课本
            shellcmd.DOS_makeDir(desPath).done(function(){
                var fileNameNoExt = item.filename.substr(0,item.filename.lastIndexOf('.'));
                item.filename= renameAuto(fileNameNoExt,item.type);
                item.filepath = item.filename + '.' + ext;
                var desPath_kejian = desPath + '/' + item.filepath;
                var fromPic = null;
                if(ext=='icw'){
                  fromPic = APP_CONFIG.PPTICWS_PATH+'mr_icw.png'
                }else if(ext == 'ppt' || ext == 'pptx'){
                  fromPic = APP_CONFIG.PPTICWS_PATH+'mr_ppt.png'
                }else{
                    fromPic = APP_CONFIG.PPTICWS_PATH+'mr_ppt.png'
                }
                shellcmd.copyDir(fromPic , desPath + '/thumbnail.jpg');
                shellcmd.copyDir(filePath , desPath_kejian).done(function(){
                    dbaccessor.addInfo(item).done(function(){
                        def.resolve();
                    });

                });

            });
            return def.promise();
        };
        function getUuid(){
            var s = [];
            var hexDigits = "0123456789abcdef";
            for (var i = 0; i < 36; i++) {
                s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
            }
            s[14] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
            s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01
            s[8] = s[13] = s[18] = s[23] = "";
            var uuid = s.join("");
            return uuid;
        };
        function import_refresh() {
            alertDialog.alertDone(function(){
                //设置居中
                cloudRes.init_myprebook();
                pageMyPrepare.setBeikeCenterPosition($('#im_ex_port_done'));
            });
            _self.refresh("Add");
        }


        function import_iter (_index , callback) {
            if (_index >= collectLen) {
                callback();
                return ;
            }
            import_once(fileCollect[_index] , _index).done(function(){
                import_iter(_index +1 , callback);
            });

        }
        alertDialog.alertDoing(function(){
            //设置居中
            pageMyPrepare.setBeikeCenterPosition($('#im_ex_port'));
            LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'19',ta_app:'beike'},null);
        });
        import_iter(0 , import_refresh);
    };
    //TODO删除判断
    // 删除
    this.delele = function(){
        pageMyPrepare.beikeTipOnly('process','温馨提示','正在删除，请稍候');
        var basePath = APP_CONFIG.PPTICWS_PATH + uid;
        // var $item = common_operate('find' , [[$('#myprebook-list') , 'tr']]);
        var filterResult={};
        var timestampArr = [];
        var cloud_checked_res=[];
        var local_checked_res=[];
        var local_cloud_res = myprebook.localDbInfo.filter(function(el){
            return el.checked == true;
        });
        local_cloud_res.forEach(function(el){
            if(el.from=="cloud" ){
                cloud_checked_res.push(el.fid);
            }
        });
        local_cloud_res.forEach(function(el){
            if(el.from=="cloud" && el.hasdownLoad ){
                local_checked_res.push(el.fid);
            }else if(el.from=="local"){
                local_checked_res.push(el.fid);
            }
        });
        if(cloud_checked_res.length>0){
            delete_cloud();
        }
        //删除备课本云端资源
        function delete_cloud(){
                var parameters ={
                    uid:pageMyPrepare.userInfo.id,
                    fileIds:cloud_checked_res.join(","),
                };
                var ajax_pan_file_delete = pagePrepareService.getInstance().pan_files_delete(parameters);
                ajax_pan_file_delete.done(function(result){
                    console.log(result);
                    setTimeout(function(){
                        cloudRes.init_myprebook();
                    },100*cloud_checked_res.length);
                }).fail(function(err){
                    console.log(err);
                });
        };
        //删除备课本本地资源
        local_cloud_res.forEach(function(el){
            timestampArr.push(el.timestamp);
        });
        filterResult.length = local_cloud_res.length;
        function delete_iter (_index , callback){
            if(_index >= filterResult.length){
                callback();
                return ;
            } else {
                dbaccessor.deleteInfo(timestampArr[_index]).done(function(){
                    delete_iter(_index + 1 , callback);
                });
            }
        }

        delete_iter(0 , function(){
            dele_physic(timestampArr);
            if (_self.allPage <= _self.cur_page){
                _self.cur_page = _self.allPage;
            }
            _self.refresh();
            LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'20',ta_app:'beike'},null);
        });

        function Re_delete(_index) {
            var def = $.Deferred();
            if(_index >= filterResult.length){
                def.resovle();
                return def.promise();
            }
            dbaccessor.deleteInfo(timestampArr[_index]).done(function(){
                Re_delete(_index+1).done(function(){
                    def.resolve();
                    return def.promise();
                });
            });
            return def.promise();
        }

        function dele_physic(fileArr){
            for (var i =0 ; i< fileArr.length ; ++i){
                shellcmd._rmdirASync(basePath + '/' + fileArr[i],function(path){
                    //刷新视图
                    myprebook.selectAll=false;
                    $('#beikeTipOnly').hide();
                    $("#mask_layer").hide(); 
                    cloudRes.init_myprebook();
                 /*   var new_local_res = myprebook.localDbInfo.filter(function(el){
                        return el.checked == false;
                    });
                    myprebook.localDbInfo = new_local_res;*/
                },function(e){
                    switch (e.code) {
                        //删除文件夹失败
                        case "ENOTEMPTY":
                            //刷新视图
                            myprebook.selectAll=false;
                            $('#beikeTipOnly').hide();
                            $("#mask_layer").hide();
                            cloudRes.init_myprebook();
                            break;
                        //删除文件失败
                        case "EBUSY":
                            //刷新视图
                            myprebook.selectAll=false;
                            $('#beikeTipOnly').hide();
                            $("#mask_layer").hide();
                            cloudRes.init_myprebook();
                            return;
                            break;
                        default:
                            //异常情况，保证页面允许继续操作
                            $('#beikeTipOnly').hide();
                            $("#mask_layer").hide();
                            return;
                            break;
                    }
                });
            }
        }
    };



    // 新建
    this.newRes = function(coursewareData){
        // todo ： 弹出界面 ， 打开ppt或icw ， 关闭后保存
        var def = $.Deferred();
        var timestamp = new Date().Format("yyyyMMddhhmmssS");
        var fileName = coursewareData.fileName;
        var ext = coursewareData.extName;

        var desPath = APP_CONFIG.PPTICWS_PATH + uid + '/'+ timestamp;
        var item = {
            "filename" : fileName,
            "unit1" : coursewareData.unit1,
            "unit2" : coursewareData.unit2,
            "unit3" : coursewareData.unit3,
            "unit4" : coursewareData.unit4,
            "timestamp" : timestamp ,
            "fileid" : "" ,
            "type" : ext ,
            "bookcode" : coursewareData.bookCode,
            "filepath" : fileName + '.' + ext,
            "lasttime" : new Date().Format("yyyy-MM-dd hh:mm:ss"),
            "creator"  : pageMyPrepare.userInfo.userName
        };
        // icw 课件未处理
        var templatePath ;
        var fromPic = null;
        var desPath_kejian = null;
        var desPath_pic = null;
        if (ext == 'icw'){
            templatePath = APP_CONFIG.PPTICWS_PATH + 'template.icw';
            fromPic = APP_CONFIG.PPTICWS_PATH + 'mr_icw.png';
        }else{
            templatePath = APP_CONFIG.PPTICWS_PATH + 'template.ppt';
            fromPic = APP_CONFIG.PPTICWS_PATH + 'mr_ppt.png';
        }
       // new waiting('创建中...').shadeMain();
        shellcmd.DOS_makeDir(desPath).done(function(){
            item.filename= renameAuto(item.filename);
            item.filepath = item.filename + '.' +ext;
            desPath_kejian=  desPath + '/' + item.filepath;
            desPath_pic = desPath+'/thumbnail.jpg';
            shellcmd.copyDir(fromPic , desPath_pic);
            shellcmd.copyDir(templatePath , desPath_kejian).done(function(){
                shellcmd.copyDir(fromPic , desPath_pic).done(function(){
                    if(ext == 'icw'){
                        var newExtraData={
                            item:item,
                            path:desPath,
                            uid:pageMyPrepare.userInfo.id
                        };
                        shellcmd.playOrEditICW(desPath_kejian, 'new',coursewareData,newExtraData, function(){
                            cloudRes.init_myprebook();
                        });
                        //TODO：交互式课件刷新
                    }else{
                        dbaccessor.addInfo(item).done(function(){
                              shellcmd.playOrEditPPT(desPath_kejian );
                              LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'16',ta_app:'beike'},null);
                              _self.refresh("Add");
                              def.resolve();
                        });
                    }

                    ///////////////////////
//                    dbaccessor.addInfo(item).done(function(){
//                        if (ext == 'icw') {
//                            shellcmd.playOrEditICW(desPath_kejian, 'new',coursewareData);
//                            LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'17',ta_app:'beike'},null);
//                        } else {
//                            shellcmd.playOrEditPPT(desPath_kejian );
//                            LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'16',ta_app:'beike'},null);
//                        }
//                        // new waiting('创建中...').showMain();
//                        _self.refresh("Add");
//                        def.resolve();
//                    });
                    //////////////
                });

            });
        });

        return def.promise();

    };


    this.anyPage = function(pageIndex){
        var forceToNewCourseFlag = true;
        UI_operate([common_operate('find' , [[$('#pre-inforlist2') , 'li']])] , ['remove' ]);
        $('#no_course_local').hide();
        $('#selectAll_local').removeClass('selected');
        if(pageMyPrepare.forceToNewCourse){
            pageMyPrepare.forceToNewCourse = null;
            forceToNewCourseFlag = false;
            $('#preicon-xj').trigger('click');
        }
        if (dataModel.length == 0){
            $('#no_course_local').show();
            if(forceToNewCourseFlag) newCheckFreshGuider("third",$("#newCourseware").offset());
            return ;
        }

        if (pageIndex <=0 || pageIndex > _self.allPage){
            return;
        }
        $('#selectAll').removeAttr('checked');
        UI_operate([common_operate('find' , [[$('#pre-inforlist2') , 'li']])] , ['remove']);

        var userBaseDir = APP_CONFIG.PPTICWS_PATH + uid + '/';
        var beginItemIndex = (pageIndex-1)*pageMyPrepare.localCoursewareCfg.itemShowNumber +1 ;
        var maxItem = (beginItemIndex + pageMyPrepare.localCoursewareCfg.itemShowNumber -1) > (dataModel.length)   ? dataModel.length : beginItemIndex + pageMyPrepare.localCoursewareCfg.itemShowNumber -1;
        for(var i = beginItemIndex ; i <= maxItem  ; ++i){
            //TODO ： 渲染界面 addapend DomTemplate_item;
            // var tmp = $(DomTemplate_item.replace('{{_index}}' , i));
            var thumbnailPath = userBaseDir + dataModel[i-1].timestamp + '/thumbnail.jpg';
            tmp = DomTemplate_item.replace('{{_index}}' , i)
                .replace('{{title}}' , dataModel[i-1].filename)
                .replace('{{tips_title}}' , dataModel[i-1].filename)
                .replace('{{tip_title}}' , dataModel[i-1].filename)
                .replace('{{thumbnail}}' , thumbnailPath);
            //$("#pre-inforlist2").append(tmp);
            UI_operate('#pre-inforlist2' , 'append' , tmp);
        }
        _self.cur_page = pageIndex;
    };

    this.nextPage  = function() {
        _self.anyPage(++_self.cur_page);
    };

    this.prePage = function() {
        _self.anyPage(--_self.cur_page);
    };

    this.refreshCurPage = function(itemShowNumber){
        var last_config_itemshow = pageMyPrepare.localCoursewareCfg.itemShowNumber;
        var beginItem = (_self.cur_page -1) * last_config_itemshow + 1;
        pageMyPrepare.localCoursewareCfg.itemShowNumber = itemShowNumber;
        var pageNumber_afterChange = Math.ceil(beginItem / pageMyPrepare.localCoursewareCfg.itemShowNumber);
        _self.cur_page = pageNumber_afterChange;
        _self.allPage = Math.ceil(dataModel.length / pageMyPrepare.localCoursewareCfg.itemShowNumber);
        pageMyPrepare.indexInit(_self.cur_page ,_self.allPage ,'courseware_local' , _self.prePage ,_self.nextPage ,_self.anyPage);
        _self.anyPage(_self.cur_page);
    };

    this.cloudBeike = function(){

        var filterBeike = {
            "bookcode": pageMyPrepare.books[pageMyPrepare.curBookIndex].bookCode ,
            "unit1" : pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit1,
            "unit2" : pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit2,
            "unit3" : pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit3,
            "unit4" : pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit4

        };
        var cloudInstance = new BeiKeCloud(uid);
        if(!APPManager.onlineFlag) {
            $('#beike_yun_pop').find('.pop-beike').html('<div class="no-pre-inforlist"><img src="assets/images/outline_ico.png"  /><p>请联网后获取更多云端资源</p></div>');
            return;
        }
        cloudInstance.getAllBeiKe().done(function(){
            cloudInstance.getFileList(filterBeike).done(function(){
                //cloudInstance.getFileUrl();
                cloudInstance.getMore_iter(cloudInstance.map_pointer , cloudInstance.render);
            });
        });

    }

}

function renameAuto (fileName,type) {
    var allInfo = pageMyPrepare.dbaccessor.allInfo;
    var sameTypeInfo=[];
    if(type){
        for(var i=0;i<allInfo.length;i++){
            if(allInfo[i].type==type){
                sameTypeInfo.push(allInfo[i]);
            };
        };
    };
    //var sameTimes = 0;
    for (var i = 0 ;i < sameTypeInfo.length ; ++i){
        if (fileName == sameTypeInfo[i].filename){
            var rgExp = /\(\d+\)$/g;
            var matchStr = fileName.match(rgExp);
            if (matchStr){
                var matchNumber = matchStr[0].match(/\d+/);
                var curNumberExt = ++matchNumber;
                fileName = fileName.replace(rgExp , '('+curNumberExt+')');
            } else {
                fileName += '(2)';
            }
            //fileName = fileName + '(' + (curNumberExt).toString() + ')';
        }
    }
    return fileName;
}

/**
 * TODO EDC
 * 上传回调
 * @param _data
 */
function beike_file_upload(_data){
    var curDataModel = pageMyPrepare.localClass.getDataModel();
    for(var i = 0 ; i < curDataModel.length ; ++i){
        if (_data.id == curDataModel[i].timestamp ){
             if ("beike_upload" == _data.source ){
                if(_data.process == -1){
                    curUploadCnt--;
                    uploadFail++;
                    uploadFailIndex.push(_data.id);
                    curUploadCnt ? $(document).dequeue("beikeQueueUpload") : null;
                    if (curUploadCnt == 0 ){
                        beike_file_upload_result();
                    }
                }else if(_data.process == 100 && 'beike_upload' == _data.source ){
                    edcService.Instance().pan_file_upload_complete(_data.raw_data.edc_file_upload_complete_request).done(function(ret){
                        if(ret.code==0){
                            edcService.Instance().beike_file_add(_data.raw_data.edc_file_add_request).done(function(ret){
                                if(ret.code==0){
                                    curUploadCnt--;
                                    curUploadCnt ? $(document).dequeue("beikeQueueUpload") : null;
                                    if (curUploadCnt == 0 ){
                                        beike_file_upload_result();
                                    }
                                }
                                else{
                                    curUploadCnt--;
                                    curUploadCnt ? $(document).dequeue("beikeQueueUpload") : null;
                                    uploadFail++;
                                    uploadFailIndex.push(_data.id);
                                    if (curUploadCnt == 0 ){
                                        beike_file_upload_result();
                                    }
                                }
                            }).fail(function(){
                                curUploadCnt--;
                                curUploadCnt ? $(document).dequeue("beikeQueueUpload") : null;
                                uploadFail++;
                                uploadFailIndex.push(_data.id);
                                if (curUploadCnt == 0 ){
                                    beike_file_upload_result();
                                }
                            })
                        }
                        else{
                            curUploadCnt--;
                            curUploadCnt ? $(document).dequeue("beikeQueueUpload") : null;
                            uploadFail++;
                            uploadFailIndex.push(_data.id);
                            if (curUploadCnt == 0 ){
                                beike_file_upload_result();
                            }
                        }
                    }).fail(function(err){
                        curUploadCnt--;
                        curUploadCnt ? $(document).dequeue("beikeQueueUpload") : null;
                        uploadFail++;
                        uploadFailIndex.push(_data.id);
                        if (curUploadCnt == 0 ){
                            beike_file_upload_result();
                        }
                    })
                }
             }
        }
    }
}

function beike_file_upload_result(){
    var tipFun =  pageMyPrepare.beikeTipOnly;
    var successCount = uploadTotal - uploadFail;
    var tipContent = '已上传'+successCount+'个课件';
    if(uploadFail>0 && successCount>0){
        tipContent = tipContent +',上传失败'+uploadFail+'个课件';
        tipFun('success','温馨提示',tipContent);
        LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'14',ta_app:'beike'},null);
    }else if(successCount<1){
        tipFun('fail','温馨提示','上传失败');
    }else{
        tipFun('success','温馨提示',tipContent);
        LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'14',ta_app:'beike'},null);
    }
    myprebook.localDbInfo.forEach(function(el){
        el.checked = false;
    })
    myprebook.selectAll=false;
    uploadTotal = 0;
    uploadFail = 0;
/*
    setUploadFail();
    $('#selectAll_local').removeAttr('checked');*/
}

function setUploadFail(){
    if(!uploadFailIndex.length) return;
    var $item = common_operate('find' , ['#pre-inforlist2' , 'li']);
    for(var i=0;i<$item.length;i++){
        if(uploadFailIndex.indexOf(parseInt($($item[i]).attr('index')))!=-1){
            $($item[i]).find('.pre-checkbox input').attr('checked', 'checked').prop("checked", true);
            UI_operate(common_operate('find' , [[($item[i]) , '.pre-checkbox']]) ,'show' );
            $($item[i]).find('.add-pre-inforing').addClass('uploadFailPrepare');
        }
    }
    uploadFailIndex = [];
}
