/**
 * Created by JJ on 15-6-23.
 */

/**
 * 云备课本类
 * @param userId 用户uid
 * @constructor
 */
function BeiKeCloud (userId){
    var CONFIG_BEIKECLOUD ={
        "showItemNumber" : 18
    };
    var uid = userId;
    var that = this;
    var map_bookbeike = []; // 某一用户的所有备课本ID集合
    var map_fileid = [];  // 某一备课本下所有文件ID及部分信息集合
    that.map_pointer  = 0; // 分批加载而引入的集合指针
    var srcollBottomTimes = 0; // 用户通过鼠标滚轮而触发加载所需的滚动次数
    var isLoadingFlag = 0;  // 是否正在加载标志
    bindEvt();

    function download_fileInfo_get($curDom){
        var $liDom = common_operate('getItemLi' , [[$curDom,'li']]);
        return [ $liDom , common_operate('getAttribute' , [[$liDom , 'fid']])];
    }
    function download_UI_change($liDom){
        UI_operate([ $liDom.find('#beike_yun_download') ,  $liDom.find('#beike_yun_ReDownload') , $liDom.find('#beike_yun_progress')] , ['hide' , 'hide' , 'show']);
    }
    function hoverItem($Dom , showOrHide){
        $Dom = common_operate('getItemLi' , [[$Dom , '#yunItem']]);
        var isNoDowning = common_operate('isHidden' , [[$Dom , '#beike_yun_progress']]);
        if (isNoDowning == true){
            UI_operate($Dom.find('.bekke-infor'), showOrHide);
        }
    }

    function beike_close_click(){
        UI_operate([$('#beike_yun_pop')] , ['remove','remove']);
        $("#mask_layer").hide();
    }

    function beikeFile_download_click(){
        /**
         * 增加联网检测
         */
        if(!APPManager.onlineFlag){
            dNetworkPanel.show();
            return;
        }
        var fileInfo = download_fileInfo_get($(event.target));
        download_UI_change(fileInfo[0]);
        that.downloadFile(fileInfo[1]);
    }

    function mouseWheel_load_click (){
        if ($(this)[0].scrollTop + $(this).height() >= $(this)[0].scrollHeight){
            srcollBottomTimes++;
            if (srcollBottomTimes >= 10) {
                srcollBottomTimes = 0;
                if (isLoadingFlag == 0){
                    isLoadingFlag = 1;
                    that.getMore_iter(that.map_pointer , that.render);
                }
            }
        } else {
            srcollBottomTimes = 0;
        }
    }

    function beike_mouse_over(){
        hoverItem($(event.target) ,'show');
    }

    function beike_mouse_out(){
        hoverItem($(event.target) , 'hide');
    }


    function unbindEvt() {
        $(document).off('click' , '#beike_yun_close');
        $(document).off('click' , '#beike_yun_download , #beike_yun_ReDownload');
        $('.pop-beike').off('scroll');
    }

    function bindEvt(){
        unbindEvt();
        $(document).on('click' , '#beike_yun_close' , beike_close_click);
        $(document).on('click' , '#beike_yun_download , #beike_yun_ReDownload' ,  beikeFile_download_click);
        $('.pop-beike').on('mousewheel' ,mouseWheel_load_click);
        $(document).off('mouseover' , '#yunItem').on('mouseover' , '#yunItem' ,beike_mouse_over);
        $(document).off('mouseout' , '#yunItem').on('mouseout' , '#yunItem' ,beike_mouse_out);
    }

    that.getAllBeiKe = function(){
        var def = $.Deferred();
        var URL_beikelist = APP_CONFIG.GETBEIKELIST + '&uid=' + uid + '&access_token=' + TA_Token_Manager.currentToken;
        HttpRequest(URL_beikelist , function(result){
            map_bookbeike = [];
            for (var i = 0 ; i < result.length ; ++ i ){
              if(!map_bookbeike[result[i].bookcode])  map_bookbeike[result[i].bookcode] = result[i].fid;
            }
            def.resolve();
        });
        return def.promise();
    };

    that.getFileList = function(filterArgs){
        var def = $.Deferred();
        var bookcode = filterArgs.bookcode,
            unit1 = filterArgs.unit1,
            unit2 = filterArgs.unit2,
            unit3 = filterArgs.unit3,
            unit4 = filterArgs.unit4;

        var beikeId = map_bookbeike[bookcode];
        //这里是木有这个备课本的时候显示的内容
        if(!beikeId){
            $('#beike_yun_pop').find('.pop-beike').html('<img src="assets/images/no_beike_cloud.png" style="padding-left: 30%;padding-top: 25%;">');
            return def.promise();
        }
        var URL_getFilelist = APP_CONFIG.GETFILELIST +  '&uid=' + uid + '&access_token=' + TA_Token_Manager.currentToken + '&beikeId=' + beikeId +
                            '&unit=' + unit1 +  '&course=' + unit2 + '&limit=999999&page=1&extension=ppt,pptx,icw&bookCode='+bookcode;

        HttpRequest(URL_getFilelist , function(result){
            //这里是木有这个备课本课件的时候显示的内容
            if(!result||result.total<1){
                    $('#beike_yun_pop').find('.pop-beike').html('<img src="assets/images/no_beike_cloud.png" style="padding-left: 30%;padding-top: 25%;">');
            }
            for (var i = 0 ; i < result.data.length ; ++i ){
                if (result.data[i].fileInfo.extension != 'ppt'&& result.data[i].fileInfo.extension != 'pptx'&& result.data[i].fileInfo.extension != 'icw' ){
                    continue;
                }
                var hasDownLoad = false;
                hasDownLoad = checkHasDownLoad(result.data[i].fileInfo.fid);
                var fileData = {
                    "fid" : result.data[i].fileInfo.fid,
                    "name" : result.data[i].fileInfo.name ,
                    "hasDownLoad" : hasDownLoad
                }
                map_fileid.push(fileData);
            }
            that.map_pointer  = 0;
            def.resolve();
        });
        return def.promise();

    };

    that.getFileUrl = function(fid){

        var def = $.Deferred();
        var URL_filedownload = APP_CONFIG.GETFILEURL + '&uid=' + uid + '&access_token='+  TA_Token_Manager.currentToken + '&fileId=' + fid;
        HttpRequest(URL_filedownload , function(result){
            var necessaryData = {
                "filename" : result.name,
                "ext" : result.extension,
                "downloadPath" : result.downloadpath,
                "fid" : result.fid,
                "thumbpath" :  result.thumbpath
            }
            def.resolve(necessaryData);
        });
        return def.promise();
    };

    that.getMore = function(){
        for (var i = that.map_pointer  ;i < map_fileid.length &&i - that.map_pointer < 9 ; ++i){
            that.getFileUrl(map_fileid[i].fid).done(function(ret){
                $.extend(map_fileid[i] , ret);
            });
        }
        that.map_pointer = i;
    };

    that.getMore_iter = function(index_cur , callback){
        if (index_cur - that.map_pointer >= CONFIG_BEIKECLOUD.showItemNumber || index_cur >= map_fileid.length){
            callback&&callback(that.map_pointer , index_cur);
            that.map_pointer = index_cur;
            isLoadingFlag = 0;
            return ;
        }

        that.getFileUrl(map_fileid[index_cur].fid).done(function(ret){
            $.extend(map_fileid[index_cur] , ret);
            that.getMore_iter(index_cur + 1 , callback);
        });

    };



    that.render = function(index_begin , index_cur){
        var template_dom =  '<li hasDownLoad = "{{hasDownLoad}}" id = "yunItem" fid = "{{fileId}}" class="fl ">' +
            '<div class="bekke-infor-block">'+
            '<img class = "beike_yun_img" width = "161px" height="120px" style="display : none" src="{{thumbnail}}" title = "{{fileName}}" />'+
//            onerror="javascript:this.src=' + "'" + 'assets/images/yun_banner.png'+" ';"+'"'+'
            '<img id = "beike_yun_img_default" width = "161px" height="120px" style="display : block" src="assets/images/yun_banner.png" />'+
            '<div class="bekke-infor" style="display: none">'+
            ' <a id = "beike_yun_download" class="download" style="cursor:pointer;display: {{downshow}}"><span>下载</span></a>'+
            ' <a id = "beike_yun_ReDownload" class="download"  style="cursor:pointer;display: {{Redownshow}}"><span>重新下载</span></a>'+
            '  <div id = "beike_yun_progress" class="jd-block clearfix" style="display:none">'+
            '   <p class="fl" style="width: 110px"><span></span></p>'+
            '   <b class="fl">0%</b>'+
            '     </div>'+
            '   </div>'+
            '     </div>'+
            '     <p id = "filename" style="text-align: center" title = "{{fileName}}" >{{fileName}}</p>'+
            '</li>';
        var $beike_yun_ul = common_operate('find' , [[$('#beike_yun_pop') , 'ul']]);
        for (var i = index_begin ; i < index_cur ; ++i){
            var tmp_dom = template_dom.replace(/{{fileName}}/g , map_fileid[i].filename)
                .replace('{{fileId}}' , map_fileid[i].fid)
                .replace('{{thumbnail}}' , map_fileid[i].thumbpath);
            if (map_fileid[i].hasDownLoad == true){
                tmp_dom = tmp_dom.replace('{{downshow}}' , "none")
                    .replace('{{Redownshow}}' , "block")
                    .replace("{{hasDownLoad}}" , "true");
            } else {
                tmp_dom = tmp_dom.replace('{{downshow}}' , "block")
                    .replace('{{Redownshow}}' , "none")
                    .replace("{{hasDownLoad}}" , "false");
            }
            $beike_yun_ul.append(tmp_dom);
            $(".beike_yun_img").load(function(){
                var $curDom = $(this);
                var $parentDom = common_operate('getItemLi' , [[$curDom , '#yunItem']]);
                UI_operate(common_operate('find' , [[$parentDom , '#beike_yun_img_default']]) , 'hide');
                UI_operate($(this) , 'show');
            });
        }
    };

    that.downloadFile = function(fid){
        that.getFileUrl(fid).done(function(ret){
            if (ret) {
                download_socket(ret, fid , false); return;
                var isDownLoad = false;
                var matchData = scanDB("fileid" , fid);
                // 当前下载文件已在数据库中存在，则删除掉原先的文件，重新下载
                if (matchData){
                    pageMyPrepare.dbaccessor.deleteInfo(matchData.timestamp).done(function(){
                        download_socket(ret, fid , true);
                    });
                } else {
                    download_socket(ret, fid , false);
                }
            }
        });
    }

    function download_socket(ret , fid , isDownLoad){
        var timePath = new Date().Format('yyyyMMddhhmmssS');
        var dirPath = APP_CONFIG.PPTICWS_PATH+uid+'/'+timePath;
        // 重命名
        ret.filename = renameAuto(ret.filename);
        var extraData = {
            "timestamp" : timePath,
            "filename" : ret.filename,
            "unit1" :  pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit1,
            "unit2" :  pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit2,
            "unit3" :  pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit3,
            "unit4" :  pageMyPrepare.curBookMetaInfo&&pageMyPrepare.curBookMetaInfo.Unit4,
            "bookcode" : pageMyPrepare.books[pageMyPrepare.curBookIndex].bookCode,
            "type" : ret.ext ,
            "uid" : uid,
            "filepath" : ret.filename+ '.' +ret.ext ,
            "fileid" : fid ,
            "lasttime" : new Date().Format("yyyy-MM-dd hh:mm:ss"),
            "isReDownLoad" : isDownLoad
        };

        var download_params = {
            "id" :  fid,
            "url" :  ret.downloadPath,
            "file" : dirPath+'/'+ret.filename+ '.' +ret.ext  ,
            "source" : "local_courseware",
            "extraData" : extraData,
            "extra_download" : []
        };
        // 附带下载缩略图
        download_params.extra_download.push({'url': ret.thumbpath, 'file': dirPath + '/' + 'thumbnail.jpg'});

        var fs = require('fs');
        // 启动下载前，先建立文件所属的文件夹
        fs.exists(dirPath, function (exist) {
            if (!exist) {
                fs.mkdir(dirPath, function () {
                    socket&&socket.send({type:"logic",action:'ta_download',to:'ta_dum',data:download_params});
                });
            } else {
                socket&&socket.send({type:"logic",action:'ta_download',to:'ta_dum',data:download_params});
            }
        });
    }

    /**
     *  检测是否已经下载过了
     * @param resId
     * @returns {boolean}
     */
    function checkHasDownLoad(resId){
            if (JSON.stringify(pageMyPrepare.dbaccessor.allInfo).indexOf(resId)!=-1){
                return true;
            }else{
                return false;
            }
    }

    /**
     * 检测是否已经下载，若已下载则返回该已下载文件的相关信息
     * @param key  检测字段
     * @param value 检测值
     * @param callback 检测到之后只执行的回调函数
     * @returns {*}
     */
    function scanDB(key , value , callback) {
        var dbData = pageMyPrepare.dbaccessor.allInfo;
        for (var i = 0 ; i < dbData.length ; ++i){
            if (dbData[i][key] == value){
                return dbData[i];
            }
        }
        return null;
    }

}


/**
 * 备课本下载回调
 * @param _data
 * @constructor
 */
var  BeiKeDownLoadRecData  = function(_data){
    if(_data.extraData.uid == pageMyPrepare.userInfo.id){
        $("li[fid="+_data.id+"]").find(".jd-block p span").css("width" , _data.process + '%').css('height','8px');
        $("li[fid="+_data.id+"]").find("#beike_yun_progress b").html(_data.process.toFixed(0) + '%');
    }

    if (_data.process == 100){
            pageMyPrepare.dbaccessor.addInfo(_data.extraData).done(function(){
                if(_data.extraData.uid == pageMyPrepare.userInfo.id){
                    pageMyPrepare.localClass.refresh("Add");
                    setTimeout(function(){
                        changeUI();
                    },1000);
                    LogManager.statistics('trigger',{user_id:pageMyPrepare.userInfo.id,module:'22',ta_app:'beike'},null);
                }

            });
    }else if(_data.process == -1 && _data.extraData.uid == pageMyPrepare.userInfo.id){
            pageMyPrepare.showCommonTip('下载失败，请重试.',false);
            changeUI_fail();
    }

    function changeUI (){
        // 改变DOM的下载标志
        var $Dom_list = common_operate("find" , [[$("li[fid="+_data.id+"]") , ".bekke-infor"],[ $("li[fid="+_data.id+"]") ,"#beike_yun_progress"],[$("li[fid="+_data.id+"]"),"#beike_yun_ReDownload"]]);
        UI_operate($Dom_list , ['hide' , 'hide' , 'show']);
        common_operate('setAttribute' ,  [$("li[fid="+_data.id+"]") , 'hasDownLoad' , 'true']);

    }

    function changeUI_fail(){
        var $Dom_list = common_operate("find" , [[$("li[fid="+_data.id+"]") , ".bekke-infor"],[ $("li[fid="+_data.id+"]") ,"#beike_yun_progress"],[$("li[fid="+_data.id+"]"),"#beike_yun_download"]]);
        UI_operate($Dom_list , ['hide' , 'hide' , 'show']);
    }
};