var path = require("path");
var _basePath = path.dirname(process.execPath);
var aucPath = path.join(_basePath, "upgrade/auc.ini");

var parseINIString = function (data) {
    var regex = {
        section: /^\s*\[\s*([^\]]*)\s*\]\s*$/,
        param: /^\s*([\w\.\-\_]+)\s*=\s*(.*?)\s*$/,
        comment: /^\s*;.*$/
    };
    var value = {};
    var lines = data.split(/\r\n|\r|\n/);
    var section = null;
    lines.forEach(function (line) {
        if (regex.comment.test(line)) {
            return;
        } else if (regex.param.test(line)) {
            var match = line.match(regex.param);
            if (section) {
                value[section][match[1]] = match[2];
            } else {
                value[match[1]] = match[2];
            }
        } else if (regex.section.test(line)) {
            var match = line.match(regex.section);
            value[match[1]] = {};
            section = match[1];
        } else if (line.length == 0 && section) {
            // section = null;
        };
    });
    return value;
}

var pageIFlyBook = new NC.Page({
    name: 'iflybook',
    refreshAlways: false,
    btn: null,
    init: function (opt) {
        var that = this;
        shellcmd.log('启动::pageIflybook');
        //Login.init();
        var NewLine = '\n';
        var region = APP_CONFIG.REGION ? APP_CONFIG.REGION : ""; //区域信息 zqwei 2016-5-11 17:39:46
        var temp = '';
        /*            temp += '<div class="pop_text_infor clearfix">';
                    temp += '            <div class="fl ">';
                    temp += '                <img src="assets/images/infor_logo.png" />';
                    temp += '';
                    temp += '            </div>';
                    temp += '            <div class="fl text_infor_right">';
                    temp += '                <h3>畅言教学通'+region+'<span id="teacherAssistantVersionShow">正在获取版本...</span></h3>';
                    temp += '                <p>全国首家专业教师的一站式教学工具</p>';
                    temp += '                <div id="setUpdate_ok_parent" class="button_infor">';
                    temp += '                    <a class="blue_button" href="javascript:;" id="setUpdate_ok"><span>检测更新</span></a>';
                    temp += '                </div>';
                    temp += '            </div>';
                    temp += '        </div>';
                    temp += '        <div class="line4"></div>';
                    temp += '        <p class="pop_infor_footer">';
                    temp += '            版权所有:科大讯飞股份有限公司';
                    temp += '        </p>';*/


        temp += '<div class="pop_content pop_feeback pop_version" style="padding: 0px 15px 0px 15px;">';
        temp += '    <div class="pop_text_infor clearfix">';
        temp += '    <div class="fl ">';
        temp += '    <img src="assets/images/infor_logo.png" />';
        temp += '    </div>';
        temp += '    <div class="fl text_infor_right" style="margin-top:36px">';
        temp += '    <h3>标准化教学平台<span id="teacherAssistantVersionShow">正在获取版本...</span></h3>';
        temp += ' <p>全国首家专业教师的一站式教学工具</p>';
        temp += '    </div>';
        temp += '     </div>';
        // temp += '    <div class="line4"></div>';
        // temp += '    <p class="pop_infor_footer">';
        // temp += '    版权所有:科大讯飞股份有限公司';
        // temp += '</p>';
        temp += '<div class="button_infor">';
        temp += '    <a class="blue_button blue_button_lg" style="margin-left:50%;-webkit-transform:translateX(-50%)" id="setUpdate_ok" href="javascript:;"><span>检测更新</span></a>';
        temp += '    </div>';
        temp += '</div>';



        var dSetting = dialog({
            id: 'dialog-setting',
            title: '版本信息',
            content: temp,
            cancel: function () {
                this.close();
                //不销毁对话窗dom
                return false;
            }
        });


        //检测升级公告,移至自动登录流程前的校验
        // setTimeout(function () {
        //     NoticeManager.noticeStart();
        // }, 500);

        //添加对flash的信任
        //TODO:一般情况下这个地址不会变，如有变动，则说明出了大问题
        var flahtrust = require('../node_modules/flashtrust');
        flahtrust('yun.changyan.com');


        //设置框弹出
        $(document).on("click", "#setUpdate", function () {
            //点击版本信息监管    ---pengchen3
            LogManager.statistics("trigger", {
                ta_app: "ta",
                module: "10",
                user_id: userInfo.id
            }, null);

            if (APPManager.onlineFlag) {
                dSetting.showModal();
            } else {
                dNetworkPanel.showModal();
            }
            fs.readFile(aucPath, function (err, data) {
                var iniContent = parseINIString(data.toString());
                $("#teacherAssistantVersionShow").html(iniContent.Product.Version + " 版本");
            })
        });

        //检查版本更新
        $(document).on("click", "#setUpdate_ok", function () {

            if (APP_CONFIG.UpgradeDetect) {
                shellcmd.findProcess("UpgradeDetect.exe").done(function (num) {
                    //进程未启动
                    if (parseInt(num) < 1) {
                        APP_CONFIG.UpgradeDetect = false;
                        socket.send({
                            type: TYPE.LOGIC,
                            action: CMD.TA_CHECKUPDATE,
                            data: {}
                        });
                    }
                });

            }

        });
        //当有APP删除的消息传入
        taEmitter.on(TA_EVENT.PLUGIN_DELETED, NC.delegate(this.onAppDeleted, this));
        taEmitter.on(TA_EVENT.APP_UPZIP, NC.delegate(this.onAppDeleted, this));
        //taEmitter.on(TA_EVENT.DOWNLOAD_START, NC.delegate(this.onDownloadStart, this));
        //taEmitter.on(TA_EVENT.DOWNLOAD_PROGRESS, NC.delegate(this.onDownloadProgress, this));
    },
    onDownloadStart: function (id) {
        if (id == '62') {
            this._prepareLoadingUI(
                $('.main_right div[name="btncontainer"]', this.getPageDom()),
                this.downloadStr
            );
        }
    },
    onDownloadProgress: function (opt) {
        var id, l;
        id = opt.split(',')[0];
        l = opt.split(',')[1];
        if (id == '62') {
            var appManager = APPManager.getInstance();
            appManager.progress[id] = l;
            this._createItem({
                id: 62,
                url: ''
            }, null, $('.main_right', this.getPageDom()));
        }
    },
    onAppDeleted: function (id) {
        shellcmd.log("接收消息::删除应用" + id);
        this._createItem({
                id: 62,
                url: ''
            },
            this._getItem(62),
            $('.main_right', this.getPageDom())
        );
    },
    pageLoad: function (opt) {
        'use strict'
        var that = this;
        if (this.inited) return;
        /*
         if(!this.networkListener){
         this.networkListener=NC.delegate(this.pageLoad,this);
         taEmitter.on(TA_EVENT.NETWORK_STATUS_CHANGED,this.networkListener);
         }
         */
        $(this.getPageDom()).html($('#temp_iflybook').html());
        /*if (!APPManager.onlineFlag) {
            $("#no_internet_text_iFlyBook").show();
        }*/
        that._loadRecentBookList();
        that._createItem({
                id: 62,
                url: ''
            },
            that._getItem(62),
            $('.main_right', that.getPageDom())
        );
        //$('#runiFlybook').click(runIFLYBOOK);
        /*
         $("#no_internet_text_iFlyBook").find("a[name='refreash_internet']").click(function () {
         NC.Pages.go('iflybook', true);
         });
         */
    },
    destroy: function () {
        //$("#no_internet_text").hide();
    },
    _loadRecentBookList: function () {
        'use strict';
        var that = this,
            user = 'defaultuser';
        var fs = require("fs");
        var path = require('path');
        var bookData = path.join(plugins, '62\\bin\\share\\metamap.data');
        TA.UserService.getUserInfo(function (loginInfo) {
            if (loginInfo) {
                user = loginInfo.loginName;
            }
            var indexPaths = path.join(plugins, '62\\bin\\users\\' + user + '\\useBook.dat');
            that._createBookList(indexPaths, bookData);
        });
    },
    _createBookList: function (indexPaths, bookData) {
        var fs = require("fs");
        var path = require('path');
        var that = this;
        shellcmd.handleFile(bookData, null, {
            success: function (data) {
                try {
                    data = JSON.parse(data).data.subjects;
                } catch (ex) {
                    return;
                }
                shellcmd.handleFile(indexPaths, null, {
                    success: function (result) {
                        try {
                            result = JSON.parse(result).booklist;
                            result = result.slice(0, 3);
                        } catch (ex) {
                            result = [];
                        }
                        if (result.length) {
                            $('.main_left', that.getPageDom()).show();
                            var listContainer = $('ul.book_side_box', that.getPageDom());
                            $('ul.book_side_box', that.getPageDom()).empty();
                            for (var i = 0; i < result.length; i++) {
                                var _temp = result[i];
                                var _subjectList = data.filter(function (element, index) {
                                    return element.code == _temp.subject;
                                });
                                _temp.subject = _subjectList.length == 0 ? '未知' : _subjectList[0].name;
                                //reset thumbnail path
                                _temp.thumbnail = _temp.thumbnail.indexOf('.') === 0 ? _temp.thumbnail.replace('../', plugins + '62\\bin\\') : _temp.thumbnail;
                                //reset datetime format
                                _temp.lastUsedTime = new Date(_temp.lastUsedTime);
                                _temp.lastUsedTime = _temp.lastUsedTime.getFullYear() + '-' + (_temp.lastUsedTime.getMonth() + 1) + "-" + _temp.lastUsedTime.getDate();
                                var temp = '<li class="clearfix"><div class="book_img fl"><a href="javascript:;" onclick="var appManager = APPManager.getInstance();appManager.runiFlybook({})"><img src="{thumbnail}"   style="width:60px"/><span class="book_img_bg"></span></a></div><div class="beside_content fl" style="padding-left: 10px"><h4 title="{title}">{bookname}</h4><p>当前课：{subject}<span>最近使用：{lastused}</span></P></div></li>';
                                var _title = "";
                                if (_temp.title) {
                                    _temp.title.length > 7 ? _title = _temp.title.substr(0, 7) + "···" : _title = _temp.title;
                                }
                                temp = temp.replace('{thumbnail}', _temp.thumbnail).replace('{bookname}', _title).replace('{title}', _temp.title).replace('{subject}', _temp.subject).replace('{lastused}', _temp.lastUsedTime);
                                listContainer.append(temp);
                            }
                        }
                    },
                    fail: function () {
                        $('.main_left', that.getPageDom()).hide();
                    }
                })
            },
            fail: function () {
                $('.main_left', that.getPageDom()).hide();
            }
        });
    },
    _prepareLoadingUI: function (btnContainer, downloadStr) {
        btnContainer.addClass("table_t clearfix");
        btnContainer.html(downloadStr);
    },
    _prepareDownloadUI: function (btnContainer, appItem, downloadStr, remoteCommandInfo) {
        var that = this,
            appManager = APPManager.getInstance();
        btnContainer.removeClass("table_t clearfix");
        appItem.find("div[name='btncontainer']").html(this.btn);
        appItem.find("button[name='btn']").text("一键加载").one('click', function () {
            if (APPManager.onlineFlag) {
                btnContainer.addClass("table_t clearfix");
                btnContainer.html(downloadStr);
                appManager.getAPPInfo({
                    id: remoteCommandInfo.id,
                    success: function (appDetailInfo) {
                        remoteCommandInfo = appDetailInfo;
                        TA.Utils.downloadAPP(btnContainer, remoteCommandInfo, function () {
                            that._createItem({
                                    id: 62,
                                    url: ''
                                },
                                that._getItem(62),
                                $('.main_right', that.getPageDom())
                            )
                        }, appManager);
                    }
                });
            } else {
                dNetworkPanel.show();
            }
        });
    },

    downloadStr: '<div><b class="fl" name="shuzi">0.0%</b><div class="jd fl"><div class="jd_con" name="jindu"></div></div><a class="jd_close fl" href="javascript:void(0);" name="closebtn"></a></div>',
    _createItem: function (remoteCommandInfo, localAppInfo, appItem) {
        var that = this,
            btnContainer;

        var btn = this.btn = '<button class="main_button_load" name="btn">一键加载</button>';
        btnContainer = appItem.find("div[name='btncontainer']");
        btnContainer.attr("content", remoteCommandInfo.id);
        var appManager = APPManager.getInstance();
        //正在下载中
        if (!localAppInfo && appManager.progress[remoteCommandInfo.id]) {
            if (appManager.progress[remoteCommandInfo.id] == 'unzip') {
                appItem.find("b[name='shuzi']").text("解压中");
            } else {
                appItem.find("b[name='shuzi']").text(appManager.progress[remoteCommandInfo.id]);
                appItem.find("div[name='jindu']").css("width", appManager.progress[remoteCommandInfo.id]);
            }
            return;
        }
        //本地未安装
        if (!localAppInfo && !appManager.progress[remoteCommandInfo.id]) {
            that._prepareDownloadUI(btnContainer, appItem, that.downloadStr, remoteCommandInfo);
            return;
        }
        //本地已经安装
        if (localAppInfo) {
            btnContainer.html(btn);
            appItem.find("button[name='btn']").text("打开应用").click(function () {
                appManager.runiFlybook({
                    id: remoteCommandInfo.id,
                    error: function (err) {
                        shellcmd.log('APP::启动IFlybook失败');
                    }
                });
            });
        }
    },
    _getItem: function (idx) {
        var loginName = userInfo.loginName;
        var path = APP_CONFIG.BASE_PATH + "/user/" + loginName + "/appmanage.dat";

        var localInfo = shellcmd.readFile(path);
        var localAppInfo,
            localAppInfoMap;
        try {
            localAppInfoMap = JSON.parse(localInfo);
            localAppInfo = localAppInfoMap[idx] || null;
        } catch (ex) {
            localAppInfo = null;
        }
        return localAppInfo;
    }
});
//NC.Pages.register(pageIFlyBook);