/**
 *
 * User: chengyang@iflytek.com
 * Date: 15-6-8 下午7:54
 * Version: 1.0
 */


var appRegion = (function () {

    var appRegionDom,
        localinfo,  //appmanage.dat
        remoteinfo, //按时间排序的服务端的appList
        appdata = {},    //所有app信息源
        recentUse = [],
        recentUsePath = "",
        appDom = ""; //拼接要加载的app信息

    function init(dom){
        appRegionDom = $(dom);
        appDom = appRegionDom.find('#recentApp');
    }

    /**
     * 初始化用户使用app信息的目录
     * @param user 用户对象
     */
    function setRecentApp(user){
        var loginName = user.loginName;

        if(loginName){
            recentUsePath = APP_CONFIG.BASE_PATH + "/user/" + loginName;
            shellcmd.fileOrDirExist(recentUsePath).done(function(ret) {
                if(!ret) {
                    shellcmd.DOS_makeDir(recentUsePath);
                }
                getAppInfo(recentUsePath, user);
            });
        }
    }

    /**
     * 获取要在TA首页右上角展示的APP信息
     * @param recentUsePath 用户app信息目录
     * @param user          用户对象
     */
    function getAppInfo(recentUsePath, user){
        //初始化用户信息
        syncLocalAppList({
            info: "",
            ignoreIflybook: false,
            type: "read",
            success: function (localInfo) {
               console.log("初始化用户app信息成功");
            }
        });

        var appManager = APPManager.getInstance();
        appManager.getAPPList({
            success: function(remoteList) {
                for(var app in remoteList) {
                    var appInfo = remoteList[app];
                    appdata[appInfo.id] = appInfo;
                }
                syncRecentUse({
                    type: 'read',
                    success: function(recentuse) {
                        recentUse = deleteRecentUseRepeat(recentuse);
                        // 主页不再展示列表（无dom），暂屏蔽
                        // createList();
                    }
                });
            }
        });
    }

    //删除重复的记录; 若记录不足四条，从默认推荐里补充
    function deleteRecentUseRepeat(recentUse){
        var result = [];
        for(var i = 0; i < recentUse.length; i++){
            if(result.indexOf(parseInt(recentUse[i]))==-1){
                result.push(parseInt(recentUse[i]));
            }
        }

        var recommend = APP_CONFIG.DEFAULT_RECENT_APP;
        if(result.length - APP_CONFIG.BLANK_APP.length < 4) {
            for(var i=0, len = recommend.length; i<len; i++) {
                if(result.indexOf(parseInt(recommend[i]))==-1) {
                    result.push((parseInt(recommend[i])));
                    recentUse.push(recommend[i]);
                };
            }

            syncRecentUse({
                type: 'write',
                appRecentUse: recentUse,
                success: function() {
                    console.log("最近使用的APP不足4个，已将默认推荐APP添加显示区域");
                }
            });
        }

        return result;
    }

    //创建APP列表
    function createList() {
        var count = 0;
        appDom.empty();
        for(var i in recentUse){
            var app = appdata[recentUse[i]];
            //多媒体教学系统不显示
            if(app && count < 4 && APP_CONFIG.BLANK_APP.indexOf(parseInt(app.id)) == -1){
                createAppItem(app);
                count++;
            }
        }
    }

    //创建单个APP
    function createAppItem(app) {
        var item = '<li name="recentApp" appid="{id}"><img src="{src}" width="48" height="48"><span>{name}</span></li>';
        var $item = $(item.replace('{id}', app.id).replace('{src}', app.icon).replace('{name}', app.name));

        appDom.append($item);
    }

    return {
        init: init,
        setRecentApp:setRecentApp
    }

})();