/**
 * Created by zzsun on 14-6-18.
 */
var onLoginFlag = 0;
//ifs运行状态
var ifsrun = 0;
var Login = (function () {
    //当前是否为联网状态的标识
    var onlineFlag = 1;
    var userCenter_childprocess;
    /**
     * 主登录框提示语
     * 提示语修改注意事项：提示语长度影响UI呈现。请确保同步修改LoginBox.showTips()方法中对特定长度提示语的特殊处理。
     */
    var MainLoginTips = {
        'Input_Account_Default': '账号/手机号/邮箱',
        'Error_Account_Password_Empty': '账号、密码不能为空',
        'Error_VerifyCode_Empty': '验证码不能为空',
        'Error_VerifyCode_Not_Correct': '验证码输入错误',
        'Error_VerifyCode_Expired': '验证码过期，请重新输入',
        'Error_Account_Status': '获取用户状态信息失败',
        'Status_Need_NetWork': '请联网登录',
        'Error_Account_Not_Exist': '账户不存在',
        'Error_Account_Password_Not_Correct': '账号、密码错误',
        'Error_Account_Forbidden': '账号被冻结，如需启用，请联系当地教育主管部门',
        'Status_Need_ForceLogin': '您已修改密码，请重新登录',
        'Status_Need_Authorized': '软件授权已过期，如需继续使用，请联系当地教育主管部门',
        'Status_Need_Active': '您的账户已过期',
        'Status_Need_ReLogin': '自动登录失败，请输入密码登录',
        'Error_Login_ErrorNumber': '登录异常，错误码：',
        'Error_SSO_Validate': '登录请求失败，请联系客服400 887 8557',
        'Error_Api_EDC': 'EDC接口调用失败',
        'Status_Need_Bind_Teacher': '暂不支持非教师账户登录',
        'Status_Need_Local_Expired': '已超过3年期限，请在线登录',
        'Status_Need_Environment_Support': '不支持在当前模式下登录',
        'Status_Need_Network':'您当前已处于离线状态',
        'Error_Api_Area': '区域接口请求失败'
    };
    /**
     * 用户登录模式
     * 登录模式主要用于控制校验流程和登录流程
     * @type {{password: string, tgt: string, cr: string}}
     */
    var MainLoginModel = {
        //用户主动登录
        'PASSWORD':'password',
        //用户自动登录 tgt
        'TGT':'tgt',
        //用户自动登录 cr
        'CR':'cr'
    };

    var sqlite3 = require('sqlite3').verbose();

    /**
     * 用户登录
     * @param loginInfo={useranme,password}用户登录信息
     * @private
     */
    function openPersonCenter(para) {
        if(!APPManager.onlineFlag){
            dNetworkPanel.show();
            return ;
        }
        shellcmd.log('个人中心::启动');
        $("#sel_box").hide();
        var spawn = require('child_process').spawn;
        var nw = APP_CONFIG.BASE_PATH + "/nw.exe";
        var usercenter = APP_CONFIG.BASE_PATH + "/usercenter";
        /**
         * 这里判断个人中心是否存在的原因是：已打开一个个人中心进程，再次打开时NW返回的进程PID改变，
         * 事实上，PID并未改变，只是重启了一个进程发现单实例后自动退出，同时能监听到重启的进程的离开状态。
         * 如若node-webkit换版本，请注意修改此问题。
         * TODO:something;
         */
        if(TA.Stage.stages['usercenter']){
            spawn(nw, [usercenter, para]);
        }else{
            TA.Stage.stages['usercenter'] = spawn(nw, [usercenter, para, APPManager.onlineFlag]).on("error", function (err) {
                shellcmd.log('个人中心::启动失败' + JSON.stringify(err));
            }).on("exit", function () {
                TA.Stage.stages['usercenter']=null;
            });
        }

    }

    /**
     * 打开消息中心
     */
    function openMessageCenter() {
        if(!APPManager.onlineFlag){
            dNetworkPanel.show();
            return ;
        }
        shellcmd.log('消息中心::启动');
        var spawn = require('child_process').spawn;
        var nw = APP_CONFIG.BASE_PATH + "/nw.exe";
        var messagecenter = APP_CONFIG.BASE_PATH + "/messagecenter";
        /**
         * 这里判断个人中心是否存在的原因是：已打开一个个人中心进程，再次打开时NW返回的进程PID改变，
         * 事实上，PID并未改变，只是重启了一个进程发现单实例后自动退出，同时能监听到重启的进程的离开状态。
         * 如若node-webkit换版本，请注意修改此问题。
         * TODO:something;
         */
        if(TA.Stage.stages['messagecenter']){
            spawn(nw, [messagecenter]);
        }else{
            TA.Stage.stages['messagecenter'] = spawn(nw, [messagecenter,APPManager.onlineFlag]).on("error", function (err) {
                shellcmd.log('个人中心::启动失败' + JSON.stringify(err));
            }).on("exit", function () {
                TA.Stage.stages['messagecenter']=null;
            });
        }
    }

    function openFeedBack(){
        if (!APPManager.onlineFlag) {
            dNetworkPanel.show();
            return ;
        }
        shellcmd.log('反馈页面::启动');
        var spawn = require('child_process').spawn;
        var nw = APP_CONFIG.BASE_PATH + "/nw.exe";
        var feedback = APP_CONFIG.BASE_PATH + "/feedback";
        /**
         * 这里判断反馈是否存在的原因是：已打开一个反馈进程，再次打开时NW返回的进程PID改变，
         * 事实上，PID并未改变，只是重启了一个进程发现单实例后自动退出，同时能监听到重启的进程的离开状态。
         * 如若node-webkit换版本，请注意修改此问题。
         * TODO:something;
         */
        if(TA.Stage.stages['feedback']){
            spawn(nw, [feedback]);
        }
        else{
            TA.Stage.stages['feedback'] = spawn(nw, [feedback,APPManager.onlineFlag]).on("error", function (err) {
                shellcmd.log('反馈页面::启动失败' + JSON.stringify(err));
            }).on("exit", function () {
                TA.Stage.stages['feedback']=null;
            });
        }
    }

    /**
     * 自动登录，该函数废弃
     * fromIFB 是否来自iflybook发出的websocket消息触发的自动登录
     */
    //登出
    function _logout(socketFlag) {

        /**
         *  用户登出的时候则不再保存当前用户正在上传课堂实录的状态,
         *  因为此时可能不是之前在上传的那个用户，
         *  没有必要再有提示，同时还预防新的账户登录没有产生课堂实录而给提示尴尬,
         *  添加部分加下划钱
         *  added by linwang5 2016年11月17日
         *  ___________________________________
         */
        $('#win_close').attr('ktsl', 'false');
        TA_KTSL.initHistory();
        /**
         * ____________________________________
         */
        var isSSOLogin = true;
        if(isSSOLogin){
            ssoLogout(socketFlag);
        } else {
            $("#mask_layer").hide();
            dLogoutConfirm.close();
            $("#user_info").hide();
            $("#dl_zc").show();

            $("#head_control").find("li").removeClass("selected");
            $("#head_classteach").addClass("selected");

            onLoginFlag = 0;
            /*      pageMyInteract.userInfo = null;
             pageMyInteract.userId = null;
             pageMyInteract.afterLogout();

             pageMyPrepare.afterLogout();

             pageMyHomework.userInfo = null;
             pageMyHomework.userId = null;
             pageMyHomework.afterLogout();*/

            pageMyPrepare.afterLogout();

            pageClassPrepare.userInfo = null;
            pageClassPrepare.userId = null;
            pageClassPrepare.afterLogout();

            pageClassAttend.userInfo = null;
            pageClassAttend.userId = null;
            pageClassAttend.afterLogout();

            /*pageMyZhiXue.userInfo = null;
             pageMyZhiXue.userId = null;
             pageMyZhiXue.afterLogout();

             pageClassTeach.afterLogout();*/
            userInfo = {loginName: "defaultuser"};
            taEmitter.emit(TA_EVENT.APPBOX_LOGIN_OUT + ".appbox.false"); //这里为appbox设置userInfo

            //登出时关闭正在使用的app
            for (var s in TA.Stage.stages) {
                if ((s.indexOf('app_') != -1) && (s.indexOf('app_62') == -1)) {
                    TA.Stage.stages[s] && TA.Stage.stages[s].kill();
                }
            }

            /**
             * 发出登出消息,这里加socketFlag是为了IFB传来的logout再次被发送出去.
             */
            if (socketFlag != true) socket.send({type: TYPE.LOGIC, action: CMD.TAMSG_LOGOUT, data: {}});
            else     socket.send({type: TYPE.LOGIC, action: CMD.TAMSG_LOGOUT, to: TA_APP.TA_APP_TRAY, data: {}});
            //用户注销后消息提醒消失
            $(".userInfoCenter").find('b').hide();
            TA.UserService.loginOut();
//                $("#login_box").show();
            loginAndCurtain(true);
            // //提示语隐藏
            // $("#loginwarn").html("");
            // $("#loginwarn").hide();
            //注销后头像还原为默认
            $("#user_photo").attr("src", "assets/images/user.jpg");
            if (TA.Stage.stages['usercenter']) {
                TA.Stage.stages['usercenter'].kill();
            }

            //做任务赢奖励退出时清除dom ---屏蔽做任务赢奖励
            // if(APP_CONFIG.isShowAward && Global_Version == "Center") {
            //     getAward.remove();
            // }
        }
        killFloatToolbar();
    }
    function ssoLogout(socketFlag){
        if (APPManager.onlineFlag) {
            SSO.logout(function (result) {
                if (result && result.code == "2001") {
                    ssoLogoutAfter(socketFlag);
                }else{
                    //force logout
                    ssoLogoutAfter(socketFlag);
                }
            });
        }else{
            ssoLogoutAfter(socketFlag);
        }
    }

    function ssoLogoutAfter(socketFlag){
        $("#mask_layer").hide();
        dLogoutConfirm.close();
        $("#user_info").hide();
        $("#dl_zc").show();

        $("#head_control").find("li").removeClass("selected");
        $("#head_classteach").addClass("selected");

        onLoginFlag = 0;
        ifsrun = 0;
        /*      pageMyInteract.userInfo = null;
         pageMyInteract.userId = null;
         pageMyInteract.afterLogout();

         pageMyPrepare.afterLogout();

         pageMyHomework.userInfo = null;
         pageMyHomework.userId = null;
         pageMyHomework.afterLogout();*/

        pageClassPrepare.userInfo = null;
        pageClassPrepare.userId = null;
        pageClassPrepare.afterLogout();

        pageClassAttend.userInfo = null;
        pageClassAttend.userId = null;
        pageClassAttend.afterLogout();

        /*pageMyZhiXue.userInfo = null;
         pageMyZhiXue.userId = null;
         pageMyZhiXue.afterLogout();

         pageClassTeach.afterLogout();*/
        userInfo = {loginName: "defaultuser"};
        taEmitter.emit(TA_EVENT.APPBOX_LOGIN_OUT + ".appbox.false"); //这里为appbox设置userInfo

        //登出时关闭正在使用的app
        for (var s in TA.Stage.stages) {
            if ((s.indexOf('app_') != -1) && (s.indexOf('app_62') == -1)) {
                TA.Stage.stages[s] && TA.Stage.stages[s].kill();
            }
            //关闭消息中心
            if(s === "messagecenter"){
                TA.Stage.stages[s] && TA.Stage.stages[s].kill();
            }

        }

        /**
         * 发出登出消息,这里加socketFlag是为了IFB传来的logout再次被发送出去.
         */
        if (socketFlag != true) socket.send({type: TYPE.LOGIC, action: CMD.TAMSG_LOGOUT, data: {}});
        else     socket.send({
            type: TYPE.LOGIC,
            action: CMD.TAMSG_LOGOUT,
            to: TA_APP.TA_APP_TRAY,
            data: {}
        });
        //用户注销后消息提醒消失
        $(".userInfoCenter").find('b').hide();
        TA.UserService.loginOut();
//                $("#login_box").show();
        loginAndCurtain(true);
        // //提示语隐藏
        // $("#loginwarn").html("");
        // $("#loginwarn").hide();
        //注销后头像还原为默认
        $("#user_photo").attr("src", "assets/images/user.jpg");
        if (TA.Stage.stages['usercenter']) {
            TA.Stage.stages['usercenter'].kill();
        }

        //做任务赢奖励退出时清除dom ---屏蔽做任务赢奖励
        // if(APP_CONFIG.isShowAward && Global_Version == "Center") {
        //     getAward.remove();
        // }
        //使用hproseClient服务向备课本发消息
        hproseClient.hproseSend({_from:'TA',_to:'preparebook',data:{method:'loginOut'}})
    }
    function go_login(loginInfo, checkChangePdFlag) {

        shellcmd.log('检测登录::登录。是否已走过登录流程：' + onLoginFlag);
        shellcmd.log('检测登录::登录。用户信息：' + (loginInfo ? loginInfo.username : ''));
        if (onLoginFlag == 1){
            return;
        }
        if (!loginInfo)return;
        var loginClass = parseAccountType(loginInfo.username);
        if(loginInfo._type){
            var _type = loginInfo._type;
            LoginBox.setLoginModel(_type);
        }else{
            var _type = MainLoginModel.PASSWORD;
            LoginBox.setLoginModel(MainLoginModel.PASSWORD);
        }

        if (APPManager.onlineFlag) {
            shellcmd.log('检测登录::有网络');
            beforeOnLineLoginCheck(loginInfo,_type).done(function(user){
                switch(_type){
                    //主动登录
                    case MainLoginModel.PASSWORD:
                    //自动登录cr文件(和password登录流程是一样的)
                    case MainLoginModel.CR:
                        ssoValidate(loginInfo).done(function(SSOResult){
                            userValidate(SSOResult,loginInfo).done(function(userDetailInfo){
                                afterOnlineLogin(userDetailInfo,loginInfo,_type);
                            }).fail(function(e){
                                // 终止登录流程
                                LoginBox.setLoginStatus(0);
                                // 刷新验证码
                                LoginBox.refreshVerifyCode();
                                if(e.msg && typeof (e.msg) === 'string'){
                                    switch(e.msg){
                                        case MainLoginTips.Error_Api_EDC:
                                            $("#mask_layer").show();
                                            userLoginFailTipDia.show();
                                            break;
                                        case MainLoginTips.Status_Need_Bind_Teacher:
                                        case MainLoginTips.Status_Need_Authorized:
                                        case MainLoginTips.Status_Need_Active:
                                            LoginBox.showTips('warn',e.msg);
                                            break;
                                        default:
                                            LoginBox.showTips('warn',e.msg);
                                    }
                                }else{
                                    $("#mask_layer").show();
                                    userLoginFailTipDia.show();
                                }
                                // focus验证码区域
                                $(LoginBox.verifyCodeDom).find("input").focus();
                            });
                        }).fail(function(e){
                            // 终止登录流程
                            LoginBox.setLoginStatus(0);
                            // 刷新验证码
                            LoginBox.refreshVerifyCode();
                            if(e.msg && typeof (e.msg) === 'string'){
                                switch(e.msg){
                                    case MainLoginTips.Error_Account_Password_Not_Correct:
                                        // focus密码区域
                                        $(LoginBox.pwdDom).focus();
                                        LoginBox.showTips('warn',e.msg);
                                        break;
                                    case MainLoginTips.Error_Account_Forbidden:
                                    case MainLoginTips.Error_SSO_Validate:
                                    default:
                                        // focus验证码区域
                                        $(LoginBox.verifyCodeDom).find("input").focus();
                                        LoginBox.showTips('warn',e.msg);
                                }
                            }else{
                                $("#mask_layer").show();
                                userLoginFailTipDia.show();
                            }
                        });
                        break;
                    //自动登录tgt
                    case MainLoginModel.TGT:
                        var tgt = user && user._reserve1._sso_tgt;
                        loginInfo.password = tgt;
                        tgtLogin(loginInfo);
                        break;
                    default:
                        //不支持的登录模式
                        // 终止登录流程
                        LoginBox.setLoginStatus(0);
                        // 刷新验证码
                        LoginBox.refreshVerifyCode();
                        // focus验证码区域
                        $(LoginBox.verifyCodeDom).find("input").focus();
                        LoginBox.showTips('warn',MainLoginTips.Status_Need_Environment_Support);
                }
            }).fail(function(e){
                // 这里不需要处理input框的focus，在check的时候已经做了处理
                // 终止登录流程
                LoginBox.setLoginStatus(0);
                if(e.msg && typeof (e.msg) === 'string'){
                    switch(e.msg){
                        case MainLoginTips.Error_Account_Password_Empty:
                        case MainLoginTips.Error_VerifyCode_Empty:
                        case MainLoginTips.Error_VerifyCode_Not_Correct:
                        case MainLoginTips.Error_VerifyCode_Expired:
                            LoginBox.showTips('warn',e.msg);
                            break;
                        default:
                            LoginBox.showTips('warn',e.msg);
                            break;
                    }
                }else{
                    $("#mask_layer").show();
                    userLoginFailTipDia.show();
                }
            });
        } else {
            shellcmd.log('检测登录::无网络');
            beforeOffLineLoginCheck(loginInfo,_type).done(function(user){
                switch(_type){
                    case MainLoginModel.PASSWORD:
                    case MainLoginModel.CR:
                        var lastOnline = user._reserve1 && user._reserve1.lastOnline;
                        var sha1_encrypted_password = user && user._reserve1.sha1_encrypted_password;
                        sha1_loginInfo(loginInfo.username,loginInfo.password,lastOnline).done(function(ret){
                            if(ret == sha1_encrypted_password){
                                var userDetailInfo = {
                                    userInfo: user
                                };
                                afterOfflineLogin(userDetailInfo,loginInfo,_type);
                            }else{
                                //终止登录流程
                                LoginBox.setLoginStatus(0);
                                // 刷新验证码
                                LoginBox.refreshVerifyCode();
                                // focus密码区域
                                $(LoginBox.pwdDom).focus();
                                LoginBox.showTips('warn',MainLoginTips.Error_Account_Password_Not_Correct);
                            }
                        });
                        break;
                    default:
                        // 终止登录流程
                        LoginBox.setLoginStatus(0);
                        // 刷新验证码
                        LoginBox.refreshVerifyCode();
                        // focus验证码区域
                        $(LoginBox.verifyCodeDom).find("input").focus();
                        LoginBox.showTips('warn',MainLoginTips.Status_Need_Environment_Support);
                }
            }).fail(function(e){
                // 这里不需要处理input框的focus，在check的时候已经做了处理
                //终止登录流程
                LoginBox.setLoginStatus(0);
                //检测失败
                if(e.msg && typeof (e.msg) === 'string'){
                    switch(e.msg){
                        case MainLoginTips.Status_Need_Local_Expired:
                            LoginBox.showTips('warn',e.msg);
                            break;
                        //账户不存在时，提示账号密码错误
                        case MainLoginTips.Error_Account_Not_Exist:
                            LoginBox.showTips('warn',MainLoginTips.Error_Account_Password_Not_Correct);
                            break;
                        case MainLoginTips.Error_Account_Password_Empty:
                        case MainLoginTips.Error_VerifyCode_Empty:
                        case MainLoginTips.Error_VerifyCode_Not_Correct:
                        case MainLoginTips.Error_VerifyCode_Expired:
                            LoginBox.showTips('warn',e.msg);
                            break;
                        default:
                            LoginBox.showTips('warn',e.msg);
                    }
                }else{
                    $("#mask_layer").show();
                    userLoginFailTipDia.show();
                }
            });
        }
    }

    function parseAccountType(account){
        var loginClass = 'loginName';
        var regex = /^(130|131|132|133|134|135|136|137|138|139|145|147|150|151|152|153|154|155|156|157|158|159|170|176|177|178|180|181|182|183|184|185|186|187|188|189)\d{8}$/;
        //手机号登陆关键字更换
        if (regex.exec(account) != null) {
            loginClass = 'mobile';
        } else {
            regex = /^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+((\.[a-zA-Z0-9_-]{2,3}){1,2})$/;
            if (regex.exec(account) != null) {
                loginClass = 'email';
            }
        }
        return loginClass;
    }

    function isTimeValid(timestamp){
        var timestamp = timestamp || 0;
        var now = getTimestamp();
        return (parseInt(now) - parseInt(timestamp) <= 3 * 365 * 24 * 3600);
    }

    function validateUserName(userName){
        userName = userName || '';
        userName = $.trim(userName);
        if(false || userName == '' || userName == MainLoginTips.Input_Account_Default){
            return {code:-1,msg:MainLoginTips.Error_Account_Password_Empty};
        }
        return {code:0};
    }

    function validatePassword(passWord){
        passWord = passWord || '';
        passWord = $.trim(passWord);
        if(passWord == ''){
            return {code:-1,msg:MainLoginTips.Error_Account_Password_Empty};
        }
        return {code:0};
    }

    function validateVerifyCode(verifyCode){
        var global_verifyCode;
        verifyCode = verifyCode || '';
        verifyCode = $.trim(verifyCode);
        if(verifyCode == ""){
            return {code:-1,msg:MainLoginTips.Error_VerifyCode_Empty};
        }else{
            try{
                global_verifyCode = userInfo && userInfo.verifyCode;
            }catch(e){
                console.error(e);
            }
            if(global_verifyCode) {
                if(global_verifyCode != verifyCode){
                    return {code:-1,msg:MainLoginTips.Error_VerifyCode_Not_Correct};
                }
            }else{
                LoginBox.refreshVerifyCode();
                return {code:-1,msg:MainLoginTips.Error_VerifyCode_Expired};
            }
        }
        return {code:0};
    }

    function searchLocalUser(options){
        var def = jQuery.Deferred();
        var account;
        switch(typeof options){
            case 'string':
                account = options;
                break;
            case 'object':
                account = options.account || '';
                break;
        }
        // 读取登录历史数据
        userSettingInfoAccess.read().done(function (settingInfo) {
            if(account){
                var userName = account;
            }else{
                // 最后一次登录账号
                var userName = settingInfo.loginHistory ? settingInfo.loginHistory[0] : '';
            }
            var userSetting = settingInfo[userName];
            var loginName = userSetting && userSetting.loginName || "";

            userDbAccess.getAllInfo().done(function(users){
                //获取指定用户信息（数据库里以loginName唯一）
                var userDbInfo = userDbAccess.updateUsersCache('get', loginName);
                var parsedInfo = userDbAccess.parseToJson(userDbInfo);
                if(parsedInfo.length >= 1){
                    var user = parsedInfo[0] || {};
                    user.userSetting = userSetting || {};
                    def.resolve(user);
                }else{
                    def.reject({});
                }
            }).fail(function(e){
                def.reject({});
            });
        });
        return def.promise();
    }

    /**
     * 自动登录
     * fromIFB 是否来自iflybook发出的websocket消息触发的自动登录
     */
    function autoLogin(fromIFB){
        userSettingInfoAccess.read().done(function(settinginfo) {
            // 上一次登录的账号
            var userName = settinginfo.loginHistory ? settinginfo.loginHistory[0] : '';
            var userSetting = settinginfo[userName];
            if (userSetting) {
                if(fromIFB){
                    // 回显账号信息
                    LoginBox.setLoginModel(MainLoginModel.CR);
                    LoginBox.receiptAccount(userSetting);
                    // 应用间同步登录
                    appAutoLogin();
                }else{
                    if (APPManager.onlineFlag) {
                        accountLogin(userSetting);
                    }else{
                        //离线登录
                        LoginBox.setLoginModel(MainLoginModel.PASSWORD);
                        LoginBox.receiptAccount(userSetting);
                    }
                }
            } else {
                LoginBox.resetAccount();
            }
        });
    }

    /**
     * 应用间同步登录
     */
    function appAutoLogin(){
        TA.UserService.getLocalUserAccount(function(user) {
            if(user && user.password) {
                if(user.username) {
                    LoginBox.setLoginModel(MainLoginModel.CR);
                    go_login({
                        username: user.username,
                        password: user.password,
                        _type: MainLoginModel.CR
                    }, 1);
                }else{
                    LoginBox.init();
                }
            }else{
                LoginBox.init();
            }
        });
    }

    /**
     * 在线账号登录
     * @param account
     */
    function accountLogin(userSetting){
        if(userSetting){
            var autoLogin = userSetting && userSetting.autoLogin;
            var rememberPwd = userSetting && userSetting.rememberPwd;
            if(rememberPwd){
                //自动登录
                if(autoLogin){
                    // 回显账号信息
                    LoginBox.receiptAccount(userSetting);
                    // 开始登录流程
                    LoginBox.setLoginStatus(1);
                    // 登录按钮聚焦
                    $(LoginBox.loginButtonDom).focus();

                    loginInfoManager({
                        type: 'read',
                        loginInfo: {
                            username: userSetting.userName
                        },
                        success: function(loginInfo) {
                            if(loginInfo.username && loginInfo.password){
                                // 进行自动登录流程
                                go_login({
                                    username: loginInfo.username,
                                    password: loginInfo.password,
                                    _type: MainLoginModel.CR
                                },1);
                            }else{
                                // 读取的加密信息异常
                                // 结束登录流程
                                LoginBox.setLoginStatus(0);
                                LoginBox.setLoginModel(MainLoginModel.PASSWORD);
                                //回显账号
                                LoginBox.receiptAccount(userSetting);
                            }
                        },
                        error: function(){
                            // 结束登录流程
                            LoginBox.setLoginStatus(0);
                            // 加密文件不存在
                            LoginBox.setLoginModel(MainLoginModel.PASSWORD);
                            //回显账号
                            LoginBox.receiptAccount(userSetting);
                        }
                    });
                }else{
                    //仅记住密码
                    LoginBox.setLoginModel(MainLoginModel.CR);
                    // 回显账号信息
                    LoginBox.receiptAccount(userSetting);
                }
                // 调用全国公告显示
                NoticeManager.noticeStart().done(function (hasNotice){});
            }else{
                // 回显账号信息
                LoginBox.receiptAccount(userSetting);
                // 避免公告和快速登录框重叠，如果有全国公告显示，等公告关掉后再显示快速登录框
                // 目前已经没有快速登录框了
                NoticeManager.noticeStart().done(function (hasNotice) {
                    if(hasNotice){
                        //等公告关掉后再显示快速登录框
                        $(document).one('click', '.noticeClose', function (){
                            setTimeout(function (){
                                //关闭公告后，做其他处理
                            }, 800);
                        });
                    }else{
                        //没有公告，不做处理
                    }
                });
            }
        }else{
            LoginBox.resetAccount();
        }
    }

    /**
     * 在线登录预检查
     * @param loginInfo
     * @param type
     */
    function beforeOnLineLoginCheck(loginInfo,type){
        var def = $.Deferred();
        var input_account = loginInfo.username;
        var input_password = loginInfo.password;
        var input_verifyCode = loginInfo.verifyCode;
        var username = $.trim(input_account);
        var password = $.trim(input_password);
        var verifyCode = $.trim(input_verifyCode);

        var v_username = validateUserName(username);
        var v_password = validatePassword(password);
        var v_verifyCode = validateVerifyCode(verifyCode);

        //用户名校验
        if(v_username.code != 0){
            $(LoginBox.accountDom).focus();
            def.reject({code:-1,msg:v_username.msg});
            return def.promise();
        }
        switch(type){
            case MainLoginModel.PASSWORD:
                // 密码校验
                if(v_password.code != 0){
                    $(LoginBox.pwdDom).focus();
                    def.reject({code:-1,msg:v_password.msg});
                    return def.promise();
                }
                //验证码校验
                if(v_verifyCode.code != 0){
                    $(LoginBox.verifyCodeDom).find("input").focus();
                    def.reject({code:-1,msg:v_verifyCode.msg});
                    return def.promise();
                }
                def.resolve();
                break;
            case MainLoginModel.TGT:
                searchLocalUser(loginInfo.username).done(function(user){
                    var userSetting = user.userSetting || {};
                    var autoLogin = userSetting && userSetting.autoLogin;
                    var rememberPwd = userSetting && userSetting.rememberPwd;
                    //最后一次在线登录时间
                    var lastOnline = user._reserve1 && user._reserve1.lastOnline;
                    if(rememberPwd){
                        if(!autoLogin){
                            //验证码校验
                            if(v_verifyCode.code != 0){
                                $(LoginBox.verifyCodeDom).find("input").focus();
                                def.reject({code:-1,msg:v_verifyCode.msg});
                                return def.promise();
                            }else{
                                def.resolve(user);
                                return def.promise();
                            }
                        }
                        var checkTime = isTimeValid(lastOnline);
                        checkTime ? def.resolve(user) : def.reject({code:-1,msg:MainLoginTips.Status_Need_NetWork});
                        return def.promise();
                    }else{
                        def.resolve(user);
                        return def.promise();
                    }
                }).fail(function(){
                    //未找到记录
                    def.reject({code:-1,msg:MainLoginTips.Status_Need_NetWork});
                    return def.promise();
                });
                break;
            case MainLoginModel.CR:
                // 密码校验
                if(v_password.code != 0){
                    $(LoginBox.pwdDom).focus();
                    def.reject({code:-1,msg:v_password.msg});
                    return def.promise();
                }
                //验证码校验
                if(loginInfo.hasOwnProperty('verifyCode')){
                    if(v_verifyCode.code != 0){
                        $(LoginBox.verifyCodeDom).find("input").focus();
                        def.reject({code:-1,msg:v_verifyCode.msg});
                        return def.promise();
                    }
                }
                def.resolve();
                break;
            default:
                def.reject({code:-1,msg:MainLoginTips.Status_Need_Environment_Support});
        }
        return def.promise();
    }

    /**
     * 离线登录预检查
     * @param loginInfo
     * @param type
     */
    function beforeOffLineLoginCheck(loginInfo,type){
        var def = $.Deferred();
        var input_account = loginInfo.username;
        var input_password = loginInfo.password;
        var input_verifyCode = loginInfo.verifyCode;
        var username = $.trim(input_account);
        var password = $.trim(input_password);
        var verifyCode = $.trim(input_verifyCode);

        var v_username = validateUserName(username);
        var v_password = validatePassword(password);
        var v_verifyCode = validateVerifyCode(verifyCode);

        //用户名校验
        if(v_username.code != 0){
            $(LoginBox.accountDom).focus();
            def.reject({code:-1,msg:v_username.msg});
            return def.promise();
        }
        // 密码校验
        if(v_password.code != 0){
            $(LoginBox.pwdDom).focus();
            def.reject({code:-1,msg:v_password.msg});
            return def.promise();
        }
        // 验证码校验
        if(v_verifyCode.code != 0){
            $(LoginBox.verifyCodeDom).find("input").focus();
            def.reject({code:-1,msg:v_verifyCode.msg});
            return def.promise();
        }
        switch(type){
            case MainLoginModel.PASSWORD:
                searchLocalUser(loginInfo.username).done(function(user){
                    var userSetting = user.userSetting || {};
                    var autoLogin = userSetting && userSetting.autoLogin;
                    var rememberPwd = userSetting && userSetting.rememberPwd;
                    //最后一次在线登录时间
                    var lastOnline = user._reserve1 && user._reserve1.lastOnline;
                    //不需要判断用户是否记住密码
                    var checkTime = isTimeValid(lastOnline);
                    checkTime ? def.resolve(user) : def.reject({code:-1,msg:MainLoginTips.Status_Need_Local_Expired});
                    return def.promise();
                }).fail(function(){
                    //未找到记录
                    def.reject({code:-1,msg:MainLoginTips.Error_Account_Not_Exist});
                    return def.promise();
                });
                break;
            case MainLoginModel.CR:
                searchLocalUser(loginInfo.username).done(function(user){
                    var userSetting = user.userSetting || {};
                    var autoLogin = userSetting && userSetting.autoLogin;
                    var rememberPwd = userSetting && userSetting.rememberPwd;
                    //最后一次在线登录时间
                    var lastOnline = user._reserve1 && user._reserve1.lastOnline;
                    //不需要判断用户是否记住密码
                    var checkTime = isTimeValid(lastOnline);
                    checkTime ? def.resolve(user) : def.reject({code:-1,msg:MainLoginTips.Status_Need_Local_Expired});
                    return def.promise();
                }).fail(function(){
                    //未找到记录
                    def.reject({code:-1,msg:MainLoginTips.Error_Account_Not_Exist});
                    return def.promise();
                });
                break;
            default:
                def.reject({code:-1,msg:MainLoginTips.Status_Need_Environment_Support});
        }
        return def.promise();
    }

    /**
     * sso验证用户信息
     * @param username 用户名
     * @param password 用户密码
     */
    function ssoValidate(loginInfo){
        var def = $.Deferred();
        var account = loginInfo.username;
        var password = loginInfo.password;

        SSO.appName = Edc_Cfg.EDC_appName;
        SSO.appKey = Edc_Cfg.EDC_appKey;
        SSO.SSOServerUrl = Edc_Cfg.EDC_SSOServerUrl;
        SSO.client = Edc_Cfg.EDC_client;
        SSO.isCenterSSO = Edc_Cfg.EDC_isCenterSSO;
        SSO.loginRedirectUrl = Edc_Cfg.EDC_loginRedirectUrl;
        SSO.needAttribute = Edc_Cfg.EDC_needAttribute;
        // 检测账号审核状态
        edcService.Instance().api_register_checkReviewStatus({loginName: account}).done(function (reviewRet) {
            if (reviewRet.code != '0') { // 成功
                // 检测账号冻结状态
                edcService.Instance().api_register_checkFrozenStatus({loginName: account}).done(function (frozenRet) {
                    if (frozenRet.code != '0') { // 成功
                        SSO.login(account, password, function (result) {
                            //sso可能会发起二次请求
                            LoginBox.setLoginStatus(1);
                            if (result && result.result && result.result.toLowerCase() == 'success' && result.code == "1001" && result.data && result.data.st) {
                                var ticket = result.data.st;
                                var tgt = result.data.tgt;
                                SSO.validateServiceTicket(ticket, SSO.loginRedirectUrl, function (validateST) {
                                    if (validateST && validateST.code == 1) {
                                        var loginName = validateST.data && validateST.data.attributes && validateST.data.attributes.loginName;
                                        var userId = validateST.data && validateST.data.attributes && validateST.data.attributes.userId;
                                        var openId = validateST.data && validateST.data.openId;
                                        /**
                                         * 生成用户信息
                                         */
                                        var password = loginInfo.password;
                                        //对用户信息进行加密
                                        var encryptedInfo = setEncryptedUserInfo(loginName, password);
                                        //加密信息保存到全局属性里
                                        userInfo.des_encrypted_userInfo = encryptedInfo.des_encrypted_userInfo;
                                        userInfo.rsa_encrypted_password = encryptedInfo.rsa_encrypted_password;
                                        //加密的用户信息 --edc接口设置用户级别授权
                                        encryptedInfo.sso_openId = openId;
                                        edcService.Instance().setEncryptedUserInfo(encryptedInfo);

                                        if (false) {
                                            var bindParam = {
                                                openId: openId,
                                                productId: 'p_ta',
                                                userQuery: true
                                            };
                                            accountExchange(bindParam).done(function (exchangeArr) {
                                                var exchange = exchangeArr[0] || {};
                                                var exchangeOpenId = exchange.id || '';
                                                var rs = {
                                                    loginName: loginName || '',
                                                    userId: userId || '',
                                                    openId: openId || '',
                                                    exchangeOpenId: exchangeOpenId || '',
                                                    tgt: tgt || '',
                                                    st: ticket || '',
                                                    des_encrypted_userInfo: userInfo.des_encrypted_userInfo || '',
                                                    rsa_encrypted_password: userInfo.rsa_encrypted_password || ''
                                                };
                                                def.resolve(rs);
                                            }).fail(function (e) {
                                                var rs = {
                                                    loginName: loginName || '',
                                                    userId: userId || '',
                                                    openId: openId || '',
                                                    exchangeOpenId: '',
                                                    tgt: tgt || '',
                                                    st: ticket || '',
                                                    des_encrypted_userInfo: userInfo.des_encrypted_userInfo || '',
                                                    rsa_encrypted_password: userInfo.rsa_encrypted_password || ''
                                                };
                                                def.resolve(rs);
                                            });
                                        } else {
                                            var rs = {
                                                loginName: loginName || '',
                                                userId: userId || '',
                                                openId: openId || '',
                                                exchangeOpenId: '',
                                                tgt: tgt || '',
                                                st: ticket || '',
                                                des_encrypted_userInfo: userInfo.des_encrypted_userInfo || '',
                                                rsa_encrypted_password: userInfo.rsa_encrypted_password || ''
                                            };
                                            def.resolve(rs);
                                        }
                                    } else {
                                        def.reject({code: -1, msg: MainLoginTips.Error_SSO_Validate});
                                    }
                                });
                            } else {
                                // 判断是否是审核失败
                                edcService.Instance().api_register_getAuditStatus({loginName: account}).done(function (auditRet) {
                                    if (auditRet.code == '0') {
                                        console.log(auditRet.msg);
                                        def.reject({code: -1, msg: auditRet.msg});
                                    } else if (auditRet.code === '1002') {
                                        def.reject({code: -1, msg: auditRet.msg});
                                    } else {
                                        ssoFail();
                                    }
                                }).fail(function (e) {
                                    console.error(e);
                                    ssoFail();
                                });
                                function ssoFail() {
                                    /**
                                     * 1000 success <1001>
                                     * 1002 您提供的凭证有误。
                                     * 2002 您登陆尝试次数过多，请{0}分钟后再试
                                     * 2003 账号被冻结
                                     * 2007 登录超时
                                     * 2008 TGT已经过期或者不存在
                                     * 2009 用户不存在<同1002>
                                     */
                                    if (result && result.result == "fail" && result.code) {
                                        var errCode = result.code + '';
                                        switch (errCode) {
                                            case '1002':
                                            case '2009':
                                                def.reject({
                                                    code: -1,
                                                    msg: MainLoginTips.Error_Account_Password_Not_Correct
                                                });
                                                break;
                                            case '2002':
                                            case '2007':
                                                def.reject({code: -1, msg: result.data});
                                                break;
                                            case '2003':
                                                def.reject({code: -1, msg: MainLoginTips.Error_Account_Forbidden});
                                                break;
                                            case '2008':
                                                $(LoginBox.pwdDom).val('');
                                                LoginBox.setLoginModel(MainLoginModel.PASSWORD);
                                                def.reject({code: -1, msg: MainLoginTips.Status_Need_ReLogin});
                                                break;
                                            default:
                                                // 对于异常信息，目前sso暂未提供完善、完整的状态码说明，这里暂根据返回的result.data做一些优化处理。
                                                var fail_tips = result.data;
                                                // 处理 '未能够识别出目标','???','登录失败，出现异常！'异常
                                                if (-1 == fail_tips.indexOf("未能够识别出目标") && -1 == fail_tips.indexOf("???") && -1 == fail_tips.indexOf("异常")) {
                                                    // 使用默认提示语
                                                    def.reject({code: -1, msg: fail_tips});
                                                } else {
                                                    def.reject({code: -1, msg: MainLoginTips.Error_SSO_Validate});
                                                }
                                        }
                                    } else {
                                        def.reject({code: -1, msg: MainLoginTips.Error_SSO_Validate});
                                    }
                                }
                            }
                        });
                    } else {
                        // 提示账号冻结
                        console.log(frozenRet.msg);
                        def.reject({code: -1, msg: frozenRet.msg});
                    }
                }).fail(function (e) {
                    // 提示接口请求失败
                    console.error(e);
                    def.reject({code: -1, msg: MainLoginTips.Error_Api_Area});
                });
            } else {
                // 提示账号审核不通过
                console.log(reviewRet.msg);
                def.reject({code: -1, msg: reviewRet.msg});
            }
        }).fail(function (e) {
             // 提示接口请求失败
            console.error(e);
            def.reject({code: -1, msg: MainLoginTips.Error_Api_Area});
        });
        return def.promise();
    }

    /**
     * 获取用户详细信息和商务平台验证
     * @param obj sso验证通过返回的数据
     * @param options 自定义数据 {password:'用户输入的密码',tgt:'tgt'}
     */
    function userValidate(obj,loginInfo){
        var def = $.Deferred();
        var data = obj;
        //sso返回的信息
        var loginName = data.loginName;
        var userId = data.userId;
        var openId = data.openId;
        var exchangeOpenId = data.exchangeOpenId;
        var st = data.st;
        var tgt = data.tgt;
        var des_encrypted_userInfo = data.des_encrypted_userInfo;
        var rsa_encrypted_password = data.rsa_encrypted_password;

        password = loginInfo.password;

        var sso_userInfo = {
            "sso_loginName": loginName,
            "sso_userId": userId,
            "sso_openId": openId,
            "exchange_openId": exchangeOpenId,
            "sso_tgt": tgt,
            "des_encrypted_userInfo": des_encrypted_userInfo,
            "rsa_encrypted_password": rsa_encrypted_password
        };
        ssoDataTranslate(sso_userInfo).done(function(userDetailInfo){
            if (userDetailInfo && userDetailInfo.statusCode == 1) {
                if(APP_CONFIG.BANSTUDENT && userDetailInfo.userInfo && userDetailInfo.userInfo.enName != "teacher"){
                    def.reject({code:-1,msg:MainLoginTips.Status_Need_Bind_Teacher});
                }else{
                    iflybookModule.beforeLogin(userDetailInfo.userInfo.loginName,password,userDetailInfo).done(function(userInfo){
                        def.resolve(userInfo);
                    }).fail(function(errCode){
                        switch(errCode){
                            case iflybookModule.CloudResult.isDele:
                                // 软件授权已过期，如需继续使用，请联系当地教育主管部门
                                def.reject({code:-1,msg:MainLoginTips.Status_Need_Authorized});
                                break;
                            case iflybookModule.CloudResult.isOutDate:
                                // 您的账户已过期
                                def.reject({code:-1,msg:MainLoginTips.Status_Need_Active});
                                break;
                            case iflybookModule.CloudResult.webError:
                                // 获取用户状态信息失败
                                def.reject({code:-1,msg:MainLoginTips.Error_Account_Status});
                                break;
                            default:
                                //其他错误码 登录异常，错误码：'+ errCode +'
                                def.reject({code:-1,msg:MainLoginTips.Error_Login_ErrorNumber + errCode});
                        }
                    });
                }
            }else{
                //状态异常
                def.reject({code:-1,msg:MainLoginTips.Error_Api_EDC});
            }
        }).fail(function(e){
            def.reject({code:-1,msg:MainLoginTips.Error_Api_EDC});
        });
        return def.promise();
    }

    /**
     * 畅言通信证2.0校验
     */
    function accountExchange(param){
        var def = $.Deferred();
        if(-1 == Easy_Cfg.EASYSVC.indexOf('test')){
            // 生产
            console.warn('生产环境下，请将畅言通行证接口开放，目前原路返回用户openId：%s',param.openId);
            def.resolve({
                code: 0,
                data: [{id:param.openid}]
            });
        }else{
            // 测试
            edcService.Instance().core_usercenter_account_get_by_product(param).done(function(ret){
                if(ret && ret.code == 0 && ret.data && $.isArray(ret.data)){
                    var accountList = ret.data || [];
                    if(accountList.length > 0){
                        def.resolve(accountList);
                    }else{
                        def.reject([]);
                    }
                }else{
                    def.reject(ret);
                }
            }).fail(function(e){
                console.log(e);
                def.reject(e);
            });
        }
        return def.promise();
    }

    /**
     * tgt在线登录
     */
    function tgtLogin(loginInfo){
        var def = $.Deferred();
        return def.promise();
    }

    /**
     * 在线登录验证成功后执行流程
     * @param userDetailInfo
     * @param loginInfo
     */
    function afterOnlineLogin(userDetailInfo,loginInfo,type){
        var userInfo  = userDetailInfo;
        onLoginFlag = 1;
        initUserFolderAndDb(userInfo.userInfo._sso_loginName,userInfo.userInfo.id);
        userInfo.userInfo.password = loginInfo.password;
        // 记录用户最后在线登录的时间戳
        userInfo.userInfo.lastOnline = getTimestamp();
        sha1_loginInfo(loginInfo.username,userInfo.userInfo.password,userInfo.userInfo.lastOnline).done(function(sha1_encrypted_password){
            userInfo.userInfo.sha1_encrypted_password = sha1_encrypted_password;
            // 记录用户最后登录的时间戳
            userInfo.userInfo.lastLoginTime = getTimestamp();
            _setUserState(userInfo, loginInfo,false,type);
        });
        //TA的记住密码
        if(LoginBox.isRememberPwd) {
            loginInfoManager({
                type: 'write',
                loginInfo: loginInfo
            });
        }
        //同步到账号列表
        userSettingInfoAccess.add({
            userInfo: userInfo.userInfo,
            setting: {
                userName: loginInfo.username,
                name: userInfo.userInfo.userName,
                autoLogin: LoginBox.isAutoLogin,
                rememberPwd: LoginBox.isRememberPwd,
                loginName: userInfo.userInfo.loginName
            }
        });
        iflybookModule.getBookCard(userInfo.userInfo.loginName);
        //notice center--zqwei
        if(APP_CONFIG.USE_NOTICE_CENTER){
            NoticeManager.checkNewMessageAvailable(userInfo);
        }
        //初始化备课模块相关参数
        ta.initAppConfig();
    }

    function afterOfflineLogin(userDetailInfo,loginInfo,type){
        var userInfo = userDetailInfo;
        onLoginFlag = 1;

        //解析userInfo的reserve1字段(需要用户openId信息)
        var reserve1 = JSON.parse(userInfo.userInfo.reserve1);
        var sso_openId = reserve1._sso_openId;

        //对用户信息进行加密
        var encryptedInfo = setEncryptedUserInfo(userInfo.userInfo.loginName,loginInfo.password);
        //加密信息保存到全局属性里
        userInfo.des_encrypted_userInfo = encryptedInfo.des_encrypted_userInfo;
        userInfo.rsa_encrypted_password = encryptedInfo.rsa_encrypted_password;
        //加密的用户信息 --edc接口设置用户级别授权
        encryptedInfo.sso_openId = sso_openId;
        edcService.Instance().setEncryptedUserInfo(encryptedInfo);

        //记录用户最后登录的时间戳
        userInfo.userInfo.lastLoginTime = getTimestamp();
        //第三个参数，是否离线登录标志
        _setUserState(userInfo, loginInfo, true, type);
        //TA的记住密码
        if(LoginBox.isRememberPwd) {
            loginInfoManager({
                type: 'write',
                loginInfo: loginInfo
            });
        }
        //同步到账号列表
        userSettingInfoAccess.add({
            userInfo: userInfo.userInfo,
            setting: {
                userName: loginInfo.username,
                name: userInfo.userInfo.userName,
                autoLogin: LoginBox.isAutoLogin,
                rememberPwd: LoginBox.isRememberPwd,
                loginName: userInfo.userInfo.loginName
            }
        });
    }

    /**
     * 用户login后，初始化备课本的用户的文件夹和数据库文件
     * added by linwang5
     * @param userName
     */
    function initUserFolderAndDb(userName,uid) {
        var uP = APP_CONFIG.BASE_PATH+'/user/'+userName;
        var dbsrc_P = APP_CONFIG.BASE_PATH+'/user/resource.db',
            dbdst_P = uP+'/resource.db',
            bP = uP+'/books';
        if(!fs.existsSync(uP)) fs.mkdirSync(uP);
        if(!fs.existsSync(bP)) fs.mkdir(bP);
        if(!fs.existsSync(dbdst_P)) shellcmd.copyFile(dbsrc_P,dbdst_P);
        //initAllBookMenu 初始化所有未同步到新备课本的目录信息 added by linwang5@iflytek.com 2017.02.16 11:12
        hproseClient.hproseNoti({method:'initAllBookMenu',data:{userName:userName,uid:uid}});

    }

    /**
     * 设置用户加密信息（包括des加密和rsa密码加密）
     * @param loginName,password
     * @returns {*}
     */
    function setEncryptedUserInfo(loginName,password){
        //将用户信息DES(key,loginName=password)加密存储到全局des_encrypted_userInfo --用于单点登录
        var plain_userInfo = loginName + '=' + password;
        var des_key = '';
        if(typeof TA != 'undefined' && $.isPlainObject(TA) && TA.UserService && TA.UserService.key){
            des_key = TA.UserService.key;
        }else{
            des_key = 'wyc4yrmK';
        }
        DES.init(des_key, plain_userInfo);
        var des_encrypted_userInfo = DES.Encrypt();

        //将用户明文密码RSA(key,password)加密存储到rsa_encrypted_password -- 用于用户级别授权接口
        //这里的RSA算法和sso登录的RSA算法一致，（n,e）
        var exponent = Edc_Cfg.EDC_SSORSAExponent;
        var modulus = Edc_Cfg.EDC_SSORSAModulus;
        var key = RSAUtils.getKeyPair(exponent, "", modulus);
        var rsa_encrypted_password = RSAUtils.encryptedString(key, password);
        return {loginName:loginName,des_encrypted_userInfo:des_encrypted_userInfo,rsa_encrypted_password:rsa_encrypted_password};
    }

    function ssoDataTranslate(sso_userInfo){
        var def = jQuery.Deferred();
        var result = {};
        var sso_userInfo = sso_userInfo;
        var sso_loginName = sso_userInfo.sso_loginName;
        var sso_userId = sso_userInfo.sso_userId;
        var sso_openId = sso_userInfo.sso_openId;
        // sso_userInfo.exchange_openId 是查询用户绑定接口得到的绑定用户openId
        var exchange_openId = sso_userInfo.exchange_openId;
        var sso_tgt = sso_userInfo.sso_tgt;

        var _openId = "",
            _user_id = "",
            _user_info = "",
            _user_type = "",
            _user_school = "",
            _user_freeClass = "",
            _user_orgClass = "",
            _user_org_detail = "";
        if(exchange_openId && exchange_openId != ''){
            _openId = exchange_openId;
            decryptId = decryptOpenId("4A91CBB9","4A91CBB9",exchange_openId,Edc_Cfg.EDC_appKey);
            _user_id = decryptId ? decryptId : sso_userId;
        }else{
            _openId = sso_openId;
            _user_id = sso_userId;
        }
        var param_user_type_get = {
            userId:_openId
        };
        edcService.Instance().core_user_type_get(param_user_type_get).done(function(ret){
            if(ret && ret.code == 0){
                _user_type = ret.data;
                var param_core_user_org_detail = {
                    openId: sso_openId,
                    userId: _openId
                };
                edcService.Instance().core_user_org_detail(param_core_user_org_detail).done(function(ret){
                    if(ret && ret.code == 0){
                        _user_org_detail = ret.data;
                        _user_school = _user_org_detail && _user_org_detail.extInfo && _user_org_detail.extInfo.school || [];
                        _user_freeClass = _user_org_detail && _user_org_detail.extInfo && _user_org_detail.extInfo.freeClass || [];
                        _user_orgClass = _user_org_detail && _user_org_detail.extInfo && _user_org_detail.extInfo.orgClass || [];
                        var userData = {
                            sso_userInfo:sso_userInfo,
                            user_info:_user_org_detail,
                            user_type:_user_type,
                            user_school:_user_school,
                            user_freeClass:_user_freeClass,
                            user_orgClass:_user_orgClass,
                            user_id:_user_id
                        };
                        result = format_core_user_data(userData);
                        def.resolve(result);
                    }else{
                        def.reject(e);
                    }
                }).fail(function(e){
                    def.reject(e);
                });
            }else{
                def.reject(e);
            }
        }).fail(function(e){
            def.reject(e);
        });
        return def.promise();
    }

    function format_core_user_data(userData) {
        var sso_userInfo = userData.sso_userInfo || {};
        var user_info = userData.user_info || {};
        var user_type_arr = userData.user_type || [];
        var _user_school_list_arr = userData.user_school || [];
        var _user_freeClass_list_arr = userData.user_freeClass || [];
        var _user_orgClass_list_arr = userData.user_orgClass || [];
        // 登录用户内部id
        var _user_id = userData.user_id || "";
        //示例结构
        var result = {
            statusCode:1,
            userInfo:{
                userExt:{},
                userPhotoSize:{},
                classInfo:[],
                freeClass:[]
            }
        };
        var enName = "";
        //用户身份类型，001机构用户，002行政教师用户，003行政学生用户，004家长用户，005自由老师，006自由学生
        if (Object.prototype.toString.apply(user_type_arr) === '[object Array]') {
            //用户身份为空，默认允许登录
            if(user_type_arr.length == 0){
                enName = "teacher";
            }else{
                var _teacher_type_arr = user_type_arr.filter(function(el){
                    return el.code == '005' || el.code == '002';
                });
                if(_teacher_type_arr.length > 0){
                    enName = "teacher";
                }
            }
        }
        result.userInfo = {
            "id": _user_id,
            "_sso_loginName": sso_userInfo.sso_loginName,
            "_sso_openId": sso_userInfo.sso_openId,
            "_sso_userId": sso_userInfo.sso_userId,
            "_sso_tgt": sso_userInfo.sso_tgt,
            "des_encrypted_userInfo": sso_userInfo.des_encrypted_userInfo,
            "rsa_encrypted_password": sso_userInfo.rsa_encrypted_password,
            "_user_openId": user_info.id,
            "_user_userType": user_type_arr,
            "_user_exchange_openId": sso_userInfo.exchange_openId,
            "_user_userAppName": user_info.appName,
            "delFlag": "", //--
            "loginName": user_info.loginName,
            "email": user_info.loginEmail,
            "mobile": user_info.loginMobile,
            "userCode": null, //--
            "userName": user_info.userName,
            "gender": user_info.gender,
            "phone": user_info.displayMobile, //--
            "pinyinName": user_info.pinyinName,
            "birthDate": user_info.birthDate,
            "im": user_info.im,
            "homeAddress": user_info.homeAddr,
            "idCardNo": user_info.idCardNo,
            "remark": "", //--
            "appName": "", //--
            "creator": "", //--
            "createTime": "", //--
            "modificator": "", //--
            "updateTime": "", //--
            "grade": "",//--
            "subject": "",//--
            "enName": enName,
            "userPhoto": user_info.userPhoto,
            "avatar": user_info.userPhoto,
            "loginCount": user_info.loginCount,
            "userExt":{},
            "userPhotoSize":{},
            //老的userInfo里只存储了行政班级的班级列表，不存储自由班级列表，这里沿用以前数据结构
            "classInfo":[],
            "freeClass":[] //自由班级
        };
        result.userInfo.userPhotoSize = user_info.userPhotoSize || {};
        //判断用户是否有学校
        if(_user_school_list_arr.length > 0) {
            var userExt = _user_school_list_arr[0];
            result.userInfo.userExt = {
                "schoolName": userExt.schoolName,
                "schooldCode": userExt.id, //老的数据命名就是这样...
                "province": "",//--
                "city": "",//--
                "district": "",//--
                "provinceName": userExt.provinceName,
                "cityName": userExt.cityName,
                "districtName": userExt.districtName,
                "provinceId": userExt.provinceId,
                "cityId": userExt.cityId,
                "districtId": userExt.districtId
            };
        }else{
            result.userInfo.userExt = {};
        }
        for(i = 0,count = _user_orgClass_list_arr.length;i < count;i++){
            var item = _user_orgClass_list_arr[i];
            var rs = {
                "classCode" : item.classShortId || "",
                "classShortId" :item && item.classShortId  || "",
                "classId" : item.id || "",
                "className" : item.className || "",
                "shortName" : item.shortName || "",
                "eduSystem" : item.eduSystem || "",
                "classLabel" : item.classLabel || "",
                "classOrder" : item.classOrder || "",
                "passed" : item.passed || "",
                "createTime" : "undefined",
                "phase" : item.phase || "",
                "schoolId" : item.schoolId || "",
                "schoolName" : "undefined",
                "studentCount" : "undefined",
                "subject" : "undefined",
                "subjectName" : "undefined",
                "year" : item.year || "",
                "extInfo" : item.extInfo || ""
            };
            result.userInfo.classInfo.push(rs);
        }
        //这里对自由班级做格式化处理，是为了在后期班级合并展示时避免兼容性问题
        for(i = 0,count = _user_freeClass_list_arr.length;i < count;i++){
            var item = _user_freeClass_list_arr[i];
            var rs = {
                "classCode" : item.classShortId || "undefined",
                "classShortId" :item.classShortId || "",
                "classId" : item.id || "",
                "className" : item.className || "",
                "shortName" : "undefined",
                "eduSystem" : "undefined",
                "classLabel" : "undefined",
                "classOrder" : "undefined",
                "passed" : "undefined",
                "createTime" : "undefined",
                "grade" : item.grade || "",
                "phase" : item.phase || "",
                "schoolId" : item.schoolId || "",
                "schoolName" : "undefined",
                "studentCount" : "undefined",
                "subject" : "undefined",
                "subjectName" : "undefined",
                "year" :item.year || "",
                "extInfo" :item.extInfo || ""
            };
            result.userInfo.freeClass.push(rs);
        }
        return result;
    }

    function decryptOpenId(key,iv,openid,appkey){
        if(!key || !iv || !openid || !appkey){
            return false;
        }
        var inner_id;
        try{
            var decryptContent = CryptoJSBrowser.decryptByTripleDESCBC(key,iv,openid) + "";
            var index = decryptContent.indexOf('_');
            if (index != -1 && decryptContent.substring(index+1) == appkey) {
                inner_id = decryptContent.substring(0, index);
                return inner_id;
            }
            return false;
        }catch(e){
            console.error(e);
            return false;
        }
    }

//监听注册成功
    taEmitter.on(TA_EVENT.REGISTER_SUCCESS, function (registerInfo) {
        if (registerInfo == "login") {
//            $("#login_box").show();
            loginAndCurtain(true);
            $("#loginwarn").html("");
            $("#loginwarn").hide();
            $("#login_username").val("");
            $("#login_password").val("");
            return 0;
        } else if (registerInfo == "noNet") {
            dNetworkPanel.show();
            return 0;
        }
        var loginInfo = {'username': registerInfo[0], 'password': registerInfo[2]};
        onLoginFlag = 0;
        ifsrun = 0;
        if(registerInfo[3]=="phone"){
            //手机注册则登陆
            go_login(loginInfo, 0);
        }
        registerSuccessDia(registerInfo[0],registerInfo[1], registerInfo[3]);
    });

//监听反馈
    taEmitter.on(TA_EVENT.FEEDBACK_SUCCESS, function (info) {
        console.log(info);
        feedbackDialogShow();
    });
    //保存头像到本地，下次自动拉取 created by linwang5
    function saveImageToLocal(ImageUrl, $login) {
        console.log(ImageUrl);
        var http = require('http');
        var fs = require('fs');

        http.get(ImageUrl, function (res) {
            var imgData = "";

            if(res.statusCode == 200) {
                res.setEncoding("binary"); //一定要设置response的编码为binary否则会下载下来的图片打不开
                res.on("data", function (chunk) {
                    imgData += chunk;
                });

                res.on("end", function () {
                    userSettingInfoAccess.read().done(function(settinginfo) {
                        var loginName = $login.userInfo.loginName;
                        // var loginName = [$login.userInfo.loginName, $login.userInfo.mobile, $login.userInfo.email].indexOf(settinginfo.loginHistory[0]) == -1 ? undefined : settinginfo.loginHistory[0];
                        // loginName && fs.writeFile(APP_CONFIG.BASE_PATH + "/user/" + loginName + "/photo.png", imgData, "binary", function (err) {
                        loginName && fs.writeFile(APP_CONFIG.BASE_PATH + "/user/" + loginName + "/photo.png", imgData, "binary", function (err) {
                            if (err) {
                                console.log("save fail");
                            }
                            console.log("save success");
                        });
                    });
                });
            }
        });
    }

    /**
     * 设置用户登录后的UI表现
     * @private
     */
    function _setUserState($login, loginInfo,localLogin,type) {
        // 设置登录完成标记
        LoginBox.setLoginStatus(2);

        // 王哒哒修改
        // 关闭主界面
        var gui = require("nw.gui")
        var win = gui.Window.get()
        win.hide()
        // 打开书架页面
        // var appManager = APPManager.getInstance()
        // appManager.runApp({
        //     id: "62"
        // });
         // 打开书架页面
        $("#openIflybook").trigger("click")
        console.log(3323)

        if(localLogin){
            var reserve1 = JSON.parse($login.userInfo.reserve1);
            delete reserve1.userPhoto;
            reserve1._sso_tgt = undefined;
            $login.userInfo = $.extend(reserve1,$login.userInfo);
        }
        shellcmd.log('登录::登录后用户信息：' + JSON.stringify(loginInfo.username));
        if($login && $login.userInfo){
            startFloatToolbar();
            /*pageMyInteract.userInfo = $login.userInfo;
             pageMyInteract.userId = $login.userInfo.id;
             pageMyInteract.userName = $login.userInfo.userName;
             pageMyInteract.role = $login.userInfo.enName;
             pageMyInteract.afterLogin();

             pageMyPrepare.afterLogin($login.userInfo);

             pageMyHomework.userInfo = $login.userInfo;
             pageMyHomework.afterLogin();

             pageMyZhiXue.userInfo = $login.userInfo;
             pageMyZhiXue.afterLogin();*/

            createUserFolder($login.userInfo.id);

            /*pageClassTeach.userInfo = $login.userInfo;
             pageClassTeach.afterLogin(localLogin);*/
            pageClassPrepare.userInfo = $login.userInfo;
            pageClassPrepare.afterLogin(localLogin);

            /*pageClassAttend.userInfo = $login.userInfo;
             pageClassAttend.afterLogin(localLogin);*/
            pageClassAttend.userInfo = $login.userInfo;
            pageMyPrepare.userInfo = $login.userInfo;

            userInfo = $login.userInfo;  //这里为Appmanage设置UserInfo，这里是部分信息

            //创建TA的书本数据库
            createBookDB();

            //处理ifb登陆后信息
            //点数和本数
            if(!localLogin){
                iflybookModule.getPointsAndBooks(loginInfo.username).done(function(result){
                    userInfo.points = result.points;
                    userInfo.books = result.books;

                    //创建用户文件夹时，没有创建license文件，因此要在登陆的时候添加
                    iflybookModule.writeUserLic();
                    iflybookModule.StartUpload();
                });
            }


            //更新TA本地用户信息（仅限在线登录并且是密码登录）
            if(!localLogin && (type == MainLoginModel.PASSWORD || type == MainLoginModel.CR)){
                var id = $login.userInfo && $login.userInfo.id;
                if(id){
                    userDbAccess.update(id,$login.userInfo,loginInfo);
                }else{
                    console.error('在线登录成功后,更新本地数据库错误');
                }
            }
        }
        //登录信息，用于单点登录
        if ($login) {
            loginInfo = {'username': loginInfo.username, 'password': loginInfo.password};
        }
        $login && (TA.UserService.setLoginInfo(JSON.stringify(loginInfo), function(){
            //用户信息记录本地文件后再同步APPbox的信息
            taEmitter.emit(TA_EVENT.APPBOX_LOGIN_IN + ".appbox.false"); //这里为appbox设置userInfo
        }));
        $login && (TA.UserService.setUserInfo(JSON.stringify($login.userInfo), function(){
            socket.send({type : TYPE.LOGIC, action : CMD.TAMSG_LOGIN, data : {url:APP_CONFIG.MESSAGE_STATISTICS+$login.userInfo.id,uid:$login.userInfo.id}});
            //登录成功后检测蓝牙状态
            var json= {
                type : "logic",
                action : "bt_info",
                from : "ta",
                to : "all",
                data : {
                }
            }
            socket.send(json);
            //ifs启动成功则给其发用户信息
            if(ifsrun == 1){
                Login.sendUserInfo($login.userInfo);
            }
        }));
        $("#user_info").show();
        //用于切换用户还原默认头像
        $("#dl_zc").hide();
        $("#login_name").html($login ? $login.userInfo.userName : loginInfo.username);
//        $("#login_box").hide();
        $("#_page_main").show();
        loginAndCurtain(false);
        if ($login) {
            if ($login.userInfo.userPhotoSize != null) {
                //外网访问替换图片内网地址start
                var in_RESOURCE_ADDRESS = "http://172.16.81.43:4301/";
                var display_avatar = $login.userInfo.userPhoto || "";
                if(-1 !=  display_avatar.indexOf(in_RESOURCE_ADDRESS)){
                    display_avatar = display_avatar.replace(in_RESOURCE_ADDRESS,APP_CONFIG.RESOURCE_ADDRESS);
                }
                //外网访问替换图片内网地址end
                //修改成功

                if(display_avatar){
                    var tempStr =display_avatar +"?"+Math.random().toString();
                }else{
                    var tempStr = "assets/images/user.jpg";
                }
                //根据ID更改头像
                $("#user_photo").attr("src", tempStr);
                console.log(tempStr);
                // 将用户图像url保存到本地，快速登录可以快速获取头像
                tempStr.replace(/\?.*/, '') && saveImageToLocal(tempStr, $login);
            }
        }
        //登录时关闭正在使用的app
        for(var s in TA.Stage.stages) {
            if((s.indexOf('app_') != -1) && (s.indexOf('app_62') == -1)) {
                TA.Stage.stages[s] && TA.Stage.stages[s].kill();
            }
        }
    }

    function sendUserInfo(userInfo){
        var nickName=decodeURIComponent(userInfo.userName);//昵称
        var loginName=userInfo._sso_loginName;//用户名
        var userId=userInfo._sso_userId;//用户id
        var json={
            type : "logic",
            action : "signin",
            from : "ta",
            to : "all",
            data : {
                uuid:userId,
                openid:userInfo._sso_openId,
                user_name:loginName,
                nickname:nickName,
                user_app_name: userInfo._user_userAppName,
                sso_loginName: userInfo._sso_loginName,
                rsa_encrypted_password: userInfo.rsa_encrypted_password,
                sso_openId: userInfo._sso_openId,
                exchangeOpenId: userInfo._user_exchange_openId,
                openApiToken: edcService.Instance().AccessTokenCache,
                openApiServer: Easy_Cfg.EASYSVC,
                openApiTokenServer: Easy_Cfg.OAUTH_TOKEN_SERVER,
                eshopServer: Base_Cfg.ESHOP,
                itaServer: Base_Cfg.ITA_BASE,
                grantType:'password', //鉴权类型 enum('client_credentials','password')
                school:{
                    provinceName:userInfo.userExt.provinceName,
                    provinceId:userInfo.userExt.provinceId,
                    cityName:userInfo.userExt.cityName,
                    cityId:userInfo.userExt.cityId,
                    districtName:userInfo.userExt.districtName,
                    districtId:userInfo.userExt.districtId,
                    schoolName:userInfo.userExt.schoolName,
                    schoolCode:userInfo.userExt.schooldCode //这里就是schooldCode命名额
                },
                orgClass:userInfo.classInfo,
                freeClass:userInfo.freeClass
            }
        }
        socket.send(json);
    }


    //检测授权是否已过期
    /* function checkAuthorize(outDate,createTime){
     outDate=new Date("2016-07-05");
     createTime=new Date("2015-06-05");
     var outYear=outDate.getFullYear();
     var outMonth=outDate.getMonth();
     var outDay=outDate.getDate();
     var createYear=createTime.getFullYear();
     var createMonth=createTime.getMonth();
     var createDay=createTime.getDate();
     var difYear=outYear-createYear;
     var difMonth=outMonth-createMonth;
     var difDay=outDay-createDay;
     if(difYear==0){
     //已过试用期提醒
     }else if(difYear==1&&difMonth<0){
     //已过试用期提醒
     }else if(difYear==1&&difMonth==0&&difDay<0){
     //已过试用期提醒
     }else if(difYear==1&&difMonth==0&&difDay>=0){
     //授权即将过期
     if(difDay<=15){
     //授权即将过期提醒
     }
     }else if(difYear==1&&difMonth>0){
     //授权即将过期
     }else if(difYear>1){
     授权即将过期
     }

     }*/


    //创建书本db和文件
    function createBookDB(){
        var ifbDBPath = APP_CONFIG.IFB_PATH + "users/icw_template.db";
        var ifbBookMenuPath = APP_CONFIG.IFB_PATH + "users/13170425-022/13170425-022.menu";
        var ifbBookPicPath = APP_CONFIG.IFB_PATH + "users/13170425-022/13170425-022_Thumbnail.png";

        var taDBPath = APP_CONFIG.PPTICWS_PATH + userInfo.id + "/book.db";
        var taBookPath = APP_CONFIG.PPTICWS_PATH + userInfo.id + "/book/13170425-022";
        var taBookMenuPath = taBookPath + "/13170425-022.menu";
        var taBookPicPath = taBookPath + "/13170425-022_Thumbnail.png";

        shellcmd.fileOrDirExist(taDBPath).done(function(exist){
            if(!exist){
                shellcmd.mkdirs(taBookPath,0777,function(){
                    shellcmd.copyFile(ifbDBPath,taDBPath).done(function(){
                        shellcmd.copyFile(ifbBookMenuPath,taBookMenuPath).done(function(){
                            shellcmd.copyFile(ifbBookPicPath,taBookPicPath);
                        });
                    })
                });
            }
        })
    }


    //创建用户课件库文件夹
    function createUserFolder(uid){
        var folerpath = APP_CONFIG.PPTICWS_PATH + uid + "/";

        fs.exists(folerpath, function (exist) {
            if(exist){
                copydb();
            }
            else{
                fs.mkdir(folerpath,function(){
                    copydb();
                })
            }
        });

        function copydb(){
            var userdbpath = folerpath + "file.db";
            fs.exists(userdbpath, function (exist) {
                if(exist){
                }
                else{
                    shellcmd.copyFile(APP_CONFIG.PPTICWS_DB_PATH,userdbpath);
                }
            });
        }
    }

    //更新本地用户
    function updateLocalUser(userInfo,loginInfo){
        var userInfo_ext = JSON.stringify(userInfo);
        // userInfo_ext = userInfo_ext.replace(/"/g,'\\"');
        // userInfo_ext = eval("'"+userInfo_ext+"'");
        var dbpath = APP_CONFIG.BASE_PATH + "/user/user.db";
        if (fs.existsSync(dbpath)) {
            var db = new sqlite3.Database(dbpath);
            var sql;

            db.all("SELECT * FROM users", function (err, rows) {
                if(!err){

                    DES.init(APP_CONFIG.DESKEY,userInfo.loginName + "=" + loginInfo.password);
                    var password = DES.Encrypt();

                    for (var i = 0, len = rows.length; i < len; i++) {
                        if(userInfo.loginName == rows[i].loginName){
                            sql = 'update users set '
                                + 'userName="' + userInfo.userName + '",'
                                + 'loginName="' + userInfo.loginName + '",'
                                + 'password="' + password + '",'
                                + 'email="' + userInfo.email + '",'
                                + 'phone="' + userInfo.mobile + '",'
                                + 'isActive="' + userInfo.isActive + '",'
                                + 'schoolName="' + userInfo.userExt.schoolName + '",'
                                + 'enName="' + userInfo.enName + '",'
                                + 'reserve1=\'' + userInfo_ext + '\''
                                + ' where id="' + userInfo.id + '"';
                            db.run(sql);
                            return;
                        }
                    }

                    sql = 'insert into users(id,userName,loginName,password,email,phone,isActive,schoolName,enName,reserve1) values("'
                        + userInfo.id + '","'
                        + userInfo.userName + '","'
                        + userInfo.loginName + '","'
                        + password  + '","'
                        + userInfo.email + '","'
                        + userInfo.mobile + '","'
                        + userInfo.isActive + '","'
                        + userInfo.userExt.schoolName + '","'
                        + userInfo.enName + '",\''
                        + userInfo_ext +'\')';
                    db.run(sql);
                }
            })
        }
    }

    //离线登陆
    function localLogin(loginName,pwd,type){
        var dbpath = APP_CONFIG.BASE_PATH + "/user/user.db";
        if (fs.existsSync(dbpath)) {
            var db = new sqlite3.Database(dbpath);
            db.all("SELECT * FROM users", function (err, rows) {
                if(!err){
                    if(type=="mobile"){
                        type="phone";
                    };
                    for (var i = 0, len = rows.length; i < len; i++) {
                        var userInfo = rows[i];
                        if(loginName == userInfo[type]){

                            DES.init(APP_CONFIG.DESKEY,userInfo.password);
                            var result = decodeURIComponent(DES.Encrypt("Decrypt")).split("=");
                            var password = result[1];

                            if(pwd == password){
                                var $login = {};
                                var info = {
                                    password: password,
                                    username: userInfo.loginName
                                };
                                $login.userInfo = userInfo;
                                onLoginFlag = 1;

                                //解析userInfo的reserve1字段(需要用户openId信息)
                                var userDetailInfo = JSON.parse(userInfo.reserve1);
                                var sso_openId = userDetailInfo._sso_openId;

                                //对用户信息进行加密
                                var encryptedInfo = setEncryptedUserInfo(info.username,info.password);
                                //加密信息保存到全局属性里
                                userInfo.des_encrypted_userInfo = encryptedInfo.des_encrypted_userInfo;
                                userInfo.rsa_encrypted_password = encryptedInfo.rsa_encrypted_password;
                                //加密的用户信息 --edc接口设置用户级别授权
                                encryptedInfo.sso_openId = sso_openId;
                                edcService.Instance().setEncryptedUserInfo(encryptedInfo);

                                _setUserState($login,info,true);//第三个参数，是否离线登录标志
                                //TA的记住密码
                                if(LoginBox.isRememberPwd) {
                                    loginInfoManager({
                                        type: 'write',
                                        loginInfo: {
                                            password: password,
                                            username: loginName
                                        }
                                    });
                                }
                                //同步到账号列表
                                loginSetting({
                                    type: 'add',
                                    userInfo: userInfo,
                                    setting: {
                                        userName: loginName,
                                        name: userInfo.userName,
                                        autoLogin: LoginBox.isAutoLogin,
                                        rememberPwd: LoginBox.isRememberPwd,
                                        loginName: userInfo.userInfo.loginName
                                    }
                                });
                            }else{
                                // 刷新验证码
                                LoginBox.refreshVerifyCode();
                                $("#loginwarn").show().html('<i class="iconfont">&#xe60b;</i><div class="tips-inner"><em>账号、密码错误</em></div>');
                            }
                            return;
                        }
                    }
                    //$("#loginwarn").show().html('<i class="iconfont">&#xe60b;</i><div class="tips-inner"><em>账号、密码错误</em></div>');
                }
            });
        }
    }

    //获取时间戳
    function getTimestamp() {
        return parseInt(new Date().getTime() / 1000) + '';
    };

    //字典排序
    function keySort(args) {
        var keys = Object.keys(args);
        keys = keys.sort()
        var newArgs = {};
        keys.forEach(function (key) {
            newArgs[key.toLowerCase()] = args[key];
        });
        return newArgs;
    };

    //字符串进行rfc3968转换
    function rfc3986(str) {
        return encodeURIComponent(str)
            .replace(/!/g,'%21')
            .replace(/\*/g,'%2A')
            .replace(/\(/g,'%28')
            .replace(/\)/g,'%29')
            .replace(/'/g,'%27');
    }

    /**
     * sha1签名
     * @param dic 对象数组/字符串
     */
    function sha1_sign(dic){
        if(dic != null && typeof dic === "object"){
            //字典排序
            var sortedDic = keySort(dic);
            //url参数编码
            var string = jQuery.param(sortedDic);
            //rfc3986 格式转换
            var encodeString = rfc3986(string);
        }else{
            var encodeString = dic + '';
        }
        //sha1 签名
        try{
            var signature = CryptoJS.enc.Hex.stringify(CryptoJS.SHA1(encodeString));
        }catch(e){
            var signature = false;
            console.error('不支持SHA1签名算法');
        }
        return signature;
    }

    //获取登录信息的sha1签名(异步)
    function sha1_loginInfo(loginName, pwd, timestamp){
        var def = jQuery.Deferred();
        //sha1签名标准格式
        var struct = {
            mac: '00-00-00-00-00-00',
            username: loginName || '',
            password: pwd || '',
            timestamp: timestamp || ''
        }
        var mac = require('getmac');
        //获取机器mac地址
        mac.getMac(function(err, macAddress){
            if (err){
                console.error('获取本机mac地址失败');
            }else{
                struct.mac = macAddress;
            }
            var sign = sha1_sign(struct);
            def.resolve(sign);
        });
        return def.promise();
    }

    /**
     * 登录框
     * @type {Object}
     */
    var LoginBox = {
        isAutoLogin: false,     //登录框是否选择自动登录
        isShowList: false,       //是否显示登录列表
        isRememberPwd: false,       //登录框是否选择记住密码
        loginModel: MainLoginModel.PASSWORD, //登录类型
        loginStatus: 0, //登录状态 0-未登录 1-登录中 2-登录完成
        /*fastLoginDom: $("#fastLogin"),     //快速登录DOM*/
        confirmLoginDom: $("#confirmLogin"),      //确认登录DOM
        loginDom: $("#login_box"),      //登录DOM
        loginFormMask: $("#J_mainLoginFormMask"),      //登录遮罩DOM
        avatarDom: $("#loginBoxPhoto"), //用户头像DOM
        accountDom: $('#login_username'), //用户账户输入区DOM
        pwdDom: $('#login_password'), //用户密码输入区DOM
        autoLoginDom: $("#J_autoLoginCheck"), //自动登录checkbox DOM
        rememberPwdDom: $("#J_rememberPwdCheck"), //记住密码checkbox DOM
        accountHistoryDom: $("#loginList"), //历史账号 i DOM
        verifyCodeDom: $("#J_verifyCode"), //验证码输入区 DOM
        verifyImgDom: $("#J_verifyCodeImg"), //验证码图像 DOM
        verifyCodeChangeDom: $("#J_verifyCodeChange"), //验证码更新 DOM
        loginButtonDom: $("#btn_login_ok"), //登录按钮 DOM
        loginWarnDom: $('#loginwarn'), //错误提示区 DOM
        isCheckAccount: false,     //是否检测匹配账号 过滤Backspace
        loginFormMaskClickTime: 0, //最后点击遮盖的时间戳
        loginFormMaskClickCount: 0, //点击遮盖的次数
        currentTips:'', //当前提示语
        setAutoLogin: function(set) {
            var _this = this;
            var flag = (set != undefined) ? set : !_this.isAutoLogin;
            _this.isAutoLogin = flag;
            $(_this.autoLoginDom).attr('checked',flag).prop('checked',flag);
            //未设置记住密码，设置自动登录时同时设置记住密码
            if(!_this.isRememberPwd && flag){
                _this.setRememberPwd(true);
            }
        },
        setRememberPwd: function(set) {
            var _this = this;
            var flag = (set != undefined) ? set : !_this.isRememberPwd;
            _this.isRememberPwd = flag;
            $(_this.rememberPwdDom).attr('checked',flag).prop('checked',flag);
            //设置自动登录时取消记住密码，则同时取消自动登录
            if(_this.isAutoLogin && !flag){
                _this.setAutoLogin(false);
            }
        },
        /**
         * 设置登录状态
         */
        setLoginStatus: function(status){
            var _this = this;
            _this.loginStatus = status;
            // 未登录（取消登录）或者登录成功
            if(status == 0 || status == 2){
                _this.showLoginFormMask(false);
                $(_this.loginButtonDom).find("i").css({"display":"none"});
            }else{
                // 登录中
                _this.showLoginFormMask(true);
                if(!$(_this.loginButtonDom).find("i").is(":visible")){
                    $(_this.loginButtonDom).find("i").css({"display":"inline"});
                }
            }
        },

        /**
         * 设置用户账号登录类型
         */
        setLoginModel: function(model){
            var _this = this;
            var allModel = [];
            for(m in MainLoginModel){
                allModel.push(MainLoginModel[m]);
            }
            if(-1 == $.inArray(model,allModel)){
                _this.loginModel = MainLoginModel.PASSWORD;
            }else{
                _this.loginModel = model;
            }
        },
        /**
         * 登录框初始化
         */
        init: function(account) {
            var _this = this;
            //初始化登录流程
            LoginBox.setLoginStatus(0);
            // 生成验证码
            _this.generateVerifyCode();

            userSettingInfoAccess.read().done(function(settinginfo) {
                if(account){
                    var userName = account;
                }else{
                    var userName = settinginfo.loginHistory ? settinginfo.loginHistory[0] : '';   //上一次登录的账号
                }
                var userSetting = settinginfo[userName];
                _this.setShowList(false);
                if(userSetting){
                    _this.receiptAccount(userSetting);
                }else{
                    //初始化账户信息
                    _this.resetAccount();
                }
            });
        },
        /**
         * 显示快速登录or显示登录框
         */
        initLogin: function() {
            userSettingInfoAccess.read().done(function(settinginfo) {
                var loginHistory = settinginfo.loginHistory || [],
                    fastUsers = { loginHistory: [] };
                for(var i=0,len=loginHistory.length; i<len; i++) {
                    var userName = settinginfo.loginHistory[i];
                    if(settinginfo[userName].rememberPwd == true) {
                        fastUsers.loginHistory.push(settinginfo.loginHistory[i]);
                        fastUsers[userName] = settinginfo[userName];
                    }
                }
                LoginBox.init();
                // fastUsers.loginHistory.length > 0 ? LoginBox.fastLogin(fastUsers) : LoginBox.login(true);
            });
        },
        /**
         * 快速登录框
         * @param fastUsers 需要快速登录的 users
         */
        /*fastLogin: function(fastUsers) {
         var isDirectLogin = fastUsers.loginHistory.length == 1 ? true : false,
         dom = '<li><a href="javascript:void(0);"><img  src="{src}" width="88" height="88" onerror="this.src=\'assets/images/user.jpg\'" /></a><span>{userName}</span></li>',
         $dom = '',
         userList = [],
         that = this,
         index = 0,     //开始显示用户的位置
         photoSrc = '';

         /!*$("#mask_layer").show();*!/
         that.fastLoginDom.show();
         initUserList(function (){
         showListView();

         APPManager.onlineFlag ?  $('#fastLoginwarn').text('') : $('#fastLoginwarn').text('您当前已处于离线状态');
         //显示的用户超过3个显示两侧箭头
         if(fastUsers.loginHistory.length > 3) {
         that.fastLoginDom.find('.tx-prve-btn').show().unbind('click').on('click', function (){
         fadeleft();
         });

         that.fastLoginDom.find('.tx-next-btn').show().unbind('click').on('click', function (){
         faderight();
         });
         } else {
         that.fastLoginDom.find('.tx-prve-btn').hide();
         that.fastLoginDom.find('.tx-next-btn').hide();
         }
         //切换账号
         that.fastLoginDom.find('.acount').unbind('click').on('click', function (){
         that.fastLoginDom.addClass('flip');
         that.fastLoginDom.addClass("out").removeClass("in");
         that.loginDom.addClass('flip');

         setTimeout(function() {
         that.loginDom.addClass("in").removeClass("out");
         that.login(true, true);
         that.fastLoginDom.removeClass("out").hide();

         setTimeout(function() {
         that.loginDom.removeClass("in");
         },225);
         }, 225);
         });
         });

         function initUserList(callback){
         for(var i=0,len=fastUsers.loginHistory.length; i<len; i++) {
         var userName = fastUsers.loginHistory[i],
         name = fastUsers[userName].name || userName,
         path = APP_CONFIG.BASE_PATH + "/user/" + userName + "/photo.png";
         photoSrc = fs.existsSync(path) ? path : APP_CONFIG.BASE_PATH + "/main/assets/images/user.jpg";
         $dom = $(dom.replace('{src}', photoSrc).replace('{userName}', name));
         userList.push($dom);
         }
         callback && callback();
         }

         function showListView() {
         $('#userList').html('');
         for(var i=index,len=index+3; i<len; i++) {
         $('#userList').append(userList[i]);
         }
         // < 是否灰显
         if(index > 0) {
         that.fastLoginDom.find('.tx-prve-btn').hasClass('gray') && that.fastLoginDom.find('.tx-prve-btn').removeClass('gray');
         } else {
         !that.fastLoginDom.find('.tx-prve-btn').hasClass('gray') && that.fastLoginDom.find('.tx-prve-btn').addClass('gray');
         }
         // > 是否灰显
         if(fastUsers.loginHistory.length > index+3) {
         that.fastLoginDom.find('.tx-next-btn').hasClass('gray') && that.fastLoginDom.find('.tx-next-btn').removeClass('gray');
         } else {
         !that.fastLoginDom.find('.tx-next-btn').hasClass('gray') && that.fastLoginDom.find('.tx-next-btn').addClass('gray');
         }
         //点击图像进入确认登录或直接登录
         $('#userList').find('li').unbind('click').on('click', function (){
         var name = $(this).find('span').text(),
         userSetting = {};

         for(var i=0,len=fastUsers.loginHistory.length; i<len; i++) {
         if(fastUsers[fastUsers.loginHistory[i]].name == name || fastUsers[fastUsers.loginHistory[i]].userName == name) {
         userSetting = fastUsers[fastUsers.loginHistory[i]];
         break;
         }
         }

         if(isDirectLogin) {
         loginInfoManager({
         type: 'read',
         loginInfo: {
         username: userSetting.userName
         },
         success: function(loginInfo) {
         that.isAutoLogin = userSetting.autoLogin;
         that.isRememberPwd = userSetting.rememberPwd;
         go_login(loginInfo, 1);
         $('#mask_layer').hide();
         that.fastLoginDom.hide();
         }
         });
         } else {
         that.fastLoginDom.hide();
         that.confirmLogin(userSetting);
         }
         });
         }

         function fadeleft() {
         if(index > 0) {
         index--;
         showListView();
         }
         }

         function faderight() {
         if(index < userList.length -3) {
         index++;
         showListView();
         }
         }
         },*/
        /**
         * 确认登录框
         */
        confirmLogin: function(userSetting){
            var dom = '<li><a href="javascript:void(0);"><img src="{src}" width="88" height="88" onerror="this.src=\'assets/images/user.jpg\'"/></a><span>{userName}</span></li>',
                userName = userSetting.userName,
                name = userSetting.name || userName,
                path = APP_CONFIG.BASE_PATH + "/user/" + userName + "/photo.png",
                that = this;
            $('#confirmUser').html('');
            that.confirmLoginDom.show();
            fs.exists(path, function (exist){
                var photoSrc = exist ? path : APP_CONFIG.BASE_PATH + "/main/assets/images/user.jpg",
                    $dom = dom.replace('{src}', photoSrc).replace('{userName}', name);
                $('#confirmUser').append($dom);
                //登录
                $('#onConfirmLogin').unbind('click').on('click', function (){
                    loginInfoManager({
                        type: 'read',
                        loginInfo: {
                            username: userName
                        },
                        success: function(loginInfo) {
                            that.isAutoLogin = userSetting.autoLogin;
                            that.isRememberPwd = userSetting.rememberPwd;
                            go_login(loginInfo, 1);
                            $('#mask_layer').hide();
                            that.confirmLoginDom.hide();
                        }
                    });
                });
                //返回
                that.confirmLoginDom.find('.login-back').unbind('click').on('click', function (){
                    that.confirmLoginDom.hide();
                    /*that.fastLoginDom.show();*/
                });

                //切换账号
                that.confirmLoginDom.find('.acount').unbind('click').on('click', function (){
                    that.confirmLoginDom.addClass('flip');
                    that.confirmLoginDom.addClass("out").removeClass("in");
                    that.loginDom.addClass('flip');

                    setTimeout(function() {
                        that.loginDom.addClass("in").removeClass("out");
                        that.login(true, true);
                        that.confirmLoginDom.removeClass("out").hide();

                        setTimeout(function() {
                            that.loginDom.removeClass("in");
                        },225);
                    }, 225);
                });
            });
        },
        /**
         * 直接登录框
         */
        login: function(loginFlag, isFromFastLogin) {
            if(loginFlag) {
                /* $("#mask_layer").show();*/
                $("#login_username").val("");
                $("#login_password").val("");
                LoginBox.loginDom.show();
                $('#loginBoxPhoto').attr('src', APP_CONFIG.BASE_PATH + "/main/assets/images/user.jpg");
                // APPManager.onlineFlag ? $("#loginwarn").hide() : $("#loginwarn").show().html("您当前已处于离线状态");
                // APPManager.onlineFlag ? $("#loginwarn").hide() : $("#loginwarn").show().html('<i class="iconfont">&#xe60b;</i><div class="tips-inner"><em>您当前已处于离线状态</em></div>');

                LoginBox.init();
                if(isFromFastLogin) {
                    LoginBox.loginDom.find('.login-back').show().unbind('click').on('click', function (){
                        LoginBox.loginDom.addClass('flip');
                        LoginBox.loginDom.addClass("out").removeClass("in");
                        /*LoginBox.fastLoginDom.addClass('flip');*/
                        setTimeout(function() {
                            /*LoginBox.fastLoginDom.addClass("in").removeClass("out");*/
                            LoginBox.initLogin();
                            LoginBox.loginDom.removeClass("out").hide();
                            /*  setTimeout(function() {
                             LoginBox.fastLoginDom.removeClass("in");
                             },225);*/
                        }, 200);   //这里不设置225是因为保证快速登录数据最新，有些延迟，因而缩短时间
                    });
                } else {
                    LoginBox.loginDom.find('.login-back').hide();
                }
                $(document).on('click', LoginBox.loginDom, function() {
                    LoginBox.setShowList(false);
                });
            } else {
                $("#mask_layer").hide();
                LoginBox.loginDom.hide();
            }
        },
        /**
         * 设置显示列表图标
         */
        setShowList: function(set) {
            var _this = this;
            var isShow = (set != undefined) ? set : !_this.isShowList;
            _this.isShowList = isShow;
            if(isShow) {
                _this.accountList();
                $(_this.accountHistoryDom).html('').html("&#xe609;");
            } else {
                $(_this.loginDom).find('.history-userlist').hide().html('');
                $(_this.accountHistoryDom).html('').html("&#xe60c;");
            }
        },
        /**
         * 账号列表管理
         */
        accountList: function() {
            var that = this;
            userSettingInfoAccess.read().done(function(settinginfo) {
                var loginHistory = settinginfo.loginHistory || [],
                    template = '<li><span>{userName}</span><i class="iconfont del">&#xe60a;</i></li>',
                    domList = $(that.loginDom).find('.history-userlist'),
                    domAccount = '';

                if(loginHistory.length > 0){
                    for(var i=0, len=loginHistory.length; i < len; i++) {
                        domAccount += template.replace('{userName}', settinginfo.loginHistory[i]);
                    }
                    domList.html('').append(domAccount).show();
                }else{
                    LoginBox.setShowList(false);
                }
                //domList.height() == 90 ? domList.css("overflow-y", "scroll") : domList.css("overflow-y", "visible");

                //账号点击回执
                domList.find('li').off('click').on('click', function() {
                    that.setShowList(false);
                    var choiceName = $(this).find('span').text(),
                        usersetting = settinginfo[choiceName];
                    if(usersetting){
                        $(LoginBox.pwdDom).val('');
                        that.receiptAccount(usersetting);
                    }else{
                        that.resetAccount();
                    }
                });

                //删除账号
                domList.find('i').off('click').on('click', function(evt) {
                    var choiceName = $(this).parent().find("span").text(),
                        usersetting = settinginfo[choiceName],
                        currentName = $(that.accountDom).val();
                    if(usersetting){
                        if(currentName == usersetting.userName) {
                            that.resetAccount();
                        }
                    }else{
                        //某些异常情况下，History里有记录，但settinginfo里没有记录
                        usersetting = {};
                        usersetting.userName = choiceName;
                    }
                    loginSetting({
                        type: 'delete',
                        setting: usersetting,
                        success: function(settinginfo) {
                            that.setShowList(true);
                            //如果删除完所有记住密码的用户，不应该显示返回至快速登录的按钮
                            var loginHistory = settinginfo.loginHistory || [],
                                isShowBack = false;
                            for(var i=0,len=loginHistory.length; i<len; i++) {
                                var userName = settinginfo.loginHistory[i];
                                if(settinginfo[userName].rememberPwd == true) {
                                    isShowBack = true;
                                    break;
                                }
                            }
                            //if(!isShowBack) LoginBox.loginDom.find('.login-back').hide();
                        }
                    });
                    evt.stopPropagation();
                    evt.stopImmediatePropagation();
                    return false;
                });
            });
        },
        /**
         * 显示登录设置
         */
        showSetting: function(usersetting) {
            this.setRememberPwd(usersetting.rememberPwd);
            this.setAutoLogin(usersetting.autoLogin);
        },
        /**
         * 账号、密码、头像、自动登录、记住密码
         */
        receiptAccount: function(usersetting) {
            var _this = this;
            //清空提示语
            _this.showTips('clear');
            //初始化登录流程
            LoginBox.setLoginStatus(0);
            var online = APPManager.onlineFlag;
            if(usersetting.userName){
                // 头像
                var path = APP_CONFIG.BASE_PATH + "/user/" + usersetting.loginName + "/photo.png";
                fs.exists(path, function (exist){
                    var photoSrc = exist ? path : APP_CONFIG.BASE_PATH + "/main/assets/images/user.jpg";
                    $(_this.avatarDom).attr('src', photoSrc);
                });
                //自动填充账号、密码
                $(_this.accountDom).val(usersetting.userName);
                if(online){
                    //如果在线，并且有离线提示，则清除提示语
                    if(_this.getCurrentTips() == MainLoginTips.Status_Need_Network){
                        _this.showTips('clear');
                    }
                    // 自动登录、记住密码
                    if(usersetting.autoLogin){
                        _this.setAutoLogin(true);
                    }else{
                        _this.setAutoLogin(false);
                    }
                    if(usersetting.rememberPwd){
                        //自动填充虚拟密码框
                        _this.setRememberPwd(true);
                        $(_this.pwdDom).val(new Array(11).join(' '));
                        _this.setLoginModel(MainLoginModel.CR);
                        // focus验证码区域
                        $(_this.verifyCodeDom).find("input").focus();
                    }else{
                        _this.setRememberPwd(false);
                        if($.trim($(_this.pwdDom).val()).length == 0){
                            $(_this.pwdDom).val('');
                        }
                        // focus密码区域
                        $(_this.pwdDom).focus();
                        _this.setLoginModel(MainLoginModel.PASSWORD);
                    }
                }else{
                    // 提示离线状态
                    _this.showTips('warn',MainLoginTips.Status_Need_Network);
                    // 自动登录、记住密码
                    if(usersetting.autoLogin){
                        _this.setAutoLogin(true);
                    }else{
                        _this.setAutoLogin(false);
                    }
                    if(usersetting.rememberPwd){
                        _this.setRememberPwd(true);
                    }else{
                        _this.setRememberPwd(false);
                    }
                    if($.trim($(_this.pwdDom).val()).length == 0){
                        $(_this.pwdDom).val('');
                    }
                    // focus密码区域
                    $(_this.pwdDom).focus();
                    _this.setLoginModel(MainLoginModel.PASSWORD);
                }
            }else{
                _this.resetAccount();
            }
        },
        /**
         * 输入账号时检查是否有历史记录，如果有则自动补全
         */
        checkAccount: function(str, callback) {
            if(str && this.isCheckAccount){
                var that = this;
                userSettingInfoAccess.read().done(function(settinginfo) {
                    var loginHistory = settinginfo.loginHistory || [],
                        userName = '';
                    for(var i=0,len=loginHistory.length; i<len; i++) {
                        userName = loginHistory[i];
                        if(userName.indexOf(str) == 0) {
                            that.receiptAccount(settinginfo[userName]);
                            that.showSetting(settinginfo[userName]);
                            callback && callback(true);
                            return;
                        }
                    }
                    callback && callback(false);
                });
            } else {
                callback && callback(false);
            }
        },
        /**
         * 生成验证码图像
         */
        generateVerifyCodeImage: function(code,options){
            if ( typeof code === "object" ) {
                options = code;
                code = undefined;
            }
            options = options || {};
            //注意：src 之后的参数为 HTML5 canvas 的属性
            var s = {
                code: '0000', //验证码
                display: '0000', //验证码显示文本
                fontHeight: '18', //验证码显示文本高度
                src: '', // 验证码图片base64
                // 以下参数为 HTML5 canvas 的属性
                width: '94',
                height: '44',
                fillStyle: '#ccc',
                font: 'italic normal normal 24px serif',
                strokeStyle: '#424952',
                textAlign: 'center',
            }

            var _verify = {
                code: '',
                display:'',
                src: ''
            };
            // 验证码
            _verify.code = code || options.code || s.code;
            // 显示的文本串
            _verify.display = options.display ? options.display : _verify.code;
            var fontHeight = options.fontHeight || s.fontHeight;
            var width = options.width || s.width;
            var height = options.height || s.height;
            /*创建一个canvas*/
            var canvas = document.createElement('canvas');
            var ctx=canvas.getContext('2d');
            canvas.width = width;
            canvas.height = height;
            ctx.fillStyle = options.fillStyle ? options.fillStyle : s.fillStyle;
            ctx.fillRect(0,0,width,height);
            ctx.font = options.font ? options.font : s.font;
            ctx.strokeStyle = options.strokeStyle ? options.strokeStyle : s.strokeStyle;
            ctx.textAlign = options.textAlign ? options.textAlign : s.textAlign;
            // 将显示的文本串绘制进canvas
            ctx.strokeText(_verify.display,width / 2,height / 2 + fontHeight / 2);
            _verify.src = canvas.toDataURL('image/png');
            return _verify;
        },
        /**
         * 生成验证码随机数
         */
        generateRandomString: function(n,chars){
            var code = '';
            if(typeof chars == 'undefined' || chars.length <= 0){
                chars = '0123456789';
            }
            for (var i = 0; i < n; i++){
                var index = Math.floor(Math.random() * parseInt(chars.length) + 0);
                code += chars.charAt(index);
            }
            return code;
        },
        /**
         * 生成验证码
         */
        generateVerifyCode: function(){
            //清空验证码输入框
            $(LoginBox.verifyCodeDom).find("input").val("");
            $(LoginBox.verifyImgDom).find("img").attr('src','');
            // 生成验证码
            var code = LoginBox.generateRandomString(4);
            // 保存验证码
            try{
                userInfo.verifyCode = code;
            }catch(e){
                userInfo = {loginName:"defaultuser",verifyCode:code};
            }
            // 生成图片
            var verify = LoginBox.generateVerifyCodeImage(code);
            $(LoginBox.verifyImgDom).find("img").attr('src',verify.src);
        },
        /**
         * 刷新验证码
         */
        refreshVerifyCode: function(){
            // 显示刷新中图片
            $(LoginBox.verifyImgDom).find("img").attr('src','');
            LoginBox.generateVerifyCode();
        },
        setCurrentTips: function(tips){
            var _this = this;
            if(tips){
                _this.currentTips = tips;
            }else{
                _this.currentTips = '';
            }
            return _this.currentTips;
        },
        getCurrentTips: function(){
            var _this = this;
            return _this.currentTips;
        },
        /**
         * 显示错误提示(包括清空)
         */
        showTips: function(type,content){
            var _this = this;
            type = type || '';
            var lineLimit = 20;
            switch(type){
                case 'warn':
                    if(typeof content == 'string' && content){
                        $(_this.loginWarnDom).html('').html('<i class="iconfont">&#xe60b;</i><div class="tips-inner"><em>'+ content +'</em></div>');
                        _this.setCurrentTips(content);
                    }else{
                        console.error('content值必须为字符串');
                        _this.setCurrentTips('');
                    }
                    if(-1 != $.inArray(content,[MainLoginTips.Status_Need_Authorized,MainLoginTips.Error_Account_Forbidden])){
                        $(_this.loginWarnDom).addClass('linewrap').show();
                    }else{
                        $(_this.loginWarnDom).removeClass('linewrap').show();
                    }
                    break;
                case 'clear':
                    if($(_this.loginWarnDom).is(":visible")){
                        $(_this.loginWarnDom).removeClass('linewrap').html('').hide();
                        _this.setCurrentTips('');
                    }
                    break;
                default:
                    //未匹配到type,则默认type="warn"
                    content = type || '';
                    type = 'warn';
                    if(typeof content == 'string' && content){
                        $(_this.loginWarnDom).html('').html('<i class="iconfont">&#xe60b;</i><div class="tips-inner"><em>'+ content +'</em></div>');
                        _this.setCurrentTips(content);
                    }else{
                        console.error('参数不能为空');
                        _this.setCurrentTips('');
                    }
                    if(-1 != $.inArray(content,[MainLoginTips.Status_Need_Authorized,MainLoginTips.Error_Account_Forbidden])){
                        $(_this.loginWarnDom).addClass('linewrap').show();
                    }else{
                        $(_this.loginWarnDom).removeClass('linewrap').show();
                    }
                    break;
            }
        },
        /**
         * 恢复默认账户设置/重置
         * @param account
         * @param options
         */
        resetAccount: function(){
            var _this = this;
            //初始化登录流程
            LoginBox.setLoginStatus(0);
            //清空提示语
            _this.showTips('clear');
            $(_this.avatarDom).attr('src', APP_CONFIG.BASE_PATH + "/main/assets/images/user.jpg");
            $(_this.accountDom).val('');
            // focus账号区域
            $(_this.accountDom).focus();
            if($.trim($(_this.pwdDom).val()).length == 0){
                $(_this.pwdDom).val('');
            }
            _this.setAutoLogin(false);
            _this.setRememberPwd(false);
        },
        showLoginFormMask: function (status) {
            var _this = this;
            if(status){
                $(_this.loginFormMask).show();
            }else{
                $(_this.loginFormMask).hide();
            }
        }
    }

    /**
     * 用户数据库管理
     */
    var userDbAccess = {
        dbpath: APP_CONFIG.BASE_PATH + "/user/user.db",
        uniqueFlag: 'loginName',
        usersCache: [],
        //获取用户数据库信息
        getAllInfo: function(){
            var _this = this;
            var def = jQuery.Deferred();
            if(_this.usersCache.length > 0){
                def.resolve(_this.usersCache);
            }else {
                fs.exists(_this.dbpath, function (exists) {
                    if (exists) {
                        var db = new sqlite3.Database(_this.dbpath);
                        db.all("SELECT * FROM users", function (err, rows) {
                            db.close();
                            if (err) {
                                console.error('数据库：%s 查询用户失败', dbpath);
                                def.resolve([]);
                            } else {
                                _this.usersCache = rows;
                                def.resolve(rows);
                            }
                        });
                    } else {
                        console.error('用户数据库文件:%s 不存在', dbpath);
                        def.reject();
                    }
                });
            }
            return def.promise();
        },
        //更新用户信息
        update:function(id,userInfo,loginInfo){
            var _this = this;
            var def = jQuery.Deferred();
            _this.getAllInfo().done(function(users){
                var db = new sqlite3.Database(_this.dbpath);
                var sql;
                var isNewUser = true;
                DES.init(APP_CONFIG.DESKEY,userInfo.loginName + "=" + loginInfo.password);
                var password = DES.Encrypt();

                try{
                    var reserve1 = JSON.stringify(userInfo);
                }catch(e){
                    var reserve1 = JSON.stringify({});
                }
                var schoolName = userInfo.userExt && userInfo.userExt.schoolName || '';

                for (var i = 0, len = users.length; i < len; i++) {
                    var item = users[i];
                    if(userInfo.loginName == item.loginName){
                        isNewUser = false;
                        sql = 'update users set '
                            + 'userName="' + userInfo.userName + '",'
                            + 'loginName="' + userInfo.loginName + '",'
                            + 'password="' + password + '",'
                            + 'email="' + userInfo.email + '",'
                            + 'phone="' + userInfo.mobile + '",'
                            + 'isActive="' + userInfo.isActive + '",'
                            + 'lastLoginTime="' + userInfo.lastLoginTime + '",'
                            + 'schoolName="' + schoolName + '",'
                            + 'enName="' + userInfo.enName + '",'
                            + 'reserve1=\'' + reserve1 + '\''
                            + ' where id="' + id + '"';
                        db.run(sql);
                        //更新用户缓存信息
                        userDbAccess.updateUsersCache('refresh', userInfo.loginName, {
                            IsRememberPasswordOrNot: item.IsRememberPasswordOrNot,
                            email: userInfo.email,
                            enName: userInfo.enName,
                            headImg: item.headImg,
                            id: item.id,
                            isActive: userInfo.isActive,
                            lastLoginTime: userInfo.lastLoginTime,
                            loginName: userInfo.loginName,
                            password: password,
                            phone: userInfo.mobile,
                            reserve1: reserve1,
                            reserver2: null,
                            schoolName: schoolName,
                            userName: userInfo.userName
                        });
                        def.resolve(userInfo);
                        return;
                    }
                }

                if(isNewUser){
                    sql = 'insert into users(id,userName,loginName,password,email,phone,isActive,lastLoginTime,schoolName,enName,reserve1) values("'
                        + id + '","'
                        + userInfo.userName + '","'
                        + userInfo.loginName + '","'
                        + password  + '","'
                        + userInfo.email + '","'
                        + userInfo.mobile + '","'
                        + userInfo.isActive + '","'
                        + userInfo.lastLoginTime + '","'
                        + schoolName + '","'
                        + userInfo.enName + '",\''
                        + reserve1 +'\')';
                    db.run(sql);
                    //新增新用户缓存信息
                    userDbAccess.updateUsersCache('create', userInfo.loginName, {
                        IsRememberPasswordOrNot: userInfo.IsRememberPasswordOrNot,
                        email: userInfo.email,
                        enName: userInfo.enName,
                        headImg: userInfo.headImg,
                        id: id,
                        isActive: userInfo.isActive,
                        lastLoginTime: userInfo.lastLoginTime,
                        loginName: userInfo.loginName,
                        password: password,
                        phone: userInfo.mobile,
                        reserve1: reserve1,
                        reserver2: null,
                        schoolName: schoolName,
                        userName: userInfo.userName
                    });
                }
                def.resolve(userInfo);
            }).fail(function(e){
                def.reject(e);
            });
            return def.promise();
        },
        // 获取，更新指定用户缓存信息
        updateUsersCache: function(operation,loginName,obj){
            var _this = this;
            if(!operation || !loginName){
                return false;
            }
            var newcache = [],
                cached = _this.usersCache,
                result = [];
            var findCache = cached.filter(function(el){
                return el[_this.uniqueFlag] == loginName;
            });

            if(operation == 'create'){
                if(obj && typeof obj === "object") {
                    if(findCache.length == 0) {
                        //新增cache
                        obj[_this.uniqueFlag] = loginName;
                        newcache = cached.push(obj);
                        _this.usersCache = newcache;
                        return true;
                    }else{
                        //更新cache
                        operation = 'refresh';
                    }
                }else{
                    return false;
                }
            }
            if(operation == 'get'){
                if(findCache.length == 1){
                    return findCache;
                }else{
                    return false;
                }
            }
            if(operation == 'refresh'){
                if(obj && typeof obj === "object") {
                    for (var i = 0, count = cached.length; i < count; i++) {
                        var _item = cached[i];
                        if (_item[_this.uniqueFlag] == loginName) {
                            obj[_this.uniqueFlag] = loginName;
                            newcache.push(obj);
                        } else {
                            newcache.push(_item);
                        }
                    }
                    //如果没有被cache,则立即cache
                    if(findCache.length == 0) {
                        obj[_this.uniqueFlag] = loginName;
                        newcache.push(obj);
                    }
                    _this.usersCache = newcache;
                    return true;
                }else{
                    return false;
                }
            }
            if(operation == 'delete'){
                for(var i=0,count = cached.length;i<count;i++) {
                    var _item = cached[i];
                    if(_item[_this.uniqueFlag] != loginName){
                        newcache.push(_item);
                    }
                }
                _this.usersCache = newcache;
            }
            if(operation == 'clear'){
                _this.usersCache = [];
            }
        },
        //解析记录(解析为json格式)
        parseToJson: function(record){
            var _this = this;
            var result = [];
            if(jQuery.isArray(record)){
                result = record.filter(function(el){
                    try{
                        el._reserve1 = JSON.parse(el.reserve1);
                    }catch(e){
                        el._reserve1 = {};
                    }
                    return el;
                });
            }
            return result;
        }
    }

    /**
     * 用户登录设置管理
     * 这个是loginSetting方法的中间处理层，增加了数据缓存
     */
    var userSettingInfoAccess = {
        loginSettingCache: {},
        refreshCache: function(settingInfo){
            var _this = this;
            _this.loginSettingCache = settingInfo;
        },
        add: function(options){
            var _this = this;
            options = options || {};
            var setting = options.setting,
                userInfo = options.userInfo;
            var def = jQuery.Deferred();
            loginSetting({
                type: 'add',
                setting: setting,
                userInfo: userInfo,
                success: function(settingInfo){
                    _this.loginSettingCache = settingInfo;
                    def.resolve(settingInfo);
                }
            });
            return def.promise();
        },
        delete: function(options){
            var _this = this;
            options = options || {};
            var setting = options.setting,
                userInfo = options.userInfo;
            var def = jQuery.Deferred();
            loginSetting({
                type: 'delete',
                setting: setting,
                userInfo: userInfo,
                success: function(settingInfo){
                    _this.loginSettingCache = settingInfo;
                    def.resolve(settingInfo);
                }
            });
            return def.promise();
        },
        read: function(options){
            var _this = this;
            options = options || {};
            var setting = options.setting,
                userInfo = options.userInfo;
            var def = jQuery.Deferred();
            var loginHistory = _this.loginSettingCache.loginHistory;
            if(loginHistory && loginHistory.length > 0){
                def.resolve(_this.loginSettingCache);
            }else{
                loginSetting({
                    type: 'read',
                    setting: setting,
                    userInfo: userInfo,
                    success: function (settingInfo) {
                        def.resolve(settingInfo);
                    }
                });
            }
            return def.promise();
        }
    }

    /**
     * 登录优化后"记住密码"和"读取密码"管理
     */
    function loginInfoManager(callback) {
        var type = callback.type,
            loginInfo = callback.loginInfo,
            success = callback.success,
            error = callback.error,
            content = '',
            path = APP_CONFIG.BASE_PATH + "/user/" + loginInfo.username + "/userExt.cr";
        if(type == 'write') {
            content = loginInfo.username + '=' + loginInfo.password;
            DES.init(TA.UserService.key, content);
            var val = DES.Encrypt();
            shellcmd.handleFile(path, val, {type: 'write', success: function(){
                success && success();
                console.log("保存密码成功");
            },fail: function(){
                error && error();
                console.log('保存密码失败');
            }});
        } else {
            fs.exists(path, function (exist) {
                if (exist) {
                    content = shellcmd.readFile(path);
                    DES.init(TA.UserService.key, content);
                    content = decodeURIComponent(DES.Encrypt("Decrypt"));
                    loginInfo = TA.UserService._list(content);
                    //自动登录读取cr文件，password结尾有空字符
                    loginInfo.password = loginInfo.password.replace(/\0/g,"");

                    success && success(loginInfo);
                }else{
                    error && error('');
                }
            });

        }
    }

    /**
     * 自动登录、记住密码设置和读取
     * callback.type  "add"为添加账号设置信息；"delete"为删除账号设置信息;"read"为读取设置信息
     */
    function loginSetting(callback) {
        var path = APP_CONFIG.BASE_PATH + "/user/loginSetting.dat";
        var type = callback.type,
            setting = callback.setting,
            userInfo = callback.userInfo,
            success = callback.success,
            loginsetting = '',
            settingInfo = {};

        fs.exists(path, function(exist) {
            if(exist) {
                loginsetting = shellcmd.readFile(path);
                settingInfo = JSON.parse(loginsetting);
            }

            var loginHistory = settingInfo.loginHistory || [];

            //删除包括loginName、mobile、email三种方式
            function deleteUser(loginName) {
                loginHistory.splice(loginHistory.indexOf(loginName), 1);
                delete settingInfo[loginName];
            }

            if(type == "add") {
                var userName = setting.userName,   //登录名（可能是下面三种方式的任意一种）
                    loginName = userInfo ? userInfo.loginName : '',
                    mobile = userInfo ? (userInfo.mobile ? userInfo.mobile : userInfo.phone) : '',  //在线登录是mobile，离线字段是phone
                    email = userInfo ? userInfo.email : '';
                //删除同一个账号的其他登录方式，保持一个账号只有一条历史记录
                if (loginHistory.indexOf(loginName) != -1) {
                    deleteUser(loginName);
                } else if(loginHistory.indexOf(mobile) != -1) {
                    deleteUser(mobile);
                } else if(loginHistory.indexOf(email) != -1) {
                    deleteUser(email);
                }
                // 畅言通信证2.0
                // if (loginHistory.indexOf(userName) != -1) {
                //     deleteUser(userName);
                // }
                loginHistory.unshift(userName);
                settingInfo.loginHistory = loginHistory;
                settingInfo[setting.userName] = setting;
                shellcmd.writeFile(path, JSON.stringify(settingInfo));
                userSettingInfoAccess.refreshCache(settingInfo);
                success && success(settingInfo);
            } else if(type == "delete") {
                deleteUser(setting.userName);
                settingInfo.loginHistory = loginHistory;
                shellcmd.writeFile(path, JSON.stringify(settingInfo));
                userSettingInfoAccess.refreshCache(settingInfo);
                success && success(settingInfo);
            } else if(type == "read") {
                userSettingInfoAccess.refreshCache(settingInfo);
                success && success(settingInfo);
            }
        });
    }


    //初始化全局工具栏
    function startFloatToolbar(){
        //   var FloatToolBarExe = Config.binPath + 'tools/iFLY_FloatToolBar.exe';
        // shellcmd.shellexecutewithargs(FloatToolBarExe, 'ws://127.0.0.1:9980 ib');
        var path = require("path");
        var base = path.dirname(process.execPath);
        var FloatToolBarExe = base + "/plugins/62/bin/tools/iFLY_FloatToolBar.exe";
        var exec = require("child_process").exec;
        exec('"'+FloatToolBarExe + '" ws://127.0.0.1:9980 main',function(){
            console.error(arguments);
        });
    };
    //退出全局工具栏
    function killFloatToolbar(){
        callClient('syscmd', 'killprocess', 'iFLY_FloatToolBar.exe', 0, function () {
        });
    }


    return {
        go_login: go_login,
        openPersonCenter:openPersonCenter,
        openFeedback:openFeedBack,
        autoLogin:autoLogin,
        _logout:_logout,
        loginBoxInit:LoginBox.init,
        login: LoginBox.login,
        generateVerifyCode: LoginBox.generateVerifyCode,
        refreshVerifyCode: LoginBox.refreshVerifyCode,
        sendUserInfo: sendUserInfo,
        rfc3986: rfc3986,
        sha1_sign: sha1_sign,
        sha1_loginInfo: sha1_loginInfo,
        userDbAccess: userDbAccess,
        accountLogin: accountLogin,
        appAutoLogin: appAutoLogin,
        beforeOnLineLoginCheck: beforeOnLineLoginCheck,
        beforeOffLineLoginCheck: beforeOffLineLoginCheck,
        MainLoginTips: MainLoginTips,
        MainLoginModel: MainLoginModel,
        init: function () {
            var that = this;
            //初始化登录流程
            LoginBox.setLoginStatus(0);
            //初始化时即请求登录数据
            userSettingInfoAccess.read().done(function(settinginfo) {
                // 上一次登录的账号
                var userName = settinginfo.loginHistory ? settinginfo.loginHistory[0] : '';
                var userSetting = settinginfo[userName];
                if(userSetting){
                    var autoLogin = userSetting && userSetting.autoLogin;
                    var rememberPwd = userSetting && userSetting.rememberPwd;
                    // 回显账号信息
                    LoginBox.receiptAccount(userSetting);
                }else{
                    LoginBox.resetAccount();
                }
            });
            //刷新验证码
            LoginBox.refreshVerifyCode();

            //打开登录框
            $(document).on("click", "#login", function () {
                loginAndCurtain(true);
            });
            //退出程序，关闭进程
            $(document).on("click", "#login_close", function () {
                //socket && socket.send({"type":"logic","action":"quit","from":"","to":"tray","id":4,"data":{}});
                closeTaGlobalMethod();
            });
            //关闭登录框
            $(document).on("click", "#img_close", function () {
                $("#loginwarn").html("");
                $("#loginwarn").hide();
                loginAndCurtain(false);
                //关闭快速登录   --- test
                /*$("#fastLogin").hide();*/
                $("#confirmLogin").hide();
            });

            $(LoginBox.pwdDom).on('input',function(event){
                if(LoginBox.loginModel === MainLoginModel.CR){
                    if($.trim($(LoginBox.pwdDom).val()).length == 0){
                        $(LoginBox.pwdDom).val('');
                    }
                }
                //处理完CR模式下密码框任何输入都清空密码框后，将当前模式改为password
                LoginBox.setLoginModel(MainLoginModel.PASSWORD);
                return false;
            }).on("focus",function(){
                $(this).parent().find(".user").css("color","#4fa2f8");
                return false;
            }).on("blur",function(){
                $(this).parent().find(".user").css("color","#bcc4cd");
                return false;
            });
            //在backspace的情况下不进行登录框自动匹配
            // $(document).on('keydown', "#login_username", function (evt){
            //     var filterKeyCode = [8,46];  //过滤backspace,del
            //     LoginBox.isCheckAccount = filterKeyCode.indexOf(evt.keyCode) == -1;
            // });
            //在backspace的情况下不进行登录框自动匹配
            $(LoginBox.accountDom).on("keydown",function(evt){
                var filterKeyCode = [8,46];  //过滤backspace,del
                LoginBox.isCheckAccount = filterKeyCode.indexOf(evt.keyCode) == -1;
            });
            //登录框的input事件
            $(LoginBox.accountDom).on("input",function () {
                //清空提示
                LoginBox.showTips("clear");
                $(LoginBox.pwdDom).val('');
                var inputStr = $(LoginBox.accountDom).val();
                LoginBox.checkAccount(inputStr, function (flag){
                    if(flag) {
                        $(LoginBox.accountDom).select();
                        window.document.activeElement.selectionStart = inputStr.length;
                    } else {
                        if($.trim($(LoginBox.pwdDom).val()).length == 0){
                            $(LoginBox.pwdDom).val('');
                        }
                        LoginBox.setRememberPwd(false);
                        LoginBox.setAutoLogin(false);
                        $('#loginBoxPhoto').attr('src', APP_CONFIG.BASE_PATH + "/main/assets/images/user.jpg");
                    }
                });
                return false;
            }).on("focus",function(){
                $(this).parent().find(".user").css("color","#4fa2f8");
                return false;
            }).on("blur",function(){
                $(this).parent().find(".user").css("color","#bcc4cd");
                return false;
            }).on("click",function(){
                if(LoginBox.isShowList){
                    setTimeout(function (){
                        LoginBox.setShowList(false);
                    }, 1);
                }
                return false;
            });
            //记住密码checkbox
            $(LoginBox.rememberPwdDom).on("change",function(event){
                LoginBox.setRememberPwd();
                return false;
            });

            //自动登录checkbox
            $(LoginBox.autoLoginDom).on("change", function (event) {
                LoginBox.setAutoLogin();
                return false;
            });

            $(LoginBox.accountHistoryDom).on("click",function(event){
                if(LoginBox.isShowList){
                    LoginBox.setShowList(false);
                }else{
                    LoginBox.setShowList(true);
                }
                // UI呈现整体蓝色边框
                $(LoginBox.accountDom).focus();
                return false;
            });

            // 登录按钮
            $(LoginBox.loginButtonDom).on("click",function(){
                if(LoginBox.loginStatus != 1) {
                    // 开始登录流程
                    // 登录按钮聚焦
                    $(LoginBox.loginButtonDom).focus();
                    // 清空错误提示
                    LoginBox.showTips('clear');
                    // 设置登录中状态
                    LoginBox.setLoginStatus(1);
                    ta_how_to_login();
                    return false;
                }
            });

            //验证码切换
            $(LoginBox.verifyCodeChangeDom).on("click",function(event){
                LoginBox.refreshVerifyCode();
                // focus验证码区域
                $(LoginBox.verifyCodeDom).find("input").focus();
                return false;
            });

            /**
             * 连续点击登录区域，取消弹窗遮盖
             */
            $(LoginBox.loginFormMask).on("click",function () {
                var now = new Date().getTime();
                var checkValid = function(lastTime){
                    var isvalid = (now - lastTime < 300);
                    console.log(now - lastTime);
                    LoginBox.loginFormMaskClickTime = now;
                    return isvalid;
                }
                if(LoginBox.loginFormMaskClickTime == 0){
                    LoginBox.loginFormMaskClickTime = now;
                    LoginBox.loginFormMaskClickCount = 0;
                }else{
                    if(checkValid(LoginBox.loginFormMaskClickTime)){
                        LoginBox.loginFormMaskClickCount ++;
                    }else{
                        //重置统计数
                        LoginBox.loginFormMaskClickCount = 0;
                    }
                }
                if(LoginBox.loginFormMaskClickCount >= 3){
                    // 终止登录流程
                    LoginBox.setLoginStatus(0);
                    LoginBox.showLoginFormMask(false);
                }
            });

            //下拉框
            $(document).on("click", "#_box", function (evt) {
                $("#sel_box").toggle();
                $("#controlBar").addClass("hide");
                /*                if ($("#sel_btn").attr("class") == "login_lap_button") {
                 $("#sel_box").hide();
                 $("#sel_btn").addClass("login_lap_button_active");
                 } else {
                 $("#sel_box").show();
                 $("#sel_btn").removeClass("login_lap_button_active");
                 $("#controlBar").addClass("hide");
                 }*/
                evt.stopPropagation();
                evt.stopImmediatePropagation();
            });

            //右上角图标管理
            $(document).on("click", '#controlIco', function (evt){
                if($("#controlBar").hasClass("hide")) {
                    $("#controlBar").removeClass("hide");
                    $("#sel_box").hide();
                    $("#sel_btn").addClass("login_lap_button_active");
                } else {
                    $("#controlBar").addClass("hide");
                }
                evt.stopPropagation();
                evt.stopImmediatePropagation();
            });

            $(document).on('click', '.web_wrapper', function(){
                $("#controlBar").addClass("hide");
                $("#sel_box").hide();
                $("#sel_btn").addClass("login_lap_button_active");
            });

            //登陆框免费注册
            $("#loginFreeRegister").click(function () {
//                $("#login_box").hide();
                // loginAndCurtain(false);
                startWeb(APP_CONFIG.REGISTER);

                //register();
            });

            //注册文字链接
            $(document).on("click", "#register", function () {
                startWeb(APP_CONFIG.REGISTER);

//                register();
            });

            function register() {
                shellcmd.log('注册::开始');
                if (APPManager.onlineFlag) {
                    shellcmd.log('注册::开始。有网络');

                    var spawn = require('child_process').spawn;
                    var nw = APP_CONFIG.BASE_PATH + "/nw.exe";
                    var register = APP_CONFIG.BASE_PATH + "/register";
                    /**
                     * 这里判断注册页面是否存在的原因是：已打开一个注册页面进程，再次打开时NW返回的进程PID改变，
                     * 事实上，PID并未改变，只是重启了一个进程发现单实例后自动退出，同时能监听到重启的进程的离开状态。
                     * 如若node-webkit换版本，请注意修改此问题。
                     * TODO:something;
                     */
                    if(TA.Stage.stages['register'] ){
                        spawn(nw, [register]);
                    }else{
                        TA.Stage.stages['register'] = spawn(nw, [register]).on("error", function (err) {
                            shellcmd.log('注册::启动注册面板失败。' + JSON.st);
                        }).on("exit", function () {
                            TA.Stage.stages['register'] = null;
                        });
                    }
                } else {
                    shellcmd.log('注册::开始。无网络');
                    dNetworkPanel.show();
                }

            }

            //个人中心
            $("#personCenter").click(function () {
                openPersonCenter("base");

                //统计基本资料点击次数    ---pengchen3
                LogManager.statistics("trigger", {ta_app :"ta", module: "12", user_id :userInfo.id},null);
            });

            //初始化全局变量
            global._show_tm_window = false;
            //向ifs索要授课精灵连接信息
            $("#need_connect_info").click(function(){
                var json = {
                    action:"need_connect_info",
                    data:{},
                    from:"main",
                    id:"",
                    to:"iflyslide",
                    type:"logic"
                };
                global._show_tm_window = true;
                socket.send(json);
            });

            //用户头像点击事件
            $("#user_photo").click(function () {
                openPersonCenter("base");
                // userCenter_childprocess.send({table:"1"});

                //统计点击个人资料图标次数   ---pengchen3
                LogManager.statistics("trigger", {ta_app :"ta", module: "11", user_id :userInfo.id},null);
            });

            // 注销登录
            $("#logout").unbind("click");
            $("#logout").click(function () {
                $("#mask_layer").show();
                dLogoutConfirm.show();

                //注销弹出框
                $(document).on("click", "#logout_confirm_yes", _logout);

                //注销取消
                $(document).on("click", "#logout_confirm_no", function () {
                    $("#mask_layer").hide();
                    dLogoutConfirm.close();
                });

                //统计退出登录点击次数   ---pengchen3
                LogManager.statistics("trigger", {ta_app :"ta", module: "14", user_id :userInfo.id},null);
            });

            //用户反馈弹出框
            $("#feedback").click(function () {
                //点击反馈监管    ---pengchen3
                LogManager.statistics("trigger", {ta_app :"ta", module: "09", user_id :userInfo.id},null);

                openFeedBack();
            });
            //修改密码
            $("#userCenterChanagePassword").click(function () {
                if (APPManager.onlineFlag) {
                    openPersonCenter("password");
                } else {
                    dNetworkPanel.show();
                }
                //统计修改密码点击次数   ---pengchen3
                LogManager.statistics("trigger", {ta_app :"ta", module: "13", user_id :userInfo.id},null);
            });
            //消息中心
            $(".userInfoCenter").click(function(){
                //统计点击公告图标次数   ---pengchen3
                LogManager.statistics("trigger", {ta_app :"ta", module: "07", user_id :userInfo.id},null);
                //隐藏未读标识--zqwei
                $(".userInfoCenter").find('b').hide();
                if(APPManager.onlineFlag){
                    if(onLoginFlag==1){
                        openMessageCenter();
                    }else {
                        /**
                         * 如果有自动登录的选项，不做任何处理，直接退会，这个是为了托盘打开消息中心的时序错乱而加。
                         */
                        // TA.UserService.getLocalUserAccount(function (loginInfo) {
                        //     if (loginInfo) return;
                        //     $("#login_username").val("账号/手机号/邮箱");
                        //     $("#login_password").val("密码");
                        //     loginAndCurtain(true);
                        // });
                        $("#login").trigger('click');
                    }
                }else{
                    dNetworkPanel.show();
                }
            });

            //单点登录到畅言云
            $('.userCloud').click(function(){
                // 这里功能已屏蔽
                // var url = APP_CONFIG.YUN_CLOUD_LOGIN;
                // if(userInfo.loginName != "defaultuser"){
                //     DES.init(APP_CONFIG.DESKEY,userInfo.loginName + "=" + userInfo.password);
                //     var token = DES.Encrypt();
                //     url = url + "&token=" + token;
                // }
                // startWeb(url);
            });
            //单点登录到智慧平台
            $('.userCloud_hefei').click(function(){
                // sso单点登录到智慧平台地址
                var url = Base_Cfg.HEFEI_JX + '/area/login.action' + '?from=ew&appId=jxpt';
                // des单点登录智慧平台地址
                // var url = Base_Cfg.HEFEI_JX + "/area/loginCheck.action?";
                TA.Utils.openWebPage(url);
            });
            //跳转链接到i畅言
            $('#ichangyan').click(function(){
                var url = APP_CONFIG.I_CHANGYAN;
                startWeb(url);
            });

            //单点登录到畅言云班级圈
            $('#classMeg').click(function(){
                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:userInfo.id,
                    module:'04001',
                    type:'trigger',
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
                // 这里功能已屏蔽
                // $("#classMeg").removeClass("msg-active");
                // var url = APP_CONFIG.YUN_ESCHOOL_LOGIN+"/index.php?m=Clazz&c=Class&a=index&classId=";
                // if(userInfo.loginName != "defaultuser"){
                //     DES.init(APP_CONFIG.DESKEY,userInfo.loginName + "=" + userInfo.password);
                //     var token = DES.Encrypt();
                //     url = url + "&token=" + token;
                // }
                // startWeb(url);
            });

            //监听本地登录文件，若有变化，则尝试登录
            taEmitter.on(TA_EVENT.USER_STATUS_CHANGED, function (isExsits) {
                if (!isExsits) {
                    if(onLoginFlag!=0)
                    {_logout();}
                    return;
                }
                TA.UserService.getLocalUserAccount(function (loginInfo) {
//                    onLoginFlag=0;
                    if(!onLoginFlag){
                        loginInfo._type = Login.MainLoginModel.CR;
                        go_login(loginInfo, 0);
                    }

                });
            });

            //监听网络变化
            taEmitter.on(TA_EVENT.NETWORK_STATUS_CHANGED, function(status){
                if(status){
                    // 网络恢复正常
                    if(LoginBox.getCurrentTips() == MainLoginTips.Status_Need_Network){
                        LoginBox.showTips('clear');
                    }
                }else{
                    // 网络不给力 登录框显示并且遮罩不显示
                    if($(LoginBox.loginDom).is(":visible") && !$(LoginBox.loginFormMask).is(":visible")){
                        if(LoginBox.getCurrentTips() != MainLoginTips.Status_Need_Network){
                            LoginBox.showTips('warn',MainLoginTips.Status_Need_Network);
                        }
                    }
                }
            });

            //回车键监听
            document.onkeydown = function (e) {
                e = e ? e : window.event;
                var keyCode = e.which ? e.which : e.keyCode;
                // enter键
                if (keyCode == 13 && $(LoginBox.loginDom).is(":visible") && LoginBox.loginStatus != 1) {
                    // 设置登录中状态
                    LoginBox.setLoginStatus(1);
                    // 登录按钮聚焦
                    $(LoginBox.loginButtonDom).focus();
                    // 清空错误提示
                    LoginBox.showTips('clear');
                    ta_how_to_login();
                }
                // tab键
                if(keyCode == 9 && $(LoginBox.loginDom).is(":visible")){
                    // 关闭账号历史弹窗
                    LoginBox.setShowList(false);
                }
            };

            $(document).on("click","#forgetPassword",function(){
                window.location.href = APP_CONFIG.FORGETPASSWORD;
            });

            //检查是否本地有记住密码
            setTimeout(function(){
                autoLogin();
                //自动登录功能延迟500ms,为检测联网提供间隙
            },2000);

            function ta_how_to_login(){
                var account = $.trim($(LoginBox.accountDom).val());
                var password = $.trim($(LoginBox.pwdDom).val());
                var verifyCode = $.trim($(LoginBox.verifyCodeDom).find("input").val());

                if(password == ''){
                    if(LoginBox.loginModel === MainLoginModel.CR){
                        loginInfoManager({
                            type: 'read',
                            loginInfo: {
                                username: account
                            },
                            success: function(loginInfo) {
                                if(loginInfo.username && loginInfo.password){
                                    // 进行登录流程
                                    go_login({
                                        username: loginInfo.username,
                                        password: loginInfo.password,
                                        verifyCode: verifyCode,
                                        _type: MainLoginModel.CR
                                    },0);
                                }else{
                                    // 读取的加密信息异常
                                    // 结束登录流程
                                    LoginBox.setLoginStatus(0);
                                    LoginBox.init(account);
                                }
                            },
                            error: function(){
                                // 加密文件不存在
                                // 结束登录流程
                                $(LoginBox.pwdDom).val('');
                                LoginBox.setLoginStatus(0);
                                LoginBox.init(account);
                            }
                        });
                    }else{
                        // 进行登录流程
                        $(LoginBox.pwdDom).val('');
                        LoginBox.setLoginStatus(0);
                        LoginBox.init(account);
                    }
                }else{
                    // 进行登录流程
                    go_login({
                        username: account,
                        password: password,
                        verifyCode: verifyCode,
                        _type: MainLoginModel.PASSWORD
                    },0);
                }
            }
            function ta_how_to_login_old(){
                $("#loginwarn").hide();
                var username = $.trim($(LoginBox.accountDom).val());
                var password = $.trim($(LoginBox.pwdDom).val());
                var verifyCode = $.trim($(LoginBox.verifyCodeDom).find("input").val());
                var loginInfo = {
                    username: username || "",
                    password: password || "",
                    verifyCode: verifyCode || ""
                };
                go_login(loginInfo, 0);
            }

        }
    };
})();