/**
 * Created by linwang5 2014/9/30.
 * 用于监管用戶并上传log，集成了logCenterSDK
 */

var LogManager = {
    sessionList: new Array(),
    appList: {
        'iflybook':'01',
        'beike':'02',
        'ta_app':'03',
        'usercenter':'04',
        'ta':'05',
        'classTeach':'06',
        'icw':'63',
        'datibao':'15'
    },
    statisticsMoudleTime: function (a,b,c) {
       c&&c();
    },
    statistics: function (action, parms, callback) {
        if (arguments.length < 2) {
            console.err('参数传入错误');
            return;
        }
        if(typeof(parms.user_id) == "undefined") {
            delete parms.user_id;
        }
        var  ta_app = LogManager.appList[parms.ta_app];
        parms.module = ta_app+parms.module;
        var thisSession = LogManager.getSession(ta_app, parms.module, action);
        if (thisSession) {
            parms.session_id = thisSession;
            parms.ta_app = ta_app;
            LogManager.sendMessage(action, parms, callback);
        }

    },

    getSession: function (taApp, module, action) {
        var sessionId = taApp + module;
        var sessionTemp = null;
        if (action == 'enter') {
            var flag = false;
            for (var i in LogManager.sessionList) {
                if (LogManager.sessionList[i].id == sessionId) {
                    sessionTemp = LogManager.sessionList[i].session;
                    flag = true;
                    break;
                }

            }
            if (!flag) {
                sessionTemp = LogManager._getRandomString();
                LogManager.sessionList.push({
                    id: sessionId,
                    session: sessionTemp
                });
            }

        } else if (action == 'quit') {
            for (var i in LogManager.sessionList) {
                if (LogManager.sessionList[i].id == sessionId) {
                    sessionTemp = LogManager.sessionList[i].session;
                    LogManager.sessionList.splice(i,1);
                    break;
                }
            }
        } else {
            sessionTemp = LogManager._getRandomString();
        }

        return sessionTemp;
    },

    _getRandomString: function (len) {
        var len = len || 48;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
        var maxPos = $chars.length;
        var pwd = '';
        for (var i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd.toLowerCase();
    },

    sendMessage: function (action, parms, callback) {
        socket && socket.send({
            type: 'logic',
            action: 'monitor',
            to: 'tray',
            data: {
                action: action,
                arguments: parms
            }
        });
        callback && callback();
    }

};

