/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2016/10/18 16:08
 * description :
 */
var TA_KTSL = (function () {
    var crypto = require('crypto');
    var fs = require('fs');
    var sqlite3 = require('sqlite3').verbose();
    var zipUtil = require("ziputil/AddonZip");
    var DBPATH = APP_CONFIG.BASE_PATH + '/DAT/ktsl.db';
    var IFBPATH = APP_CONFIG.BASE_PATH + '/plugins/62/bin/users/ktsl.db';
    var IFBDir = APP_CONFIG.BASE_PATH + '/plugins/62/bin/users/ktslDir/';
    var ktslDir = APP_CONFIG.BASE_PATH + '/DAT/ktsl/';
    var phaseToGrade = [
        {
            "phase": "01",
            "grade": [
                {
                    "code": "14",
                    "name": "幼儿园小班"
                },
                {
                    "code": "15",
                    "name": "幼儿园中班"
                },
                {
                    "code": "16",
                    "name": "幼儿园大班"
                },
            ]
        },
        {
            "phase": "02",
            "grade": [
                {
                    "code": "17",
                    "name": "学前班"
                }
            ]
        },
        {
            "phase": "03",
            "grade": [
                {
                    "code": "01",
                    "name": "一年级"
                },
                {
                    "code": "02",
                    "name": "二年级"
                },
                {
                    "code": "03",
                    "name": "三年级"
                },
                {
                    "code": "04",
                    "name": "四年级"
                },
                {
                    "code": "05",
                    "name": "五年级"
                },
                {
                    "code": "06",
                    "name": "六年级"
                },
            ]
        },
        {
            "phase": "04",
            "grade": [
                {
                    "code": "07",
                    "name": "七年级"
                },
                {
                    "code": "08",
                    "name": "八年级"
                },
                {
                    "code": "09",
                    "name": "九年级"
                },
            ]
        },
        {
            "phase": "05",
            "grade": [
                {
                    "code": "10",
                    "name": "高一"
                },
                {
                    "code": "11",
                    "name": "高二"
                },
                {
                    "code": "12",
                    "name": "高三"
                },
            ]
        },
    ];


    function getUserInfo() {
        return userInfo;
    }

    function _socketClassInfo(from) {
        getClassInfo(socketInner);
        function socketInner(userInfo) {

            var obj = {
                "type": 'logic',
                "action": 'ktsl_classInfo',
                "from": 'main',
                "to": from,
                "id": _getRandomString(),
                "data": {
                    classInfo:userInfo.classInfo,//行政班级
                    freeClass:userInfo.freeClass //自由班级
                }
            };
            socket && socket.send(obj);

        }
    }

    function getClassInfo(callback) {
        var userInfo = getUserInfo();
        var p = {
            userId: userInfo._user_openId,
            openId: userInfo._sso_openId
        };
        edcService.Instance().core_user_org_detail(p).done(function (ret) {
            if (ret && ret.code == 0) {
                callback && callback(FormatClassInfo(userInfo, ret.data));
            } else {
                callback && callback(addGradeInfo(userInfo));
            }

        }).fail(function () {
            callback && callback(addGradeInfo(userInfo));
        });
    }

    function addGradeInfo(userInfo) {
        var classList = userInfo.classInfo;
        var startYear,gradeName,gradeCode, curDate,curPhase,phaseIndex,curYear, curMonth, curDay;
        phaseIndex = 0;
        curDate = new Date();
        curYear = curDate.getFullYear();//当前年
        curMonth = curDate.getMonth() + 1;//当前月
        curDay = curDate.getDate();//当前天
        for(var i = 0,len = classList.length;i<len;i++){
            var item = classList[i];
            curPhase = item.phase;//当前学段
            startYear = item.year;
            var gradeIdx = curYear - startYear;
            switch (curPhase) {//找到当前学段号对应的学段
                case '01':
                    phaseIndex = 0;
                    break;
                case '02':
                    phaseIndex = 1;
                    break;
                case '03':
                    phaseIndex = 2;
                    break;
                case '04':
                    phaseIndex = 3;
                    break;
                case '05':
                    phaseIndex = 4;
                    break;
            }

            if ((curMonth > 8 && curDay >= 15) || curMonth > 9) {
                if (gradeIdx >= 1) {
                    if (gradeIdx < phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx++;//超过九月中旬的了  加一年级

                    } else if (gradeIdx == phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx = 1;
                        phaseIndex++;
                    } else {
                        gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                        phaseIndex++;
                    }
                    gradeName = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                    gradeCode = phaseToGrade[phaseIndex].grade[gradeIdx - 1].code;
                } else {
                    gradeName = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                    gradeCode = phaseToGrade[phaseIndex].grade[gradeIdx].code;
                }
            } else {
                if (gradeIdx >= 1) {
                    if (gradeIdx > phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                        phaseIndex++;
                    }
                    gradeName = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                    gradeCode = phaseToGrade[phaseIndex].grade[gradeIdx - 1].code;
                } else {
                    gradeName = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                    gradeCode = phaseToGrade[phaseIndex].grade[gradeIdx].code;
                }

            }
            userInfo.classInfo[i].gradeName = gradeName;

            userInfo.classInfo[i].gradeCode = gradeCode;
        }
        return userInfo;
    }


    function FormatClassInfo(_userInfo, data) {
        var orgClass = [], freeClass = [];
        var classList = data.extInfo.orgClass || [], freeClassList = data.extInfo.freeClass || [];
        //----------------------------------handle grade info-------------------------
        var startYear,gradeName,gradeCode, curDate,curPhase,phaseIndex,curYear, curMonth, curDay;
        phaseIndex = 0;
        curDate = new Date();
        curYear = curDate.getFullYear();//当前年
        curMonth = curDate.getMonth() + 1;//当前月
        curDay = curDate.getDate();//当前天
        //----------------------------------------------------------------------------
        for (var i = 0, count = classList.length; i < count; i++) {
            var item = classList[i];
            //----------------------------------handle grade info---------------------
            curPhase = item.phase;//当前学段
            startYear = item.year;
            var gradeIdx = curYear - startYear;
            switch (curPhase) {//找到当前学段号对应的学段
                case '01':
                    phaseIndex = 0;
                    break;
                case '02':
                    phaseIndex = 1;
                    break;
                case '03':
                    phaseIndex = 2;
                    break;
                case '04':
                    phaseIndex = 3;
                    break;
                case '05':
                    phaseIndex = 4;
                    break;
            }

            if ((curMonth > 8 && curDay >= 15) || curMonth > 9) {
                if (gradeIdx >= 1) {
                    if (gradeIdx < phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx++;//超过九月中旬的了  加一年级

                    } else if (gradeIdx == phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx = 1;
                        phaseIndex++;
                    } else {
                        gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                        phaseIndex++;
                    }
                    gradeName = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                    gradeCode = phaseToGrade[phaseIndex].grade[gradeIdx - 1].code;
                } else {
                    gradeName = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                    gradeCode = phaseToGrade[phaseIndex].grade[gradeIdx].code;
                }
            } else {
                if (gradeIdx >= 1) {
                    if (gradeIdx > phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                        phaseIndex++;
                    }
                    gradeName = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                    gradeCode = phaseToGrade[phaseIndex].grade[gradeIdx - 1].code;
                } else {
                    gradeName = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                    gradeCode = phaseToGrade[phaseIndex].grade[gradeIdx].code;
                }

            }
            //----------------------------------------------------------------------------




            var rs = {
                "classCode": item.classShortId || "",
                "classShortId": item && item.classShortId || "",
                "classId": item.id || "",
                "className": item.className || "",
                "shortName": item.shortName || "",
                "eduSystem": item.eduSystem || "",
                "classLabel": item.classLabel || "",
                "classOrder": item.classOrder || "",
                "passed": item.passed || "",
                "createTime": "undefined",
                "phase": item.phase || "",
                "schoolId": item.schoolId || "",
                "schoolName": "undefined",
                "studentCount": "undefined",
                "subject": "undefined",
                "subjectName": "undefined",
                "year": item.year || "",
                "extInfo": item.extInfo || "",
                "gradeName":gradeName,
                "gradeCode":gradeCode,
            };
            orgClass.push(rs);
        }
        //这里对自由班级做格式化处理，是为了在后期班级合并展示时避免兼容性问题
        for (var i = 0, count = freeClassList.length; i < count; i++) {
            var item = freeClassList[i];
            var rs = {
                "classCode": item.classShortId || "undefined",
                "classShortId": item.classShortId || "",
                "classId": item.id || "",
                "className": item.className || "",
                "shortName": "undefined",
                "eduSystem": "undefined",
                "classLabel": "undefined",
                "classOrder": "undefined",
                "passed": "undefined",
                "createTime": "undefined",
                "grade": item.grade || "",
                "phase": item.phase || "",
                "schoolId": item.schoolId || "",
                "schoolName": "undefined",
                "studentCount": "undefined",
                "subject": "undefined",
                "subjectName": "undefined",
                "year": item.year || "",
                "extInfo": item.extInfo || ""
            };
            freeClass.push(rs);
        }
        _userInfo.classInfo = orgClass;
        _userInfo.freeClass = freeClass;
        userInfo = _userInfo;
        return userInfo;

    }


    /**
     * 获取文件的MD5
     * @param filepath
     * @returns {*}
     * @private
     */
    function _getFileMd5(filepath) {
        //读取一个Buffer
        var buffer = fs.readFileSync(filepath);
        var fsHash = crypto.createHash('md5');

        fsHash.update(buffer);
        var md5 = fsHash.digest('hex');
        return md5;
    }

    /**
     * 生成随机长度的字符串
     * @param len 生成的长度 可选 未传则生成32的
     * @private
     */
    function _getRandomString(len) {
        var len = len || 32;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
        var maxPos = $chars.length;
        var pwd = '';
        for (var i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd.toLowerCase();
    }


    /**
     * 根据预上传返回的host和其他参数开始正式上传,此时为发送socket消息
     * @param params
     * @param prepareInfo
     * @private
     */
    function uploadKtsl2J0(id, uid, zipPath, isHistory) {
        if (isHistory == 'true') $('#win_close').attr('ktsl_history', 'true');
        var data = {
            id: id,
            multi: 1,
            url: Base_Cfg.J0_BASE + "/api4/ifly/jxt/xclass/upload.json",
            key: 'file',
            source: 'ta_ktsl_upload',
            file: zipPath,
            extra: {
                uuid: uid
            },
            raw_data: {
                ktId: id,
                uid: uid,
                isHistory: isHistory
            }

        };
        var obj = {
            "type": 'logic',
            "action": 'ta_upload',
            "from": 'main',
            "to": 'ta_dum',
            "id": id,
            "data": data
        };
        socket.send(obj);
    }


    function invokeHistory(time) {
        return;
        setTimeout(innerHandle, time * 1000);
        function innerHandle() {
            if ($('#win_close').attr('ktsl_history') == 'true' || !APPManager.onlineFlag) {
                return;
            }
            var db = new sqlite3.Database(DBPATH);
            var sql = "select * from ktsl where over='1' order by startTime desc";
            db.all(sql, function (err, row) {
                db.close();
                if (!err && row.length) {
                    var zipPath = ktslDir + row[0].id + '.xclass';
                    if(fs.existsSync(zipPath)){
                        uploadKtsl2J0(row[0].id, row[0].userId, zipPath, 'true');
                    }else {
                        startUploadPrepare(row[0].id, row[0].userId,row[0].classId,'true');
                    }

                }
            })

        }
    }

    /**
     * 接收真实上传的回调信息,完成 后进行相应的处理
     * @param _data
     */
    function onReceiveMessage(_data) {
        var userInfo = getUserInfo();
        if (_data.source == 'ta_ktsl_upload' && _data.process == 100) {
            if (JSON.parse(_data.response_message).status == 200) {
                if (onLoginFlag && userInfo.id == _data.raw_data.uid && _data.raw_data.isHistory != 'true') {
                    $('#win_close').attr('ktsl', 'false');//
                    shellcmd.trayTips('课堂实录保存成功');
                }
                var ktslSql = "delete from ktsl where id='" + _data.raw_data.ktId + "'";
                var db = new sqlite3.Database(DBPATH);
                console.log(sql);
                db.exec(ktslSql, function (err) { //更新DB为上传完成的状态
                    db.close();
                    deleteKtsl(_data.raw_data.ktId);
                    if (_data.raw_data.isHistory == 'true') {
                        $('#win_close').attr('ktsl_history', 'false');
                        invokeHistory(0);
                    }
                });


            } else {
                if (onLoginFlag && userInfo.id == _data.raw_data.uid && _data.raw_data.isHistory != 'true') {
                    $('#win_close').attr('ktsl', 'false');
                    shellcmd.trayTips('课堂实录保存失败');
                }
                var db = new sqlite3.Database(DBPATH);
                var sql = "update ktsl set over='1' where id='" + _data.raw_data.ktId + "'";
                console.log(sql);
                db.exec(sql, function (err) { //更新DB为上传失败的状态
                    db.close();
                    if (_data.raw_data.isHistory != 'true' && APPManager.onlineFlag) invokeHistory(20);
                    else $('#win_close').attr('ktsl_history', 'false');
                })
            }

        } else if (_data.source == 'ta_ktsl_upload' && _data.process == -1) {
            if ( onLoginFlag && userInfo.id == _data.raw_data.uid && _data.raw_data.isHistory != 'true') {
                $('#win_close').attr('ktsl', 'false');
                shellcmd.trayTips('课堂实录保存失败');
            }

            var db = new sqlite3.Database(DBPATH);
            var sql = "update ktsl set over='1' where id='" + _data.raw_data.ktId + "'";
            console.log(sql);
            db.exec(sql, function (err) { //更新DB为上传失败的状态
                db.close();
                if (_data.raw_data.isHistory != 'true') invokeHistory(20);
                else $('#win_close').attr('ktsl_history', 'false');
            })
        } else {
            if (userInfo.id == _data.raw_data.uid && _data.raw_data.isHistory != 'true') $('#win_close').attr('ktsl', 'true');
        }
    }

    function handleEvent(from, data) {
        console.log(from + data.toString());
        if (data.return) return;
        if (data.class == 'goPage') {
            goPages(data.toWhere);
            return;
        }
        if (data.class == 'getClassInfo') {
            _socketClassInfo(from);
            return;
        }
        return;
        var db = new sqlite3.Database(DBPATH);
        var sql = "select * from current";
        db.all(sql, function (err, rows) {
            db.close();
            if (!err && rows.length != 0) {
                if (data.class == 'zip') {
                    // changeStatus(from,data);
                    receiveZip(from, data, rows[0]);
                } else if (data.class == 'over') {
                    if (data.existZip == 1) {
                        receiveZip(from, data, rows[0], function () {
                            checkMicroCourse(data,rows[0].id,function (exist) {
                                if(exist) overKtsl(data,rows[0]);
                                else cancelKtsl();
                            });
                        })
                    } else {
                        checkMicroCourse(data,rows[0].id,function (exist) {
                            if(exist) overKtsl(data,rows[0]);
                            else cancelKtsl();
                        });
                    }
                } else if (data.class == 'cancel') {
                    cancelKtsl();
                }
            } else {
                data.isDelete == 1 && shellcmd.deleteFile(data.src);
            }
        });

    }
    
    function checkMicroCourse(data,ktId,callback) {
        if(data.lessSaveFlag){
            callback&&callback(true);
        }else {
            var db = new sqlite3.Database(DBPATH);

           var sql = "select *  from zips where ktId='"+ktId+"'";
            db.all(sql,function (e,rows) {
                if(e||rows.length<=0){
                    db.close();
                    callback&&callback(false);
                }
                else {
                    var count = 0;
                    for(var k in rows){
                        count = count + rows[k].microCourseCount;
                    }
                    if(count<=0){
                        db.close();
                        callback&&callback(false);
                    }
                    else {
                        sql = "delete from zips where microCourseCount=0 and ktId='"+ktId+"'";
                        db.exec(sql,function (err) {
                            db.close();
                           if(err)  callback&&callback(false);
                           else {
                               for(var j in rows){
                                   if(rows[j].microCourseCount==0) fs.unlinkSync(rows[j].src);
                               }
                               callback&&callback(true);
                           }
                        });

                    }
                }
            })


        }
    }
    
    function goPages(toWhere) {
        switch (toWhere) {
            //跳转到创建班级
            case 'createClass':
                //des单点登录地址
                // loginUrl(Base_Cfg.YUN_CREATE_CLASS);
                //sso单点登录地址
                TA.Utils.openWebPage(APP_CONFIG.YUN_CREATE_CLASS + '&' + 'from=ew&appId=web');
                break;
            //跳转到个人工作台  目前只是合肥局校平台的跳转 下同
            case 'personal':
                loginSsoUrl(Base_Cfg.KTSL_CHANGYAN_URL);
                break;
            case 'relation':
                //des单点登录地址
                // loginUrl(Base_Cfg.HEFEI_JX + "/area/loginCheck.action?", true);
                //sso单点登录地址
                TA.Utils.openWebPage(Base_Cfg.HEFEI_JX + "/area/login.action?from=ew&appId=jxpt");
                break;
            case 'workbench':
                //des单点登录地址
                // loginUrl(Base_Cfg.HEFEI_JX + "/area/loginCheck.action?", true);
                //sso单点登录地址
                TA.Utils.openWebPage(Base_Cfg.HEFEI_JX + "/area/login.action?from=ew&appId=jxpt");
                break;
        }
    }

    function loginSsoUrl(url) {
        var userInfo = getUserInfo();
        if(!userInfo._user_userAppName||userInfo._user_userAppName==""){
            TA.Utils.openWebPage(url+'/?from=ew&appId=7affaf7a522a46c8a4da908381be0c13');
        }else {
            getUserUrlCfg(userInfo._user_userAppName).done(function (ret) {
                TA.Utils.openWebPage(ret+'/?from=ew&appId=7affaf7a522a46c8a4da908381be0c13');
            }).fail(function () {
                TA.Utils.openWebPage(url+'/?from=ew&appId=7affaf7a522a46c8a4da908381be0c13');
            });
        }
    }

    function getUserUrlCfg(appName) {
        var url = null;
        var def = $.Deferred();
        edcService.Instance().ita_get_appname_url().done(function (ret) {
            ret = JSON.parse(ret);
                if(ret.code==1){
                    for(var i=0,len=ret.list.length;i<len;i++){
                        if(appName==ret.list[i].appName){
                            url = ret.list[i].url;
                            break;
                        }
                    }
                    if(url) def.resolve(url);
                    else def.reject();
                }else {
                    def.reject();
                }
            }
        );
        return def.promise();
    }

    function loginUrl(url, last) {
        var userInfo = getUserInfo();
        DES.init(APP_CONFIG.DESKEY, userInfo._sso_loginName + "=" + userInfo.password);
        var token = DES.Encrypt();
        if (last) url = url + "token=" + token;
        else url = url + "&token=" + token;
        startWeb(url);
    }

    function cancelKtsl() {
        var db = new sqlite3.Database(DBPATH);
        var sql = "select * from current";
        db.all(sql, function (err, row) {
            // db.close();
            if (err || !row.length) {
                db.close();
            } else {
                sql = 'delete from current';
                db.exec(sql, function (err) {
                    db.close();
                    deleteKtsl(row[0].id);
                });
            }
        });

    }

    function deleteKtsl(ktId) {
        var TADB = new sqlite3.Database(DBPATH);
        var IFBDB = new sqlite3.Database(IFBPATH);
        //1.delete ktsl
        var ktslSql = "delete from ktsl where id='" + ktId + "'";
        //2.delete zips
        var zipsSql = "delete from zips where ktId='" + ktId + "'";
        //3.delete real zip
        // fs.unlinkSync(ktslDir + ktId + ".xclass");
        shellcmd.deleteFile(ktslDir + ktId + ".xclass");
        //4.delete files
        var filesSql = "delete from files";
        //5.delete real folder
        shellcmd._rmdirASync(ktslDir + ktId);
        //6.delete ifb real folder
        shellcmd._rmdirASync(IFBDir + ktId);

        TADB.exec(ktslSql, function (err) {
            TADB.exec(zipsSql, function (err) {
                TADB.close();
            })
        });
        IFBDB.exec(filesSql, function (err) {
            IFBDB.close();
        });
    }

    function receiveZip(from, data, dbData, callback) {
        var fromWhere = 'iflybook';
        if (from == 'ib') {
            fromWhere = 'iflybook';
        } else if (from == 'iflyslide') {
            fromWhere = 'iflyslide';
        } else if (from == 'vote-main') {
            fromWhere = 'dtb';
        }
        var microCourseCount = data.microCourseCount||0;
        var fileName = fromWhere + "_" + _getRandomString(10) + ".zip";
        var newDir = ktslDir + dbData.id;
        var newFilePath = newDir + "/" + fileName;
        if (!fs.existsSync(newDir)) fs.mkdirSync(newDir);
        shellcmd.copyFile(data.src, newFilePath).done(function () {
            data.isDelete == 1 && shellcmd.deleteFile(data.src);
            var db = new sqlite3.Database(DBPATH);
            var id = _getRandomString();
            var sql = "insert into zips values('" + id +
                "','" + dbData.id +
                "','" + newFilePath +
                "','" + data.isDelete +
                "','" + fromWhere + "',"+microCourseCount+")";
            db.exec(sql, function (err) {
                db.close();
                callback && callback();
            });
        });


    }


    function overKtsl(data, dbData) {
        var db = new sqlite3.Database(DBPATH);
        var sql = 'delete from current';
        var userInfo = getUserInfo();
        if (dbData.ifbStatus != 1 && dbData.ifsStatus != 1) {
            db.exec(sql, function (err) {
                var time = _formatTimeStamp(Date.parse(new Date()));
                var id = dbData.id;
                var name = data.name != '' ? data.name : '课堂实录 ' + time;
		        var lessSaveFlag = data.lessSaveFlag||0;
                sql = "insert into ktsl values('" + id + "','" + dbData.openId +
                    "','" + name +
                    "','" + data.grade +
                    "','" + data.className +
                    "','','" + dbData.startTime +
                    "','" + time +
                    "',0,'" + data.classId + "','" + data.toWhere + "','" + userInfo.id + "',"+lessSaveFlag+")";
                db.exec(sql, function (err) {
                    db.close();
                    if (!err) {
                        saveMeta(data, dbData, userInfo, name, time, function (exist) {
                            if (exist) {
                                if (!lessSaveFlag){
                                    var db = new sqlite3.Database(DBPATH);
                                    var sql = "update ktsl set over='1' where id='" + id + "'";
                                    console.log(sql);
                                    db.exec(sql, function (err) { //更新DB为上传失败的状态
                                        db.close();
                                        invokeHistory(1);
                                    });

                                }else if(!APPManager.onlineFlag) {
                                    var db = new sqlite3.Database(DBPATH);
                                    var sql = "update ktsl set over='1' where id='" + id + "'";
                                    console.log(sql);
                                    db.exec(sql, function (err) { //更新DB为上传失败的状态
                                        db.close();
                                        shellcmd.trayTips("离线课堂实录无法上传，请联网");
                                    });

                                } else {
                                    shellcmd.trayTips('正在保存课堂实录...');
                                    $('#win_close').attr('ktsl', 'true');
                                    startUploadPrepare(id, userInfo.id,data.classId);
                                }

                            } else {
                                deleteKtsl(id);
                            }

                        });

                    }
                })
            })
        }

    }

    function saveMeta(data, dbData, userInfo, name, time, callback) {
        var path = ktslDir + dbData.id + '/meta.dat';
        var db = new sqlite3.Database(DBPATH);
        var sql = "select * from zips where ktId='" + dbData.id + "'";
        db.all(sql, function (err, row) {
            db.close();
            if (err || !row.length) {
                callback(false);//不存在课堂实录
            }
            var files = [];
            for (var i = 0, l = row.length; i < l; i++) {
                files.push({
                    src: row[i].src.substr(row[i].src.lastIndexOf('/') + 1),
                    from: row[i].from
                })
            }

            var json = {
                type: "XClass",
                userId: userInfo.id,
                openId: dbData.openId,
                name: name,
                description: "",
                grade: data.grade || "",
                className: data.className || "",
                classId: data.classId || "",
                toWhere: data.toWhere,
                startLessonDatetime: dbData.startTime,
                stopLessonDatetime: time,
                createDateTime: _formatTimeStamp(Date.parse(new Date())),
                files: files,
                lessSaveFlag:data.lessSaveFlag||0
            };

            fs.writeFileSync(path, JSON.stringify(json));
            callback && callback(true);
        });

    }

    function startUploadPrepare(id, uid,classId,isHistory) {

        GSScount(id,classId,function (isCorrect) {
            if(!isCorrect){
                var userInfo = getUserInfo();
                if(userInfo.id == uid && isHistory!='true'){
                    $('#win_close').attr('ktsl', 'false');
                    shellcmd.trayTips('课堂实录保存失败');
                    var db = new sqlite3.Database(DBPATH);
                    var sql = "update ktsl set over='1' where id='" + id + "'";
                    db.exec(sql, function (err) { //更新DB为上传失败的状态
                        db.close();
                    });
                    if(APPManager.onlineFlag) invokeHistory(20);
                }
                shellcmd.deleteFile(ktslDir + id + '.xclass');
                return;
            }
            var pathDir = ktslDir + id;
            var zipPath = ktslDir + id + '.xclass';
            pathDir = pathDir.replace(/\//g, "\\");
            zipPath = zipPath.replace(/\//g, "\\");
            zipUtil.updateZipFile(pathDir, zipPath, function (e) {
                uploadKtsl2J0(id, uid, zipPath,isHistory);
            });
        });

    }
    
    function GSScount(id,classId,callback) {
        if(classId&&classId!=''&&classId!=null){
            var p = {
                classIds:classId
            };
            edcService.Instance().core_class_org_count_student(p).done(function (ret) {
                console.log(ret);
                if(ret&&ret.code ==0){
                    updateMetaStudentNumber(id,ret.data[classId]);
                    callback&&callback(true);
                }else {
                    callback&&callback(false);
                }
            }).fail(function () {
                callback&&callback(false);
            });
        }else {
            updateMetaStudentNumber(id,0);
            callback&&callback(true);
        }
    }

    function updateMetaStudentNumber(id,count) {
        var path = ktslDir + id +'/meta.dat';
        var data = JSON.parse(fs.readFileSync(path));
        data.studentsNumber = count || 0;
        fs.writeFileSync(path,JSON.stringify(data));
    }
    

    function deleteKtslRows(id, callback) {
        var db = new sqlite3.Database(DBPATH);
        var sql = "delete from ktsl where id='" + id + "'";
        db.exec(sql, function (err) {
            db.close();
            callback && callback();
        })
    }

    function deleteEventsRows(ktId, callback) {
        var db = new sqlite3.Database(DBPATH);
        var sql = "delete from events where ktId='" + ktId + "'";
        db.exec(sql, function (err) {
            db.close();
            callback && callback();
        })
    }

    function deleteFilesRows(ktId, callback) {
        var db = new sqlite3.Database(DBPATH);
        var sql = "delete from files where ktId='" + ktId + "'";
        db.exec(sql, function (err) {
            db.close();
            callback && callback();
        })
    }

    /**
     * 格式化时间戳
     * @param timestamp
     * @private
     */
    function _formatTimeStamp(timestamp) {
        if (typeof timestamp == "string") timestamp = parseInt(timestamp);
        return (new Date(timestamp)).Format("yyyy-MM-dd hh:mm:ss");

    }

    /**
     * 切换登录的时候取消此次课堂实录
     */
    function initHistory() {
        return;
        cancelKtsl();
    }

    function cleanHistory() {
        return;
        cancelKtsl();
        invokeHistory(60);
    }

    return {
        onReceiveMessage: onReceiveMessage,
        handleEvent: handleEvent,
        initHistory: initHistory,
        cleanHistory: cleanHistory,
        invokeHistory: invokeHistory
    }

})();