/**
 *
 * User: chengyang@iflytek.com
 * Date: 15-8-22 下午8:19
 * Version: 1.0
 */

var iflybookModule = (function(){

    var finalUserInfo;
    var userAccount;
    var password;

    var CloudResult = {
        webError : 1,
        accountOrPwdWrong : 2,
        accountPwdRight : 3,
        isDeleOrOutDate : 4,
        isDele : 11, // 区分dele和outdate
        isOutDate : 12, // 区分dele和outdate
        isNormal : 5,
        alreadyBind : 6,
        bindSuccess : 7,
        canNotBind : 8,
        getBindMsgError : 9,
        bindFail : 10,
        roleError : 20,
        autoAccountForbidden: 21, // 用户被冻结
        autoSSOValidateError:22, //sso单点登录失败

        spaceError:30,
        machineError:31
    };
    var result = CloudResult.bindSuccess;

    var AppTips = {
        "OutOFMemoryMsg": "磁盘空间不足",
        "loginWrongMachineMsg": "无法获取机器信息",
        "NetWorkConnectFailed":"网络连接异常，请检查网络",
        "localLoginWrongPasswordMsg": "账号或密码错误",
        "accountForbiddenMsg": "该用户被禁用或账户过期",
        "bindOverflowMsg": '授权数量已达上限',
        "bindFailMsg": "硬件绑定失败",
        "loginCreateFolderFailMsg": "创建用户目录失败",
        "ULicOutDateMsg" : "U盘授权已过期，请联网更新U盘授权",
        "bookLicOutdateMsg": "课本已过期，不能继续使用",
        "NotFindURight" : "请插入授权U盘后再打开课本"
    };

    var UpanResult = {
        "checkSuccess":1,
        "bookLicOutdate":-1,
        "ULicOutDate":-2,
        "NotFindURight":-3
    };

    function beforeLogin(account, pwd, $login){
        var def = $.Deferred();
        finalUserInfo = $login;
        userAccount = account;
        password = pwd;
        //检查环境
        shellcmd.checkEnvironment().done(function (isEnvironmentAllowed) {
            if (isEnvironmentAllowed) {
                shellcmd.checkRunningDiskSpace().done(function (freeSpace) {
                    console.log(freeSpace);
                    if (freeSpace < APP_CONFIG.memoryRequired) {
                        result = CloudResult.spaceError;
                        def.resolve(finalUserInfo)
                    } else {
                        checkInfo(account,pwd).done(function(ret){
                            result = ret;
                            if(result == CloudResult.alreadyBind || result == CloudResult.bindSuccess || result == CloudResult.canNotBind){
                                createUserFolder(userAccount).done(function(){
                                    def.resolve(finalUserInfo);
                                })
                            }else{
                                def.reject(ret);
                            }
                        }).fail(function(errCode){
                            def.reject(errCode);
                        });
                    }
                });
            } else {
                result = CloudResult.machineError;
                def.resolve(finalUserInfo);
            }
        });
        return def.promise();
    }

    function checkInfo(account, pwd) {
        var def = $.Deferred();
        checkEshopInfo(account, pwd).done(function (ret) {
            console.log("checkEshopInfo :: " + ret + "----" + new Date());
            if (ret === CloudResult.isNormal) {
                //可用
                var user = {
                    userAccount: account,
                    userEmail: finalUserInfo.userInfo.email || "",
                    userPhone: finalUserInfo.userInfo.mobile || "",
                    isActive: finalUserInfo.userInfo.isActive,
                    userName: finalUserInfo.userInfo.userName || "",
                    uid: finalUserInfo.userInfo.id || "",
                    // 以下为扩展属性
                    user_openId: userInfo._user_openId || "",
                    user_enName: userInfo.enName || "",
                };

                //这里不更新用户信息是因为TA的shellcmd不支持desEncrpty，直接崩溃
                //同时TA的des加密和iflybook的加密结果不一致
                shellcmd.desEncrpty(password, userAccount).done(function (passwordData) {
                    console.log("shellcmd.desEncrpty:" + passwordData);
                    if(!password){
                        passwordData = "";
                    }
                    addUserToLocalDb(user, passwordData, 1).done(function () {
                        checkBindInfo(userAccount, password).done(function (ret1) {
                            result = ret1;
                            def.resolve(ret1);
                        });
                    });
                });
            }else if(ret === CloudResult.isDele){
                def.reject(CloudResult.isDele);
            }else if(ret === CloudResult.isOutDate){
                def.reject(CloudResult.isOutDate);
            }else if(ret === CloudResult.webError){
                def.reject(CloudResult.webError);
            }
            else {
                def.resolve(ret);
            }
        });
        return def.promise();
    }

    function checkEshopInfo(account,pwd){
        var def = $.Deferred();
        var httpurl = APP_CONFIG.ESHOP + "/index.php?c=userServices&a=isActive";
        var msgJson = {
            url: httpurl,
            loginName: account
        };
        shellcmd.postHttpRequest(msgJson).done(function (ret) {
            var retObj , _res;
            try{
                if(ret) {
                    retObj = JSON.parse(ret);
                }
            }catch(e){
                ret = "";
                retObj = [];
            }
            if(ret) {
                console.log(retObj ? retObj : ret);
                //返回[],新账号
                if (retObj instanceof Array && retObj.length == 0) {
                    if (finalUserInfo.userInfo.mobile) {
                        finalUserInfo.userInfo.isActive = true;
                    }
                    def.resolve(CloudResult.isNormal);
                }
                else if (retObj) {
                    //返回对象，有值
                    _res = retObj.isDelete === 1 ? CloudResult.isDele : CloudResult.isNormal;
                    var nowDate = new Date();
                    var retDate = Date.parse(retObj.outDate);
                    _res = (nowDate < retDate ) ? _res : CloudResult.isOutDate;
                    finalUserInfo.userInfo.isActive = (!!(retObj.isActive == 1));
                    if (finalUserInfo.userInfo.mobile) {
                        finalUserInfo.userInfo.isActive = true;
                    }
                }
            }
            //返回 "" 字符串
            def.resolve(ret ? _res : CloudResult.webError);
        });
        return def.promise();
    }

    function checkBindInfo(account, pwd) {
        var def = $.Deferred();
        var getHdTypeTask = shellcmd.getHardwareType();
        var getHdInfoTask = shellcmd.getHardwareInfo(account);
        var hdNameTask = shellcmd.getHardwareName();
        $.when(getHdTypeTask, getHdInfoTask, hdNameTask).done(function (hdType, hdInfo, hdName) {
            var httpurl = APP_CONFIG.ESHOP + "/index.php?c=userServices&a=get_auth_status";
            var msgJson = {
                url: httpurl,
                account: account,
                hardware: hdInfo,
                machinename: hdName,
                hdtype: hdType,
                password: pwd || password
            };
            shellcmd.postHttpRequest(msgJson).done(function (ret) {
                console.log(ret);
                if(ret && ret != ''){
                    var retResult = null;
                    try{
                        var retObj = JSON.parse(ret);
                    }catch(e){
                        ret = "";
                        var retObj = {};
                        console.error(e);
                    }
                    switch (parseInt(retObj.statuscode)) {
                        case 0:
                            retObj.userLoginName && (finalUserInfo.userInfo.userLoginName = retObj.userLoginName);
                            retObj.userFrom && (finalUserInfo.userInfo.userFrom = retObj.userFrom);
                            retObj.ticket && (finalUserInfo.userInfo.setSSOTicket = retObj.ticket);
                            if (retObj.bindcode == 0) retResult = CloudResult.bindSuccess;
                            if (retObj.bindcode == 1) retResult = CloudResult.bindFail;
                            break;
                        case 1:
                            retResult = CloudResult.canNotBind;
                            break;
                        case 2:
                            retResult = CloudResult.alreadyBind;
                            retObj.userLoginName && (finalUserInfo.userInfo.userLoginName = retObj.userLoginName);
                            retObj.userFrom && (finalUserInfo.userInfo.userFrom = retObj.userFrom);
                            retObj.ticket && (finalUserInfo.userInfo.setSSOTicket = retObj.ticket);
                            break;
                        case 3:
                            retResult = CloudResult.getBindMsgError;
                            break;
                    }
                    result = ret ? retResult : CloudResult.webError;
                    def.resolve(ret ? retResult : CloudResult.webError);
                }else{
                    def.resolve(CloudResult.webError);
                }
            });
        });
        return def.promise();
    }

    // TODO(xinfang3): 2016-09-5 15:36:10,该方法在用户接入sso时可以通过接口一次性获取，该接口方法废弃,或者可以重写.
    function getClassInfo(){
        var def = $.Deferred();
        TA_Token_Manager.getInterface(function(interUrl){
            $.ajax({
                url:interUrl+'method=jx.class.list&version=1.0&format=json&userId='+ finalUserInfo.userInfo.id + '&roleName=' + finalUserInfo.userInfo.enName,
                type:'get',
                timeout:4000,
                dataType:'json',
                success:function(result){
                    def.resolve(result);
                },
                error:function(err){
                    console.log(err);
                    var arr = [];
                    def.resolve(arr);
                }
            });
        },"center");
        return def.promise();
    }

    function getPointsAndBooks(account){
        var def = $.Deferred();
        var msgJson = {
            url: APP_CONFIG.ESHOP + "/index.php?c=userServices&a=getPointsAndCards",
            account:account
        };
        shellcmd.postHttpRequest(msgJson).done(function (ret) {
            try{
                var jsonObj = JSON.parse(ret);
                console.log(jsonObj);
                def.resolve({points:jsonObj.points, books:jsonObj.bookAllNum});
            }
            catch(e){
                def.resolve({points:0, books:0});
            }
        });
        return def.promise();
    }

    function addUserToLocalDb(userInfo, passwordData, rememberPasswordFlag) {
        var def = $.Deferred();
        var account = userInfo.userAccount;
        var email = userInfo.userEmail;
        var phone = userInfo.userPhone;
        var isActive = userInfo.isActive;
        var userName = userInfo.userName;
        var reserve1 = {
            userName: userInfo.userName || "",
            uid: userInfo.uid || "",
            user_openId: userInfo.user_openId || "",
            user_enName: userInfo.user_enName || "",
            sso_loginName: userInfo.sso_loginName || undefined,
            sso_openId: userInfo.sso_openId || undefined,
            sso_tgt: userInfo.sso_tgt || undefined,
            sso_userId: userInfo.sso_userId || undefined,
            bind_user_exchange_openId: userInfo.bind_user_exchange_openId || undefined,
            bind_user_openId: userInfo.bind_user_openId || undefined,
            bind_user_userAppName: userInfo.bind_user_userAppName || undefined,
            bind_user_loginName: userInfo.bind_user_loginName || undefined,
            rsa_encrypted_password: userInfo.rsa_encrypted_password || undefined,
            bind_user_enName: userInfo.bind_user_enName || undefined,
        };
        // 过滤参数
        for (var key in reserve1) {
            if (reserve1[key] === undefined) {
                delete reserve1[key];
            }
        }
        var reserve1_stringify = JSON.stringify(reserve1);
        getAccount(account).done(function (isAccountExist) {
            if (isAccountExist == null || isAccountExist == '' || isAccountExist == 0) {
                addAccount(account, email, phone, passwordData, rememberPasswordFlag, isActive, reserve1_stringify)
                    .done(function (ret) {
                        def.resolve(ret);
                    });
            } else {
                updateAccount(account, email, phone, passwordData, rememberPasswordFlag, isActive, reserve1_stringify)
                    .done(function (ret) {
                        def.resolve(ret);
                    });
            }
        });
        return def.promise();
    }

    function getAccount(inputinfo) {
        var def = $.Deferred();
        var dbPath = APP_CONFIG.IFB_PATH + "iflybook.db";
        var sqlStr = 'select account from users where account="' + inputinfo +
            '" or email="' + inputinfo + '" or phone="' + inputinfo + '"';
        shellcmd.getFirstItemAsyn(dbPath, sqlStr).done(function (account) {
            def.resolve(account);
        });
        return def.promise();
    }

    function addAccount(account, email, phone, password, rememberPasswordFlag,isActive,reserve1_stringify) {
        var def = $.Deferred();
        var dbPath = APP_CONFIG.IFB_PATH + "iflybook.db";
        var _nowDate = (new Date()).Format("yyyy-MM-dd hh:mm:ss.S");
        var sqlStr = "insert into users(account,email,phone,password,IsRememberPasswordOrNot,isActive,lastLoginTime,reserve1) values('" +
            account + "','" +
            email + "','" +
            phone + "','" +
            password + "','" +
            rememberPasswordFlag + "','" +
            isActive + "','" +
            _nowDate + "','" +
            reserve1_stringify.replace(/\'/g,"\'\'") + "')";
        shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
            def.resolve(ret);
        });

        return def.promise();
    }

    function updateAccount(account, email, phone, password, rememberPasswordFlag,isActive,reserve1_stringify) {
        var def = $.Deferred();
        var dbPath = APP_CONFIG.IFB_PATH + "iflybook.db";
        var _nowDate = (new Date()).Format("yyyy-MM-dd hh:mm:ss.S");
        var sqlStr = "update users set ";
        email && (sqlStr += "email='" + email + "',");
        phone && (sqlStr += "phone='" + phone + "',");
        password && (sqlStr += "password='" + password + "',");
        isActive && (sqlStr += "isActive='" + isActive + "',");
        reserve1_stringify && (sqlStr += "reserve1='" + reserve1_stringify.replace(/\'/g,"\'\'") + "', ");

        sqlStr += "IsRememberPasswordOrNOt='" + rememberPasswordFlag + "', " +
            "lastLoginTime='" + _nowDate + "'  " +
            "where account='" + account + "'";

        shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
            def.resolve(ret);
        });

        return def.promise();
    }


    function createUserFolder(userAccount) {
        var def = $.Deferred();
        var userPath = APP_CONFIG.IFB_PATH +  'users/' + userAccount;

        shellcmd.isDirExist(userPath).done(function (isExist) {
            if (!isExist) {
                createUserDir(userAccount).done(function (ret) {
                    def.resolve(ret)
                });
            } else {
                def.resolve(true);
            }
        });
        return def.promise();
    }

    function createUserDir(userAccount) {
        var def = $.Deferred();
        createUserFolders(userAccount).done(function (ret1) {
            if (ret1) {
                /*$.when(createUserXbDbByCopy(userAccount), createUserDbByCopy(userAccount)).done(function (retXB, ret2) {
                    def.resolve(ret2 && retXB)
                });*/
                createUserDbByCopy(userAccount).done(function (ret2) {
                    def.resolve(ret2);
                });
            }
            else {
                def.resolve(ret1)
            }
        });
        return def.promise();
    }

    /**
     * 创建用户文件夹
     * @returns {boolean}
     */
    function createUserFolders(userAccount) {
        var def = $.Deferred();
        var userPath = APP_CONFIG.IFB_PATH +  'users/' + userAccount;
        var userStdBookFolder = userPath + '/ebook';
        var userBookFolder = userPath + '/userbook';
        var userResourceFolder = userPath + '/localresource';
        var userWBFolder = userPath +  '/wboard';
        var userXBFolder = userPath + '/xbbook';


        shellcmd.createDir(userStdBookFolder).done(function (ret1) {
            if (ret1) {
                shellcmd.createDir(userBookFolder).done(function (ret2) {
                    if (ret2) {
                        shellcmd.createDir(userResourceFolder).done(function (ret3) {
                            if (ret3) {
                                shellcmd.createDir(userXBFolder).done(function (ret_xb) {
                                    if (ret_xb) {
                                        shellcmd.createDir(userWBFolder).done(function (ret4) {
                                            if (ret4) {
                                                var _xmlstr = '<eb:page background="1.jpg" xmlns:eb="EBookLib">' +
                                                    '<eb:absolutelayout></eb:absolutelayout></eb:page>';
                                                shellcmd.saveFile(_xmlstr, userWBFolder + "/wb.xaml");
                                                def.resolve(true);
                                            } else {
                                                def.resolve(false);
                                            }
                                        });
                                    } else {
                                        def.resolve(false);
                                    }
                                });
                            } else {
                                def.resolve(false);
                            }
                        });
                    } else {
                        def.resolve(false);
                    }
                });
            } else {
                def.resolve(false);
            }
        });
        return def.promise();
    }


    function createUserDbByCopy(userAccount){
        var def = $.Deferred();
        var srcFile = APP_CONFIG.IFB_PATH + 'users/template.db';
        var dstPath = APP_CONFIG.IFB_PATH + 'users/' + userAccount + '/userdb.db';

        shellcmd.copyFile(srcFile, dstPath).done(function () {
            var content = shellcmd.readFile(dstPath);
            if (content && content.length >=3000) { //成功
                def.resolve(true);
            } else {
                def.resolve(false);
            }
        });
        return def.promise();
    }
    /**
     * copy校本数据库
     * @param userAccount
     */
    function createUserXbDbByCopy(userAccount){
        var def = $.Deferred();
        var srcFile = APP_CONFIG.IFB_PATH + 'users/templatexb.db';
        var dstPath = APP_CONFIG.IFB_PATH + 'users/' + userAccount + '/userdbxb.db';

        shellcmd.copyFile(srcFile, dstPath).done(function () {
            var content = shellcmd.readFile(dstPath);
            if (content && content.length >=3000) { //成功
                def.resolve(true);
            } else {
                def.resolve(false);
            }
        });
        return def.promise();
    }

    /**
     * 更新用户授权
     */
    function writeUserLic() {
        //获取用户登录授权文件
        var getHdTypeTask = shellcmd.getHardwareType();
        var getHdInfoTask = shellcmd.getHardwareInfo(userAccount);
        $.when(getHdTypeTask, getHdInfoTask).done(function (hdType, hardwareInfo) {
            callGetUserLicense(hardwareInfo, hdType).done(function (dataReceived) {
                var retObj = userLicDataConverter(dataReceived);
                if (retObj.statusCode == 0 && retObj.data) {
                    shellcmd.saveFile(retObj.data, APP_CONFIG.IFB_PATH +  'users/' + userAccount + '/license.dat' )
                }
            });
        });
    }

    /**
     * 获取用户授权文件
     * @param hdInfo
     * @param hdType
     * @returns {{}}
     */
    function callGetUserLicense(hdInfo, hdType) {
        var def = $.Deferred();
        var httpurl = APP_CONFIG.ESHOP + "/index.php?c=userServices&a=get_userlicense_handler";
        var msgJson = {
            url: httpurl,
            account: userAccount,
            pwd: password,
            hardware: hdInfo,
            hdtype: hdType
        };
        shellcmd.postHttpRequest(msgJson).done(function (ret) {
            def.resolve(ret);
        });

        return def.promise();
    }

    function userLicDataConverter(dataReceived) {
        console.log("下载用户LIC:" + dataReceived);
        var retObj = {};
        retObj.statusCode = -1;
        retObj.data = '';
        if (dataReceived == null || dataReceived == "") {
            retObj.statusCode = -1;
            return retObj
        }
        var jsonReceived = null;
        try {
            jsonReceived = JSON.parse(dataReceived);
            retObj.statusCode = parseInt(jsonReceived.statuscode);
            retObj.data = jsonReceived.license;
            return retObj;
        }
        catch (err) {
            console.log("下载用户License返回数据无法解析");
            retObj.statusCode = -1;
            return retObj;
        }
    }

    /**
     * 启动上传
     */
    function StartUpload() {
        //写上传参数文件，启动上传器
        var obj = {
            'appkey': 'HWQIjW2K',
            'token': "changyanyun",
            'uid': finalUserInfo.userInfo.id,
            'loginname': userAccount
        };
        var str = JSON.stringify(obj);
        var filePath = APP_CONFIG.IFB_PATH + 'users/';
        shellcmd.saveFile(str, filePath + 'awdlog.cr');
        var uploadManagerexe =APP_CONFIG.IFB_PATH + 'iFlybookUploadMananger.exe';
        shellcmd.shellexecutewithargs(uploadManagerexe, APP_CONFIG.BASE_CYSERVICE + "api");
        console.log('uploadManagerexe start success!');
    }


    function getResult(){
        return result;
    }

    function checkU(isU, userName, bookCode,bookId){
        var def = $.Deferred();
        if(!isU){
            def.resolve(UpanResult.checkSuccess);
        }else{
            var hdInfoTask = shellcmd.getHardwareInfo(userName);
            var hdTypeTask = shellcmd.getHardwareType();
            $.when(hdInfoTask, hdTypeTask).done(function (hdInfo, hdType) {
                callGetBookLicense(bookId, bookCode, userName,hdInfo, hdType).done(function (bookLicResult) {
                    if (!bookLicResult) {
                        console.log("下载书本授权文件失败");
                        shellcmd.checkU(isU,userName).done(function(U){
                            if(U){
                                checkULicOutDate(U,userName,bookCode,isU).done(function(ret){
                                    console.log(ret);
                                    if(ret == 4){
                                        checkUBookOutdate(bookCode,isU,userName).done(function (isBookLicOutdate) {
                                            if (isBookLicOutdate) {  //如果过期
                                                def.resolve(UpanResult.bookLicOutdate);
                                            }else{
                                                def.resolve(UpanResult.checkSuccess);
                                            }
                                        });
                                    }
                                    else if(ret == 3){
                                        def.resolve(UpanResult.ULicOutDate);
                                    }
                                    else if(ret == -1){
                                        def.resolve(UpanResult.ULicOutDate);
                                    }
                                });
                            }
                            else{
                                def.resolve(UpanResult.NotFindURight);
                            }
                        });
                    }else{
                        changeBookIsU(bookCode,"",userName).done(function(){
                            def.resolve(UpanResult.checkSuccess);
                        });
                    }
                })
            });
        }

        return def.promise();
    }


    function checkULicOutDate(U,account,bookCode,isU){
        var defer = $.Deferred();
        var dirBook = APP_CONFIG.BOOKS_PATH +  account + "/ebook/" + bookCode + "/bookInfo.json";
        shellcmd.readFileAsync(dirBook).done(function (str) {
            if (str) {
                var book = JSON.parse(str);
                shellcmd.desDecrpty(book.datata, account).done(function (ret) {
                    checkUAuthor(account, ret, isU, U).done(function (isValid) {
                        switch (isValid) {
                            case '-2':
                                defer.resolve(-2);
                                break;
                            case '-1':
                                defer.resolve(-1);
                                break;
                            case '0':
                                defer.resolve(0);
                                break;
                            case '1':
                                defer.resolve(1);
                                break;
                            case '2':
                                defer.resolve(2);
                                break;
                            case '3':
                                defer.resolve(3);
                                break;
                            case '4':
                                defer.resolve(4);
                                break;
                            default:
                                defer.resolve(5);
                        }
                    });
                });
            }
        });

        return defer.promise();
    }


    /**
     * 验证U盘授权
     */
    function checkUAuthor(account, password, hardwareInfo, U) {
        var def = $.Deferred();
        checkULicExist(account, U).done(function (isExist) {
            if (isExist) {
                var licensepath = U + ":/iflybook_books/" + account + ".dat";
                var msg = account + '|' + password + '|' + hardwareInfo + '|' + licensepath +'|'+ APP_CONFIG.IFB_PATH;
                console.log(msg);
                shellcmd.checkLocalAuthorization(msg).done(function (ret) {
                    console.log(ret);
                    def.resolve(ret);
                });
            }
            else {
                def.resolve('-1');
            }
        });
        return def.promise();
    }

    function checkULicExist(account, U) {
        var def = $.Deferred();
        var licensepath = U + ":/iflybook_books/" + account + ".dat";
        shellcmd.isFileExist(licensepath).done(function (isLicExist) {
            def.resolve(isLicExist);
        });
        return def.promise();
    }


    function checkUBookOutdate(bookCode,isU,user) {
        var def = $.Deferred();
        var licPath = APP_CONFIG.BOOKS_PATH + user + "/ebook/" + bookCode + '/' + bookCode + '.lic';
        var paramJson = {
            licpath: licPath,
            token:  isU,
            lickey: "TimeLine"
        };
        shellcmd.getBookLicNode(JSON.stringify(paramJson)).done(function (data) {
            if (!data) {
                def.resolve(false);
            } else {
                var now = new Date();
                var nowMon = (now.getMonth() + 1);
                var nowday = now.getDate();
                try {
                    var licData = Date.parse(data);
                    var nowDate = now.getFullYear() + '-' + (nowMon < 10 ? ('0' + nowMon) : nowMon) + '-' + (nowday < 10 ? ('0' + nowday) : nowday); //获取当前日期
                    var _nowDate = Date.parse(nowDate);
                    def.resolve(_nowDate > licData ? true : false);
                } catch (e) {
                    def.resolve(false);
                }
            }
        });
        return def.promise();
    }


    /**
     * 下载本书授权License
     * 获取书本授权信息请求处理
     * statuscode
     * 0=获取授权文件请求处理成功
     * 1=用户不存在
     * 2=用户未激活
     * 3=该硬件用户未绑定
     * 4=资源问题，资源不存在，资源未购买等
     * 5=请求参数非法
     * 6=获取授权文件失败 ,可能商务平台或者授权服务出现故障等
     * @param bookId
     * @param bookCode
     * @param user
     * @param hdInfo
     * @param hdType
     * @returns {{}}
     */
    function callGetBookLicense(bookId, bookCode, user, hdInfo, hdType) {
        var def = $.Deferred();
        var httpurl = APP_CONFIG.ESHOP + "/index.php?c=bookstore&a=getLicenseHandler";
        var savePath = APP_CONFIG.BOOKS_PATH + user + "/ebook/" + bookCode + '/' + bookCode + '.lic';
        shellcmd.getBookLic(httpurl, bookId, user, hdInfo, hdType, savePath)
            .done(function (dataReceived) {
                console.log("get Lic StatusCode:" + dataReceived);
                var statusCode = parseInt(dataReceived);
                def.resolve(handlerBookLicenseResult(statusCode, bookId));
            });
        return def.promise();
    }


    /**
     * 解析书本授权License下载结果
     * @param bookLicObj
     * @returns {boolean}
     * @private
     */
    function handlerBookLicenseResult(statusCode, bookId) {
        switch (statusCode) {
            case 1:
                console.log("用户不存在");
                return false;
                break;
            case 2:
                console.log("用户未激活");
                return false;
                break;
            case 3:
                console.log("该硬件用户未绑定");
                return false;
                break;
            case 4:
                console.log("资源问题，资源不存在等");
                return false;
                break;
            case 5:
                console.log("请求参数非法");
                return false;
                break;
            case 6:
                console.log("获取授权文件失败 ,可能商务平台或者授权服务出现故障等");
                return false;
                break;
            case 0:
                console.log("获取授权文件请求处理成功");
                return true;
                break;
            default :
                console.log("如果授权服务不正常 license = null或者");
                return false;
                break;
        }
    }


    function changeBookIsU(bookCode,isU,userName){
        var def = $.Deferred();
        if(bookCode){
            var sql = "update Books set mtbkId ='" + isU + "' where bookCode = '"+ bookCode + "'";
            console.log(sql);

            var dbPath = APP_CONFIG.IFB_PATH + 'users/' + userName + '/userdb.db';
            shellcmd.executeDbAsyn(dbPath, sql).done(function () {
                def.resolve();
            });
        }
        else{
            def.resolve();
        }
        return def.promise();
    }

    function getBookCard(account){
        if(Global_Version == "Center"){
            var httpurl = APP_CONFIG.ESHOP + "/index.php?c=home&a=doBindUserCard";
            var msgJson = {
                url: httpurl,
                loginName: account
            };
            shellcmd.postHttpRequest(msgJson).done(function (ret) {
                console.log("%c4.0书本授权结果","color:blue");
                console.log(ret);
            });
        }
    }

    return{
        CloudResult:CloudResult,
        UpanResult:UpanResult,
        AppTips:AppTips,
        beforeLogin:beforeLogin,
        getResult:getResult,
        getPointsAndBooks:getPointsAndBooks,
        writeUserLic:writeUserLic,
        StartUpload:StartUpload,
        getClassInfo:getClassInfo,
        checkBindInfo:checkBindInfo,
        checkU:checkU,
        getBookCard:getBookCard,
        createUserFolder:createUserFolder,
        addUserToLocalDb:addUserToLocalDb,
    }

})();
