/**
 * Created by zzsun on 15-1-29.
 */

var SocketServer = {
  "url":  "ws://192.168.62.202:9980",
  "testUrl" : "ws://localhost:9980/test"
};

var TA_APP ={
    //空
    "TA_APP_NONE" : '0x00',
    //TA主程序
    "TA_APP_MAIN" : '0x01',
    //iFlyBook
    "TA_APP_IB"   : '0x02',
    //托盘
    "TA_APP_TRAY" : '0x03',
    //课件制作工具
    "TA_APP_ICW"  : '0x04',
    //所有
    "TA_APP_ALL"  : '0xff'
};

var TAMSG = {
    "TAMSG_CMDKEY"  : "command",
    "TAMSG_DATAKEY" : "data",
    "TAMSG_NOKEY"   : "msgNo",
    "TAMSG_FROMKEY" : "from",
    "TAMSG_TOKEY"   : "to"
}

var CMD = {
    //login
    "TAMSG_LOGIN":  '0x00000001UL',
    //logout
    "TAMSG_LOGOUT": '0x00000002UL',
    //畅言云有消息
    "TAMSG_HASMSG": '0x00000010UL',
    //打开面板
    'TAMSG_OPENPANEL': '0x00000020UL',
    //打开反馈和客服
    "TAMSG_OPENFEEDBACK": '0x00000021UL',
    //打开消息中心
    "TAMSG_OPENMSGCENTER": '0x00000022UL',
    //通知退出
    "TAMSG_NOTIFYEXIT":'0x00000023UL'

};
var RESCMD = {
    //返回消息
    "TAMSG_REPLYOPT":'0x00000100UL',
    //广播消息
    "TAMSG_BROADCASTOPT":'0x00000200UL'
};

function TA_SocketEvent() {
    this.callbacks = {};
};

TA_SocketEvent.prototype.on = function (event, fn) {
    event = this.removePrefix(event);
    (this.callbacks[event] = this.callbacks[event] || [])
        .push(fn);
    return this;
};

TA_SocketEvent.prototype.emit = function (event) {

};

var TA_socketEmit = new TA_SocketEvent();


var WS;
var TA_webSocket  = function(){
    //  this.WS = null;
      this.SocketCreated = false;
      this.isUserloggedout = false;
      this.TA_APP_ID = null;
};

TA_webSocket.prototype.init =  function( ID ) {
    var that = this,
        WebSocketsExist = true;
    try {
          new WebSocket( SocketServer.testUrl );
    } catch (ex) {
        try
        {
            new MozWebSocket( SocketServer.testUrl );
        }
        catch(ex)
        {
            WebSocketsExist = false;
        }
    }
    if (WebSocketsExist) {
        console.log("您的浏览器支持WebSocket. 您可以尝试连接到聊天服务器!", "OK");
        that.run( ID );
    } else {
        console.log("您的浏览器不支持WebSocket。请选择其他的浏览器再尝试连接服务器。", "ERROR");
    }

};

TAWebSocket.prototype.run = function( ID ){
    if( !this.SocketCreated  &&   ! WS   ){
        var that = this;
        try {
            if ("WebSocket" in window) {
                WS = new WebSocket( SocketServer.url );
            }
            else if("MozWebSocket" in window) {
                WS = new MozWebSocket( SocketServer.url );
            }
            this.SocketCreated = true;
            this.isUserloggedout = false;
            this.TA_APP_ID =  ID;
            WS.onopen = that.onOpen;
            WS.onmessage = that.onReceive;
            WS.onclose = that.onClose;
            WS.onerror = that.onError;

        } catch (ex) {
            console.error(ex);
            return;
        }
    }

};

TA_webSocket.prototype.onOpen = function(  ){
    WS.send( 'login:' + this.ID);
};

TA_webSocket.prototype.send = function( sendJson ){
    sendJson && WS.send(sendJson);
};


TA_webSocket.prototype.onReceive = function (event){
        console.log("this is a none");
};

TA_webSocket.prototype.onClose = function( evt ){
    this.SocketCreated = false;
    this.isUserloggedout = true;
    console.log("远程连接中断");
};

TA_webSocket.prototype.onError = function(evt){
    console.log("远程连接中断"+ evt.data)
};

TA_webSocket.prototype.close = function( evt ){
   WS.close();
};



