/**
 * Created by linwang5 on 2014/11/27.
 */

NC.namespace('NoticeManager');
NoticeManager={
    lastPublicMsg:{},
    noticeStart:function(){
        var defer = $.Deferred();

        //绑定关闭或确定按钮
        $(document).on("click", ".noticeClose", function () {
             NoticeManager.noticeCloseAnimate();
        });
        try{
            if(APP_CONFIG.USE_NOTICE_CENTER){
                NoticeManager.getLocalInfo(function(err,_notice){
                    if(err){
                        _notice =[{}];
                    } 
                    NoticeManager.lastPublicMsg = _notice[0];
                    var interval = 1;
                    if(_notice[0].showTime)
                        interval = Date.now()/1000/3600/24 - _notice[0].showTime/1000/3600/24;
                    console.log("历史公告:"+JSON.stringify(_notice) + "间隔:"+interval);
                
                    $.ajax({//从服务拉取公告信息
                         url: APP_CONFIG.NOTICE_CENTER,
                         type: "POST",
                         timeout: 10000, //设置超时
                         dataType: "json",
                         success: function ($notice) {
                            //if(!$notice.isShow) return;
                            console.log("最新公告:"+JSON.stringify($notice));
                            //TODO:请求成功处理 显示并保存本地
                            if($notice.length > 0 && _notice[0].id != $notice[0].id){
                                console.log("显示最新公告");
                                NoticeManager.showNoticeWithTimeValidation($notice).done(function (ret){
                                    if(ret) {
                                        defer.resolve(true);
                                    } else {
                                        showHistoryNotice();
                                    }
                                });
                                NoticeManager.saveLocalInfo($notice);
                                _notice = $notice;
                                NoticeManager.lastPublicMsg = _notice[0];
                            } else {
                                showHistoryNotice();
                            }
                         },
                         error: function (er) {
                            showHistoryNotice();
                            // console.log("请求错误:"+er);
                            // NoticeManager.getLocalInfo(function(err,$notice){
                            //      if(err){
                            //          console.log("Get local information of notice error!!");
                            //          return ;
                            //      }
                            //      NoticeManager.showNoticeWithTimeValidation($notice);
                            //      // if(!version||!time){
                            //      //      updateUrl=APP_CONFIG.NOTICE_UPDATE;
                            //      // }else{
                            //      //     updateUrl=APP_CONFIG.NOTICE_UPDATE+"&version="+version+"&time="+time;
                            //      // }
                            //  });
                        }
                    });
                    
                    function showHistoryNotice() {
                        if(interval >= 1){
                            console.log("显示历史公告");
                            NoticeManager.showNoticeWithTimeValidation(_notice).done(function (ret){
                                if(ret) {
                                    defer.resolve(true);
                                } else {
                                    defer.resolve(false);
                                }
                            });
                            NoticeManager.saveLocalInfo(_notice);
                        } else {
                            defer.resolve(false);
                        }
                    }
                });
            }
            else{
                NoticeManager.getLocalInfo(function(err,_notice){
                    console.log("get localnotic:"+JSON.stringify(_notice));
                     if(err){
                         console.log("Get local information of notice error!!");
                         defer.resolve(false);
                         return ;
                     }
                     var updateUrl;
                     if(!_notice||!_notice.version||!_notice.time){
                          updateUrl=APP_CONFIG.NOTICE_UPDATE;
                     }else{
                         updateUrl=APP_CONFIG.NOTICE_UPDATE+"&version="+_notice.version+"&time="+_notice.time;
                     }
                     $.ajax({//从服务拉取公告信息
                         url: updateUrl,
                         type: "get",
                         timeout: 10000, //设置超时
                         dataType: "json",
                         success: function ($notice) {
                            console.log($notice);
                            if(!$notice.isShow) {
                                defer.resolve(false);
                                return;
                            }
                            //TODO:请求成功处理 显示并保存本地
                             NoticeManager.showNotice($notice.app_notice_info);
                             defer.resolve(true);
                             $("#updateNotice h2").html($notice.app_notice_title);
                             NoticeManager.saveLocalInfo($notice);
                         },
                         error: function (er) {
                             console.log("请求错误:"+er);
                             defer.resolve(false);
                         }
                     });

                 });
            }
        }
        catch(e){
            defer.resolve(false);
        }
        return defer.promise();
    },
    getLocalInfo:function(callback){
        try {
            var updateLog = JSON.parse(shellcmd.readFile(DAT_CONFIG.UPDATE_AD));
            if(updateLog){
                //callback&&callback(null,updateLog.version,updateLog.time)
                callback&&callback(null,updateLog)
            }else{
                callback&&callback("fail",null,null);
            }
        } catch (e) {
            console.log(e.message);
            callback&&callback("fail",null,null);
        }
    },
    saveLocalInfo:function(updateLog){
         // var updateLog={
         //     "version":vsersion,
         //     "time":time
         // }
        shellcmd.writeFile(DAT_CONFIG.UPDATE_AD, JSON.stringify(updateLog));
    },
    showNotice:function(noticeInfo){
         console.log(noticeInfo);
        $("#mask_layer").show();
        $("#updateNotice").attr("style","");
        $("#updateNotice").show();
        $("#updateNotice p").html(noticeInfo);

        //绑定关闭或确定按钮(处理 checkNewMessageAvailable方法执行后页面出现弹窗但关闭按钮没有绑定事件)
        $(document).on("click", ".noticeClose", function () {
            NoticeManager.noticeCloseAnimate();
        });
    },
    showNoticeWithTimeValidation:function($notice){
        var defer = $.Deferred();
        var curTime = Date.now();
        var notice = $notice[0];
        var beginTime = new Date(notice.beginTime).getTime();
        var endTime = new Date(notice.endTime).getTime();
        // curTime = beginTime;
        console.log("当前时间:" + curTime+":"+(curTime >= beginTime && curTime < endTime));
        if(curTime >= beginTime && curTime < endTime){
            notice.content = NoticeManager.strTracer(notice.content);
            notice.showTime = curTime;
            NoticeManager.showNotice(notice.content);
            // $("#updateNotice h2").html($notice.content);
            defer.resolve(true);
        } else {
            defer.resolve(false);
        }
        return defer.promise();
    },
    noticeCloseAnimate:function(){
        $("#mask_layer").hide();
        $("#updateNotice").animate({'top':'5px','left':'82%','opacity':'0','height':'0px','width':'0px'},2000,function(){
            $("#updateNotice").hide();
        });
    },
    checkNewMessageAvailable:function(userInfo){
        $(".userInfoCenter").find('b').hide();
        if(userInfo){
            var user = userInfo.userInfo;
            var msgFiltrationCond = {
                classInfo:user.classInfo,
                grade:user.grade,
                subject:user.subject,
                position:user.userExt
            };
            
            $.ajax({//从服务拉取公告信息
                url: APP_CONFIG.NOTICE_CENTER,
                type: "post",
                timeout:3000,
                data: {
                    info:JSON.stringify(msgFiltrationCond),
                    from:0,
                    count:1
                },
                dataType:"json",
                success: function ($data) {
                    function timeSpan(data) {
                        var notice = data[0],
                            curTime = Date.now();
                        var createTime = new Date(notice.createTime).getTime();
                        var days = (curTime - createTime) / 1000 / 60 /60 /24;
                        return days;
                    }
                    var days = timeSpan($data);
                    if(days < 7 ){
                        $(".userInfoCenter").find('b').show();
                        $("#controlBar").find('i').addClass('control_ico');
                        $("#controlIco").find('i').addClass('control_ico');
                    } else {
                        //如果最新公告超过7天，再判断消息
                        $.ajax({
                            url: APP_CONFIG.NOTICE_HISTORY,
                            type: "post",
                            data: {
                                info:JSON.stringify(msgFiltrationCond),
                                from:0,
                                count:1
                            },
                            dataType:"json",
                            success: function (data) {
                                var days = timeSpan(data);
                                if(days < 7) {
                                    $("#controlBar").find('i').addClass('control_ico');
                                    $("#controlIco").find('i').addClass('control_ico');
                                }
                            }
                        })
                    }
                    console.log("用户公告:"+JSON.stringify($data[0]));
                    if(NoticeManager.lastPublicMsg.id != $data[0].id){
                        NoticeManager.showNoticeWithTimeValidation($data);
                        NoticeManager.saveLocalInfo($data);
                        _notice = $data;
                        NoticeManager.lastPublicMsg = _notice;
                    }
                },
                error: function (er) {
                }
            });
        }
    },
    getMessageTotalFromCY:function(statusCode){
        $(".userInfoCenter").find('b').hide();
        if(!statusCode) return;
        TA.UserService.getUserInfo(function (userInfo) {
            if(userInfo){
                $.ajax({
                    url:APP_CONFIG.MESSAGE_STATISTICS+userInfo.id,
                    type: "get",
                    timeout: 10000, //设置超时
                    dataType: "json",
                    success:function(result){
                        if(result.statusCode==1){
                          result = result.data;
                            var count=parseInt(result.unread_comment)+parseInt(result.unread_notify)+parseInt(result.unread_message)+parseInt(result.unread_favour);
                            if(count>0){
//                                 $(".userInfoCenter").find('b').html(count).show();
                                $(".userInfoCenter").find('b').show();
                            }
                        }
                    },
                    error:function(err){
                        console.log("get message from CYY error: "+err);
                    }
                });
            }

        });
    },
    openExternal : function(url){
        console.log(url);
        var gui = require('nw.gui');
        var shell = gui.Shell;
            shell.openExternal(url);
    },
    strTracer:function(str){
        var content = str.replace(/<#(.*?)#>/g,"<a href='javascript:NoticeManager.openExternal(\"$1\")'>$1</a>");
            content = content.replace(/[\n\r]/g,"<br/>");
        return content;
    }
};