/**
 * Created by simon on 14-6-27.
 */
var http = require('http');
var fs = require('fs');
var spawn = require('child_process').spawn;
var path = require("path");
var nw = APP_CONFIG.BASE_PATH + "/nw.exe";
var plugins = APP_CONFIG.BASE_PATH + "/plugins/";
var request = require('../node_modules/request');

function loader(config) {
    //瞧好了, config一共有这么些参数
    var url = config.url;
    var target = config.target;
    var begin = config.begin;
    var progress = config.progress;
    var end = config.end;
    var error = config.error;
    var dirPath = config.dirPath;
    var re_direct = null;
    fnmkdir({
        success: function () {
            re_direct = arguments.callee;
            var httpReq = http.get(url,function (res) {
                //var httpReq = request(url, function (error, res, body) {
                //   //在这里只能寄托ondata调用全部结束后才调用onend调用
                // }).on("response",function(res){
                var headers = res.headers;
                /**
                 * 处理下载重定向问题
                 */
                if (res.statusCode >= 300 && res.statusCode < 400) {
                    url = headers.location;
                    re_direct && re_direct();
                    return;
                }
                var contentLength = headers["content-length"];
                var progressedLength = 0;
                var out = fs.createWriteStream(target);
                var endtype = "complete";
                if (!fs.existsSync(dirPath)) fs.mkdirSync(dirPath);
                begin && begin({
                    req: httpReq,
                    pause: function (type) {
                        endtype = type;
                    }
                });
                var timeinterval = setTimeout(
                    function () {
                        if (progress) {
                            if (!progress(progressedLength / contentLength)) {
                                httpReq.abort();
                                endtype = "interrupt";
                                return;
                            }
                        }
                        //progress && progress(progressedLength / contentLength);
                        if (progressedLength / contentLength < 1) {
                            timeinterval = setTimeout(arguments.callee, 500);
                        } else {
                            end && end();
                        }
                    }, 500);
                res.on("data", function (chunk) {
                    out.write(chunk, function () {
                        progressedLength += chunk.length;
                    });
                });
                res.on("end", function () {
                    if (endtype == "interrupt") {
                        clearTimeout(timeinterval);
                        return;
                    }
                    out.end(function () {
                        //end && end();
                    });
                });

            }).on("error", function (e) {
                //这时临时文件还没有创建
                error && error(e.message);
            });
        }
    });
}
/**
 * 同步本地应用列表数据
 * @param callback
 * @param callback.info APP数据
 */
function syncLocalAppList(callback) {
    var ignoreIflybook = callback.ignoreIflybook || false;
    var remoteInfo = callback.info;
    var success = callback.success;
    var type = callback.type;

    var loginName = userInfo.loginName;
    var path = APP_CONFIG.BASE_PATH + "/user/" + loginName + "/appmanage.dat";
    var localInfoJson;
    //写文件
    if (type == "write") {
        var localAppInfoMap = {};
        fs.exists(path, function (exist) {
            // exist为true表示文件存在
            if (exist) {
                var localInfo = shellcmd.readFile(path);
                try {
                    localAppInfoMap = JSON.parse(localInfo);
                } catch (e) {
                    console.error(e.message);
                }
            }
            localAppInfoMap[remoteInfo.id] = remoteInfo;
            shellcmd.writeFile(path, JSON.stringify(localAppInfoMap));
            success && success("");
        });
        //读文件
    } else {
        fs.exists(path, function (exist) {
            // exist为true表示文件存在
            if (exist) {
                var localInfo = shellcmd.readFile(path);
                //过滤iflybook
                try {
                    if (ignoreIflybook) {
                        localInfoJson = JSON.parse(localInfo);
                        if (localInfoJson['62']) {
                            delete localInfoJson['62'];
                        }
                        success && success(JSON.stringify(localInfoJson));
                    } else {
                        success && success(localInfo);
                    }
                } catch (ex) {
                    success && success("");
                }

            } else {
                var appInfo = {};
                var appManager = APPManager.getInstance();
                appManager.getAPPList({
                    success:function(remoteList){
                        for (var i in remoteList){
                            var app = remoteList[i];
                            appInfo[app.id] = app;
                        }
                        console.log(appInfo);

                        var localAppInfoMap = {};
                        for(var id in APP_CONFIG.DEFAULT_APP) {
                            var info = APP_CONFIG.DEFAULT_APP[id];
                            localAppInfoMap[info] = appInfo[info];
                            //将预置APP的版本信息同步到appVersion.dat
                            syncAppVersion({
                                appInfo: appInfo[info],
                                type: 'write',
                                success: function() {
                                    console.log("成功同步预置版本文件");
                                }
                            });
                        }

                        //TA升级4.0版本，客户端同步以前安装的APP
                        var oldAppdatPath = APP_CONFIG.BASE_PATH + "/appmanage.dat";
                        fs.exists(oldAppdatPath, function (ext) {
                            if(ext) {
                                var oldAppdat = JSON.parse(shellcmd.readFile(oldAppdatPath));
                                for(var dat in oldAppdat) {
                                    if(typeof localAppInfoMap[dat] == "undefined") {
                                        localAppInfoMap[dat] = appInfo[dat];  //oldAppdat[dat];
                                    }
                                }
                            }

                            shellcmd.writeFile(path, JSON.stringify(localAppInfoMap));
                            console.log("该文件不存在");
                            success && success("");
                        });
                    }
                });
            }
        });
    }
}

/**
 * 同步本地App物理文件的版本号
 * 用于判断更新是否真正执行
 */
function syncAppVersion(callback) {
    var path = APP_CONFIG.BASE_PATH + "/user/" + "/appVersion.dat";
    var type = callback.type,
        appInfo = callback.appInfo,
        versionInfo = "",
        versionInfoMap = {},
        success = callback.success;

    fs.exists(path, function(exist) {
        if(exist) {
            versionInfo = shellcmd.readFile(path);
            versionInfoMap = JSON.parse(versionInfo);
        }

        if(type == "write") {
            var appVersion = {};
            appVersion.id = appInfo.id;
            appVersion.version = appInfo.version;
            versionInfoMap[appVersion.id] = appVersion;

            shellcmd.writeFile(path, JSON.stringify(versionInfoMap));
            success && success(versionInfoMap);
        } else {
            success && success(versionInfoMap);
        }
    });
}
function splicUrl(url){
    // var a = url.substring(22);
     //url = "http://zqwei.test.changyan.cn/" + a;
    // url = APP_CONFIG.BASE_CYSERVICE + a;
    return url;
}
/**
 * 读写recentUse.dat文件
 */
function syncRecentUse(callback) {
    var loginName = userInfo.loginName,
        path = APP_CONFIG.BASE_PATH + "/user/" + loginName + "/recentUse.dat";
    var type = callback.type,
        appRecentUse = callback.appRecentUse,
        success = callback.success,
        recentdat = "",
        recentUse = [];

    fs.exists(path, function(exist) {
        if(!exist) {
            recentUse = APP_CONFIG.DEFAULT_RECENT_APP;   //记录到最近使用app信息中，作为推送app
            shellcmd.writeFile(path, JSON.stringify(recentUse));
        }

        if(type == "write") {
            shellcmd.writeFile(path, JSON.stringify(appRecentUse));
            success && success();
        } else {
            recentdat = shellcmd.readFile(path);
            recentUse = JSON.parse(recentdat);
            success && success(recentUse);
        }
    });
}

//判断plugins文件夹是否存在
function fnmkdir(config) {
    var success = config.success;
    fs.exists(plugins, function (exist) {
        // 不存在
        if (!exist) {
            fs.mkdir(plugins, function () {
                success && success();
            });
        } else {
            success && success();
        }
    });
}
/**
 * 应用管理器
 * @constructor
 */

function APPManager() {
    var that = this;
}
taEmitter.on(TA_EVENT.NETWORK_STATUS_CHANGED, function (status) {
    if (status != APPManager.onlineFlag) {
        APPManager.onlineFlag = status;
        APPManager.inited = APPManager.onlineFlag == true ? new OLAPPManager() : new OffLineAPPManager();
        if(!status){
            // shellcmd.trayTips("网络不给力，请检查网络连接");
        }else {
            try{
                TA_KTSL && TA_KTSL.invokeHistory(30);
            }catch(e){
                console.log('找不到TA_KTSL');
            }
        }
    }
});
APPManager.onlineFlag = true;
APPManager.getInstance = function () {
    if (APPManager.inited) {
        return APPManager.inited;
    }
    return APPManager.inited = APPManager.onlineFlag == true ? new OLAPPManager() : new OffLineAPPManager(),
        APPManager.inited;
};
APPManager.prototype = {
    progress: {length: 0},
    process: [],
    /**
     * 拉取所有应用列表
     */
    getAPPList: function (config) {
        if (!config)return false;
        var that = this;
        console.log(this);
        var success = config.success;
        var fail = config.fail;
        this.getLastAppInfoList(function (apclist) {
            var list = [];
            for (var j = 0, n = apclist.length; j < n; j++) {
                var applist = apclist[j].data;
                for (var i = 0; i < applist.length; i++) {
                    var icon = splicUrl(applist[i].apv_low_picture_url);
                    var url = splicUrl(applist[i].apv_zip_url);
                    var item = {};
                    if (that.online == 1) {
                        item = {
                            "id": applist[i].apm_id || "",
                            "version": applist[i].apm_latest_version || "",
                            "name": applist[i].apm_chinese_name || "",
                            "icon": icon || '',
                            "url": url || '',
                            "desc": applist[i].apv_description || '',
                            "upgrade_info": applist[i].apm_update_info || '',
                            "upgrading_model": applist[i].apm_update_model || 0,
                            "rank": applist[i].apm_star_level || '4',
                            "size": applist[i].apm_zip_size || 0,
                            "apc_type": apclist[j].apc_name,
                            "is_nw": applist[i].is_nw || '1',
                            "open_path": applist[i].open_path || '',
                            "title": applist[i].title || ""
                        };
                    } else {
                        item = {
                            "id": applist[i].apm_id || "",
                            "version": applist[i].apm_latest_version || "",
                            "name": applist[i].apm_chinese_name || "",
                            "icon": plugins + applist[i].apm_id + "/picture/48.png" || "",
                            "url": url || "",
                            "desc": applist[i].apv_description || '',
                            "upgrade_info": applist[i].apm_update_info || '',
                            "upgrading_model": applist[i].apm_update_model || 0,
                            "rank": applist[i].apm_star_level || '4',
                            "size": applist[i].apm_zip_size || 0,
                            "apc_type": apclist[j].apc_name,
                            "is_nw": applist[i].is_nw || '1',
                            "open_path": applist[i].open_path || '',
                            "title": applist[i].title || ""
                        };
                    }
                    list.push(item);
                }
            }
            //console.log(list);
            if (list.length) {
                success && success(list, that.online);
            } else {
                // 在线获取列表失败，尝试读取本地列表
                var offLineMamager = new OffLineAPPManager();
                offLineMamager.getLastAppInfoList(function (apclist) {
                    var list = [];
                    for (var j = 0, n = apclist.length; j < n; j++) {
                        var applist = apclist[j].data;
                        for (var i = 0; i < applist.length; i++) {
                            var icon = splicUrl(applist[i].apv_low_picture_url);
                            var url = splicUrl(applist[i].apv_zip_url);
                            var item = {};
                                item = {
                                    "id": applist[i].apm_id || "",
                                    "version": applist[i].apm_latest_version || "",
                                    "name": applist[i].apm_chinese_name || "",
                                    "icon": plugins + applist[i].apm_id + "/picture/48.png" || "",
                                    "url": url || "",
                                    "desc": applist[i].apv_description || '',
                                    "upgrade_info": applist[i].apm_update_info || '',
                                    "upgrading_model": applist[i].apm_update_model || 0,
                                    "rank": applist[i].apm_star_level || '4',
                                    "size": applist[i].apm_zip_size || 0,
                                    "apc_type": apclist[j].apc_name,
                                    "is_nw": applist[i].is_nw || '1',
                                    "open_path": applist[i].open_path || '',
                                    "title": applist[i].title || ""
                            };
                            list.push(item);
                        }
                    }
                    if(list.length > 0){
                        success && success(list, !1);
                    }else{
                        config.error && config.error();
                    }
                });
            }
        });
    },
    /**
     * 获取应用详情
     */
    getAPPInfo: function (callback) {
        var appid = callback.id;
        var success = callback.success;
        var that = this;
        this.getAppDetailInfo({
            id: appid,
            success: function (app) {
                var screenImage =[] ;
                $.each(app.apm_screen_url,function(index,el){
                    screenImage.push(splicUrl(el));
                });
                var icon = splicUrl(app.apv_high_picture_url);
                var url = splicUrl(app.apv_zip_url);
                var item = {
                    "id": app.apm_id || "",
                    "version": app.apm_latest_version || "",
                    "name": app.apm_chinese_name || "",
                    "icon": icon || '',
                    "url": url || '',
                    "desc": app.apv_description || '',
                    "size": app.apm_zip_size || 0,
                    "upgrade_info": app.apm_update_info || '',
                    "upgrading_model": app.apm_update_model || 0,
                    "rank": app.apm_star_level || '4',
                    "screen_url": screenImage || "",
                    "lowIcon": splicUrl(app.apv_low_picture_url) || '',
                    "is_nw": app.is_nw || '1',
                    "open_path": app.open_path || '',
                    "title": app.title || ''
                };
                if (that.online != 1) {
                    screenImage = [plugins + appid + "/picture/1.jpg", plugins + appid + "/picture/2.jpg", plugins + appid + "/picture/3.jpg"];
                    item.icon = plugins + appid + "/picture/96.png" || '';
                    item.lowIcon = plugins + appid + "/picture/48.png" || '';
                    item.screen_url = screenImage;
                }
                success && success(item);
            }
        });
    },
    getSortApp: function (callback) {
        var that = this;
        var success = callback.success;
        var fail = callback.fail;
        this.getSortAppList(function (applist) {
            console.log(applist)
            var list = [];
            for (var i = 0; i < applist.length; i++) {
                var item = {};
                if (that.online == 1) {
                    item = {
                        "id": applist[i].apm_id || "",
                        "version": applist[i].apm_latest_version || "",
                        "name": applist[i].apm_chinese_name || "",
                        "icon": splicUrl(applist[i].apv_low_picture_url) || '',
                        "url": splicUrl(applist[i].apv_zip_url) || '',
                        "desc": applist[i].apv_description || '',
                        "size": applist[i].apm_zip_size || 0,
                        "upgrade_info": applist[i].apm_update_info || '',
                        "upgrading_model": applist[i].apm_update_model || 0,
                        "rank": applist[i].apm_star_level || '4'
                    };
                }
                list.push(item);
            }
            if (list) {
                success && success(list);
            } else {
                callback.error && callback.error();

            }
        });
    },
    updateApp: function () {
    },
    removeApp: function (config) {
        var that = this;
        var filePath = APP_CONFIG.BASE_PATH + "/DAT/running.dat";
        var runningApp = [];
        try {
            runningApp = JSON.parse(shellcmd.readFile(filePath));
        }
        catch (e) {
        }
        //如果当前软件正在运行
        if (config.id == '64') {
            shellcmd.findProcess('RecordLesson.exe').done(function (isExsit) {
                if (isExsit && isExsit != '0') {
                    $("#mask_layer").show();
                    dAppIsRunningConfirm.show();
                }
                else {
                    deleteApp();
                }
            });
        } else {
            if (runningApp.indexOf(config.id) != -1) {
                $("#mask_layer").show();
                dAppIsRunningConfirm.show();
            } else {
                deleteApp();
            }
        }

        //关闭当前软件再删除
        $("#closeRunningApp").one('click', function (evt) {
            $("#mask_layer").hide();
            dAppIsRunningConfirm.close();
            config.oneBreak && config.oneBreak();
            //  TA.Stage.stages[ 'app_' + config.id ] && TA.Stage.stages[ 'app_' + config.id ].kill();
            //  deleteApp();
            evt.stopPropagation();
        });
        //这里才是开始真正的删除
        function deleteApp() {
            var interVal = setInterval(function () {
                var id = config.id || config.appInfo.id;
                var success = config.success;
                var error = config.error;

                //同步删除本地的配置文件在这里
                var loginName = userInfo.loginName;
                var infoPath = APP_CONFIG.BASE_PATH + "/user/" + loginName + "/appmanage.dat";

                try {
                    var localInfo = shellcmd.readFile(infoPath);
                    if (localInfo) {
                        var localAppInfoMap = JSON.parse(localInfo);
                        delete localAppInfoMap[id];
                        shellcmd.writeFile(infoPath, JSON.stringify(localAppInfoMap));
                    }
                    //  success && success();
                } catch (e) {
                    console.error(e.message);
                    error && error(e);
                }
                //修改预装的软件配置
                // var preInstallArr = [];
                // var filePath = APP_CONFIG.BASE_PATH + "/preInstall.dat";
                // try {
                //     preInstallArr = JSON.parse(shellcmd.readFile(filePath));
                //     if (preInstallArr.indexOf(Number(id)) >= 0) {
                //         var index = preInstallArr.indexOf(Number(id));
                //         preInstallArr.splice(index, 1);
                //     }
                //     shellcmd.writeFile(filePath, JSON.stringify(preInstallArr));
                // }
                // catch (e) {
                //     console.error(e.message);
                //     error && error(e);
                // }
                //删除文件在这里
                if(config.isUpdataApp){
                    var path = plugins + id;
                    fs.exists(path, function (exist) {
                        if (exist) {
                            try {
                                that._rmdirSync(path, success);
                                clearInterval(interVal);
                            } catch (err) {
                                error && error(err);
                                clearInterval(interVal);
                            }
                        } else {
                            console.log("Warning: file " + path + " is lost");
                            success && success();
                            //clearInterval( interVal );
                        }
                    });
                } else {
                    //这里不是更新时删除app，所以删除该app在recentuse.dat中的记录
                    syncRecentUse({
                        type: 'read',
                        success: function(recentInfo) {
                            if (recentInfo.indexOf(id) !== -1) {
                                recentInfo.splice(recentInfo.indexOf(id), 1);
                                syncRecentUse({
                                    type: 'write',
                                    appRecentUse: recentInfo,
                                    success: function() {

                                    }
                                });

                                //在不同进程中打开app，利用nw进程; 否则直接刷新appRegion
                                if(typeof(appRegion) == "undefined") {
                                    taEmitter.emit(TA_EVENT.RECENTUSE_CHANGE + ".main.true");
                                } else {
                                    setTimeout(function() {
                                        appRegion.setRecentApp(userInfo);
                                    }, 1000);
                                }
                            }
                        }
                    });

                    clearInterval(interVal);
                    success && success();
                }

            }, 1000);
        }
    },
    _rmdirSync: function (path, success, mainFlag) {
        var tempLength;
        var thisFunction = arguments.callee;
        if (fs.existsSync(path)) {
            files = fs.readdirSync(path);
            tempLength = files.length;
            if (tempLength == 0) {
                success && success();
                return;
            }
            files.forEach(function (file) {
                if (file == 'picture' && !mainFlag) {
                    console.log('no delete');
                    if ((mainFlag && tempLength == 0) || (!mainFlag && tempLength == 1)) success && success(true);
                }
                else {
                    var curPath = path + "/" + file;
                    fs.stat(curPath, function (err, stats) {
                        if (!err && stats.isDirectory()) {// recurse
                            thisFunction(curPath, function () {
                                console.log(files.length);

                                fs.rmdirSync(curPath);
                                tempLength--;
                                if ((mainFlag && tempLength == 0) || (!mainFlag && tempLength == 1)) success && success();

                            }, true);
                        } else {// delete file
                            fs.unlink(curPath, function () {
                                //console.log("1111")
                                tempLength--;
                                if ((mainFlag && tempLength == 0) || (!mainFlag && tempLength == 1)) success && success();
                            });
                        }
                    });
                }
            });
//            success && success();
            //   fs.rmdirSync(path);

        } else {
            success && success();
        }
    },
    appSetAlwaysTop: function (tepExe, tempPid, tempTitle) {
        var title = (tempTitle && tempTitle != '') ? tempTitle : null;
        if (!title) return;
        var pid = tempPid || 0;
        var exe = tepExe || '';
        exe = exe.split('/')[exe.split('/').length - 1];
        exe = (exe == '') ? null : exe.replace('.exe', '');
        var reiv = APP_CONFIG.BASE_PATH + '/reiv.exe ';
        var cmdLine = 'topmost|' + exe + '|' + pid + '|' + title;
        console.log(reiv + cmdLine);
        spawn(reiv, [cmdLine], {detached: true}).on('exit',function () {
            console.log(reiv + ' exit');
        }).on('error', function (err) {
            console.log(reiv + ' ' + err);
        });
    },
    /**
     * 原有的启动方式，是为了兼容用户已经下载到本地的APP没有启动信息，包括NW建构的启动，原有做的特殊处理任然存在
     * @param config
     */
    runAppOld: function (config, title) {
        var that = this;
        this.process.push(config.id);
        var id = config.id || config.appInfo.id;
        //todo:这里应该是finished吧
        var error = config.error;
        var realPlugins = plugins + id;

        var ifbExiting = process.execPath.substring(0,process.execPath.lastIndexOf('\\')).replace(/\\/g,"/")+'/ifbExiting.flag';
        var ifbExitingFlag = fs.existsSync(ifbExiting);

        if(TA.Stage.stages['app_' + id] && ifbExitingFlag){
            //iflybook进程尚未退出完全，给予用户提示
            // var $ifbRunDialog = $("#iflybook_exist");
            // $ifbRunDialog.find("p[name='content']").html("").html("电子课本应用退出中，请稍候");
            // //绑定事件
            // $($ifbRunDialog).on("click","a[name='close']",function () {
            //     $($ifbRunDialog).hide();
            // });
            // $($ifbRunDialog).on("click","a[name='complete']",function () {
            //     $($ifbRunDialog).hide();
            // });
            // $($ifbRunDialog).on("click","a[name='cancel']",function () {
            //     $($ifbRunDialog).hide();
            // });
            // $ifbRunDialog.show();
            console.warn('iflybook进程尚未退出完全,请等待...');
            return 0;
        }

        // 删除 iflybok进程退出中标记文件
        if(id == 62){
            //replace (file:/c:/test.txt 前的 file:/ 删除掉)
            var ta_folder_path = (APP_CONFIG.BASE_PATH + '/' +'ifbExiting.flag').replace(/\bfile:(\/+)/g, "");

            fs.exists(ta_folder_path, function (exists) {
                if(true == exists){
                    fs.unlink(ta_folder_path, function (ret) {
                        //使用另外一种方法删除
                        if(-1 == ret){
                            shellcmd.deleteFile(ta_folder_path);
                        }
                    });
                }
            });
        }

        if (TA.Stage.stages['app_' + id]) {
            if ((id != 64 && id != 63) || (id == 63 && !fs.existsSync(plugins + '63/iFlySlide.exe'))) {
                if(id == 62){
                    if(config.bookCode){
                        realPlugins = plugins + id + "/package/index";
                    }else{
                        realPlugins = plugins + id + "/package/bookshelf";
                    }
                }
                spawn(nw, [realPlugins], {detached: true});
                that.appSetAlwaysTop(null, TA.Stage.stages['app_' + id].pid, title);
            } else if (id == 64) {
                var RecordLesson = plugins + "64/RecordLesson.exe";
                spawn(RecordLesson, [], {detached: true});
                that.appSetAlwaysTop("RecordLesson.exe", TA.Stage.stages['app_' + id].pid, title);
            } else if (id == 63) {
                var iFlySlide = plugins + "63/iFlySlide.exe";
                spawn(iFlySlide, [], {detached: true});
                //课件制作工具会再次打开一个的，不用吊起
//                that.appSetAlwaysTop("iFlySlide.exe",TA.Stage.stages['app_' + id].pid,title);
            }
            return;
        }
        // LogManager.statisticsMoudleTime(id.toString(), "openApp");

        setTimeout(function () {
            // LogManager.statisticsMoudleTime(id.toString(), "entry");
            if(id != 62 && id != 63) {
                LogManager.statistics("enter", {ta_app :"ta_app", module: "03"+id, user_id :userInfo.id},null);
            }
        }, 1000);
        if ((id != 64 && id != 63) || (id == 63 && !fs.existsSync(plugins + '63/iFlySlide.exe'))) {

            var filePath = APP_CONFIG.BASE_PATH + "/DAT/running.dat";
            var runningApp = [];
            try {
                runningApp = JSON.parse(shellcmd.readFile(filePath));
            }
            catch (e) {
            }
            if (runningApp.indexOf(id) == -1) {
                runningApp.push(id);
            }
            shellcmd.writeFile(filePath, JSON.stringify(runningApp));


            var argv = "";
            if(id == 62 && config.bookCode){
                //cyservice信息
                var user = encodeURIComponent(userInfo.loginName || "");
                var userName = encodeURIComponent(userInfo.userName || "");
                var p="";
                if(userInfo.userExt){
                    p = encodeURIComponent(userInfo.userExt.provinceName || "");
                }
                var uid = userInfo.id || "";
                var phone = userInfo.mobile || "";
                var role  = userInfo.enName || "";
                var userAppName  = userInfo._user_userAppName || "";

                //eshop信息
                var books = userInfo.books || 0;
                var points = userInfo.points || 0;
                var isactive = userInfo.isActive || "";
                var SSOTicket = userInfo.setSSOTicket || "";
                var classInfo = userInfo.classInfo;
                var classId = "";
                if(classInfo && classInfo.length > 0){
                    classId = classInfo[0].classId;
                }

                var pageIndex = config.pageIndex || 1;
                var isOpenTeachingPackage = config.isOpenTeachingPackage || false;
                var firstload = true;
                var unit=config.unit||"";
                var bookStatus=config.bookStatus;

                //iflybook信息
                argv = "index.html?bookCode=" + config.bookCode + "&user=" + user + "&ticket=" +
                    "&userName=" + userName + "&p=" + p + "&userloginname=&isonline=" + APPManager.onlineFlag +
                    "&isactive=" + isactive + "&pageIndex=" + pageIndex +"&unit="+ unit +"&bookStatus="+bookStatus+"&uid=" + uid +"&phone=" + phone +
                    "&points=" + points + "&books=" + books + "&isU=" + config.isU + "&SSOTicket=" + SSOTicket +
                    "&LoginFrom=&classId=" + classId + "&role=" + role + "&userAppName=" + userAppName + "&firstload=" + firstload + "&isOpenTeachingPackage=" + isOpenTeachingPackage;
            }

            if(id == 62){
                if(config.bookCode){
                    realPlugins = plugins + id + "/package/index";
                }else{
                    realPlugins = plugins + id + "/package/bookshelf";
                    var openlib = config.openlib || false;
                    if(openlib){
                        argv = "--openlib=true";
                    }

                }
            }

            TA.Stage.stages['app_' + id]  = spawn(nw, [realPlugins,argv], {detached: true}).on("error",function (err) {
                shellcmd.log('start app error' + err);
                error && error(err);
            }).on("exit", function () {
                //关闭时置空信息
                TA.Stage.stages['app_' + id] = null;
                //用户离开APP
                // LogManager.statisticsMoudleTime(id.toString(), "quit");
                if(id != 62 && id != 63) {
                    LogManager.statistics("quit", {ta_app :"ta_app", module: "03"+id, user_id :userInfo.id},null);
                }
                var filePath = APP_CONFIG.BASE_PATH + "/DAT/running.dat";
                var runningApp = [];
                try {
                    runningApp = JSON.parse(shellcmd.readFile(filePath));
                }
                catch (e) {
                }
                if (runningApp.indexOf(id) !== -1) {
                    runningApp.splice(runningApp.indexOf(id), 1);
                }
                shellcmd.writeFile(filePath, JSON.stringify(runningApp));
            });

        } else if (id == 63) {
            var iFlySlide = plugins + "63/iFlySlide.exe";
            TA.Stage.stages['app_63'] = spawn(iFlySlide, [], {detached: true}).on("exit", function () {
                console.log('监听到录课退出');
                //   这里是无用的监听
                //TA.Stage.stages['app_63']=null;
            });
            var filePath = APP_CONFIG.BASE_PATH + "/DAT/running.dat";
            var runningApp = [];
            try {
                runningApp = JSON.parse(shellcmd.readFile(filePath));
            }
            catch (e) {
            }
            if (runningApp.indexOf(id) == -1) {
                runningApp.push(id);
            }
            shellcmd.writeFile(filePath, JSON.stringify(runningApp));

        } else if (id == 64) {
            var RecordLesson = plugins + "64/RecordLesson.exe";
            TA.Stage.stages['app_64'] = spawn(RecordLesson, [], {detached: true}).on("exit", function () {
                console.log('监听到录课退出');
                TA.Stage.stages['app_64'] = null;
            });
        }

        that.resetRecentApp(id);
    },
    /**
     * 非NW架构的启动
     * @param config
     *  @param appPath 启动的相对路径，在ID的下一层
     */
    runAppNew: function (config, appPath, title) {
        var that = this;
        this.process.push(config.id);
        var id = config.id || config.appInfo.id;
        //todo:这里应该是finished吧
        var error = config.error;
        var appLastPath = plugins + id + "/" + appPath;
        if (TA.Stage.stages['app_' + id]) {
            spawn(appLastPath, [], {detached: true});
            that.appSetAlwaysTop(appPath, TA.Stage.stages['app_' + id].pid, title);
            return;
        }
        // LogManager.statisticsMoudleTime(id.toString(), "openApp");
        setTimeout(function () {
            // LogManager.statisticsMoudleTime(id.toString(), "entry");
            if(id != 62 && id != 63) {
                LogManager.statistics("enter", {ta_app :"ta_app", module: "03"+id, user_id :userInfo.id},null);
            }
        }, 1000);
        TA.Stage.stages['app_' + id] = spawn(appLastPath, [], {detached: true}).on("exit", function () {
            //关闭时置空信息
            TA.Stage.stages['app_' + id] = null;
            //用户离开APP
            // LogManager.statisticsMoudleTime(id.toString(), "quit");
            if(id != 62 && id != 63) {
                LogManager.statistics("quit", {ta_app :"ta_app", module: "03"+id, user_id :userInfo.id},null);
            }
            var filePath = APP_CONFIG.BASE_PATH + "/DAT/running.dat";
            var runningApp = [];
            try {
                runningApp = JSON.parse(shellcmd.readFile(filePath));
            }
            catch (e) {
            }
            if (runningApp.indexOf(id) !== -1) {
                runningApp.splice(runningApp.indexOf(id), 1);
            }
            shellcmd.writeFile(filePath, JSON.stringify(runningApp));
        });
        var filePath = APP_CONFIG.BASE_PATH + "/DAT/running.dat";
        var runningApp = [];
        try {
            runningApp = JSON.parse(shellcmd.readFile(filePath));
        }
        catch (e) {
        }
        if (runningApp.indexOf(id) == -1) {
            runningApp.push(id);
        }
        shellcmd.writeFile(filePath, JSON.stringify(runningApp));

        that.resetRecentApp(id);
    },
    /**
     * 用于选择是用来的运行方式还是新的
     * @param config
     */
    runAppControl: function (config) {
        var that = this;
        syncLocalAppList({
            info: "",
            ignoreIflybook: false,
            type: "read",
            success: function (localInfo) {
                    var localAppInfoMap = "";
                    try {
                        localAppInfoMap = JSON.parse(localInfo);
                        var localAppInfo = localAppInfoMap[config.id] || {};
                        var title = localAppInfo.title || "";
                        if ((APP_CONFIG.NEED_LOGIN_LIST.indexOf(config.id.toString()) != -1) && (onLoginFlag == 0 || onLoginFlag == false)) {
                            $("#login").trigger('click');
                            openTAMain();
                            return;
                        }
                        if (localAppInfo.is_nw && localAppInfo.is_nw == '0' && localAppInfo.open_path && localAppInfo.open_path != '')
                            that.runAppNew(config, localAppInfo.open_path, title);
                        else {
                            that.runAppOld(config, title);
                        }
                    }
                    catch (e) {
                        console.log(e)
                    }
                //}

            }
        });
    },
    runApp: function (config) {
        if (!MAIN_GLOBAL_FLAG) {
            //如果不是主程序，是百宝箱打开，让主进程启动，以便关闭
            taEmitter.emit(TA_EVENT.APP_OPEN + '.main.true', config.id || config.appInfo.id);

            //如果是登录用户信息后打开的，将信息写入文件
            var loginName = userInfo.loginName;
            var id = config.id;
            this.resetRecentApp(id);
            return;
        }
        var that = this;
        that.runAppControl(config);
    },
    runiFlybook: function (config) {

        //如果用户应用中无iflybook则不启动
//        var loginName = userInfo.loginName;
//        var infoPath = APP_CONFIG.BASE_PATH + "/user/" + loginName + "/appmanage.dat";
//        try {
//            var localInfo = shellcmd.readFile(infoPath);
//            if (localInfo) {
//                var localAppInfoMap = JSON.parse(localInfo);
//                if (localAppInfoMap[62]) {
//                    config.id = '62';
//                    this.runApp(config);
//                }
//            }
//        } catch (e) {
//
//        }

        //不用判断ifb是否安装
        config.id = '62';
        //this.runApp(config);
        //书架启动后把消息传递给IFB做进一步处理
        var ifbrun = process.execPath.substring(0,process.execPath.lastIndexOf('\\')).replace(/\\/g,"/")+'/ifbrun.flag';
        if(TA.Stage.stages["app_62"] || fs.existsSync(ifbrun)){
            shellcmd.appSetAlwaysTop(null,null,'课本教学');
        }else{
            this.runApp(config);
        }

    },
    /**
     * 打开答题宝
     * @param  from 从百宝箱打开或TA打开
     */
    runDTB: function (from, flag){
        if(APPManager.onlineFlag){
            if(!onLoginFlag){
                if(from == 'TA') {
                    loginAndCurtain(true)
                } else {
                    $("#mask_layer").show()
                    dialog({
                        id: 'dialog-loginComfirm',
                        title: '温馨提示',
                        content: document.getElementById('dtbLoginConfirm').innerHTML || "" ,
                        cancel: function () {
                            this.close();
                            //不销毁对话窗dom
                            return false;
                        }
                    }).show();

                    $(document).one('click','#net_img_ok_TAVOTER',function(){
                        $(this).parent().parent().parent().parent().parent().hide();
                        $("#mask_layer").hide();
                        socket && socket.send({type: 'logic', action: 'openLoginBox', to: 'main'});
                    });
                }
            }else{
                var exec = require('child_process').exec;
                var path = require('path');
                // var votedetectdir = "\"" + path.resolve("..\\..\\")+"\\tools\\TAVoteDetect.exe" + "\"";
                var nwexePath = process.execPath.substring(0,process.execPath.lastIndexOf('\\')).replace(/\\/g,"/");
                var votedetectdir = '"'+nwexePath + '/tools/TAVoteDetect.exe'+'"';
                var cwdPath = nwexePath +'/tools/';
                var options = {
                    cwd: cwdPath
                };
                var child = exec(votedetectdir,options,
                    function (error, stdout, stderr) {
                        console.log('stdout: ' + stdout);
                        console.log('stderr: ' + stderr);
                        if (error !== null) {
                            console.log('exec error: ' + error);
                        }
                    });
                child.on('exit', function (code) {
                    console.log('Child process exited with exit code '+code);
                    if (code != 0) {
                        console.log('no device install');
                        if (flag == 'qTool'){
                            dtbCheckDialogFromQtool();
                        } else {
                            dtbCheckDialog();
                        }
                    } else {
                        var plugins = APP_CONFIG.BASE_PATH + "/plugins/";
                        var spawn = require('child_process').spawn;
                        if (TA.Stage.stages['app_15']){
                            // spawn(nw, [plugins + '15'], {detached: true});
                            shellcmd.appSetAlwaysTop(null,TA.Stage.stages['app_15'].pid,'答题宝');
                            return;
                        }
                        TA.Stage.stages['app_15']  = spawn(nw, [plugins + '15'], {detached: true}).on("exit", function () {
                            //关闭时置空信息
                            TA.Stage.stages['app_15'] = null;
                        });
                    }
                });
            }
        }else{
            from == 'TA' ? pageMyPrepare.showCommonTip('网络不给力，请检查网络连接后重试') : dNetworkPanel.show();
        }
    },
    /**
     * 打开答题宝有屏版
     * @param  from 从百宝箱打开或TA打开
     */
    runDTB_screen: function (from){
        if(APPManager.onlineFlag){
            if(!onLoginFlag){
                if(from == 'TA') {
                    loginAndCurtain(true)
                } else {
                    $("#mask_layer").show()
                    dialog({
                        id: 'dialog-loginComfirm',
                        title: '温馨提示',
                        content: document.getElementById('dtbLoginConfirm').innerHTML || "" ,
                        cancel: function () {
                            this.close();
                            //不销毁对话窗dom
                            return false;
                        }
                    }).show();

                    $(document).one('click','#net_img_ok_TAVOTER',function(){
                        $(this).parent().parent().parent().parent().parent().hide();
                        $("#mask_layer").hide();
                        socket && socket.send({type: 'logic', action: 'openLoginBox', to: 'main'});
                    });
                }
            }else{
                var exec = require('child_process').exec;
                var path = require('path');
                // var votedetectdir = "\"" + path.resolve("..\\..\\")+"\\tools\\TAVoteDetect.exe" + "\"";
                var nwexePath = process.execPath.substring(0,process.execPath.lastIndexOf('\\')).replace(/\\/g,"/");
                var votedetectdir = '"'+nwexePath + '/tools/TAVoteDetect.exe'+'"';
                var cwdPath = nwexePath +'/tools/';
                var options = {
                    cwd: cwdPath
                };
                var child = exec(votedetectdir,options,
                    function (error, stdout, stderr) {
                        console.log('stdout: ' + stdout);
                        console.log('stderr: ' + stderr);
                        if (error !== null) {
                            console.log('exec error: ' + error);
                        }
                    });
                child.on('exit', function (code) {
                    console.log('Child process exited with exit code '+code);
                    if (code != 0) {
                        console.log('no device install');
                        dtbCheckDialog();
                    } else {
                        var plugins = APP_CONFIG.BASE_PATH + "/plugins/";
                        var spawn = require('child_process').spawn;
                        if (TA.Stage.stages['app_150']){
                            // spawn(nw, [plugins + '15'], {detached: true});
                            shellcmd.appSetAlwaysTop(null,TA.Stage.stages['app_150'].pid,'答题宝有屏版');
                            return;
                        }
                        TA.Stage.stages['app_150']  = spawn(nw, [plugins + '150'], {detached: true}).on("exit", function () {
                            //关闭时置空信息
                            TA.Stage.stages['app_150'] = null;
                        });
                    }
                });
            }
        }else{
            from == 'TA' ? pageMyPrepare.showCommonTip('网络不给力，请检查网络连接后重试') : dNetworkPanel.show();
        }
    },

    /*
    * 打开实物展台
    *
    */
    runcameraStand:function(config){
        config.id=91;
        var exArray = [];
        MediaStreamTrack.getSources(function(devs){
            for(var i=0;i<devs.length;i++){
                if(devs[i].kind=="video"&&devs[i].label!="screen-capture-recorder"){
                    exArray.push(devs[i]);
                }
            }
            if(exArray.length==0){
                // alert("没有连接摄像头设备，实物展台不可用！")
                /*$("#noCameraReminder,#Camera_mask").show();
                var xpos= ($("#min").width()-$("#noCameraReminder").width())/2;
                var ypos=($("#min").height()-$("#noCameraReminder").height())/2;
                $("#noCameraReminder").css({  //设置位置
                    left:  xpos,
                    top:   ypos,
                })*/
                noCameraConfirm.show();
                $("#btn_no_camera").one('click',function () {
                    // $("#mask_layer").hide();
                    noCameraConfirm.cancel();
                    // $("#temp_no_camera_pop").parent().parent().hide();
                })
            }else{
                APPManager.prototype.runApp(config)
            }
        });
    },

    setLastAppInfoList: function (map) {
        try {
            var path = require('path');
            var content = JSON.stringify(map || {});
            //NC.Storage.setValue("-main-lastAppInfoList", content);
            shellcmd.writeFile(path.join(APP_CONFIG.BASE_PATH, 'appdata.dat'), content);
        } catch (ex) {

        }
    },
    getLocalAppInfoMapping: function () {
        var content = NC.Storage.getValue("-main-localAppInfoMapping") || "{}";
        return JSON.parse(content);
    },
    setLocalAppInfoMapping: function (map) {
        var content = JSON.stringify(map || {});
        NC.Storage.setValue("-main-localAppInfoMapping", content);
    },
    /**
     * 使用或下载APP改变TA首页右上角展示APP的位置
     */
    resetRecentApp: function(id) {
        syncRecentUse({
            type: 'read',
            success: function(recentUse) {
                if (recentUse.indexOf(id) !== -1) {
                    recentUse.splice(recentUse.indexOf(id), 1);
                    recentUse.unshift(id);
                } else {
                    recentUse.unshift(id);
                }
                syncRecentUse({
                    type: 'write',
                    appRecentUse: recentUse,
                    success: function() {
                        console.log("移动TA首页右上角展示APP的位置成功");
                    }
                });

                //在不同进程中打开app，利用nw进程刷新; 否则直接刷新appRegion
                if(typeof(appRegion) == "undefined") {
                    taEmitter.emit(TA_EVENT.RECENTUSE_CHANGE + ".main.true");
                } else {
                    setTimeout(function() {
                        appRegion.setRecentApp(userInfo);
                    }, 1000);
                }
            }
        });
    }
};

var OLAPPManager = NC.oop(APPManager, {
    online: 1,
    getLastAppInfoList: function (callback) {
        var that = this;
        $.ajax({
            url: APP_CONFIG.REQUIRE_URL + "app_controller-getLatestAppInfo.html",
            type: 'post',
            error: function () {
                callback && callback('error');
            },
            timeout: 30000,
            success: function (data) {
                data = $.trim(data);
                // 捕获某些网络异常时返回的data不是json数据引发异常
                try{
                    var apclist = JSON.parse(data);
                    that.setLastAppInfoList(apclist);
                    //加载成功，删除加载等待
                    $('.loading').remove();
                    callback && callback(apclist);
                }catch(e){
                    callback && callback([]);
                }
            },
            error: function () {
                callback && callback([]);
            }
        });
    },
    getAppDetailInfo: function (callback) {
        var id = callback.id;
        var success = callback.success;
        $.ajax({
            url: APP_CONFIG.REQUIRE_URL + "app_controller-getAppInfo-apm_id-" + id + ".html",
            type: 'get',
            error: function () {
                //alert("当前网络不稳定");
            },
            success: function (data) {
                var app = JSON.parse(data) || "";
                app = app[0] || "";
                if (!app || app == "")
                    success && success("");
                success && success(app);
            }
        });
    },
    getSortAppList: function (callback) {
        var that = this;
        $.ajax({
            url: APP_CONFIG.REQUIRE_URL + "main_controller-getBestApp.html",
            type: 'post',
            timeout: 30000,
            success: function (data) {
                try {
                    var apclist = JSON.parse(data);
                    //加载成功，删除加载等待
                    callback && callback(apclist);
                } catch (e) {
                    callback && callback([]);
                }

            },
            error: function () {
                callback && callback([]);
            }
        });
    },
    updateApp: function (config) {
        var that = this;
        var appInfo = config.appInfo;
        //最新的app信息.
        var begin = config.begin;
        var progress = config.progress || {};
        var end = config.end;
        var error = config.error;
        var unzip = require('../node_modules/unzip');
        var l = loader({
            url: appInfo.url,
            target: plugins + appInfo.id + ".nw",
            begin: begin,
            progress: progress.download,
            dirPath: plugins + appInfo.id,
            end: function () {
                //下载完毕
                console.log('down finish');
                //app(具体)下载完毕监管    ---pengchen3
                LogManager.statistics("trigger", {ta_app :"ta_app", module: "01"+appInfo.id, user_id :userInfo.id},null);

                //先卸载老版本
                that.removeApp({
                    id: appInfo.id,
                    isUpdataApp: true,
                    oneBreak: function () {
                        end && end();
                    },
                    success: function () {
                        //卸载成功解压缩, 写入APP信息
                        progress.unzip && progress.unzip();
                        var extract = unzip.Extract({
                            path: plugins + appInfo.id,
                            verbose: true
                        });
                        fs.createReadStream(plugins + appInfo.id + ".nw").pipe(extract);
                        extract.on("close", function () {
                            //清除临时文件
                            fs.unlink(plugins + appInfo.id + ".nw");
                            syncLocalAppList({
                                info: appInfo,
                                type: "write",
                                success: function () {
                                    end && end();
                                }
                            });
                            //更新app物理文件后同步版本文件
                            syncAppVersion({
                                appInfo: appInfo,
                                type: "write",
                                success: function() {
                                    console.log("成功同步版本文件");
                                }
                            });
                            //写入预装
                            // var preInstallArr = [];
                            // var filePath = APP_CONFIG.BASE_PATH + "/preInstall.dat";
                            // try {
                            //     preInstallArr = JSON.parse(shellcmd.readFile(filePath));
                            //     if (preInstallArr.indexOf(appInfo.id) == -1) preInstallArr.push(Number(appInfo.id));
                            //     console.log(preInstallArr);
                            //     shellcmd.writeFile(filePath, JSON.stringify(preInstallArr));
                            // }
                            // catch (e) {
                            //     console.error(e.message);
                            //     error && error(e);
                            // }

                            that.resetRecentApp(appInfo.id);
                        });

                    },
                    error: error
                });
            },
            error: error
        });
    }
});
var OffLineAPPManager = NC.oop(APPManager, {
    online: 0,
    getLastAppInfoList: function (callback) {
        try {
            var path = require('path');
            var content = shellcmd.readFile(path.join(APP_CONFIG.BASE_PATH, 'appdata.dat'));
            //content为空，主要是appdata.dat的内容被恶意删除或者文件不存在
            if (content != '') {
                //加载成功，删除加载等待
                $('.loading').remove();
            }else{
                content = "{}";
                $('.loading').remove();
            }
            callback && callback(JSON.parse(content));
        } catch (ex) {
            callback && callback({});
            console.error(ex);
        }
    },
    getAppDetailInfo: function (callback) {
        var id = callback.id;
        var success = callback.success;
        var listContent, thisItem;
        this.getLastAppInfoList(function (list) {
            if (list) {
                for (var i = 0; i < list.length; i++) {
                    if (list[i].data) {
                        for (var j = 0; j < list[i].data.length; j++) {
                            if (list[i].data[j]['apm_id'] == id) {
                                success && success(list[i].data[j]);
                                break;
                            }
                        }
                    }
                }
            }
        });
    },
    getSortAppList: function (callback) {
        callback && callback([]);
    },
    updateApp: function () {
        dNetworkPanel.show();
    }
});
