/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/5 14:04
 * description :
 */
/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/3 9:31
 * description : hprose 服务端 说明如下 :
 * ----------------------------------------------------------
 * 这里只向外暴露了一个hproseBroadcast 广播的方法 可直接调用 其他均在
 * hproseNoti 和 hproseCall 进行分发处理
 * ----------------------------------------------------------
 */
;
(function (win) {
    // 捕获全局异常
    process.on('uncaughtException', function (err) {
        console.error(err);
    });
    function hproseServerSub(hproseNoti,hproseCall) {
        var hprose = require('hprose');
        var serverHprose = hprose.Server.create('ws://0.0.0.0:19527');
        serverHprose.publish('topic');
        // serverHprose.publish('topic',{heartbeat:3000});//默认为3秒心跳
        serverHprose.addFunction(hproseSend,{oneway:true});
        serverHprose.addFunction(hproseNoti,{oneway:true});
        serverHprose.addAsyncFunction(hproseCall);
        serverHprose.addAsyncFunction(checkNetState);
        serverHprose.start();
        win.serverHprose = serverHprose;
        serverHprose.onAccept = function (context) {
            console.log('%c a new client, total: '+context.server.clients.length + ' '+(new Date).toLocaleString(),'color:green');

        };
        serverHprose.onClose = function (context) {
            console.log('%c have close a client, total: '+context.server.clients.length + ' '+(new Date).toLocaleString(),'color:deeppink');
        };
        // serverHprose.on('beforeInvoke', function(name, args, byref, context) {
        //     if(name != "checkNetState")
        //         console.log(name, args, byref);
        // });
        // serverHprose.on('sendError',function(err,ctx){
        //     console.log(err,ctx);
        // });
        win.hproseBroadcast = broadcast;

        /**
         * 广播 默认只需传入data参数即可
         * @param data
         * @param from
         * @param to
         */
        function broadcast(data,from,to) {
            var tempData = {};
            tempData._from = from||'server';
            tempData._to = to||'all';
            tempData.method = 'broadcast';
            tempData.data = data;
            serverHprose.broadcast('topic',tempData,function (success,fail) {
                //在这里可以查看广播成功和失败的列表
                // console.log("\r\nbroadcast success: "+success);
                // console.log("\r\nbroadcast fail: "+fail);
            });
        }

        /**
         * 传入data,JSON对象，三个属性参数 _from,_to,data
         * @param data
         */
        function hproseSend(data) {
            var _to = data._to;
            //if是 all 或者空 则默认为广播
            if(_to == 'all' ||!_to) broadcast(data);
            else {
                //多播或者是单播  都调用单播实现 这样 _to参数 仅有一个
                var arr = [];
                if(typeof _to == 'string') arr.push(_to);
                else arr = _to;
                for(var i =0,len=arr.length,tempData={};i<len;i++){
                    tempData._from = data._from || 'server';
                    tempData._to = arr[i];
                    tempData.method = data.method;
                    tempData.data = data.data;
                    if(data.method=='download'||data.method=='upload') tempData.extension = data.extension;
                    serverHprose.unicast('topic',arr[i],tempData,function (ret) {
                        //ret 记录单播是否成功
                        // console.log(ret);
                    });
                }

            }
        }
        win.hproseSend = hproseSend;


    }
    win.hproseServerSub = hproseServerSub;
})(window);

hproseServerSub(hproseNoti,hproseCall);
/**
 * 通知函数，无回调
 * @param message 一般为JSON数据 便于分发
 */
function hproseNoti(message) {
    _NOTI.reg(message);
}

/**
 * 客户端调服务端的方法
 * @param data 一般为JSON数据 便于分发
 * @param callback 回调client子方法
 */
function hproseCall(data,callback){
    _CALL.reg(data,callback);
}

function checkNetState(callback){
    var state = window.NetWorkListener ? window.NetWorkListener.online : true;
    // if(!state){
    //     _COMMON.trayTipMessage("网络不给力，请检查网络连接");
    // }
    callback(state);
}

