/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/9 9:19
 * description :
 */
;
(function (win) {
    var _FILE = {}, BP = APP_CONFIG.BASE_PATH + '/user/';
    var _fs = require('fs');
    var _yauzl = require('yauzl');
    win._FILE = _FILE;
    var bookCache = {};//缓存book已经存在的记录，这样不必每次去检查文件 for checkBook

    _FILE.checkBook = function (userName, bookCode) {
        var def = $.Deferred();
        var path = BP + userName + '/books/' + bookCode;
        if(bookCache[userName]&&bookCache[userName][bookCode]){
            setTimeout(function () {
                def.resolve();
            },0);
        }else {
            //缓存中不存在
            _fs.exists(path, function (exist) {
                if(!exist) {
                   _COMMON.mkdir(path).done(function () {

                       if(typeof bookCache[userName] == 'object'){
                           bookCache[userName][bookCode] = true;
                       }else {
                           bookCache[userName]={};
                           bookCache[userName][bookCode] = true;
                       }
                       def.resolve();
                   }).fail(function () {

                       if(typeof bookCache[userName] == 'object'){
                           bookCache[userName][bookCode] = true;
                       }else {
                           bookCache[userName]={};
                           bookCache[userName][bookCode] = true;
                       }
                       def.resolve();
                   });
                }else {
                    if(typeof bookCache[userName] == 'object'){
                        bookCache[userName][bookCode] = true;
                    }else {
                        bookCache[userName]={};
                        bookCache[userName][bookCode] = true;
                    }
                    def.resolve();
                }

            });
        }

        return def.promise();
    };

    _FILE.deleteFolder = function (userName,bookCode,uuid) {
        var def = $.Deferred();
        var path = BP + userName + '/books/' + bookCode+'/'+uuid;
        _COMMON.deleteDir(path,function () {
           def.resolve();
        },function (e) {
            def.reject(e);
        });
        return def.promise();
    };

    _FILE.deleteFolderBat = function (userName,bookCode,arr) {
        for(var i=0,len = arr.length;i<len;i++){
            _FILE.deleteFolder(userName,bookCode,arr[i]);
        }
    };
    
    _FILE.checkName = function (orgName,oldNames) {
        var i = 2,k;
        var newName = orgName;
        //slice for copy Arrary and don't change orc value
        var oldNames = oldNames.slice();
        k = $.inArray(newName,oldNames);
        while (k>=0){
            oldNames.splice(k,1);
            newName = orgName+'('+i+')';
            i++;
            k = $.inArray(newName,oldNames);
        }
        return newName;

    };

    _FILE.readMTBKList = function (fileName){
        var def = $.Deferred();
        var arr = [];
        _yauzl.open(fileName,{lazyEntries:true},function (err,zipfile) {
            if(err){
                def.reject(err);
            }else {
                zipfile.readEntry();
                zipfile.on('entry',function (entry) {

                    if (!/\/$/.test(entry.fileName)&&!/.xaml$/.test(entry.fileName)){
                        arr.push(entry.fileName.substr(entry.fileName.lastIndexOf('/')+1));
                    }
                    zipfile.readEntry();
                });
                zipfile.on('close',function () {
                    def.resolve(arr);
                });
                zipfile.on('error',function (e) {
                    def.reject(e);
                });
            }

        });
        return def.promise();
    };

    _FILE.getMTBKInfo = function (fileName){
        var def = $.Deferred();
        var arr = [];
        _yauzl.open(fileName,{lazyEntries:true},function (err,zipfile) {
            if(err){
                def.reject(err);
            }else {
                zipfile.readEntry();
                zipfile.on('entry',function (entry) {

                    if (!/\/$/.test(entry.fileName)&&!/.xaml$/.test(entry.fileName)){

                        arr.push(entry.fileName.replace(/\\/g,'/'));
                    }
                    zipfile.readEntry();
                });
                zipfile.on('close',function () {
                    def.resolve(arr);
                });
                zipfile.on('error',function (e) {
                    def.reject(e);
                });
            }

        });
        return def.promise();
    };



    _FILE.depart = function (config) {
        var def = $.Deferred();
        var path = config.file.replace(/\\/g,'/');
        var tempDir = process.env.TEMP+ '\\' + _COMMON.guid();
        var fileName = path.substr(path.lastIndexOf('/')+1);
        var ext = fileName.substr(fileName.lastIndexOf('.')+1);
        var result = {
            number:0,
            dir:tempDir,
            arr:[],
            size:0
        };
        _COMMON.fileStat(path).done(function (pro) {
            if(pro.isDir){
                def.reject('not a file,is a dir');
            }else {
                _COMMON.mkdir(tempDir).done(function () {
                    //single size of block is 50M
                    var sizeB = pro.size,cell = 50*1024*1024,len=1,pre=0;
                    result.size = pro.size;
                    while (len*cell<sizeB-1){
                        result.arr.push({
                            start:pre,
                            end:len*cell-1,
                            dst:tempDir+'\\'+len+'.'+ext,
                            src:path
                        });
                        pre = len*cell;
                        len++;
                    }
                    result.arr.push({
                        start:pre,
                        end:sizeB>0?sizeB-1:0,
                        dst:tempDir+'\\'+len+'.'+ext,
                        src:path
                    });
                    result.number = result.arr.length;
                    global_queue(result.arr,_FILE.copyPart).done(function () {
                        def.resolve(result);
                    }).fail(function (e) {
                        _COMMON.deleteDir(tempDir);
                        def.reject(e);
                    });
                }).fail(function (e) {
                    def.reject(e);
                });

            }

        }).fail(function (e) {
            def.reject(e);
        });

        return def.promise();
    };

    _FILE.copyPart = function (config) {
        var def = $.Deferred();
        var read = _fs.createReadStream(config.src,{start:config.start,end:config.end});
        var write = _fs.createWriteStream(config.dst);
        read.pipe(write);
        write.on('error', function (e) {
            def.reject(e);
        });
        write.on('close', function () {
            def.resolve();
        });
        return def.promise();
    };


})(window);
