/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/17 19:22
 * description :
 */
;
(function (win) {

    var Curl=require("node-libcurl").Curl;
    var fs = require("fs");
    var async = require("async");
    var Q = require("q");
    var exec = require("child_process").exec;
    var spawn = require("child_process").spawn;
    var uuid = require("uuid");

    var const_connect_timeout = 5;
    var const_reconnect_interval = 500;
    var const_section_reconnect_interval = 15;
    var const_retry = 5;
    var const_progress_notify = 1000;

    var getDownloadFileLength = function(url){
        var deferred = Q.defer();
        var curl = new Curl();
        curl.setOpt('URL',url);
        curl.setOpt(Curl.option.HEADER,1);
        curl.setOpt(Curl.option.NOBODY,1);
        curl.setOpt(Curl.option.CONNECTTIMEOUT, const_connect_timeout);
        curl.setOpt(Curl.option.TIMEOUT,const_connect_timeout);
        curl.perform();
        curl.on( 'end', function ( statusCode, body, headers ) {
            var httpCode = statusCode + '';
            var startString = httpCode.slice(0,1);
            if(startString == '2' || startString == '3'){
                var total = this.getInfo("CONTENT_LENGTH_DOWNLOAD");
                this.close();
                deferred.resolve(total);
            }else{
                this.close();
                deferred.reject('reQuestError::statusCode:' + statusCode);
            }
        });

        curl.on( 'error', function ( err, curlErrCode ) {
            this.close();
            err.code = curlErrCode;
            deferred.reject(err);
        });
        return deferred.promise;
    };

    var curlDownload = function(curl,option){

        var deferred = Q.defer();

        curl.setOpt( 'URL', option.url );
        if(typeof option.range != "undefined"){
            curl.setOpt( Curl.option.RANGE , option.range);
        }
        if(typeof option.timeout != "undefined"){
            curl.setOpt( Curl.option.TIMEOUT, option.timeout);
        }
        if(typeof option.connectTimeout != "undefined"){
            curl.setOpt( Curl.option.CONNECTTIMEOUT, option.connect_timeout);
        }
        if(typeof option.speedLimit != "undefined"){
            curl.setOpt( Curl.option.MAX_RECV_SPEED_LARGE,option.speedLimit);
        }
        if(typeof option.processCallback != "undefined"){
            curl.setOpt( Curl.option.NOPROGRESS, false );
            curl.enable( Curl.feature.NO_STORAGE );
            curl.setProgressCallback( function( dltotal, dlnow/*, ultotal, ulnow*/ ) {
                if ( dltotal === 0 ) {
                    return 0;
                }
                if(typeof(option.processCallback) != "undefined"){
                    option.processCallback.apply(this,[dltotal, dlnow]);
                }
                return 0;
            });
        }
        // This is the same than the data event, however,
        // keep in mind that here the return value is considered.
        curl.setOpt( Curl.option.WRITEFUNCTION, function( chunk ) {
            deferred.notify(chunk);
            return chunk.length;
        });
        curl.on( 'end', function(){
            curl.close.bind( curl ) ;
            deferred.resolve();
        });
        curl.on( 'error', function(err,code){
            curl.close.bind( curl ) ;
            err.code = code;
            deferred.reject(err);
        });
        curl.perform();
        return deferred.promise;
    };

    var DownloadSection = function(sectionOption){
        this.state = 0; //0: unfinished ;1: finished
        this.sectionOption = sectionOption;
        // console.log(JSON.stringify(this.saveInfo()));
    };

    DownloadSection.prototype.getTotal = function(){
        var deferred = Q.defer();
        var _this = this;

        getDownloadFileLength(_this.sectionOption.url).then(function(total){
            _this.originTotal = total;
            if(typeof _this.sectionOption.total == "undefined"){
                deferred.resolve(total);
            }
            else{
                deferred.resolve(_this.sectionOption.total);
            }
        }).fail(function(err){
            deferred.reject(err);
        })
        return deferred.promise;
    }
//single thread Dowload with reconnect
    DownloadSection.prototype.download = function(resume) {
        var _this = this;
        var deferred = Q.defer();
        if(!resume){
            _this.hasDownload = 0;
            _this.total = 0;
        }
        _this.retry = _this.sectionOption.retry;
        _this.errCount = 0;
        //
        _this.__current_handle = null;

        _this.getTotal().then(function(total){
            _this.total = total;
            return total;
        }).then(function(){
            if(_this.total < (_this.originTotal - 1) || _this.hasDownload)
                _this.sectionOption.range = _this.getNextRange();

            if(_this.hasDownload == 0){
                _this.__writeStream = fs.createWriteStream(_this.sectionOption.file,{
                    flags:'w'
                });
            }
            else{
                _this.__writeStream = fs.createWriteStream(_this.sectionOption.file,{
                    flags:'a'
                });
            }
            _this.__writeStream.on("finish",function(){
                deferred.resolve();
            });

            async.until(function(){
                return _this.state == 1;
            },function(next){
                _this.__current_handle = new Curl();
                curlDownload(_this.__current_handle,_this.sectionOption).then(function(){
                    _this.state = 1;
                    _this.__writeStream.end();
                },null,function(chunk){
                    //
                    _this.errCount = 0;
                    //
                    _this.__writeStream.write(chunk);
                    _this.hasDownload += chunk.length;

                    deferred.notify({
                        total:_this.total,
                        now:_this.hasDownload
                    });
                }).fail(function(err){
                    //
                    _this.__current_handle.close();
                    //
                    if(err.code == 28 && fs.existsSync(_this.sectionOption.file)){
                        //
                        var range = _this.getNextRange();
                        if(!range){
                            _this.__writeStream.end();
                            next(err);
                        }
                        else{
                            _this.sectionOption.range = range;
                            setTimeout(function(){
                                next(null);
                            },const_reconnect_interval);
                        }
                    }
                    else{
                        if(_this.errCount < _this.retry){
                            console.log(err);
                            //
                            _this.errCount++ ;
                            setTimeout(function(){
                                next(null);
                            },const_reconnect_interval);
                        }
                        else{
                            _this.__writeStream.end();
                            next(err);
                        }
                    }
                });
            },function(err){
                deferred.reject(err);
            })
        }).fail(function(err){
            deferred.reject(err);
        })

        return deferred.promise;
    };

    DownloadSection.prototype.close = function(){
        var _this = this;
        try{
            _this.__current_handle.close();
            _this.__writeStream.end();
        }
        catch(err){
            //pass
        }
    };

    DownloadSection.prototype.saveInfo = function(){
        var info = {
            sectionOption : this.sectionOption,
            total : this.total,
            hasDownload : this.hasDownload
        };
        return JSON.parse(JSON.stringify(info));
    };

    DownloadSection.prototype.getNextRange = function(){
        var _this = this;

        var startPos = 0;
        var endPos = 0;

        if(typeof _this.sectionOption.startPos == "undefined"){
            _this.sectionOption.startPos = 0;
        }

        startPos = _this.sectionOption.startPos + _this.hasDownload;

        if(_this.sectionOption.startPos == 0){
            endPos = _this.total;
        }
        else{
            endPos = _this.sectionOption.startPos + _this.total - 1;
        }
        console.log(_this.sectionOption.file+":" + startPos + "-" + endPos + "-" + _this.hasDownload);
        //
        if(startPos > endPos){
            return "";
        }
        else{
            return startPos + "-" + endPos;
        }
    }

    DownloadSection.prototype.resume = function(info){
        if(typeof info != "undefined"){
            this.sectionOption = info.sectionOption;
            this.total = info.total;
            this.hasDownload = info.hasDownload;
        }
        return this.download(true);
    };

    var ThreadsDownload = function(option){
        this.option = option;
        this.sections = [];
        this.total = 0;
        this.now = 0;
        this.timestamp = 0;
    };

    ThreadsDownload.prototype.download = function(){
        var deferred = Q.defer();
        var _this = this;
        getDownloadFileLength(_this.option.url).then(function(total){
            _this.total = total;
            if(typeof _this.option.threads == "undefined"){
                _this.option.threads = 1;
            }
            var sectionLength = Math.floor(total / _this.option.threads);
            var leftLength = _this.total;
            var downloadThreads = [];
            var startPos = 0;
            for(var i=0;i<_this.option.threads;i++){
                (function(i){
                    var length = i == (_this.option.threads - 1) ? leftLength : sectionLength;
                    var endPos = i == 0 ? (startPos + length) : (startPos + length - 1);
                    var sectionOption = {
                        url:_this.option.url,
                        // file:_this.option.file,
                        file:_this.option.file+".part_"+i,
                        total: i == (_this.option.threads - 1) ? leftLength : sectionLength,
                        retry : _this.option.retry ? _this.option.retry : const_retry,
                        timeout: const_section_reconnect_interval,
                        connect_timeout: _this.option.connect_timeout ? _this.option.connect_timeout : const_connect_timeout,
                        startPos : startPos
                    };
                    startPos = endPos + 1;
                    leftLength -= sectionLength;

                    var section = new DownloadSection(sectionOption);

                    downloadThreads.push(function(next){
                        section.download().then(function(){
                            next(null);
                        },function(err){
                            next(err);
                        },function(progress){
                            if(Date.now() - _this.timestamp > const_progress_notify){
                                _this.total = _this.total;
                                _this.now = 0;
                                for(var i=0;i<_this.sections.length;i++){
                                    _this.now += _this.sections[i].hasDownload;
                                }
                                deferred.notify({
                                    total:_this.total,
                                    now:_this.now
                                });
                                _this.timestamp = Date.now();
                            }
                        })
                    });

                    _this.sections.push(section);

                })(i);
            };
            async.parallel(downloadThreads,function(err,results){
                var finished = true;
                for(var i=0;i<_this.sections.length;i++){
                    if(_this.sections[i].state == 0){
                        finished = false;
                        break;
                    }
                }
                if(!err && finished){
                    var arrFile = [];
                    for(var i=0;i<_this.sections.length;i++){
                        arrFile.push({
                            final:_this.option.file,
                            file:_this.sections[i].sectionOption.file,
                            delete:true
                        });
                    }
                    win.global_queue(arrFile,_COMMON.appendFileSingle).done(function () {
                        deferred.resolve();
                    }).fail(function (e) {
                        deferred.reject(e);
                    });

                }
                else{
                    deferred.reject(err);
                    for(var i=0;i<_this.sections.length;i++){
                        fs.unlink(_this.sections[i].sectionOption.file);
                    }
                }
            })

        }).fail(function(err){
            deferred.reject(err);
        });
        return deferred.promise;
    };

    ThreadsDownload.prototype.close = function(){
        var _this = this;
        for(var i=0;i<_this.sections.length;i++){
            _this.sections[i].close();
        }
    };

    ThreadsDownload.prototype.saveInfo = function(){
        var _this = this;
        var info = {
            option : _this.option,
            total : _this.total,
            now : _this.now,
            sections : []
        }
        for(var i=0;i<_this.sections.length;i++){
            info.sections.push(_this.sections[i].saveInfo());
        }
        return JSON.parse(JSON.stringify(info));
    };

    ThreadsDownload.prototype.clearCache = function(){
        var _this = this;
        for(var i=0;i<_this.sections.length;i++){
            var sectionOption = _this.sections[i].sectionOption;
            if(fs.existsSync(sectionOption.file)){
                fs.unlinkSync(sectionOption.file);
            }
        }
    }

    ThreadsDownload.prototype.resume = function(info){
        var _this = this;
        var deferred = Q.defer();

        _this.option = info.option;
        _this.total = info.total;
        _this.now = info.now;

        var downloadThreads = [];

        for(var i=0;i<info.sections.length;i++){
            (function(i){
                var sectionInfo = info.sections[i];
                var section = new DownloadSection();
                downloadThreads.push(function(next){
                    section.resume(sectionInfo).then(function(){
                        next(null);
                    },function(err){
                        next(err);
                    },function(progress){
                        if(Date.now() - _this.timestamp > const_progress_notify){
                            _this.total = _this.total;
                            _this.now = 0;
                            for(var i=0;i<_this.sections.length;i++){
                                _this.now += _this.sections[i].hasDownload;
                            }
                            deferred.notify({
                                total:_this.total,
                                now:_this.now
                            });
                            _this.timestamp = Date.now();
                        }
                    })
                });

                _this.sections.push(section);
            })(i);
        };
        async.parallel(downloadThreads,function(err,results){
            var finished = true;
            for(var i=0;i<_this.sections.length;i++){
                if(_this.sections[i].state == 0){
                    finished = false;
                    break;
                }
            }
            if(!err && finished){
                var cmd = 'copy /b ';
                for(var i=0;i<_this.sections.length;i++){
                    if( i != _this.sections.length - 1){
                        cmd += '"' + _this.sections[i].sectionOption.file + '"+';
                    }
                    else{
                        cmd += '"' + _this.sections[i].sectionOption.file + '" ';
                    }
                }
                cmd += '"' + _this.option.file + '"';
                exec(cmd,function(err){
                    if(!err){
                        for(var i=0;i<_this.sections.length;i++){
                            var file = _this.sections[i].sectionOption.file;
                            if(fs.existsSync(file)){
                                fs.unlinkSync(file);
                            }
                        }
                        deferred.resolve();
                    }
                    else{
                        deferred.reject(err);
                    }
                })

            }
            else{
                deferred.reject(err);
            }
        });
        return deferred.promise;
    };

    var DownloadManger = function(){
        this.tasks = {};
    };

    DownloadManger.prototype.addTask = function(option){
        var taskId = uuid();
        this.tasks[taskId] = new ThreadsDownload(option);
        return {
            id:taskId,
            task: this.tasks[taskId].download()
        };
    };

    DownloadManger.prototype.removeTask = function(taskId){
        if(taskId == 0){
            for(var id in this.tasks){
                this.tasks[id].close();
                this.tasks[id].clearCache();
            }
            this.tasks = {};
        }
        else{
            this.tasks[taskId].close();
            this.tasks[taskId].clearCache();
            delete this.tasks[taskId];
        }
    };

    DownloadManger.prototype.pause = function(taskId){
        this.tasks[taskId].close();
        return this.tasks[taskId].saveInfo();
    };

    DownloadManger.prototype.resume = function(taskId,info){
        return this.tasks[taskId].resume(info);
    };

    win.global_ThreadsDownload = ThreadsDownload;
    win.global_DownloadSection = DownloadSection;
    win.global_DownloadManger = DownloadManger;
    win.global_getDownloadFileLength = getDownloadFileLength;

})(window);