/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/5 11:32
 * description : 公共模块,用于提供hprose基本功能
 */

(function (win) {
    var _fs = require('fs');
    var _crypto = require('crypto');
    var _path = require('path');
    var _Q = require("q");
    var _yazl = require('yazl');
    var _async = require('async');
    win._COMMON = {};

    /**
     * 获取guid
     * @param len 长度
     * @returns {string} 小写的字符串
     */
    _COMMON.guid = function (len) {
        var len = len||32;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
        var maxPos = $chars.length;
        var pwd = '';
        for (var i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd.toLowerCase();
    };

    _COMMON.existFile = function (path) {
        var def = $.Deferred();
        _fs.exists(path,function (exist) {
            if(exist) def.resolve();
            else def.reject();
        });
        return def.promise();
    }

    _COMMON.getMd5 = function (path) {
        var def = $.Deferred();
        var hash = _crypto.createHash('md5');
        var readStream = _fs.createReadStream(path);
        readStream.on('data', function(chunk) { // 当有数据流出时，写入数据
            hash.update(chunk);
        });

        readStream.on('end', function() { // 当没有数据时，关闭数据流
            var md5 = hash.digest('hex');
            def.resolve(md5);
        });
        return def.promise();
    };

    _COMMON.copyFile = function (src,des) {
        var def = $.Deferred();
        src = src.replace(/\\/g,"/");
        des = des.replace(/\\/g,"/");
        var fileReadStream = _fs.createReadStream(src);
        var fileWriteStream = _fs.createWriteStream(des);
        fileReadStream.pipe(fileWriteStream);
        fileWriteStream.on('error', function () {
            def.reject();
        });
        fileWriteStream.on('close', function () {
            def.resolve();
        });
        return def.promise();
    };

    _COMMON.deleteFile = function (path) {
      var def = $.Deferred();
        _fs.unlink(path,function (err) {
            if(err) def.reject();
            else def.resolve();
        });
        return def.promise();
    };

    _COMMON.deleteDir = function (path,success,error) {
        var tempLength;
        var thisFunction = arguments.callee;
        var path = path;
        if (_fs.existsSync(path)) {
            var files = _fs.readdirSync(path);
            tempLength = files.length;
            if (tempLength == 0) {
                try{
                    _fs.rmdirSync(path);
                    success && success(path);
                }catch(e) {
                    error && error(e);
                }
                return;
            }
            files.forEach(function (file) {
                var curPath = path + "/" + file;
                _fs.stat(curPath, function (err, stats) {
                    if (!err && stats.isDirectory()) {
                        thisFunction(curPath, function () {
                            console.log(files.length);
                            tempLength--;
                            if (tempLength == 0) {
                                try{
                                    _fs.rmdirSync(path);
                                    success && success(path);
                                }catch(e) {
                                    error && error(e);
                                }
                            }

                        });
                    } else {
                        _fs.unlink(curPath, function (e) {
                            if(e){
                                error && error(e);
                            } else {
                                tempLength--;
                                if (tempLength == 0) {
                                    try {
                                        _fs.rmdirSync(path);
                                        success && success(path);
                                    } catch (e) {
                                        error && error(e);
                                    }
                                }
                            }
                        });
                    }
                });

            });

        } else {
            success && success(path);
        }
    };

    _COMMON.mkdir = function (path) {
        var def = $.Deferred();
        _fs.mkdir(path,function (err) {
            if(err) def.reject(err);
            else def.resolve();
        });
        return def.promise();
    };

    _COMMON.mkdirSync = function (path) {
        _fs.mkdirSync(path);
    };
    
    _COMMON.writeFile = function (path,data) {
        var def = $.Deferred();
        _fs.writeFile(path,data,function (err) {
            if(err) def.reject(err);
            else def.resolve();
        });
        return def.promise();
    };

    _COMMON.readFile = function (path) {
        var def = $.Deferred();
        _fs.readFile(path,function (err,data) {
            if(err) def.reject(err);
            else def.resolve(data);
        });
        return def.promise();
    };

    _COMMON.fileStat = function (path) {
        var def = $.Deferred();
        _fs.stat(path,function (err,pro) {
            if(err) def.reject();
            else {
                def.resolve({
                    path:path,
                    size:pro.size,//B 字节
                    isDir:pro.isDirectory(),
                    isFile:pro.isFile(),
                    atime:(new Date(pro.atime)).Format('yyyy-MM-dd hh:mm:ss'),
                    ctime:(new Date(pro.ctime)).Format('yyyy-MM-dd hh:mm:ss'),
                    mtime:(new Date(pro.mtime)).Format('yyyy-MM-dd hh:mm:ss')
                });
            }
        });
        return def.promise();
    };

    _COMMON.removeArr = function (arr,dx) {
        if(!isNaN(dx)||arr[dx]) arr.splice(dx,1);
    };
    _COMMON.renameFile = function (oldPath,newPath) {
        var def = $.Deferred();
        _fs.rename(oldPath,newPath,function (e) {
            if(e) def.reject();
            else  def.resolve();
        });
        return def.promise();
    };
    _COMMON.appendFileSingle = function (data) {
        var def = $.Deferred();
        _fs.readFile(data.file,function (err,chuck) {
            if(err) def.reject(err);
            else {
                _fs.appendFile(data.final,chuck,function (e) {
                    if(e) def.reject(e);
                    else {
                        def.resolve();
                        data.delete && _fs.unlink(data.file);
                    }

                });
            }
        });
        return def.promise();
    };
    _COMMON.crateUuid = function (){
        var s = [];
        var hexDigits = "0123456789abcdef";
        for (var i = 0; i < 36; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }
        s[14] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
        s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01
        s[8] = s[13] = s[18] = s[23] = "-";
        
        return s.join("");
    };
    //
    mkWebsocket();
    _COMMON.trayTipMessage = function(content,title){
        var message = {
            type:"logic",
            to: "all",
            action: "tray_tips",
            from: "hprose",
            data: {
                title: title ? title : " ",
                content: escape(content)
            }
        };
        if(!global.WS){
            mkWebsocket();
            try {
                global.WS.send(JSON.stringify(message));
            }catch (e) {
                //todo:
            }

        }
        else{
            global.WS.send(JSON.stringify(message));
        }
    };
    
    function mkWebsocket() {
        global.WS = new WebSocket("ws://localhost:9980/test");
        global.WS.onopen = function(){
            var sendJson = {
                type: 'conn',
                action: 'register',
                from: "hprose",
                to: 'all',
                id: 1
            };
			try{
				setTimeout(function(){
					global.WS.send(JSON.stringify(sendJson));
				},1000);
				
			}catch(e){
				console.error(e);
				
			}
            

        };
        global.WS.onerror = function(err){
            console.log(err);
			try{
				global.WS.close();
			}catch(e){
				console.error(e);
			}
            
            global.WS = null;
            mkWebsocket();
        };
        global.WS.onmessage = function(data){
            try{
                var msg = JSON.parse(data.data);
                if(msg.action == "exit"){
                    // 用户退出时，不断开websocket连接，以确保下次登录能正常连接
                    // global.WS.close();
                    // global.WS = null;
                }else if(msg.action == 'ap_note_result'){
                    win.noteServer.receiveMessage(msg.data);
                }
            }
            catch(e){
                console.log(e.message);
            }
        };
        // 注册close事件，否则close方法不会生效
        // notice,在onclose事件里，不应该再次发起建立连接请求
        global.WS.onclose = function(){
            console.log("close");
            // global.WS = null;
        };
    }
    //
    function __walkDir(root) {  
        var deferred = _Q.defer();
        var _folders = [];
        var _files = [];
        _fs.readdir(root, function(err, files) {  
            if (err) {  
                deferred.reject(err); 
            } else {  
                _async.map(files,function(file,next){
                    var tmpPath = _path.join(root,file);
                    _fs.stat(tmpPath, function(err1, stats) {  
                        var isFolder = stats.isDirectory();
                        if(!err1){
                            if(isFolder){
                                _folders.push(tmpPath);
                            }
                            else{
                                _files.push(tmpPath);
                            }
                        }
                        next(err1,{
                            path:tmpPath,
                            isFolder:isFolder
                        });   
                    });  
                },function(err2,results){
                    deferred.resolve({
                        'folders':_folders,
                        'files':_files});
                })
            }  
        }); 
        return deferred.promise; 
    };
    function walkDir(root){
        //
        console.log(root);
        //
        var deferred = _Q.defer();
        var _files = [];
        __walkDir(root).then(function(ret){
            _files = _files.concat(ret.files);
            _async.map(ret.folders,function(folder,next){
                walkDir(folder).then(function(ret1){
                    _files = _files.concat(ret1);
                    next(null,ret1);
                },function(err){
                    next(err);
                })
            },function(err){
                if(!err){
                    deferred.resolve(_files);
                }
                else{
                    deferred.reject(err);
                }
            })
        },function(err){
            deferred.reject(err);
        })
        return deferred.promise; 
    };
    //
    _COMMON.zipDir = function(dst,root,parent){
        var deferred = _Q.defer();
        if(typeof parent == "undefined"){
            parent = root;
        }
        var zipFile = new _yazl.ZipFile();
        var path = require("path");
        walkDir(root).then(function(files){
            _async.map(files,function(file,next){
                zipFile.addFile(file, _path.relative(parent,file));
                next(null);
            },function(){
                zipFile.outputStream.pipe(_fs.createWriteStream(dst)).on("close", function() {
                    deferred.resolve();
                });
                zipFile.end();
            })
        },function(err){
            deferred.reject(err);
        })
        return deferred.promise; 
    };

    /**
     * 将有效的 Date、string、number事件转换为标准时间对象
     * return null or Date
     */
    _COMMON.transformTime = function (time) {
        if (time) {
            if (time instanceof Date && !isNaN(time.getTime())) {
                return time;
            }
            if (typeof time === "string") {
                var num_time = Number(time);
                if (isNaN(num_time)) {
                    var obj_time = new Date(time);
                    if (!isNaN(obj_time.getTime())) {
                        return obj_time;
                    }
                } else {
                    return new Date(num_time);
                }
            }
            if (typeof time === "number") {
                return new Date(time);
            }
        }
        return null;
    };
    // 格式化时间
    _COMMON.dateForamt = function (date, fmt) {
        var d = new Date(date);
        var o = {
            "M+": d.getMonth() + 1,                 //月份
            "d+": d.getDate(),                    //日
            "h+": d.getHours(),                   //小时
            "m+": d.getMinutes(),                 //分
            "s+": d.getSeconds(),                 //秒
            "q+": Math.floor((d.getMonth() + 3) / 3), //季度
            "S": d.getMilliseconds()             //毫秒
        };
        if (/(y+)/.test(fmt))
            fmt = fmt.replace(RegExp.$1, (d.getFullYear() + "").substr(4 - RegExp.$1.length));
        for (var k in o)
            if (new RegExp("(" + k + ")").test(fmt))
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        return fmt;
    };
    // url包含中文路径检测和编码
    _COMMON.cn_encodeuri = function (url) {
        if (url && typeof url === "string") {
            if (/[\u4E00-\u9FA5]/i.test(url)) {
                url = encodeURI(url);
            }
        }
        return url;
    };
    //
    Date.prototype.Format = function (fmt) {
        var o = {
            "M+": this.getMonth() + 1,                 //月份
            "d+": this.getDate(),                    //日
            "h+": this.getHours(),                   //小时
            "m+": this.getMinutes(),                 //分
            "s+": this.getSeconds(),                 //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds()             //毫秒
        };
        if (/(y+)/.test(fmt))
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        for (var k in o)
            if (new RegExp("(" + k + ")").test(fmt))
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        return fmt;
    }



})(window);
