/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/3 9:52
 * description : hprose 客户端 支持以下方法：
 * 1.初始化接收推送的消息 ，代码示例
 * window.hproseClientSub('clientA',function (message) {
 *  var _from = message.from;
 *  var _to = message._to;
 *  var _data = message.data;
 *
 *   console.log(message);
 * });
 *其中 clientA 为端的名称，可自行取名，不和其他端重复即可
 * @param _from 消息来自哪里
 * @param_to 消息给谁的
 * @param data 数据体  一般为json
 *
 * 2. hproseSend  发送消息给其他端
 *  @param _from 消息来自哪里
 *   @param _to 消息给谁的 空或all代表全部  单个为字符串 多个端为字符串数组
 *  @param data 数据体  一般为json
 *
 * 3.hproseClient.hproseCall 调用服务端的方法 有回调
 *  @param method 一般为JSON数据 便于分发
 *  @param callback回调函数
 *
 *
 * 4.hproseClient.hproseNoti 通知hprose服务端消息
 *  @param message 一般为JSON数据 便于分发
 */
;
(function (win) {

    win.hproseClientName = null;
    /**
     * **********************************************
     * todo:demo to use emit handle message dispatcher
     */
    // var emitter = require('events').EventEmitter;
    // win.dwnEmitter = new emitter();
    /**
     * ***********************************
     */
    function subscribe(name, receive) {
        win.hproseClientName = name;
        var hprose = require('hprose');
        var client = hprose.Client.create('ws://127.0.0.1:19527');
        client.setOption({
            timeout:0,
            idempotent:true
        });
        client.subscribe('topic', name, tempReceive);
        client.on('error',function (name,error) {
            console.log('%c hprose client error: '+name + error,'color:red');
        });
        var proxy = client.useService(["hproseCall", "hproseNoti","checkNetState"]);
        var send = client.useService(["hproseSend"]);
        win.hproseClient = proxy;
        win.hproseRClient = client;
        win.hproseSend = hproseSend;
        function hproseSend(data) {
            //如果未指定 来源则为本身
            data._from = data._from || hproseClientName;
            data._to = data._to || 'all';
            send.hproseSend(data);
        }

        function tempReceive(obj) {
            //不是自己的消息，则屏蔽
            if (obj._to != 'all' && obj._to != hproseClientName) return;
            receive(obj);
        }

    }
    
    win.hproseClientSub = subscribe;
})(window);

/*-----------how to register and use-------------*/

// window.hproseClientSub('clientA',function (message) {
//     var _from = message.from;
//     var _to = message._to;
//     var _data = message.data;
//     switch (_data.method){
//         case 'download':
//             /**
//              * todo:demo to use emit handle message dispatcher
//              */
//             // if(message.extension.emit) dwnEmitter.emit(message.extension.emit,message);
//             break;
//         default:break;
//     }
// });

/**
 * todo:demo to use emit handle message dispatcher
 * * notice that : before Noti hprose_server download , you should public your function by your emitName
 message = {
     *      method:'download',
     *      data:{
     *          file:'d:/demo/example.ppt',
     *          url:'http://www.demo.com/file/some.ppt',
     *          _from:'clientA', 自己客户端的名字
     *
     *      },
     *      extension:{
     *          emit:'emitName' //为触发的事件定义一个名字
     *      }
     * }
 *

 */
// dwnEmitter.on('emitName',function (message) {
//         //todo:handle your method;
//         console.log(message);
// });
// hproseClient.hproseNoti(message);
//